/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.gl.app.GLAcctAgeUtils;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountAgeCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAcctAgeTreeDao
implements IGLRptDao {
    private static Logger logger = Logger.getLogger((String)GLRptAcctAgeTreeDao.class.getClass().getName());
    protected Context ctx;
    protected GLRptAccountAgeCondition cond;

    public GLRptAcctAgeTreeDao(Context ctx) {
        this.ctx = ctx;
    }

    public void init(EntityViewInfo ev) throws EASBizException, BOSException {
        this.cond = (GLRptAccountAgeCondition)ev.get("GLFixCondition");
        this.cond.setCtx(this.ctx);
    }

    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        selector.add(GLRptField.accountNumber);
        selector.add(new GLRptField("nonLeaf", "INT", null, -1, true));
        String title = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"84_AccountAgeUI", (Locale)this.ctx.getOriginLocale());
        if (this.cond.getRptParams().isAccountShowLongName()) {
            selector.add(new GLRptField("accountName", "av.fdisplayName", "NVARCHAR(500)", title, 150, true));
        } else {
            selector.add(new GLRptField("accountName", "av.fname", "NVARCHAR(500)", title, 150, true));
        }
        return selector;
    }

    private void getAccountSql(StringBuffer merge, List listParam) throws BOSException, EASBizException {
        CompanyOrgUnitInfo _company;
        AccountAgeParam paramAge = new AccountAgeParam();
        CompanyOrgUnitInfo curCompany = _company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        boolean isIncludeUnPosted = this.cond.isIncludeUnPosted();
        boolean isIncludeVerifyVch = this.cond.isIncludeVerifyVch();
        boolean isIncludeInit = this.cond.isIncludeInit();
        boolean isBizCode = this.cond.isBizCode();
        java.util.Date endDate = this.cond.getEndDate();
        String currencyId = this.cond.getCurrencyID();
        Map hmItems = this.cond.getItems();
        boolean isFilterAcctByAcctCussent = false;
        String companyId = "";
        companyId = isIsOnlyUnion ? this.cond.getCompanyIdsStr().replace("(", "").replace(")", "") : this.cond.getSelectedCompanys()[0].getId().toString();
        PeriodInfo currPeriod = null;
        PeriodInfo endPeriod = null;
        String currPeriodID = "";
        String endPeriodID = "";
        String tempTableBal = "";
        int balType = 1;
        String acctTableID = "";
        StringBuffer inAccountNumber = null;
        int verifyMode = -1;
        if (isIsOnlyUnion) {
            isIncludeUnPosted = true;
            isFilterAcctByAcctCussent = !this.cond.isIncludeVerifyVch();
        } else {
            curCompany = GlUtils.getCompanyById(this.ctx, companyId);
            verifyMode = GlUtils.getVerifyMode(this.ctx, companyId);
            if (verifyMode == 2) {
                isIncludeUnPosted = true;
            }
            if (verifyMode != 0 && !isIncludeVerifyVch) {
                isFilterAcctByAcctCussent = true;
            }
        }
        balType = isIncludeUnPosted ? 1 : 5;
        int isEndPeriodInFuture = 0;
        if (!isFilterAcctByAcctCussent && !isIsOnlyUnion) {
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)this.ctx, (java.util.Date)endDate, (java.util.Date)endDate, (CompanyOrgUnitInfo)curCompany);
            if (periodColl.size() <= 0) {
                throw new GLException(GLException.NOPERIODLIST);
            }
            endPeriod = periodColl.get(0);
            endPeriodID = periodColl.get(0).getId().toString();
            currPeriod = GlUtils.getCurrentPeriod(this.ctx, companyId);
            currPeriodID = currPeriod.getId().toString();
            isEndPeriodInFuture = endPeriodID.compareToIgnoreCase(currPeriodID) == 0 ? 0 : (PeriodUtils.PeriodCompare((PeriodInfo)endPeriod, (PeriodInfo)currPeriod) ? 1 : -1);
        }
        GLAcctAgeUtils.setEnterDateType(paramAge);
        ArrayList alAcResult = new ArrayList();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        boolean isAllCurr = false;
        if (currencyId.equals("AllCurrency")) {
            isAllCurr = true;
        }
        boolean isGeneralCy = false;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyId)) {
            isGeneralCy = true;
        }
        StringBuffer from = new StringBuffer();
        String companyFieldName = "";
        String assgrpFieldName = "";
        boolean isDM = SQLUtil.isDM(this.ctx);
        if (isFilterAcctByAcctCussent) {
            from.append(" from t_gl_acctcussent CUSSENT  \r\n");
            companyFieldName = "fcompanyid";
            assgrpFieldName = "fassgrpid";
            from.append(" left outer join t_gl_voucher vch on vch.fid = cussent.fvoucherid  \r\n");
        } else {
            if (isDM && balType == 1) {
                from.append(" from t_gl_assistbalance_1f CUSSENT  \r\n");
            } else if (isDM && balType == 5) {
                from.append(" from t_gl_assistbalance_5f CUSSENT  \r\n");
            } else {
                from.append(" from t_gl_assistbalance CUSSENT  \r\n");
            }
            companyFieldName = "forgunitid";
            assgrpFieldName = "FAssistGrpID";
        }
        if (isIsOnlyUnion) {
            from.append(" inner join (select * from t_bd_accountview t where t.fcompanyid in (").append(companyId).append("))");
            from.append("  account on cussent.faccountid = account.fid  \r\n");
        } else {
            from.append(" inner join t_bd_accountview account on cussent.faccountid = account.fid  ");
            from.append("  and account.fcompanyid = ?  \r\n");
            listParam.add(companyId);
        }
        if (isIsOnlyUnion) {
            from.append(" left outer join (select * from t_bd_accountview t where t.fcompanyid in (").append(companyId).append("))");
            from.append("  paccount on account.fparentid = paccount.fid  \r\n");
        } else {
            from.append(" left outer join t_bd_accountview paccount on account.fparentid = paccount.fid ");
            from.append("  and paccount.fcompanyid = ?  \r\n");
            listParam.add(companyId);
        }
        if (hmItems.size() > 0) {
            from.append(" inner join t_bd_assistanthg hg on cussent.").append(assgrpFieldName).append(" = hg.fid  \r\n");
        }
        StringBuffer innerJoinAsst = new StringBuffer();
        StringBuffer sqlGroupby = new StringBuffer();
        ArrayList<String> alAstNumbers = new ArrayList<String>();
        ArrayList<String> alAstTables = new ArrayList<String>();
        ArrayList<String> alAstFields = new ArrayList<String>();
        Iterator itemkeyit = hmItems.keySet().iterator();
        HashMap[] itemList = new HashMap[hmItems.keySet().size()];
        int k = 0;
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            Integer seq = (Integer)item.get("seq");
            if (seq != null) {
                itemList[seq.intValue()] = item;
            } else {
                itemList[k] = item;
            }
            ++k;
        }
        if (isBizCode) {
            if (hmItems.size() > 0) {
                innerJoinAsst.append(" left join ").append("t_bd_customer").append(" cst").append(" on hg.").append("fcustomerid").append("=").append("cst").append(".fid             \r\n");
                innerJoinAsst.append(" left join T_BD_BizAnaylysisCode bac1 on bac1.fid = cst.FBizAnalysisCodeID \r\n");
                innerJoinAsst.append(" left join ").append("T_BD_Supplier").append(" sup").append(" on hg.").append("FProviderID").append("=").append("sup").append(".fid              \r\n");
                innerJoinAsst.append(" left join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID \r\n");
            }
        } else {
            for (int i = 0; i < itemList.length; ++i) {
                HashMap item = itemList[i];
                String[] numbers = (String[])hmItems.get(item);
                String table = (String)item.get("tablename");
                String field = (String)item.get("fieldname");
                boolean isGeneralActType = item.get("FGLAsstActTypeGrpID") != null && item.get("propname").toString().startsWith("generalAssActType");
                boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
                alAstTables.add(table);
                alAstFields.add(field);
                innerJoinAsst.append(" inner join ").append(table).append(" as ").append("t").append(i).append(" on hg.").append(field).append("=").append("t").append(i).append(".fid  \r\n");
                if (numbers[0] != null) {
                    innerJoinAsst.append(" and ").append("t").append(i);
                    if (isGeneralActType && isUseLongNumber) {
                        innerJoinAsst.append(".flongnumber>=?");
                        alAstNumbers.add(numbers[0].replace('.', '!'));
                    } else {
                        innerJoinAsst.append(".fnumber>=?");
                        alAstNumbers.add(numbers[0]);
                    }
                }
                if (numbers[1] != null) {
                    innerJoinAsst.append(" and ").append("t").append(i);
                    if (isGeneralActType && isUseLongNumber) {
                        innerJoinAsst.append(".flongnumber<=?");
                        alAstNumbers.add(numbers[1].replace('.', '!'));
                    } else {
                        innerJoinAsst.append(".fnumber<=?");
                        alAstNumbers.add(numbers[1]);
                    }
                }
                ++i;
            }
        }
        for (String number : alAstNumbers) {
            listParam.add(number);
        }
        StringBuffer where = new StringBuffer();
        StringBuffer whereCommon = new StringBuffer();
        StringBuffer whereCompany = new StringBuffer();
        StringBuffer wherePeriod = new StringBuffer();
        if (isIsOnlyUnion) {
            whereCompany.append(" \r\n where cussent.").append(companyFieldName).append(" in (").append(companyId).append(")   \r\n");
        } else {
            whereCompany.append(" \r\n where cussent.").append(companyFieldName).append("=?  \r\n");
            listParam.add(companyId);
        }
        whereCommon.append(" and ACCOUNT.fac = 1   \r\n");
        if (isFilterAcctByAcctCussent) {
            whereCommon.append(" and cussent.FUNVERIFIEDAMTFOR<>0 ");
        }
        String accountFrom = this.cond.getAccountCodeStart();
        String accountTo = this.cond.getAccountCodeEnd();
        if (isIsOnlyUnion) {
            inAccountNumber = this.delAccount(accountFrom, accountTo, companyId);
            if (inAccountNumber != null) {
                whereCommon.append(" and ACCOUNT.fnumber in ").append(inAccountNumber).append("  \r\n");
            }
        } else if (!this.cond.getAccountIdSet().isEmpty()) {
            StringBuffer inAccount = new StringBuffer("(").append(this.cond.getAccountIdFilter()).append(")");
            whereCommon.append(" and cussent.faccountid in ").append(inAccount).append("  \r\n");
        }
        if (accountFrom != null && !accountFrom.equals("")) {
            whereCommon.append(" and ACCOUNT.fnumber >= '").append(accountFrom).append("'");
        }
        if (accountTo != null && !accountFrom.equals("")) {
            whereCommon.append(" and ACCOUNT.fnumber <= '").append(accountTo).append("zzzzzz'");
        }
        if (!isGeneralCy && !isAllCurr) {
            whereCommon.append(" and cussent.fcurrencyid=?   \r\n");
            listParam.add(currencyId);
        }
        if (isFilterAcctByAcctCussent) {
            if (!isIncludeInit) {
                wherePeriod.append(" AND cussent.FPeriodID <> '").append("AAAAAAAAAAAAAAAAAAAAAII4jEw=").append("'  \r\n");
            }
        } else if (isDM) {
            wherePeriod.append(" AND pd.FID = '").append(endPeriodID).append("'  \r\n");
        } else {
            wherePeriod.append(" AND cussent.FPeriodID = '").append(endPeriodID).append("'  \r\n");
            wherePeriod.append(" AND cussent.FBalType = ").append(balType).append("  \r\n");
        }
        ArrayList<String> bizParams = new ArrayList<String>();
        if (isBizCode && hmItems.size() > 0) {
            HashMap item = itemList[0];
            String[] numbers = (String[])hmItems.get(item);
            whereCommon.append(" and (");
            whereCommon.append(" (bac1.fid is not null ");
            if (numbers != null && numbers[0] != null) {
                bizParams.add(numbers[0]);
                whereCommon.append(" and ").append("bac1").append(".fnumber>=?  \r\n");
            }
            if (numbers != null && numbers[1] != null) {
                bizParams.add(numbers[1] + "~");
                whereCommon.append(" and ").append("bac1").append(".fnumber<=?  \r\n");
            }
            whereCommon.append(") or (bac.fid is not null ");
            if (numbers != null && numbers[0] != null) {
                bizParams.add(numbers[0]);
                whereCommon.append(" and ").append("bac").append(".fnumber>=?  \r\n");
            }
            if (numbers != null && numbers[1] != null) {
                bizParams.add(numbers[1] + "~");
                whereCommon.append(" and ").append("bac").append(".fnumber<=?  \r\n");
            }
            whereCommon.append("))");
        }
        for (String number : bizParams) {
            listParam.add(number);
        }
        String accountname = GlUtils.isAccountShowLongName(this.ctx, _company.getId().toString()) ? "Flongname_" : "Fname_";
        StringBuffer selectAccount = new StringBuffer();
        selectAccount.append(" distinct account.fid FAccountID,account.fnumber accountNumber,account.").append(accountname).append(loc).append(" accountName,account.FLongNumber longNumber");
        selectAccount.append(" ,account.fisleaf fisleaf,account.flevel flevel,paccount.fNumber pnumber,paccount.flongnumber plongnumber,paccount.flevel plevel ");
        String orderByAcctNumber = " order by account.fnumber  \r\n";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeUtils.checkDbTypeIsOracleDB2(this.ctx);
        try {
            con = this.getConnection(this.ctx);
            if (!isFilterAcctByAcctCussent) {
                if (!isIsOnlyUnion) {
                    if (1 == isEndPeriodInFuture) {
                        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)currPeriod);
                        int[] periodRange = new int[]{nextPeriod.getPeriodYear(), nextPeriod.getPeriodNumber(), endPeriod.getPeriodYear(), endPeriod.getPeriodNumber()};
                        String yearNumberFilter = " and " + SQLUtil.getPeriodCondition("pd.fperiodyear", "pd.fperiodnumber", periodRange) + "  \r\n";
                        whereCommon = whereCompany.append(whereCommon);
                        if (isDM) {
                            innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fnumber = cussent.FPeriod ");
                        } else {
                            innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fid = cussent.FPeriodID ");
                        }
                        tempTableBal = this.createTempTable4FuturePeriodAsstBal(this.ctx, con, isDbTypeOracleDB2, isIsOnlyUnion, tempTableBal, listParam, companyId, currPeriodID, endPeriodID, balType, isEndPeriodInFuture, yearNumberFilter, from, innerJoinAsst, whereCommon, isDM);
                        merge.append("select ").append(selectAccount).append(GLAcctAgeUtils.getResultSql4Acct(tempTableBal));
                    } else {
                        if (isDM) {
                            innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fnumber = cussent.FPeriod ");
                        }
                        where.append(whereCompany).append(whereCommon).append(wherePeriod);
                        merge.append("select ").append(selectAccount).append(from).append(innerJoinAsst).append(where).append(sqlGroupby).append(orderByAcctNumber);
                    }
                } else {
                    String subCompanyID = "";
                    Date subBeginDate = null;
                    Date subEndDate = null;
                    StringBuffer whereCommonSub = new StringBuffer();
                    StringBuffer sql = new StringBuffer();
                    sql.append(" ----\u5404\u4e2a\u516c\u53f8\u7684\u5f53\u524d\u671f\u95f4                                                       \r\n");
                    sql.append(" select ssc.fcompanyid,ssc.fcurrentperiodid,pd.fbegindate,pd.fenddate         \r\n");
                    sql.append(" from t_bd_systemstatus sst                                                   \r\n");
                    sql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fsystemstatusid = sst.fid       \r\n");
                    sql.append(" inner join t_bd_period pd on pd.fid = ssc.fcurrentperiodid                   \r\n");
                    sql.append(" where sst.fname='6'                                                          \r\n");
                    sql.append(" and ssc.fcompanyid in (").append(companyId).append(")                        \r\n");
                    ps = con.prepareStatement(sql.toString());
                    rs = ps.executeQuery();
                    if (isDM) {
                        innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fnumber = cussent.FPeriod ");
                    } else {
                        innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fid = cussent.FPeriodID ");
                    }
                    while (rs.next()) {
                        subCompanyID = rs.getString(1);
                        currPeriodID = rs.getString(2);
                        subBeginDate = rs.getDate(3);
                        subEndDate = rs.getDate(4);
                        PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)this.ctx, (java.util.Date)endDate, (java.util.Date)endDate, (IObjectPK)new ObjectUuidPK(subCompanyID));
                        if (periodColl.size() <= 0) {
                            throw new GLException(GLException.NOPERIODLIST);
                        }
                        endPeriod = periodColl.get(0);
                        endPeriodID = periodColl.get(0).getId().toString();
                        isEndPeriodInFuture = endPeriod.getEndDate().after(subEndDate) ? 1 : (endPeriod.getEndDate().before(subEndDate) ? -1 : 0);
                        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(currPeriodID));
                        int[] periodRange = new int[]{nextPeriod.getPeriodYear(), nextPeriod.getPeriodNumber(), endPeriod.getPeriodYear(), endPeriod.getPeriodNumber()};
                        String yearNumberFilter = " and " + SQLUtil.getPeriodCondition("pd.fperiodyear", "pd.fperiodnumber", periodRange) + "  \r\n";
                        whereCompany.setLength(0);
                        whereCompany.append(" and cussent.").append(companyFieldName).append(" = ?  \r\n");
                        whereCommonSub.setLength(0);
                        whereCommonSub.append(" where 1=1 ");
                        whereCommonSub.append(whereCommon).append(whereCompany);
                        tempTableBal = this.createTempTable4FuturePeriodAsstBal(this.ctx, con, isDbTypeOracleDB2, isIsOnlyUnion, tempTableBal, listParam, subCompanyID, currPeriodID, endPeriodID, balType, isEndPeriodInFuture, yearNumberFilter, from, innerJoinAsst, whereCommonSub, isDM);
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                    merge.append("select ").append(selectAccount).append(GLAcctAgeUtils.getResultSql4Acct(tempTableBal));
                }
            } else {
                wherePeriod.append(" and (vch.FBookedDate <= ? or vch.fid is null)");
                listParam.add(new Timestamp(endDate.getTime()));
                where.append(whereCompany).append(whereCommon).append(wherePeriod);
                merge.append("select ").append(selectAccount).append(from).append(innerJoinAsst).append(where).append(sqlGroupby).append(orderByAcctNumber);
            }
            if (!isFilterAcctByAcctCussent && (1 == isEndPeriodInFuture && !isIsOnlyUnion || isIsOnlyUnion)) {
                listParam.clear();
            }
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, ps, (Connection)con);
        }
    }

    private StringBuffer delAccount(String from, String to, String companyIds) throws BOSException {
        IAccountView ctrl;
        AccountViewCollection col;
        StringBuffer result = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String acctTableId = this.cond.getAccountTableId();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("accountTableId.id", (Object)acctTableId));
        if (from != null && !from.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)from, CompareType.GREATER_EQUALS));
        }
        if (to != null && !to.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(to + "zzzzzz"), CompareType.LESS_EQUALS));
        }
        if ((col = (ctrl = AccountViewFactory.getRemoteInstance()).getAccountViewCollection(view)) != null && col.size() > 0) {
            result = new StringBuffer("(");
            for (int i = 0; i < col.size(); ++i) {
                result.append("'").append(col.get(i).getNumber()).append("',");
            }
            result.deleteCharAt(result.length() - 1);
            result.append(")");
        }
        return result;
    }

    private String createTempTable4FuturePeriodAsstBal(Context ctx, Connection con, boolean isDbTypeOracleDB2, boolean isIsOnlyUnion, String tableName, List listParam, String companyID, String currPeriodID, String endPeriodID, int balType, int isEndPeriodInFuture, String yearNumberFilter, StringBuffer from, StringBuffer innerJoinAsst, StringBuffer whereCommon, boolean isDM) throws EASBizException, BOSException {
        PreparedStatement ps = null;
        Object psUpdate = null;
        Object rs = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        int index = 1;
        boolean indexUpdate = true;
        boolean iCountPsUpdate = false;
        String keyTable = "TMP_GL_AGEASSTBAL";
        try {
            if (StringUtils.isEmpty((String)tableName)) {
                sql.setLength(0);
                sql.append(" create table ").append(keyTable).append("                   \r\n");
                sql.append(" (                                                           \r\n");
                if (!isDM) {
                    sql.append("   FBALTYPE           int not null,                   \r\n");
                }
                sql.append("   FORGUNITID         VARCHAR(44) not null,                 \r\n");
                sql.append("   FPERIODID          VARCHAR(44) not null,                 \r\n");
                sql.append("   FACCOUNTID         VARCHAR(44) not null,                 \r\n");
                sql.append("   FASSISTGRPID       VARCHAR(44) not null,                 \r\n");
                sql.append("   FCURRENCYID        VARCHAR(44) not null,                 \r\n");
                sql.append("                                                             \r\n");
                sql.append("   FBEGINBALANCEFOR   decimal(19,4) default 0 not null,       \r\n");
                sql.append("   FDEBITFOR          decimal(19,4) default 0 not null,       \r\n");
                sql.append("   FCREDITFOR         decimal(19,4) default 0 not null,       \r\n");
                sql.append("   FENDBALANCEFOR     decimal(19,4) default 0 not null        \r\n");
                sql.append(" )                                                           \r\n");
                tableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
                try {
                    sql.setLength(0);
                    sql.append(" create index ").append(tableName).append("i on ").append(tableName).append("              \r\n");
                    if (isDM) {
                        sql.append("   (FORGUNITID, FASSISTGRPID, FACCOUNTID, FCURRENCYID,FPERIODID);  \r\n");
                    } else {
                        sql.append("   (FORGUNITID, FASSISTGRPID, FACCOUNTID, FCURRENCYID, FBALTYPE, FPERIODID);  \r\n");
                    }
                    ps = con.prepareStatement(sql.toString());
                    ps.execute();
                    ps.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (1 != isEndPeriodInFuture) {
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("                                    \r\n");
                sql.append(" (                                                                            \r\n");
                if (!isDM) {
                    sql.append(" FBALTYPE,                                                                    \r\n");
                }
                sql.append(" FORGUNITID,                                                                  \r\n");
                sql.append(" FPERIODID,                                                                   \r\n");
                sql.append(" FACCOUNTID,                                                                  \r\n");
                sql.append(" FAssistGrpID,                                                                \r\n");
                sql.append(" FCURRENCYID,                                                                 \r\n");
                sql.append("                                                                              \r\n");
                sql.append(" fbeginbalancefor,                                                            \r\n");
                sql.append(" fendbalancefor                                                               \r\n");
                sql.append(" )                                                                            \r\n");
                sql.append("                                                                              \r\n");
                if (!isDM) {
                    sql.append("   cussent.FBALTYPE,                                                             \r\n");
                }
                sql.append("   cussent.FORGUNITID,                                                        \r\n");
                sql.append("   ? as FPERIODID, --\u622a\u6b62\u671f\u95f4                                                 \r\n");
                sql.append("   cussent.FACCOUNTID,                                                        \r\n");
                sql.append("   cussent.FAssistGrpID,                                                      \r\n");
                sql.append("   cussent.FCURRENCYID,                                                       \r\n");
                sql.append("                                                                              \r\n");
                sql.append("   cussent.fendbalancefor,                                                    \r\n");
                sql.append("   cussent.fendbalancefor                                                     \r\n");
                sql.append("                                                                              \r\n");
                sql.append(from).append(innerJoinAsst).append(whereCommon);
                if (isDM) {
                    sql.append("      and pd.fid = ?  --\u622a\u6b62\u671f\u95f4\uff0c\u6216\u8005Year+Number                  \r\n");
                } else {
                    sql.append("      and cussent.FBalType=?                                                  \r\n");
                    sql.append("      and cussent.fperiodid = ?  --\u622a\u6b62\u671f\u95f4\uff0c\u6216\u8005Year+Number                  \r\n");
                }
                sql.append("      and cussent.FEndBalancefor<>0.0                                         \r\n");
                sql.append(" ;                                                                            \r\n");
                ps = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)endPeriodID);
                for (String param : listParam) {
                    DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)param);
                }
                if (isIsOnlyUnion) {
                    DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)companyID);
                }
                if (!isDM) {
                    ps.setInt(index++, balType);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)endPeriodID);
                ps.execute();
                ps.close();
            } else {
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("                                    \r\n");
                sql.append(" (                                                                            \r\n");
                if (!isDM) {
                    sql.append(" FBALTYPE,                                                                    \r\n");
                }
                sql.append(" FORGUNITID,                                                                  \r\n");
                sql.append(" FPERIODID,                                                                   \r\n");
                sql.append(" FACCOUNTID,                                                                  \r\n");
                sql.append(" FAssistGrpID,                                                                \r\n");
                sql.append(" FCURRENCYID,                                                                 \r\n");
                sql.append("                                                                              \r\n");
                sql.append(" fbeginbalancefor,                                                            \r\n");
                sql.append(" fendbalancefor                                                               \r\n");
                sql.append(" )                                                                            \r\n");
                sql.append(" SELECT                                                                        \r\n");
                if (!isDM) {
                    sql.append(" cussent.FBALTYPE,                                                     \r\n");
                }
                sql.append("   cussent.FORGUNITID,                                                        \r\n");
                sql.append("   ? as FPERIODID, --\u622a\u6b62\u671f\u95f4                                                 \r\n");
                sql.append("   cussent.FACCOUNTID,                                                        \r\n");
                sql.append("   cussent.FAssistGrpID,                                                      \r\n");
                sql.append("   cussent.FCURRENCYID,                                                       \r\n");
                sql.append("                                                                              \r\n");
                sql.append("   cussent.fendbalancefor,                                                    \r\n");
                sql.append("   cussent.fendbalancefor                                                     \r\n");
                sql.append("                                                                              \r\n");
                sql.append(from).append(innerJoinAsst).append(whereCommon);
                sql.append("      --\u7279\u6b8a\u6761\u4ef6                                                              \r\n");
                if (isDM) {
                    sql.append("      and pd.fid = ?  --\u622a\u6b62\u671f\u95f4\uff0c\u6216\u8005Year+Number                  \r\n");
                } else {
                    sql.append("      and cussent.FBalType=?                                                  \r\n");
                    sql.append("      and cussent.fperiodid = ?  --\u5f53\u524d\u671f\u95f4\uff0c\u6216\u8005Year+Number                  \r\n");
                }
                sql.append(" ;                                                                            \r\n");
                ps = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)endPeriodID);
                for (String param : listParam) {
                    ps.setString(index++, param);
                }
                if (isIsOnlyUnion) {
                    DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)companyID);
                }
                if (!isDM) {
                    ps.setInt(index++, balType);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)currPeriodID);
                ps.execute();
                ps.close();
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("                                    \r\n");
                sql.append(" (                                                                            \r\n");
                if (!isDM) {
                    sql.append(" FBALTYPE,                                                                    \r\n");
                }
                sql.append(" FORGUNITID,                                                                  \r\n");
                sql.append(" FPERIODID,                                                                   \r\n");
                sql.append(" FACCOUNTID,                                                                  \r\n");
                sql.append(" FAssistGrpID,                                                                \r\n");
                sql.append(" FCURRENCYID ,                                                                 \r\n");
                sql.append(" fbeginbalancefor,                                                            \r\n");
                sql.append(" fendbalancefor                                                               \r\n");
                sql.append(" )                                                                            \r\n");
                sql.append("                                                                              \r\n");
                sql.append(" SELECT distinct                                           \r\n");
                if (!isDM) {
                    sql.append("cussent.FBALTYPE,");
                }
                sql.append("        cussent.FORGUNITID,                                                   \r\n");
                sql.append("        ? as FPERIODID, --\u622a\u6b62\u671f\u95f4                                            \r\n");
                sql.append("        cussent.FACCOUNTID,                                                   \r\n");
                sql.append("        cussent.FAssistGrpID,                                                 \r\n");
                sql.append("        cussent.FCURRENCYID,                                                   \r\n");
                sql.append("        cussent.fendbalancefor,                                                    \r\n");
                sql.append("        cussent.fendbalancefor                                                     \r\n");
                sql.append(from).append(innerJoinAsst);
                sql.append("    left outer join ").append(tableName).append(" tmp  on (                        \r\n");
                if (!isDM) {
                    sql.append("      tmp.fbaltype = cussent.fbaltype AND                                 \r\n");
                }
                sql.append("      tmp.forgunitid = cussent.forgunitid AND                                 \r\n");
                sql.append("      tmp.faccountid = cussent.faccountid AND                                 \r\n");
                sql.append("      tmp.FAssistGrpID = cussent.FAssistGrpID AND                             \r\n");
                sql.append("      tmp.fcurrencyid = cussent.fcurrencyid)                                  \r\n");
                sql.append("                                                                              \r\n");
                sql.append(whereCommon);
                sql.append("      --\u7279\u6b8a\u7684\u6761\u4ef6                                                            \r\n");
                sql.append("      ----\u671f\u95f4\u8303\u56f4\uff1a\u5f53\u671f\u671f\u95f4\u7684\u540e\u4e00\u671f~~\u622a\u6b62\u671f\u95f4                                \r\n");
                if (!isDM) {
                    sql.append("      and cussent.FBalType=?                                                  \r\n");
                }
                sql.append(yearNumberFilter).append("                                                     \r\n");
                sql.append("      --\u66f4\u7279\u6b8a\u7684\u6761\u4ef6                                                          \r\n");
                sql.append(" ;                                                                            \r\n");
                ps = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)endPeriodID);
                if (isIsOnlyUnion) {
                    DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)companyID);
                }
                for (String param : listParam) {
                    ps.setString(index++, param);
                }
                if (!isDM) {
                    ps.setInt(index++, balType);
                }
                ps.execute();
                ps.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLAccessException(e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    @Override
    public GLRptTableHeadInfo getTableHeadInfo() throws BOSException, EASBizException {
        GLRptTableHeadInfo headInfo = new GLRptTableHeadInfo();
        GLRptTableHeadInfo.GLRptTableColumnInfo idCol = headInfo.addColumnInfo();
        idCol.setColName("FAccountID");
        idCol.setWidth(-1);
        idCol.setHide(true);
        GLRptTableHeadInfo.GLRptTableColumnInfo numCol = headInfo.addColumnInfo();
        numCol.setColName("accountNumber");
        numCol.setWidth(-1);
        numCol.setHide(true);
        GLRptTableHeadInfo.GLRptTableColumnInfo leafCol = headInfo.addColumnInfo();
        leafCol.setColName("nonLeaf");
        leafCol.setWidth(-1);
        leafCol.setHide(true);
        GLRptTableHeadInfo.GLRptTableColumnInfo nameCol = headInfo.addColumnInfo();
        nameCol.setColName("accountName");
        nameCol.setWidth(150);
        String title = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"84_AccountAgeUI", (Locale)this.ctx.getOriginLocale());
        String[][] titles = new String[][]{{"", "", "", title}};
        headInfo.setHeadTitle(titles);
        return headInfo;
    }

    @Override
    public GLRptRowSet getData(int start, int length) throws BOSException, EASBizException {
        boolean isUnion;
        GLRptRowSet rowSet;
        ArrayList listParam;
        StringBuffer sql;
        block18: {
            sql = new StringBuffer();
            listParam = new ArrayList();
            this.getAccountSql(sql, listParam);
            rowSet = null;
            boolean bl = isUnion = !this.cond.getCompany().isIsBizUnit();
            if (!this.cond.isSumAccount()) break block18;
            StringBuffer tempSql = new StringBuffer();
            String t = sql.toString().replace("from", "FROM");
            if (isUnion) {
                t = t.replace("account.fid FAccountID,", "");
            }
            String select = t.substring(0, t.indexOf("FROM"));
            String from = t.substring(t.indexOf("FROM"));
            tempSql.append(select).append(" into ").append(" temptable_glrptacctage ").append(from);
            SqlParams sqlParam = new SqlParams();
            for (Object object : listParam) {
                sqlParam.addObject(object);
            }
            String tempTable2 = null;
            Connection con = null;
            try {
                con = this.getConnection(this.ctx);
                tempTable2 = DBUtil.executeSelectIntoForTempTable((Context)this.ctx, (String)tempSql.toString(), (SqlParams)sqlParam, (Connection)con).getTempTable();
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Connection)con);
            if (tempTable2 != null) {
                tempSql.setLength(0);
                tempSql.append(" insert into ").append(tempTable2).append(" (fisleaf,flevel,accountnumber, accountname,longNumber)  \r\n");
                tempSql.append(" select distinct 0,plevel,pnumber,'',plongNumber from ").append(tempTable2);
                DbUtil.execute((Context)this.ctx, (String)tempSql.toString());
            }
            sql.setLength(0);
            if (isUnion) {
                sql.append("select distinct fisleaf,flevel,accountnumber, accountname,longNumber,pnumber,plongNumber from ").append(tempTable2).append(" where accountNumber is not null order by  accountnumber asc,fisleaf asc");
            } else {
                sql.append("select distinct fisleaf,flevel,FAccountID,accountnumber, accountname,longNumber,pnumber,plongNumber from ").append(tempTable2).append(" where accountNumber is not null order by  accountnumber asc,fisleaf asc");
            }
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            rowSet = new GLRptRowSet(this.getTableHeadInfo().getColNames(), rs.size());
            try {
                while (rs.next()) {
                    rowSet.insertRow();
                    boolean leaf = rs.getBoolean("fisleaf");
                    String merge = null;
                    merge = leaf ? (String)rs.getObject("accountNumber") + "-" + (String)rs.getObject("accountName") : (String)rs.getObject("accountNumber") + "  -" + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"86_AccountAgeUI", (Locale)this.ctx.getOriginLocale());
                    if (!isUnion) {
                        rowSet.updateObject("FAccountID", rs.getObject("FAccountID"));
                    }
                    rowSet.updateObject("accountNumber", rs.getObject("accountNumber"));
                    rowSet.updateObject("accountName", merge);
                    rowSet.updateObject("nonLeaf", !leaf);
                }
            }
            catch (SQLException e) {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
        }
        String excuteSql = sql.toString();
        if (isUnion) {
            excuteSql = excuteSql.replace("account.fid FAccountID,", "");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)excuteSql, (Object[])listParam.toArray());
        int i = 0;
        rowSet = new GLRptRowSet(this.getTableHeadInfo().getColNames(), rs.size() + i);
        try {
            while (rs.next()) {
                rowSet.insertRow();
                if (!isUnion) {
                    rowSet.updateObject("FAccountID", rs.getObject("FAccountID"));
                }
                rowSet.updateObject("accountNumber", rs.getObject("accountNumber"));
                String merge = (String)rs.getObject("accountNumber") + "-" + (String)rs.getObject("accountName");
                rowSet.updateObject("accountName", merge);
                rowSet.updateObject("isLeaf", rs.getBoolean("fisleaf"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return rowSet;
    }

    @Override
    public String createDataSourceTable(EntityViewInfo ev) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void releaseTempTable() {
    }

    @Override
    public int getViewRowCount() throws BOSException, EASBizException {
        return 1;
    }

    @Override
    public GLRptRowSet getAsynSumData() throws BOSException, EASBizException {
        return null;
    }
}

