/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.IGLRptAsstActTypeBalanceSQL;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAsstActTypeBizCompBalanceSQL
implements IGLRptAsstActTypeBalanceSQL {
    private static final Logger logger = Logger.getLogger(GLRptAsstActTypeBizCompBalanceSQL.class);
    private Map<String, Object> systemParam;
    GLRptAsstActTypeBalanceCondition cond;
    private Context ctx;
    private Collection<String> recycleTables;

    public GLRptAsstActTypeBizCompBalanceSQL(Context ctx, GLRptAsstActTypeBalanceCondition cond) {
        this.cond = cond;
        this.ctx = ctx;
        this.systemParam = cond.systemParam();
        this.recycleTables = new HashSet<String>(5);
    }

    private CompanyOrgUnitInfo getCorrectCompany(Context ctx, String currentCompanyId, int periodYear, int periodNum) {
        CompanyOrgUnitInfo company = null;
        try {
            company = GlUtils.getCompanyById(ctx, currentCompanyId);
            CompanyOrgUnitInfo orgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), orgUnitInfo.getAccountTable().getId().toString(), periodYear, periodNum);
            if (ar != null && ar.getEnabledAcctTable() != null) {
                company.setAccountTable(RptClientUtil.periodCheckForAccountRefContrast(ar, periodYear, periodNum) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return company;
    }

    private Context getCtx() {
        return this.ctx;
    }

    @Override
    public String buildInsertBalanceSQL() throws EASBizException, BOSException {
        String firstTempTableName;
        AsstactTypeEntity asstType;
        int i;
        boolean isBaseCurrencyQuery;
        LinkedList<Object> sp = new LinkedList<Object>();
        boolean isAccountShowLongName = this.cond.isAccountShowLongName();
        boolean includeNoTransPLVoucher = this.cond.isNotIncluePLVoucher();
        String companyID = this.cond.getCompanyId();
        int[] periodRange = new int[]{this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart(), this.cond.getPeriodYearEnd(), this.cond.getPeriodNumberEnd()};
        int[] periodRange1 = new int[]{this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart(), this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd()};
        int yearEnd = this.cond.getPeriodYearEnd();
        int periodEnd = this.cond.getPeriodNumberEnd();
        boolean includeUnPost = this.cond.getOptionPosting();
        boolean isBizCode = this.cond.isBizCode();
        String currencyID = this.cond.getCurrencyID();
        String bizCodeFromNumber = this.cond.getBizCodeNumFrom();
        String bizCodeToNumber = this.cond.getBizCodeNumTo();
        boolean isDCSeparate = this.cond.isOptionDCDispatchAsst();
        boolean noDisplayZero = this.cond.isOptionAmountZero();
        boolean noDisplayBalanceZero = this.cond.isOptionBalanceZero();
        boolean displayAmount = this.cond.isShowQty();
        String muId = this.cond.getMeasureUnitId();
        List rs = this.cond.getAsstActList();
        MeasureUnitInfo standardUnit = null;
        int n = rs.size();
        for (int i2 = 0; i2 < n; ++i2) {
            AsstactTypeEntity at = (AsstactTypeEntity)rs.get(i2);
            if (!at.isQtyAsst() || at.getAsstMeasureUnitGroupId() == null) continue;
            MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
            if (at.getAsstMeasureUnitId() == null) continue;
            measureUnitInfo.setId(BOSUuid.read((String)at.getAsstMeasureUnitId()));
            standardUnit = measureUnitInfo;
        }
        if (standardUnit != null) {
            IMeasureUnit iunit = MeasureUnitFactory.getLocalInstance((Context)this.ctx);
            ObjectUuidPK pk = new ObjectUuidPK(standardUnit.getId());
            standardUnit = iunit.getMeasureUnitInfo((IObjectPK)pk);
        }
        boolean isExchangeStandardUnit = this.cond.isShowByStandardMU();
        boolean ischkOpAsstGroup = this.cond.isFilterByCat();
        boolean showOnlySubAccountview = this.cond.isShowLeafAccount();
        boolean isBalDcSameAsAccount = this.cond.isBalanceDirSamAsAccount();
        Context ctx = this.getCtx();
        boolean isQtyAsst = Boolean.valueOf(this.systemParam.get("G010") + "");
        boolean isAsstActShowLongNumber = Boolean.valueOf(this.systemParam.get("GL_064") + "");
        boolean isShowLongNameFromGeneral = Boolean.valueOf(this.systemParam.get("GL_066") + "");
        boolean isForegnCurr = Boolean.valueOf(this.systemParam.get("GL_008") + "");
        boolean displayUnit = displayAmount && isQtyAsst;
        String loc = this.getLoc(ctx);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        CompanyOrgUnitInfo currentFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)currentFIUnit);
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)currentFIUnit);
        CompanyOrgUnitInfo company = this.getCorrectCompany(ctx, companyID, yearEnd, this.cond.getPeriodNumberEnd());
        Object[] accountView = null;
        Object currAccountFrom = this.cond.getAccountViewStart();
        Object currAccountTo = this.cond.getAccountViewEnd();
        accountView = currAccountFrom instanceof AccountViewInfo ? new Object[]{currAccountFrom} : (Object[])currAccountFrom;
        Object[] accountViewTo = null;
        accountViewTo = currAccountTo instanceof AccountViewInfo ? new Object[]{currAccountTo} : (Object[])currAccountTo;
        StringBuffer fromWhere = new StringBuffer();
        StringBuffer select = new StringBuffer();
        select.append("select ");
        LinkedList<String> selectFields = new LinkedList<String>();
        if (includeNoTransPLVoucher) {
            String[] tempNoTransPL;
            try {
                tempNoTransPL = RptServerUtil.getQueryNOTransPnLBalanceTable(ctx, yearEnd, periodRange[0] * 100 + periodRange[1], periodRange[2] * 100 + periodRange[3], "'" + companyID + "'", false, includeUnPost, displayUnit ? 3 : 2, currencyID, this.getBOSType());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.recycleTables.add(tempNoTransPL[1]);
            fromWhere.append("\n from " + tempNoTransPL[0] + " A ");
        } else {
            String mainTable = this.getMainTable(includeUnPost, displayUnit, this.cond.isShowFor(), this.cond.isShowRpt(), this.cond.isShowLocal());
            this.logDebug("mainTable is " + mainTable);
            fromWhere.append("\n from ").append(mainTable).append(" A ");
        }
        fromWhere.append("\n inner join T_BD_AssistantHG B on A.FAssistGrpID=B.FID ");
        if (isBizCode) {
            fromWhere.append("\n inner join ").append(this.queryBizCodeHgid(ctx, bizCodeFromNumber, bizCodeToNumber)).append(" on T_Hgid.fid = B.fid ");
        }
        if (showOnlySubAccountview) {
            fromWhere.append("\n inner join T_BD_AccountView D on D.Fid=A.Faccountid and D.fcompanyid = A.forgunitid and d.fcompanyid = ? ");
        } else {
            fromWhere.append("\n inner join T_BD_AccountView AV on AV.Fid=A.Faccountid and AV.fcompanyid = A.forgunitid and av.fcompanyid = ? ");
            fromWhere.append("\n inner join T_BD_AccountView D on ").append(" D.Faccounttableid =AV.Faccounttableid and D.fcompanyid =AV.fcompanyid and d.fcompanyid = ? ");
            if (SQLUtil.isSupportCharIndexToLike(this.getCtx())) {
                fromWhere.append(" and AV.FNumber like concat(D.FNumber, '%') ");
            } else {
                fromWhere.append(" and charIndex(D.FNumber, AV.FNumber)=1 ");
            }
        }
        fromWhere.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("D", userId, companyID, ctx));
        if (this.cond.isAllCurrency()) {
            fromWhere.append("\n inner join t_bd_currency CUR ON CUR.fid = A.FCurrencyID ");
        }
        if (displayUnit) {
            fromWhere.append("\n left join T_BD_MeasureUnit mu on A.FMeasureUnitID = mu.fid ");
        }
        String alis = null;
        if (isBizCode) {
            select.append(" T_Hgid.bacid fid0,T_Hgid.bacnumber fnumber0,T_Hgid.bacname fname0, ");
            selectFields.add("FID0 VARCHAR(44)");
            selectFields.add("FNumber0 NVARCHAR(80)");
            selectFields.add("FName0 NVARCHAR(500)");
        } else {
            AsstactTypeEntity asstType2 = null;
            boolean isMultiLevel = false;
            boolean useGroup = false;
            for (int n2 = 0; n2 < rs.size(); ++n2) {
                String permission;
                alis = "T_" + n2;
                asstType2 = (AsstactTypeEntity)rs.get(n2);
                fromWhere.append("\n inner join ").append(asstType2.getTableName()).append(' ').append(alis).append(" on ").append(alis).append(".FID=B.").append(asstType2.getHgField());
                isMultiLevel = asstType2.isMultilevel();
                useGroup = asstType2.getGroupTable() != null;
                boolean isGeneralActType = asstType2.getHgAttribute() != null && asstType2.getHgAttribute().startsWith("generalAssActType");
                boolean isUseLongNumber = asstType2.isUseLongNumber();
                select.append(alis).append(".FID FID").append(n2).append(",");
                selectFields.add("FID" + n2 + " " + "VARCHAR(44)");
                if (isMultiLevel && !useGroup) {
                    if (!(isAsstActShowLongNumber && isGeneralActType || !isGeneralActType && isUseLongNumber)) {
                        select.append(alis).append(".FNumber FNumber").append(n2).append(",");
                    } else {
                        select.append(" replace(").append(alis).append(".FLongNumber,'!','.') FNumber").append(n2).append(",");
                    }
                    select.append(alis).append(".FLongNumber FLongNumber").append(n2).append(",");
                    selectFields.add("FNumber" + n2 + " " + "NVARCHAR(80)");
                    selectFields.add("FLongNumber" + n2 + " " + "NVARCHAR(500)");
                } else if (useGroup) {
                    String groupTable = asstType2.getGroupTable();
                    String asstGroupInfo = asstType2.getAsstGroup();
                    select.append(alis).append(".FNumber FNumber").append(n2).append(",");
                    select.append("\n case when ").append(groupTable).append(n2).append(".FLongNumber is null then ").append(alis).append(".FNumber else ").append(groupTable).append(n2).append(".FLongNumber||'!'||").append(alis).append(".FNumber end FLongNumber").append(n2).append(",");
                    String asstHG = asstType2.getHgAttribute();
                    if (ischkOpAsstGroup && (asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material")) && asstGroupInfo != null && asstGroupInfo.length() > 0 && asstGroupInfo.indexOf(35) >= 0) {
                        String standardTable = groupTable + "Standard";
                        String detail = asstType2.getTableName() + "Group" + (asstHG.equals("material") ? "Detial" : "Detail");
                        fromWhere.append("\n inner join ").append(detail).append(" GD").append(n2).append(" on GD").append(n2).append(".").append(asstHG.equalsIgnoreCase("provider") ? "FSupplierID" : asstType2.getHgField()).append(" = ").append(alis).append(".fid ").append("\r\n inner join ").append(standardTable).append(" GS").append(n2).append(" on GS").append(n2).append(".fid = GD").append(n2).append(".F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupStandardID").append("\r\n inner join ").append(groupTable).append(" ").append(groupTable).append(n2).append(" on ").append(groupTable).append(n2).append(".fid = GD").append(n2).append(".F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupID");
                    } else {
                        fromWhere.append("\n left join ").append(groupTable).append(" ").append(groupTable).append(n2).append(" on ").append(alis).append(".").append(asstType2.getGroupField()).append("=").append(groupTable).append(n2).append(".FID");
                    }
                    select.append(groupTable).append(n2).append(".FID FGPID").append(n2).append(",");
                    selectFields.add("FNumber" + n2 + " " + "NVARCHAR(80)");
                    selectFields.add("FLongNumber" + n2 + " " + "NVARCHAR(500)");
                    selectFields.add("FGPID" + n2 + " " + "VARCHAR(44)");
                } else {
                    select.append(alis).append(".FNumber FNumber").append(n2).append(",");
                    select.append(alis).append(".FNumber FLongNumber").append(n2).append(",");
                    selectFields.add("FNumber" + n2 + " " + "NVARCHAR(80)");
                    selectFields.add("FLongNumber" + n2 + " " + "NVARCHAR(500)");
                }
                String nameField = null;
                nameField = isShowLongNameFromGeneral && isGeneralActType ? ".FDISPLAYName_" + loc : ".FName_" + loc;
                select.append(alis).append(nameField).append(" FName").append(n2).append(",");
                selectFields.add("FName" + n2 + " " + "NVARCHAR(500)");
                if (!asstType2.isEnabledPermissionLimit() || (permission = asstType2.getPermissionItem()) == null || permission.trim().length() <= 0 || !AsstactTypeEntity.takeOffPersonPerm(permission)) continue;
                fromWhere.append("\n").append(RptServerUtil.innerJoinAsstactPermissionSql("B." + asstType2.getHgField(), permission, userId, cuId, ctx));
            }
        }
        select.append(" d.fid FAccountID,d.fnumber FAccountNumber,");
        select.append(isAccountShowLongName ? "d.fdisplayName_" : "d.fname_").append(loc).append(" FAccountName,d.fdc faccountdc,\r\n");
        selectFields.add("FAccountID VARCHAR(44)");
        selectFields.add("FAccountNumber NVARCHAR(80)");
        selectFields.add("FAccountName NVARCHAR(500)");
        selectFields.add("faccountdc INT");
        if (displayUnit && !isExchangeStandardUnit) {
            select.append("\n mu.fid muId, mu.fname_").append(loc).append(" muName ,");
            selectFields.add("muId VARCHAR(44)");
            selectFields.add("muName NVARCHAR(500)");
        } else if (displayUnit && standardUnit != null) {
            select.append("\n '").append(standardUnit.getId().toString()).append("' muId ,'").append(standardUnit.getName()).append("' muName ,");
            selectFields.add("muId VARCHAR(44)");
            selectFields.add("muName NVARCHAR(500)");
        } else if (displayUnit) {
            select.append("\n ' ' muId, ' ' muName ,");
            selectFields.add("muId VARCHAR(44)");
            selectFields.add("muName NVARCHAR(500)");
        }
        if (this.cond.isAllCurrency()) {
            select.append(" A.FCurrencyID, ");
            select.append(" CUR.FName_" + loc + " FCurrencyName, ");
            select.append(" CUR.FPrecision, ");
            selectFields.add("FCurrencyID VARCHAR(44)");
            selectFields.add("FCurrencyName NVARCHAR(500)");
            selectFields.add("FCurrencyPre INT");
        }
        boolean bl = isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        if (isForegnCurr) {
            isBaseCurrencyQuery = true;
        }
        if (displayAmount) {
            if (isBaseCurrencyQuery) {
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
            } else {
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[0]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange[2] + "00");
                sp.add(periodRange[2] + "99");
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
                sp.add(periodRange1[1]);
            }
        } else if (isBaseCurrencyQuery) {
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
        } else {
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[0]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange[2] + "00");
            sp.add(periodRange[2] + "99");
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
            sp.add(periodRange1[1]);
        }
        if (showOnlySubAccountview) {
            sp.add(companyID);
        } else {
            sp.add(companyID);
            sp.add(companyID);
        }
        fromWhere.append("\n where A.FOrgunitID=? ");
        sp.add(companyID);
        if (this.coreUseCurrency(this.cond.isShowFor(), this.cond.isShowRpt(), this.cond.isShowLocal(), this.cond.isAllCurrency())) {
            fromWhere.append("\n and A.FCurrencyID =? ");
            sp.add(currencyID);
        }
        fromWhere.append("\n and a.FPeriod <= ? \n                   and (a.FPeriod >= ? or\n                       a.FPeriod >= ? \n                   )\n                   and a.FPeriod >= ? \n");
        sp.add(periodRange1[1]);
        sp.add(periodRange1[0]);
        sp.add(currPeriod.getNumber());
        sp.add(startPeriod.getNumber());
        String asstAccountID = this.cond.getAsstAccountId();
        if (!isBizCode && asstAccountID != null) {
            if (showOnlySubAccountview) {
                fromWhere.append(" and D.FCAA = ? ");
            } else {
                fromWhere.append(" and AV.FCAA = ? ");
            }
            sp.add(asstAccountID);
        }
        fromWhere.append(" and (1=1 ");
        String accountNumber = null;
        String accountNumberTo = null;
        if (accountView != null && accountView.length >= 1 && accountView[accountView.length - 1] != null && (accountNumber = ((AccountViewInfo)accountView[accountView.length - 1]).getNumber()) != null && !accountNumber.equals("null")) {
            if (showOnlySubAccountview) {
                fromWhere.append(" and D.FNumber >= ? ");
            } else {
                fromWhere.append(" and AV.FNumber >= ? ");
            }
            sp.add(accountNumber);
        }
        if (accountViewTo != null && accountViewTo.length >= 1 && accountViewTo[0] != null && (accountNumberTo = ((AccountViewInfo)accountViewTo[0]).getNumber()) != null && !accountNumberTo.equals("null")) {
            if (showOnlySubAccountview) {
                fromWhere.append(" and D.FNumber < ? ");
            } else {
                fromWhere.append(" and AV.FNumber < ? ");
            }
            sp.add(accountNumberTo + GlUtils.getMaxChar());
        }
        if (accountView != null && accountView.length > 1) {
            for (i = accountView.length - 2; i >= 0; --i) {
                if (accountView[i] == null) continue;
                if (showOnlySubAccountview) {
                    fromWhere.append(" or D.FNumber like ? ");
                } else {
                    fromWhere.append(" or AV.FNumber like ? ");
                }
                sp.add(((AccountViewInfo)accountView[i]).getNumber() + "%");
            }
        }
        if (accountViewTo != null && accountViewTo.length > 1) {
            for (i = accountViewTo.length - 1; i >= 1; --i) {
                if (accountViewTo[i] == null) continue;
                if (showOnlySubAccountview) {
                    fromWhere.append(" or D.FNumber like ? ");
                } else {
                    fromWhere.append(" or AV.FNumber like ? ");
                }
                sp.add(((AccountViewInfo)accountViewTo[i]).getNumber() + "%");
            }
        }
        fromWhere.append(" )");
        if (!showOnlySubAccountview) {
            fromWhere.append(" and D.FLevel >= ? and D.FLevel <= ? ");
            int levelFrom = 1;
            int levelTo = 1;
            levelFrom = this.cond.getAccountLevelStart();
            levelTo = this.cond.getAccountLevelEnd();
            sp.add(levelFrom);
            sp.add(levelTo);
        }
        boolean isMultiLevel = false;
        boolean useGroup = false;
        for (int n3 = 0; n3 < rs.size() && !isBizCode; ++n3) {
            String fGDcsspGroupStandardID;
            String fGDcsspGroupID;
            String detail;
            String standardTable;
            AcctountAsstItemParser.AccountAsstItem accountAsstItem;
            String groupLongNumber;
            String asstGroupInfo;
            String[] numberID;
            String groupTable;
            AsstactTypeEntity asstType3 = (AsstactTypeEntity)rs.get(n3);
            alis = "T_" + n3;
            isMultiLevel = asstType3.isMultilevel();
            useGroup = asstType3.getGroupTable() != null;
            Object asstTypeFrom = asstType3.getFrom();
            Object asstTypeTo = asstType3.getTo();
            if ((!isMultiLevel || useGroup) && useGroup && ischkOpAsstGroup) {
                String asstHG = asstType3.getHgAttribute();
                String asstGroupInfo2 = asstType3.getAsstGroup();
                if ((asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material")) && asstGroupInfo2 != null && asstGroupInfo2.length() > 0 && asstGroupInfo2.indexOf(35) >= 0) {
                    try {
                        AcctountAsstItemParser.AccountAsstItem accountAsstItem2 = AcctountAsstItemParser.parse((String)("||" + asstGroupInfo2 + "#"));
                        AcctountAsstItemParser.Group[] groups = accountAsstItem2.asstItems[0].group;
                        groupTable = asstType3.getGroupTable() + n3;
                        for (int j = 0; j < groups.length; ++j) {
                            fromWhere.append("\n and GS").append(n3).append(".fnumber=? ");
                            AcctountAsstItemParser.Group group = groups[j];
                            sp.add(group.standardNumber);
                            if (group.startNumber != null) {
                                fromWhere.append(" and (").append(groupTable).append(".FLongNumber >= ? or ").append(groupTable).append(".FLongNumber like ?)");
                                sp.add(group.startNumber);
                                sp.add(group.startNumber + "%");
                            }
                            if (group.endNumber == null) continue;
                            fromWhere.append(" and (").append(groupTable).append(".FLongNumber <= ? or ").append(groupTable).append(".FLongNumber like ?)");
                            sp.add(group.endNumber);
                            sp.add(group.endNumber + "%");
                        }
                    }
                    catch (ParseException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
            }
            if (asstTypeFrom != null) {
                numberID = this.getCellObjectNumberID(asstTypeFrom, isMultiLevel, useGroup);
                String actItemFrom = numberID[0];
                String actItemFIDFrom = numberID[1];
                fromWhere.append("\n and ");
                if (isMultiLevel && !useGroup) {
                    fromWhere.append(alis).append(".FLongNumber>=? ");
                    sp.add(actItemFrom);
                } else if (useGroup) {
                    asstGroupInfo = asstType3.getAsstGroup();
                    groupTable = asstType3.getGroupTable() + n3;
                    String asstHG = asstType3.getHgAttribute();
                    groupLongNumber = null;
                    if (ischkOpAsstGroup && this.coreExistAsstGroup(asstType3)) {
                        try {
                            accountAsstItem = AcctountAsstItemParser.parse((String)("||" + asstGroupInfo + "#"));
                            standardTable = asstType3.getGroupTable() + "Standard";
                            detail = asstType3.getTableName() + "Group" + (asstHG.equals("material") ? "Detial" : "Detail");
                            fGDcsspGroupID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupID";
                            fGDcsspGroupStandardID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupStandardID";
                            groupLongNumber = this.getCSSPGroupLongNumber(actItemFIDFrom, standardTable, asstType3.getGroupTable(), detail, accountAsstItem, asstHG.equalsIgnoreCase("provider") ? "FSupplierID" : asstType3.getHgField(), fGDcsspGroupID, fGDcsspGroupStandardID, ctx);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"", (Throwable)e);
                        }
                    } else {
                        groupLongNumber = this.getGroupLongNumber(actItemFIDFrom, asstType3.getTableName(), asstType3.getGroupTable(), asstType3.getGroupField(), ctx);
                    }
                    fromWhere.append("(isNull(").append(groupTable).append(".FLongNumber,'')||").append(alis).append(".FNumber >= ?");
                    fromWhere.append(" or ").append(groupTable).append(".FLongNumber is null and ").append(alis).append(".FNumber >= ? )");
                    sp.add(groupLongNumber + actItemFrom);
                    sp.add(actItemFrom);
                } else {
                    fromWhere.append(alis).append(".FNumber>=?");
                    sp.add(actItemFrom);
                }
            }
            if (asstTypeTo == null) continue;
            numberID = this.getCellObjectNumberID(asstTypeTo, isMultiLevel, useGroup);
            String actItemTo = numberID[0];
            String actItemFIDTo = numberID[1];
            fromWhere.append("\n and ");
            if (isMultiLevel && !useGroup) {
                fromWhere.append(alis).append(".FLongNumber<=?");
                sp.add(actItemTo);
                continue;
            }
            if (useGroup) {
                asstGroupInfo = asstType3.getAsstGroup();
                groupTable = asstType3.getGroupTable() + n3;
                String asstHG = asstType3.getHgAttribute();
                groupLongNumber = null;
                if (ischkOpAsstGroup && (asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material")) && asstGroupInfo != null && asstGroupInfo.length() > 0 && asstGroupInfo.indexOf(35) >= 0) {
                    try {
                        accountAsstItem = AcctountAsstItemParser.parse((String)("||" + asstGroupInfo + "#"));
                        standardTable = asstType3.getGroupTable() + "Standard";
                        detail = asstType3.getTableName() + "Group" + (asstHG.equals("material") ? "Detial" : "Detail");
                        fGDcsspGroupID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupID";
                        fGDcsspGroupStandardID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupStandardID";
                        groupLongNumber = this.getCSSPGroupLongNumber(actItemFIDTo, standardTable, asstType3.getGroupTable(), detail, accountAsstItem, asstHG.equalsIgnoreCase("provider") ? "FSupplierID" : asstType3.getHgField(), fGDcsspGroupID, fGDcsspGroupStandardID, ctx);
                    }
                    catch (ParseException parseException) {}
                } else {
                    groupLongNumber = this.getGroupLongNumber(actItemFIDTo, asstType3.getTableName(), asstType3.getGroupTable(), asstType3.getGroupField(), ctx);
                }
                fromWhere.append("(isNull(").append(groupTable).append(".FLongNumber,'')||").append(alis).append(".FNumber <= ?");
                fromWhere.append(" or ").append(groupTable).append(".FLongNumber is null and ").append(alis).append(".FNumber <= ? )");
                sp.add(groupLongNumber + actItemTo);
                sp.add(actItemTo);
                continue;
            }
            fromWhere.append(alis).append(".FNumber<=?");
            sp.add(actItemTo);
        }
        int yearTo = yearEnd;
        int periodTo = periodEnd;
        AccountTableInfo newAccountTable = null;
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), company.getAccountTable().getId().toString(), yearTo, periodTo);
            if (ar != null) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (int)yearTo, (int)periodTo, (CompanyOrgUnitInfo)company);
                newAccountTable = period != null && RptClientUtil.periodCheckForAccountRefContrast(ar, yearTo, periodTo) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (newAccountTable != null) {
            fromWhere.append(" and D.Faccounttableid=? ");
            sp.add(newAccountTable.getId().toString());
        }
        if (displayUnit && !StringUtils.isEmpty((String)muId) && !"null".equals(muId)) {
            fromWhere.append(" and a.FMeasureUnitID = '");
            fromWhere.append(muId);
            fromWhere.append("' ");
        }
        if (isBaseCurrencyQuery) {
            this.buildLocalSelect(currPeriod, startPeriod, displayAmount, isExchangeStandardUnit, isForegnCurr, select, selectFields, currencyID, isDCSeparate);
        } else {
            this.buildForSelect(currPeriod, startPeriod, displayAmount, isExchangeStandardUnit, select, selectFields, isDCSeparate, yearEnd, periodEnd);
        }
        select.append("\n 0 as FLEVEL,1 as FIsLeaf, ");
        selectFields.add("FLEVEL INT");
        selectFields.add("FIsLeaf INT");
        if (!isBizCode && rs.isEmpty()) {
            throw new BOSException("asstType is empty");
        }
        if (!isBizCode) {
            asstType = (AsstactTypeEntity)rs.get(0);
            isMultiLevel = asstType.isMultilevel();
            boolean bl2 = useGroup = asstType.getGroupTable() != null;
        }
        if (isBizCode) {
            select.append("T_Hgid.bacnumber  as FOrderNumber");
        } else if (isMultiLevel && !useGroup) {
            select.append("T_0.FLongNumber  as FOrderNumber");
        } else if (useGroup) {
            String groupTable = ((AsstactTypeEntity)rs.get(0)).getGroupTable() + 0;
            select.append("isNull(").append(groupTable).append(".FLongNumber,'')||").append("T_0.FNumber  as FOrderNumber");
        } else {
            select.append("T_0.FNumber   as FOrderNumber");
        }
        selectFields.add("FOrderNumber NVARCHAR(500)");
        if (!isBizCode) {
            for (int n4 = 0; n4 < rs.size(); ++n4) {
                alis = "T_" + n4;
                asstType = (AsstactTypeEntity)rs.get(n4);
                String asstHG = asstType.getHgAttribute();
                if (!"1".equals(String.valueOf(asstType.isForCompany())) || asstHG.equals("person") || asstHG.equals("innerAccount") || asstHG.equals("ProductType") || asstHG.equals("CurProject")) continue;
                fromWhere.append(" and ( ").append(alis).append(".fcompanyId='").append(companyID).append("'").append(" or ").append(alis).append(".fcompanyId is null )");
            }
        }
        StringBuilder group = new StringBuilder();
        group.append("\n group by d.fid ,").append(isAccountShowLongName ? "d.fdisplayName_" : "d.fname_").append(loc).append(" ,d.fnumber,d.fdc,");
        if (isBizCode) {
            group.append(" T_Hgid.bacnumber ,T_Hgid.bacid ,T_Hgid.bacname ,");
        } else {
            for (int i3 = 0; i3 < rs.size(); ++i3) {
                AsstactTypeEntity asstType4 = (AsstactTypeEntity)rs.get(i3);
                alis = "T_" + i3;
                isMultiLevel = asstType4.isMultilevel();
                boolean bl3 = useGroup = asstType4.getGroupTable() != null;
                if (isMultiLevel && !useGroup) {
                    group.append(alis).append(".FLongNumber,");
                    group.append(alis).append(".FNumber,");
                } else if (useGroup) {
                    String groupTable = asstType4.getGroupTable() + i3;
                    group.append(groupTable).append(".FID,");
                    group.append(groupTable).append(".FLongNumber,");
                    group.append(alis).append(".FNumber,");
                } else {
                    group.append(alis).append(".FNumber,");
                }
                boolean isGeneralActType = asstType4.getHgAttribute() != null && asstType4.getHgAttribute().startsWith("generalAssActType");
                String nameField = isShowLongNameFromGeneral && isGeneralActType ? ".FDISPLAYName_" + loc : ".FName_" + loc;
                group.append(alis).append(".FID,").append(alis).append(nameField).append(",");
            }
        }
        if (this.cond.isAllCurrency()) {
            group.append(" A.FCurrencyID,");
            group.append(" CUR.FName_" + loc + ",");
            group.append(" CUR.FPrecision,");
        }
        if (displayUnit && !isExchangeStandardUnit) {
            group.append(" mu.fid, mu.fname_").append(loc).append(" ");
        } else {
            group.deleteCharAt(group.length() - 1);
        }
        String sqlGetData = select.toString() + fromWhere.toString() + group.toString();
        if (noDisplayZero) {
            sqlGetData = isBaseCurrencyQuery ? " select * from (" + sqlGetData + ") T where FDebitFor<>0 or FCreditFor<>0" : " select * from (" + sqlGetData + ") T where FDebitfor<>0 or FCreditfor<>0 or FDebitLocal<>0 or FCreditLocal<>0";
        }
        if (noDisplayBalanceZero) {
            sqlGetData = isBaseCurrencyQuery ? " select * from (" + sqlGetData + ") TT where TT.FEndBalanceDebitFor<>0 or TT.FEndBalanceCreditFor<>0  " : " select * from (" + sqlGetData + ") TT where TT.FEndBalanceDebitFor<>0 or TT.FEndBalanceDebitLocal<>0 or TT.FEndBalanceCreditFor<>0 or TT.FEndBalanceCreditLocal<>0 ";
        }
        this.logDebug(" data sql is ", sqlGetData);
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append("create table AsstActTypeBalTable (");
        for (int i4 = 0; i4 < selectFields.size(); ++i4) {
            createTableSql.append((String)selectFields.get(i4));
            createTableSql.append(',');
        }
        createTableSql.deleteCharAt(createTableSql.length() - 1);
        createTableSql.append(")");
        try {
            firstTempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("create tempTable error! for " + createTableSql, (Throwable)e);
        }
        DbUtil.execute(ctx, "insert into " + firstTempTableName + " " + sqlGetData + "", sp.toArray());
        if (isDCSeparate) {
            this.buildUpdateDCSQL(firstTempTableName);
        }
        this.execInsertAsstItemMulitLevelAndGroupSQL(firstTempTableName);
        String reGroupSQL = this.execReGroupSQL(firstTempTableName);
        if (StringUtils.isEmpty((String)reGroupSQL)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            sql.append(" dataTable.* ");
            sql.append(" from ").append(firstTempTableName).append(" dataTable ");
            for (int i5 = 0; i5 < rs.size(); ++i5) {
                AsstactTypeEntity asstType5 = (AsstactTypeEntity)rs.get(i5);
                isMultiLevel = asstType5.isMultilevel();
                if (!isMultiLevel || !CollectEnum.UP.equals((Object)asstType5.getCollect())) continue;
                sql.append(" where FLevel = " + asstType5.getSelectedLevel() + " ");
                break;
            }
            reGroupSQL = sql.toString();
        }
        return reGroupSQL;
    }

    private boolean coreExistAsstGroup(AsstactTypeEntity asstType) {
        String asstGroupInfo = asstType.getAsstGroup();
        String asstHG = asstType.getHgAttribute();
        return (asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material")) && asstGroupInfo != null && asstGroupInfo.length() > 0 && asstGroupInfo.indexOf(35) >= 0;
    }

    private boolean coreUseCurrency(boolean showFor, boolean showRpt, boolean showLocal, boolean allCurrency) {
        if (!showFor) {
            if (showRpt && showLocal) {
                return !this.cond.isAllCurrency();
            }
            return false;
        }
        return !allCurrency;
    }

    private void logDebug(Object s1, Object s2) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("" + s1 + s2));
        }
    }

    private void logDebug(Object s) {
        if (logger.isDebugEnabled()) {
            logger.debug(s);
        }
    }

    private String buildUpdateDCSQL(String dataSourceTableName) {
        boolean isBaseCurrencyQuery;
        boolean isDCSeparate = this.cond.isOptionDCDispatchAsst();
        String currencyID = this.cond.getCurrencyID();
        CompanyOrgUnitInfo company = this.cond.getCompany();
        boolean bl = isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        if (isDCSeparate) {
            StringBuffer updatesql = new StringBuffer();
            if (isBaseCurrencyQuery) {
                updatesql.append(" update ").append(dataSourceTableName).append(" set FBeginBalanceDebitFor=case when FBeginBalanceDebitFor - FBeginBalanceCreditFor > 0 then FBeginBalanceDebitFor - FBeginBalanceCreditFor else 0 end ,").append(" FBeginBalanceCreditFor = case when FBeginBalanceDebitFor - FBeginBalanceCreditFor < 0 then  FBeginBalanceCreditFor - FBeginBalanceDebitFor  else 0 end ,").append(" FEndBalanceDebitFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor > 0 then  FEndBalanceDebitFor  - FEndBalanceCreditFor else 0 end,").append(" FEndBalanceCreditFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor < 0 then  FEndBalanceCreditFor-FEndBalanceDebitFor   else 0 end ");
                updatesql.append("where (FBeginBalanceDebitFor<> 0 and FBeginBalanceCreditFor<> 0) or (FEndBalanceDebitFor<>0 and FEndBalanceCreditFor<>0)");
            } else {
                updatesql.append(" update ").append(dataSourceTableName).append(" set FBeginBalanceDebitFor=case when FBeginBalanceDebitFor - FBeginBalanceCreditFor > 0 then FBeginBalanceDebitFor - FBeginBalanceCreditFor else 0 end ,").append(" FBeginBalanceCreditFor = case when FBeginBalanceDebitFor - FBeginBalanceCreditFor < 0 then  FBeginBalanceCreditFor - FBeginBalanceDebitFor  else 0 end ,").append(" FEndBalanceDebitFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor > 0 then  FEndBalanceDebitFor  - FEndBalanceCreditFor else 0 end,").append(" FEndBalanceCreditFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor < 0 then  FEndBalanceCreditFor-FEndBalanceDebitFor   else 0 end, ").append(" FBeginBalanceDebitLocal=case when FBeginBalanceDebitLocal - FBeginBalanceCreditLocal > 0 then FBeginBalanceDebitLocal - FBeginBalanceCreditLocal else 0 end ,").append(" FBeginBalanceCreditLocal = case when FBeginBalanceDebitLocal - FBeginBalanceCreditLocal < 0 then  FBeginBalanceCreditLocal - FBeginBalanceDebitLocal  else 0 end ,").append(" FEndBalanceDebitLocal  = case when FEndBalanceDebitLocal  - FEndBalanceCreditLocal > 0 then  FEndBalanceDebitLocal  - FEndBalanceCreditLocal else 0 end,").append(" FEndBalanceCreditLocal  = case when FEndBalanceDebitLocal  - FEndBalanceCreditLocal < 0 then  FEndBalanceCreditLocal-FEndBalanceDebitLocal   else 0 end ");
                updatesql.append("where (FBeginBalanceDebitFor<> 0 and FBeginBalanceCreditFor<> 0) or (FEndBalanceDebitFor<>0 and FEndBalanceCreditFor<>0) or (FBeginBalanceDebitLocal<> 0 and FBeginBalanceCreditLocal<> 0) or (FEndBalanceDebitLocal<>0 and FEndBalanceCreditLocal<>0)");
            }
            try {
                DbUtil.execute(this.ctx, updatesql.toString());
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
            return updatesql.toString();
        }
        return "";
    }

    @Override
    public void buildInsertCurrencySumSQL(String dataTable) throws EASBizException, BOSException {
        boolean isBizCode = this.cond.isBizCode();
        if (isBizCode) {
            return;
        }
        List rs = this.cond.getAsstActList();
        if (rs.isEmpty()) {
            return;
        }
        String currencyID = this.cond.getCurrencyID();
        boolean displayAmount = this.cond.isShowQty();
        boolean showOnlySubAccountview = this.cond.isShowLeafAccount();
        Context ctx = this.getCtx();
        boolean isQtyAsst = Boolean.valueOf(this.systemParam.get("G010") + "");
        boolean displayUnit = displayAmount && isQtyAsst;
        CompanyOrgUnitInfo company = this.cond.getCompany();
        boolean isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        StringBuffer qqSumAss = new StringBuffer();
        StringBuilder group = new StringBuilder("\n group by ");
        StringBuilder selectFields = new StringBuilder();
        if (isBizCode) {
            StringBuffer ff = new StringBuffer().append("FNumber0").append(',').append("FID0").append(',').append("FName0").append(',');
            selectFields.append("FID0").append(',').append("FNumber0").append(',').append("FName0").append(',');
            qqSumAss.append(ff);
            group.append(ff);
        } else {
            for (int n = 0; n < rs.size(); ++n) {
                StringBuffer ff = new StringBuffer();
                ff.append("FID").append(n).append(',').append("FNumber").append(n).append(',').append("FLongNumber").append(n).append(',');
                if (((AsstactTypeEntity)rs.get(n)).getGroupTable() != null) {
                    ff.append("FGPID").append(n).append(',');
                }
                ff.append("FName").append(n).append(',');
                selectFields.append(ff);
                qqSumAss.append(ff);
                group.append(ff);
            }
        }
        qqSumAss.append(" t.FAccountID,t.FAccountNumber,t.FAccountName,t.FAccountDC,");
        selectFields.append("FAccountID,FAccountNumber,FAccountName,FAccountDC,");
        group.append("t.FAccountID,t.FAccountNumber,t.FAccountName,t.FAccountDC,");
        if (displayUnit) {
            qqSumAss.append(" muId,muName, ");
            selectFields.append(" muId,muName,");
        }
        if (this.cond.isAllCurrency()) {
            qqSumAss.append(" '' FCurrencyId,").append("'").append(GLResUtil.getRes("subtotal", ctx)).append("' FCurrencyName,").append(this.cond.getCompany().getBaseCurrency().getPrecision()).append(" FCurrencyPre, ").append(" 1 FIsCurrencyTotal,");
            selectFields.append(" FCurrencyId,FCurrencyName,FCurrencyPre,FIsCurrencyTotal,");
        }
        StringBuilder amount = new StringBuilder();
        if (displayAmount) {
            qqSumAss.append(" sum(FBeginDebitQty) FBeginDebitQty, \t\t\t\t\t\n");
            qqSumAss.append(" 0.0 FBeginBalanceDebitFor, \t\t\t                \n");
            qqSumAss.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \n");
            qqSumAss.append(" sum(FBeginCreditQty) FBeginCreditQty, \t\t\t\t\n");
            qqSumAss.append(" 0.0 FBeginBalanceCreditFor, \t\t                    \n");
            qqSumAss.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal,\n");
            amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t\t\t\t\n");
            amount.append(" sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
            amount.append(" 0.0 FDebitLocal, \t\t\t\t\t\t\t            \n");
            amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t\t\t\t\n");
            amount.append(" 0.0 FCreditFor,\t\t\t\t\t\t\t\t            \n");
            amount.append(" sum(FCreditLocal) FCreditLocal,\t\t\t\t\t\t\t\n");
            amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t\t\t\t\n");
            amount.append(" 0.0 FYearDebitFor,\t\t\t\t\t\t                \n");
            amount.append(" sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
            amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t\t\t\t\n");
            amount.append(" 0.0 FYearCreditFor, \t\t\t\t\t                \n");
            amount.append(" sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\n");
            amount.append(" sum(FEndDebitQty) FEndDebitQty, \t\t\t\t\t\t\t\t\t\n");
            selectFields.append("FBeginDebitQty,FBeginBalanceDebitFor,FBeginBalanceDebitLocal,FBeginCreditQty,FBeginBalanceCreditFor,FBeginBalanceCreditLocal,FDebitQty,FDebitFor,FDebitLocal,FCreditQty,FCreditFor,FCreditLocal,FYearDebitQty,FYearDebitFor,FYearDebitLocal,FYearCreditQty,FYearCreditFor,FYearCreditLocal,FEndDebitQty,");
        } else {
            qqSumAss.append(" 0.0 FBeginBalanceDebitFor, \t\t\t                \n");
            qqSumAss.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \n");
            qqSumAss.append(" 0.0 FBeginBalanceCreditFor, \t\t                    \n");
            qqSumAss.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal,\n");
            amount.append("0.0 FDebitFor, \t\t\t\t\t\t\t\t            \n");
            amount.append("sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
            amount.append("0.0 FCreditFor, \t\t\t\t\t\t\t\t            \n");
            amount.append("sum(FCreditLocal) FCreditLocal, \t\t\t\t\t\t\t\n");
            amount.append("0.0 FYearDebitFor,\t\t\t\t\t\t                \n");
            amount.append("sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
            amount.append("0.0 FYearCreditFor, \t\t\t\t\t\t                \n");
            amount.append("sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\t\n");
            selectFields.append("FBeginBalanceDebitFor,FBeginBalanceDebitLocal,FBeginBalanceCreditFor,FBeginBalanceCreditLocal,FDebitFor,FDebitLocal,FCreditFor,FCreditLocal,FYearDebitFor,FYearDebitLocal,FYearCreditFor,FYearCreditLocal,");
        }
        qqSumAss.append((CharSequence)amount);
        qqSumAss.append(" 0.0 FEndBalanceDebitFor, \t\t\t\n");
        qqSumAss.append(" sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal, \t\t\n");
        if (displayAmount) {
            qqSumAss.append(" sum(FEndCreditQty) FEndCreditQty, \t\t\n");
        }
        qqSumAss.append(" 0.0 FEndBalanceCreditFor, \t\t\t\n");
        qqSumAss.append(" sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal, \t\t\n");
        selectFields.append("FEndBalanceDebitFor,FEndBalanceDebitLocal,");
        if (displayAmount) {
            selectFields.append("FEndCreditQty,");
        }
        selectFields.append("FEndBalanceCreditFor,FEndBalanceCreditLocal,");
        qqSumAss.append("t.FLevel,t.FIsLeaf,t.FOrderNumber,0");
        selectFields.append("FLevel,FIsLeaf,FOrderNumber,isTotal ");
        if (this.cond.isShowAsstItemTotal()) {
            qqSumAss.append(",0");
            selectFields.append(",actTypeIsTotal ");
        }
        group.append("t.FLevel,t.FIsLeaf,FOrderNumber");
        if (displayUnit) {
            group.append(" ,muId, muName ");
        }
        qqSumAss.append("  from ").append(dataTable).append(" t ");
        if (!showOnlySubAccountview) {
            qqSumAss.append(" inner join t_bd_accountview av on av.fid = t.faccountid ");
        }
        qqSumAss.append("\r\n where t.isTotal = 0 ");
        if (!showOnlySubAccountview) {
            int levelFrom = this.cond.getAccountLevelStart();
            qqSumAss.append(" and av.flevel = ").append(levelFrom);
        }
        if (this.cond.isShowAsstItemTotal()) {
            qqSumAss.append(" and t.actTypeIsTotal = 0 ");
        }
        qqSumAss.append((CharSequence)group);
        qqSumAss = new StringBuffer().append("insert into " + dataTable + "(" + selectFields + ") select ").append(qqSumAss);
        if (this.cond.isAllCurrency()) {
            DbUtil.execute(ctx, qqSumAss.toString());
        }
    }

    private BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"BD2D65BD");
    }

    private StringBuffer queryBizCodeHgid(Context ctx, String bizCodeFromNumber, String bizCodeToNumber) throws BOSException {
        StringBuffer queryBizCodeHgid = new StringBuffer();
        String loc = this.getLoc(ctx);
        queryBizCodeHgid.append("(select distinct * from (select hg.fid fid,bac.fid bacid ,bac.fnumber bacnumber ,bac.fname_").append(loc).append(" bacname from t_bd_assistanthg hg inner join t_bd_customer cst on hg.fcustomerid = cst.fid inner join T_BD_BizAnaylysisCode bac on bac.fid = cst.FBizAnalysisCodeID ");
        if (bizCodeFromNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber >='").append(bizCodeFromNumber).append("' ");
        }
        if (bizCodeToNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber <='").append(bizCodeToNumber).append("z' ");
        }
        queryBizCodeHgid.append("\r\n union all ");
        queryBizCodeHgid.append("select hg1.fid fid,bac.fid bacid,bac.fnumber bacnumber ,bac.fname_").append(loc).append(" bacname  from t_bd_assistanthg hg1 inner join T_BD_Supplier sup on hg1.FProviderID = sup.fid inner join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID ");
        if (bizCodeFromNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber >='").append(bizCodeFromNumber).append("' ");
        }
        if (bizCodeToNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber <='").append(bizCodeToNumber).append("~' ");
        }
        queryBizCodeHgid.append("\r\n) t_hgin ) T_Hgid ");
        return queryBizCodeHgid;
    }

    private String[] getCellObjectNumberID(Object actObject, boolean isMultiLevel, boolean useGroup) {
        String[] re = new String[2];
        if (actObject instanceof DataBaseInfo) {
            re[0] = isMultiLevel && !useGroup ? (((DataBaseInfo)actObject).get("longnumber") != null ? ((DataBaseInfo)actObject).get("longnumber").toString() : null) : (((DataBaseInfo)actObject).get("number") != null ? ((DataBaseInfo)actObject).get("number").toString() : null);
            re[1] = ((DataBaseInfo)actObject).getId().toString();
        } else {
            re[0] = isMultiLevel && !useGroup ? (String)((Object[])((LabelValueBean)actObject).getProperty())[5] : ((LabelValueBean)actObject).getValue();
            re[1] = (String)((Object[])((LabelValueBean)actObject).getProperty())[4];
        }
        return re;
    }

    private String getLoc(Context ctx) {
        return ctx.getLocale().toString();
    }

    private String getGroupLongNumber(String fid, String actTableName, String groupTableName, String groupMappingFieldName, Context ctx) throws BOSException, EASBizException {
        String sql = "select B.FLongNumber from " + actTableName + " A inner join " + groupTableName + " B on A." + groupMappingFieldName + "=B.FID where A.FID=?";
        IRowSet rst = DbUtil.executeQuery(ctx, sql, new Object[]{fid});
        try {
            if (rst.next()) {
                return rst.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return "";
    }

    private String getCSSPGroupLongNumber(String fid, String stand, String groupTableName, String detail, AcctountAsstItemParser.AccountAsstItem accountAsstItem, String mappingfieldname, String fGDcsspGroupID, String fGDcsspGroupStandardID, Context ctx) throws BOSException, EASBizException {
        AcctountAsstItemParser.Group[] groups = accountAsstItem.asstItems[0].group;
        String sql = "select G.FLongNumber from " + detail + " GD inner join " + stand + " GS on GS.fid = GD." + fGDcsspGroupStandardID + " inner join " + groupTableName + " G on G.fid = GD." + fGDcsspGroupID + " where GD." + mappingfieldname + "=?";
        int i = 1;
        SqlParams sqlpa = new SqlParams().setString(i++, fid);
        for (int j = 0; j < groups.length; ++j) {
            AcctountAsstItemParser.Group group = groups[j];
            sqlpa.setString(i++, group.standardNumber);
            sql = sql + " and GS.fnumber = ? -- \n";
            if (group.startNumber != null) {
                sqlpa.setString(i++, group.startNumber).setString(i++, group.startNumber);
                sql = sql + "and (G.FLongNumber >= ? or  G.FLongNumber like ?) ";
            }
            if (group.endNumber == null) continue;
            sqlpa.setString(i++, group.endNumber).setString(i++, group.endNumber);
            sql = sql + "and (G.FLongNumber <= ? or  G.FLongNumber like ?) ";
        }
        IRowSet rst = DbUtil.executeQuery(ctx, sql, sqlpa.getParams());
        try {
            if (rst.next()) {
                return rst.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return "";
    }

    private String coreBalFieldSQLPart(int fieldKey, String fieldSuffix, boolean isBalDcSameAsAccount, boolean isDCSeparate, boolean isExchangeStandardUnit, int startPeriodNumber, int currPeriodNumber) {
        switch (fieldKey) {
            case 1: {
                String fieldSQL = isBalDcSameAsAccount || !isDCSeparate ? "\n sum(                case when D.FDC = 1 then \n                   case when ? < " + startPeriodNumber + " and                        a.fperiod =                        " + startPeriodNumber + " then                     A.FBeginQty                    when ? >= " + startPeriodNumber + " and                         ? <= " + currPeriodNumber + " and                         a.fperiod = ? then                     A.FBeginQty                    when ? > " + currPeriodNumber + " and                         a.fperiod = " + currPeriodNumber + " then                     A.FEndQty                    when ? > " + currPeriodNumber + " and                         a.fperiod > " + currPeriodNumber + " and                         a.fperiod < ? then                     a.fdebitQty - a.fcreditQty                    else                     0                  end                else                   0              end " : "\n sum(                    case when ? < " + startPeriodNumber + " and                        a.fperiod =                        " + startPeriodNumber + " then                        case when A.FBeginQty > 0 then                            A.FBeginQty                         else 0 end                    when ? >= " + startPeriodNumber + " and                         ? <= " + currPeriodNumber + " and                         a.fperiod = ? then                        case when A.FBeginQty > 0 then                            A.FBeginQty                         else 0 end                    when ? > " + currPeriodNumber + " and                         a.fperiod = " + currPeriodNumber + " then                        case when A.FEndQty > 0 then                            A.FEndQty                         else 0 end                    when ? > " + currPeriodNumber + " and                         a.fperiod > " + currPeriodNumber + " and                         a.fperiod < ? then                        case when a.fdebitQty - a.fcreditQty > 0 then                            a.fdebitQty - a.fcreditQty                         else 0 end                    else                     0                  end ";
                fieldSQL = isExchangeStandardUnit ? fieldSQL + " * mu.fcoefficient" : fieldSQL + " ";
                fieldSQL = fieldSQL + " ) FBeginDebitQty, ";
                return fieldSQL;
            }
            case 3: {
                if (isBalDcSameAsAccount || !isDCSeparate) {
                    return "\n sum(case              when D.FDC = 1 then                                  case when ? < " + startPeriodNumber + " and                        a.fperiod =                        " + startPeriodNumber + " then                     A.FBeginBalance" + fieldSuffix + "                    when ? >= " + startPeriodNumber + " and                         ? <= " + currPeriodNumber + " and                         a.fperiod = ? then                     A.FBeginBalance" + fieldSuffix + "                    when ? > " + currPeriodNumber + " and                         a.fperiod = " + currPeriodNumber + " then                     A.fendbalance" + fieldSuffix + "                    when ? > " + currPeriodNumber + " and                         a.fperiod > " + currPeriodNumber + " and                         a.fperiod < ? then                     a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + "                    else                     0                  end              else               0            end) FBeginBalanceDebit" + fieldSuffix + ",";
                }
                return "\n sum(                                                                     case when ? < " + startPeriodNumber + " and                                 a.fperiod =                                 " + startPeriodNumber + " then                               case                                when A.FBeginBalance" + fieldSuffix + " > 0 then                                 A.FBeginBalance" + fieldSuffix + "                                else                                 0                              end                            when ? >= " + startPeriodNumber + " and                                 ? <= " + currPeriodNumber + " and                                 a.fperiod = ? then                             case                                when A.FBeginBalance" + fieldSuffix + " > 0 then                                 A.FBeginBalance" + fieldSuffix + "                                else                                 0                              end                            when ? > " + currPeriodNumber + " and                                 a.fperiod = " + currPeriodNumber + " then                                 case                                  when A.fendbalance" + fieldSuffix + " > 0 then                                   A.fendbalance" + fieldSuffix + "                                  else                                   0                                end                            when ? > " + currPeriodNumber + " and                                 a.fperiod > " + currPeriodNumber + " and                                 a.fperiod < ? then                                                            case                                    when a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + " > 0 then                                        a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + "                                   else                                        0                                 end                                 else                             0                          end                            ) FBeginBalanceDebit" + fieldSuffix + ",";
            }
            case 2: {
                String fieldSQL = isBalDcSameAsAccount || !isDCSeparate ? "\n sum(                case when D.FDC = -1 then \n                   case when ? < " + startPeriodNumber + " and                        a.fperiod =                        " + startPeriodNumber + " then                     -1 * A.FBeginQty                    when ? >= " + startPeriodNumber + " and                         ? <= " + currPeriodNumber + " and                         a.fperiod = ? then                     -1 * A.FBeginQty                    when ? > " + currPeriodNumber + " and                         a.fperiod = " + currPeriodNumber + " then                     -1 * A.FEndQty                    when ? > " + currPeriodNumber + " and                         a.fperiod > " + currPeriodNumber + " and                         a.fperiod < ? then                      a.fcreditQty - a.fdebitQty                   else                     0                  end                else                   0              end " : "\n sum(                    case when ? < " + startPeriodNumber + " and                        a.fperiod =                        " + startPeriodNumber + " then                        case when A.FBeginQty < 0 then                            A.FBeginQty                         else 0 end                    when ? >= " + startPeriodNumber + " and                         ? <= " + currPeriodNumber + " and                         a.fperiod = ? then                        case when A.FBeginQty < 0 then                            A.FBeginQty                         else 0 end                    when ? > " + currPeriodNumber + " and                         a.fperiod = " + currPeriodNumber + " then                        case when A.FEndQty < 0 then                            A.FEndQty                         else 0 end                    when ? > " + currPeriodNumber + " and                         a.fperiod > " + currPeriodNumber + " and                         a.fperiod < ? then                        case when  a.fcreditQty - a.fdebitQty > 0 then                            a.fcreditQty - a.fdebitQty                         else 0 end                    else                     0                  end ";
                fieldSQL = isExchangeStandardUnit ? fieldSQL + " * mu.fcoefficient" : fieldSQL + " ";
                fieldSQL = fieldSQL + " ) FBeginCreditQty, ";
                return fieldSQL;
            }
            case 4: {
                if (isBalDcSameAsAccount || !isDCSeparate) {
                    return "\n sum(case              when D.FDC = -1 then                  case when ? < " + startPeriodNumber + " and                       a.fperiod =                       " + startPeriodNumber + " then                   A.FBeginBalance" + fieldSuffix + " * D.FDC                  when ? >= " + startPeriodNumber + " and                       ? <= " + currPeriodNumber + " and                       a.fperiod = ? then                   A.FBeginBalance" + fieldSuffix + " * D.FDC                  when ? > " + currPeriodNumber + " and                       a.fperiod = " + currPeriodNumber + " then                   A.fendbalance" + fieldSuffix + " * D.FDC                  when ? > " + currPeriodNumber + " and                       a.fperiod > " + currPeriodNumber + " and                       a.fperiod < ? then                    a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + "                  else                   0                end              else               0            end) FBeginBalanceCredit" + fieldSuffix + ",";
                }
                return "\n sum(                                                                     case when ? < " + startPeriodNumber + " and                                 a.fperiod =                                 " + startPeriodNumber + " then                               case                                when A.FBeginBalance" + fieldSuffix + " < 0 then                                 -1 * A.FBeginBalance" + fieldSuffix + "                                else                                 0                              end                            when ? >= " + startPeriodNumber + " and                                 ? <= " + currPeriodNumber + " and                                 a.fperiod = ? then                             case                                when A.FBeginBalance" + fieldSuffix + " < 0 then                                 -1 * A.FBeginBalance" + fieldSuffix + "                                else                                 0                              end                            when ? > " + currPeriodNumber + " and                                 a.fperiod = " + currPeriodNumber + " then                                 case                                  when A.fendbalance" + fieldSuffix + " < 0 then                                   -1 * A.fendbalance" + fieldSuffix + "                                  else                                   0                                end                            when ? > " + currPeriodNumber + " and                                 a.fperiod > " + currPeriodNumber + " and                                 a.fperiod < ? then                                                            case                                   when a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + " < 0 then                                        a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + "                                   else                                        0                                 end                                 else                             0                          end                            ) FBeginBalanceCredit" + fieldSuffix + ",";
            }
            case 5: {
                String fieldSQL = "\n sum(\n                           case\n                             when a.fperiod >= ? and\n                                  a.fperiod <= ? and\n                                  a.fperiod >=\n                                  " + startPeriodNumber + " then\n                              a.FDebitQty\n                             else\n                              0\n                           end  ";
                if (isExchangeStandardUnit) {
                    fieldSQL = fieldSQL + " * mu.fcoefficient ";
                }
                fieldSQL = fieldSQL + "                           ) FDebitQty, ";
                return fieldSQL;
            }
            case 6: {
                return "\n sum(\n                           case\n                             when a.fperiod >= ? and\n                                  a.fperiod <= ? and\n                                  a.fperiod >=\n                                  " + startPeriodNumber + " then\n                              a.FDebit" + fieldSuffix + "\n                             else\n                              0\n                           end  ) FDebit" + fieldSuffix + ", ";
            }
            case 7: {
                String fieldSQL = "\n  sum(\n                           case\n                             when a.fperiod >= ? and\n                                  a.fperiod <= ? and\n                                  a.fperiod >=\n                                  " + startPeriodNumber + " then\n                              A.FCreditQty\n                             else\n                              0\n                           end  ";
                if (isExchangeStandardUnit) {
                    fieldSQL = fieldSQL + " * mu.fcoefficient ";
                }
                fieldSQL = fieldSQL + "                           ) FCreditQty, ";
                return fieldSQL;
            }
            case 8: {
                return "\n  sum(\n                           case\n                             when a.fperiod >= ? and\n                                  a.fperiod <= ? and\n                                  a.fperiod >=\n                                  " + startPeriodNumber + " then\n                              A.FCredit" + fieldSuffix + "\n                             else\n                              0\n                           end  ) FCredit" + fieldSuffix + ", ";
            }
            case 9: {
                String fieldSQL = "\n sum(  \n                             case\n                               when ? >= " + startPeriodNumber + " and\n                                    ? <= " + currPeriodNumber + " and\n                                    a.fperiod = ? then\n                                a.FYearDebitQty \n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod = " + currPeriodNumber + " and\n                                    a.fperiod > ? and a.fperiod <= ? then\n                                a.FYearDebitQty \n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod > " + currPeriodNumber + " and\n                                    a.fperiod > ? and a.fperiod <= ? then\n                                a.fdebitQty \n                               else\n                                0\n                             end ";
                if (isExchangeStandardUnit) {
                    fieldSQL = fieldSQL + " * mu.fcoefficient ";
                }
                fieldSQL = fieldSQL + "                           ) FYearDebitQty, ";
                return fieldSQL;
            }
            case 10: {
                return "\n sum(  \n                             case\n                               when ? >= " + startPeriodNumber + " and\n                                    ? <= " + currPeriodNumber + " and\n                                    a.fperiod = ? then\n                                a.fyeardebit" + fieldSuffix + "\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod = " + currPeriodNumber + " and\n                                    a.fperiod > ? and a.fperiod <= ? then\n                                a.fyeardebit" + fieldSuffix + "\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod > " + currPeriodNumber + " and\n                                    a.fperiod > ? and a.fperiod <= ? then\n                                a.fdebit" + fieldSuffix + "\n                               else\n                                0\n                             end ) FYearDebit" + fieldSuffix + ", ";
            }
            case 11: {
                String fieldSQL = "\n sum(\n                         case\n                           when ? >= " + startPeriodNumber + " and\n                                ? <= " + currPeriodNumber + " and\n                                a.fperiod = ? then\n                            a.FYearCreditQty \n                           when ? > " + currPeriodNumber + " and\n                                a.fperiod = " + currPeriodNumber + " and\n                                a.fperiod > ? and a.fperiod <= ? then\n                            a.FYearCreditQty \n                           when ? > " + currPeriodNumber + " and\n                                a.fperiod > " + currPeriodNumber + " and\n                                a.fperiod > ? and a.fperiod <= ? then\n                            a.FCreditQty \n                           else\n                            0\n                         end ";
                if (isExchangeStandardUnit) {
                    fieldSQL = fieldSQL + " * mu.fcoefficient ";
                }
                fieldSQL = fieldSQL + "                           ) FYearCreditQty, ";
                return fieldSQL;
            }
            case 12: {
                return "\n sum(\n                         case\n                           when ? >= " + startPeriodNumber + " and\n                                ? <= " + currPeriodNumber + " and\n                                a.fperiod = ? then\n                            a.fyearcredit" + fieldSuffix + "\n                           when ? > " + currPeriodNumber + " and\n                                a.fperiod = " + currPeriodNumber + " and\n                                a.fperiod > ? and a.fperiod <= ? then\n                            a.fyearcredit" + fieldSuffix + "\n                           when ? > " + currPeriodNumber + " and\n                                a.fperiod > " + currPeriodNumber + " and\n                                a.fperiod > ? and a.fperiod <= ? then\n                            a.FCredit" + fieldSuffix + "\n                           else\n                            0\n                         end\n                       ) FYearCredit" + fieldSuffix + ",";
            }
            case 13: {
                String fieldSQL = isBalDcSameAsAccount || !isDCSeparate ? "\n sum(\n                    case when D.FDC = 1 then \n                             case\n                               when ? >= " + startPeriodNumber + " and\n                                    ? <= " + currPeriodNumber + " and\n                                    a.fperiod = ? then\n                                  A.FEndQty\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod = " + currPeriodNumber + " then\n                                  A.FEndQty\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod > " + currPeriodNumber + " then \n                                   a.fdebitQty - a.fcreditQty \n                               else\n                                0\n                             end                         else                             0                          end " : "\n sum(\n                             case\n                               when ? >= " + startPeriodNumber + " and\n                                    ? <= " + currPeriodNumber + " and\n                                    a.fperiod = ? then\n                                   case when A.FEndQty > 0 then \n                                       A.FEndQty\n                                   else 0 end\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod = " + currPeriodNumber + " then\n                                   case when A.FEndQty > 0 then \n                                       A.FEndQty\n                                   else 0 end\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod > " + currPeriodNumber + " then \n                                   case when a.fdebitQty - a.fcreditQty > 0 then \n                                       a.fdebitQty - a.fcreditQty\n                                   else 0 end\n                               else\n                                0\n                             end ";
                fieldSQL = isExchangeStandardUnit ? fieldSQL + " * mu.fcoefficient" : fieldSQL + " ";
                fieldSQL = fieldSQL + " ) FEndDebitQty, ";
                return fieldSQL;
            }
            case 14: {
                if (isBalDcSameAsAccount || !isDCSeparate) {
                    return "\n sum(\n                    case when D.FDC = 1 then \n                             case\n                               when ? >= " + startPeriodNumber + " and\n                                    ? <= " + currPeriodNumber + " and\n                                    a.fperiod = ? then\n                                  A.FEndBalance" + fieldSuffix + "\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod = " + currPeriodNumber + " then\n                                  A.FEndBalance" + fieldSuffix + "\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod > " + currPeriodNumber + " then \n                                   a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + "\n                               else\n                                0\n                             end\n            else\n               0\n            end\n                       ) FEndBalanceDebit" + fieldSuffix + ",";
                }
                return "\n sum(\n                             case\n                               when ? >= " + startPeriodNumber + " and\n                                    ? <= " + currPeriodNumber + " and\n                                    a.fperiod = ? then\n                                case\n                                 when A.FEndBalanceFor > 0 then\n                                  A.FEndBalance" + fieldSuffix + "\n                                 else\n                                  0\n                               end\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod = " + currPeriodNumber + " then\n                                case\n                                 when A.FEndBalance" + fieldSuffix + " > 0 then\n                                  A.FEndBalance" + fieldSuffix + "\n                                 else\n                                  0\n                               end\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod > " + currPeriodNumber + " then                                \n                                case \n                                  when a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + " > 0 then\n                                       a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + "\n                                  else\n                                       0\n                                end\n                               else\n                                0\n                             end\n                       ) FEndBalanceDebit" + fieldSuffix + ",";
            }
            case 15: {
                String fieldSQL = isBalDcSameAsAccount || !isDCSeparate ? "\n sum(\n                    case when D.FDC = -1 then \n                             case\n                               when ? >= " + startPeriodNumber + " and\n                                    ? <= " + currPeriodNumber + " and\n                                    a.fperiod = ? then\n                                  -1 * A.FEndQty\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod = " + currPeriodNumber + " then\n                                  -1 * A.FEndQty\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod > " + currPeriodNumber + " then \n                                   a.fcreditQty - a.fdebitQty \n                               else\n                                0\n                             end                         else                             0                          end " : "\n sum(\n                             case\n                               when ? >= " + startPeriodNumber + " and\n                                    ? <= " + currPeriodNumber + " and\n                                    a.fperiod = ? then\n                                   case when A.FEndQty < 0 then \n                                       A.FEndQty\n                                   else 0 end\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod = " + currPeriodNumber + " then\n                                   case when A.FEndQty < 0 then \n                                       A.FEndQty\n                                   else 0 end\n                               when ? > " + currPeriodNumber + " and\n                                    a.fperiod > " + currPeriodNumber + " then \n                                   case when a.fcreditQty - a.fdebitQty > 0 then \n                                       a.fcreditQty - a.fdebitQty \n                                   else 0 end\n                               else\n                                0\n                             end ";
                fieldSQL = isExchangeStandardUnit ? fieldSQL + " * mu.fcoefficient" : fieldSQL + " ";
                fieldSQL = fieldSQL + " ) FEndCreditQty, ";
                return fieldSQL;
            }
            case 16: {
                if (isBalDcSameAsAccount || !isDCSeparate) {
                    return "\n sum(\n                    case when D.FDC = -1 then \n                         case\n                           when ? >= " + startPeriodNumber + " and\n                                ? <= " + currPeriodNumber + " and\n                                a.fperiod = ? then\n                                -1 * A.FEndBalance" + fieldSuffix + "\n                           when ? > " + currPeriodNumber + " and\n                                a.fperiod = " + currPeriodNumber + " then\n                              -1 * A.FEndBalance" + fieldSuffix + "\n                           when ? > " + currPeriodNumber + " and\n                                a.fperiod > " + currPeriodNumber + " then\n                              a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + "\n                           else\n                            0\n                         end\n            else\n               0\n            end\n                       ) FEndBalanceCredit" + fieldSuffix + ",";
                }
                return "\n sum(\n                         case\n                           when ? >= " + startPeriodNumber + " and\n                                ? <= " + currPeriodNumber + " and\n                                a.fperiod = ? then\n                              case\n                               when A.FEndBalance" + fieldSuffix + " < 0 then\n                                -1 * A.FEndBalance" + fieldSuffix + "\n                               else\n                                0\n                             end\n                           when ? > " + currPeriodNumber + " and\n                                a.fperiod = " + currPeriodNumber + " then\n                            case\n                             when A.FEndBalance" + fieldSuffix + " < 0 then\n                              -1 * A.FEndBalance" + fieldSuffix + "\n                             else\n                              0\n                           end\n                           when ? > " + currPeriodNumber + " and\n                                a.fperiod > " + currPeriodNumber + " then\n                              case \n                                  when a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + " > 0 then\n                                       a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + "\n                                  else\n                                       0\n                                end\n                           else\n                            0\n                         end\n                       \n                       ) FEndBalanceCredit" + fieldSuffix + ",";
            }
        }
        return "";
    }

    private void buildLocalSelect(PeriodInfo currPeriod, PeriodInfo startPeriod, boolean displayAmount, boolean isExchangeStandardUnit, boolean isForgenCurr, StringBuffer select, List<String> selectFields, String currencyId, boolean isDCSeparate) {
        String currencyID = String.valueOf(currencyId);
        String fieldSuffix = RptServerUtil.getCurrencyFieldSuffix(currencyID);
        if (isForgenCurr) {
            fieldSuffix = "For";
        }
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(1, fieldSuffix, false, isDCSeparate, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FBeginDebitQty NUMERIC(29,10)");
        }
        select.append(this.coreBalFieldSQLPart(3, fieldSuffix, false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(2, fieldSuffix, false, isDCSeparate, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
        }
        select.append(this.coreBalFieldSQLPart(4, fieldSuffix, false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        selectFields.add("FBeginBalanceDebitFor NUMERIC(27,10)");
        if (displayAmount) {
            selectFields.add("FBeginCreditQty INT");
        }
        selectFields.add("FBeginBalanceCreditFor NUMERIC(27,10)");
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(5, fieldSuffix, false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(6, fieldSuffix, false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(7, fieldSuffix, false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(8, fieldSuffix, false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FDebitQty NUMERIC(29,10)");
            selectFields.add("FDebitFor NUMERIC(27,10)");
            selectFields.add("FCreditQty NUMERIC(29,10)");
            selectFields.add("FCreditFor NUMERIC(27,10)");
        } else {
            select.append(this.coreBalFieldSQLPart(6, fieldSuffix, false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(8, fieldSuffix, false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FDebitFor NUMERIC(27,10)");
            selectFields.add("FCreditFor NUMERIC(27,10)");
        }
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(9, fieldSuffix, false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FYearDebitQty NUMERIC(29,10)");
        }
        select.append(this.coreBalFieldSQLPart(10, fieldSuffix, false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
        selectFields.add("FYearDebitFor NUMERIC(27,10)");
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(11, fieldSuffix, false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FYearCreditQty NUMERIC(29,10)");
        }
        select.append(this.coreBalFieldSQLPart(12, fieldSuffix, false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
        selectFields.add("FYearCreditFor NUMERIC(27,10)");
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(13, fieldSuffix, false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FEndDebitQty NUMERIC(29,10)");
        }
        select.append(this.coreBalFieldSQLPart(14, fieldSuffix, false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        selectFields.add("FEndBalanceDebitFor NUMERIC(27,10)");
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(15, fieldSuffix, false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FEndCreditQty NUMERIC(29,10)");
        }
        select.append(this.coreBalFieldSQLPart(16, fieldSuffix, false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        selectFields.add("FEndBalanceCreditFor NUMERIC(27,10)");
    }

    private void buildForSelect(PeriodInfo currPeriod, PeriodInfo startPeriod, boolean displayAmount, boolean isExchangeStandardUnit, StringBuffer select, List<String> selectFields, boolean isDCSeparate, int yearEnd, int periodEnd) {
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(1, "", false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FBeginDebitQty NUMERIC(29,10)");
        }
        select.append(this.coreBalFieldSQLPart(3, "for", false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        select.append(this.coreBalFieldSQLPart(3, "local", false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(2, "", false, isDCSeparate, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
        }
        select.append(this.coreBalFieldSQLPart(4, "for", false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        select.append(this.coreBalFieldSQLPart(4, "local", false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        selectFields.add("FBeginBalanceDebitFor NUMERIC(27,10)");
        selectFields.add("FBeginBalanceDebitLocal NUMERIC(27,10)");
        if (displayAmount) {
            selectFields.add("FBeginCreditQty NUMERIC(29,10)");
        }
        selectFields.add("FBeginBalanceCreditFor NUMERIC(27,10)");
        selectFields.add("FBeginBalanceCreditLocal NUMERIC(27,10)");
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(5, "", false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(6, "For", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(6, "Local", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(7, "", false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(8, "For", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(8, "Local", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FDebitQty NUMERIC(29,10)");
            selectFields.add("FDebitFor NUMERIC(27,10)");
            selectFields.add("FDebitLocal NUMERIC(27,10)");
            selectFields.add("FCreditQty NUMERIC(29,10)");
            selectFields.add("FCreditFor NUMERIC(27,10)");
            selectFields.add("FCreditLocal NUMERIC(27,10)");
        } else {
            select.append(this.coreBalFieldSQLPart(6, "For", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(6, "Local", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(8, "For", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            select.append(this.coreBalFieldSQLPart(8, "Local", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FDebitFor NUMERIC(27,10)");
            selectFields.add("FDebitLocal NUMERIC(27,10)");
            selectFields.add("FCreditFor NUMERIC(27,10)");
            selectFields.add("FCreditLocal NUMERIC(27,10)");
        }
        int currPeriodNum = currPeriod.getPeriodYear() * 100 + currPeriod.getPeriodNumber();
        int yearTo = yearEnd;
        int periodTo = periodEnd;
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(9, "", false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FYearDebitQty NUMERIC(29,10)");
        }
        select.append(this.coreBalFieldSQLPart(10, "For", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
        select.append(this.coreBalFieldSQLPart(10, "Local", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
        selectFields.add("FYearDebitFor NUMERIC(27,10)");
        selectFields.add("FYearDebitLocal NUMERIC(27,10)");
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(11, "", false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FYearCreditQty NUMERIC(29,10)");
        }
        select.append(this.coreBalFieldSQLPart(12, "For", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
        select.append(this.coreBalFieldSQLPart(12, "Local", false, false, false, startPeriod.getNumber(), currPeriod.getNumber()));
        selectFields.add("FYearCreditFor NUMERIC(27,10)");
        selectFields.add("FYearCreditLocal NUMERIC(27,10)");
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(13, "", false, false, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
            selectFields.add("FEndDebitQty NUMERIC(29,10)");
        }
        select.append(this.coreBalFieldSQLPart(14, "For", false, isDCSeparate, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
        select.append(this.coreBalFieldSQLPart(14, "Local", false, isDCSeparate, isExchangeStandardUnit, startPeriod.getNumber(), currPeriod.getNumber()));
        if (displayAmount) {
            select.append(this.coreBalFieldSQLPart(15, "For", false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        }
        select.append(this.coreBalFieldSQLPart(16, "For", false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        select.append(this.coreBalFieldSQLPart(16, "Local", false, isDCSeparate, false, startPeriod.getNumber(), currPeriod.getNumber()));
        selectFields.add("FEndBalanceDebitFor NUMERIC(27,10)");
        selectFields.add("FEndBalanceDebitLocal NUMERIC(27,10)");
        if (displayAmount) {
            selectFields.add("FEndCreditQty NUMERIC(29,10)");
        }
        selectFields.add("FEndBalanceCreditFor NUMERIC(27,10)");
        selectFields.add("FEndBalanceCreditLocal NUMERIC(27,10)");
    }

    private void execInsertAsstItemMulitLevelAndGroupSQL(String dataTable) throws BOSException, EASBizException {
        if (this.cond.isBizCode()) {
            return;
        }
        List rs = this.cond.getAsstActList();
        if (rs.isEmpty()) {
            return;
        }
        int asstTypeIndex = -1;
        boolean haveDealOneLevelCollectAsstActType = false;
        for (AsstactTypeEntity firstAsstActType : rs) {
            ++asstTypeIndex;
            if (haveDealOneLevelCollectAsstActType) {
                this.logDebug(" two level-collect asstType is not supported!");
                break;
            }
            if (CollectEnum.LEVEL.equals((Object)firstAsstActType.getCollect()) || CollectEnum.UP.equals((Object)firstAsstActType.getCollect())) {
                boolean useGroup;
                if (CollectEnum.LEVEL.equals((Object)firstAsstActType.getCollect())) {
                    haveDealOneLevelCollectAsstActType = true;
                }
                String currencyID = this.cond.getCurrencyID();
                boolean displayAmount = this.cond.isShowQty();
                boolean ischkOpAsstGroup = this.cond.isFilterByCat();
                Context ctx = this.getCtx();
                boolean isQtyAsst = Boolean.valueOf(this.systemParam.get("G010") + "");
                boolean isAsstActShowLongNumber = Boolean.valueOf(this.systemParam.get("GL_064") + "");
                boolean displayUnit = displayAmount && isQtyAsst;
                CompanyOrgUnitInfo company = this.cond.getCompany();
                boolean isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
                String loc = this.getLoc(ctx);
                String firstAsstActTypeTableName = firstAsstActType.getTableName();
                boolean isMultiLevel = firstAsstActType.isMultilevel();
                boolean bl = useGroup = firstAsstActType.getGroupTable() != null;
                if (isMultiLevel && !useGroup) {
                    boolean isExistRecord;
                    StringBuffer sql = new StringBuffer();
                    sql.append("select max(B.FLevel) FLevel from ").append(dataTable).append(" A ").append(" inner join ").append(firstAsstActTypeTableName).append(" B ").append(" on B.FID = A.FID").append(asstTypeIndex);
                    IRowSet rr = DbUtil.executeQuery(this.ctx, sql.toString());
                    try {
                        isExistRecord = rr.next() && rr.getObject(1) != null;
                        int maxLevel = rr.getInt(1);
                    }
                    catch (SQLException e) {
                        logger.error((Object)"", (Throwable)e);
                        throw new SQLDataException(e);
                    }
                    if (!isExistRecord) continue;
                    boolean isGeneralActType = firstAsstActType.getHgAttribute() != null && firstAsstActType.getHgAttribute().startsWith("generalAssActType");
                    boolean isUseLongNumber = "1".equals(firstAsstActType.getHgAttribute());
                    boolean showasstNumber = !(isAsstActShowLongNumber && isGeneralActType || !isGeneralActType && isUseLongNumber);
                    sql = new StringBuffer();
                    sql.setLength(0);
                    sql.append(this.getSQL4InsertSumLvl1Insert(dataTable, rs, displayAmount, displayUnit, isBaseCurrencyQuery, asstTypeIndex, true));
                    sql.append(" select FaccountID,FaccountName,FaccountNumber, faccountdc, \n");
                    sql.append(showasstNumber ? "C.FNumber" : "replace(C.FLongNumber,'!','.')");
                    sql.append(" FNumber0, C.FLongNumber, C.FID FID0, ").append("C.FName_").append(loc).append(" FName0, ");
                    if (displayAmount) {
                        if (isBaseCurrencyQuery) {
                            sql.append("\n sum(FBeginDebitQty), sum(FBeginBalanceDebitFor),").append(" sum(FBeginCreditQty),sum(FBeginBalanceCreditFor),").append(" sum(FDebitQty), sum(FDebitFor), sum(FCreditQty), sum(FCreditFor),").append(" sum(FYearDebitQty), sum(FYearDebitFor), sum(FYearCreditQty), ").append(" sum(FYearCreditFor), sum(FEndDebitQty), sum(FEndBalanceDebitFor), ").append(" sum(FEndCreditQty) FEndCreditQty,sum(FEndBalanceCreditFor),");
                        } else {
                            sql.append("\n sum(FBeginDebitQty),").append("sum(FBeginBalanceDebitFor),sum(FBeginBalanceDebitLocal),").append("\n sum(FBeginCreditQty),").append("sum(FBeginBalanceCreditFor), sum(FBeginBalanceCreditLocal),").append("sum(FDebitQty),").append("sum(FDebitFor), sum(FDebitLocal),").append("sum(FCreditQty),").append("sum(FCreditFor),sum(FCreditLocal), ").append("sum(FYearDebitQty),").append("sum(FYearDebitFor),sum(FYearDebitLocal),").append("sum(FYearCreditQty),").append("sum(FYearCreditFor),sum(FYearCreditLocal),").append("sum(FEndDebitQty),").append("sum(FEndBalanceDebitFor),sum(FEndBalanceDebitLocal),").append("sum(FEndCreditQty) FEndCreditQty,").append("sum(FEndBalanceCreditFor),sum(FEndBalanceCreditLocal),");
                        }
                    } else if (isBaseCurrencyQuery) {
                        sql.append("\n sum(FBeginBalanceDebitFor), sum(FBeginBalanceCreditFor), sum(FDebitFor), ").append(" sum(FCreditFor), sum(FYearDebitFor), ").append(" sum(FYearCreditFor), sum(FEndBalanceDebitFor), ").append(" sum(FEndBalanceCreditFor),");
                    } else {
                        sql.append("\n sum(FBeginBalanceDebitFor),sum(FBeginBalanceDebitLocal),").append("sum(FBeginBalanceCreditFor), sum(FBeginBalanceCreditLocal),").append("sum(FDebitFor), sum(FDebitLocal),").append("sum(FCreditFor),sum(FCreditLocal),").append("sum(FYearDebitFor),sum(FYearDebitLocal),").append("sum(FYearCreditFor),sum(FYearCreditLocal),").append("sum(FEndBalanceDebitFor),sum(FEndBalanceDebitLocal),").append("sum(FEndBalanceCreditFor),sum(FEndBalanceCreditLocal),");
                    }
                    sql.append(" C.FLevel, 0,");
                    if (displayUnit) {
                        sql.append("A.muId, A.muName,");
                    }
                    sql.append(" C.FLongNumber \r\n");
                    sql.append(" from ").append(dataTable).append(" A \n ");
                    sql.append(" inner join ").append(firstAsstActTypeTableName).append(" B  ");
                    sql.append(" on B.FID=A.FID0 and B.FLevel= ? ").append(" \n inner join ").append(firstAsstActTypeTableName).append(" C ");
                    sql.append("  on C.FID=B.FParentID ").append(" \n group by C.FLongNumber,FaccountID,FaccountName,FaccountNumber,").append("faccountdc,");
                    if (showasstNumber) {
                        sql.append("C.FNumber,");
                    }
                    sql.append("C.FID, C.FName_").append(loc).append(", ");
                    if (displayUnit) {
                        sql.append(" muId, muName ,");
                    }
                    for (int m = 0; m < rs.size(); ++m) {
                        if (m != asstTypeIndex) {
                            sql.append("\n A.FNumber").append(m).append(",A.FLongNumber").append(m).append(",A.FID").append(m).append(",A.FName").append(m).append(",");
                            continue;
                        }
                        this.logDebug("omit level-collect asstType");
                    }
                    sql.append("C.FLevel");
                    int parentMaxLevel = 1;
                    if (CollectEnum.UP.equals((Object)firstAsstActType.getCollect())) {
                        parentMaxLevel = firstAsstActType.getSelectedLevel();
                    }
                    for (int i = maxLevel; i > parentMaxLevel; --i) {
                        DbUtil.execute(ctx, sql.toString(), new Object[]{i});
                    }
                    String updateLevelSQL = "update " + dataTable + " set FLevel = ( select A.FLevel from " + firstAsstActTypeTableName + " A  where A.FID= " + dataTable + ".FID0) \n where " + dataTable + ".FLevel=0 ";
                    DbUtil.execute(ctx, updateLevelSQL);
                    continue;
                }
                if (useGroup) {
                    boolean isExistRecord;
                    boolean isCsspGroup;
                    String asstHG = firstAsstActType.getHgAttribute();
                    String asstGroupInfo = firstAsstActType.getAsstGroup();
                    String standardTable = null;
                    String detail = null;
                    String fGDcsspGroupID = null;
                    String fGDcsspGroupStandardID = null;
                    String fmappingfieldname = null;
                    AcctountAsstItemParser.AccountAsstItem accountAsstItem = null;
                    boolean bl2 = isCsspGroup = ischkOpAsstGroup && this.coreExistAsstGroup(firstAsstActType);
                    if (isCsspGroup) {
                        standardTable = firstAsstActType.getGroupTable() + "Standard";
                        detail = firstAsstActType.getTableName() + "Group" + (asstHG.equals("material") ? "Detial" : "Detail");
                        fGDcsspGroupID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupID";
                        fGDcsspGroupStandardID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupStandardID";
                        fmappingfieldname = asstHG.equalsIgnoreCase("provider") ? "FSupplierID" : firstAsstActType.getHgField();
                        try {
                            accountAsstItem = AcctountAsstItemParser.parse((String)("||" + asstGroupInfo + "#"));
                        }
                        catch (ParseException e) {
                            logger.error((Object)"", (Throwable)e);
                        }
                    }
                    StringBuilder maxLevelSQL = new StringBuilder();
                    String groupTable = firstAsstActType.getGroupTable();
                    String groupTableField = firstAsstActType.getGroupField();
                    if (isCsspGroup) {
                        maxLevelSQL.append("select max(C.FLevel) FLevel from ").append(dataTable).append(" A ").append(" inner join ").append(detail).append(" B ").append(" on B.").append(fmappingfieldname).append(" = A.FID").append(asstTypeIndex).append(" inner join ").append(standardTable).append(" GS ").append(" on GS.FID = B.").append(fGDcsspGroupStandardID).append(" inner join ").append(groupTable).append(" C ").append(" on c.FID =  B.").append(fGDcsspGroupID);
                    } else {
                        maxLevelSQL.append("select max(C.FLevel) FLevel from ").append(dataTable).append(" A \n").append(" inner join ").append(groupTable).append(" C ").append(" on C.FID = a.FGPID").append(asstTypeIndex);
                    }
                    IRowSet maxLevelRS = DbUtil.executeQuery(this.ctx, maxLevelSQL.toString());
                    try {
                        isExistRecord = maxLevelRS.next() && maxLevelRS.getObject(1) != null;
                        int maxLevel = maxLevelRS.getInt(1);
                    }
                    catch (SQLException e) {
                        logger.error((Object)"", (Throwable)e);
                        throw new SQLDataException(e);
                    }
                    if (!isExistRecord) continue;
                    maxLevelSQL.setLength(0);
                    maxLevelSQL.append(this.getSQL4InsertSumLvl1Insert(dataTable, rs, displayAmount, displayUnit, isBaseCurrencyQuery, asstTypeIndex, false));
                    maxLevelSQL.append(this.getSQL4InsertSumLvl1Select(dataTable, rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, isCsspGroup, groupTable, standardTable, detail, fGDcsspGroupID, fGDcsspGroupStandardID, fmappingfieldname, accountAsstItem, asstTypeIndex));
                    DbUtil.execute(this.ctx, maxLevelSQL.toString());
                    String u = "update " + dataTable + " set(FLevel)=(select isnull(B.FLevel,0)+1  from " + firstAsstActTypeTableName + " A," + groupTable + " B  where A.FID=" + dataTable + ".FID0 and  B.FID=A." + groupTableField + ")\n where " + dataTable + ".FLevel=0";
                    if (isCsspGroup) {
                        AcctountAsstItemParser.Group group = accountAsstItem.asstItems[0].group[0];
                        u = "update " + dataTable + " set(FLevel)=(select isnull(B.FLevel,0)+1 from " + detail + " A," + standardTable + " GS," + groupTable + " B  where A." + fmappingfieldname + "=" + dataTable + ".FID" + asstTypeIndex + " and  GS.FID=A." + fGDcsspGroupStandardID + " and B.fid = A." + fGDcsspGroupID + "  and GS.fnumber = '" + group.standardNumber + "')\n where " + dataTable + ".FLevel=0 ";
                    }
                    DbUtil.execute(this.ctx, u);
                    maxLevelSQL.setLength(0);
                    maxLevelSQL.append(this.getSQL4InsertSumLvl1Insert(dataTable, rs, displayAmount, displayUnit, isBaseCurrencyQuery, asstTypeIndex, false));
                    maxLevelSQL.append(this.getSQL4InsertSumLvl2Select(dataTable, rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, groupTable, asstTypeIndex));
                    for (int i = maxLevel; i > 0; --i) {
                        DbUtil.execute(this.ctx, maxLevelSQL.toString(), new Object[]{i});
                    }
                    continue;
                }
                this.logDebug("no isMultiLevel or UserGroup");
                continue;
            }
            this.logDebug("omit non-level-collect asstType");
        }
    }

    private String execReGroupSQL(String tempTable) throws BOSException, EASBizException {
        StringBuffer ff;
        boolean isBizCode = this.cond.isBizCode();
        List rs = this.cond.getAsstActList();
        if (isBizCode) {
            return "";
        }
        if (rs.isEmpty()) {
            return "";
        }
        String currencyID = this.cond.getCurrencyID();
        boolean displayAmount = this.cond.isShowQty();
        boolean isQtyAsst = Boolean.valueOf(this.systemParam.get("G010") + "");
        boolean displayUnit = displayAmount && isQtyAsst;
        CompanyOrgUnitInfo company = this.cond.getCompany();
        boolean isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        StringBuilder selectFrom = new StringBuilder("select ");
        StringBuilder group = new StringBuilder("\n group by ");
        if (isBizCode) {
            ff = new StringBuffer().append("FID").append(',').append("FNumber").append(',').append("FName0").append(',');
            selectFrom.append(ff);
            group.append(ff);
        } else {
            for (int n = 0; n < rs.size(); ++n) {
                ff = new StringBuffer().append("FID").append(n).append(',').append("FNumber").append(n).append(',').append("FLongNumber").append(n).append(',');
                if (((AsstactTypeEntity)rs.get(n)).getGroupTable() != null) {
                    ff.append("FGPID").append(n).append(',');
                }
                ff.append("FName").append(n).append(',');
                selectFrom.append(ff);
                group.append(ff);
            }
        }
        selectFrom.append("  FaccountID,FaccountNumber,  FaccountName, faccountdc,");
        if (displayUnit) {
            selectFrom.append(" muId, muName, ");
        }
        if (this.cond.isAllCurrency()) {
            selectFrom.append("  FCurrencyID,FCurrencyName,FCurrencyPre,");
        }
        StringBuilder amount = new StringBuilder();
        if (isBaseCurrencyQuery) {
            if (displayAmount) {
                selectFrom.append(" sum(FBeginDebitQty) FBeginDebitQty, \t\t\t\t\t\t    \n");
                amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t            \n");
                amount.append(" sum(FDebitFor) FDebitFor, \t\t\t\t\t\t        \n");
                amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t            \n");
                amount.append(" sum(FCreditFor) FCreditFor,\t\t\t\t\t\t        \n");
                amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t            \n");
                amount.append(" sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t    \n");
                amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t            \n");
                amount.append(" sum(FYearCreditFor) FYearCreditFor, \t\t\t\t    \n");
                amount.append(" sum(FEndDebitQty) FEndDebitQty, \t\t\t\t\t\t            \n");
            } else {
                amount.append("sum(FDebitFor) FDebitFor, sum(FCreditFor) FCreditFor,    \n");
                amount.append("sum(FYearDebitFor) FYearDebitFor,                        \n");
                amount.append("sum(FYearCreditFor) FYearCreditFor,                      \n");
            }
            selectFrom.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t    \n");
            if (displayAmount) {
                selectFrom.append(" sum(FBeginCreditQty) FBeginCreditQty,               \n");
            }
            selectFrom.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t\n");
            selectFrom.append((CharSequence)amount);
            selectFrom.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\n");
            if (displayAmount) {
                selectFrom.append(" sum(FEndCreditQty) FEndCreditQty,                   \n");
            }
            selectFrom.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\n");
        } else {
            if (displayAmount) {
                selectFrom.append(" sum(FBeginDebitQty) FBeginDebitQty, \t\t\t\t\n");
                amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditFor) FCreditFor,\t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditLocal) FCreditLocal,\t\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
                amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t\t\t\t\n");
                amount.append(" sum(FYearCreditFor) FYearCreditFor, \t\t\t\t\t\n");
                amount.append(" sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\n");
                amount.append(" sum(FEndDebitQty) FEndDebitQty, \t\t\t\t\t\t\n");
            } else {
                amount.append("sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
                amount.append("sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
                amount.append("sum(FCreditFor) FCreditFor, \t\t\t\t\t\t\t\t\n");
                amount.append("sum(FCreditLocal) FCreditLocal, \t\t\t\t\t\t\t\n");
                amount.append("sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t\t\n");
                amount.append("sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
                amount.append("sum(FYearCreditFor) FYearCreditFor, \t\t\t\t\t\t\n");
                amount.append("sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\t\n");
            }
            selectFrom.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\t\n");
            selectFrom.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \t\n");
            if (displayAmount) {
                selectFrom.append(" sum(FBeginCreditQty) FBeginCreditQty,               \n");
            }
            selectFrom.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t\n");
            selectFrom.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal, \n");
            selectFrom.append((CharSequence)amount);
            selectFrom.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\n");
            selectFrom.append(" sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal, \t\t\n");
            if (displayAmount) {
                selectFrom.append(" sum(FEndCreditQty) FEndCreditQty,                   \n");
            }
            selectFrom.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\n");
            selectFrom.append(" sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal, \t\n");
        }
        selectFrom.append("FLevel,FIsLeaf,");
        selectFrom.append(" FOrderNumber");
        selectFrom.append("\n from ").append(tempTable).append(" t ");
        for (int i = 0; i < rs.size(); ++i) {
            boolean useGroup;
            AsstactTypeEntity asstType = (AsstactTypeEntity)rs.get(i);
            boolean isMultiLevel = asstType.isMultilevel();
            boolean bl = useGroup = asstType.getGroupTable() != null;
            if (!isMultiLevel || !CollectEnum.UP.equals((Object)asstType.getCollect())) continue;
            selectFrom.append(" where FLevel = " + asstType.getSelectedLevel() + " ");
            break;
        }
        group.append("t.FLevel,t.FIsLeaf,FOrderNumber");
        if (this.cond.isAllCurrency()) {
            group.append(",FCurrencyID,FCurrencyName,FCurrencyPre ");
        }
        if (displayUnit) {
            group.append(" ,muId, muName ");
        }
        selectFrom.append((CharSequence)group);
        selectFrom.append(",FaccountNumber,  FaccountName, FaccountID,faccountdc");
        return selectFrom.toString();
    }

    @Override
    public void execInsertAsstItemSumSQL(String dataTable) throws BOSException, EASBizException {
        boolean isBizCode = this.cond.isBizCode();
        if (isBizCode) {
            return;
        }
        List rs = this.cond.getAsstActList();
        if (rs.isEmpty()) {
            return;
        }
        String currencyID = this.cond.getCurrencyID();
        boolean displayAmount = this.cond.isShowQty();
        boolean showOnlySubAccountview = this.cond.isShowLeafAccount();
        Context ctx = this.getCtx();
        boolean isQtyAsst = Boolean.valueOf(this.systemParam.get("G010") + "");
        boolean displayUnit = displayAmount && isQtyAsst;
        CompanyOrgUnitInfo company = this.cond.getCompany();
        boolean isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        StringBuffer qqSumAss = new StringBuffer();
        StringBuilder group = new StringBuilder("\n group by ");
        StringBuilder selectFields = new StringBuilder();
        if (isBizCode) {
            StringBuffer ff = new StringBuffer().append("FNumber0").append(',').append("FID0").append(',').append("FName0").append(',');
            selectFields.append("FID0").append(',').append("FNumber0").append(',').append("FName0").append(',');
            qqSumAss.append(ff);
            group.append(ff);
        } else {
            for (int n = 0; n < rs.size(); ++n) {
                StringBuffer ff = new StringBuffer();
                ff.append("FID").append(n).append(',').append("FNumber").append(n).append(',').append("FLongNumber").append(n).append(',');
                if (((AsstactTypeEntity)rs.get(n)).getGroupTable() != null) {
                    ff.append("FGPID").append(n).append(',');
                }
                ff.append("FName").append(n).append(',');
                selectFields.append(ff);
                qqSumAss.append(ff);
                group.append(ff);
            }
        }
        if (isBaseCurrencyQuery) {
            qqSumAss.append(" ' ',");
            qqSumAss.append("'").append(GLResUtil.getRes("subtotal", ctx)).append("',");
            qqSumAss.append("' ',case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) ").append("then 1 else 0 end,");
        } else {
            qqSumAss.append(" ' ',");
            qqSumAss.append("'").append(GLResUtil.getRes("subtotal", ctx)).append("',");
            qqSumAss.append("' ',case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) ").append("then 1 else 0 end,");
        }
        selectFields.append("FAccountID,FAccountNumber,FAccountName,FAccountDC,");
        if (displayUnit) {
            qqSumAss.append(" muId,muName, ");
            selectFields.append(" muId,muName,");
        }
        if (this.cond.isAllCurrency()) {
            // empty if block
        }
        StringBuilder amount = new StringBuilder();
        if (isBaseCurrencyQuery) {
            if (displayAmount) {
                qqSumAss.append(" sum(FBeginDebitQty) FBeginDebitQty, \t\t\t\t\t\t    \n");
                qqSumAss.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t        \n");
                qqSumAss.append(" sum(FBeginCreditQty) FBeginCreditQty, \t\t\t\t\t\t\n");
                qqSumAss.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t        \n");
                amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t                    \n");
                amount.append(" sum(FDebitFor) FDebitFor, \t\t\t\t\t\t                \n");
                amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t                    \n");
                amount.append(" sum(FCreditFor) FCreditFor,\t\t\t\t\t\t                \n");
                amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t                    \n");
                amount.append(" sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t            \n");
                amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t                    \n");
                amount.append(" sum(FYearCreditFor) FYearCreditFor, \t\t\t\t            \n");
                amount.append(" sum(FEndDebitQty) FEndDebitQty, \t\t\t\t\t\t                    \n");
                selectFields.append("FBeginDebitQty,FBeginBalanceDebitFor,FBeginCreditQty,FBeginBalanceCreditFor,FDebitQty,FDebitFor,FCreditQty,FCreditFor,FYearDebitQty,FYearDebitFor,FYearCreditQty,FYearCreditFor,FEndDebitQty,");
            } else {
                qqSumAss.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t        \n");
                qqSumAss.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t        \n");
                selectFields.append("FBeginBalanceDebitFor,FBeginBalanceCreditFor,");
                amount.append("sum(FDebitFor) FDebitFor, sum(FCreditFor) FCreditFor,            \n");
                amount.append("sum(FYearDebitFor) FYearDebitFor,                                \n");
                amount.append("sum(FYearCreditFor) FYearCreditFor,                              \n");
                selectFields.append("FDebitFor,FCreditFor,FYearDebitFor,FYearCreditFor,");
            }
            qqSumAss.append((CharSequence)amount);
            qqSumAss.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\t\t\n");
            if (displayAmount) {
                qqSumAss.append("sum(FEndCreditQty) FEndCreditQty, ");
            }
            qqSumAss.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\t\t\t\n");
            selectFields.append("FEndBalanceDebitFor,");
            if (displayAmount) {
                selectFields.append("FEndCreditQty, ");
            }
            selectFields.append("FEndBalanceCreditFor,");
        } else {
            if (displayAmount) {
                qqSumAss.append(" sum(FBeginDebitQty) FBeginDebitQty, \t\t\t\t\t\t\t\n");
                qqSumAss.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\t\t\n");
                qqSumAss.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \t\t\n");
                qqSumAss.append(" sum(FBeginCreditQty) FBeginCreditQty, \t\t\t\t\t\t\n");
                qqSumAss.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t\t    \n");
                qqSumAss.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal, \t    \n");
                amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditFor) FCreditFor,\t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditLocal) FCreditLocal,\t\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
                amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t\t\t\t\n");
                amount.append(" sum(FYearCreditFor) FYearCreditFor, \t\t\t\t\t\n");
                amount.append(" sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\n");
                amount.append(" sum(FEndDebitQty) FEndDebitQty, \t\t\t\t\t\t\t\t\t\n");
                selectFields.append("FBeginDebitQty,FBeginBalanceDebitFor,FBeginBalanceDebitLocal,FBeginCreditQty,FBeginBalanceCreditFor,FBeginBalanceCreditLocal,FDebitQty,FDebitFor,FDebitLocal,FCreditQty,FCreditFor,FCreditLocal,FYearDebitQty,FYearDebitFor,FYearDebitLocal,FYearCreditQty,FYearCreditFor,FYearCreditLocal,FEndDebitQty,");
            } else {
                qqSumAss.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\t\t\n");
                qqSumAss.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \t\t\n");
                qqSumAss.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t\t\n");
                qqSumAss.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal, \t\n");
                amount.append("sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
                amount.append("sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
                amount.append("sum(FCreditFor) FCreditFor, \t\t\t\t\t\t\t\t\n");
                amount.append("sum(FCreditLocal) FCreditLocal, \t\t\t\t\t\t\t\n");
                amount.append("sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t\t\n");
                amount.append("sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
                amount.append("sum(FYearCreditFor) FYearCreditFor, \t\t\t\t\t\t\n");
                amount.append("sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\t\n");
                selectFields.append("FBeginBalanceDebitFor,FBeginBalanceDebitLocal,FBeginBalanceCreditFor,FBeginBalanceCreditLocal,FDebitFor,FDebitLocal,FCreditFor,FCreditLocal,FYearDebitFor,FYearDebitLocal,FYearCreditFor,FYearCreditLocal,");
            }
            qqSumAss.append((CharSequence)amount);
            qqSumAss.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\t\t\n");
            qqSumAss.append(" sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal, \t\t\t\t\n");
            if (displayAmount) {
                qqSumAss.append(" sum(FEndCreditQty) FEndCreditQty, \t\t\t\t\n");
            }
            qqSumAss.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\t\t\n");
            qqSumAss.append(" sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal, \t\t\t\n");
            selectFields.append("FEndBalanceDebitFor,FEndBalanceDebitLocal,");
            if (displayAmount) {
                selectFields.append("FEndCreditQty,");
            }
            selectFields.append("FEndBalanceCreditFor,FEndBalanceCreditLocal,");
        }
        qqSumAss.append("t.FLevel,t.FIsLeaf,FOrderNumber,0,1");
        selectFields.append("FLevel,FIsLeaf,FOrderNumber,isTotal,actTypeIsTotal ");
        group.append("t.FLevel,t.FIsLeaf,FOrderNumber");
        if (displayUnit) {
            group.append(" ,muId, muName ");
        }
        qqSumAss.append("  from ").append(dataTable).append(" t ");
        if (!showOnlySubAccountview) {
            qqSumAss.append(" inner join t_bd_accountview av on av.fid = t.faccountid ");
        }
        qqSumAss.append("\r\n where t.FOrderNumber <> '").append(GlUtils.getMaxChar()).append("'");
        if (!showOnlySubAccountview) {
            int levelFrom = this.cond.getAccountLevelStart();
            qqSumAss.append(" and av.flevel = ").append(levelFrom);
        }
        qqSumAss.append((CharSequence)group);
        qqSumAss = new StringBuffer().append("insert into " + dataTable + "(" + selectFields + ") select ").append(qqSumAss);
        if (this.cond.isShowAsstItemTotal()) {
            DbUtil.execute(ctx, qqSumAss.toString());
        }
    }

    private StringBuffer getSQL4InsertSumLvl1Insert(String dataTable, List<AsstactTypeEntity> rs, boolean displayAmount, boolean displayUnit, boolean isBaseCurrencyQuery, int asstTypeIndex, boolean isForGroup) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(dataTable).append("    \r\n");
        sql.append("   (FACCOUNTID,FACCOUNTNAME,FACCOUNTNUMBER,FACCOUNTDC      \r\n");
        sql.append("    ,FNUMBER").append(asstTypeIndex).append(",FLONGNUMBER").append(asstTypeIndex).append(",");
        if (!isForGroup) {
            sql.append("FGPID").append(asstTypeIndex).append(",");
        }
        sql.append("FID").append(asstTypeIndex).append(",FNAME").append(asstTypeIndex).append(",               \r\n");
        for (int m = 0; m < rs.size(); ++m) {
            if (m == asstTypeIndex) continue;
            sql.append("\n FNumber").append(m).append(", FLongNumber").append(m).append(", FID").append(m).append(",FName").append(m).append(",  \r\n");
        }
        if (displayAmount) {
            if (isBaseCurrencyQuery) {
                sql.append("\n FBeginDebitQty,FBeginBalanceDebitFor,FBeginCreditQty,FBeginBalanceCreditFor,").append("FDebitQty,FDebitFor,FCreditQty,FCreditFor,");
                sql.append(" FYearDebitQty,FYearDebitFor,FYearCreditQty,FYearCreditFor,").append("FEndDebitQty,FEndBalanceDebitFor,FEndCreditQty,FEndBalanceCreditFor,");
            } else {
                sql.append("\n FBeginDebitQty,").append("FBeginBalanceDebitFor,FBeginBalanceDebitLocal,").append("FBeginCreditQty,").append("FBeginBalanceCreditFor,FBeginBalanceCreditLocal,").append("FDebitQty,").append("FDebitFor,FDebitLocal,").append("FCreditQty,").append("FCreditFor,FCreditLocal,").append("FYearDebitQty,").append("FYearDebitFor,FYearDebitLocal,").append("FYearCreditQty,").append("FYearCreditFor,FYearCreditLocal, ").append("FEndDebitQty,").append("FEndBalanceDebitFor,FEndBalanceDebitLocal,").append("FEndCreditQty,").append("FEndBalanceCreditFor,FEndBalanceCreditLocal,");
            }
        } else if (isBaseCurrencyQuery) {
            sql.append("\n FBeginBalanceDebitFor,FBeginBalanceCreditFor,").append("FDebitFor,FCreditFor,FYearDebitFor,FYearCreditFor,").append("FEndBalanceDebitFor,FEndBalanceCreditFor,");
        } else {
            sql.append("\n FBeginBalanceDebitFor,FBeginBalanceDebitLocal,").append("FBeginBalanceCreditFor,FBeginBalanceCreditLocal,").append("FDebitFor,FDebitLocal,").append("FCreditFor,FCreditLocal,").append("FYearDebitFor,FYearDebitLocal, ").append("FYearCreditFor,FYearCreditLocal, ").append("FEndBalanceDebitFor,FEndBalanceDebitLocal,").append("FEndBalanceCreditFor,FEndBalanceCreditLocal,");
        }
        sql.append("\r\n    FLEVEL,FISLEAF,");
        if (displayUnit) {
            sql.append(" muId, muName, ");
        }
        sql.append(" FORDERNUMBER                             \r\n");
        sql.append("\t)                                                         \r\n");
        return sql;
    }

    @Override
    public void execInsertSumSQL(String tempTable) throws BOSException, EASBizException {
        boolean isBizCode = this.cond.isBizCode();
        List rs = this.cond.getAsstActList();
        if (!isBizCode && rs.isEmpty()) {
            return;
        }
        String currencyID = this.cond.getCurrencyID();
        boolean displayAmount = this.cond.isShowQty();
        boolean showOnlySubAccountview = this.cond.isShowLeafAccount();
        boolean isBalDcSameAsAccount = this.cond.isBalanceDirSamAsAccount();
        Context ctx = this.getCtx();
        boolean isQtyAsst = Boolean.valueOf(this.systemParam.get("G010") + "");
        boolean displayUnit = displayAmount && isQtyAsst;
        CompanyOrgUnitInfo company = this.cond.getCompany();
        boolean isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        StringBuffer qqSum = new StringBuffer();
        StringBuffer selectFields = new StringBuffer();
        if (isBizCode) {
            selectFields.append("FID0").append(',').append("FNumber0").append(',').append("FName0").append(',');
            qqSum.append("' ',' ','").append(GLResUtil.getRes("subtotal", ctx)).append(" ',");
        } else {
            for (int n = 0; n < rs.size(); ++n) {
                selectFields.append("FID").append(n).append(',').append("FNumber").append(n).append(',').append("FLongNumber").append(n).append(',');
                if (((AsstactTypeEntity)rs.get(n)).getGroupTable() != null) {
                    selectFields.append("FGPID").append(n).append(',');
                }
                selectFields.append("FName").append(n).append(',');
                if (((AsstactTypeEntity)rs.get(n)).getGroupTable() != null) {
                    qqSum.append("' ',");
                }
                qqSum.append("' ',' ',' ','");
                if (n == 0) {
                    qqSum.append(GLResUtil.getRes("total", ctx)).append("',");
                    continue;
                }
                qqSum.append(" ',");
            }
        }
        String fieldSuffix = RptServerUtil.getCurrencyFieldSuffix(currencyID);
        if (isBaseCurrencyQuery) {
            qqSum.append(" ' ',' ',' ',case when sum(FBeginBalanceDebit" + fieldSuffix + ") >= sum(FBeginBalanceCredit" + fieldSuffix + ") then 1 else 0 end,");
        } else {
            qqSum.append(" ' ',' ',' ',case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) then 1 else 0 end,");
        }
        selectFields.append("FAccountID,FAccountNumber,FAccountName,FAccountDC,");
        if (displayUnit) {
            qqSum.append(" ' ',' ',");
            selectFields.append("muId,muName,");
        }
        StringBuffer amount = new StringBuffer();
        if (isBaseCurrencyQuery) {
            if (displayAmount) {
                qqSum.append(" sum(FBeginDebitQty) FBeginDebitQty, \t\t\t\t\t\n");
                qqSum.append(" sum(FBeginBalanceDebit" + fieldSuffix + ") FBeginBalanceDebitFor, \t\n");
                qqSum.append(" sum(FBeginCreditQty) FBeginCreditQty, \t\t\t\t\t\n");
                qqSum.append(" sum(FBeginBalanceCredit" + fieldSuffix + ") FBeginBalanceCreditFor, \t\n");
                amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t\n");
                amount.append(" sum(FDebit" + fieldSuffix + ") FDebitFor, \t\t\t\t\t\t\n");
                amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t\n");
                amount.append(" sum(FCredit" + fieldSuffix + ") FCreditFor,\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t\n");
                amount.append(" sum(FYearDebit" + fieldSuffix + ") FYearDebitFor,\t\t\t\t\t\n");
                amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t\n");
                amount.append(" sum(FYearCredit" + fieldSuffix + ") FYearCreditFor, \t\t\t\t\n");
                amount.append(" sum(FEndDebitQty) FEndDebitQty, \t\t\t\t\t\t\n");
                selectFields.append("FBeginDebitQty,FBeginBalanceDebit" + fieldSuffix + ",FBeginCreditQty,FBeginBalanceCredit" + fieldSuffix + ",FDebitQty,FDebit" + fieldSuffix + ",FCreditQty,FCredit" + fieldSuffix + ",FYearDebitQty,FYearDebit" + fieldSuffix + ",FYearCreditQty,FYearCredit" + fieldSuffix + ",FEndDebitQty,");
            } else {
                qqSum.append(" sum(FBeginBalanceDebit" + fieldSuffix + ") FBeginBalanceDebitFor, \t\n");
                qqSum.append(" sum(FBeginBalanceCredit" + fieldSuffix + ") FBeginBalanceCreditFor, \t\n");
                selectFields.append("FBeginBalanceDebit" + fieldSuffix + ",FBeginBalanceCredit" + fieldSuffix + ",");
                amount.append("sum(FDebit" + fieldSuffix + ") FDebitFor, sum(FCredit" + fieldSuffix + ") FCreditFor, \r\n");
                amount.append("sum(FYearDebit" + fieldSuffix + ") FYearDebitFor, \r\n");
                amount.append("sum(FYearCredit" + fieldSuffix + ") FYearCreditFor, \r\n");
                selectFields.append("FDebit" + fieldSuffix + ",FCredit" + fieldSuffix + ",FYearDebit" + fieldSuffix + ",FYearCredit" + fieldSuffix + ",");
            }
            qqSum.append(amount);
            qqSum.append(" sum(FEndBalanceDebit" + fieldSuffix + ") FEndBalanceDebitFor, \t\t\t\t\t\t\n");
            if (displayAmount) {
                qqSum.append(" sum(FEndCreditQty) FEndCreditQty, \t\t\t\t\t\t\n");
            }
            qqSum.append(" sum(FEndBalanceCredit" + fieldSuffix + ") FEndBalanceCreditFor, \t\t\t\t\t\n");
            selectFields.append("FEndBalanceDebit").append(fieldSuffix).append(",");
            if (displayAmount) {
                selectFields.append("FEndCreditQty,");
            }
            selectFields.append("FEndBalanceCredit").append(fieldSuffix).append(",");
        } else {
            if (displayAmount) {
                qqSum.append(" sum(FBeginDebitQty) FBeginDebitQty, \t\t\t\t\t\t\n");
                qqSum.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\t\n");
                qqSum.append(" sum(FBeginCreditQty) FBeginCreditQty, \t\t\t\t\t\t\n");
                qqSum.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \t\n");
                qqSum.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor,\n");
                qqSum.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal,\t\n");
                amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditFor) FCreditFor,\t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditLocal) FCreditLocal,\t\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
                amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t\t\t\t\n");
                amount.append(" sum(FYearCreditFor) FYearCreditFor, \t\t\t\t\t\n");
                amount.append(" sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\n");
                amount.append(" sum(FEndDebitQty) FEndDebitQty, \t\t\t\t\t\t\t\t\t\n");
                selectFields.append("FBeginDebitQty,FBeginBalanceDebitFor,FBeginBalanceDebitLocal,FBeginCreditQty,FBeginBalanceCreditFor,FBeginBalanceCreditLocal,FDebitQty,FDebitFor,FDebitLocal,FCreditQty,FCreditFor,FCreditLocal,FYearDebitQty,FYearDebitFor,FYearDebitLocal,FYearCreditQty,FYearCreditFor,FYearCreditLocal,FEndDebitQty,");
            } else {
                qqSum.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\t\n");
                qqSum.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \t\n");
                qqSum.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor,\n");
                qqSum.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal,\t\n");
                amount.append("sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
                amount.append("sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
                amount.append("sum(FCreditFor) FCreditFor, \t\t\t\t\t\t\t\t\n");
                amount.append("sum(FCreditLocal) FCreditLocal, \t\t\t\t\t\t\t\n");
                amount.append("sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t\t\n");
                amount.append("sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
                amount.append("sum(FYearCreditFor) FYearCreditFor, \t\t\t\t\t\t\n");
                amount.append("sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\t\n");
                selectFields.append("FBeginBalanceDebitFor,FBeginBalanceDebitLocal,FBeginBalanceCreditFor,FBeginBalanceCreditLocal,FDebitFor,FDebitLocal,FCreditFor,FCreditLocal,FYearDebitFor,FYearDebitLocal,FYearCreditFor,FYearCreditLocal,");
            }
            qqSum.append(amount);
            qqSum.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\t\n");
            qqSum.append(" sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal, \t\t\t\n");
            if (displayAmount) {
                amount.append(" sum(FEndCreditQty) FEndCreditQty, \t\t\t\t\t\t\n");
            }
            qqSum.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\t\t\n");
            qqSum.append(" sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal, \t\t\t\n");
            selectFields.append("FEndBalanceDebitFor,FEndBalanceDebitLocal,");
            if (displayAmount) {
                amount.append("FEndCreditQty,");
            }
            selectFields.append("FEndBalanceCreditFor,FEndBalanceCreditLocal,");
        }
        qqSum.append(" 0,0,'").append(GlUtils.getMaxChar()).append("',1  from ").append(tempTable).append(" t ");
        selectFields.append("FLevel,FIsLeaf,FOrderNumber,isTotal ");
        if (!showOnlySubAccountview) {
            qqSum.append(" inner join t_bd_accountview av on av.fid = t.faccountid ");
        }
        qqSum.append(" where 1 = 1 ");
        if (!showOnlySubAccountview) {
            int levelFrom = this.cond.getAccountLevelStart();
            qqSum.append(" and av.flevel = ").append(levelFrom);
        }
        if (!showOnlySubAccountview) {
            // empty if block
        }
        String sql = " select top 1 * from  " + tempTable;
        IRowSet set = DbUtil.executeQuery(ctx, sql);
        try {
            if (set != null && set.next()) {
                DbUtil.execute(ctx, "insert into " + tempTable + " (" + selectFields + ")select " + qqSum.toString());
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new SQLDataException(e);
        }
        if (!this.cond.isOptionDCDispatchAsst()) {
            this.updateBalanceDC4SumLine(ctx, tempTable, isBaseCurrencyQuery);
        }
    }

    @Override
    public void recycleTable() throws BOSException {
        if (!this.recycleTables.isEmpty()) {
            for (String table : this.recycleTables) {
                DbUtil.execute(this.ctx, "drop table " + table + " ");
            }
        }
    }

    private void updateBalanceDC4SumLine(Context ctx, String tempTable, boolean isBaseCurrencyQuery) throws EASBizException, BOSException {
        StringBuffer updatesql = this.getSqlUpdateSum4BalSameAsAcct(tempTable, isBaseCurrencyQuery);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("updateBalanceDC4SumLine/updatesql:" + updatesql));
        }
        DbUtil.execute(ctx, updatesql.toString());
    }

    private StringBuffer getSqlUpdateSum4BalSameAsAcct(String tempTable, boolean isBaseCurrencyQuery) {
        StringBuffer updatesql = new StringBuffer();
        updatesql.append(" update ").append(tempTable).append("  \r\n");
        updatesql.append(" set FBeginBalanceDebitFor = case when FBeginBalanceDebitFor - FBeginBalanceCreditFor >= 0 then FBeginBalanceDebitFor - FBeginBalanceCreditFor else 0 end ,  \r\n").append(" FBeginBalanceCreditFor = case when FBeginBalanceDebitFor - FBeginBalanceCreditFor < 0 then FBeginBalanceCreditFor - FBeginBalanceDebitFor  else 0 end ,  \r\n").append(" FEndBalanceDebitFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor >= 0 then FEndBalanceDebitFor  - FEndBalanceCreditFor else 0 end,  \r\n").append(" FEndBalanceCreditFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor < 0 then FEndBalanceCreditFor - FEndBalanceDebitFor else 0 end   \r\n");
        if (!isBaseCurrencyQuery) {
            updatesql.append(", FBeginBalanceDebitLocal = case when FBeginBalanceDebitLocal - FBeginBalanceCreditLocal > 0 then FBeginBalanceDebitLocal - FBeginBalanceCreditLocal else 0 end ,  \r\n").append(" FBeginBalanceCreditLocal = case when FBeginBalanceDebitLocal - FBeginBalanceCreditLocal < 0 then  FBeginBalanceCreditLocal - FBeginBalanceDebitLocal  else 0 end ,  \r\n").append(" FEndBalanceDebitLocal  = case when FEndBalanceDebitLocal  - FEndBalanceCreditLocal > 0 then  FEndBalanceDebitLocal  - FEndBalanceCreditLocal else 0 end,  \r\n").append(" FEndBalanceCreditLocal  = case when FEndBalanceDebitLocal  - FEndBalanceCreditLocal < 0 then  FEndBalanceCreditLocal - FEndBalanceDebitLocal   else 0 end   \r\n");
        }
        updatesql.append("where ((FBeginBalanceDebitFor<> 0 or FBeginBalanceCreditFor<> 0) or (FEndBalanceDebitFor<>0 or FEndBalanceCreditFor<>0)  \r\n");
        if (!isBaseCurrencyQuery) {
            updatesql.append(" or (FBeginBalanceDebitLocal<> 0 or FBeginBalanceCreditLocal<> 0) or (FEndBalanceDebitLocal<>0 and FEndBalanceCreditLocal<>0)  \r\n");
        }
        updatesql.append(" ) and fordernumber = '").append(GlUtils.getMaxChar()).append("'  \r\n");
        return updatesql;
    }

    private StringBuffer getSQL4InsertSumLvl12SelectPart(List<AsstactTypeEntity> rs, boolean displayAmount, boolean isBaseCurrencyQuery, String loc, boolean displayUnit, int asstTypeIndex) {
        StringBuffer s = new StringBuffer();
        int m = 0;
        s.append(" select  FaccountID,FaccountName,FaccountNumber, faccountdc").append(",D.FNumber FNumber").append(asstTypeIndex).append(",D.FLongNumber FLongNumber").append(asstTypeIndex).append(",D.FID FGPID").append(asstTypeIndex).append(",D.FID FID").append(asstTypeIndex).append(",D.FName_").append(loc).append(" FName" + asstTypeIndex + ", ");
        for (m = 0; m < rs.size(); ++m) {
            if (m != asstTypeIndex) {
                s.append("\n A.FNumber").append(m).append(", A.FLongNumber").append(m).append(", A.FID").append(m).append(",A.FName").append(m).append(",  \r\n");
                continue;
            }
            this.logDebug("continue_log");
        }
        if (displayAmount) {
            if (isBaseCurrencyQuery) {
                s.append("\n sum(FBeginDebitQty), sum(FBeginBalanceDebitFor), sum(FBeginCreditQty),sum(FBeginBalanceCreditFor), sum(FDebitQty), sum(FDebitFor), sum(FCreditQty), sum(FCreditFor),");
                s.append(" sum(FYearDebitQty), sum(FYearDebitFor), sum(FYearCreditQty), sum(FYearCreditFor), sum(FEndDebitQty), sum(FEndBalanceDebitFor),sum(FEndCreditQty), sum(FEndBalanceCreditFor),");
            } else {
                s.append("\n sum(FBeginDebitQty),").append("sum(FBeginBalanceDebitFor),sum(FBeginBalanceDebitLocal),").append("\n sum(FBeginCreditQty),").append("sum(FBeginBalanceCreditFor), sum(FBeginBalanceCreditLocal),").append("sum(FDebitQty) FDebitQty,").append("sum(FDebitFor), sum(FDebitLocal),").append("sum(FCreditQty) FCreditQty,").append("sum(FCreditFor),sum(FCreditLocal),").append("sum(FYearDebitQty) FYearDebitQty,").append("sum(FYearDebitFor),sum(FYearDebitLocal),").append("sum(FYearCreditQty) FYearCreditQty,").append("sum(FYearCreditFor),sum(FYearCreditLocal),").append("sum(FEndDebitQty) FEndDebitQty,").append("sum(FEndBalanceDebitFor),sum(FEndBalanceDebitLocal),").append("sum(FEndCreditQty) FEndCreditQty,").append("sum(FEndBalanceCreditFor),sum(FEndBalanceCreditLocal),");
            }
        } else if (isBaseCurrencyQuery) {
            s.append("\n sum(FBeginBalanceDebitFor), sum(FBeginBalanceCreditFor), sum(FDebitFor), sum(FCreditFor), sum(FYearDebitFor), sum(FYearCreditFor), sum(FEndBalanceDebitFor), sum(FEndBalanceCreditFor),");
        } else {
            s.append("\n sum(FBeginBalanceDebitFor),sum(FBeginBalanceDebitLocal),").append("sum(FBeginBalanceCreditFor), sum(FBeginBalanceCreditLocal),").append("sum(FDebitFor), sum(FDebitLocal),").append("sum(FCreditFor),sum(FCreditLocal),").append("sum(FYearDebitFor),sum(FYearDebitLocal),").append("sum(FYearCreditFor),sum(FYearCreditLocal),").append("sum(FEndBalanceDebitFor),sum(FEndBalanceDebitLocal), ").append("sum(FEndBalanceCreditFor),sum(FEndBalanceCreditLocal),");
        }
        s.append(" D.FLevel, 0, ");
        if (displayUnit) {
            s.append(" A.muId, A.muName ,");
        }
        s.append(" D.FLongNumber||'!!!'").append("  \r\n");
        return s;
    }

    private StringBuffer getSQL4InsertSumLvl1From(String tempTable, List<AsstactTypeEntity> rs, String loc, boolean displayUnit, boolean isCsspGroup, String groupTable, String standardTable, String detail, String fGDcsspGroupID, String fGDcsspGroupStandardID, String fmappingfieldname, AcctountAsstItemParser.AccountAsstItem accountAsstItem, int asstTypeIndex) {
        StringBuffer s = new StringBuffer();
        s.append(" from ").append(tempTable);
        if (isCsspGroup) {
            AcctountAsstItemParser.Group[] groups = accountAsstItem.asstItems[0].group;
            AcctountAsstItemParser.Group group = accountAsstItem.asstItems[0].group[0];
            s.append(" A \n inner join ").append(detail).append(" B on B.").append(fmappingfieldname).append("=A.FID0\n").append("inner join ").append(standardTable).append(" GS on GS.FID = B.").append(fGDcsspGroupStandardID).append(" inner join ").append(groupTable).append(" D on d.FID =  B.").append(fGDcsspGroupID);
            s.append(" \r\nwhere GS.fnumber = '").append(group.standardNumber).append("'");
            for (int i = 1; i < groups.length; ++i) {
                s.append(" and GS.fnumber = '").append(groups[i].standardNumber).append("'");
            }
        } else {
            s.append(" A \n inner join ").append(groupTable).append(" D  on D.FID=A.FGPID0 ");
        }
        s.append(" \n group by D.FLongNumber, D.FNumber, D.FID, D.FName_").append(loc).append(", ").append("    FaccountID,FaccountName,FaccountNumber, faccountdc");
        if (displayUnit) {
            s.append(" ,A.muId, A.muName");
        }
        for (int m = 0; m < rs.size(); ++m) {
            if (m != asstTypeIndex) {
                s.append("\n ,A.FNumber").append(m).append(", A.FLongNumber").append(m).append(", A.FID").append(m).append(",A.FName").append(m).append("");
                continue;
            }
            this.logDebug("omit");
        }
        s.append(",D.FLevel");
        return s;
    }

    private StringBuffer getSQL4InsertSumLvl2From(String tempTable, List<AsstactTypeEntity> rs, String loc, boolean displayUnit, String groupTable, int asstTypeIndex) {
        StringBuffer fromWhereSQL = new StringBuffer();
        fromWhereSQL.append(" from ").append(tempTable).append(" A \n").append(" inner join ").append(groupTable).append(" C ").append(" on C.FID = A.FID").append(asstTypeIndex).append(" and C.FLevel=? \n ").append(" inner join ").append(groupTable).append(" D ").append(" on D.FID=C.FParentID");
        fromWhereSQL.append(" \n group by D.FLongNumber,D.FNumber, D.FID, D.FName_").append(loc).append(",FaccountID,FaccountName,FaccountNumber, faccountdc");
        if (displayUnit) {
            fromWhereSQL.append(",A.muId, A.muName");
        }
        for (int m = 0; m < rs.size(); ++m) {
            if (m == asstTypeIndex) continue;
            fromWhereSQL.append("\n ,A.FNumber").append(m).append(", A.FLongNumber").append(m).append(", A.FID").append(m).append(", A.FName").append(m).append("");
        }
        fromWhereSQL.append(",D.FLevel");
        return fromWhereSQL;
    }

    private StringBuffer getSQL4InsertSumLvl1Select(String tempTable, List<AsstactTypeEntity> rs, boolean displayAmount, boolean isBaseCurrencyQuery, String loc, boolean displayUnit, boolean isCsspGroup, String groupTable, String standardTable, String detail, String fGDcsspGroupID, String fGDcsspGroupStandardID, String fmappingfieldname, AcctountAsstItemParser.AccountAsstItem accountAsstItem, int asstTypeIndex) {
        StringBuffer s = new StringBuffer();
        s.append(this.getSQL4InsertSumLvl12SelectPart(rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, asstTypeIndex));
        s.append(this.getSQL4InsertSumLvl1From(tempTable, rs, loc, displayUnit, isCsspGroup, groupTable, standardTable, detail, fGDcsspGroupID, fGDcsspGroupStandardID, fmappingfieldname, accountAsstItem, asstTypeIndex));
        return s;
    }

    private StringBuffer getSQL4InsertSumLvl2Select(String tempTable, List<AsstactTypeEntity> rs, boolean displayAmount, boolean isBaseCurrencyQuery, String loc, boolean displayUnit, String groupTable, int asstTypeIndex) {
        StringBuffer s = new StringBuffer();
        s.append(this.getSQL4InsertSumLvl12SelectPart(rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, asstTypeIndex));
        s.append(this.getSQL4InsertSumLvl2From(tempTable, rs, loc, displayUnit, groupTable, asstTypeIndex));
        return s;
    }

    private String getMainTable(boolean includeUnPost, boolean displayUnit, boolean showFor, boolean showRpt, boolean showLocal) {
        String tableSuffix;
        String string = tableSuffix = includeUnPost ? "1" : "5";
        tableSuffix = showFor ? tableSuffix + "F" : (showLocal && !showRpt ? tableSuffix + "L" : (showRpt && !showLocal ? tableSuffix + "R" : tableSuffix + "F"));
        if (displayUnit) {
            return "T_GL_AssistMeasureBalance_" + tableSuffix;
        }
        return "T_GL_AssistBalance_" + tableSuffix;
    }

    private static class DbUtil {
        private DbUtil() {
        }

        public static void execute(Context ctx, String sql) throws BOSException {
            try {
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }

        public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
            try {
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }

        public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
            try {
                return com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }

        public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
            try {
                return com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }
    }
}

