/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.GLRptAssistBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAmountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItemInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GLRptAsstItemBalPageQuery
extends GLRptPageQuery {
    private CompanyOrgUnitInfo company;
    private List asstActList = new ArrayList();
    protected boolean isCreateDataTempTable;

    public GLRptAsstItemBalPageQuery(Context ctx, GLRptAssistBalanceCondition cond, CompanyOrgUnitInfo company, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        super(ctx, cond);
        this.company = company;
        this.isCreateDataTempTable = isCreateDataTempTable;
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        this.initAsstActList();
        return super.getSQL();
    }

    protected void initAsstActList() throws BOSException {
        String pageFilter;
        this.asstActList.clear();
        StringBuffer sql = new StringBuffer();
        ArrayList sp = new ArrayList();
        sql.append("select distinct t.").append(GLRptField.actTypeID);
        sql.append(" from ").append(this.getDataSourceTableName()).append(" t ");
        if (this.isSeqTable() && (pageFilter = this.getPageFilter("t", sp)) != null && pageFilter.length() > 0) {
            sql.append(" where ").append(pageFilter);
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString(), (Object[])sp.toArray());
        try {
            while (rs.next()) {
                AsstactTypeEntity at = this.getAsstactTypeEntity(rs.getString(GLRptField.actTypeID.getName()));
                if (at == null) continue;
                this.asstActList.add(at);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
    }

    private AsstactTypeEntity getAsstactTypeEntity(String actTypeId) {
        if (actTypeId == null) {
            return null;
        }
        for (AsstactTypeEntity at : ((GLRptAssistBalanceCondition)this.getCond()).getAsstActList()) {
            if (!at.getId().equals(actTypeId)) continue;
            return at;
        }
        return null;
    }

    @Override
    protected String getJoinDataBaseSQL() throws BOSException, EASBizException {
        this.initAsstActList();
        StringBuffer sql = new StringBuffer();
        this.joinAccountView(sql);
        this.joinCurrency(sql);
        this.joinAsstactType(sql);
        return sql.toString();
    }

    private void joinAsstactType(StringBuffer sql) {
        if (this.sumItem == null || this.sumItem != null && this.sumItem.getFields().contains(GLRptField.actTypeName)) {
            StringBuffer subTyQuery = new StringBuffer();
            Iterator it = this.asstActList.iterator();
            AsstactTypeEntity at = null;
            if (it.hasNext()) {
                at = (AsstactTypeEntity)it.next();
            }
            subTyQuery.append(" select ").append(at == null ? "to_char(null)" : "'" + at.getId() + "'").append(" fid, ").append(at == null ? "to_char(null)" : "N'" + at.getNumber() + "'").append(" fnumber, ").append(at == null ? "to_char(null)" : "N'" + at.getName() + "'").append(" fname_").append(this.getCtx().getLocale().toString());
            while (it.hasNext()) {
                at = (AsstactTypeEntity)it.next();
                subTyQuery.append(" union all ");
                subTyQuery.append(" select '").append(at.getId()).append("' fid, N'").append(at.getNumber()).append("' fnumber, N'").append(at.getName()).append("' fname_").append(this.getCtx().getLocale().toString());
            }
            sql.append(" left outer join (").append(subTyQuery).append(") actType on actType.fid = ").append(this.getMainTable().getAlias()).append(".").append(GLRptField.actTypeID);
        }
    }

    private void joinCurrency(StringBuffer sql) {
        if (this.getCond().isAllCurrency() && (this.sumItem == null || this.sumItem != null && this.sumItem.getFields().contains(GLRptField.currencyName))) {
            sql.append(" left outer join t_bd_currency cy on cy.fid = ").append(this.getMainTable().getAlias()).append(".").append(GLRptField.currencyID);
        }
    }

    private void joinAccountView(StringBuffer sql) {
        if (this.sumItem == null || this.sumItem != null && (this.sumItem.getFields() == null || this.sumItem.getFields().contains(GLRptField.accountName) || this.sumItem.getFields().contains(GLRptField.accountNumber))) {
            if (this.getCtx().get((Object)"isPca") != null) {
                sql.append(" left outer join t_bd_accountview av on av.fid = ").append(this.getMainTable().getAlias()).append(".").append(GLRptField.accountID);
            } else {
                sql.append(" left outer join t_bd_accountview av on av.fid = ").append(this.getMainTable().getAlias()).append(".").append(GLRptField.accountID).append(" and av.fcompanyid = '").append(this.company.getId().toString()).append("'");
            }
        }
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String where;
        if (this.isSeqTable() && this.sumItem == null) {
            return super.getWhereSQL();
        }
        StringBuffer sql = new StringBuffer();
        int endPeriod = this.getCond().getPeriodYearEnd() * 100 + this.getCond().getPeriodNumberEnd();
        int startPeriod = this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart();
        sql.append(" ((t.fperiod >= ").append(startPeriod).append(" and t.fperiod <= ").append(endPeriod).append(")");
        if (startPeriod != endPeriod || this.getCond().isAfterCurrPeriod()) {
            this.setAmountFilter(sql);
        }
        if ((where = super.getWhereSQL()) != null && where.trim().length() > 0) {
            sql.append(" and ").append(where);
        }
        if (this.sumItems != null) {
            sql.append(" or (").append(this.getTotalRecordFilter()).append(")");
        }
        sql.append(")");
        if (this.getCond().isAfterCurrPeriod()) {
            sql.append(" and t.").append("FIsAfterCurrPeriod").append(" = 0 ");
        }
        return sql.toString();
    }

    private void setAmountFilter(StringBuffer sql) throws EASBizException, BOSException {
        String amountFilter = new GLRptAmountFilter(this.getCond(), "tp").getSQL();
        if (amountFilter != null && amountFilter.trim().length() > 0) {
            if (sql.length() > 0) {
                sql.append(" and ");
            }
            if (this.getCond().isOptionAmountZero() || this.getCond().isOptionAmountAndBalZero()) {
                int startPeriod = this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart();
                sql.append(" exists (").append("select 1 from ( ");
                sql.append(" SELECT fasstitemid, itemnumber, itemname, facttypefid, faccountid ");
                if (this.getCond().isAllCurrency()) {
                    sql.append(",fcurrencyid ");
                }
                sql.append(" FROM (select fasstitemid,itemnumber,itemname,facttypefid,faccountid ");
                if (this.getCond().isAllCurrency()) {
                    sql.append(",fcurrencyid ");
                }
                sql.append(",count(*) cc ");
                sql.append(" from ").append(this.getDataSourceTableName()).append(" where ");
                if (this.getCond().isOptionAmountZero()) {
                    if (this.getCond().isShowFor()) {
                        sql.append("((FDebitFor <> 0) OR (FCreditFor <> 0)) and ");
                    } else if (this.getCond().isShowLocal()) {
                        sql.append("((FDebitLocal <> 0) OR (FCreditLocal <> 0)) and ");
                    }
                } else if (this.getCond().isOptionAmountAndBalZero()) {
                    if (this.getCond().isShowFor()) {
                        sql.append("((FDebitFor <> 0) OR (FCreditFor <> 0) OR (FEndBalanceFor <> 0)) and ");
                    } else if (this.getCond().isShowLocal()) {
                        sql.append("((FDebitLocal <> 0) OR (FCreditLocal <> 0) OR (FEndBalanceLocal <> 0)) and ");
                    }
                }
                sql.append(" fperiod >= ").append(startPeriod);
                sql.append(" group by fasstitemid, itemnumber, itemname, facttypefid, faccountid ");
                if (this.getCond().isAllCurrency()) {
                    sql.append(",fcurrencyid ");
                }
                sql.append(" ) ss where ss.cc > 0 ");
                sql.append(" ) tp ");
            } else {
                sql.append(" exists (").append("select 1 from ").append(this.getDataSourceTableName()).append(" tp ");
            }
            sql.append(" where ").append(this.getMainTable().getAlias()).append(".fasstitemid = tp.fasstitemid ");
            sql.append(" and ").append(this.getMainTable().getAlias()).append(".faccountid = tp.faccountid ");
            if (this.getCond().isAllCurrency()) {
                sql.append(" and ").append(this.getMainTable().getAlias()).append(".fcurrencyid = tp.fcurrencyid ");
            }
            if (!this.getCond().isOptionAmountZero() && !this.getCond().isOptionAmountAndBalZero()) {
                sql.append(" and (").append(amountFilter).append(")");
                sql.append(" and ").append(this.getMainTable().getAlias()).append(".fperiod = tp.fperiod ");
            }
            sql.append(")");
        }
    }

    protected String getTotalRecordFilter() {
        StringBuffer sql = new StringBuffer();
        Iterator it = this.sumItems.getSumItems().iterator();
        GLRptSumItemInfo item = (GLRptSumItemInfo)it.next();
        sql.append(" t.").append(item.getName()).append(" = 1 ");
        while (it.hasNext()) {
            item = (GLRptSumItemInfo)it.next();
            sql.append(" or t.").append(item.getName()).append(" = 1 ");
        }
        return sql.toString();
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException {
        GLRptSQLOrder order = new GLRptSQLOrder();
        order.add("t.isTotal");
        if (this.getCond().isAllCurrency()) {
            order.add("t.currencyIsTotal");
        }
        order.add(GLRptField.actTypeNumber.getSelect());
        GLRptAssistBalanceCondition condition = (GLRptAssistBalanceCondition)this.getCond();
        if (condition.isShowAsstItemTotal()) {
            order.add("t.actTypeIsTotal");
        }
        order.add(GLRptField.asstItemNumber.getSelect());
        if (condition.isShowAsstItemTotal()) {
            order.add("t.actItemIsTotal");
        }
        if (this.getCond().isAllCurrency()) {
            order.add(GLRptField.currencyNumber.getSelect());
        }
        order.add(GLRptField.accountNumber.getSelect());
        order.add("t." + GLRptField.period.getName());
        return order;
    }
}

