/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGGCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptCache;
import com.kingdee.eas.fi.gl.rpt.GLRptException;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptRowData;
import com.kingdee.eas.fi.gl.rpt.TOTAL;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAmountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactGGPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItems;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GLRptAsstactBalGGDao
extends AbstractGLRptDao {
    protected GLRptAsstactGGCondition cond;
    protected boolean isShowAsstItem = false;
    protected boolean isPrintTotal = false;
    private AsstActTypeInfo accountingAsstActType = null;
    private Map<String, BigDecimal> loadedAsstActIDToQtyCoefficient = new HashMap<String, BigDecimal>();
    private Map<String, BigDecimal> loadedAccountIDToQtyCoefficient = new HashMap<String, BigDecimal>();
    private Context ctx;
    private boolean isFromElRec = false;

    public GLRptAsstactBalGGDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
        this.ctx = ctx;
    }

    protected boolean getOrgIsBizUnit() {
        return this.cond.getCompany().isIsBizUnit();
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        Object isisPrintTotalObj;
        GLRptCache cache;
        super.init(ev);
        this.cond = (GLRptAsstactGGCondition)this.getQueryCondition();
        if (ev.get("isFromElRec") != null) {
            this.isFromElRec = Boolean.valueOf(ev.get("isFromElRec").toString());
        }
        if (this.cond.getDataSourceTable() != null && (cache = GLRptCache.getGLRptCache(this.getContex(), this.cond.getDataSourceTable())) == null && !this.isFromElRec) {
            throw new GLRptException(GLRptException.SESSION_INVALID);
        }
        Object isisShowAsstItemObj = ev.get("isShowAsstItem");
        if (isisShowAsstItemObj != null && isisShowAsstItemObj instanceof Boolean) {
            this.isShowAsstItem = (Boolean)isisShowAsstItemObj;
        }
        if ((isisPrintTotalObj = ev.get("isPrintTotal")) != null && isisPrintTotalObj instanceof Boolean) {
            this.isPrintTotal = (Boolean)isisPrintTotalObj;
        }
        if (this.isFromElRec) {
            this.isShowAsstItem = true;
        }
    }

    @Override
    protected void setRow1Title(List colTitles, GLRptField field) {
        if (field == GLRptField.beginAccountDC) {
            colTitles.add(GLRptField.beginBalanceFor.getTitle());
        } else if (field == GLRptField.endAccountDC) {
            colTitles.add(GLRptField.endBalanceFor.getTitle());
        } else {
            super.setRow1Title(colTitles, field);
        }
    }

    @Override
    protected void buildData() throws BOSException, EASBizException {
        String amountFilter;
        this.insertData();
        if (this.isInsertAfterCurrPeriodBalance() && this.cond.isAfterCurrPeriod()) {
            this.insertFuturePeriodBalance();
        }
        if (this.cond.isNotIncluePLVoucher()) {
            this.updateNotPLBal();
        }
        if ((amountFilter = new GLRptAmountFilter(this.cond, "t").getSQL()) != null && amountFilter.trim().length() > 0) {
            amountFilter = amountFilter.replace(" or ", " and ");
            amountFilter = amountFilter.replace(" <> ", " = ");
            String sql = "delete from " + this.getDataSourceTableName() + " t where " + amountFilter;
            DbUtil.execute((Context)this.ctx, (String)sql);
        }
        if (this.isGroupByCompany()) {
            this.insertCompanyLevelSumData();
        }
        if (!this.cond.isShowLeafAccount()) {
            this.insertLevelSumData(GLRptField.accountID, "t_bd_accountview", "av", 1);
        }
        this.insertSumItem();
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        GLRptBalQuery query = this.getRptAsstactBalQuery(this.getContex(), (OrgUnitInfo)this.getCompany(), this.cond, this.isQueryMeasureUnitBalance(), this.isCreateDataTempTable());
        query.setSelector(this.getGLRptSelector());
        String sql = query.getSQL();
        this.insertData(sql);
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode() && !this.cond.isShowLeafAccount()) {
            try {
                this.createIndex(this.getDataSourceTableName(), "FAccountID");
            }
            catch (Exception e) {
                throw new BOSException("\u8f85\u52a9\u603b\u8d26\u4e34\u65f6\u8868\u521b\u5efa\u7d22\u5f15\u5931\u8d25\uff1a" + e);
            }
            sql = "delete from " + this.getDataSourceTableName() + " t where exists (select 1 from t_bd_accountview av where av.fid = t.faccountid and av.fisleaf = 0) ";
            DbUtil.execute((Context)this.ctx, (String)sql);
        }
    }

    @Override
    protected void insertSumItem() throws EASBizException, BOSException {
        super.insertSumItem();
    }

    @Override
    protected boolean isInsertAfterCurrPeriodBalance() {
        return true;
    }

    private void updateNotPLBal() throws BOSException, EASBizException {
        String periodTypeId = this.cond.getPeriodTypeId();
        int startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        PeriodCollection pc = GLRptDaoUtil.getPeriodCollection(this.getContex(), periodTypeId, startPeriod, endPeriod);
        PeriodInfo lastPeriod = null;
        for (int i = 0; i < pc.size(); ++i) {
            PeriodInfo period = pc.get(i);
            if (lastPeriod != null) {
                StringBuffer sql = new StringBuffer();
                sql.append("update ").append(this.getDataSourceTableName());
                sql.append(" set (").append(this.getUpdateAmountField(false));
                sql.append(") = (select ").append(this.getQueryAmountField(period));
                sql.append(" from (select ").append(this.getUpdateJoinField(false));
                sql.append(",").append(this.getUpdateAmountField(true));
                sql.append(" from ").append(this.getDataSourceTableName());
                sql.append(" where ").append(GLRptField.period.getName());
                sql.append(" = ").append(lastPeriod.getNumber()).append(") t");
                sql.append(" where ").append(this.getUpdateJoinField(true)).append(")");
                sql.append(" where fperiod = ").append(period.getNumber());
                this.execute(sql.toString());
            }
            lastPeriod = period;
        }
    }

    private String getUpdateJoinField(boolean isJoin) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null || "NUMERIC(29,10)".equals(field.getType()) || field == GLRptField.period) continue;
            if (first) {
                first = false;
            } else {
                sql.append(isJoin ? " and " : ",");
            }
            if (isJoin) {
                sql.append(" t.").append(field.getName().substring(1)).append(" = ").append(field.getName());
                continue;
            }
            sql.append(field.getName()).append(" ").append(field.getName().substring(1));
        }
        return sql.toString();
    }

    private String getUpdateAmountField(boolean isAlias) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.isShowQty()) {
            this.addField(sql, GLRptField.beginQty.getName(), isAlias);
            this.addField(sql, GLRptField.yearDebitQty.getName(), isAlias);
            this.addField(sql, GLRptField.yearCreditQty.getName(), isAlias);
            this.addField(sql, GLRptField.endQty.getName(), isAlias);
        }
        if (this.isShowFor()) {
            this.addField(sql, GLRptField.beginBalanceFor.getName(), isAlias);
            this.addField(sql, GLRptField.yearDebitFor.getName(), isAlias);
            this.addField(sql, GLRptField.yearCreditFor.getName(), isAlias);
            this.addField(sql, GLRptField.endBalanceFor.getName(), isAlias);
        }
        if (this.isShowLocal()) {
            this.addField(sql, GLRptField.beginBalanceLocal.getName(), isAlias);
            this.addField(sql, GLRptField.yearDebitLocal.getName(), isAlias);
            this.addField(sql, GLRptField.yearCreditLocal.getName(), isAlias);
            this.addField(sql, GLRptField.endBalanceLocal.getName(), isAlias);
        }
        if (this.isShowRpt()) {
            this.addField(sql, GLRptField.beginBalanceRpt.getName(), isAlias);
            this.addField(sql, GLRptField.yearDebitRpt.getName(), isAlias);
            this.addField(sql, GLRptField.yearCreditRpt.getName(), isAlias);
            this.addField(sql, GLRptField.endBalanceRpt.getName(), isAlias);
        }
        return sql.toString();
    }

    private String getQueryAmountField(PeriodInfo period) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.isShowQty()) {
            this.addField(sql, "isnull(t." + GLRptField.endQty.getName().substring(1) + ",0)");
            if (period.getPeriodNumber() == 1) {
                this.addField(sql, " 0 + " + GLRptField.debitQty.getName());
                this.addField(sql, " 0 + " + GLRptField.creditQty.getName());
            } else {
                this.addField(sql, "isnull(t." + GLRptField.yearDebitQty.getName().substring(1) + ",0) + " + GLRptField.debitQty.getName());
                this.addField(sql, "isnull(t." + GLRptField.yearCreditQty.getName().substring(1) + ",0) + " + GLRptField.creditQty.getName());
            }
            this.addField(sql, "isnull(t." + GLRptField.endQty.getName().substring(1) + ",0) + " + GLRptField.debitQty.getName() + " - " + GLRptField.creditQty.getName());
        }
        if (this.isShowFor()) {
            this.addField(sql, "isnull(t." + GLRptField.endBalanceFor.getName().substring(1) + ",0)");
            if (period.getPeriodNumber() == 1) {
                this.addField(sql, " 0 + " + GLRptField.debitFor.getName());
                this.addField(sql, " 0 + " + GLRptField.creditFor.getName());
            } else {
                this.addField(sql, "isnull(t." + GLRptField.yearDebitFor.getName().substring(1) + ",0) + " + GLRptField.debitFor.getName());
                this.addField(sql, "isnull(t." + GLRptField.yearCreditFor.getName().substring(1) + ",0) + " + GLRptField.creditFor.getName());
            }
            this.addField(sql, "isnull(t." + GLRptField.endBalanceFor.getName().substring(1) + ",0) + " + GLRptField.debitFor.getName() + " - " + GLRptField.creditFor.getName());
        }
        if (this.isShowLocal()) {
            this.addField(sql, "isnull(t." + GLRptField.endBalanceLocal.getName().substring(1) + ",0)");
            if (period.getPeriodNumber() == 1) {
                this.addField(sql, " 0 + " + GLRptField.debitLocal.getName());
                this.addField(sql, " 0 + " + GLRptField.creditLocal.getName());
            } else {
                this.addField(sql, "isnull(t." + GLRptField.yearDebitLocal.getName().substring(1) + ",0) + " + GLRptField.debitLocal.getName());
                this.addField(sql, "isnull(t." + GLRptField.yearCreditLocal.getName().substring(1) + ",0) + " + GLRptField.creditLocal.getName());
            }
            this.addField(sql, "isnull(t." + GLRptField.endBalanceLocal.getName().substring(1) + ",0) + " + GLRptField.debitLocal.getName() + " - " + GLRptField.creditLocal.getName());
        }
        if (this.isShowRpt()) {
            this.addField(sql, "isnull(t." + GLRptField.endBalanceRpt.getName().substring(1) + ",0)");
            if (period.getPeriodNumber() == 1) {
                this.addField(sql, " 0 + " + GLRptField.debitRpt.getName());
                this.addField(sql, " 0 + " + GLRptField.creditRpt.getName());
            } else {
                this.addField(sql, "isnull(t." + GLRptField.yearDebitRpt.getName().substring(1) + ",0) + " + GLRptField.debitRpt.getName());
                this.addField(sql, "isnull(t." + GLRptField.yearCreditRpt.getName().substring(1) + ",0) + " + GLRptField.creditRpt.getName());
            }
            this.addField(sql, "isnull(t." + GLRptField.endBalanceRpt.getName().substring(1) + ",0) + " + GLRptField.debitRpt.getName() + " - " + GLRptField.creditRpt.getName());
        }
        return sql.toString();
    }

    private void addField(StringBuffer sql, String field) {
        if (sql.length() > 0) {
            sql.append(",");
        }
        sql.append(field);
    }

    private void addField(StringBuffer sql, String field, boolean isAlias) {
        if (sql.length() > 0) {
            sql.append(",");
        }
        sql.append(field);
        if (isAlias) {
            sql.append(" ").append(field.substring(1));
        }
    }

    protected boolean isQueryMeasureUnitBalance() {
        return this.isShowQty() && this.cond.getMeasureUnitId() != null;
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        super.doGLRptRowData(rowSet);
        Object dcObj = rowSet.getObject(GLRptField.beginAccountDC.getName());
        if (dcObj != null && dcObj instanceof BalanceDirectionEnum && this.cond.getRptParams().isBalanceDirSamAsAccount()) {
            BalanceDirectionEnum dc = (BalanceDirectionEnum)rowSet.getObject(GLRptField.beginAccountDC.getName());
            this.setAmountWithAccountDC(rowSet, dc);
        } else {
            this.setAmountAndDC(rowSet, "begin");
            this.setAmountAndDC(rowSet, "end");
        }
        this.setEqualDC(rowSet, "begin");
        this.setEqualDC(rowSet, "end");
        this.setChildrenNode(rowSet);
        if (this.cond.isShowQty() && this.cond.getMeasureUnitId() == null) {
            this.setQty(rowSet);
        }
    }

    @Override
    protected void updateField(IRowSet rs, GLRptRowSet rowData, String colName, Object value) throws BOSException, EASBizException, SQLException {
        super.updateField(rs, rowData, colName, value);
        if (value != null && GLRptField.period.getName().equalsIgnoreCase(colName)) {
            int period = Integer.parseInt(value.toString());
            rowData.updateObject(colName, period / 100 + "." + period % 100);
        } else if ((GLRptField.beginAccountDC.getName().equalsIgnoreCase(colName) || GLRptField.endAccountDC.getName().equalsIgnoreCase(colName)) && this.cond.getRptParams().isBalanceDirSamAsAccount() && value != null) {
            int dc = Integer.parseInt(value.toString());
            rowData.updateObject(colName, BalanceDirectionEnum.getEnum((int)dc));
        }
    }

    protected void setChildrenNode(GLRptRowSet rowSet) throws BOSException {
        if (!this.getOrgIsBizUnit()) {
            GLRptTreeNode node = (GLRptTreeNode)rowSet.getObject(this.getOrgUnitNameField().getName());
            if (node.getParentNode() != null) {
                if (this.isAllCurrency()) {
                    rowSet.updateObject(GLRptField.currencyName.getName(), null);
                }
                rowSet.updateObject(GLRptField.accountName.getName(), null);
                rowSet.updateObject(GLRptField.accountNumber.getName(), null);
            }
        } else if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() && rowSet.getInt("companyIsTotal") == 0 && rowSet.getInt("accountIsTotal") == 0) {
            rowSet.updateObject(GLRptField.accountNameMerger.getName(), null);
            rowSet.updateObject(GLRptField.accountNumberMerger.getName(), null);
        }
        if (rowSet.getInt("accountIsTotal") == 1) {
            rowSet.updateObject(GLRptField.accountNumber.getName(), TOTAL.getSubTotal(this.getContex()));
        }
    }

    protected void setQty(GLRptRowSet rowSet) throws BOSException, EASBizException {
        if (this.cond.getRptParams().isQtyAsst()) {
            if (rowSet.getBigDecimal(GLRptField.beginQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.beginQty.getName(), rowSet.getBigDecimal(GLRptField.beginQty.getName()).divide(this.getAsstQtyCoefficient(rowSet), this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal(GLRptField.debitQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.debitQty.getName(), rowSet.getBigDecimal(GLRptField.debitQty.getName()).divide(this.getAsstQtyCoefficient(rowSet), this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal(GLRptField.creditQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.creditQty.getName(), rowSet.getBigDecimal(GLRptField.creditQty.getName()).divide(this.getAsstQtyCoefficient(rowSet), this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal(GLRptField.yearDebitQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.yearDebitQty.getName(), rowSet.getBigDecimal(GLRptField.yearDebitQty.getName()).divide(this.getAsstQtyCoefficient(rowSet), this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal(GLRptField.yearCreditQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.yearCreditQty.getName(), rowSet.getBigDecimal(GLRptField.yearCreditQty.getName()).divide(this.getAsstQtyCoefficient(rowSet), this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal(GLRptField.endQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.endQty.getName(), rowSet.getBigDecimal(GLRptField.endQty.getName()).divide(this.getAsstQtyCoefficient(rowSet), this.cond.getQtyScale(), 4));
            }
        } else {
            String accountId = rowSet.getString(GLRptField.accountID.getName());
            if (rowSet.getBigDecimal(GLRptField.beginQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.beginQty.getName(), rowSet.getBigDecimal(GLRptField.beginQty.getName()).divide(this.getAccountQtyCoefficient(accountId), 10, 4));
            }
            if (rowSet.getBigDecimal(GLRptField.debitQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.debitQty.getName(), rowSet.getBigDecimal(GLRptField.debitQty.getName()).divide(this.getAccountQtyCoefficient(accountId), 10, 4));
            }
            if (rowSet.getBigDecimal(GLRptField.creditQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.creditQty.getName(), rowSet.getBigDecimal(GLRptField.creditQty.getName()).divide(this.getAccountQtyCoefficient(accountId), 10, 4));
            }
            if (rowSet.getBigDecimal(GLRptField.yearDebitQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.yearDebitQty.getName(), rowSet.getBigDecimal(GLRptField.yearDebitQty.getName()).divide(this.getAccountQtyCoefficient(accountId), 10, 4));
            }
            if (rowSet.getBigDecimal(GLRptField.yearCreditQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.yearCreditQty.getName(), rowSet.getBigDecimal(GLRptField.yearCreditQty.getName()).divide(this.getAccountQtyCoefficient(accountId), 10, 4));
            }
            if (rowSet.getBigDecimal(GLRptField.endQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.endQty.getName(), rowSet.getBigDecimal(GLRptField.endQty.getName()).divide(this.getAccountQtyCoefficient(accountId), 10, 4));
            }
        }
    }

    protected BigDecimal getAsstQtyCoefficient(GLRptRowSet rs) throws BOSException, EASBizException {
        BigDecimal accountingCoefficient = null;
        if (this.accountingAsstActType == null) {
            for (int i = 0; i < this.cond.getAsstActList().size(); ++i) {
                AsstactTypeEntity asstactTypeEntity = (AsstactTypeEntity)this.cond.getAsstActList().get(i);
                if (!asstactTypeEntity.isQtyAsst()) continue;
                IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)this.ctx);
                this.accountingAsstActType = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstactTypeEntity.getId()));
                break;
            }
        }
        if (this.accountingAsstActType == null) {
            accountingCoefficient = GlUtils.one;
        } else {
            String asstActId = null;
            if (this.cond.getSelectedItem() != null && this.cond.getSelectedItem().size() == 1) {
                GLRptRowSet selectedItem = this.cond.getSelectedItem();
                asstActId = selectedItem.getString(0, this.accountingAsstActType.getMappingFieldName());
            } else {
                asstActId = rs.indexOf(this.accountingAsstActType.getMappingFieldName()) < 0 ? null : rs.getString(this.accountingAsstActType.getMappingFieldName());
            }
            accountingCoefficient = this.loadedAsstActIDToQtyCoefficient.get(asstActId);
            if (accountingCoefficient != null) {
                return accountingCoefficient;
            }
            if (asstActId == null) {
                accountingCoefficient = GlUtils.one;
            } else if (this.accountingAsstActType.getGlAsstActTypeGrp() != null) {
                GeneralAsstActTypeInfo accountingAsstAct = GeneralAsstActTypeFactory.getLocalInstance((Context)this.ctx).getGeneralAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActId));
                accountingCoefficient = accountingAsstAct != null ? (accountingAsstAct.getMeasureUnit() != null ? MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(accountingAsstAct.getMeasureUnit().getId().toString())).getCoefficient() : (accountingAsstAct.getMeasureUnitGroup() != null ? GlUtils.one : (this.accountingAsstActType.getMeasureUnit() != null ? MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(this.accountingAsstActType.getMeasureUnit().getId().toString())).getCoefficient() : (this.accountingAsstActType.getMeasureUnitGroup() != null ? GlUtils.one : GlUtils.one)))) : GlUtils.one;
            } else if ("material".equals(this.accountingAsstActType.getAsstHGAttribute())) {
                MaterialInfo mateial = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(asstActId));
                if (mateial != null) {
                    if (mateial.getBaseUnit() != null) {
                        String measureunitId = mateial.getBaseUnit().getId().toString();
                        EntityViewInfo view = new EntityViewInfo();
                        view.getSelector().add(new SelectorItemInfo("id"));
                        view.getSelector().add(new SelectorItemInfo("name"));
                        view.getSelector().add(new SelectorItemInfo("number"));
                        view.getSelector().add(new SelectorItemInfo("coefficient"));
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)measureunitId));
                        view.setFilter(filter);
                        accountingCoefficient = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitCollection(view).get(0).getCoefficient();
                    } else {
                        accountingCoefficient = this.accountingAsstActType.getMeasureUnit() != null ? MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(this.accountingAsstActType.getMeasureUnit().getId().toString())).getCoefficient() : (this.accountingAsstActType.getMeasureUnitGroup() != null ? GlUtils.one : GlUtils.one);
                    }
                } else {
                    accountingCoefficient = GlUtils.one;
                }
            } else {
                accountingCoefficient = this.accountingAsstActType.getMeasureUnit() != null ? MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(this.accountingAsstActType.getMeasureUnit().getId().toString())).getCoefficient() : (this.accountingAsstActType.getMeasureUnitGroup() != null ? GlUtils.one : GlUtils.one);
            }
            this.loadedAsstActIDToQtyCoefficient.put(asstActId, accountingCoefficient);
        }
        return accountingCoefficient;
    }

    protected BigDecimal getAccountQtyCoefficient(String accountId) throws BOSException, EASBizException {
        if (accountId != null) {
            MeasureUnitInfo measureUnitID;
            BigDecimal accountQtyCoefficient = GlUtils.one;
            AccountViewInfo accountViewInfo = null;
            if (this.loadedAccountIDToQtyCoefficient.containsKey(accountId)) {
                accountQtyCoefficient = this.loadedAccountIDToQtyCoefficient.get(accountId);
            } else {
                accountViewInfo = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            }
            if (accountViewInfo != null && (measureUnitID = accountViewInfo.getMeasureUnitID()) != null) {
                accountQtyCoefficient = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureUnitID.getId().toString())).getCoefficient();
            }
            this.loadedAccountIDToQtyCoefficient.put(accountId, accountQtyCoefficient);
            return accountQtyCoefficient;
        }
        return GlUtils.one;
    }

    private void setAmountWithAccountDC(IGLRptRowData rowData, BalanceDirectionEnum dc) throws BOSException, EASBizException {
        if (dc == BalanceDirectionEnum.CREDIT) {
            if (this.isShowQty()) {
                this.negateBalance(rowData, "Qty");
            }
            if (this.isShowFor()) {
                this.negateBalance(rowData, "BalanceFor");
            }
            if (this.isShowLocal()) {
                this.negateBalance(rowData, "BalanceLocal");
            }
            if (this.isShowRpt()) {
                this.negateBalance(rowData, "BalanceRpt");
            }
        }
    }

    private void setAmountAndDC(IGLRptRowData rs, String prefix) throws BOSException, EASBizException {
        String fpref = "F" + prefix;
        BigDecimal amount = null;
        if (this.isShowFor()) {
            amount = rs.getBigDecimal(fpref + "BalanceFor");
        }
        if (this.isShowLocal() && (amount == null || amount.doubleValue() == 0.0)) {
            amount = rs.getBigDecimal(fpref + "BalanceLocal");
        }
        if (this.isShowRpt() && (amount == null || amount.doubleValue() == 0.0)) {
            amount = rs.getBigDecimal(fpref + "BalanceRpt");
        }
        if (amount != null && amount.doubleValue() < 0.0) {
            if (this.isShowQty()) {
                this.negateBalance(rs, fpref, "Qty");
            }
            if (this.isShowFor()) {
                this.negateBalance(rs, fpref, "BalanceFor");
            }
            if (this.isShowLocal()) {
                this.negateBalance(rs, fpref, "BalanceLocal");
            }
            if (this.isShowRpt()) {
                this.negateBalance(rs, fpref, "BalanceRpt");
            }
            rs.updateObject(prefix + "AccountDC", BalanceDirectionEnum.CREDIT);
        } else if (amount != null && amount.doubleValue() > 0.0) {
            rs.updateObject(prefix + "AccountDC", BalanceDirectionEnum.DEBIT);
        }
    }

    private void negateBalance(IGLRptRowData rs, String sufifx) throws BOSException {
        this.negateBalance(rs, "FBegin", sufifx);
        this.negateBalance(rs, "FEnd", sufifx);
    }

    private void negateBalance(IGLRptRowData rs, String prefix, String sufifx) throws BOSException {
        BigDecimal bal = rs.getBigDecimal(prefix + sufifx);
        if (bal != null) {
            rs.updateBigDecimal(prefix + sufifx, bal.negate());
        }
    }

    private void setEqualDC(IGLRptRowData rs, String prefix) throws BOSException, EASBizException {
        String fpref = "F" + prefix;
        if (this.isShowFor() && rs.getBigDecimal(fpref + "BalanceFor") != null && rs.getBigDecimal(fpref + "BalanceFor").doubleValue() != 0.0) {
            return;
        }
        if (this.isShowLocal() && rs.getBigDecimal(fpref + "BalanceLocal") != null && rs.getBigDecimal(fpref + "BalanceLocal").doubleValue() != 0.0) {
            return;
        }
        if (this.isShowRpt() && rs.getBigDecimal(fpref + "BalanceRpt") != null && rs.getBigDecimal(fpref + "BalanceRpt").doubleValue() != 0.0) {
            return;
        }
        rs.updateObject(prefix + "AccountDC", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"cell_equal", (Locale)this.getContex().getLocale()));
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(this.getAsstItemSelector());
        selector.add(GLRptField.accountID);
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            selector.add(GLRptField.accountNumberMerger);
            if (this.cond.getRptParams().isAccountShowLongName()) {
                selector.add(GLRptField.accountDisplayNameMerger);
            } else {
                selector.add(GLRptField.accountNameMerger);
            }
        } else {
            selector.add(GLRptField.accountNumber);
            if (this.cond.getRptParams().isAccountShowLongName()) {
                selector.add(GLRptField.accountDisplayName);
            } else {
                selector.add(GLRptField.accountName);
            }
        }
        if (this.isAllCurrency()) {
            selector.add(GLRptField.currencyID);
            selector.add(GLRptField.currencyName);
            selector.add(GLRptField.currencyPre);
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            this.initSelectorOrgUnit(selector);
            selector.add(this.getOrgUnitNameField());
        }
        selector.add(GLRptField.period);
        selector.add(GLRptField.beginAccountDC);
        if (this.isShowQty()) {
            selector.add(GLRptField.beginQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.beginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.beginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.beginBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.debitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.debitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.debitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.debitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.creditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.creditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.creditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.creditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearDebitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearCreditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearCreditRpt);
        }
        selector.add(GLRptField.endAccountDC);
        if (this.isShowQty()) {
            selector.add(GLRptField.endQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.endBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.endBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.endBalanceRpt);
        }
        return selector;
    }

    protected GLRptSelector getAsstItemSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        if (!this.isShowAsstItem && !this.isFromElRec) {
            return selector;
        }
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            selector.add(this.genAsstDataBaseID(at));
            boolean isShowNumber = this.cond.getRptParams().isAssitemShowNumber();
            boolean isShowLongName = this.cond.getRptParams().isShowLongNameForGeneral();
            boolean isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
            selector.add(GLRptField.genAsstDataBaseNumber(at, isShowLongNumber));
            selector.add(GLRptField.genAsstDataBaseName(at, this.getContex().getLocale(), isShowNumber, isShowLongNumber, isShowLongName));
            if (!at.isShowAsstGroup()) continue;
            selector.add(GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at));
        }
        return selector;
    }

    private GLRptField genAsstDataBaseID(AsstactTypeEntity at) {
        if (this.isPrintTotal) {
            return new GLRptField(at.getHgField(), "t." + at.getHgField(), null, "VARCHAR(44)", null, -1);
        }
        return new GLRptField(at.getHgField(), GLRptDataTable.HG.getAlias() + "." + at.getHgField(), "assGrp." + at.getHgAttribute() + ".id", "VARCHAR(44)", null, -1);
    }

    @Override
    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected GLRptField getFreezeField() {
        return GLRptField.accountName;
    }

    @Override
    protected GLRptSumItems getTempTableSumItem() throws BOSException, EASBizException {
        GLRptSumItems sumItem = new GLRptSumItems();
        Iterator<GLRptField> it = this.getAsstItemSelector().iterator();
        while (it.hasNext()) {
            sumItem.add(it.next());
        }
        if (!this.getOrgUnit().isIsBizUnit()) {
            sumItem.add(this.getOrgUnitIDField());
        }
        if (this.isAllCurrency()) {
            sumItem.add(GLRptField.currencyID);
        }
        sumItem.add(GLRptField.period);
        sumItem.setSumGroup("accountIsTotal");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sumItem.add(GLRptField.accountNumberMerger);
            sumItem.add(GLRptField.accountNameMerger);
            sumItem.setSumGroup("companyIsTotal");
        }
        return sumItem;
    }

    protected GLRptBalQuery getRptAsstactBalQuery(Context ctx, OrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMeasureUnit, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAsstactBalQuery(ctx, company, cond, isMeasureUnit, isCreateDataTempTable);
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptAsstactGGPageQuery(this.getContex(), this.cond, this.isCreateDataTempTable(), this.isShowAsstItem);
    }

    protected void initSelectorOrgUnit(GLRptSelector selector) {
        selector.add(GLRptField.orgUnitID);
    }

    protected GLRptField getOrgUnitIDField() {
        return GLRptField.orgUnitID;
    }

    protected GLRptField getOrgUnitNameField() {
        return GLRptField.orgUnitName;
    }

    @Override
    protected String getTempTableDefineFunction() {
        return "GLRptAsstactBalGGDao";
    }
}

