/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGGCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import java.util.Iterator;

public class GLRptAsstactGGPageQuery
extends GLRptPageQuery {
    private GLRptAsstactGGCondition cond;
    protected boolean isCreateDataTempTable;
    private boolean isShowAsstItem;

    public GLRptAsstactGGPageQuery(Context ctx, GLRptAsstactGGCondition cond, boolean isCreateDataTempTable, boolean isShowAsstItem) throws EASBizException, BOSException {
        super(ctx, cond);
        this.cond = cond;
        this.isCreateDataTempTable = isCreateDataTempTable;
        this.isShowAsstItem = isShowAsstItem;
    }

    protected String getJoinDataOrgSQL() {
        return " left outer join t_org_company cp on cp.fid = t.forgunitid  \r\n";
    }

    @Override
    protected String getJoinDataBaseSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" left outer join t_bd_accountview av on av.fid = t.faccountid \r\n");
        sql.append(" left outer join t_bd_accountview pav on pav.fid = av.fparentid \r\n");
        if (this.cond.isAllCurrency()) {
            sql.append(" left outer join t_bd_currency cy on cy.fid = t.fcurrencyid \r\n");
        }
        sql.append(this.getJoinDataOrgSQL());
        if (this.isShowAsstItem) {
            for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                sql.append(" left outer join ").append(at.getTableName()).append(" ").append(at.getHgAttribute()).append(" on ").append(at.getHgAttribute()).append(".fid = t.").append(at.getHgField());
                if (!at.isShowAsstGroup()) continue;
                sql.append(" left outer join ").append(at.getGroupTable()).append(" ").append(at.getHgAttribute()).append("Group on ").append(at.getHgAttribute()).append("Group.FID=").append("t.").append(at.getHgAttribute()).append("GroupID");
            }
        }
        return sql.toString();
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        StringBuffer whereSQL = new StringBuffer();
        String superWhere = super.getWhereSQL();
        if (superWhere != null && superWhere.trim().length() > 0) {
            this.addFilterItem(whereSQL, superWhere);
        }
        if (this.cond.isAfterCurrPeriod()) {
            this.addFilterItem(whereSQL, " t.FIsAfterCurrPeriod = 0 ");
        }
        if (!this.isSeqTable()) {
            int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
            int startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
            if (this.cond.isAfterCurrPeriod()) {
                this.addFilterItem(whereSQL, " (t.fperiod >= " + startPeriod + " and t.fperiod <= " + endPeriod + ")");
            }
            if (!this.cond.isShowLeafAccount() && this.sumItem == null) {
                this.addFilterItem(whereSQL, " ((av.flevel <= " + this.cond.getAccountLevelEnd() + " and av.flevel >= " + this.cond.getAccountLevelStart() + ") or t.faccountid is null)");
            }
        }
        if (this.sumItem != null) {
            if ("accountIsTotal".compareToIgnoreCase(this.sumItem.getName()) == 0) {
                if (this.cond.getCompany().isIsBizUnit()) {
                    if (!this.cond.isShowLeafAccount()) {
                        this.addFilterItem(whereSQL, " (av.fisleaf = 1 or av.flevel = " + this.cond.getAccountLevelEnd() + ")");
                    }
                } else if (this.cond.isShowLeafAccount()) {
                    this.addFilterItem(whereSQL, " (av.fisleaf = 1 or t." + this.sumItem.getName() + " = 1)");
                } else {
                    this.addFilterItem(whereSQL, " (av.flevel = " + this.cond.getAccountLevelStart() + " or t." + this.sumItem.getName() + " = 1)");
                }
            } else {
                this.addFilterItem(whereSQL, " (accountIsTotal <> 1)");
            }
        }
        return whereSQL.toString();
    }

    private void addFilterItem(StringBuffer where, String WhereItem) {
        if (WhereItem != null && WhereItem.trim().length() > 0) {
            if (where.length() > 0) {
                where.append(" and ");
            }
            where.append(WhereItem);
        }
    }

    protected String getOrgOrderSql() {
        return "cp.flongnumber";
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        GLRptSQLOrder order = new GLRptSQLOrder();
        if (this.isShowAsstItem) {
            Iterator it = this.cond.getAsstActList().iterator();
            boolean isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
            while (it.hasNext()) {
                AsstactTypeEntity at = (AsstactTypeEntity)it.next();
                if (at.isShowAsstGroup()) {
                    order.add(at.getHgAttribute() + "Group.flongnumber");
                }
                order.add(at.isUseLongNumber() && isShowLongNumber ? at.getHgAttribute() + ".flongnumber" : at.getHgAttribute() + ".fnumber");
                order.add(at.getHgAttribute() + ".fid");
            }
        }
        order.add("t." + GLRptField.period.getName());
        if (this.cond.isAllCurrency()) {
            order.add(GLRptField.currencyNumber.getSelect());
        }
        order.add("t.accountIsTotal");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            order.add("t." + GLRptField.accountNumberMerger.getName());
            order.add("t." + GLRptField.accountNameMerger.getName());
            order.add("t.companyIsTotal", SortType.DESCEND);
        } else {
            order.add(GLRptField.accountNumber.getSelect());
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            order.add(this.getOrgOrderSql());
        }
        return order;
    }
}

