/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CommonSchemaInfo;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportConditionAsstactMultiColumn;
import com.kingdee.eas.fi.gl.RptCommonSchemaFactory;
import com.kingdee.eas.fi.gl.common.CommonSchema;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptMulColAbsDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactMultiColumnQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptMulColAccoutDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptMulColAsstDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableStruct;
import com.kingdee.eas.fi.gl.rpt.app.dao.IDRptDataManager;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public class GLRptAsstactMultiColumnDao
extends AbstractGLRptDao {
    protected ReportConditionAsstactMultiColumn condition;
    protected CurrencyCollection currencys;
    protected CommonSchema cs;
    protected AbstractGLRptMulColAbsDao absDao;
    protected String idListTempTable;
    private String orderSql;

    public String getIdListTempTable() {
        return this.idListTempTable;
    }

    private void setIdListTempTable(String idListTempTable) {
        this.idListTempTable = idListTempTable;
    }

    public GLRptAsstactMultiColumnDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
    }

    public CurrencyCollection getCurrencys() {
        return this.currencys;
    }

    protected void setRptCondition() {
        this.condition = (ReportConditionAsstactMultiColumn)this.getQueryCondition();
    }

    protected void setAbsDao() throws EASBizException, BOSException {
        String accViewId = this.cs.getParams().getString("accountViewID");
        boolean isAccountColumnType = this.cs.getParams().getBoolean("isAccountColumnType");
        AccountViewInfo accountView = AccountViewFactory.getLocalInstance((Context)this.getContex()).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accViewId));
        this.absDao = accountView.isIsLeaf() || !isAccountColumnType ? this.getRptMulColAsstDao(this.getContex(), this.getCompany(), this, this.condition, this.cs) : this.getRptMulColAccoutDao(this.getContex(), this.getCompany(), this, this.condition, this.cs);
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.setRptCondition();
        this.initSchema();
        this.currencys = this.getCurrencyCollection((HashSet)this.cs.getParams().getObject("selectedCurrencyIDSet"));
        this.setAbsDao();
    }

    protected GLRptMulColAsstDao getRptMulColAsstDao(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactMultiColumnDao dao, ReportConditionAsstactMultiColumn condition, CommonSchema cs) throws EASBizException, BOSException {
        return new GLRptMulColAsstDao(ctx, company, dao, condition, cs);
    }

    protected GLRptMulColAccoutDao getRptMulColAccoutDao(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactMultiColumnDao dao, ReportConditionAsstactMultiColumn condition, CommonSchema cs) throws EASBizException, BOSException {
        return new GLRptMulColAccoutDao(ctx, company, dao, condition, cs);
    }

    protected void createIdListTempTable() throws BOSException, EASBizException {
        String tableName = null;
        try {
            String createTableSql = "create table GLRptAsstactMultiColumnDao_IDList (SQL_SEQ INT, SQL_BATCH INT, KSQL_SEQ INT IDENTITY (1, 1))";
            tableName = TempTablePool.getInstance((Context)this.getContex()).createTempTable(createTableSql);
            GLRptPageQuery query = this.getGLRptDataQuery();
            StringBuffer sql = new StringBuffer();
            sql.append("insert ").append(tableName).append("(KSQL_SEQ, SQL_SEQ, SQL_BATCH)");
            sql.append("select t.KSQL_SEQ, t.SQL_BATCH ");
            sql.append(" from ").append(this.getDataSourceTableName()).append(" t ");
            sql.append(((GLRptQuery)query).getJoinSQL());
            this.orderSql = query.getOrder().getOrderSQL();
            sql.append(this.orderSql);
            this.execute(sql.toString());
            this.createIndex(tableName, "SQL_SEQ, SQL_BATCH");
            this.setIdListTempTable(tableName);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }

    protected CommonSchema getCommonSchema(String id) throws EASBizException, BOSException {
        return RptCommonSchemaFactory.getLocalInstance(this.getContex()).getSchema(id);
    }

    protected void initSchema() throws BOSException, EASBizException {
        CommonSchemaInfo csi = this.condition.getSchema();
        this.cs = this.getCommonSchema(csi.getId().toString());
        if (this.cs == null) {
            throw new ReportBizException(ReportBizException.MULTI_ACCOUNT_SCHEMA_NOT_EXISTS);
        }
        if (!this.cs.isMatchVersion()) {
            throw new ReportBizException(ReportBizException.MULTI_ACCOUNT_SCHEMA_UNMATCH_VERSION);
        }
        this.decodeCommSchmaInfo(this.cs);
    }

    protected CurrencyCollection getCurrencyCollection(HashSet idSet) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        CurrencyCollection cc = CurrencyFactory.getLocalInstance((Context)this.getContex()).getCurrencyCollection(ev);
        CurrencyInfo c0 = cc.get(0);
        int n = cc.size();
        for (int i = 1; i < n; ++i) {
            CurrencyInfo ci = cc.get(i);
            if (!ci.getId().toString().equals(this.getCompany().getBaseCurrency().getId().toString())) continue;
            cc.set(0, ci);
            cc.add(c0);
            break;
        }
        return cc;
    }

    @Override
    public GLRptTableHeadInfo initTableHeadInfo() throws BOSException, EASBizException {
        GLRptTableHeadInfo headInfo = super.initTableHeadInfo();
        return this.absDao.initTableHeadInfo(headInfo);
    }

    @Override
    public void buildData() throws BOSException, EASBizException {
        this.insertData();
        this.createIdListTempTable();
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        this.absDao.buildData();
    }

    protected void decodeCommSchmaInfo(CommonSchema cs) throws BOSException {
        Object[][] md = (Object[][])cs.getParams().getObject("md");
        for (int i = 0; i < md.length; ++i) {
            if (md[i][1] instanceof Map) {
                md[i][1] = this.map2Object((Map)md[i][1]);
            }
            if (md[i][0] instanceof Integer) {
                md[i][0] = BalanceDirectionEnum.getEnum((int)((Integer)md[i][0]));
                continue;
            }
            if (!(md[i][0] instanceof String)) continue;
            md[i][0] = BalanceDirectionEnum.getEnum((int)Integer.parseInt((String)md[i][0]));
        }
        List list = (List)cs.getParams().getObject("asstact_type_list");
        for (int i = 0; i < list.size(); ++i) {
            Object objValue = list.get(i);
            if (!(objValue instanceof Map)) continue;
            list.set(i, this.map2Object((Map)objValue));
        }
    }

    protected Object map2Object(Map value) throws BOSException {
        LabelValueBean lvb = new LabelValueBean();
        try {
            BeanUtils.populate((Object)lvb, (Map)value);
            lvb.setProperty(value.get("property"));
        }
        catch (Exception e) {
            throw new BOSException("map2Object error!", (Throwable)e);
        }
        return lvb;
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() {
        return new GLRptAsstactMultiColumnQuery(this.getContex(), this.getCompany(), this.getFieldNameExtend(), this.condition);
    }

    public String getFieldNameExtend() {
        return "_" + this.getContex().getLocale().getLanguage();
    }

    @Override
    public GLRptTempTableStruct getTempTableStruct() throws BOSException, EASBizException {
        return this.absDao.getTempTableStruct();
    }

    @Override
    public GLRptRowSet getData(int start, int length) throws BOSException, EASBizException {
        GLRptID[] ids = ((IDRptDataManager)this.getDataManager()).getIdManager().getIdList(start, length);
        return this.absDao.getData(ids, this.orderSql);
    }

    @Override
    public void releaseTempTable() {
        this.absDao.releaseTempTable();
    }

    @Override
    protected boolean isUseRptID() {
        return true;
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        return null;
    }

    @Override
    public GLRptField getTreeColmun() {
        return null;
    }

    @Override
    protected String getTempTableDefineFunction() {
        return "GLRptAsstactMultiColumnDao";
    }
}

