/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.IGLRptRowData;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;

public abstract class GLRptBalanceBaseDao
extends AbstractGLRptDao {
    public GLRptBalanceBaseDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
    }

    @Override
    protected void setRow1Title(List colTitles, GLRptField field) {
        if (field == GLRptField.period) {
            colTitles.add("fiscal_year");
            colTitles.add("period");
        } else if (field == GLRptField.yearBeginBalanceDC) {
            colTitles.add(GLRptField.yearBeginBalanceFor.getTitle());
        } else if (field == GLRptField.beginBalanceDC) {
            colTitles.add(GLRptField.beginBalanceFor.getTitle());
        } else if (field == GLRptField.endBalanceDC) {
            colTitles.add(GLRptField.endBalanceFor.getTitle());
        } else {
            super.setRow1Title(colTitles, field);
        }
    }

    @Override
    protected void setRow2Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field == GLRptField.period) {
            colTitles.add("fiscal_year");
            colTitles.add("period");
        } else {
            super.setRow2Title(colTitles, field);
        }
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        super.doGLRptRowData(rowSet);
        this.setBalanceDC(rowSet);
        this.updateYearBegin(rowSet);
    }

    @Override
    protected void updateField(IRowSet rs, GLRptRowSet rowData, String colName, Object value) throws BOSException, EASBizException, SQLException {
        super.updateField(rs, rowData, colName, value);
        if (GLRptField.accountDC.getName().equalsIgnoreCase(colName) && value != null && this.getQueryCondition().getRptParams().isBalanceDirSamAsAccount()) {
            rowData.updateObject(colName, BalanceDirectionEnum.getEnum((int)rs.getInt(colName)));
        }
    }

    private void setBalanceDC(IGLRptRowData rowData) throws EASBizException, BOSException {
        if (!this.getGLRptSelector().contains(GLRptField.accountDC)) {
            return;
        }
        boolean negate = this.isCreditBalance(rowData);
        if (this.getGLRptSelector().containsBalField("FBegin")) {
            this.setAmountBalanceDC(rowData, "FBegin", negate);
        }
        if (this.getGLRptSelector().containsBalField("FEnd")) {
            this.setAmountBalanceDC(rowData, "FEnd", negate);
        }
    }

    protected boolean isCreditBalance(IGLRptRowData rowData) throws BOSException, EASBizException {
        BigDecimal amount = null;
        String fieldName = null;
        if (this.getGLRptSelector().containsBalField("FEnd")) {
            fieldName = "FEnd";
        } else if (this.getGLRptSelector().containsBalField("FBegin")) {
            fieldName = "FBegin";
        }
        if (fieldName == null) {
            return false;
        }
        if (this.isShowFor()) {
            amount = rowData.getBigDecimal(fieldName + "BalanceFor");
        }
        if ((amount == null || amount.doubleValue() == 0.0) && this.isShowLocal()) {
            amount = rowData.getBigDecimal(fieldName + "BalanceLocal");
        }
        if ((amount == null || amount.doubleValue() == 0.0) && this.isShowRpt()) {
            amount = rowData.getBigDecimal(fieldName + "BalanceRpt");
        }
        boolean negate = false;
        if (amount == null || amount.doubleValue() == 0.0) {
            rowData.updateObject(GLRptField.accountDC.getName(), EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"dir_equal", (Locale)this.getContex().getOriginLocale()));
        } else {
            Object accountDC = rowData.getObject(GLRptField.accountDC.getName());
            if (this.getQueryCondition().getRptParams().isBalanceDirSamAsAccount() && accountDC instanceof BalanceDirectionEnum) {
                if (accountDC == BalanceDirectionEnum.CREDIT) {
                    negate = true;
                }
            } else if (amount.doubleValue() < 0.0) {
                rowData.updateObject(GLRptField.accountDC.getName(), BalanceDirectionEnum.CREDIT);
                negate = true;
            } else {
                rowData.updateObject(GLRptField.accountDC.getName(), BalanceDirectionEnum.DEBIT);
            }
        }
        return negate;
    }

    private void setAmountBalanceDC(IGLRptRowData rowData, String fieldName, boolean negate) throws BOSException, EASBizException {
        BigDecimal amount;
        if (this.isShowFor()) {
            amount = rowData.getBigDecimal(fieldName + "BalanceFor");
            rowData.updateBigDecimal(fieldName + "BalanceFor", negate ? (amount == null ? GlUtils.zero : amount.negate()) : amount);
        }
        if (this.isShowLocal()) {
            amount = rowData.getBigDecimal(fieldName + "BalanceLocal");
            rowData.updateBigDecimal(fieldName + "BalanceLocal", negate ? (amount == null ? GlUtils.zero : amount.negate()) : amount);
        }
        if (this.isShowRpt()) {
            amount = rowData.getBigDecimal(fieldName + "BalanceRpt");
            rowData.updateBigDecimal(fieldName + "BalanceRpt", negate ? (amount == null ? GlUtils.zero : amount.negate()) : amount);
        }
        if (this.isShowQty()) {
            amount = rowData.getBigDecimal(fieldName + "Qty");
            rowData.updateBigDecimal(fieldName + "Qty", negate ? (amount == null ? GlUtils.zero : amount.negate()) : amount);
        }
    }

    protected void updateYearBegin(IGLRptRowData rowData) throws BOSException, EASBizException {
        boolean negate;
        boolean bl = negate = rowData.getObject(GLRptField.accountDC.getName()) == BalanceDirectionEnum.CREDIT;
        if (this.getGLRptSelector().containsBalField("FYearBegin")) {
            BigDecimal amount;
            BigDecimal yearCredit;
            BigDecimal yearDebit;
            BigDecimal endBalance;
            if (this.isShowFor()) {
                endBalance = rowData.getBigDecimal(GLRptField.endBalanceFor.getName());
                if (endBalance == null) {
                    endBalance = GlUtils.zero;
                }
                if ((yearDebit = rowData.getBigDecimal(GLRptField.yearDebitFor.getName())) == null) {
                    yearDebit = GlUtils.zero;
                }
                if ((yearCredit = rowData.getBigDecimal(GLRptField.yearCreditFor.getName())) == null) {
                    yearCredit = GlUtils.zero;
                }
                amount = negate ? endBalance.add(yearDebit).subtract(yearCredit) : endBalance.subtract(yearDebit).add(yearCredit);
                rowData.updateBigDecimal(GLRptField.yearBeginBalanceFor.getName(), amount);
            }
            if (this.isShowLocal()) {
                endBalance = rowData.getBigDecimal(GLRptField.endBalanceLocal.getName());
                if (endBalance == null) {
                    endBalance = GlUtils.zero;
                }
                if ((yearDebit = rowData.getBigDecimal(GLRptField.yearDebitLocal.getName())) == null) {
                    yearDebit = GlUtils.zero;
                }
                if ((yearCredit = rowData.getBigDecimal(GLRptField.yearCreditLocal.getName())) == null) {
                    yearCredit = GlUtils.zero;
                }
                amount = negate ? endBalance.add(yearDebit).subtract(yearCredit) : endBalance.subtract(yearDebit).add(yearCredit);
                rowData.updateBigDecimal(GLRptField.yearBeginBalanceLocal.getName(), amount);
            }
            if (this.isShowRpt()) {
                endBalance = rowData.getBigDecimal(GLRptField.endBalanceRpt.getName());
                if (endBalance == null) {
                    endBalance = GlUtils.zero;
                }
                if ((yearDebit = rowData.getBigDecimal(GLRptField.yearDebitRpt.getName())) == null) {
                    yearDebit = GlUtils.zero;
                }
                if ((yearCredit = rowData.getBigDecimal(GLRptField.yearCreditRpt.getName())) == null) {
                    yearCredit = GlUtils.zero;
                }
                amount = negate ? endBalance.add(yearDebit).subtract(yearCredit) : endBalance.subtract(yearDebit).add(yearCredit);
                rowData.updateBigDecimal(GLRptField.yearBeginBalanceRpt.getName(), amount);
            }
            if (this.isShowQty()) {
                endBalance = rowData.getBigDecimal(GLRptField.endQty.getName());
                if (endBalance == null) {
                    endBalance = GlUtils.zero;
                }
                if ((yearDebit = rowData.getBigDecimal(GLRptField.yearDebitQty.getName())) == null) {
                    yearDebit = GlUtils.zero;
                }
                if ((yearCredit = rowData.getBigDecimal(GLRptField.yearCreditQty.getName())) == null) {
                    yearCredit = GlUtils.zero;
                }
                amount = negate ? endBalance.add(yearDebit).subtract(yearCredit) : endBalance.subtract(yearDebit).add(yearCredit);
                rowData.updateBigDecimal(GLRptField.yearBeginQty.getName(), amount);
            }
        }
    }
}

