/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptDiffItemSumCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDiffItemSumPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class GLRptDiffItemSumDao
extends AbstractGLRptDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.GLRptDiffItemSumDao");
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";
    protected GLRptDiffItemSumCondition cond;

    public GLRptDiffItemSumDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLRptDiffItemSumCondition)this.getQueryCondition();
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(new GLRptField("FSeq", "t.FSeq", "INT", null, -1, false, true, "seq"));
        selector.add(new GLRptField("FDiffItemID", "t.FDiffItemID", "diffItem.id", "VARCHAR(44)"));
        selector.add(new GLRptField("FDiffItemNumber", "t.FDiffItemNumber", "NVARCHAR(500)", "diffItemNumber", -1, false, true, "diffItem"));
        selector.add(new GLRptField("FDiffItemName", "t.FDiffItemName", "NVARCHAR(500)", "diffItem", 460, false, true, "diffItem"));
        selector.add(GLRptField.orgUnitID);
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            selector.add(GLRptField.orgUnitName);
        }
        selector.add(new GLRptField("FAssignedLocalAmount", "FAssignedLocalAmount", "assignedLocalAmount", "NUMERIC(29,10)", "period_happened", 150));
        selector.add(new GLRptField("FYearAssignedLocalAmount", "FAssignedYearLocalAmount", "yearAssignedLocalAmount", "NUMERIC(29,10)", "year_happened", 150));
        return selector;
    }

    @Override
    protected boolean isCreateSeqTable() throws BOSException {
        return super.isCreateSeqTable();
    }

    @Override
    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptDiffItemSumPageQuery(this.getContex(), this.cond, this.isCreateDataTempTable());
    }

    @Override
    protected void setAmountColScale(GLRptField field, GLRptTableHeadInfo.GLRptTableColumnInfo colInfo) throws EASBizException, BOSException {
        if (field.getName().endsWith("Amount")) {
            colInfo.setScale(this.getCompany().getBaseCurrency().getPrecision());
        } else {
            super.setAmountColScale(field, colInfo);
        }
    }

    @Override
    protected void buildData() throws BOSException, EASBizException {
        this.insertData();
        if (this.isGroupByCompany()) {
            this.insertCompanyLevelSumData();
        }
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        int start = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        int end = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        int yearStart = this.cond.getPeriodYearEnd() * 100 + 1;
        int minStart = this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd() ? yearStart : start;
        int seq = 1;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(seq);
        sql.append("select \n");
        sql.append("    case when av.FCategory = 1 then 98 else ? end FSeq, \n");
        sql.append("    case when av.FCategory = 1 then ? else ? end FDiffItemID, \n");
        sql.append("    null FDiffItemNumber, \n");
        sql.append("    case when av.FCategory = 1 then ? else ? end FDiffItemName, \n");
        sql.append("    v.FCompanyID FOrgUnitID, \n");
        params.add("virtual_finance");
        params.add("virtual_budget");
        params.add(this.getResource(this.getContex(), "GLRptDiffItemSumDao1"));
        params.add(this.getResource(this.getContex(), "GLRptDiffItemSumDao2"));
        if (this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd()) {
            sql.append("    sum(case when p.fnumber >= ? and av.FDiffType in (1, 2) then (1-2*ve.FEntryDC) * ve.FLocalAmount else 0 end) FAssignedLocalAmount, \n");
            sql.append("    sum(case when av.FDiffType in (1, 2) then (1-2*ve.FEntryDC) * ve.FLocalAmount else 0 end) FYearAssignedLocalAmount \n");
            params.add(start);
        } else {
            sql.append("    sum(case when av.FDiffType in (1, 2) then (1-2*ve.FEntryDC) * ve.FLocalAmount else 0 end) FAssignedLocalAmount, \n");
            sql.append("    sum(case when p.fnumber >= ? and av.FDiffType in (1, 2) then (1-2*ve.FEntryDC) * ve.FLocalAmount else 0 end) FYearAssignedLocalAmount \n");
            params.add(yearStart);
        }
        sql.append("from T_GL_Voucher v \n");
        sql.append("join T_BD_Period p on p.FID = v.FPeriodID \n");
        sql.append("join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
        sql.append("join T_BD_AccountView av on av.FID = ve.FAccountID \n");
        sql.append("where v.FCompanyID in " + this.cond.getCompanyIdsStr() + " \n");
        sql.append("and p.fnumber >= ? \n");
        sql.append("and p.fnumber <= ? \n");
        if (this.cond.getOptionPosting()) {
            sql.append("and v.FBizStatus in (1, 3, 5) \n");
        } else {
            sql.append("and v.FBizStatus = 5 \n");
        }
        sql.append("and v.FSourceType <> 1 \n");
        sql.append("group by v.FCompanyID, av.FCategory \n");
        params.add(minStart);
        params.add(end);
        this.insertData(sql.toString(), params);
        sql.setLength(0);
        params.clear();
        sql.append("select \n");
        sql.append("    ? FSeq, ? FDiffItemID, null FDiffItemNumber, ? FDiffItemName, \n");
        sql.append("    c.FID FOrgUnitID, 0 FAssignedLocalAmount, 0 FYearAssignedLocalAmount \n");
        sql.append("from T_ORG_Company c \n");
        sql.append("where c.FID in " + this.cond.getCompanyIdsStr() + " \n");
        sql.append("and not exists ( \n");
        sql.append("    select 1 from " + this.getDataSourceTable().getTableName() + " where FDiffItemID = ? \n");
        sql.append(") \n");
        params.add(seq);
        params.add("virtual_budget");
        params.add(this.getResource(this.getContex(), "GLRptDiffItemSumDao2"));
        params.add("virtual_budget");
        this.insertData(sql.toString(), params);
        params.clear();
        params.add(98);
        params.add("virtual_finance");
        params.add(this.getResource(this.getContex(), "GLRptDiffItemSumDao1"));
        params.add("virtual_finance");
        this.insertData(sql.toString(), params);
        ++seq;
        sql.setLength(0);
        params.clear();
        sql.append("select \n");
        sql.append("    ? FSeq, 'virtual_adjust' FDiffItemID, 'virtual_adjust' FDiffItemNumber, ? FDiffItemName, \n");
        sql.append("    null FOrgUnitID, 0 FAssignedLocalAmount, 0 FYearAssignedLocalAmount \n");
        params.add(seq);
        params.add(this.getResource(this.getContex(), "GLRptDiffItemSumDao3"));
        this.insertData(sql.toString(), params);
        sql.setLength(0);
        params.clear();
        params.add(++seq);
        sql.append("select \n");
        sql.append("    ? FSeq, \n");
        sql.append("    d.FID FDiffItemID, \n");
        sql.append("    d.FNumber FDiffItemNumber, \n");
        sql.append("    case \n");
        sql.append("    when d.FLevel = 1 then '\u3000' \n");
        sql.append("    when d.FLevel = 2 then '\u3000\u3000' \n");
        sql.append("    when d.FLevel = 3 then '\u3000\u3000\u3000' \n");
        sql.append("    when d.FLevel = 4 then '\u3000\u3000\u3000\u3000' \n");
        sql.append("    else '' end ||'('||d.FNumber||') '||d.FName_").append(this.getContex().getLocale()).append(" FDiffItemName, \n");
        sql.append("    t.FOrgUnitID FOrgUnitID, \n");
        sql.append("    t.FAssignedLocalAmount FAssignedLocalAmount, \n");
        sql.append("    t.FYearAssignedLocalAmount FYearAssignedLocalAmount \n");
        sql.append("from (\n");
        sql.append("select \n");
        sql.append("    r.FDiffItemID FDiffItemID, \n");
        sql.append("    v.FCompanyID FOrgUnitID, \n");
        if (this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd()) {
            sql.append("    sum(case when p.fnumber >= ? then r.FAssignedLocalAmount else 0 end) FAssignedLocalAmount, \n");
            sql.append("    sum(r.FAssignedLocalAmount) FYearAssignedLocalAmount \n");
            params.add(start);
        } else {
            sql.append("    sum(r.FAssignedLocalAmount) FAssignedLocalAmount, \n");
            sql.append("    sum(case when p.fnumber >= ? then r.FAssignedLocalAmount else 0 end) FYearAssignedLocalAmount \n");
            params.add(yearStart);
        }
        sql.append("from T_GL_DiffItemRecord r \n");
        sql.append("join T_GL_Voucher v on v.FID = r.FVoucherID \n");
        sql.append("join T_BD_Period p on p.FID = v.FPeriodID \n");
        sql.append("where v.FCompanyID in " + this.cond.getCompanyIdsStr() + " \n");
        sql.append("and p.fnumber >= ? \n");
        sql.append("and p.fnumber <= ? \n");
        sql.append("and v.FDiffItemFlag = 1 \n");
        if (this.cond.getOptionPosting()) {
            sql.append("and v.FBizStatus in (1, 3, 5) \n");
        } else {
            sql.append("and v.FBizStatus = 5 \n");
        }
        sql.append("and v.FSourceType <> 1 \n");
        sql.append("group by v.FCompanyID, r.FDiffItemID \n");
        sql.append(") t \n");
        sql.append("join T_GL_DiffItem d on d.FID = t.FDiffItemID \n");
        params.add(minStart);
        params.add(end);
        this.insertData(sql.toString(), params);
        sql.setLength(0);
        params.clear();
        params.add(seq);
        sql.append("select \n");
        sql.append("    ? FSeq, \n");
        sql.append("    d.FID FDiffItemID, \n");
        sql.append("    d.FNumber FDiffItemNumber, \n");
        sql.append("    case \n");
        sql.append("    when d.FLevel = 1 then '\u3000' \n");
        sql.append("    when d.FLevel = 2 then '\u3000\u3000' \n");
        sql.append("    when d.FLevel = 3 then '\u3000\u3000\u3000' \n");
        sql.append("    when d.FLevel = 4 then '\u3000\u3000\u3000\u3000' \n");
        sql.append("    else '' end ||'('||d.FNumber||') '||d.FName_").append(this.getContex().getLocale()).append(" FDiffItemName, \n");
        sql.append("    c.FID FOrgUnitID, \n");
        sql.append("    0 FAssignedLocalAmount, \n");
        sql.append("    0 FYearAssignedLocalAmount \n");
        sql.append("from T_ORG_Company c, T_GL_DiffItem d \n");
        sql.append("where c.FID in " + this.cond.getCompanyIdsStr() + " \n");
        sql.append("and not exists ( \n");
        sql.append("    select 1 from " + this.getDataSourceTable().getTableName() + " where FDiffItemID = d.FID \n");
        sql.append(") \n");
        this.insertData(sql.toString(), params);
        sql.setLength(0);
        params.clear();
        sql.append("select \n");
        sql.append("    97 FSeq, \n");
        sql.append("    'virtual_calc' FDiffItemID, \n");
        sql.append("    'virtual_calc' FDiffItemNumber, \n");
        sql.append("    ? FDiffItemName, \n");
        sql.append("    FOrgUnitID FOrgUnitID, \n");
        sql.append("    sum(case when FDiffItemNumber like '103%' or FDiffItemNumber like '104%' then 0-FAssignedLocalAmount else FAssignedLocalAmount end) FAssignedLocalAmount, \n");
        sql.append("    sum(case when FDiffItemNumber like '103%' or FDiffItemNumber like '104%' then 0-FYearAssignedLocalAmount else FYearAssignedLocalAmount end) FYearAssignedLocalAmount \n");
        sql.append("from " + this.getDataSourceTable().getTableName() + " t \n");
        sql.append("where FOrgUnitID is not null \n");
        sql.append("    and FDiffItemID <> 'virtual_finance' \n");
        sql.append("group by FOrgUnitID \n");
        params.add(this.getResource(this.getContex(), "GLRptDiffItemSumDao4"));
        this.insertData(sql.toString(), params);
        sql.setLength(0);
        params.clear();
        sql.append("select \n");
        sql.append("    99 FSeq, \n");
        sql.append("    'virtual_diff' FDiffItemID, \n");
        sql.append("    'virtual_diff' FDiffItemNumber, \n");
        sql.append("    ? FDiffItemName, \n");
        sql.append("    FOrgUnitID FOrgUnitID, \n");
        sql.append("    sum(case when FDiffItemID = 'virtual_finance' then 0-FAssignedLocalAmount else FAssignedLocalAmount end) FAssignedLocalAmount, \n");
        sql.append("    sum(case when FDiffItemID = 'virtual_finance' then 0-FYearAssignedLocalAmount else FYearAssignedLocalAmount end) FYearAssignedLocalAmount \n");
        sql.append("from " + this.getDataSourceTable().getTableName() + " \n");
        sql.append("where FDiffItemID = 'virtual_calc' \n");
        sql.append("    or FDiffItemID = 'virtual_finance' \n");
        sql.append("group by FOrgUnitID \n");
        params.add(this.getResource(this.getContex(), "GLRptDiffItemSumDao5"));
        this.insertData(sql.toString(), params);
    }

    @Override
    protected void insertCompanyLevelSumData() throws EASBizException, BOSException {
        this.insertLevelSumData(GLRptField.orgUnitID, "t_org_company", "company", this.getCompany().getLevel());
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + this.getDataSourceTable().getTableName() + " \n");
        sql.append("where FOrgUnitID <> '" + this.getCompany().getId().toString() + "' \n");
        sql.append("and (FAssignedLocalAmount = 0 and FYearAssignedLocalAmount = 0) \n");
        DbUtil.execute((Context)this.getContex(), (String)sql.toString());
        sql.setLength(0);
        sql.append("update " + this.getDataSourceTable().getTableName() + " \n");
        sql.append("set FDiffItemName = '' \n");
        sql.append("where FOrgUnitID <> '" + this.getCompany().getId().toString() + "' \n");
        DbUtil.execute((Context)this.getContex(), (String)sql.toString());
    }

    @Override
    protected String getTempTableDefineFunction() {
        return "GLRptDiffItemSumDao";
    }

    public String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }
}

