/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptDiffItemSumCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import java.util.Iterator;

public class GLRptDiffItemSumPageQuery
extends GLRptPageQuery {
    private boolean isCreateDataTempTable = false;
    private String locale = "_L2";

    public GLRptDiffItemSumPageQuery(Context ctx, GLRptDiffItemSumCondition cond, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        super(ctx, cond);
        this.locale = "_" + ctx.getLocale().getLanguage();
        this.isCreateDataTempTable = isCreateDataTempTable;
    }

    @Override
    protected String getSelectSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String alias = this.getMainTable().getAlias();
        if (!this.isCreateDataTempTable) {
            alias = "b";
            sql.append("b.sqlseq");
        } else {
            sql.append(alias).append(".").append("KSQL_SEQ");
            if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
                sql.append(",").append(alias).append(".").append("SQL_BATCH");
            }
        }
        GLRptSelector selector = this.getSelector();
        Iterator<GLRptField> it = selector.iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.isYearBegin() || field == GLRptField.orgUnitName) continue;
            if (sql.length() > 0) {
                sql.append(",");
            }
            if (field == GLRptField.orgUnitID) {
                sql.append(this.getMainTable().getAlias()).append(".").append(field.getName()).append(" ").append(field.getName());
                continue;
            }
            if (field.isQty()) {
                sql.append("case when av.FIsQty = 0 then 0 else TO_DECIMAL(isnull(" + alias + "." + field.getName() + ",0), 29, 10)/ISNULL(MU.FCoefficient,1) end " + field.getName());
                continue;
            }
            if (field.getType() == "NUMERIC(29,10)") {
                sql.append(alias).append(".").append(field.getName());
                continue;
            }
            if (field.isMultiLang()) {
                sql.append(field.getSelect()).append(this.locale).append(" ").append(field.getName());
                continue;
            }
            sql.append(field.getSelect()).append(" ").append(field.getName());
        }
        return sql.toString();
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(super.getJoinSQL());
        sql.append(this.getOrgJoinSQL());
        return sql.toString();
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String sql = super.getWhereSQL();
        if (sql.length() > 0) {
            return sql + " and t.FSeq > 0";
        }
        return "t.FSeq > 0";
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        GLRptSQLOrder order = new GLRptSQLOrder();
        order.add("t.FSeq");
        order.add("t.FDiffItemNumber");
        if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
            order.add("company.flongnumber");
        }
        return order;
    }

    protected String getOrgJoinSQL() throws BOSException, EASBizException {
        if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
            return " left outer join t_org_company company on company.fid = t.forgunitid ";
        }
        return "";
    }
}

