/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptGeneralLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalNextPeriodQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptGeneralLedgerPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItems;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptGeneralLedgerDao
extends AbstractGLRptDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.dao.GLRptGeneralLedgerDao");
    private GLRptGeneralLedgerCondition cond;
    private String sysStatusTmpTable;
    private String strFirstTempTable;
    protected static final BigDecimal ZERO = new BigDecimal("0.00");
    protected String TITLE_YEAR_START = "strBalanceYearStart";
    protected String TITLE_PERIOD_START = "strBalancePeriodStart";
    protected String TITLE_PERIOD_SUM = "strPeriodSum";
    protected String TITLE_YEAR_SUM = "strYearSum";
    protected String TITLE_SUB_TOTAL = "strSubTitle";
    protected String TITLE_DEBIT = "FlagDebit";
    protected String TITLE_CREDIT = "FlagCredit";
    protected String TITLE_BALANCE = "FlagBalance";
    private Map<String, BigDecimal> loadedAccountIDToQtyCoefficient = new HashMap<String, BigDecimal>();
    private Context ctx;

    public GLRptGeneralLedgerDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
        this.ctx = ctx;
    }

    protected boolean getOrgIsBizUnit() {
        return this.cond.getCompany().isIsBizUnit();
    }

    protected String getOrgInnerJoinSql() {
        return " inner join t_org_company cp on cp.fid = tp.FOrgUnitID \r\n";
    }

    protected int getOrgLevel() {
        return this.cond.getCompany().getLevel();
    }

    protected String getOtherAcountOrgWhereSql() {
        return "   AND b.FOrgUnitID = T.FOrgUnitID \r\n";
    }

    protected void setOtherAccountOrgFilterSql(StringBuffer sql) throws BOSException {
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" (select distinct av.fnumber fnumber, av.fid fid,av.FCompanyID FOrgUnitID ,'").append(this.cond.getCurrencyID()).append("' FCurrencyID ");
        } else {
            sql.append(" (select distinct av.fnumber fnumber, av.fid fid,av.FCompanyID FOrgUnitID , av.FCurrencyID ");
        }
        sql.append("from t_bd_accountview av  \r\n");
        sql.append(" where av.FAccountTableID = '").append(this.cond.getAccountTableId()).append("' \r\n");
        sql.append(" AND av.fisProfitCenter <> 1 ");
        sql.append(" AND av.fcompanyid in " + this.cond.getCompanyIdsStr());
        sql.append(" AND av.FLevel>=1 AND av.FLevel<=").append(this.cond.getAccountLevelEnd());
    }

    protected void setOrgFilterSql(StringBuffer strBuffer) throws BOSException {
        strBuffer.append(" where b.FOrgUnitID in ").append(this.cond.getCompanyIdsStr()).append("\n");
    }

    protected void setSystemStatusControlSql(StringBuffer strBuffer) {
        strBuffer.append("\tINNER JOIN t_bd_SystemStatusCtrol ssc ON ssc.FCompanyID = b.FOrgUnitID \r\n");
        strBuffer.append("\tINNER JOIN t_bd_period pav ON ssc.FStartPeriodID = pav.FID\t\r\n");
        strBuffer.append("\tinner join t_bd_systemstatus tsst on ssc.FSystemStatusID=tsst.fid and tsst.fname= ").append(6);
        strBuffer.append(" inner join T_BD_AccountView tav on tav.fid=b.FAccountID \r\n");
    }

    protected String getFirstTempOrg() {
        return " FOrgUnitID Varchar(44), \r\n";
    }

    protected GLRptField getOrgUnitIDField() {
        return GLRptField.orgUnitID;
    }

    protected GLRptField getOrgUnitNameField() {
        return GLRptField.orgUnitName;
    }

    @Override
    protected GLRptField getFreezeField() {
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            return GLRptField.orgUnitName;
        }
        if (this.isAllCurrency()) {
            return GLRptField.currencyName;
        }
        return GLRptField.accountName;
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptGeneralLedgerPageQuery(this.getContex(), this.cond, this.isCreateDataTempTable());
    }

    protected void setOrgUnitSelector(GLRptSelector selector) {
        selector.add(GLRptField.orgUnitID);
        selector.add(GLRptField.orgUnitName);
    }

    protected String getTempDataOrgSelectSql() {
        return "FOrgUnitID FOrgUnitID,";
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLRptGeneralLedgerCondition)this.getQueryCondition();
        this.cond.setShowQty(this.cond.isShowQty());
    }

    protected String getFirstTempTableStructure() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" FAccountID VARCHAR(44), \r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append(this.getFirstTempOrg());
        }
        strBuffer.append(" FCurrencyID VARCHAR(44), \r\n");
        strBuffer.append("  FPeriod INT, \r\n");
        try {
            if (this.cond.isShowFor()) {
                strBuffer.append("  FBeginBalanceFor DECIMAL(28,10),");
                strBuffer.append("  FDebitFor DECIMAL(28,10), FCreditFor DECIMAL(28,10),\r\n");
                strBuffer.append("  FYearDebitFor DECIMAL(28,10),  FYearCreditFor DECIMAL(28,10),\r\n");
            } else if (this.cond.isAfterCurrPeriod() && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
                strBuffer.append("  FDebitFor DECIMAL(28,10), FCreditFor DECIMAL(28,10),\r\n");
            }
            if (this.cond.isShowLocal()) {
                strBuffer.append("  FBeginBalanceLocal DECIMAL(28,10),\r\n");
                strBuffer.append("  FDebitLocal DECIMAL(28,10),  FCreditLocal DECIMAL(28,10),\r\n");
                strBuffer.append("  FYearDebitLocal DECIMAL(28,10),  FYearCreditLocal DECIMAL(28,10),\r\n");
            } else if (this.cond.isAfterCurrPeriod() && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
                strBuffer.append("  FDebitLocal DECIMAL(28,10),  FCreditLocal DECIMAL(28,10),\r\n");
            }
            if (this.cond.isShowRpt()) {
                strBuffer.append("  FBeginBalanceRpt DECIMAL(28,10),\r\n");
                strBuffer.append("  FDebitRpt DECIMAL(28,10),  FCreditRpt DECIMAL(28,10),\r\n");
                strBuffer.append("  FYearDebitRpt DECIMAL(28,10),  FYearCreditRpt DECIMAL(28,10),\r\n");
            } else if (this.cond.isAfterCurrPeriod() && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID())) {
                strBuffer.append("  FDebitRpt DECIMAL(28,10),  FCreditRpt DECIMAL(28,10),\r\n");
            }
            strBuffer.append("  FEndBalanceFor DECIMAL(28,10) ");
            strBuffer.append("  ,FEndBalanceLocal DECIMAL(28,10) ");
            strBuffer.append("  ,FEndBalanceRpt DECIMAL(28,10)  ");
            if (this.cond.isShowQty()) {
                strBuffer.append("  ,FBeginQty DECIMAL(28,10) \r\n");
                strBuffer.append("  ,FDebitQty DECIMAL(28,10), FCreditQty DECIMAL(28,10),\r\n");
                strBuffer.append("  FYearDebitQty DECIMAL(28,10), FYearCreditQty DECIMAL(28,10),\r\n");
                strBuffer.append("  FEndQty DECIMAL(28,10)");
            }
            if (this.cond.isAfterCurrPeriod()) {
                strBuffer.append(" ,FIsAfterCurrPeriod INT ");
            }
        }
        catch (BOSException | EASBizException e) {
            e.printStackTrace();
        }
        return strBuffer.toString();
    }

    @Override
    public void buildData() throws BOSException, EASBizException {
        this.insertData();
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        String strStructure = this.getFirstTempTableStructure();
        this.strFirstTempTable = GLTempTableUtil.createDBSysTempTable(this.getContex(), strStructure);
        this.sysStatusTmpTable = GLRptDaoUtil.createSysStatusTmpTable(this.getContex(), this.cond);
        this.insertAccountBalance();
        this.insertOtherAccountBalance();
        if (this.cond.isAfterCurrPeriod()) {
            String periodTypeId = this.cond.getCompany().getAccountPeriodType().getId().toString();
            PeriodInfo currPeriod = null;
            currPeriod = this.cond.getCurrPeriod();
            int startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
            int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
            if (currPeriod.getNumber() > startPeriod) {
                startPeriod = currPeriod.getNumber();
            }
            PeriodCollection pc = GLRptDaoUtil.getPeriodCollection(this.getContex(), periodTypeId, startPeriod, endPeriod);
            PeriodInfo lastPeriod = null;
            if (pc.size() <= 0) {
                return;
            }
            if (pc.get(0).getNumber() > currPeriod.getNumber()) {
                lastPeriod = currPeriod;
            }
            GLRptGeneralLedgerCondition conddd = (GLRptGeneralLedgerCondition)this.cond.clone();
            GLRptSelector selector = new GLRptSelector();
            selector.add(GLRptField.accountID);
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                this.setOrgUnitSelector(selector);
            }
            selector.add(GLRptField.currencyID);
            selector.add(GLRptField.period);
            if (this.isShowFor()) {
                selector.add(GLRptField.beginBalanceFor);
            }
            if (this.isShowFor()) {
                selector.add(GLRptField.debitFor);
            }
            if (this.isShowFor()) {
                selector.add(GLRptField.creditFor);
            }
            if (this.isShowFor()) {
                selector.add(GLRptField.yearDebitFor);
            }
            if (this.isShowFor()) {
                selector.add(GLRptField.yearCreditFor);
            }
            if (this.isShowLocal()) {
                selector.add(GLRptField.beginBalanceLocal);
            }
            if (this.isShowLocal()) {
                selector.add(GLRptField.debitLocal);
            }
            if (this.isShowLocal()) {
                selector.add(GLRptField.creditLocal);
            }
            if (this.isShowLocal()) {
                selector.add(GLRptField.yearDebitLocal);
            }
            if (this.isShowLocal()) {
                selector.add(GLRptField.yearCreditLocal);
            }
            if (this.isShowRpt()) {
                selector.add(GLRptField.beginBalanceRpt);
            }
            if (this.isShowRpt()) {
                selector.add(GLRptField.debitRpt);
            }
            if (this.isShowRpt()) {
                selector.add(GLRptField.creditRpt);
            }
            if (this.isShowRpt()) {
                selector.add(GLRptField.yearDebitRpt);
            }
            if (this.isShowRpt()) {
                selector.add(GLRptField.yearCreditRpt);
            }
            if (this.cond.isAfterCurrPeriod() && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
                selector.add(GLRptField.debitFor);
                selector.add(GLRptField.creditFor);
                selector.add(GLRptField.debitLocal);
                selector.add(GLRptField.creditLocal);
                selector.add(GLRptField.debitRpt);
                selector.add(GLRptField.creditRpt);
            }
            if (this.isShowFor()) {
                selector.add(GLRptField.endBalanceFor);
            } else if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID())) {
                selector.add(new GLRptField("FEndBalanceLocal", "b.FEndBalanceLocal", "endBalanceLocal", "NUMERIC(29,10)"));
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
                selector.add(new GLRptField("FEndBalanceRpt", "b.FEndBalanceRpt", "endBalanceRpt", "NUMERIC(29,10)"));
            }
            if (this.isShowLocal()) {
                selector.add(GLRptField.endBalanceLocal);
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
                selector.add(new GLRptField("FEndBalanceRpt", "b.FEndBalanceRpt", "endBalanceRpt", "NUMERIC(29,10)"));
            } else {
                selector.add(new GLRptField("FEndBalanceLocal", "b.FEndBalanceLocal", "endBalanceLocal", "NUMERIC(29,10)"));
            }
            if (this.isShowRpt()) {
                selector.add(GLRptField.endBalanceRpt);
            } else if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID())) {
                selector.add(new GLRptField("FEndBalanceLocal", "b.FEndBalanceLocal", "endBalanceLocal", "NUMERIC(29,10)"));
            } else {
                selector.add(new GLRptField("FEndBalanceRpt", "b.FEndBalanceRpt", "endBalanceRpt", "NUMERIC(29,10)"));
            }
            if (this.isShowQty()) {
                selector.add(GLRptField.beginQty);
            }
            if (this.isShowQty()) {
                selector.add(GLRptField.debitQty);
            }
            if (this.isShowQty()) {
                selector.add(GLRptField.creditQty);
            }
            if (this.isShowQty()) {
                selector.add(GLRptField.yearDebitQty);
            }
            if (this.isShowQty()) {
                selector.add(GLRptField.yearCreditQty);
            }
            if (this.isShowQty()) {
                selector.add(GLRptField.endQty);
                selector.add(GLRptVoucherField.endPrice);
            }
            selector.add(new GLRptField("FIsAfterCurrPeriod", "b.FIsAfterCurrPeriod", "FIsAfterCurrPeriod", "INT"));
            GLRptBalNextPeriodQuery laterPeriodQuery = this.getRptBalNextPeriodQuery(this.getContex(), conddd);
            laterPeriodQuery.setSelector(selector);
            laterPeriodQuery.setDataSourceTableName(this.strFirstTempTable);
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                laterPeriodQuery.setSysStatusTable(this.sysStatusTmpTable);
            }
            for (int i = 0; i < pc.size(); ++i) {
                PeriodInfo period = pc.get(i);
                if (lastPeriod != null) {
                    laterPeriodQuery.setPeriod(lastPeriod.getNumber(), period.getNumber());
                    DbUtil.execute((Context)this.getContex(), (String)("INSERT  INTO " + this.strFirstTempTable + "  " + laterPeriodQuery.getSQL()));
                }
                lastPeriod = period;
            }
        }
        this.insertBalanceAndTotal();
        if (this.isGroupByCompany()) {
            this.deleteDataWithConditionForVirtual();
        }
        if (this.isAllCurrency() && this.cond.getShowTotal()) {
            this.insertAllCurrencySum();
        }
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            this.afterCurrentPeriodData();
        } else {
            this.afterCurrentPeriodData();
            this.insertCompanySum();
        }
        GLTempTableUtil.dropTempTable(this.getContex(), this.strFirstTempTable);
    }

    protected void insertAccountBalance() throws EASBizException, BOSException {
        String currencyID;
        String userID = ContextUtil.getCurrentUserInfo((Context)this.getContex()).getId().toString();
        String companyID = this.cond.getCompany().getId().toString();
        StringBuffer strBuffer = new StringBuffer();
        ArrayList sp = new ArrayList();
        strBuffer.append("\n SELECT tav.fid,\r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append(" b.").append(this.getTempDataOrgSelectSql());
        }
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
            strBuffer.append(" b.FCurrencyID  FCurrencyID,");
        } else {
            strBuffer.append(" '").append(this.cond.getCurrencyID()).append("' FCurrencyID,");
        }
        strBuffer.append("    b.FPeriod ");
        strBuffer.append(this.getAmountSelectSQL());
        if (this.cond.isAfterCurrPeriod()) {
            strBuffer.append(" ,CASE WHEN (b.fperiod > ").append(this.cond.getCurrPeriod().getNumber()).append(") THEN 1 ELSE 0 END FIsAfterCurrPeriod ");
        }
        strBuffer.append(" FROM \n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append(this.getAccountBalanceTable());
        } else {
            strBuffer.append(this.getAccountBalanceTable());
        }
        strBuffer.append("  as b ");
        strBuffer.append(" inner join t_bd_accountview tav on tav.fid = b.faccountid and tav.fcompanyid = b.forgunitid \r\n");
        strBuffer.append(" inner join ").append(this.sysStatusTmpTable).append(" ssc on ssc.fcompanyid = b.forgunitid ");
        if (this.cond.getCurrencyID() != null && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
            strBuffer.append("  INNER JOIN T_BD_Currency currency ON b.FCurrencyID = currency.Fid \r\n ");
        }
        strBuffer.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = tav.FMeasureUnitID  \r\n");
        strBuffer.append(RptServerUtil.innerJoinAccountPermissionSql("tav", userID, companyID, this.getContex()));
        this.setOrgFilterSql(strBuffer);
        int beginPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        if (beginPeriod > this.cond.getCurrPeriod().getNumber()) {
            int startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
            int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
            strBuffer.append(" and b.fperiod <= ").append(startPeriod).append(" and (b.fperiod >= ").append(endPeriod).append(" or b.fperiod >= ssc.fcurrPeriod) \r\n");
        } else {
            strBuffer.append(" and b.fperiod in ");
            strBuffer.append(SQLUtil.buildPeriodNumbersInSql(false, this.cond));
        }
        if (this.cond.isAfterCurrPeriod()) {
            strBuffer.append(" and b.fperiod >= ssc.fstartPeriod \r\n");
        }
        if (!((currencyID = this.cond.getCurrencyID()) == null || currencyID.trim().length() == 0 || currencyID.equals("AllCurrency") || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID))) {
            strBuffer.append(" and b.FCurrencyID = '").append(currencyID).append("' ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append(" AND tav.FGLevel >= tav.FLevel AND tav.FLevel>=1 AND tav.FLevel <=").append(this.cond.getAccountLevelEnd());
        } else {
            strBuffer.append(" AND tav.FLevel >= 1 AND tav.FLevel <=").append(this.cond.getAccountLevelEnd());
        }
        strBuffer.append(" AND tav.fisProfitCenter <> 1 \n");
        String accountFilter = new GLRptAccountFilter(this.getContex(), this.cond, "tav", "tav.fid", "tav.fcompanyid", false, true, this.cond.getCompanyIdsStr()).getSQL();
        if (accountFilter != null) {
            strBuffer.append(" AND ").append(accountFilter).append(" \n");
        }
        strBuffer.append(" AND tav.faccounttableid = '").append(this.cond.getAccountTableId()).append("' ");
        strBuffer.append(" group by tav.fid, ");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append(" b.forgunitid, ");
        }
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
            strBuffer.append(" b.FCurrencyID,  ");
        }
        strBuffer.append(" b.FPeriod ");
        DbUtil.execute((Context)this.getContex(), (String)("INSERT  INTO " + this.strFirstTempTable + strBuffer.toString()));
    }

    public String getAmountSelectSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Integer startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        Integer endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        boolean isAfterPeriodIncluded = this.cond.isAfterCurrPeriod();
        sql.append(" , ");
        if (this.cond.isShowFor()) {
            sql.append(this.getAmountSelectSQL("For"));
        } else if (this.cond.isAfterCurrPeriod() && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
            sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.FDebit").append("For").append(" else 0 end").append(") FDebit").append("For,");
            sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.FCredit").append("For").append(" else 0 end").append(") FCredit").append("For,");
        }
        if (this.cond.isShowLocal()) {
            sql.append(this.getAmountSelectSQL("Local"));
        } else if (this.cond.isAfterCurrPeriod() && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
            sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.FDebit").append("Local").append(" else 0 end").append(") FDebit").append("Local,");
            sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.FCredit").append("Local").append(" else 0 end").append(") FCredit").append("Local,");
        }
        if (this.cond.isShowRpt()) {
            sql.append(this.getAmountSelectSQL("Rpt"));
        } else if (this.cond.isAfterCurrPeriod() && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID())) {
            sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.FDebit").append("Rpt").append(" else 0 end").append(") FDebit").append("Rpt,");
            sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.FCredit").append("Rpt").append(" else 0 end").append(") FCredit").append("Rpt,");
        }
        ArrayList<String> suffixString = new ArrayList<String>();
        ArrayList<String> bSuffix = new ArrayList<String>();
        bSuffix.add("For");
        bSuffix.add("Local");
        bSuffix.add("Rpt");
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID())) {
            suffixString.add("Local");
            suffixString.add("Local");
            suffixString.add("Local");
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
            suffixString.add("Rpt");
            suffixString.add("Rpt");
            suffixString.add("Rpt");
        } else {
            suffixString.add("For");
            suffixString.add("Local");
            suffixString.add("Rpt");
        }
        for (int i = 0; i < 3; ++i) {
            sql.append(" sum(case ");
            if (isAfterPeriodIncluded) {
                sql.append(" when ").append(endPeriod).append(" >= ssc.fstartPeriod and ").append(endPeriod).append(" <= ssc.fcurrPeriod and b.fperiod = ").append(endPeriod).append(" then b.fendbalance").append(suffixString.get(i)).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod = ssc.fcurrPeriod  then b.fendbalance").append(suffixString.get(i)).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod > ssc.fcurrPeriod then b.fdebit").append(suffixString.get(i)).append(" - b.fcredit").append(suffixString.get(i)).append(" \r\n");
                sql.append(" when ").append(" b.fperiod < ssc.fcurrPeriod and b.fperiod >= ssc.fstartPeriod then b.fendbalance").append(suffixString.get(i)).append(" \r\n");
                sql.append(" else 0 end) fendbalance").append(bSuffix.get(i)).append(" \r\n");
            } else {
                sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fendbalance").append(suffixString.get(i)).append(" \r\n");
                sql.append(" else b.fendbalance").append(suffixString.get(i)).append(" end) fendbalance").append(bSuffix.get(i)).append(" \r\n");
            }
            if (i >= 2) continue;
            sql.append(" , ");
        }
        if (this.cond.isShowQty()) {
            sql.append(this.getQtySelectSQL());
        }
        return sql.toString();
    }

    private String getAmountSelectSQL(String suffix) throws EASBizException, BOSException {
        Integer startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        Integer endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        Integer endPeriodYear = this.cond.getPeriodYearEnd();
        boolean isAfterPeriodIncluded = this.cond.isAfterCurrPeriod();
        StringBuffer sql = new StringBuffer();
        sql.append(" sum(case ");
        sql.append(" when ").append(startPeriod).append(" < ssc.fstartPeriod and b.fperiod = ssc.fstartPeriod then b.fbeginbalance").append(suffix).append(" \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(startPeriod).append(" >= ssc.fstartPeriod and ").append(startPeriod).append(" <= ssc.fcurrPeriod and b.fperiod = ").append(startPeriod).append(" then b.fbeginbalance").append(suffix).append(" \r\n");
            sql.append(" when ").append(startPeriod).append(" > ssc.fcurrPeriod and b.fperiod = ssc.fcurrPeriod then b.fendbalance").append(suffix).append(" \r\n");
            sql.append(" when ").append(startPeriod).append(" > ssc.fcurrPeriod and b.fperiod > ssc.fcurrPeriod and b.fperiod < ").append(startPeriod).append(" then b.fdebit").append(suffix).append(" - b.fcredit").append(suffix).append(" \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(startPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.fbeginbalance").append(suffix).append(" \r\n");
        }
        sql.append(" else 0 end) fbeginbalance").append(suffix);
        sql.append(",sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.FDebit").append(suffix).append(" else 0 end").append(") FDebit").append(suffix);
        sql.append(",sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.FCredit").append(suffix).append(" else 0 end").append(") FCredit").append(suffix);
        sql.append(",sum(case ");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.fstartPeriod and ").append(endPeriod).append(" <= ssc.fcurrPeriod and b.fperiod = ").append(endPeriod).append(" then b.fyeardebit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod = ssc.fcurrPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fyeardebit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod > ssc.fcurrPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append("  then b.fdebit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" >= ssc.fstartPeriod and b.fperiod <= ssc.fcurrPeriod ").append(" then b.fyeardebit").append(suffix).append(" \r\n");
            sql.append(" else 0 end) fyeardebit").append(suffix).append(", \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fyeardebit").append(suffix).append(" \r\n");
            sql.append(" else b.fyeardebit").append(suffix).append(" end) fyeardebit").append(suffix).append(", \r\n");
        }
        sql.append(" sum(case ");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.fstartPeriod and ").append(endPeriod).append(" <= ssc.fcurrPeriod and b.fperiod = ").append(endPeriod).append(" then b.fyearcredit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod = ssc.fcurrPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fyearcredit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod > ssc.fcurrPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append("  then b.fcredit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" >= ssc.fstartPeriod and b.fperiod <= ssc.fcurrPeriod ").append(" then b.fyearcredit").append(suffix).append(" \r\n");
            sql.append(" else 0 end) fyearcredit").append(suffix).append(", \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fyearcredit").append(suffix).append(" \r\n");
            sql.append(" else b.fyearcredit").append(suffix).append(" end) fyearcredit").append(suffix).append(", \r\n");
        }
        return sql.toString();
    }

    private String getQtySelectSQL() throws EASBizException, BOSException {
        Integer startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        Integer endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        Integer endPeriodYear = this.cond.getPeriodYearEnd();
        boolean isAfterPeriodIncluded = this.cond.isAfterCurrPeriod();
        StringBuffer sql = new StringBuffer();
        sql.append(" ,sum(case \r\n");
        sql.append(" when ").append(startPeriod).append(" < ssc.fstartPeriod and b.fperiod = ssc.fstartPeriod then b.fbeginQty \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(startPeriod).append(" >= ssc.fstartPeriod and ").append(startPeriod).append(" <= ssc.fcurrPeriod and b.fperiod = ").append(startPeriod).append(" then b.fbeginQty \r\n");
            sql.append(" when ").append(startPeriod).append(" > ssc.fcurrPeriod and b.fperiod = ssc.fcurrPeriod then b.fendQty \r\n");
            sql.append(" when ").append(startPeriod).append(" > ssc.fcurrPeriod and b.fperiod > ssc.fcurrPeriod and b.fperiod < ").append(startPeriod).append(" then b.fdebitQty - b.fcreditQty \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(startPeriod).append(" then b.fbeginqty").append(" \r\n");
        }
        sql.append(" else 0 end) fbeginQty,\r\n");
        sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >=ssc.fstartPeriod then b.FDebitQty").append(" else 0 end").append(") FDebitQty,");
        sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >=ssc.fstartPeriod then b.FCreditQty").append(" else 0 end").append(") FCreditQty,");
        sql.append(" sum(case \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.fstartPeriod and ").append(endPeriod).append(" <= ssc.fcurrPeriod and b.fperiod = ").append(endPeriod).append(" then b.fyeardebitQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod = ssc.fcurrPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fyeardebitQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod > ssc.fcurrPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fdebitQty \r\n");
            sql.append(" else 0 end) fyeardebitQty, \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fyeardebitQty \r\n");
            sql.append(" else b.fyeardebitQty end) fyeardebitQty, \r\n");
        }
        sql.append(" sum(case \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.fstartPeriod and ").append(endPeriod).append(" <= ssc.fcurrPeriod and b.fperiod = ").append(endPeriod).append(" then b.fyearcreditQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod = ssc.fcurrPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fyearcreditQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod > ssc.fcurrPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append("  then b.fcreditQty \r\n");
            sql.append(" else 0 end) fyearcreditQty, \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fyearcreditQty \r\n");
            sql.append(" else b.fyearcreditQty end) fyearcreditQty, \r\n");
        }
        sql.append(" sum(case \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.fstartPeriod and ").append(endPeriod).append(" <= ssc.fcurrPeriod and b.fperiod = ").append(endPeriod).append(" then b.fendQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod = ssc.fcurrPeriod then b.fendQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.fcurrPeriod and b.fperiod > ssc.fcurrPeriod then b.fdebitQty - b.fcreditQty \r\n");
            sql.append(" else 0 end) fendQty \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fendQty \r\n");
            sql.append(" else b.fendQty end) fendQty \r\n");
        }
        return sql.toString();
    }

    protected void insertOTPeriodAccountBalance() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT  INTO ");
        sql.append(this.strFirstTempTable);
        sql.append(" \r\n");
        sql.append("SELECT b.FAccountID , b.FCurrencyID , \r\n");
        sql.append("   b.FPeriod FPeriod, \r\n");
        sql.append("   0.0  FBeginBalanceFor,0.0  FDebitFor,0.0  FCreditFor, \r\n");
        sql.append("   0.0  FYearDebitFor,0.0  FYearCreditFor, 0.0  FEndBalanceFor, \r\n");
        sql.append("   0.0  FBeginBalanceLocal,0.0  FDebitLocal,0.0  FCreditLocal,  \r\n");
        sql.append("   0.0  FYearDebitLocal, 0.0  FYearCreditLocal,0.0  FEndBalance, \r\n");
        sql.append("   0.0  FBeginBalanceRpt, 0.0  FDebitRpt, 0.0  FCreditRpt, \r\n");
        sql.append("   0.0  FYearDebitRpt, 0.0  FYearCreditRpt, 0.0  FEndBalanceRpt,  \r\n");
        sql.append("   0.0  FBeginQty, 0.0  FDebitQty, 0.0  FCreditQty, \r\n");
        sql.append("   0.0  FYearDebitQty, 0.0  FYearCreditQty, 0.0  FEndQty  \r\n");
        sql.append("\tFROM \r\n");
        sql.append("   (SELECT TC.FAccountID,TB.FPeriod,TC.FCurrencyid \r\n");
        sql.append("\tFROM  \r\n");
        sql.append(" (select distinct FAccountID,FCurrencyID from \r\n");
        sql.append(this.strFirstTempTable).append(")as TC,");
        sql.append("   (SELECT FNumber FPeriod \r\n");
        sql.append("\tFROM T_BD_Period  \r\n");
        sql.append("\tWHERE FTypeID =  '").append(this.cond.getPeriodTypeId()).append("'");
        sql.append(" AND FNumber in" + SQLUtil.buildPeriodNumbersInSql(this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart(), this.cond.getPeriodYearEnd(), this.cond.getPeriodNumberEnd()));
        sql.append(") AS TB \r\n");
        sql.append("\t) AS b  \r\n");
        sql.append("\tLEFT OUTER JOIN ").append(this.strFirstTempTable).append(" AS T ON b.FAccountID = T.FAccountID \r\n");
        sql.append("   AND b.FPeriod = T.FPeriod \r\n");
        sql.append("   AND b.FCurrencyID = T.FCurrencyID \r\n");
        sql.append("WHERE T.FAccountID is null \r\n");
        DbUtil.execute((Context)this.getContex(), (String)sql.toString());
    }

    protected void insertOtherAccountBalance() throws EASBizException, BOSException {
        String userID = ContextUtil.getCurrentUserInfo((Context)this.getContex()).getId().toString();
        String companyID = this.cond.getCompany().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT  INTO ");
        sql.append(this.strFirstTempTable);
        sql.append(" \r\n");
        sql.append("SELECT b.FAccountID,");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" b.").append(this.getTempDataOrgSelectSql());
        }
        if (this.isAllCurrency()) {
            sql.append(" b.FCurrencyID, ");
        } else {
            sql.append(" isnull(b.FCurrencyID,'").append(this.getCompany().getBaseCurrency().getId().toString()).append("') FCurrencyID, ");
        }
        sql.append("   b.FPeriod, \r\n");
        if (this.cond.isShowFor()) {
            sql.append("   0.0  FBeginBalanceFor,0.0  FDebitFor,0.0  FCreditFor, \r\n");
            sql.append("   0.0  FYearDebitFor,0.0  FYearCreditFor,  \r\n");
        } else if (this.cond.isAfterCurrPeriod() && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
            sql.append("   0.0  FDebitFor,0.0  FCreditFor, \r\n");
        }
        try {
            if (this.cond.isShowLocal()) {
                sql.append("   0.0  FBeginBalanceLocal,0.0  FDebitLocal,0.0  FCreditLocal,  \r\n");
                sql.append("   0.0  FYearDebitLocal, 0.0  FYearCreditLocal, \r\n");
            } else if (this.cond.isAfterCurrPeriod() && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
                sql.append("   0.0  FDebitLocal,0.0  FCreditLocal,  \r\n");
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        try {
            if (this.cond.isShowRpt()) {
                sql.append("   0.0  FBeginBalanceRpt, 0.0  FDebitRpt, 0.0  FCreditRpt, \r\n");
                sql.append("   0.0  FYearDebitRpt, 0.0  FYearCreditRpt,   \r\n");
            } else if (this.cond.isAfterCurrPeriod() && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID())) {
                sql.append("   0.0  FDebitRpt, 0.0  FCreditRpt, \r\n");
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        sql.append("   0.0  FEndBalanceFor, 0.0  FEndBalance, 0.0  FEndBalanceRpt \r\n");
        if (this.cond.isShowQty()) {
            sql.append("   ,0.0  FBeginQty, 0.0  FDebitQty, 0.0  FCreditQty, \r\n");
            sql.append("   0.0  FYearDebitQty, 0.0  FYearCreditQty, 0.0  FEndQty  \r\n");
        }
        if (this.cond.isAfterCurrPeriod()) {
            sql.append(" ,CASE WHEN (b.fperiod > ").append(this.cond.getCurrPeriod().getNumber()).append(") THEN 1 ELSE 0 END FIsAfterCurrPeriod ");
        }
        sql.append("FROM \r\n");
        sql.append("   (SELECT distinct TA.FNumber,TA.FID AS FAccountID,TA.").append(this.getTempDataOrgSelectSql()).append(" TB.FPeriod,");
        sql.append(" TA.FCurrencyID FCurrencyID \r\n");
        sql.append("\tFROM  \r\n");
        this.setOtherAccountOrgFilterSql(sql);
        if (this.isAllCurrency()) {
            sql.append(" AND ((av.FCurrencyID != '").append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID).append("'");
            sql.append(" AND av.FCurrencyID != '").append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID).append("'");
            sql.append(" ) OR av.FCurrencyID IS NULL) ");
        } else {
            sql.append(" AND (av.FCurrencyID = '").append(this.cond.getCurrencyID()).append("' ");
            sql.append(" OR av.FCurrencyID IS NULL) \r\n");
        }
        String accountFilterSql = new GLRptAccountFilter(this.getContex(), this.cond, "av", "av.fid", "av.fcompanyid", false, true, this.cond.getCompanyIdsStr()).getSQL();
        if (accountFilterSql != null) {
            sql.append(" \r\n AND ");
            sql.append(accountFilterSql);
        }
        sql.append(") TA , \r\n");
        sql.append("   (SELECT FNumber FPeriod \r\n");
        sql.append("\tFROM T_BD_Period  \r\n");
        sql.append("\tWHERE FTypeID =  '").append(this.cond.getPeriodTypeId()).append("' ");
        sql.append(" AND FNumber in" + SQLUtil.buildPeriodNumbersInSql(this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart(), this.cond.getPeriodYearEnd(), this.cond.getPeriodNumberEnd()));
        sql.append(") TB \r\n");
        sql.append("\t) b \r\n");
        sql.append("\tLEFT OUTER JOIN \n( select tav.FNumber,TP.* from ");
        sql.append(this.strFirstTempTable);
        sql.append(" TP inner join t_bd_accountView tav on tav.FID=TP.FAccountID and tav.fisProfitCenter <> 1  ) T \r\n");
        sql.append("\tON b.FNumber = T.FNumber \r\n");
        sql.append("   AND b.FPeriod = T.FPeriod \r\n");
        sql.append("   AND b.FCurrencyID = T.FCurrencyID \r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(this.getOtherAcountOrgWhereSql());
        }
        sql.append("   WHERE T.FAccountID is null ");
        DbUtil.execute((Context)this.getContex(), (String)sql.toString());
    }

    protected void insertBalanceAndTotal() throws EASBizException, BOSException {
        this.insertYearBeginBalance();
        this.insertPeriodTotal();
        this.insertYearTotal();
    }

    protected void deleteDataWithConditionForVirtual() throws BOSException, EASBizException {
        String companyId = this.cond.getCompany().getId().toString();
        String companyIdsStr = this.cond.getCompanyIdsStr();
        if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
            StringBuffer sb = new StringBuffer();
            sb.append("delete from ").append(this.getDataSourceTableName()).append(" \n where ");
            sb.append("  accountNumber||").append(this.getOrgUnitIDField().getName()).append(" not in (\n");
            sb.append(" select accountNumber||").append(this.getOrgUnitIDField().getName()).append(" from (\n");
            sb.append(" select count(1) cc, accountNumber,").append(this.getOrgUnitIDField().getName()).append(" from ").append(this.getDataSourceTableName());
            if (this.cond.isOptionAmountAndBalZero()) {
                sb.append("\n where (");
                if (this.isShowRpt()) {
                    sb.append("  fDebitRpt<>0 or fCreditRpt<>0 or");
                }
                if (this.isShowFor()) {
                    sb.append("  fDebitFor<>0 or fCreditFor<>0 or");
                }
                if (this.isShowLocal()) {
                    sb.append("  fDebitLocal<>0 or fCreditLocal<>0    ");
                }
                sb.delete(sb.length() - 2, sb.length());
                sb.append(" ) ");
                sb.append("\n or((");
                if (this.isShowRpt()) {
                    sb.append("  fDebitRpt=0 and fCreditRpt=0 and");
                }
                if (this.isShowFor()) {
                    sb.append("  fDebitFor=0 and fCreditFor=0 and");
                }
                if (this.isShowLocal()) {
                    sb.append("  fDebitLocal=0 and fCreditLocal=0     ");
                }
                sb.delete(sb.length() - 3, sb.length());
                sb.append(" ) and ( ");
                sb.append("  fEndBalanceRpt<>0 or");
                sb.append("  fEndBalanceFor<>0 or");
                sb.append("  fEndBalanceLocal<>0   ");
                sb.delete(sb.length() - 2, sb.length());
                sb.append(" ) )");
            } else if (this.cond.isOptionAmountZero()) {
                sb.append("\n where ( ");
                if (this.isShowRpt()) {
                    sb.append("  fDebitRpt<>0 or fCreditRpt<>0 or");
                }
                if (this.isShowFor()) {
                    sb.append("  fDebitFor<>0 or fCreditFor<>0 or");
                }
                if (this.isShowLocal()) {
                    sb.append("  fDebitLocal<>0 or fCreditLocal<>0    ");
                }
                sb.delete(sb.length() - 2, sb.length());
                sb.append(" )  AND FBalType = 1");
            }
            sb.append("\n group by accountNumber,").append(this.getOrgUnitIDField().getName()).append("").append("\n) as TT where TT.cc>0").append("\n)");
            DbUtil.execute((Context)this.getContex(), (String)sb.toString());
        }
    }

    protected void insertCompanySum() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" PAV.FID");
        sql.append(" ,TP.accountNumber");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(",cp.FParentID ");
        }
        sql.append(this.getOrgUnitIDField().getName());
        if (this.isAllCurrency()) {
            sql.append(",TP.FCurrencyID");
            sql.append(",TP.FIsCurrencyTotal ");
        }
        sql.append(" ,TP.FPeriod ");
        sql.append(" ,TP.FBalType ");
        if (this.isShowQty()) {
            sql.append(",sum(FDebitQty) FDebitQty");
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FDebitFor) FDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FDebitLocal) FDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FDebitRpt) FDebitRpt");
        }
        if (this.isShowQty()) {
            sql.append(",sum(FCreditQty) FCreditQty");
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FCreditFor) FCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FCreditLocal) FCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FCreditRpt) FCreditRpt");
        }
        if (this.isShowQty()) {
            sql.append(",sum(FEndQty) FEndQty");
        }
        sql.append(",SUM(FEndBalanceFor) FEndBalanceFor");
        sql.append(",SUM(FEndBalanceLocal) FEndBalanceLocal");
        sql.append(",SUM(FEndBalanceRpt) FEndBalanceRpt");
        sql.append(" \r\n");
        sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TP \r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(this.getOrgInnerJoinSql());
        }
        if (CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode()) {
            sql.append(" left outer join t_bd_accountview AV on AV.fid = TP.FAccountID and AV.fisProfitCenter <> 1 ");
            sql.append(" left outer join t_bd_accountview PAV on AV.FNumber = PAV.FNumber and AV.FAccountTableID = PAV.FAccountTableID and PAV.fisProfitCenter <> 1  ");
            if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
                sql.append(" and PAV.FCompanyID = cp.FParentID ");
            } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
                sql.append(" and PAV.FCompanyID = '").append(this.cond.getCompany().getId().toString()).append("'");
            }
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" where ");
            sql.append(" cp.flevel = ? ");
        }
        sql.append(" group by ");
        sql.append("PAV.FID, ");
        sql.append(" TP.accountNumber");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(",cp.FParentID ");
        }
        if (this.isAllCurrency()) {
            sql.append(",TP.FCurrencyID,TP.FIsCurrencyTotal ");
        }
        sql.append(" ,TP.FPeriod ");
        sql.append(" ,TP.FBalType ");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            int maxLevel;
            for (int i = maxLevel = this.getMaxCompanyLevel(); i > this.getOrgLevel(); --i) {
                ArrayList<Integer> sp = new ArrayList<Integer>();
                sp.add(new Integer(i));
                this.insertData(sql.toString(), sp);
            }
        }
    }

    protected void insertYearBeginBalance() throws EASBizException, BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(this.getTempDataSelectSql(0));
        strBuffer.append(" FROM \t\r\n");
        strBuffer.append(this.getTempDataSumSelectSql(0));
        strBuffer.append("\t  FROM ");
        strBuffer.append(this.strFirstTempTable);
        strBuffer.append("  T1 INNER JOIN \r\n");
        strBuffer.append("       (SELECT distinct FAccountID FAccountID, \r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append(this.getTempDataOrgSelectSql());
        }
        strBuffer.append("           min(FPeriod) FYearNumber from \r\n ");
        strBuffer.append(this.strFirstTempTable);
        strBuffer.append("    where fperiod>= ").append(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart()).append("    GROUP BY FAccountid  ");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append("    ,").append(this.getOrgUnitIDField().getName()).append(" ) T2 \r\n");
        } else {
            strBuffer.append("    ) T2 \r\n");
        }
        strBuffer.append("       ON T1.FaccountId = T2.FaccountID ");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append("    and T1.").append(this.getOrgUnitIDField().getName()).append("=T2.").append(this.getOrgUnitIDField().getName()).append(" \r\n");
        } else {
            strBuffer.append("     \r\n");
        }
        strBuffer.append("          AND T1.FPeriod = T2.FYearNumber \r\n");
        strBuffer.append("\t     GROUP BY T1.FAccountID ,T1.FCurrencyID");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append("    ,T1.").append(this.getOrgUnitIDField().getName()).append(",T1.FPeriod ) M \r\n");
        } else {
            strBuffer.append("     ,T1.FPeriod ) M \r\n");
        }
        strBuffer.append("       INNER JOIN T_BD_AccountView TA ON M.FAccountID = TA.FID \r\n");
        strBuffer.append("       LEFT JOIN t_BD_CURRENCY TC ON M.FCurrencyID = TC.FID \r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append(" where 1=1 ");
        } else {
            strBuffer.append(" WHERE TA.FAccountTableID = '").append(this.cond.getAccountTableId()).append("' \r\n");
            strBuffer.append(" AND TA.FLevel >= 1 and TA.fisProfitCenter <> 1 ");
            strBuffer.append(" AND TA.FLevel <= ").append(this.cond.getAccountLevelEnd()).append(" \r\n");
        }
        String accountFilter = new GLRptAccountFilter(this.getContex(), this.cond, "TA", "TA.fid", "TA.fcompanyid", false, true, this.cond.getCompanyIdsStr()).getSQL();
        if (accountFilter != null) {
            strBuffer.append(" AND ").append(accountFilter).append(" \n");
        }
        this.insertData(strBuffer.toString());
    }

    protected void insertPeriodTotal() throws EASBizException, BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(this.getTempDataSelectSql(1));
        strBuffer.append(" FROM  \r\n");
        strBuffer.append(this.getTempDataSumSelectSql(1));
        strBuffer.append("\t   FROM ");
        strBuffer.append(this.strFirstTempTable);
        strBuffer.append("  \r\n");
        strBuffer.append("\twhere fperiod>= ").append(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart());
        strBuffer.append("   GROUP BY FAccountID ,FCurrencyID");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append("    ,").append(this.getOrgUnitIDField().getName()).append(",FPeriod ) AS M \r\n");
        } else {
            strBuffer.append("    ,FPeriod ) AS M \r\n");
        }
        strBuffer.append("        INNER JOIN T_BD_AccountView TA \r\n");
        strBuffer.append("\t         ON M.FAccountID = TA.FID \r\n");
        strBuffer.append("        LEFT JOIN T_BD_CURRENCY TC \r\n");
        strBuffer.append("           ON M.FCurrencyID = TC.FID \r\n");
        strBuffer.append("     WHERE \r\n");
        strBuffer.append("\t      TA.FAccountTableID = '").append(this.cond.getAccountTableId()).append("' ");
        strBuffer.append("        AND TA.FLevel >= 1 and TA.fisProfitCenter <> 1 ");
        strBuffer.append("        AND TA.FLevel <= ").append(this.cond.getAccountLevelEnd());
        String accountFilter = new GLRptAccountFilter(this.getContex(), this.cond, "TA", "TA.fid", "TA.fcompanyid", false, true, this.cond.getCompanyIdsStr()).getSQL();
        if (accountFilter != null) {
            strBuffer.append(" AND ").append(accountFilter).append(" \n");
        }
        if (this.cond.getNoDisplayZeroTotal()) {
            if (this.cond.isShowFor() && this.cond.isShowLocal()) {
                strBuffer.append(" AND (M.FDebitLocal<>0 OR M.FCreditLocal<>0 OR M.FDebitFor<>0 OR M.FCreditFor<>0)");
            } else if (this.cond.isShowFor()) {
                strBuffer.append(" AND ( M.FDebitFor<>0 OR M.FCreditFor<>0 ) ");
            } else if (this.cond.isShowLocal()) {
                strBuffer.append(" AND ( M.FDebitLocal<>0 OR M.FCreditLocal<>0 ) ");
            }
        }
        this.insertData(strBuffer.toString());
    }

    protected void insertYearTotal() throws EASBizException, BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(this.getTempDataSelectSql(2));
        strBuffer.append(" FROM  \r\n");
        strBuffer.append(this.getTempDataSumSelectSql(2));
        strBuffer.append("\t   FROM \r\n");
        strBuffer.append(this.strFirstTempTable);
        strBuffer.append("   \r\n");
        strBuffer.append("\twhere fperiod>= ").append(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart());
        strBuffer.append("   GROUP BY FAccountID ,FCurrencyID");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append("    ,").append(this.getOrgUnitIDField().getName()).append(",FPeriod ) AS M \r\n");
        } else {
            strBuffer.append("    ,FPeriod ) AS M \r\n");
        }
        strBuffer.append("     INNER JOIN T_BD_AccountView TA \r\n");
        strBuffer.append("\t      ON M.FAccountID = TA.FID \r\n");
        strBuffer.append("     LEFT JOIN T_BD_CURRENCY TC \r\n");
        strBuffer.append("        ON M.FCurrencyID = TC.FID \r\n");
        strBuffer.append(" WHERE \r\n");
        strBuffer.append("\t   TA.FAccountTableID = '").append(this.cond.getAccountTableId()).append("' ");
        strBuffer.append("     AND TA.FLevel >= 1 and TA.fisProfitCenter <> 1 ");
        strBuffer.append("     AND TA.FLevel <= ").append(this.cond.getAccountLevelEnd());
        String accountFilter = new GLRptAccountFilter(this.getContex(), this.cond, "TA", "TA.fid", "TA.fcompanyid", false, true, this.cond.getCompanyIdsStr()).getSQL();
        if (accountFilter != null) {
            strBuffer.append(" AND ").append(accountFilter).append(" \n");
        }
        if (this.cond.getNoDisplayZeroTotal()) {
            if (this.cond.isShowFor() && this.cond.isShowLocal()) {
                strBuffer.append(" AND (M.FDebitLocal<>0 OR M.FCreditLocal<>0 OR M.FDebitFor<>0 OR M.FCreditFor<>0)");
            } else if (this.cond.isShowFor()) {
                strBuffer.append(" AND ( M.FDebitFor<>0 OR M.FCreditFor<>0)");
            } else if (this.cond.isShowLocal()) {
                strBuffer.append(" AND (M.FDebitLocal<>0 OR M.FCreditLocal<>0 )");
            }
        }
        this.insertData(strBuffer.toString());
    }

    private void insertAllCurrencySum() throws EASBizException, BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT  FAccountID,");
        strBuffer.append(" accountNumber,");
        strBuffer.append("  'xiaojiID' FCurrencyID, ");
        strBuffer.append("  1 FIsCurrencyTotal, ");
        strBuffer.append("    FPeriod, FBalType, \r\n");
        if (this.isShowQty()) {
            strBuffer.append("    sum(FDebitQty)  FDebitQty,");
        }
        if (this.isShowFor()) {
            strBuffer.append("    to_decimal(null) FDebitFor,");
        }
        if (this.isShowLocal()) {
            strBuffer.append("    sum(FDebitLocal) FDebitLocal,");
        }
        if (this.isShowRpt()) {
            strBuffer.append("    sum(FDebitRpt) FDebitRpt,");
        }
        if (this.isShowQty()) {
            strBuffer.append("    sum(FCreditQty) FCreditQty,");
        }
        if (this.isShowFor()) {
            strBuffer.append("    to_decimal(null) FCreditFor,");
        }
        if (this.isShowLocal()) {
            strBuffer.append("    sum(FCreditLocal) FCreditLocal,");
        }
        if (this.isShowRpt()) {
            strBuffer.append("    sum(FCreditRpt) FCreditRpt,");
        }
        if (this.isShowQty()) {
            strBuffer.append("    sum(FEndQty) FEndQty,");
        }
        strBuffer.append("    to_decimal(null) FEndBalanceFor,");
        strBuffer.append("    sum(FEndBalanceLocal) FEndBalanceLocal,");
        strBuffer.append("    sum(FEndBalanceRpt) FEndBalanceRpt");
        String sql = strBuffer.toString();
        if (sql.endsWith(",")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        strBuffer.delete(0, strBuffer.length());
        strBuffer.append(sql);
        strBuffer.append("\t   FROM  \r\n");
        strBuffer.append(this.getDataSourceTableName()).append(" \r\n");
        strBuffer.append("\t   GROUP BY FAccountID,accountNumber,FPeriod, FBalType \r\n");
        this.insertData(strBuffer.toString());
    }

    private void afterCurrentPeriodData() throws BOSException, EASBizException {
        class MyInnerClass0 {
            private String tempTableName = null;
            private boolean isAllCurrencyQ = false;

            MyInnerClass0(String tempTable, boolean isAllCurrency) {
                this.tempTableName = tempTable;
                this.isAllCurrencyQ = isAllCurrency;
            }

            private void setYearUpdt(StringBuffer sql, String yearcolumn, String column) {
                sql.append("\n ").append(yearcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                sql.append("\n + (select sum(").append(column).append(") from ").append(this.tempTableName);
                sql.append(" ta where ta.fperiod <= ").append(this.tempTableName);
                sql.append(".fperiod ");
                sql.append(" and fperiod >= ").append((curYear + 1) * 100).append(" and ta.faccountid = ");
                sql.append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and ta.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and FBalType = 1");
                sql.append(" )  ,");
            }

            private void setEndUpdt(StringBuffer sql, String yearcolumn, String endcolumn) {
                sql.append("\n ").append(endcolumn).append(" = ").append(" case when FBalType = 2 then(to_decimal(0.0,19,4)   ");
                sql.append(" + ").append(yearcolumn);
                sql.append("\n + ISNULL((select sum(").append(yearcolumn).append(") from ").append(this.tempTableName).append(" td where ( ");
                sql.append("  td.fperiod < ").append((curYear + 1) * 100).append(")");
                sql.append(" and fperiod >").append(curPeriodOrder).append(" and td.faccountid = ").append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and td.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and FBalType = 1");
                sql.append(" ),0.0000)");
                sql.append(" \n     + ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName).append(" tc ").append(" where tc.fperiod = ").append(curPeriodOrder).append(" and tc.faccountid = ").append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and tc.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and tc.FBalType = 1");
                sql.append(" ),0.0000)) ");
                sql.append(" \n  else  ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName).append(" tc ").append(" where tc.fperiod = ").append(queryBeginPeriodOrder).append(" and tc.faccountid = ").append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and tc.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and tc.FBalType = 1");
                sql.append(" ),0.0000)");
                sql.append("\n + ISNULL((select sum(").append(yearcolumn).append(") from ").append(this.tempTableName).append(" ta where ta.fperiod <= ").append(this.tempTableName).append(".fperiod ").append(" and fperiod >").append(queryBeginPeriodOrder).append(" and ta.faccountid = ").append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and ta.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and FBalType = 1");
                sql.append(" ),0.0000) end,");
            }
        }
        class MyInnerClass {
            private String tempTableName = null;
            private boolean isAllCurrencyQ = false;

            MyInnerClass(String tempTable, boolean isAllCurrency) {
                this.tempTableName = tempTable;
                this.isAllCurrencyQ = isAllCurrency;
            }

            private void setYearUpdt(StringBuffer sql, String yearcolumn, String column) {
                sql.append("\n ").append(yearcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                sql.append("\n + (select sum(").append(column).append(") from ").append(this.tempTableName);
                sql.append(" ta where ta.fperiod <= ").append(this.tempTableName);
                sql.append(".fperiod ");
                sql.append(" and fperiod >").append(curPeriodOrder).append(" and ta.faccountid = ");
                sql.append(this.tempTableName).append(".faccountid  ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and ta.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and FBalType = 1 ").append(" )");
                sql.append("\n      +  case when (select ").append(yearcolumn).append(" from ").append(this.tempTableName).append(" tb ");
                sql.append(" where tb.fperiod = ").append(curPeriodOrder).append(" and tb.faccountid = ");
                sql.append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and tb.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and tb.FBalType = 2 ");
                sql.append(" ) is null then to_decimal(0.0,19,4) ").append(" else (select ").append(yearcolumn);
                sql.append(" from ").append(this.tempTableName).append(" tb ").append(" where tb.fperiod = ");
                sql.append(curPeriodOrder).append(" and tb.faccountid = ").append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and tb.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and tb.FBalType = 2 ").append(" ) end ,");
            }

            private void setEndUpdt(StringBuffer sql, String yearcolumn, String endcolumn) {
                sql.append("\n ").append(endcolumn).append(" = ").append(" case when FBalType = 2 then(to_decimal(0.0,19,4)   ");
                sql.append(" + ").append(yearcolumn);
                sql.append("\n      - ISNULL((select ").append(yearcolumn).append(" from ").append(this.tempTableName).append(" tb ").append(" where tb.fperiod = ").append(curPeriodOrder).append(" and tb.faccountid = ").append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and tb.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and tb.FBalType = 2");
                sql.append(" ),0.0000)");
                sql.append(" \n     + ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName).append(" tc ").append(" where tc.fperiod = ").append(curPeriodOrder).append(" and tc.faccountid = ").append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and tc.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and tc.FBalType = 1");
                sql.append(" ),0.0000)) ");
                sql.append(" \n  else  ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName).append(" tc ").append(" where tc.fperiod = ").append(queryBeginPeriodOrder).append(" and tc.faccountid = ").append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and tc.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and tc.FBalType = 1");
                sql.append(" ),0.0000)");
                sql.append("\n + ISNULL((select sum(").append(yearcolumn).append(") from ").append(this.tempTableName).append(" ta where ta.fperiod <= ").append(this.tempTableName).append(".fperiod ").append(" and fperiod >").append(queryBeginPeriodOrder).append(" and ta.faccountid = ").append(this.tempTableName).append(".faccountid ");
                if (this.isAllCurrencyQ) {
                    sql.append(" and ta.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid");
                }
                sql.append(" and FBalType = 1");
                sql.append(" ),0.0000) end,");
            }
        }
        final int curYear = this.cond.getCurrPeriod().getPeriodYear();
        int toYear = this.cond.getPeriodYearEnd();
        final int curPeriodOrder = this.cond.getCurrPeriod().getNumber();
        final int queryBeginPeriodOrder = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            if (this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd() > curPeriodOrder) {
                StringBuffer updateBalance = new StringBuffer();
                updateBalance.append(" update  ").append(this.getDataSourceTableName()).append(" set   ");
                MyInnerClass myInner = new MyInnerClass(this.getDataSourceTableName(), this.isAllCurrency());
                if (this.isShowQty()) {
                    myInner.setYearUpdt(updateBalance, "Fdebitqty", "Fdebitqty");
                }
                if (this.isShowFor()) {
                    myInner.setYearUpdt(updateBalance, "Fdebitfor", "Fdebitfor");
                }
                if (this.isShowLocal()) {
                    myInner.setYearUpdt(updateBalance, "Fdebitlocal", "Fdebitlocal");
                }
                if (this.isShowRpt()) {
                    myInner.setYearUpdt(updateBalance, "Fdebitrpt", "Fdebitrpt");
                }
                if (this.isShowQty()) {
                    myInner.setYearUpdt(updateBalance, "Fcreditqty", "Fcreditqty");
                }
                if (this.isShowFor()) {
                    myInner.setYearUpdt(updateBalance, "Fcreditfor", "Fcreditfor");
                }
                if (this.isShowLocal()) {
                    myInner.setYearUpdt(updateBalance, "Fcreditlocal", "Fcreditlocal");
                }
                if (this.isShowRpt()) {
                    myInner.setYearUpdt(updateBalance, "Fcreditrpt", "Fcreditrpt");
                }
                updateBalance.deleteCharAt(updateBalance.length() - 1);
                updateBalance.append("\r\nwhere fperiod >").append(curPeriodOrder);
                if (curYear < toYear) {
                    updateBalance.append(" and fperiod < ").append((curYear + 1) * 100);
                }
                updateBalance.append(" and FBalType = 2 ");
                Iterator it = this.cond.getCompanyIds().iterator();
                while (it.hasNext()) {
                    String sql = updateBalance.toString();
                    String orgID = (String)it.next();
                    sql = sql.replaceAll("FBalType = 1", "FBalType = 1 and ta.FOrgUnitID = '" + orgID + "' ");
                    sql = sql.replaceAll("tb.FBalType = 2", "tb.FBalType = 2 and tb.FOrgUnitID = '" + orgID + "' ");
                    DbUtil.execute((Context)this.getContex(), (String)(sql + " and FOrgUnitID = '" + orgID + "' "));
                }
                updateBalance.setLength(0);
                updateBalance.append(" update  ").append(this.getDataSourceTableName()).append(" set   ");
                if (this.isShowFor()) {
                    myInner.setEndUpdt(updateBalance, "Fdebitfor - Fcreditfor", "FEndBalanceFor");
                }
                if (this.isShowLocal()) {
                    myInner.setEndUpdt(updateBalance, "FdebitLocal - FcreditLocal", "FEndBalanceLocal");
                }
                if (this.isShowRpt()) {
                    myInner.setEndUpdt(updateBalance, "FdebitRpt - FcreditRpt", "FEndBalanceRpt");
                }
                if (this.isShowQty()) {
                    myInner.setEndUpdt(updateBalance, "Fdebitqty - Fcreditqty", "FEndqty");
                }
                updateBalance.deleteCharAt(updateBalance.length() - 1);
                updateBalance.append("\r\nwhere fperiod >").append(curPeriodOrder);
                if (curYear < toYear) {
                    updateBalance.append(" and fperiod < ").append((curYear + 1) * 100);
                }
                updateBalance.append(" and (FBalType =1 or FBalType =2 )");
                Iterator it1 = this.cond.getCompanyIds().iterator();
                while (it1.hasNext()) {
                    String sql = updateBalance.toString();
                    String orgID = (String)it1.next();
                    sql = sql.replaceAll("tc.FBalType = 1", "tc.FBalType = 1 and tc.FOrgUnitID = '" + orgID + "' ");
                    sql = sql.replaceAll("and FBalType = 1", "and FBalType = 1 and FOrgUnitID = '" + orgID + "' ");
                    sql = sql.replaceAll("tb.FBalType = 2", "tb.FBalType = 2 and tb.FOrgUnitID = '" + orgID + "' ");
                    DbUtil.execute((Context)this.getContex(), (String)(sql + " and FOrgUnitID = '" + orgID + "' "));
                }
                if (curYear < toYear) {
                    MyInnerClass0 myInner0 = new MyInnerClass0(this.getDataSourceTableName(), this.isAllCurrency());
                    updateBalance.setLength(0);
                    updateBalance.append(" update  ").append(this.getDataSourceTableName()).append(" set   ");
                    if (this.isShowQty()) {
                        myInner0.setYearUpdt(updateBalance, "Fdebitqty", "Fdebitqty");
                    }
                    if (this.isShowFor()) {
                        myInner0.setYearUpdt(updateBalance, "Fdebitfor", "Fdebitfor");
                    }
                    if (this.isShowLocal()) {
                        myInner0.setYearUpdt(updateBalance, "Fdebitlocal", "Fdebitlocal");
                    }
                    if (this.isShowRpt()) {
                        myInner0.setYearUpdt(updateBalance, "Fdebitrpt", "Fdebitrpt");
                    }
                    if (this.isShowQty()) {
                        myInner0.setYearUpdt(updateBalance, "Fcreditqty", "Fcreditqty");
                    }
                    if (this.isShowFor()) {
                        myInner0.setYearUpdt(updateBalance, "Fcreditfor", "Fcreditfor");
                    }
                    if (this.isShowLocal()) {
                        myInner0.setYearUpdt(updateBalance, "Fcreditlocal", "Fcreditlocal");
                    }
                    if (this.isShowRpt()) {
                        myInner0.setYearUpdt(updateBalance, "Fcreditrpt", "Fcreditrpt");
                    }
                    updateBalance.deleteCharAt(updateBalance.length() - 1);
                    updateBalance.append("\r\nwhere fperiod >= ").append((curYear + 1) * 100);
                    updateBalance.append(" and FBalType = 2 ");
                    Iterator it2 = this.cond.getCompanyIds().iterator();
                    while (it2.hasNext()) {
                        String sql = updateBalance.toString();
                        String orgID = (String)it2.next();
                        sql = sql.replaceAll("FBalType = 1", "FBalType = 1 and FOrgUnitID = '" + orgID + "' ");
                        DbUtil.execute((Context)this.getContex(), (String)(sql + " and FOrgUnitID = '" + orgID + "' "));
                    }
                    updateBalance.setLength(0);
                    updateBalance.append(" update  ").append(this.getDataSourceTableName()).append(" set   ");
                    if (this.isShowFor()) {
                        myInner0.setEndUpdt(updateBalance, "Fdebitfor - Fcreditfor", "FEndBalanceFor");
                    }
                    if (this.isShowLocal()) {
                        myInner0.setEndUpdt(updateBalance, "FdebitLocal - FcreditLocal", "FEndBalanceLocal");
                    }
                    if (this.isShowRpt()) {
                        myInner0.setEndUpdt(updateBalance, "FdebitRpt - FcreditRpt", "FEndBalanceRpt");
                    }
                    if (this.isShowQty()) {
                        myInner0.setEndUpdt(updateBalance, "Fdebitqty - Fcreditqty", "FEndqty");
                    }
                    updateBalance.deleteCharAt(updateBalance.length() - 1);
                    updateBalance.append("\r\nwhere fperiod >= ").append((curYear + 1) * 100);
                    updateBalance.append(" and (FBalType =1 or FBalType =2 )");
                    Iterator it3 = this.cond.getCompanyIds().iterator();
                    while (it3.hasNext()) {
                        String sql = updateBalance.toString();
                        String orgID = (String)it3.next();
                        sql = sql.replaceAll("and FBalType = 1", "and FBalType = 1 and FOrgUnitID = '" + orgID + "' ");
                        sql = sql.replaceAll("tc.FBalType = 1", "tc.FBalType = 1 and tc.FOrgUnitID = '" + orgID + "' ");
                        DbUtil.execute((Context)this.getContex(), (String)(sql + " and FOrgUnitID = '" + orgID + "' "));
                    }
                }
            }
        } else {
            String tName;
            StringBuffer strBuffer;
            if (!this.isAllCurrency()) {
                strBuffer = new StringBuffer();
                strBuffer.append("INSERT INTO ").append(this.getDataSourceTableName()).append(" select  distinct faccountid,accountnumber,fperiod, ");
                strBuffer.append(" CASE fbaltype  WHEN 0 THEN 4  WHEN 1 THEN 5  ELSE 6 END fbaltype ");
                if (this.isShowQty()) {
                    strBuffer.append("  , FDebitQty");
                }
                if (this.isShowFor()) {
                    strBuffer.append("  , FDebitFor");
                }
                if (this.isShowLocal()) {
                    strBuffer.append("  , FDebitLocal ");
                }
                if (this.isShowRpt()) {
                    strBuffer.append("  , FDebitRpt ");
                }
                if (this.isShowQty()) {
                    strBuffer.append("  , FCreditQty ");
                }
                if (this.isShowFor()) {
                    strBuffer.append("  , FCreditFor ");
                }
                if (this.isShowLocal()) {
                    strBuffer.append("  , FCreditLocal ");
                }
                if (this.isShowRpt()) {
                    strBuffer.append("  , FCreditRpt ");
                }
                if (this.isShowQty()) {
                    strBuffer.append("  , FEndQty ");
                    strBuffer.append("  , FEndPrice ");
                }
                strBuffer.append("  , FEndBalanceFor ");
                strBuffer.append("  , FEndBalanceLocal ");
                strBuffer.append(" ,  FEndBalanceRpt");
                strBuffer.append(" from ").append(this.getDataSourceTableName());
                strBuffer.append(" group by faccountid,accountnumber,fperiod,fbaltype ");
                if (this.isShowQty()) {
                    strBuffer.append("  , FDebitQty");
                }
                if (this.isShowFor()) {
                    strBuffer.append("  , FDebitFor");
                }
                if (this.isShowLocal()) {
                    strBuffer.append("  , FDebitLocal ");
                }
                if (this.isShowRpt()) {
                    strBuffer.append("  , FDebitRpt ");
                }
                if (this.isShowQty()) {
                    strBuffer.append("  , FCreditQty ");
                }
                if (this.isShowFor()) {
                    strBuffer.append("  , FCreditFor ");
                }
                if (this.isShowLocal()) {
                    strBuffer.append("  , FCreditLocal ");
                }
                if (this.isShowRpt()) {
                    strBuffer.append("  , FCreditRpt ");
                }
                if (this.isShowQty()) {
                    strBuffer.append("  , FEndQty ");
                    strBuffer.append("  , FEndPrice ");
                }
                strBuffer.append("  , FEndBalanceFor ");
                strBuffer.append("  , FEndBalanceLocal ");
                strBuffer.append(" ,  FEndBalanceRpt");
                strBuffer.append("  having count(*) > 1");
                DbUtil.execute((Context)this.getContex(), (String)strBuffer.toString());
                strBuffer = new StringBuffer();
                strBuffer.append("\tdelete from  \r\n");
                strBuffer.append(this.getDataSourceTableName());
                tName = this.getDataSourceTableName();
                strBuffer.append("  where exists ( select 1 from ( ");
                strBuffer.append("  select faccountid,accountnumber,fperiod,fbaltype,count(*) num from ");
                strBuffer.append(this.getDataSourceTableName());
                strBuffer.append("  group by faccountid,accountnumber,fperiod,fbaltype  having count(*)>1 \r\n");
                strBuffer.append("  ) T  where \r\n");
                strBuffer.append(tName).append(".faccountid = T.faccountid ");
                strBuffer.append("  and ").append(tName).append(".accountnumber = T.accountnumber ");
                strBuffer.append("  and ").append(tName).append(".FPeriod = T.FPeriod ");
                strBuffer.append("  and ").append(tName).append(".FBaltype = T.FBaltype ");
                if (this.isShowFor()) {
                    strBuffer.append("  and ").append("\tfDebitFor = 0 ");
                }
                if (this.isShowLocal()) {
                    strBuffer.append("  and ").append("  fDebitLocal = 0 ");
                }
                if (this.isShowRpt()) {
                    strBuffer.append("  and ").append("  fDebitRpt = 0 ");
                }
                if (this.isShowFor()) {
                    strBuffer.append("  and ").append(" fCreditFor = 0 ");
                }
                if (this.isShowLocal()) {
                    strBuffer.append("  and ").append(" fCreditLocal = 0 ");
                }
                if (this.isShowRpt()) {
                    strBuffer.append("  and ").append(" fCreditRpt = 0 ");
                }
                strBuffer.append("  and ").append("  FEndBalanceFor = 0 ");
                strBuffer.append("  and ").append("  FEndBalanceLocal = 0 ");
                strBuffer.append("  and ").append("  FEndBalanceRpt = 0 ) ");
                DbUtil.execute((Context)this.getContex(), (String)strBuffer.toString());
                String sql11 = "update " + this.getDataSourceTableName() + " set fbaltype =  CASE   fbaltype  WHEN 4 THEN 0  WHEN 5 THEN 1  when 6 then 2 else fbaltype END";
                DbUtil.execute((Context)this.getContex(), (String)sql11);
            }
            if (this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd() > curPeriodOrder) {
                StringBuffer updateBalance = new StringBuffer();
                updateBalance.append(" update  ").append(this.getDataSourceTableName()).append(" set   ");
                MyInnerClass myInner = new MyInnerClass(this.getDataSourceTableName(), this.isAllCurrency());
                if (this.isShowQty()) {
                    myInner.setYearUpdt(updateBalance, "Fdebitqty", "Fdebitqty");
                }
                if (this.isShowFor()) {
                    myInner.setYearUpdt(updateBalance, "Fdebitfor", "Fdebitfor");
                }
                if (this.isShowLocal()) {
                    myInner.setYearUpdt(updateBalance, "Fdebitlocal", "Fdebitlocal");
                }
                if (this.isShowRpt()) {
                    myInner.setYearUpdt(updateBalance, "Fdebitrpt", "Fdebitrpt");
                }
                if (this.isShowQty()) {
                    myInner.setYearUpdt(updateBalance, "Fcreditqty", "Fcreditqty");
                }
                if (this.isShowFor()) {
                    myInner.setYearUpdt(updateBalance, "Fcreditfor", "Fcreditfor");
                }
                if (this.isShowLocal()) {
                    myInner.setYearUpdt(updateBalance, "Fcreditlocal", "Fcreditlocal");
                }
                if (this.isShowRpt()) {
                    myInner.setYearUpdt(updateBalance, "Fcreditrpt", "Fcreditrpt");
                }
                updateBalance.deleteCharAt(updateBalance.length() - 1);
                updateBalance.append("\r\nwhere fperiod >").append(curPeriodOrder);
                if (curYear < toYear) {
                    updateBalance.append(" and fperiod < ").append((curYear + 1) * 100);
                }
                updateBalance.append(" and FBalType = 2 ");
                DbUtil.execute((Context)this.getContex(), (String)updateBalance.toString());
                updateBalance.setLength(0);
                updateBalance.append(" update  ").append(this.getDataSourceTableName()).append(" set   ");
                if (this.isShowFor()) {
                    myInner.setEndUpdt(updateBalance, "Fdebitfor - Fcreditfor", "FEndBalanceFor");
                }
                if (this.isShowLocal()) {
                    myInner.setEndUpdt(updateBalance, "FdebitLocal - FcreditLocal", "FEndBalanceLocal");
                }
                if (this.isShowRpt()) {
                    myInner.setEndUpdt(updateBalance, "FdebitRpt - FcreditRpt", "FEndBalanceRpt");
                }
                if (this.isShowQty()) {
                    myInner.setEndUpdt(updateBalance, "Fdebitqty - Fcreditqty", "FEndqty");
                }
                updateBalance.deleteCharAt(updateBalance.length() - 1);
                updateBalance.append("\r\nwhere fperiod >").append(curPeriodOrder);
                if (curYear < toYear) {
                    updateBalance.append(" and fperiod < ").append((curYear + 1) * 100);
                }
                updateBalance.append(" and (FBalType =1 or FBalType =2 )");
                DbUtil.execute((Context)this.getContex(), (String)updateBalance.toString());
                if (curYear < toYear) {
                    MyInnerClass0 myInner0 = new MyInnerClass0(this.getDataSourceTableName(), this.isAllCurrency());
                    updateBalance.setLength(0);
                    updateBalance.append(" update  ").append(this.getDataSourceTableName()).append(" set   ");
                    if (this.isShowQty()) {
                        myInner0.setYearUpdt(updateBalance, "Fdebitqty", "Fdebitqty");
                    }
                    if (this.isShowFor()) {
                        myInner0.setYearUpdt(updateBalance, "Fdebitfor", "Fdebitfor");
                    }
                    if (this.isShowLocal()) {
                        myInner0.setYearUpdt(updateBalance, "Fdebitlocal", "Fdebitlocal");
                    }
                    if (this.isShowRpt()) {
                        myInner0.setYearUpdt(updateBalance, "Fdebitrpt", "Fdebitrpt");
                    }
                    if (this.isShowQty()) {
                        myInner0.setYearUpdt(updateBalance, "Fcreditqty", "Fcreditqty");
                    }
                    if (this.isShowFor()) {
                        myInner0.setYearUpdt(updateBalance, "Fcreditfor", "Fcreditfor");
                    }
                    if (this.isShowLocal()) {
                        myInner0.setYearUpdt(updateBalance, "Fcreditlocal", "Fcreditlocal");
                    }
                    if (this.isShowRpt()) {
                        myInner0.setYearUpdt(updateBalance, "Fcreditrpt", "Fcreditrpt");
                    }
                    updateBalance.deleteCharAt(updateBalance.length() - 1);
                    updateBalance.append("\r\nwhere fperiod >= ").append((curYear + 1) * 100);
                    updateBalance.append(" and FBalType = 2 ");
                    DbUtil.execute((Context)this.getContex(), (String)updateBalance.toString());
                    updateBalance.setLength(0);
                    updateBalance.append(" update  ").append(this.getDataSourceTableName()).append(" set   ");
                    if (this.isShowFor()) {
                        myInner0.setEndUpdt(updateBalance, "Fdebitfor - Fcreditfor", "FEndBalanceFor");
                    }
                    if (this.isShowLocal()) {
                        myInner0.setEndUpdt(updateBalance, "FdebitLocal - FcreditLocal", "FEndBalanceLocal");
                    }
                    if (this.isShowRpt()) {
                        myInner0.setEndUpdt(updateBalance, "FdebitRpt - FcreditRpt", "FEndBalanceRpt");
                    }
                    if (this.isShowQty()) {
                        myInner0.setEndUpdt(updateBalance, "Fdebitqty - Fcreditqty", "FEndqty");
                    }
                    updateBalance.deleteCharAt(updateBalance.length() - 1);
                    updateBalance.append("\r\nwhere fperiod >= ").append((curYear + 1) * 100);
                    updateBalance.append(" and (FBalType =1 or FBalType =2 )");
                    DbUtil.execute((Context)this.getContex(), (String)updateBalance.toString());
                }
            }
            if (this.isAllCurrency() && this.cond.getShowTotal()) {
                strBuffer = new StringBuffer();
                strBuffer.append("\tdelete from \r\n");
                strBuffer.append(this.getDataSourceTableName()).append("  where ");
                if (this.isAllCurrency()) {
                    strBuffer.append(this.getDataSourceTableName()).append(".FIsCurrencyTotal = 0  and \r\n");
                }
                strBuffer.append("  not\t exists (select 1 from ( \r\n");
                strBuffer.append("  select * from (  SELECT  ");
                strBuffer.append(" FAccountID,");
                strBuffer.append(" accountNumber,");
                strBuffer.append("  FCurrencyID, ");
                strBuffer.append("  FPeriod, \r\n");
                if (this.isShowQty()) {
                    strBuffer.append("    sum(FDebitQty)  FDebitQty,");
                }
                if (this.isShowFor()) {
                    strBuffer.append("    sum(FDebitFor)  FDebitFor,");
                }
                if (this.isShowLocal()) {
                    strBuffer.append("    sum(FDebitLocal) FDebitLocal,");
                }
                if (this.isShowRpt()) {
                    strBuffer.append("    sum(FDebitRpt) FDebitRpt,");
                }
                if (this.isShowQty()) {
                    strBuffer.append("    sum(FCreditQty) FCreditQty,");
                }
                if (this.isShowFor()) {
                    strBuffer.append("    sum(FCreditFor) FCreditFor,");
                }
                if (this.isShowLocal()) {
                    strBuffer.append("    sum(FCreditLocal) FCreditLocal,");
                }
                if (this.isShowRpt()) {
                    strBuffer.append("    sum(FCreditRpt) FCreditRpt,");
                }
                if (this.isShowQty()) {
                    strBuffer.append("    sum(FEndQty) FEndQty,");
                }
                strBuffer.append("    sum(FEndBalanceFor) FEndBalanceFor,");
                strBuffer.append("    sum(FEndBalanceLocal) FEndBalanceLocal,");
                strBuffer.append("    sum(FEndBalanceRpt) FEndBalanceRpt");
                String sql = strBuffer.toString();
                if (sql.endsWith(",")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                strBuffer.delete(0, strBuffer.length());
                strBuffer.append(sql);
                strBuffer.append("\t   FROM  \r\n");
                strBuffer.append(this.getDataSourceTableName()).append(" \r\n");
                strBuffer.append("  where FIsCurrencyTotal=0  ");
                strBuffer.append("\t   GROUP BY FAccountID,accountNumber,FIsCurrencyTotal,FCurrencyID,FPeriod \r\n");
                strBuffer.append("  ) s where ");
                if (this.isShowFor()) {
                    strBuffer.append(" s.fDebitFor<>0 or s.fCreditFor<>0 or");
                }
                strBuffer.append("  s.FEndBalanceFor<>0 or");
                if (this.isShowLocal()) {
                    strBuffer.append(" s.fDebitLocal<>0 or s.fCreditLocal<>0 or");
                }
                strBuffer.append("  s.FEndBalanceLocal<>0 or");
                if (this.isShowRpt()) {
                    strBuffer.append(" s.fDebitRpt<>0 or s.fCreditRpt<>0 or");
                }
                strBuffer.append(" s.FEndBalanceRpt<>0 or");
                strBuffer.delete(strBuffer.length() - 2, strBuffer.length());
                strBuffer.append(" ) b where  ").append(this.getDataSourceTableName()).append(".faccountid = b.faccountid and ");
                strBuffer.append(this.getDataSourceTableName()).append(".accountnumber = b.accountnumber and \r\n");
                strBuffer.append(this.getDataSourceTableName()).append(".FPeriod = b.FPeriod and ");
                strBuffer.append(this.getDataSourceTableName()).append(".fcurrencyid = b.fcurrencyid )");
                DbUtil.execute((Context)this.getContex(), (String)strBuffer.toString());
            }
            if (this.isAllCurrency() && !this.cond.getShowTotal()) {
                strBuffer = new StringBuffer();
                strBuffer.append("\tdelete from  \r\n");
                strBuffer.append(this.getDataSourceTableName());
                tName = this.getDataSourceTableName();
                strBuffer.append("  where exists ( select 1 from ( ");
                strBuffer.append("  select * from ( ");
                strBuffer.append("  select * from ");
                strBuffer.append(this.getDataSourceTableName());
                strBuffer.append("  where exists (select 1 from ( \r\n");
                strBuffer.append("  select  \r\n");
                strBuffer.append("     fcurrencyid as fcurrencyid2 , \r\n");
                strBuffer.append("     accountnumber as accountnumber2, \r\n");
                strBuffer.append("     FPeriod as FPeriod2, FBaltype as FBaltype2, \r\n");
                if (this.isShowFor()) {
                    strBuffer.append("\tfDebitFor  fDebitFor2,");
                }
                if (this.isShowLocal()) {
                    strBuffer.append("  fDebitLocal  fDebitLocal2,");
                }
                if (this.isShowRpt()) {
                    strBuffer.append("  fDebitRpt  fDebitRpt2,");
                }
                if (this.isShowFor()) {
                    strBuffer.append(" fCreditFor  fCreditFor2,");
                }
                if (this.isShowLocal()) {
                    strBuffer.append(" fCreditLocal  fCreditLocal2,");
                }
                if (this.isShowRpt()) {
                    strBuffer.append(" fCreditRpt  fCreditRpt2,");
                }
                strBuffer.append("  FEndBalanceFor  FEndBalanceFor2,");
                strBuffer.append("  FEndBalanceLocal  FEndBalanceLocal2,");
                strBuffer.append("  FEndBalanceRpt  FEndBalanceRpt2   ");
                strBuffer.deleteCharAt(strBuffer.length() - 1);
                strBuffer.append(" from ").append(this.getDataSourceTableName());
                strBuffer.append("     ) b where accountnumber = b.accountnumber2 and \r\n");
                strBuffer.append("     FPeriod = b.FPeriod2 \r\n");
                strBuffer.append("     and FBaltype = b.FBaltype2 and (  \r\n");
                if (this.isShowFor()) {
                    strBuffer.append(" fDebitFor2<>0 or fCreditFor2<>0 or");
                }
                strBuffer.append(" FEndBalanceFor2<>0 or");
                if (this.isShowLocal()) {
                    strBuffer.append(" fDebitLocal2<>0 or fCreditLocal2<>0 or");
                }
                strBuffer.append(" FEndBalanceLocal2<>0 or");
                if (this.isShowRpt()) {
                    strBuffer.append(" fDebitRpt2<>0 or fCreditRpt2<>0 or");
                }
                strBuffer.append(" FEndBalanceRpt2<>0 or");
                strBuffer.delete(strBuffer.length() - 2, strBuffer.length());
                strBuffer.append("  or fcurrencyid2 is not null   ) \r\n");
                strBuffer.append(") ) s");
                strBuffer.append(" where s.fcurrencyid is null ) T ");
                strBuffer.append(" where ").append(tName).append(".accountnumber = T.accountnumber ");
                strBuffer.append("  and ").append(tName).append(".FPeriod = T.FPeriod ");
                strBuffer.append("  and ").append(tName).append(".FBaltype = T.FBaltype ");
                strBuffer.append("  and ").append(tName).append(".fiscurrencytotal = T.fiscurrencytotal ");
                strBuffer.append("  and (").append(tName).append(".fcurrencyid = T.fcurrencyid or ").append(tName).append(".fcurrencyid is null)) ");
                DbUtil.execute((Context)this.getContex(), (String)strBuffer.toString());
            }
            if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
                String sql = "delete from " + this.getDataSourceTableName() + " where accountnumber not in(select accountnumber from " + this.getDataSourceTableName() + " where  ((";
                if (this.isShowFor()) {
                    sql = sql + "  fDebitFor<>0 or fCreditFor<>0 or";
                }
                if (this.isShowLocal()) {
                    sql = sql + "  fDebitLocal<>0 or fCreditLocal<>0 or";
                }
                if (this.isShowRpt()) {
                    sql = sql + "  fDebitRpt<>0 or fCreditRpt<>0    ";
                }
                sql = sql.substring(0, sql.length() - 2);
                sql = sql + " ) ";
                sql = sql + "and FBalType=1)";
                if (this.cond.isOptionAmountAndBalZero()) {
                    sql = sql + " or (";
                    sql = sql + "  fEndBalanceFor<>0 or";
                    sql = sql + "  fEndBalanceLocal<>0 or";
                    sql = sql + "  fEndBalanceRpt<>0   ";
                    sql = sql.substring(0, sql.length() - 2);
                    sql = sql + ")";
                }
                sql = sql + ")";
                DbUtil.execute((Context)this.getContex(), (String)sql);
            }
        }
    }

    @Override
    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws SQLException, BOSException, EASBizException {
        BigDecimal endQty;
        BigDecimal FCreditQty;
        BigDecimal FDebitQty;
        super.toGLRptRowData(rs, rowData);
        boolean isParmBalanceDirSamAsAccount = this.cond.getRptParams().isBalanceDirSamAsAccount();
        boolean showQty = this.cond.isShowQty();
        int iPeriod = rs.getInt("FPeriod");
        String strPeriodNumber = String.valueOf(iPeriod % 100);
        String strPeriodYear = String.valueOf(iPeriod / 100);
        if (this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd()) {
            rowData.updateString("FPeriod", strPeriodNumber.trim());
        } else {
            rowData.updateString("FPeriod", strPeriodYear.trim() + "." + strPeriodNumber.trim());
        }
        int fbaltype = rs.getInt("FBalType");
        if (fbaltype == 0) {
            if (strPeriodNumber != null && strPeriodNumber.trim().equals("1")) {
                rowData.updateString("FDescription", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)this.TITLE_YEAR_START, (Locale)this.getContex().getLocale()));
            } else {
                rowData.updateString("FDescription", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)this.TITLE_PERIOD_START, (Locale)this.getContex().getLocale()));
            }
        }
        if (fbaltype == 1) {
            rowData.updateString("FDescription", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)this.TITLE_PERIOD_SUM, (Locale)this.getContex().getLocale()));
        }
        if (fbaltype == 2) {
            rowData.updateString("FDescription", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)this.TITLE_YEAR_SUM, (Locale)this.getContex().getLocale()));
        }
        String strAccountNumber = rs.getString("accountNumber");
        String strAccountName = rs.getString("accountName");
        String strAccountID = rs.getString("FAccountID");
        if (!this.getOrgIsBizUnit() && 0 == fbaltype || this.getOrgIsBizUnit() && 0 == fbaltype) {
            rowData.updateString("accountNumber", strAccountNumber);
            rowData.updateString("accountName", strAccountName);
        } else {
            rowData.updateString("accountNumber", "");
            rowData.updateString("accountName", "");
        }
        int accountDC = rs.getInt("accountDC");
        BigDecimal balanceFor = null;
        balanceFor = rs.getBigDecimal("FEndBalanceFor");
        BigDecimal balanceLocal = null;
        balanceLocal = rs.getBigDecimal("FEndBalanceLocal");
        BigDecimal balanceRpt = rs.getBigDecimal("FEndBalanceRpt");
        if (fbaltype == 0) {
            BigDecimal debit;
            if (this.cond.isShowFor() && (debit = rs.getBigDecimal("FDebitFor")) != null && debit.compareTo(BigDecimal.ZERO) < 0) {
                rowData.updateBigDecimal("FCreDitFor", debit.abs());
                rowData.updateBigDecimal("FDebitFor", BigDecimal.ZERO);
            }
            if (this.cond.isShowLocal() && (debit = rs.getBigDecimal("FDebitLocal")) != null && debit.compareTo(BigDecimal.ZERO) < 0) {
                rowData.updateBigDecimal("FCreDitLocal", debit.abs());
                rowData.updateBigDecimal("FDebitLocal", BigDecimal.ZERO);
            }
            if (this.cond.isShowRpt() && (debit = rs.getBigDecimal("FDebitRpt")) != null && debit.compareTo(BigDecimal.ZERO) < 0) {
                rowData.updateBigDecimal("FCreDitRpt", debit.abs());
                rowData.updateBigDecimal("FDebitRpt", BigDecimal.ZERO);
            }
        }
        String strDC = "";
        strDC = (balanceFor == null || balanceFor.longValue() == 0L) && balanceLocal != null && balanceLocal.longValue() == 0L && balanceRpt != null && balanceRpt.longValue() != 0L ? this.getBalanceDC(balanceRpt, isParmBalanceDirSamAsAccount, accountDC) : (!(balanceFor != null && balanceFor.longValue() != 0L || balanceRpt != null && balanceRpt.longValue() != 0L || balanceLocal == null || balanceLocal.longValue() == 0L) ? this.getBalanceDC(balanceLocal, isParmBalanceDirSamAsAccount, accountDC) : this.getBalanceDC(balanceFor == null || balanceFor.longValue() == 0L ? balanceLocal : balanceFor, isParmBalanceDirSamAsAccount, accountDC));
        rowData.updateString("accountDC", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)strDC, (Locale)this.getContex().getLocale()));
        BigDecimal balanceFor2 = balanceFor;
        balanceFor = this.getBalanceForDC(balanceFor, isParmBalanceDirSamAsAccount, accountDC);
        BigDecimal balanceLocal2 = balanceLocal;
        balanceLocal = this.getBalanceForDC(balanceLocal, isParmBalanceDirSamAsAccount, accountDC);
        BigDecimal balanceRpt2 = balanceRpt;
        balanceRpt = this.getBalanceForDC(balanceRpt, isParmBalanceDirSamAsAccount, accountDC);
        if (this.isShowFor()) {
            rowData.updateBigDecimal("FEndBalanceFor", balanceFor);
        }
        if (this.isShowLocal()) {
            rowData.updateBigDecimal("FEndBalanceLocal", balanceLocal);
        }
        if (this.isShowRpt()) {
            rowData.updateBigDecimal("FEndBalanceRpt", balanceRpt);
        }
        BigDecimal coefficient = GlUtils.one;
        coefficient = this.getAccountQtyCoefficient(rowData.getString(GLRptField.accountID.getName()));
        if (showQty && (FDebitQty = rs.getBigDecimal("FDebitQty")) != null) {
            FDebitQty = FDebitQty.divide(coefficient, this.cond.getRptParams().getQtyScale(), 4);
            rowData.updateBigDecimal("FDebitQty", FDebitQty);
        }
        if (showQty && (FCreditQty = rs.getBigDecimal("FCreditQty")) != null) {
            FCreditQty = FCreditQty.divide(coefficient, this.cond.getRptParams().getQtyScale(), 4);
            rowData.updateBigDecimal("FCreditQty", FCreditQty);
        }
        if (showQty && (endQty = rs.getBigDecimal("FEndQty")) != null) {
            endQty = endQty.divide(coefficient, this.cond.getRptParams().getQtyScale(), 4);
            if ((balanceFor2 != null && !balanceFor2.equals(balanceFor) || balanceLocal2 != null && !balanceLocal2.equals(balanceLocal) || balanceRpt2 != null && !balanceRpt2.equals(balanceRpt)) && endQty != null) {
                endQty = endQty.negate();
            }
            rowData.updateBigDecimal("FEndQty", endQty);
            boolean isShowLocalCurrency = !this.cond.getRptParams().isForeignCurrencySu() && "11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID());
            boolean isShowReportCurrency = !this.cond.getRptParams().isForeignCurrencySu() && this.cond.getRptParams().isUseReportCurrency() && "22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID());
            BigDecimal balance = balanceFor;
            if (isShowLocalCurrency) {
                balance = balanceLocal;
            }
            if (isShowReportCurrency && !isShowLocalCurrency) {
                balance = balanceRpt;
            }
            if (endQty != null && balance != null && endQty.compareTo(new BigDecimal("0.0")) != 0) {
                BigDecimal price = balance.divide(endQty, this.cond.getRptParams().getPriceScale(), 4);
                rowData.updateBigDecimal("FEndPrice", price);
            }
        }
    }

    protected String getBalanceDC(BigDecimal curBalance, boolean bEndBalDCFormat, int iDC) throws BOSException {
        if (curBalance == null) {
            return this.TITLE_BALANCE;
        }
        String strDc = null;
        boolean autoBalance = !bEndBalDCFormat;
        if (curBalance == null) {
            curBalance = GlUtils.zero;
        }
        if (autoBalance) {
            if (curBalance.compareTo(GlUtils.zero) > 0) {
                strDc = this.TITLE_DEBIT;
            }
            if (curBalance.compareTo(GlUtils.zero) < 0) {
                strDc = this.TITLE_CREDIT;
            }
            if (curBalance.compareTo(GlUtils.zero) == 0) {
                strDc = this.TITLE_BALANCE;
            }
        } else if (curBalance.compareTo(GlUtils.zero) == 0) {
            strDc = this.TITLE_BALANCE;
        } else {
            if (iDC == 1) {
                strDc = this.TITLE_DEBIT;
            }
            if (iDC == -1) {
                strDc = this.TITLE_CREDIT;
            }
        }
        return strDc;
    }

    public BigDecimal getBalanceForDC(BigDecimal balance, boolean isParmBalanceDirSamAsAccount, int accountDC) throws BOSException, EASBizException {
        if (balance == null) {
            return balance;
        }
        int dc = balance.compareTo(ZERO);
        if (dc == 0) {
            return balance;
        }
        if (isParmBalanceDirSamAsAccount) {
            return accountDC == 1 ? balance : balance.negate();
        }
        return balance.abs();
    }

    protected void setChildrenNode(GLRptRowSet rowSet) throws BOSException {
        GLRptTreeNode node;
        if (!this.getOrgIsBizUnit() && (node = (GLRptTreeNode)rowSet.getObject(this.getOrgUnitNameField().getName())).getParentNode() != null) {
            if (this.isAllCurrency()) {
                rowSet.updateObject(GLRptField.currencyName.getName(), null);
            }
            rowSet.updateObject(GLRptField.accountName.getName(), null);
            rowSet.updateObject(GLRptField.accountNumber.getName(), null);
        }
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        super.doGLRptRowData(rowSet);
        GLRptTreeNode node = null;
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() && (node = (GLRptTreeNode)rowSet.getObject(this.getOrgUnitNameField().getName())).getParentNode() != null) {
            rowSet.updateObject(GLRptField.currencyName.getName(), null);
            rowSet.updateObject(GLRptField.accountName.getName(), null);
            rowSet.updateObject(GLRptField.accountNumber.getName(), null);
        }
        this.setChildrenNode(rowSet);
    }

    protected BigDecimal getAccountQtyCoefficient(String accountId) throws BOSException, EASBizException {
        if (accountId != null) {
            MeasureUnitInfo measureUnitID;
            BigDecimal accountQtyCoefficient = GlUtils.one;
            AccountViewInfo accountViewInfo = null;
            if (this.loadedAccountIDToQtyCoefficient.containsKey(accountId)) {
                accountQtyCoefficient = this.loadedAccountIDToQtyCoefficient.get(accountId);
            } else {
                accountViewInfo = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            }
            if (accountViewInfo != null && (measureUnitID = accountViewInfo.getMeasureUnitID()) != null) {
                accountQtyCoefficient = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureUnitID.getId().toString())).getCoefficient();
            }
            this.loadedAccountIDToQtyCoefficient.put(accountId, accountQtyCoefficient);
            return accountQtyCoefficient;
        }
        return GlUtils.one;
    }

    @Override
    protected void updateField(IRowSet rs, GLRptRowSet rowData, String colName, Object value) throws BOSException, EASBizException, SQLException {
        super.updateField(rs, rowData, colName, value);
        if (value != null && GLRptField.period.getName().equalsIgnoreCase(colName)) {
            int period = Integer.parseInt(value.toString());
            rowData.updateObject(colName, period / 100 + "." + period % 100);
        } else if (GLRptField.accountDC.getName().equalsIgnoreCase(colName) && this.cond.getRptParams().isBalanceDirSamAsAccount() && value != null) {
            int dc = Integer.parseInt(value.toString());
            rowData.updateObject(colName, BalanceDirectionEnum.getEnum((int)dc));
        }
    }

    protected GLRptSelector getYearBeginBalQuerySelector(int type) throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        selector.add(GLRptField.period);
        selector.add(GLRptField.periodBeginDate);
        if (this.isAllCurrency()) {
            selector.add(GLRptField.currencyID);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.beginQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.beginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.beginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.beginBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearDebitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearCreditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearCreditRpt);
        }
        selector.add(GLRptVoucherField.beginBalType);
        return selector;
    }

    @Override
    protected void setRow1Title(List colTitles, GLRptField field) {
        if (field == GLRptField.accountDC) {
            colTitles.add("balance");
        } else if (field == GLRptVoucherField.endPrice) {
            colTitles.add("balance");
        } else if (field.getName().equals(GLRptField.endBalanceFor.getName()) || field.getName().equals(GLRptField.endBalanceLocal.getName()) || field.getName().equals(GLRptField.endBalanceRpt.getName())) {
            colTitles.add("balance");
        } else if (field == GLRptField.endQty) {
            colTitles.add("balance");
        } else {
            super.setRow1Title(colTitles, field);
        }
    }

    @Override
    protected String[] getTitleRow2() throws EASBizException, BOSException {
        return super.getTitleRow2();
    }

    @Override
    protected void setRow2Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (!this.isShowQty() && this.isSingleAmountFiled() && (field.getName().equals("FDebitFor") || field.getName().equals("FCreditFor") || field.getName().equals("FDebitLocal") || field.getName().equals("FCreditLocal") || field.getName().equals("FDebitRpt") || field.getName().equals("FCreditRpt"))) {
            colTitles.add(field.getTitle());
        } else if (this.isShowQty() && field.getName().equals("FEndPrice")) {
            colTitles.add("price");
        } else if (this.isShowQty() && this.isSingleAmountFiled() && (field.getName().endsWith("For") || field.getName().endsWith("Local") || field.getName().endsWith("Rpt"))) {
            if (field.getName().endsWith("For")) {
                colTitles.add("currency_for");
            } else if (field.getName().endsWith("Local")) {
                colTitles.add("currency_local");
            } else {
                colTitles.add("currency_rpt");
            }
        } else {
            super.setRow2Title(colTitles, field);
        }
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        if (this.isCreateDataTempTable()) {
            selector.add(GLRptField.accountNumberMerger);
        } else {
            selector.add(GLRptField.accountNumber);
        }
        selector.add(this.cond.getRptParams().isAccountShowLongName() ? GLRptField.accountDisplayName : GLRptField.accountName);
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            this.setOrgUnitSelector(selector);
        }
        if (this.isAllCurrency()) {
            selector.add(GLRptField.currencyID);
            selector.add(GLRptField.currencyNumber);
            selector.add(GLRptField.currencyName);
            selector.add(GLRptField.currencyPre);
            selector.add(new GLRptField("FIsCurrencyTotal", "b.FIsCurrencyTotal", "FIsCurrencyTotal", "INT"));
        }
        selector.add(GLRptField.period);
        selector.add(new GLRptField("FBalType", "0", "FBalType", "INT"));
        selector.add(new GLRptField("FDescription", "", "NVARCHAR(500)", "abstract_description", 100, false));
        if (this.isShowQty()) {
            selector.add(GLRptField.debitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.debitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.debitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.debitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.creditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.creditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.creditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.creditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.endQty);
            selector.add(GLRptVoucherField.endPrice);
        }
        selector.add(GLRptField.accountDC);
        if (this.isShowFor()) {
            selector.add(GLRptField.endBalanceFor);
        } else {
            selector.add(new GLRptField("FEndBalanceFor", "b.FEndBalanceFor", "endBalanceFor", "NUMERIC(29,10)"));
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.endBalanceLocal);
        } else {
            selector.add(new GLRptField("FEndBalanceLocal", "b.FEndBalanceLocal", "endBalanceLocal", "NUMERIC(29,10)"));
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.endBalanceRpt);
        } else {
            selector.add(new GLRptField("FEndBalanceRpt", "b.FEndBalanceRpt", "endBalanceRpt", "NUMERIC(29,10)"));
        }
        return selector;
    }

    @Override
    public GLRptTableHeadInfo initTableHeadInfo() throws BOSException, EASBizException {
        return super.initTableHeadInfo();
    }

    @Override
    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = null;
        titles = new String[][]{this.getTitleRow1(), this.getTitleRow2()};
        return titles;
    }

    @Override
    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        super.addTableHeadColumn(headInfo, field);
    }

    @Override
    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected GLRptSumItems getTempTableSumItem() throws BOSException, EASBizException {
        return null;
    }

    protected String getSelectSql() throws EASBizException, BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("  (FAccountID ,accountNumber ,");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append(this.getTempDataOrgSelectSql().split(" ")[1]);
        }
        if (this.isAllCurrency()) {
            strBuffer.append("  FCurrencyID ,currencyNumber ,");
            strBuffer.append("  currencyPre,");
            strBuffer.append("  FIsCurrencyTotal,");
        }
        strBuffer.append("  FPeriod , FBalType ,  \r\n");
        if (this.isShowQty()) {
            strBuffer.append("  FDebitQty ,");
        }
        if (this.isShowFor()) {
            strBuffer.append("  FDebitFor ,");
        }
        if (this.isShowLocal()) {
            strBuffer.append("  FDebitLocal ,");
        }
        if (this.isShowRpt()) {
            strBuffer.append("  FDebitRpt ,");
        }
        if (this.isShowQty()) {
            strBuffer.append("  FCreditQty ,");
        }
        if (this.isShowFor()) {
            strBuffer.append("  FCreditFor ,");
        }
        if (this.isShowLocal()) {
            strBuffer.append("  FCreditLocal ,");
        }
        if (this.isShowRpt()) {
            strBuffer.append("  FCreditRpt ,");
        }
        if (this.isShowQty()) {
            strBuffer.append("  FEndQty ,");
        }
        strBuffer.append("  FEndBalanceFor ,");
        strBuffer.append("  FEndBalanceLocal ,");
        strBuffer.append("  FEndBalanceRpt");
        String sql = strBuffer.toString();
        if (sql.endsWith(",")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    protected String getSumSelectSql() throws EASBizException, BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("   SELECT TB.FID FAccountID,tb.FNumber accountNumber,");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append("  T1.").append(this.getTempDataOrgSelectSql());
        }
        if (this.isAllCurrency()) {
            strBuffer.append("  T1.FCurrencyID ,T1.currencyNumber ,");
            strBuffer.append("  T1.currencyPre,");
            strBuffer.append("  T1.FIsCurrencyTotal,");
        }
        strBuffer.append(" T1.FPeriod,T1.FBalType,\r\n");
        if (this.isShowQty()) {
            strBuffer.append(" SUM(T1.FDebitQty)  FDebitQty, \r\n");
        }
        if (this.isShowFor()) {
            strBuffer.append(" SUM(T1.FDebitFor)  FDebitFor, \r\n");
        }
        if (this.isShowLocal()) {
            strBuffer.append(" SUM(T1.FDebitLocal)  FDebitLocal, \r\n");
        }
        if (this.isShowRpt()) {
            strBuffer.append(" SUM(T1.FDebitRpt)  FDebitRpt, \r\n");
        }
        if (this.isShowQty()) {
            strBuffer.append(" SUM(T1.FCreditQty)  FCreditQty ,\r\n");
        }
        if (this.isShowFor()) {
            strBuffer.append(" SUM(T1.FCreditFor)  FCreditFor ,\r\n");
        }
        if (this.isShowLocal()) {
            strBuffer.append(" SUM(T1.FCreditLocal)  FCreditLocal,\r\n");
        }
        if (this.isShowRpt()) {
            strBuffer.append(" SUM(T1.FCreditRpt)  FCreditRpt ,\r\n");
        }
        if (this.isShowQty()) {
            strBuffer.append(" SUM(T1.FEndQty)  FEndQty,");
        }
        strBuffer.append(" SUM(T1.FEndBalanceFor)  FEndBalanceFor ,");
        strBuffer.append("  SUM(T1.FEndBalanceLocal)  FEndBalanceLocal,");
        strBuffer.append(" SUM(T1.FEndBalanceRpt)  FEndBalanceRpt");
        String sql = strBuffer.toString();
        if (sql.endsWith(",")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    protected String getTempDataSelectSql(int type) throws EASBizException, BOSException {
        String sql;
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT  TA.FID FAccountID,TA.FNumber  accountNumber,\r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append("    M.").append(this.getTempDataOrgSelectSql());
        }
        if (this.isAllCurrency()) {
            strBuffer.append("    M.FCurrencyID FCurrencyID,  ");
            strBuffer.append("    0 FIsCurrencyTotal,");
        }
        strBuffer.append("    M.FPeriod, ");
        strBuffer.append(type).append(" FBalType, \r\n");
        if (type == 0) {
            if (this.isShowQty()) {
                strBuffer.append("    0.0 FDebitQty ,\r\n");
            }
            if (this.isShowFor()) {
                strBuffer.append("    0.0 FDebitFor,");
            }
            if (this.isShowLocal()) {
                strBuffer.append("    0.0 FDebitLocal,");
            }
            if (this.isShowRpt()) {
                strBuffer.append("    0.0 FDebitRpt,");
            }
            if (this.isShowQty()) {
                strBuffer.append("    0.0 FCreditQty,");
            }
            if (this.isShowFor()) {
                strBuffer.append("    0.0 FCreditFor, ");
            }
            if (this.isShowLocal()) {
                strBuffer.append("    0.0 FCreditLocal, ");
            }
            if (this.isShowRpt()) {
                strBuffer.append("    0.0 FCreditRpt, \r\n");
            }
            if (this.isShowQty()) {
                strBuffer.append("    M.FBeginQty FEndQty,");
            }
            if (this.isShowFor()) {
                strBuffer.append("    M.FBeginBalanceFor FEndBalanceFor,");
            } else if (this.isShowLocal()) {
                strBuffer.append("    M.FBeginBalanceLocal FEndBalanceFor,");
            } else if (this.isShowRpt()) {
                strBuffer.append("    M.FBeginBalanceRpt FEndBalanceFor,");
            } else {
                strBuffer.append("    0.0 FEndBalanceFor,");
            }
            if (this.isShowLocal()) {
                strBuffer.append("    M.FBeginBalanceLocal FEndBalanceLocal,");
            } else if (this.isShowFor()) {
                strBuffer.append("    M.FBeginBalanceFor FEndBalanceLocal,");
            } else {
                strBuffer.append("   0.0 FEndBalanceLocal,");
            }
            if (this.isShowRpt()) {
                strBuffer.append("    M.FBeginBalanceRpt FEndBalanceRpt");
            } else if (this.isShowFor()) {
                strBuffer.append("    M.FBeginBalanceFor FEndBalanceRpt");
            } else {
                strBuffer.append("    0.0 FEndBalanceRpt");
            }
        }
        if (type == 1) {
            if (this.isShowQty()) {
                strBuffer.append("    M.FDebitQty FDebitQty ,");
            }
            if (this.isShowFor()) {
                strBuffer.append("    M.FDebitFor FDebitFor,");
            }
            if (this.isShowLocal()) {
                strBuffer.append("    M.FDebitLocal FDebitLocal,");
            }
            if (this.isShowRpt()) {
                strBuffer.append("    M.FDebitRpt FDebitRpt,");
            }
            if (this.isShowQty()) {
                strBuffer.append("    M.FCreditQty FCreditQty,");
            }
            if (this.isShowFor()) {
                strBuffer.append("    M.FCreditFor FCreditFor,");
            }
            if (this.isShowLocal()) {
                strBuffer.append("    M.FCreditLocal FCreditLocal,");
            }
            if (this.isShowRpt()) {
                strBuffer.append("    M.FCreditRpt FCreditRpt,");
            }
            if (this.isShowQty()) {
                strBuffer.append("    M.FEndQty FEndQty,");
            }
            strBuffer.append("    M.FEndBalanceFor FEndBalanceFor,");
            strBuffer.append("    M.FEndBalanceLocal FEndBalanceLocal,");
            strBuffer.append("    M.FEndBalanceRpt FEndBalanceRpt");
        }
        if (type == 2) {
            if (this.isShowQty()) {
                strBuffer.append("    M.FYearDebitQty  FDebitQty,");
            }
            if (this.isShowFor()) {
                strBuffer.append("    M.FYearDebitFor FDebitFor,");
            }
            if (this.isShowLocal()) {
                strBuffer.append("    M.FYearDebitLocal FDebitLocal,");
            }
            if (this.isShowRpt()) {
                strBuffer.append("   M.FYearDebitRpt FDebitRpt,");
            }
            if (this.isShowQty()) {
                strBuffer.append("    M.FYearCreditQty FCreditQty,");
            }
            if (this.isShowFor()) {
                strBuffer.append("    M.FYearCreditFor FCreditFor,");
            }
            if (this.isShowLocal()) {
                strBuffer.append("    M.FYearCreditLocal FCreditLocal,");
            }
            if (this.isShowRpt()) {
                strBuffer.append("    M.FYearCreditRpt FCreditRpt,");
            }
            if (this.isShowQty()) {
                strBuffer.append("    M.FEndQty FEndQty,");
            }
            strBuffer.append("    M.FEndBalanceFor FEndBalanceFor,");
            strBuffer.append("    M.FEndBalanceLocal FEndBalanceLocal,");
            strBuffer.append("    M.FEndBalanceRpt FEndBalanceRpt");
        }
        if ((sql = strBuffer.toString()).endsWith(",")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    protected String getTempDataSumSelectSql(int type) {
        StringBuffer strBuffer = new StringBuffer();
        String tableField = "";
        if (type == 0) {
            tableField = "T1.";
        }
        strBuffer.append("   (SELECT ").append(tableField).append("FAccountID ,").append(tableField).append("FCurrencyID ,  ");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            strBuffer.append(tableField).append(this.getTempDataOrgSelectSql());
        }
        strBuffer.append(tableField).append("FPeriod,\r\n");
        if (this.isShowFor()) {
            strBuffer.append("   SUM(").append(tableField).append("FBeginBalanceFor) FBeginBalanceFor ,\r\n");
            strBuffer.append("   SUM(").append(tableField).append("FDebitFor) FDebitFor, \r\n");
            strBuffer.append("   SUM(").append(tableField).append("FCreditFor) FCreditFor ,\r\n");
            strBuffer.append("   SUM(").append(tableField).append("FYearDebitFor) FYearDebitFor ,\r\n");
            strBuffer.append("   SUM(").append(tableField).append("FYearCreditFor) FYearCreditFor ,\r\n");
        }
        try {
            if (this.cond.isShowLocal()) {
                strBuffer.append("   SUM(").append(tableField).append("FBeginBalanceLocal) FBeginBalanceLocal ,\r\n");
                strBuffer.append("   SUM(").append(tableField).append("FDebitLocal) FDebitLocal, \r\n");
                strBuffer.append("   SUM(").append(tableField).append("FCreditLocal) FCreditLocal,\r\n");
                strBuffer.append("   SUM(").append(tableField).append("FYearDebitLocal) FYearDebitLocal ,\r\n");
                strBuffer.append("   SUM(").append(tableField).append("FYearCreditLocal) FYearCreditLocal,\r\n");
            }
            if (this.cond.isShowRpt()) {
                strBuffer.append("   SUM(").append(tableField).append("FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
                strBuffer.append("   SUM(").append(tableField).append("FDebitRpt) FDebitRpt, \r\n");
                strBuffer.append("   SUM(").append(tableField).append("FCreditRpt) FCreditRpt ,\r\n");
                strBuffer.append("   SUM(").append(tableField).append("FYearDebitRpt) FYearDebitRpt , \r\n");
                strBuffer.append("   SUM(").append(tableField).append("FYearCreditRpt) FYearCreditRpt ,\r\n");
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        strBuffer.append("   SUM(").append(tableField).append("FEndBalanceFor) FEndBalanceFor , \r\n");
        strBuffer.append("   SUM(").append(tableField).append("FEndBalanceLocal) FEndBalanceLocal,\r\n");
        strBuffer.append("   SUM(").append(tableField).append("FEndBalanceRpt) FEndBalanceRpt \r\n");
        if (this.cond.isShowQty()) {
            strBuffer.append("   ,SUM(").append(tableField).append("FBeginQty) FBeginQty, \r\n");
            strBuffer.append("   SUM(").append(tableField).append("FDebitQty) FDebitQty, \r\n");
            strBuffer.append("   SUM(").append(tableField).append("FCreditQty) FCreditQty ,\r\n");
            strBuffer.append("   SUM(").append(tableField).append("FYearDebitQty) FYearDebitQty , \r\n");
            strBuffer.append("   SUM(").append(tableField).append("FYearCreditQty) FYearCreditQty,\r\n");
            strBuffer.append("   SUM(").append(tableField).append("FEndQty) FEndQty\r\n");
        }
        return strBuffer.toString();
    }

    @Override
    protected String getTempTableDefineFunction() {
        return "GLRptGeneralLedgerDao";
    }
}

