/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptGeneralLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import java.util.HashMap;

public class GLRptGeneralLedgerPageQuery
extends GLRptPageQuery {
    private boolean isCreateDataTempTable = false;

    public GLRptGeneralLedgerPageQuery(Context ctx, GLRptGeneralLedgerCondition cond, boolean isCreateDataTempTable) {
        super(ctx, cond);
        this.isCreateDataTempTable = isCreateDataTempTable;
    }

    @Override
    protected String getSelectSQL() throws BOSException, EASBizException {
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append(" t.accountNumber  accountNumber,\r\n");
        sqlSelect.append(this.getAccountName()).append(this.getCtx().getLocale().toString());
        sqlSelect.append(" accountName, \r\n");
        sqlSelect.append(" av.fdc accountDC, \r\n");
        if (CompanyDisplayModeEnum.level == this.getCond().getCompanyDisplayMode()) {
            sqlSelect.append(this.getSelectedOrgSql());
        }
        if (this.getCond().isAllCurrency()) {
            sqlSelect.append(" cy.fnumber currencyNumber,");
            sqlSelect.append(" cy.fname_").append(this.getCtx().getLocale().toString()).append(" currencyName,");
            sqlSelect.append(" cy.fprecision currencyPre,");
            sqlSelect.append(" t.FIsCurrencyTotal,");
        }
        sqlSelect.append(" t.FPeriod FPeriod, \r\n");
        sqlSelect.append(" t.FBalType FBalType, \r\n");
        sqlSelect.append(this.getMainTable().getAlias()).append(".* ");
        return sqlSelect.toString();
    }

    protected String getSelectedOrgSql() {
        return " t.FOrgUnitID FOrgUnitID, \r\n";
    }

    protected String getAccountName() throws BOSException, EASBizException {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)this.getCtx());
        boolean isAccountShowLongName = false;
        paramKeyMap.put("GL_012", this.getCond().getCompany().getId().toString());
        String strAccountShowLongName = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        return isAccountShowLongName ? "    av.FLongName_" : "    av.FName_";
    }

    protected String getOrgJoinSQL() throws BOSException, EASBizException {
        if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
            return " left outer join t_org_company company on company.fid = t.forgunitid ";
        }
        return "";
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(super.getJoinSQL());
        sql.append(" left outer join t_bd_accountview av on av.fid = t.faccountid ");
        if (this.getCond().isAllCurrency()) {
            sql.append(" left outer join t_bd_currency cy on cy.fid = t.fcurrencyid ");
        }
        sql.append(this.getOrgJoinSQL());
        if (this.getCond().isShowQty()) {
            sql.append(" left outer join t_bd_measureunit endMU on endMU.fid = av.FMeasureUnitID");
        }
        return sql.toString();
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        GLRptSQLOrder order = new GLRptSQLOrder();
        order.add("t.accountNumber");
        order.add("t.FPeriod");
        if (this.getCond().isAllCurrency()) {
            order.add("t.FIsCurrencyTotal");
            order.add(GLRptField.currencyNumber.getSelect());
        }
        order.add("t.FBalType");
        if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
            order.add("company.flongnumber");
        }
        return order;
    }
}

