/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.CommonSchema;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptMulColAbsDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactMultiColumnDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptMulColAccoutDao
extends AbstractGLRptMulColAbsDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.dao.GLRptMulColAccoutDao");
    protected HashMap accountMap;

    public GLRptMulColAccoutDao(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactMultiColumnDao dao, GLRptBaseCondition condition, CommonSchema cs) throws BOSException, EASBizException {
        super(ctx, company, dao, condition, cs);
    }

    protected String getVoucherTableName() {
        return "t_gl_voucher";
    }

    protected String getVoucherEntryTableName() {
        return "t_gl_voucherentry";
    }

    protected String getVoucherAssRedTableName() {
        return "T_GL_VoucherAssistRecord";
    }

    protected String getAsstBalanceTableName() {
        return GLBalanceUtils.getAssistBalanceTable(this.balType);
    }

    protected String getAcctBalanceTableName() {
        return GLBalanceUtils.getAccountBalanceTable(this.balType);
    }

    @Override
    protected void init() throws BOSException, EASBizException {
        boolean isQueryUpAccount;
        super.init();
        this.initAccountMap();
        int maxAccountLevel = -1;
        int minAccountLevel = -1;
        this.uperAccountLevel = -1;
        boolean bl = isQueryUpAccount = this.accountMap == null ? false : (Boolean)this.accountMap.get("isAccountUpLevel");
        if (this.accountMap != null && isQueryUpAccount) {
            minAccountLevel = (Integer)this.accountMap.get("minAccountLevel");
            maxAccountLevel = (Integer)this.accountMap.get("maxAccountLevel");
            this.uperAccountLevel = maxAccountLevel - minAccountLevel;
        }
        this.debitColumn = this.initAndSortColData(this.debitList, isQueryUpAccount, maxAccountLevel);
        this.creditColumn = this.initAndSortColData(this.creditList, isQueryUpAccount, maxAccountLevel);
        List list = this.getTableData();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            if (!at.isSelected() || at.getFrom() == null && at.getTo() == null && at.getDist() == null) continue;
            this.needFilteHg = true;
            break;
        }
        this.allAccountSameUnit = true;
    }

    protected void initAccountMap() throws BOSException {
        int fromAccountLevel = 1;
        this.accountMap = this.sortAccountMd(this.ctx, fromAccountLevel);
        this.accountMap.put("isAccountUpLevel", new Boolean(this.isAccountUpLevel));
    }

    @Override
    protected void createEntryTmpTable() throws BOSException {
        try {
            StringBuffer createTabSql = new StringBuffer("create table GLRptAsstactMultiColumnDao_Entry ");
            createTabSql.append("(voucherId VARCHAR(44), entryid VARCHAR(44), FSourcetype int, \r\n");
            createTabSql.append("ActDC int, FPeriodID VARCHAR(44), FPeriodYear INT, FPeriodNumber INT, \r\n");
            createTabSql.append("bizDate datetime, voucherTypeName VARCHAR(300), description VARCHAR(900), \r\n");
            createTabSql.append("flongnumber VARCHAR(400), FCurrencyID VARCHAR(44), \r\n");
            if (!this.displayOneLineBiz) {
                createTabSql.append("FEntryID VARCHAR(44),\r\n");
            }
            createTabSql.append("fseq INT, \r\n");
            createTabSql.append("FOriginalAmount NUMERIC(19,4) DEFAULT 0, \r\n");
            createTabSql.append("FLocalAmount NUMERIC(19,4) DEFAULT 0, \r\n");
            createTabSql.append("fquantity NUMERIC(19,4) DEFAULT 0, \r\n");
            createTabSql.append("FStandardQuantity NUMERIC(19,4) DEFAULT 0, \r\n");
            createTabSql.append("fprice NUMERIC(19,4) DEFAULT 0, \r\n");
            if (this.displayAmount) {
                createTabSql.append("FCoefficient NUMERIC(19,4) DEFAULT 0, \r\n");
            }
            createTabSql.append(" muname VARCHAR(400) ");
            createTabSql.append(") \r\n");
            this.entryTempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTabSql.toString());
            this.insertEntryTmpVchData();
            TempTablePool.getInstance((Context)this.ctx).createIndex(this.entryTempTable, "voucherId, entryid", false, false);
            TempTablePool.getInstance((Context)this.ctx).createIndex(this.entryTempTable, "flongnumber, FCurrencyID", false, false);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }

    protected void insertEntryTmpVchData() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        int index = 1;
        IRowSet iRowSet = (IRowSet)this.accountMap.get("iRowSet");
        sql.append("insert ").append(this.entryTempTable);
        sql.append(" SELECT A.FID voucherId, B.fid entryid, A.FSourcetype, B.FEntryDC ActDC, \r\n");
        sql.append("F.FID FPeriodID, F.FPeriodYear,F.FPeriodNumber ,A.FBookedDate bizDate, \r\n");
        sql.append("C.FName_").append(this.loc).append("||'-'||IsNull(A.FNumber,'') voucherTypeName, \r\n");
        sql.append(" ISNULL(B.FDescription,' ') description, av.flongnumber, b.FCurrencyID, \r\n");
        if (!this.displayOneLineBiz) {
            sql.append("B.fid FEntryID,\r\n");
        }
        if (this.needFilteHg && !this.displayOneLineBiz) {
            sql.append("B.fseq + VA.fseq fseq ,");
        } else {
            sql.append("B.fseq fseq ,");
        }
        if (this.needFilteHg) {
            sql.append("va.FOriginalAmount, va.FLocalAmount, \n");
        } else {
            sql.append("B.FOriginalAmount, B.FLocalAmount, \n");
        }
        if (this.displayAmount) {
            if (this.needFilteHg) {
                sql.append("VA.fquantity, VA.FStandardQuantity, VA.fprice, mu.FCoefficient, \n");
                sql.append("mu.fname_").append(this.loc).append(" muname ");
            } else {
                sql.append("B.fquantity, B.FStandardQuantity, B.fprice, mu.FCoefficient, \n");
                sql.append("mu.fname_").append(this.loc).append(" muname ");
            }
        } else {
            sql.append("0, 0, 0, '' ");
        }
        sql.append(" from ").append(this.getVoucherTableName()).append(" A  \r\n");
        sql.append(" inner join ").append(this.getVoucherEntryTableName()).append(" B on A.fid = B.fbillid \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = b.faccountid and A.FCompanyId = AV.FCompanyId \r\n");
        if (this.needFilteHg) {
            sql.append("\n INNER JOIN ").append(this.getVoucherAssRedTableName()).append(" VA ON A.FID = VA.FBillID and B.FID = VA.FEntryID ").append("\n INNER JOIN  T_BD_AssistantHg HG ON VA.FAssGrpID = HG.FID ");
            if (this.displayAmount) {
                sql.append("\n left join t_bd_measureunit mu on va.FMeasureUnitID = mu.fid ");
            }
        } else if (this.displayAmount) {
            sql.append("\n left join t_bd_measureunit mu on B.FMeasureUnitID = mu.fid ");
        }
        sql.append(" inner join t_bd_vouchertypes C on A.fvouchertypeid = C.fid \r\n");
        sql.append(" inner join t_bd_period F  on A.fperiodid = F.fid \r\n");
        sql.append(null == this.getGovAccountDetailJoinTable(this.ctx, this.condition) ? "" : this.getGovAccountDetailJoinTable(this.ctx, this.condition));
        sql.append(" where ").append(this.getVoucherOrgIdFilter2()).append(" and AV.FCompanyId = ? and  A.FBizStatus in ").append(this.balTypes);
        sql.append(" and av.fisleaf = 1 and AV.faccounttableid = ? \r\n");
        if (this.includeNoTransPLVoucher) {
            sql.append(" and A.FSourcetype <> 1 ");
        }
        sql.append(" and F.FTypeID = ? and F.fNumber >= ? and F.fNumber <= ? \r\n");
        index = this.getVoucherOrgIdFilterValue(sp, index);
        sp.setString(index++, this.companyid);
        sp.setString(index++, this.accountTableID);
        sp.setString(index++, this.periodType);
        sp.setInt(index++, this.periodRange[0] * 100 + this.periodRange[1]);
        sp.setInt(index++, this.periodRange[2] * 100 + this.periodRange[3]);
        try {
            iRowSet.beforeFirst();
            StringBuffer tmpStr = new StringBuffer();
            StringBuffer acIdStr = new StringBuffer();
            while (iRowSet.next()) {
                String accountId = iRowSet.getString("fid");
                int isLeaf = iRowSet.getInt("fisleaf");
                if (!"false".equals(this.accountMap.get(accountId + "hasChild"))) continue;
                if (isLeaf == 1) {
                    acIdStr.append(" '").append(accountId).append("',");
                    continue;
                }
                tmpStr.append(" or av.fnumber like '").append(iRowSet.getString("fnumber")).append("%'");
            }
            sql.append("\n and ( ");
            if (tmpStr.toString().indexOf("or") != -1) {
                sql.append(tmpStr.substring(4));
            }
            if (acIdStr.toString().length() > 0) {
                this.delLastChar(acIdStr);
                if (tmpStr.toString().indexOf("or") != -1) {
                    sql.append(" or ");
                }
                sql.append("\n av.fid in (");
                sql.append(acIdStr);
                sql.append(")");
            }
            sql.append(")");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        sql.append("\n and B.FCurrencyID in(");
        CurrencyInfo ci = null;
        for (int i = 0; i < this.currencySize; ++i) {
            ci = this.currencys.get(i);
            sql.append("?,");
            sp.setString(index++, ci.getId().toString());
        }
        this.delLastChar(sql);
        sql.append(")");
        if (this.needFilteHg) {
            this.fiterHg(sql, sp, "AV");
        }
        sql.append(null == this.getGovAccountDetailFilter(this.ctx, this.condition) ? "" : this.getGovAccountDetailFilter(this.ctx, this.condition));
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])sp.getParams());
    }

    @Override
    protected void dealVchBalance(int seq, int batch, String periodid, String vchId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        int index = 1;
        sql.append("select isnull(sum(case when vch.ActDC = ");
        sql.append(1).append(" then vch.FLocalAmount else 0 end), 0) debitLocal, \r\n");
        sql.append("isnull(sum(case when vch.ActDC = ");
        sql.append(0).append(" then vch.FLocalAmount else 0 end), 0) creditLocal \r\n");
        if (this.displayAmount) {
            sql.append(", isnull(sum(case when vch.ActDC = ");
            sql.append(1).append(" then vch.fquantity else 0 end), 0) debitQty, \r\n");
            sql.append("isnull(sum(case when vch.ActDC = ");
            sql.append(0).append(" then vch.fquantity else 0 end), 0) creditQty \r\n");
        }
        sql.append("from ").append(this.dao.getDataSourceTableName()).append(" ds \r\n");
        sql.append("inner join ").append(this.dao.getIdListTempTable()).append(" ids on ds.KSQL_SEQ = ids.SQL_SEQ and ds.SQL_BATCH = ids.SQL_BATCH \r\n");
        sql.append(" left outer join ").append(this.entryTempTable);
        sql.append(" vch on ds.voucherid = vch.voucherId and ds.actdc = vch.actdc ");
        if (!this.displayOneLineBiz) {
            sql.append(" and ds.fseq = vch.fseq ");
        }
        sql.append("where ds.fperiodid = ? \r\n");
        index = sp.size() + 1;
        sp.setString(index++, periodid);
        sql.append("and ids.ksql_seq < ( \r\n");
        sql.append("select ksql_seq from ").append(this.dao.getIdListTempTable()).append(" \r\n");
        sql.append("where SQL_SEQ = ? and SQL_BATCH = ?) \r\n");
        sp.setInt(index++, seq);
        sp.setInt(index++, batch);
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sp.getParams());
            while (rowSet.next()) {
                BigDecimal debit = rowSet.getBigDecimal("debitLocal");
                BigDecimal credit = rowSet.getBigDecimal("creditLocal");
                this.balances[1] = this.balances[1].add(debit).subtract(credit);
                if (!this.displayAmount) continue;
                BigDecimal debitQty = rowSet.getBigDecimal("debitQty");
                BigDecimal creditQty = rowSet.getBigDecimal("creditQty");
                this.balances[0] = this.balances[0].add(debitQty).subtract(creditQty);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
    }

    @Override
    protected String getQuerySql(GLRptID[] ids) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        sql.append(" select DISTINCT p.KSQL_SEQ temp_SEQ, ").append(((GLRptQuery)query).getSelectSQL()).append(" ,t.FSourceType,t.no,t.ActDC,");
        sql.append("t.fperiodid, t.fperiodYear, t.fperiodNumber, vch.flongnumber,vch.FCurrencyID,vch.voucherId,");
        sql.append("IsNull(vch.FOriginalAmount, 0) FOriginalAmount,IsNull(vch.FLocalAmount, 0) FLocalAmount");
        if (this.displayAmount) {
            sql.append(", IsNull(vch.muname, '') muname");
            sql.append(", IsNull(vch.fquantity, 0) fquantity, IsNull(vch.FStandardQuantity, 0) FStandardQuantity, \n");
            sql.append("IsNull(vch.fprice, 0) fprice, IsNull(vch.FCoefficient, 0) FCoefficient \n");
        }
        sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t \r\n");
        sql.append(" inner join ").append(this.dao.getIdListTempTable()).append(" p on t.KSQL_SEQ = p.SQL_SEQ and t.SQL_BATCH = p.SQL_BATCH \r\n");
        sql.append(" left outer join ");
        if (this.displayOneLineBiz) {
            sql.append("(select t2.actdc, t2.flongnumber,t2.FCurrencyID,");
            sql.append("t2.voucherId,IsNull(sum(t2.FOriginalAmount), 0) FOriginalAmount,IsNull(sum(t2.FLocalAmount), 0) FLocalAmount");
            if (this.displayAmount) {
                sql.append(", t2.muname");
                sql.append(", IsNull(sum(t2.fquantity), 0) fquantity, IsNull(sum(t2.FStandardQuantity), 0) FStandardQuantity, \n");
                sql.append("IsNull(sum(t2.fprice), 0) fprice, IsNull(sum(t2.FCoefficient), 0) FCoefficient \n");
            }
            sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t1 inner join ").append(this.entryTempTable).append(" t2 ");
            sql.append(" on t1.voucherid = t2.voucherid and t1.actdc = t2.actdc  group by t2.flongnumber,t2.FCurrencyID,t2.voucherId,t2.actdc  ");
            if (this.displayAmount) {
                sql.append(",t2.muname");
            }
            sql.append("  )  ");
        } else {
            sql.append(this.entryTempTable);
        }
        sql.append(" vch on t.voucherid = vch.voucherId and t.actdc = vch.actdc ");
        if (!this.displayOneLineBiz) {
            sql.append(" and t.fseq = vch.fseq ");
            sql.append(" and t.fentryid = vch.fentryid ");
        }
        if (this.displayAmount) {
            sql.append(" and isnull(t.muname, 'mname') = isnull(vch.muname, 'mname') \r\n");
        }
        if (ids != null && ids.length > 0) {
            sql.append(" where ").append(this.glRptIDs2StrId(ids, "t"));
        }
        sql.append("order by  temp_SEQ ");
        return sql.toString();
    }

    @Override
    protected void dealRowToMap(IRowSet rs, Map<String, BigDecimal> mulColMap) throws SQLException {
        String prefix = rs.getString("FLongNumber") + "_" + rs.getString("FCurrencyID") + "_" + rs.getString("actDC");
        mulColMap.put(prefix + "_for", rs.getBigDecimal("FOriginalAmount"));
        mulColMap.put(prefix + "_loc", rs.getBigDecimal("FLocalAmount"));
        if (this.displayAmount) {
            mulColMap.put(prefix + "_qty", this.isQtyAsst ? rs.getBigDecimal("FStandardQuantity") : rs.getBigDecimal("FQuantity"));
        }
        prefix = prefix + "_year";
        mulColMap.put(prefix + "_for", rs.getBigDecimal("FYearOMT"));
        mulColMap.put(prefix + "_loc", rs.getBigDecimal("FYearLMT"));
        if (this.displayAmount) {
            mulColMap.put(prefix + "_qty", this.isQtyAsst ? rs.getBigDecimal("FYearStQTY") : rs.getBigDecimal("FYearQTY"));
        }
        prefix = prefix + "_period";
        mulColMap.put(prefix + "_for", rs.getBigDecimal("FPeriodOMT"));
        mulColMap.put(prefix + "_loc", rs.getBigDecimal("FPeriodLMT"));
        if (this.displayAmount) {
            mulColMap.put(prefix + "_qty", this.isQtyAsst ? rs.getBigDecimal("FPeriodStQTY") : rs.getBigDecimal("FPeriodQTY"));
        }
    }

    @Override
    protected void dealMulColSumToMap(Map<String, BigDecimal> mulColMap) {
        HashMap<String, BigDecimal> accountViewDcSumMap = new HashMap<String, BigDecimal>();
        String cColName = "Credit";
        String dColName = "Debit";
        for (int i = 0; i < this.currencySize; ++i) {
            String currencyId = this.currencys.get(i).getId().toString();
            for (Map.Entry<String, BigDecimal> entry : mulColMap.entrySet()) {
                String[] keys = entry.getKey().split("_");
                String string = keys[1];
                String dc = keys[2];
                if (!currencyId.equals(string)) continue;
                StringBuilder key = new StringBuilder();
                if ("1".equals(dc)) {
                    key.append(dColName);
                } else {
                    if (!"0".equals(dc)) continue;
                    key.append(cColName);
                }
                key.append("_").append(currencyId);
                for (int j = 3; j < keys.length; ++j) {
                    key.append("_").append(keys[j]);
                }
                BigDecimal sum = (BigDecimal)accountViewDcSumMap.get(key.toString());
                if (sum == null) {
                    sum = GlUtils.zero;
                }
                accountViewDcSumMap.put(key.toString(), sum.add(entry.getValue()));
            }
        }
        HashMap<String, BigDecimal> tempMulColMap = new HashMap<String, BigDecimal>(mulColMap);
        for (Map.Entry entry : tempMulColMap.entrySet()) {
            String[] stringArray = ((String)entry.getKey()).split("_");
            String dc = stringArray[2];
            if (!"0".equals(dc)) continue;
            StringBuilder stringBuilder = new StringBuilder(stringArray[0] + "_" + stringArray[1] + "_1");
            for (int i = 3; i < stringArray.length; ++i) {
                stringBuilder.append("_").append(stringArray[i]);
            }
            if (mulColMap.containsKey(stringBuilder.toString())) {
                BigDecimal debitAmt = mulColMap.get(stringBuilder.toString());
                mulColMap.put(stringBuilder.toString(), debitAmt.subtract((BigDecimal)entry.getValue()));
                mulColMap.remove(entry.getKey());
                continue;
            }
            BigDecimal creditAmt = mulColMap.get(entry.getKey());
            mulColMap.remove(entry.getKey());
            mulColMap.put(stringBuilder.toString(), creditAmt.negate());
        }
        int level = 0;
        for (Map.Entry<String, BigDecimal> entry : mulColMap.entrySet()) {
            String key = entry.getKey();
            String string = key.substring(0, key.indexOf(95));
            int curLevel = string.split("!").length;
            level = Math.max(level, curLevel);
        }
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(mulColMap);
        while (level > 1) {
            HashMap<String, BigDecimal> hashMap2 = new HashMap<String, BigDecimal>(hashMap);
            for (Map.Entry entry : hashMap2.entrySet()) {
                String key = (String)entry.getKey();
                String longNumber = key.substring(0, key.indexOf(95));
                String nonNumber = key.substring(key.indexOf(95));
                int curLevel = longNumber.split("!").length;
                if (curLevel != level) continue;
                String parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf(33));
                BigDecimal sum = (BigDecimal)hashMap.get(parentLongNumber + nonNumber);
                if (sum == null) {
                    sum = GlUtils.zero;
                }
                hashMap.put(parentLongNumber + nonNumber, sum.add((BigDecimal)entry.getValue()));
            }
            --level;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (mulColMap.containsKey(entry.getKey())) continue;
            mulColMap.put((String)entry.getKey(), (BigDecimal)entry.getValue());
        }
        mulColMap.putAll(accountViewDcSumMap);
    }

    @Override
    protected String getQueryBalSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("select IsNull(sum((2 * t.actDc - 1) * IsNull(vch.FOriginalAmount, 0)), 0) FOriginalAmount");
        sql.append(",IsNull(sum((2 * t.actDc - 1) * IsNull(vch.FLocalAmount, 0)), 0) FLocalAmount ");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.actDC = 1 then vch.FLocalAmount else 0 end, 0)), 0) FYearDetLMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? and t.actDC = 1 then vch.FLocalAmount else 0 end, 0)), 0) FPeriodDetLMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.actDC <> 1 then vch.FLocalAmount else 0 end, 0)), 0) FYearCetLMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? and t.actDC <> 1  then vch.FLocalAmount else 0 end, 0)), 0) FPeriodCetLMT");
        if (this.displayAmount) {
            sql.append(",IsNull(sum((2 * t.actDc - 1) * IsNull(vch.FQuantity, 0)), 0) FQuantity");
            sql.append(",IsNull(sum((2 * t.actDc - 1) * IsNull(vch.FStandardQuantity, 0)), 0) FStandardQuantity");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.actDC = 1 then vch.FQuantity else 0 end, 0)), 0) FYearDetQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? and t.actDC = 1 then vch.FQuantity else 0 end, 0)), 0) FPeriodDetQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.actDC <> 1 then vch.FQuantity else 0 end, 0)), 0) FYearCetQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? and t.actDC <> 1 then vch.FQuantity else 0 end, 0)), 0) FPeriodCetQTY");
        }
        sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t \n");
        sql.append(" inner join ").append(this.dao.getIdListTempTable()).append(" p on t.KSQL_SEQ = p.SQL_SEQ and t.SQL_BATCH = p.SQL_BATCH \r\n");
        sql.append(" left outer join ");
        if (this.displayOneLineBiz) {
            sql.append("(select t2.actDC, t2.FLongNumber, t2.FCurrencyID, t2.voucherId, t2.fsourcetype");
            sql.append(",IsNull(sum(IsNull(t2.FOriginalAmount, 0)), 0) FOriginalAmount");
            sql.append(",IsNull(sum(IsNull(t2.FLocalAmount, 0)), 0) FLocalAmount");
            if (this.displayAmount) {
                sql.append(",t2.muName");
                sql.append(",IsNull(sum(IsNull(t2.FQuantity, 0)), 0) FQuantity");
                sql.append(",IsNull(sum(IsNull(t2.FStandardQuantity, 0)), 0) FStandardQuantity");
                sql.append(",IsNull(sum(IsNull(t2.FPrice, 0)), 0) FPrice");
                sql.append(",IsNull(sum(IsNull(t2.FCoefficient, 0)), 0) FCoefficient");
            }
            sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t1 inner join ").append(this.entryTempTable).append(" t2 ");
            sql.append(" on t1.voucherId = t2.voucherId and t1.actDC = t2.actDC group by t2.FLongNumber, t2.FCurrencyID, t2.voucherId, t2.actDC, t2.fsourcetype");
            if (this.displayAmount) {
                sql.append(",t2.muName");
            }
            sql.append("  )  ");
        } else {
            sql.append(this.entryTempTable);
        }
        sql.append(" vch on t.voucherId = vch.voucherId and t.actDC = vch.actDC");
        if (!this.displayOneLineBiz) {
            sql.append(" and t.FSeq = vch.FSeq ");
            sql.append(" and t.FEntryId = vch.FEntryId ");
        }
        if (this.displayAmount) {
            sql.append(" and IsNull(t.muName, 'mname') = IsNull(vch.muName, 'mname') \r\n");
        }
        sql.append(" where p.KSQL_SEQ < ? ");
        return sql.toString();
    }

    @Override
    protected String getQueryColSumSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("select t.actDC ActDC, 0 FPeriodId, vch.FCurrencyID, vch.FLongNumber, 1 FCoefficient, N'' muName");
        sql.append(",IsNull(sum(IsNull(vch.FOriginalAmount, 0)), 0) FOriginalAmount");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? then vch.FOriginalAmount else 0 end, 0)), 0) FYearOMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? then vch.FOriginalAmount else 0 end, 0)), 0) FPeriodOMT");
        sql.append(",IsNull(sum(IsNull(vch.FLocalAmount, 0)), 0) FLocalAmount ");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? then vch.FLocalAmount else 0 end, 0)), 0) FYearLMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? then vch.FLocalAmount else 0 end, 0)), 0) FPeriodLMT");
        if (this.displayAmount) {
            sql.append(",IsNull(sum(IsNull(vch.FQuantity, 0)), 0) FQuantity");
            sql.append(",IsNull(sum(IsNull(vch.FStandardQuantity, 0)), 0) FStandardQuantity");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? then vch.FQuantity else 0 end, 0)), 0) FYearQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? then vch.FQuantity else 0 end, 0)), 0) FPeriodQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? then vch.FStandardQuantity else 0 end, 0)), 0) FYearStQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? then vch.FStandardQuantity else 0 end, 0)), 0) FPeriodStQTY");
        }
        sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t \r\n");
        sql.append(" inner join ").append(this.dao.getIdListTempTable()).append(" p on t.KSQL_SEQ = p.SQL_SEQ and t.SQL_BATCH = p.SQL_BATCH \r\n");
        sql.append(" left outer join ");
        if (this.displayOneLineBiz) {
            sql.append("(select t2.actDC, t2.FLongNumber, t2.FCurrencyID, t2.voucherId");
            sql.append(",IsNull(sum(IsNull(t2.FOriginalAmount, 0)), 0) FOriginalAmount");
            sql.append(",IsNull(sum(IsNull(t2.FLocalAmount, 0)), 0) FLocalAmount");
            if (this.displayAmount) {
                sql.append(",t2.muName");
                sql.append(",IsNull(sum(IsNull(t2.FQuantity, 0)), 0) FQuantity");
                sql.append(",IsNull(sum(IsNull(t2.FStandardQuantity, 0)), 0) FStandardQuantity");
                sql.append(",IsNull(sum(IsNull(t2.FPrice, 0)), 0) FPrice");
                sql.append(",IsNull(sum(IsNull(t2.FCoefficient, 0)), 0) FCoefficient \n");
            }
            sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t1 inner join ").append(this.entryTempTable).append(" t2 ");
            sql.append(" on t1.voucherId = t2.voucherId and t1.actDC = t2.actDC group by t2.FLongNumber, t2.FCurrencyID, t2.voucherId, t2.actDC");
            if (this.displayAmount) {
                sql.append(", t2.muName");
            }
            sql.append("  )  ");
        } else {
            sql.append(this.entryTempTable);
        }
        sql.append(" vch on t.voucherId = vch.voucherId and t.actDC = vch.actDC ");
        if (!this.displayOneLineBiz) {
            sql.append(" and t.FSeq = vch.FSeq ");
            sql.append(" and t.FEntryId = vch.FEntryId ");
        }
        if (this.displayAmount) {
            sql.append(" and isnull(t.muName, 'mname') = isnull(vch.muName, 'mname') \r\n");
        }
        sql.append(" where p.KSQL_SEQ < ? ");
        sql.append(" group by t.actDC, vch.FCurrencyID, vch.FLongNumber ");
        return sql.toString();
    }

    @Override
    protected String getQuerySql(GLRptID[] ids, String orderSql) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        sql.append(" select DISTINCT  ").append(((GLRptQuery)query).getSelectSQL()).append(" ,t.FSourceType,t.no,t.ActDC,");
        sql.append("t.fperiodid, t.fperiodYear, t.fperiodNumber, vch.flongnumber,vch.FCurrencyID,vch.voucherId,");
        sql.append("IsNull(vch.FOriginalAmount, 0) FOriginalAmount,IsNull(vch.FLocalAmount, 0) FLocalAmount");
        if (this.displayAmount) {
            sql.append(", IsNull(vch.muname, '') muname");
            sql.append(", IsNull(vch.fquantity, 0) fquantity, IsNull(vch.FStandardQuantity, 0) FStandardQuantity, \n");
            sql.append("IsNull(vch.fprice, 0) fprice, IsNull(vch.FCoefficient, 0) FCoefficient \n");
        }
        sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t \r\n");
        sql.append(" inner join ").append(this.dao.getIdListTempTable()).append(" p on t.KSQL_SEQ = p.SQL_SEQ and t.SQL_BATCH = p.SQL_BATCH \r\n");
        sql.append(" left outer join ").append(this.entryTempTable);
        sql.append(" vch on t.voucherid = vch.voucherId and t.actdc = vch.actdc ");
        if (!this.displayOneLineBiz) {
            sql.append(" and t.fseq = vch.fseq ");
        }
        if (this.displayAmount) {
            sql.append(" and isnull(t.muname, 'mname') = isnull(vch.muname, 'mname') \r\n");
        }
        if (ids != null && ids.length > 0) {
            sql.append(" where ").append(this.glRptIDs2StrId(ids, "t"));
        }
        sql.append(orderSql);
        return sql.toString();
    }

    protected String getVoucherOrgIdFilter() {
        return " v.fcompanyid = ? ";
    }

    protected String getVoucherOrgIdFilter2() {
        return " A.FCompanyId = ? ";
    }

    protected int getVoucherOrgIdFilterValue(SqlParams sp, int index) {
        String indStr = String.valueOf(index);
        if (indStr.length() >= 4 && indStr.indexOf("999") >= 0) {
            index = Integer.valueOf(indStr.substring(0, indStr.lastIndexOf("999")));
        }
        sp.setString(index++, this.companyid);
        return index;
    }

    protected String getVoucherOrgIdFilter1() {
        return " GL.FOrgUnitID = ? ";
    }

    protected void joinPLVoucherSql(StringBuffer sql, SqlParams sp, IRowSet rs) throws SQLException, BOSException {
        String periodId = rs.getString("fperiodid");
        int pYear = rs.getInt("fperiodyear");
        int pNumber = rs.getInt("fperiodNumber");
        int index = sp.size() + 1;
        sql.append("select plav.fid accountid, ve.fcurrencyid currencyid, \r\n");
        if (this.needFilteHg) {
            sql.append(" hg.fid hgid,");
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(1).append(" then va.FOriginalAmount else 0 end) debitfor, \r\n");
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(0).append(" then va.FOriginalAmount else 0 end) creditfor, \r\n");
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(1).append(" then va.FLocalAmount else 0 end) debitlocal, \r\n");
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(0).append(" then va.FLocalAmount else 0 end) creditlocal, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(1).append(" then va.FOriginalAmount else 0 end) ydebitfor, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(0).append(" then va.FOriginalAmount else 0 end) ycreditfor, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(1).append(" then va.FLocalAmount else 0 end) ydebitlocal, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(0).append(" then va.FLocalAmount else 0 end) ycreditlocal, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(1).append(" then va.FOriginalAmount else 0 end) sumdebitfor, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(0).append(" then va.FOriginalAmount else 0 end) sumcreditfor, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(1).append(" then va.FLocalAmount else 0 end) sumdebitlocal, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(0).append(" then va.FLocalAmount else 0 end) sumcreditlocal \r\n");
            sql.append(", sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(1).append(" then va.fstandardquantity else 0 end) debitQty, \r\n");
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(0).append(" then va.fstandardquantity else 0 end) creditQty, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(1).append(" then va.fstandardquantity else 0 end) ydebitQty, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(0).append(" then va.fstandardquantity else 0 end) ycreditQty, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(1).append(" then va.fstandardquantity else 0 end) sumdebitQty, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(0).append(" then va.fstandardquantity else 0 end) sumcreditQty \r\n");
        } else {
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(1).append(" then ve.FOriginalAmount else 0 end) debitfor, \r\n");
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(0).append(" then ve.FOriginalAmount else 0 end) creditfor, \r\n");
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(1).append(" then ve.FLocalAmount else 0 end) debitlocal, \r\n");
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(0).append(" then ve.FLocalAmount else 0 end) creditlocal, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(1).append(" then ve.FOriginalAmount else 0 end) ydebitfor, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(0).append(" then ve.FOriginalAmount else 0 end) ycreditfor, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(1).append(" then ve.FLocalAmount else 0 end) ydebitlocal, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(0).append(" then ve.FLocalAmount else 0 end) ycreditlocal, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(1).append(" then ve.FOriginalAmount else 0 end) sumdebitfor, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(0).append(" then ve.FOriginalAmount else 0 end) sumcreditfor, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(1).append(" then ve.FLocalAmount else 0 end) sumdebitlocal, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(0).append(" then ve.FLocalAmount else 0 end) sumcreditlocal \r\n");
            sql.append(", sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(1).append(" then ve.fstandardquantity else 0 end) debitQty, \r\n");
            sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(0).append(" then ve.fstandardquantity else 0 end) creditQty, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(1).append(" then ve.fstandardquantity else 0 end) ydebitQty, \r\n");
            sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(0).append(" then ve.fstandardquantity else 0 end) ycreditQty, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(1).append(" then ve.fstandardquantity else 0 end) sumdebitQty, \r\n");
            sql.append(" sum(case when ve.FEntryDC = ").append(0).append(" then ve.fstandardquantity else 0 end) sumcreditQty \r\n");
        }
        sql.append("from ").append(this.getVoucherTableName()).append(" v \r\n");
        sql.append("inner join ").append(this.getVoucherEntryTableName()).append(" ve on ve.fbillid = v.fid \r\n");
        sql.append("inner join t_bd_accountview plav on plav.fid = ve.faccountid and v.fcompanyid = plav.fcompanyid \r\n");
        if (this.needFilteHg) {
            sql.append("INNER JOIN ").append(this.getVoucherAssRedTableName()).append(" VA ON v.FID = VA.FBillID and ve.FID = VA.FEntryID ").append("INNER JOIN  T_BD_AssistantHg HG ON VA.FAssGrpID = HG.FID ");
        }
        sql.append("inner join t_bd_period pd on pd.fid = v.fperiodid \r\n");
        sql.append("inner join t_bd_period ypd on pd.fnumber <= ypd.fnumber \r\n");
        sql.append("where v.fbizstatus in ").append(this.balTypes).append(" \r\n");
        sql.append(" and ypd.fid = ? \r\n");
        sql.append("and v.fsourcetype = 1 and ").append(this.getVoucherOrgIdFilter()).append(" and pd.ftypeid = ? \r\n");
        sql.append(" and plav.faccounttableid = ? \r\n");
        sql.append(" and plav.fisleaf = 1 and plav.fcompanyid =  ? \r\n");
        sp.setString(index++, periodId);
        index = this.getVoucherOrgIdFilterValue(sp, index);
        sp.setString(index++, this.periodType);
        sp.setString(index++, this.accountTableID);
        sp.setString(index++, this.companyid);
        sql.append(" and pd.fnumber >= ?").append(" and pd.fnumber <= ?");
        sp.setInt(index++, this.getRptCondition().getPeriodYearStart() * 100 + 1);
        sp.setInt(index++, pYear * 100 + pNumber);
        try {
            IRowSet iRowSet = (IRowSet)this.accountMap.get("iRowSet");
            iRowSet.beforeFirst();
            StringBuffer tmpStr = new StringBuffer();
            StringBuffer acIdStr = new StringBuffer();
            while (iRowSet.next()) {
                String accountId = iRowSet.getString("fid");
                int isLeaf = iRowSet.getInt("fisleaf");
                if (!"false".equals(this.accountMap.get(accountId + "hasChild"))) continue;
                if (isLeaf == 1) {
                    acIdStr.append(" '").append(accountId).append("',");
                    continue;
                }
                tmpStr.append(" or plav.fnumber like '").append(iRowSet.getString("fnumber")).append("%'");
            }
            sql.append("\n and ( ");
            if (tmpStr.toString().indexOf("or") != -1) {
                sql.append(tmpStr.substring(4));
            }
            if (acIdStr.toString().length() > 0) {
                this.delLastChar(acIdStr);
                if (tmpStr.toString().indexOf("or") != -1) {
                    sql.append(" or ");
                }
                sql.append("\n plav.fid in (");
                sql.append(acIdStr);
                sql.append(")");
            }
            sql.append(")");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        sql.append("\n and ve.FCurrencyID in(");
        for (int i = 0; i < this.currencySize; ++i) {
            sql.append("?,");
            sp.setString(index++, this.currencys.get(i).getId().toString());
        }
        this.delLastChar(sql);
        sql.append(") \r\n");
        if (this.needFilteHg) {
            this.fiterHg(sql, sp, "plav");
        }
        sql.append("group by plav.fid, ve.fcurrencyid \r\n");
        if (this.needFilteHg) {
            sql.append(" , hg.fid \r\n");
        }
    }

    protected void joinPsAmoutSql(StringBuffer sql, SqlParams sp, IRowSet rs) throws SQLException, BOSException {
        int pYear = rs.getInt("fperiodyear");
        int pNumber = rs.getInt("fperiodNumber");
        int index = sp.size() + 1;
        sql.append("select gl.faccountid,GL.FCurrencyId, \r\n");
        sql.append("sum(GL.FCreditFor) FCreditFor,sum(GL.FDebitFor) FDebitFor, \r\n");
        sql.append("sum(GL.FCreditLocal) FCreditLocal,sum(GL.FDebitLocal) FDebitLocal, \r\n");
        sql.append("sum(GL.FCreditQty) FCreditQty,sum(GL.FDebitQty) FDebitQty \r\n");
        if (this.needFilteHg) {
            sql.append(" , hg.fid hgid from ").append(this.getAsstBalanceTableName()).append(" GL \r\n");
            sql.append("inner join T_BD_AssistantHg HG ON GL.fassistgrpid = HG.FID \r\n");
        } else {
            sql.append("from ").append(this.getAcctBalanceTableName()).append(" GL \r\n");
        }
        sql.append("inner join T_BD_AccountView C ON C.FID = GL.FAccountID \r\n");
        sql.append("inner join t_bd_accounttype avt on c.FAccountTypeID = avt.fid \r\n");
        sql.append("where ").append(this.getVoucherOrgIdFilter1()).append(" \r\n");
        sql.append(" and c.faccounttableid = ? \r\n");
        index = this.getVoucherOrgIdFilterValue(sp, Integer.valueOf(index + "999"));
        sp.setString(index++, this.accountTableID);
        sql.append(" and gl.fperiod in " + SQLUtil.buildPeriodNumbersInSql(this.getRptCondition().getPeriodYearStart(), this.getRptCondition().getPeriodNumberStart(), pYear, pNumber));
        try {
            IRowSet iRowSet = (IRowSet)this.accountMap.get("iRowSet");
            iRowSet.beforeFirst();
            StringBuffer tmpStr = new StringBuffer();
            StringBuffer acIdStr = new StringBuffer();
            while (iRowSet.next()) {
                String accountId = iRowSet.getString("fid");
                int isLeaf = iRowSet.getInt("fisleaf");
                if (!"false".equals(this.accountMap.get(accountId + "hasChild"))) continue;
                if (isLeaf == 1) {
                    acIdStr.append(" '").append(accountId).append("',");
                    continue;
                }
                tmpStr.append(" or c.fnumber like '").append(iRowSet.getString("fnumber")).append("%'");
            }
            sql.append("\n and ( ");
            if (tmpStr.toString().indexOf("or") != -1) {
                sql.append(tmpStr.substring(4));
            }
            if (acIdStr.toString().length() > 0) {
                this.delLastChar(acIdStr);
                if (tmpStr.toString().indexOf("or") != -1) {
                    sql.append(" or ");
                }
                sql.append("\n c.fid in (");
                sql.append(acIdStr);
                sql.append(")");
            }
            sql.append(")");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        sql.append("\n and gl.FCurrencyID in(");
        for (int i = 0; i < this.currencySize; ++i) {
            sql.append("?,");
            sp.setString(index++, this.currencys.get(i).getId().toString());
        }
        this.delLastChar(sql);
        sql.append(") \r\n");
        if (this.needFilteHg) {
            this.fiterHg(sql, sp, "C");
        }
        sql.append("group by gl.faccountid, gl.fcurrencyid \r\n");
        if (this.needFilteHg) {
            sql.append(" , hg.fid \r\n");
        }
    }

    protected String getSystemstausOrgFilter() {
        return " inner join t_bd_SystemStatusCtrol ssc on ssc.fcompanyid = gl.forgunitid \r\n";
    }

    @Override
    protected void createSumLineSql(IRowSet rs, StringBuffer sql, SqlParams sp) throws SQLException, BOSException, EASBizException {
        String periodId = rs.getString("fperiodid");
        int pYear = rs.getInt("fperiodyear");
        int pNumber = rs.getInt("fperiodNumber");
        int index = sp.size() + 1;
        if (this.getRptCondition().isAfterCurrPeriod()) {
            sql.append("select ab.*, \r\n");
            sql.append("isnull(plV.DebitFor, 0) DebitFor, isnull(plV.DebitLocal, 0) DebitLocal, \r\n");
            sql.append("isnull(plV.CreditFor, 0) CreditFor, isnull(plV.CreditLocal, 0) CreditLocal, \r\n");
            sql.append("isnull(plV.DebitQty, 0) DebitQty, isnull(plV.CreditQty, 0) CreditQty, \r\n");
            sql.append("isnull(plV.yDebitFor, 0) yDebitFor, isnull(plV.yDebitLocal, 0) yDebitLocal, \r\n");
            sql.append("isnull(plV.yCreditFor, 0) yCreditFor, isnull(plV.yCreditLocal, 0) yCreditLocal, \r\n");
            sql.append("isnull(plV.yDebitQty, 0) yDebitQty, isnull(plV.yCreditQty, 0) yCreditQty, \r\n");
            sql.append("isnull(plV.sumDebitFor, 0) sumDebitFor, isnull(plV.sumDebitLocal, 0) sumDebitLocal, \r\n");
            sql.append("isnull(plV.sumCreditFor, 0) sumCreditFor, isnull(plV.sumCreditLocal, 0) sumCreditLocal, \r\n");
            sql.append("isnull(plV.sumDebitQty, 0) sumDebitQty, isnull(plV.sumCreditQty, 0) sumCreditQty \r\n");
            if (this.fetchDataType != 0) {
                sql.append(", isnull(ps.fDebitFor, 0) psDebitFor, isnull(ps.fCreditFor, 0) psCreditFor, \r\n");
                sql.append("isnull(ps.fDebitLocal, 0) psDebitLocal, isnull(ps.fCreditLocal, 0) psCreditLocal, \r\n");
                sql.append("isnull(ps.fDebitQty, 0) psDebitQty, isnull(ps.fCreditQty, 0) psCreditQty \r\n");
            }
            sql.append("from ( \r\n");
        }
        sql.append("select c.FID, avt.fproperty, C.FDC, ").append(pYear).append(" fperiodyear, ").append(pNumber).append(" fperiodnumber, \r\n");
        sql.append(" '").append(periodId).append("' fperiodid, c.FLongnumber, GL.FCurrencyId, \r\n");
        if (this.needFilteHg) {
            sql.append("GL.fassistgrpid, ");
        }
        if (this.getRptCondition().isAfterCurrPeriod()) {
            sql.append("min(sp.fperiodyear) fsperiodyear, min(sp.fperiodnumber) fsperiodnumber \r\n");
            sql.append(this.getAmountSelectSQL(sp, rs, "For"));
            sql.append(this.getAmountSelectSQL(sp, rs, "Local"));
            sql.append(this.getQtySelectSQL(sp, rs));
        } else {
            sql.append("sp.fperiodyear fsperiodyear, sp.fperiodnumber fsperiodnumber, \r\n");
            sql.append("GL.FBEGINBALANCEFor, GL.FbeginbalanceLocal,  \r\n");
            sql.append("GL.FDebitFor, GL.FDebitLocal, GL.FYearDebitFor, GL.FYearDebitLocal, \r\n");
            sql.append("GL.FCreditFor, GL.FCreditLocal, GL.FYearCreditFor, GL.FYearCreditLocal,  \r\n");
            sql.append("gl.fendbalancefor, gl.fendbalanceLocal, gl.fendqty, \r\n");
            sql.append("gl.FbeginQty, gl.fDebitQty, gl.fCreditQty, gl.FYearDebitQty, gl.FYearCreditQty, \r\n");
            sql.append("GL.FmonthpnlFor, GL.FmonthpnlLocal, GL.FyearpnlFor, GL.FyearpnlLocal, \r\n");
            sql.append("isnull(plV.DebitFor, 0) DebitFor, isnull(plV.DebitLocal, 0) DebitLocal, \r\n");
            sql.append("isnull(plV.CreditFor, 0) CreditFor, isnull(plV.CreditLocal, 0) CreditLocal, \r\n");
            sql.append("isnull(plV.DebitQty, 0) DebitQty, isnull(plV.CreditQty, 0) CreditQty, \r\n");
            sql.append("isnull(plV.yDebitFor, 0) yDebitFor, isnull(plV.yDebitLocal, 0) yDebitLocal, \r\n");
            sql.append("isnull(plV.yCreditFor, 0) yCreditFor, isnull(plV.yCreditLocal, 0) yCreditLocal, \r\n");
            sql.append("isnull(plV.yDebitQty, 0) yDebitQty, isnull(plV.yCreditQty, 0) yCreditQty, \r\n");
            sql.append("isnull(plV.sumDebitFor, 0) sumDebitFor, isnull(plV.sumDebitLocal, 0) sumDebitLocal, \r\n");
            sql.append("isnull(plV.sumCreditFor, 0) sumCreditFor, isnull(plV.sumCreditLocal, 0) sumCreditLocal, \r\n");
            sql.append("isnull(plV.sumDebitQty, 0) sumDebitQty, isnull(plV.sumCreditQty, 0) sumCreditQty \r\n");
            if (this.fetchDataType != 0) {
                sql.append(", isnull(ps.fDebitFor, 0) psDebitFor, isnull(ps.fCreditFor, 0) psCreditFor, \r\n");
                sql.append("isnull(ps.fDebitLocal, 0) psDebitLocal, isnull(ps.fCreditLocal, 0) psCreditLocal, \r\n");
                sql.append("isnull(ps.fDebitQty, 0) psDebitQty, isnull(ps.fCreditQty, 0) psCreditQty \r\n");
            }
        }
        if (this.needFilteHg) {
            sql.append("from ").append(this.getAsstBalanceTableName()).append(" GL \r\n");
            sql.append("inner join T_BD_AssistantHg HG ON GL.fassistgrpid = HG.FID \r\n");
        } else {
            sql.append("from ").append(this.getAcctBalanceTableName()).append(" GL \r\n");
        }
        if (!this.getRptCondition().isAfterCurrPeriod()) {
            sql.append("left outer join ( \r\n");
            this.joinPLVoucherSql(sql, sp, rs);
            sql.append(") plV on plV.accountid = GL.faccountid and plV.currencyid = GL.fcurrencyid \r\n");
            if (this.needFilteHg) {
                sql.append(" and GL.fassistgrpid = plv.hgid ");
            }
            if (this.fetchDataType != 0) {
                sql.append("left outer join ( \r\n");
                this.joinPsAmoutSql(sql, sp, rs);
                sql.append(") ps on ps.faccountid = GL.faccountid and ps.fcurrencyid = GL.fcurrencyid \r\n");
                if (this.needFilteHg) {
                    sql.append(" and GL.fassistgrpid = ps.hgid ");
                }
            }
        }
        sql.append("inner join T_BD_AccountView C ON C.FID = GL.FAccountID \r\n");
        sql.append("inner join t_bd_accounttype avt on c.FAccountTypeID = avt.fid \r\n");
        sql.append(this.getSystemstausOrgFilter());
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid \r\n");
        sql.append(" inner join t_bd_period sp on sp.fid = ssc.fstartperiodid \r\n");
        if (this.getRptCondition().isAfterCurrPeriod()) {
            sql.append(" inner join t_bd_period cp on cp.fid = ssc.fcurrentperiodid \r\n");
        }
        sql.append("where ss.fname = ").append(this.getSystemStatusName()).append(" and C.fisleaf = 1 and ").append(this.getVoucherOrgIdFilter1()).append(" \r\n");
        sql.append(" and c.faccounttableid = ? and sp.ftypeid = ? \r\n");
        index = sp.size() + 1;
        index = this.getVoucherOrgIdFilterValue(sp, Integer.valueOf(index + "999"));
        sp.setString(index++, this.accountTableID);
        sp.setString(index++, this.periodType);
        if (this.getRptCondition().isAfterCurrPeriod()) {
            int startPeriod;
            int endPeriod = startPeriod = pYear * 100 + pNumber;
            sql.append(" and gl.fperiod <= ? and (gl.fperiod >= ? or gl.fperiod >= cp.fnumber) \r\n");
            sp.setInt(index++, endPeriod);
            sp.setInt(index++, startPeriod);
        } else {
            sql.append(" and gl.fperiod = ? \r\n");
            sp.setInt(index++, pYear * 100 + pNumber);
        }
        try {
            IRowSet iRowSet = (IRowSet)this.accountMap.get("iRowSet");
            iRowSet.beforeFirst();
            StringBuffer tmpStr = new StringBuffer();
            StringBuffer acIdStr = new StringBuffer();
            while (iRowSet.next()) {
                String accountId = iRowSet.getString("fid");
                int isLeaf = iRowSet.getInt("fisleaf");
                if (!"false".equals(this.accountMap.get(accountId + "hasChild"))) continue;
                if (isLeaf == 1) {
                    acIdStr.append(" '").append(accountId).append("',");
                    continue;
                }
                tmpStr.append(" or c.fnumber like '").append(iRowSet.getString("fnumber")).append("%'");
            }
            sql.append("\n and ( ");
            if (tmpStr.toString().indexOf("or") != -1) {
                sql.append(tmpStr.substring(4));
            }
            if (acIdStr.toString().length() > 0) {
                this.delLastChar(acIdStr);
                if (tmpStr.toString().indexOf("or") != -1) {
                    sql.append(" or ");
                }
                sql.append("\n c.fid in (");
                sql.append(acIdStr);
                sql.append(")");
            }
            sql.append(")");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        sql.append("\n and GL.FCurrencyID in(");
        for (int i = 0; i < this.currencySize; ++i) {
            sql.append("?,");
            sp.setString(index++, this.currencys.get(i).getId().toString());
        }
        this.delLastChar(sql);
        sql.append(") \r\n");
        if (this.needFilteHg) {
            this.fiterHg(sql, sp, "C");
        }
        if (this.getRptCondition().isAfterCurrPeriod()) {
            sql.append(" group by c.FID, avt.fproperty, C.FDC, c.FLongnumber, GL.FCurrencyId ");
            if (this.needFilteHg) {
                sql.append(" , GL.fassistgrpid  ");
            }
            sql.append(") ab left outer join ( \r\n");
            this.joinPLVoucherSql(sql, sp, rs);
            sql.append(") plV on plV.accountid = ab.fid and plV.currencyid = ab.fcurrencyid \r\n");
            if (this.needFilteHg) {
                sql.append(" and ab.fassistgrpid = plv.hgid ");
            }
            if (this.fetchDataType != 0) {
                sql.append("left outer join ( \r\n");
                this.joinPsAmoutSql(sql, sp, rs);
                sql.append(") ps on ps.faccountid = ab.fid and ps.fcurrencyid = ab.fcurrencyid \r\n");
                if (this.needFilteHg) {
                    sql.append(" and ab.fassistgrpid = ps.hgid ");
                }
            }
        }
    }

    @Override
    protected boolean checkColItem(IRowSet rowSet, int mu) throws SQLException {
        boolean isChecked = false;
        String hAccountid = ((LabelValueBean)this.itemList.get(mu)).getValue();
        String hAccLNumber = (String)this.accountMap.get(hAccountid);
        String lAccLNumber = rowSet.getString("flongnumber");
        if (lAccLNumber != null && hAccLNumber != null && lAccLNumber.startsWith(hAccLNumber)) {
            isChecked = true;
        }
        return isChecked;
    }

    @Override
    protected boolean checkColItem_absolute(IRowSet rowSet, int mu) throws SQLException {
        boolean isChecked = false;
        String hAccountid = ((LabelValueBean)this.itemList.get(mu)).getValue();
        String hAccLNumber = (String)this.accountMap.get(hAccountid);
        String lAccLNumber = rowSet.getString("flongnumber");
        if (lAccLNumber != null && hAccLNumber != null && lAccLNumber.equals(hAccLNumber)) {
            isChecked = true;
        }
        return isChecked;
    }

    @Override
    protected void createInitColHideMapByVchSql(StringBuffer sql) {
        sql.append("select distinct flongnumber, FCurrencyID ");
        sql.append(" from ").append(this.entryTempTable).append(" where \r\n");
        sql.append(" fsourcetype <> 1 ");
        if (this.fetchDataType == 1) {
            sql.append(" and ActDC = ").append(1);
        } else if (this.fetchDataType != 0) {
            sql.append(" and ActDC = ").append(0);
        }
    }

    protected HashMap sortAccountMd(Context ctx, int fromAccountLevel) throws BOSException {
        StringBuffer accountIds = new StringBuffer();
        String actItemId = null;
        for (int i = 0; i < this.md.length; ++i) {
            actItemId = this.md[i][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)this.md[i][1]).getId().toString() : ((LabelValueBean)this.md[i][1]).getValue();
            accountIds.append(",'");
            accountIds.append(actItemId);
            accountIds.append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct av.fid, av.fcaa, av.flongnumber, av.fnumber, av.flevel, av.fisleaf, mu.fname_");
        sql.append(ctx.getLocale()).append(" fmuname, amu.fname_");
        sql.append(ctx.getLocale()).append(" famuname, \r\n");
        sql.append("case when childav.fid is null then 'false' else 'true' end hasChild \r\n");
        sql.append(" from t_bd_accountview av \r\n");
        sql.append("left join (select fid, fparentid from t_bd_accountview where fid in ( \r\n");
        sql.append(accountIds.substring(1));
        sql.append(")) childav on childav.fparentid = av.fid \r\n");
        sql.append(" left join T_BD_AsstAccount aa on aa.fid = av.fcaa \r\n");
        sql.append(" left join T_BD_MeasureUnitGroup mug on aa.FMeasureUnitGroupID = mug.fid \r\n");
        sql.append(" left join T_BD_MeasureUnit mu on mu.fid = mug.FDefaultUnitID \r\n");
        sql.append(" left join T_BD_MeasureUnitGroup amug on av.FMeasureUnitGroupID = amug.fid \r\n");
        sql.append(" left join T_BD_MeasureUnit amu on amu.fid = amug.FDefaultUnitID \r\n");
        sql.append(" where av.fid in ( ").append(accountIds.substring(1)).append(" ) \r\n");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Object> accountMap = new HashMap<String, Object>();
        accountMap.put("iRowSet", iRowSet);
        try {
            int maxAccountLevel = -1;
            int minAccountLevel = -1;
            String jdyMu = " ";
            while (iRowSet.next()) {
                accountMap.put(iRowSet.getString("fid"), iRowSet.getString("flongnumber"));
                accountMap.put(iRowSet.getString("fid") + "hasChild", iRowSet.getString("hasChild"));
                accountMap.put(iRowSet.getString("fid") + "level", iRowSet.getString("flevel"));
                if (iRowSet.getInt("flevel") < minAccountLevel || minAccountLevel < 0) {
                    minAccountLevel = iRowSet.getInt("flevel");
                }
                if (iRowSet.getInt("flevel") > maxAccountLevel || maxAccountLevel < 0) {
                    maxAccountLevel = iRowSet.getInt("flevel");
                }
                String fmuName = null;
                fmuName = this.isQtyAsst && iRowSet.getString("fcaa") != null ? iRowSet.getString("fmuname") : iRowSet.getString("famuname");
                accountMap.put(iRowSet.getString("fid") + "_mu", fmuName);
                accountMap.put(iRowSet.getString("flongnumber") + "_mu", fmuName);
                if (fmuName == null || jdyMu == null) continue;
                if (jdyMu.equals(" ")) {
                    jdyMu = fmuName;
                    continue;
                }
                if (jdyMu.equals(fmuName)) continue;
                jdyMu = null;
            }
            if (!this.isQtyAsst && this.accountView.isIsQty()) {
                jdyMu = this.getAccountViewMeasureUnitName();
            }
            if (jdyMu == null || jdyMu.trim().length() == 0) {
                jdyMu = this.getAccountViewMeasureUnitName();
            }
            accountMap.put("minAccountLevel", new Integer(minAccountLevel));
            accountMap.put("maxAccountLevel", new Integer(maxAccountLevel));
            accountMap.put("jdyMu", jdyMu == null ? "           " : jdyMu);
        }
        catch (SQLException ex) {
            throw new BOSException("Error sql: " + sql, (Throwable)ex);
        }
        int index = 0;
        boolean hasSwap = false;
        int i = 0;
        while (i < this.md.length) {
            hasSwap = false;
            index = i;
            String uperactItemId = this.md[i][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)this.md[i][1]).getId().toString() : ((LabelValueBean)this.md[i][1]).getValue();
            String uperlongNumber = (String)accountMap.get(uperactItemId);
            for (int k = i + 1; k < this.md.length; ++k) {
                String childactItemId = this.md[k][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)this.md[k][1]).getId().toString() : ((LabelValueBean)this.md[k][1]).getValue();
                String childlongNumber = (String)accountMap.get(childactItemId);
                if (childlongNumber != null && childlongNumber.startsWith(uperlongNumber)) {
                    Object[] temp = this.md[index];
                    this.md[index] = this.md[k];
                    this.md[k] = temp;
                    index = k;
                    hasSwap = true;
                    continue;
                }
                if (childlongNumber != null) continue;
                logger.info((Object)("\r\naccountviewLongNumberIsNull:" + childactItemId));
            }
            if (hasSwap) continue;
            ++i;
        }
        return accountMap;
    }

    @Override
    protected void getDetailMeasure(AbstractGLRptMulColAbsDao.VoucherLineData lineData, IRowSet rs) throws SQLException {
        String muName = null;
        boolean isDspStd = false;
        if (!this.isQtyAsst) {
            muName = lineData.getMeasureUnitName();
        } else {
            String acctLongNumber = rs.getString("flongnumber");
            muName = (String)this.accountMap.get(acctLongNumber + "_mu");
            isDspStd = true;
        }
        lineData.setDetailDspStandard(isDspStd);
        lineData.setDetailDspMu(muName);
    }

    @Override
    protected String getUniqueMeasureUnitName() {
        return (String)this.accountMap.get("jdyMu");
    }

    protected Object[][] initAndSortColData(List dclist, boolean isQueryUpAcc, int maxAccLevel) {
        Object[][] dcColumns = new Object[dclist.size()][1];
        if (isQueryUpAcc && this.uperAccountLevel >= 1) {
            dcColumns = new Object[dclist.size()][this.uperAccountLevel + 1];
        }
        int n = dcColumns.length;
        for (int i = 0; i < n; ++i) {
            dcColumns[n - i - 1][0] = ((LabelValueBean)dclist.get(i)).getLabel();
            if (!isQueryUpAcc) continue;
            String accId = ((LabelValueBean)dclist.get(i)).getValue();
            String accLNum = (String)this.accountMap.get(accId);
            if (this.accountMap.get(accId + "hasChild") != null && "true".equals(this.accountMap.get(accId + "hasChild"))) {
                dcColumns[n - i - 1][0] = (String)dcColumns[n - i - 1][0] + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"86_AccountAgeUI", (Locale)this.ctx.getLocale());
            }
            for (int level = 1; level <= this.uperAccountLevel; ++level) {
                boolean hasFind = false;
                int nj = dcColumns.length;
                for (int j = 0; j < nj; ++j) {
                    String upAccId = ((LabelValueBean)dclist.get(j)).getValue();
                    String upAccLNum = (String)this.accountMap.get(upAccId);
                    if (!accLNum.startsWith(upAccLNum) || Integer.valueOf((String)this.accountMap.get(upAccId + "level")) + level != maxAccLevel) continue;
                    dcColumns[n - i - 1][level] = ((LabelValueBean)dclist.get(j)).getLabel();
                    hasFind = true;
                    break;
                }
                if (hasFind) continue;
                dcColumns[n - i - 1][level] = dcColumns[n - i - 1][level - 1];
            }
        }
        return dcColumns;
    }

    @Override
    protected String getUniqueMeasureUnitName4Item(int itemIndex) {
        String headAccountid = ((LabelValueBean)this.itemList.get(itemIndex)).getValue();
        return (String)this.accountMap.get(headAccountid + "_mu");
    }
}

