/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.CommonSchema;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptMulColAbsDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactMultiColumnDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GLRptMulColAsstDao
extends AbstractGLRptMulColAbsDao {
    protected Object[] actAttributes;
    protected boolean isMultiLevel;
    protected String realtiondataobjectTable;
    protected HashMap actChild;
    private String baseMuName;

    public GLRptMulColAsstDao(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactMultiColumnDao dao, GLRptBaseCondition condition, CommonSchema cs) throws BOSException, EASBizException {
        super(ctx, company, dao, condition, cs);
    }

    protected String getVoucherTableName() {
        return "t_gl_voucher";
    }

    protected String getVoucherEntryTableName() {
        return "t_gl_voucherentry";
    }

    protected String getVoucherAssRedTableName() {
        return "T_GL_VoucherAssistRecord";
    }

    protected String getAsstBalanceTableName() {
        return GLBalanceUtils.getAssistBalanceTable(this.balType);
    }

    protected String getVoucherOrgIdFilter() {
        return " v.fcompanyid = ? ";
    }

    protected String getVoucherOrgIdFilter2() {
        return " A.FCompanyId = ? ";
    }

    protected int getVoucherOrgIdFilterValue(SqlParams sp, int index) {
        String indStr = String.valueOf(index);
        if (indStr.length() >= 4 && indStr.indexOf("999") >= 0) {
            index = Integer.valueOf(indStr.substring(0, indStr.lastIndexOf("999")));
        }
        sp.setString(index++, this.companyid);
        return index;
    }

    protected String getVoucherOrgIdFilter1() {
        return " GL.FOrgUnitID = ? ";
    }

    protected String getSystemstausOrgFilter() {
        return " inner join t_bd_SystemStatusCtrol ssc on ssc.fcompanyid = gl.forgunitid \r\n";
    }

    @Override
    protected void init() throws BOSException, EASBizException {
        super.init();
        LabelValueBean actType = (LabelValueBean)((List)this.cs.getParams().getObject("asstact_type_list")).get(this.cs.getParams().getInt("asstact_type_index"));
        this.actAttributes = (Object[])actType.getProperty();
        this.hgFieldName = (String)this.actAttributes[0];
        boolean bl = this.isMultiLevel = (Integer)this.actAttributes[5] == 1;
        if (this.actAttributes.length >= 10) {
            this.realtiondataobjectTable = (String)this.actAttributes[9];
        }
        if (this.isMultiLevel && this.realtiondataobjectTable != null) {
            this.actChild = new HashMap();
            StringBuffer actIds = new StringBuffer();
            String actItemId = null;
            for (int i = 0; i < this.md.length; ++i) {
                actItemId = this.md[i][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)this.md[i][1]).getId().toString() : ((LabelValueBean)this.md[i][1]).getValue();
                actIds.append(",'");
                actIds.append(actItemId);
                actIds.append("'");
            }
            try {
                String generalAsstFilter = "";
                if ("T_BD_GeneralAsstActType".equalsIgnoreCase(this.realtiondataobjectTable)) {
                    generalAsstFilter = "and parent.fgroupid = child.fgroupid ";
                }
                StringBuffer sql = new StringBuffer();
                sql.append("select distinct parent.fid actpid,child.fid actcid from ");
                sql.append(this.realtiondataobjectTable).append(" child \n");
                sql.append(" inner join ").append(this.realtiondataobjectTable).append(" parent on (");
                if (SQLUtil.isSupportCharIndexToLike(this.ctx)) {
                    sql.append("child.FLongNumber like concat(parent.FLongNumber, '!%') or parent.fid = child.fid) \n");
                } else {
                    sql.append("charindex(parent.FLongNumber ||'!',child.FLongNumber) = 1 or parent.fid = child.fid) \n");
                }
                sql.append(" where parent.fid in (").append(actIds.substring(1)).append(" ) and parent.fid <> child.fid ");
                sql.append(generalAsstFilter).append(" order by parent.fid ");
                IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                while (iRowSet.next()) {
                    ArrayList al;
                    if (this.actChild.get(iRowSet.getString("actpid")) == null) {
                        al = new ArrayList();
                        al.add(iRowSet.getString("actcid"));
                        this.actChild.put(iRowSet.getString("actpid"), al);
                        continue;
                    }
                    al = (ArrayList)this.actChild.get(iRowSet.getString("actpid"));
                    al.add(iRowSet.getString("actcid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException("sql error!", (Throwable)e);
            }
        }
        this.debitColumn = this.initAndSortColData(this.debitList);
        this.creditColumn = this.initAndSortColData(this.creditList);
        this.needFilteHg = true;
        this.initBaseMuName();
        if (!this.isQtyAsst && this.displayAmount) {
            StringBuffer sql = new StringBuffer();
            sql.append("select count(distinct FMeasureUnitGroupID) mugcount from T_BD_AccountView av  \r\n");
            sql.append(" where av.flongnumber like '").append(this.accountView.getLongNumber()).append("%' \r\n");
            sql.append(" and av.FAccountTableID = '").append(this.accountTableID).append("' \r\n");
            sql.append(" and av.FCompanyID = '").append(this.companyid).append("' \r\n");
            sql.append(" and av.fisQty = 1 \r\n");
            IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            int mugcount = 1;
            try {
                if (iRowSet.next()) {
                    mugcount = iRowSet.getInt("mugcount");
                }
            }
            catch (SQLException ex) {
                throw new BOSException("sql error!", (Throwable)ex);
            }
            if (mugcount > 1) {
                this.allAccountSameUnit = false;
            }
        }
    }

    private void initBaseMuName() throws BOSException, EASBizException {
        this.baseMuName = this.cs.getParams().getString("baseMuName");
        if (!this.isQtyAsst) {
            this.baseMuName = this.getAccountViewMeasureUnitName();
        }
        if (this.baseMuName == null) {
            this.baseMuName = "";
        }
    }

    @Override
    protected void createEntryTmpTable() throws BOSException {
        try {
            StringBuffer createTabSql = new StringBuffer("create table GLRptAsstactMultiColumnDao_Entry ");
            createTabSql.append("(voucherId VARCHAR(44), entryid VARCHAR(44), FSourcetype int, \r\n");
            createTabSql.append("ActDC int, FPeriodID VARCHAR(44), FPeriodYear INT, FPeriodNumber INT, \r\n");
            createTabSql.append("bizDate datetime, voucherTypeName VARCHAR(300), description VARCHAR(900), \r\n");
            createTabSql.append("asstItemId VARCHAR(44), FCurrencyID VARCHAR(44), \r\n");
            createTabSql.append("FOriginalAmount NUMERIC(19,4) DEFAULT 0, \r\n");
            createTabSql.append("FLocalAmount NUMERIC(19,4) DEFAULT 0, \r\n");
            if (!this.displayOneLineBiz) {
                createTabSql.append("FEntryID VARCHAR(44),\r\n");
            }
            createTabSql.append("FSeq INT, \r\n");
            createTabSql.append("fquantity NUMERIC(19,4) DEFAULT 0, \r\n");
            createTabSql.append("FStandardQuantity NUMERIC(19,4) DEFAULT 0, \r\n");
            createTabSql.append("fprice NUMERIC(19,4) DEFAULT 0, \r\n");
            if (this.displayAmount) {
                createTabSql.append("FCoefficient NUMERIC(19,4) DEFAULT 0, \r\n");
            }
            createTabSql.append(" muname VARCHAR(400) ");
            createTabSql.append(") \r\n");
            this.entryTempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTabSql.toString());
            this.insertEntryTmpVchData();
            TempTablePool.getInstance((Context)this.ctx).createIndex(this.entryTempTable, "voucherId, entryid", false, false);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }

    private String createHgIdsTmpTable() throws BOSException {
        String hgIdsTmpTable = "";
        try {
            StringBuffer createTabSql = new StringBuffer("create table gl_temp_table ");
            createTabSql.append("(hgId VARCHAR(44))");
            hgIdsTmpTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTabSql.toString());
            TempTablePool.getInstance((Context)this.ctx).createIndex(hgIdsTmpTable, "hgId", true, false);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
        return hgIdsTmpTable;
    }

    private List<String[]> getHgIdParamList() {
        HashSet<String> hgIdSet = new HashSet<String>();
        ArrayList<String[]> hgIdList = new ArrayList<String[]>();
        for (LabelValueBean labelValueBean : this.itemList) {
            String id = labelValueBean.getValue();
            if (!hgIdSet.contains(id)) {
                hgIdSet.add(id);
                hgIdList.add(new String[]{id});
            }
            if (this.actChild == null || this.actChild.get(labelValueBean.getValue()) == null) continue;
            ArrayList al = (ArrayList)this.actChild.get(labelValueBean.getValue());
            for (int ial = al.size() - 1; ial >= 0; --ial) {
                id = al.get(ial).toString();
                if (hgIdSet.contains(id)) continue;
                hgIdSet.add(id);
                hgIdList.add(new String[]{id});
            }
        }
        return hgIdList;
    }

    private String insertHgIdToTmpTable() throws BOSException {
        List<String[]> hgIds = this.getHgIdParamList();
        String hgTmpTableName = "";
        if (!hgIds.isEmpty()) {
            hgTmpTableName = this.createHgIdsTmpTable();
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append(hgTmpTableName);
            sb.append(" values(?)");
            int count = 0;
            for (int i = 1; i <= hgIds.size(); ++i) {
                ++count;
                if (i % 1000 != 0) continue;
                DbUtil.executeBatch((Context)this.ctx, (String)sb.toString(), hgIds.subList(i - 1000, i));
                count = 0;
            }
            if (count > 0) {
                DbUtil.executeBatch((Context)this.ctx, (String)sb.toString(), hgIds.subList(hgIds.size() - count, hgIds.size()));
            }
        }
        return hgTmpTableName;
    }

    protected void insertEntryTmpVchData() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        int index = 1;
        sql.append("insert ").append(this.entryTempTable);
        sql.append(" SELECT A.FID voucherId, B.fid entryid, A.FSourcetype, B.FEntryDC ActDC, \r\n");
        sql.append("F.FID FPeriodID, F.FPeriodYear,F.FPeriodNumber ,A.FBookedDate bizDate, \r\n");
        sql.append("C.FName_").append(this.loc).append("||'-'||IsNull(A.FNumber,'') voucherTypeName, \r\n");
        sql.append("(CASE WHEN VA.FDescription IS NOT NULL THEN VA.FDescription ELSE B.FDescription END) description,");
        sql.append("HG.").append(this.hgFieldName).append(", b.FCurrencyID, \r\n");
        sql.append("va.FOriginalAmount, va.FLocalAmount, \n");
        if (!this.displayOneLineBiz) {
            sql.append("B.fid FEntryID,\r\n");
        }
        sql.append("VA.FSeq FSeq, \r\n");
        if (this.displayAmount) {
            sql.append("VA.fquantity, VA.FStandardQuantity, VA.fprice, mu.FCoefficient, \n");
            sql.append("mu.fname_").append(this.loc).append(" muname ");
        } else {
            sql.append("0, 0, 0, '' ");
        }
        sql.append(" from ").append(this.getVoucherTableName()).append(" A  \r\n");
        sql.append(" inner join ").append(this.getVoucherEntryTableName()).append(" B on A.fid = B.fbillid \r\n");
        sql.append("\n INNER JOIN ").append(this.getVoucherAssRedTableName()).append(" VA ON A.FID = VA.FBillID and B.FID = VA.FEntryID ").append("\n INNER JOIN  T_BD_AssistantHg HG ON VA.FAssGrpID = HG.FID ");
        if (this.displayAmount) {
            if (this.isQtyAsst) {
                sql.append("\n left join t_bd_measureunit mu on va.FMeasureUnitID = mu.fid ");
            } else {
                sql.append("\n left join t_bd_measureunit mu on B.FMeasureUnitID = mu.fid ");
            }
        }
        sql.append(" inner join t_bd_vouchertypes C on A.fvouchertypeid = C.fid \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = b.faccountid \r\n");
        sql.append(" inner join t_bd_period F  on A.fperiodid = F.fid \r\n");
        String hgTmpTableName = this.insertHgIdToTmpTable();
        if (!"".equals(hgTmpTableName)) {
            sql.append(" inner join ").append(hgTmpTableName).append(" tmp on tmp.hgId = HG.").append(this.hgFieldName).append("  \r\n");
        }
        sql.append(null == this.getGovAccountDetailJoinTable(this.ctx, this.condition) ? "" : this.getGovAccountDetailJoinTable(this.ctx, this.condition));
        sql.append(" where ").append(this.getVoucherOrgIdFilter2()).append(" and  A.FBizStatus in ").append(this.balTypes);
        sql.append(" and av.flongnumber like '").append(this.accountView.getLongNumber()).append("%'");
        sql.append(" and av.FAccountTableID = '").append(this.accountTableID).append("' \r\n");
        if (this.includeNoTransPLVoucher) {
            sql.append(" and A.FSourcetype <> 1 ");
        }
        sql.append(" and F.FTypeID = ? and F.fNumber >= ? and F.fNumber <= ? \r\n");
        index = this.getVoucherOrgIdFilterValue(sp, index);
        sp.setString(index++, this.periodType);
        sp.setInt(index++, this.periodRange[0] * 100 + this.periodRange[1]);
        sp.setInt(index++, this.periodRange[2] * 100 + this.periodRange[3]);
        sql.append("\n and B.FCurrencyID in(");
        CurrencyInfo ci = null;
        for (int i = 0; i < this.currencySize; ++i) {
            ci = this.currencys.get(i);
            sql.append("?,");
            sp.setString(index++, ci.getId().toString());
        }
        this.delLastChar(sql);
        sql.append(")");
        this.fiterHg(sql, sp, "av");
        sql.append(null == this.getGovAccountDetailFilter(this.ctx, this.condition) ? "" : this.getGovAccountDetailFilter(this.ctx, this.condition));
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])sp.getParams());
    }

    @Override
    protected void createSumLineSql(IRowSet rs, StringBuffer sql, SqlParams sp) throws BOSException, EASBizException, SQLException {
        String periodId = rs.getString("fperiodid");
        int pYear = rs.getInt("fperiodyear");
        int pNumber = rs.getInt("fperiodNumber");
        int index = sp.size() + 1;
        if (this.getRptCondition().isAfterCurrPeriod()) {
            sql.append("select ab.*, \r\n");
            sql.append("isnull(plV.DebitFor, 0) DebitFor, isnull(plV.DebitLocal, 0) DebitLocal, \r\n");
            sql.append("isnull(plV.CreditFor, 0) CreditFor, isnull(plV.CreditLocal, 0) CreditLocal, \r\n");
            sql.append("isnull(plV.DebitQty, 0) DebitQty, isnull(plV.CreditQty, 0) CreditQty, \r\n");
            sql.append("isnull(plV.yDebitFor, 0) yDebitFor, isnull(plV.yDebitLocal, 0) yDebitLocal, \r\n");
            sql.append("isnull(plV.yCreditFor, 0) yCreditFor, isnull(plV.yCreditLocal, 0) yCreditLocal, \r\n");
            sql.append("isnull(plV.yDebitQty, 0) yDebitQty, isnull(plV.yCreditQty, 0) yCreditQty, \r\n");
            sql.append("isnull(plV.sumDebitFor, 0) sumDebitFor, isnull(plV.sumDebitLocal, 0) sumDebitLocal, \r\n");
            sql.append("isnull(plV.sumCreditFor, 0) sumCreditFor, isnull(plV.sumCreditLocal, 0) sumCreditLocal, \r\n");
            sql.append("isnull(plV.sumDebitQty, 0) sumDebitQty, isnull(plV.sumCreditQty, 0) sumCreditQty \r\n");
            if (this.fetchDataType != 0) {
                sql.append(", isnull(ps.fDebitFor, 0) psDebitFor, isnull(ps.fCreditFor, 0) psCreditFor, \r\n");
                sql.append("isnull(ps.fDebitLocal, 0) psDebitLocal, isnull(ps.fCreditLocal, 0) psCreditLocal, \r\n");
                sql.append("isnull(ps.fDebitQty, 0) psDebitQty, isnull(ps.fCreditQty, 0) psCreditQty \r\n");
            }
            sql.append("from ( \r\n");
        }
        sql.append("select c.FID, avt.fproperty, C.FDC, ").append(pYear).append(" fperiodyear, ");
        sql.append(pNumber).append(" fperiodnumber, '").append(periodId).append("' fperiodid, \r\n");
        sql.append("HG.").append(this.hgFieldName).append(" asstItemId, GL.FCurrencyId, GL.fassistgrpid, ");
        if (this.getRptCondition().isAfterCurrPeriod()) {
            sql.append("min(sp.fperiodyear) fsperiodyear, min(sp.fperiodnumber) fsperiodnumber \r\n");
            sql.append(this.getAmountSelectSQL(sp, rs, "For"));
            sql.append(this.getAmountSelectSQL(sp, rs, "Local"));
            sql.append(this.getQtySelectSQL(sp, rs));
        } else {
            sql.append("sp.fperiodyear fsperiodyear, sp.fperiodnumber fsperiodnumber, \r\n");
            sql.append("GL.FBEGINBALANCEFor, GL.FbeginbalanceLocal,  \r\n");
            sql.append("GL.FDebitFor, GL.FDebitLocal, GL.FYearDebitFor, GL.FYearDebitLocal, \r\n");
            sql.append("GL.FCreditFor, GL.FCreditLocal, GL.FYearCreditFor, GL.FYearCreditLocal,  \r\n");
            sql.append("gl.fendbalancefor, gl.fendbalanceLocal, gl.fendqty, \r\n");
            sql.append("gl.FbeginQty, gl.fDebitQty, gl.fCreditQty, gl.FYearDebitQty, gl.FYearCreditQty, \r\n");
            sql.append("GL.FmonthpnlFor, GL.FmonthpnlLocal, GL.FyearpnlFor, GL.FyearpnlLocal, \r\n");
            sql.append("isnull(plV.DebitFor, 0) DebitFor, isnull(plV.DebitLocal, 0) DebitLocal, \r\n");
            sql.append("isnull(plV.CreditFor, 0) CreditFor, isnull(plV.CreditLocal, 0) CreditLocal, \r\n");
            sql.append("isnull(plV.DebitQty, 0) DebitQty, isnull(plV.CreditQty, 0) CreditQty, \r\n");
            sql.append("isnull(plV.yDebitFor, 0) yDebitFor, isnull(plV.yDebitLocal, 0) yDebitLocal, \r\n");
            sql.append("isnull(plV.yCreditFor, 0) yCreditFor, isnull(plV.yCreditLocal, 0) yCreditLocal, \r\n");
            sql.append("isnull(plV.yDebitQty, 0) yDebitQty, isnull(plV.yCreditQty, 0) yCreditQty, \r\n");
            sql.append("isnull(plV.sumDebitFor, 0) sumDebitFor, isnull(plV.sumDebitLocal, 0) sumDebitLocal, \r\n");
            sql.append("isnull(plV.sumCreditFor, 0) sumCreditFor, isnull(plV.sumCreditLocal, 0) sumCreditLocal, \r\n");
            sql.append("isnull(plV.sumDebitQty, 0) sumDebitQty, isnull(plV.sumCreditQty, 0) sumCreditQty \r\n");
            if (this.fetchDataType != 0) {
                sql.append(", isnull(ps.fDebitFor, 0) psDebitFor, isnull(ps.fCreditFor, 0) psCreditFor, \r\n");
                sql.append("isnull(ps.fDebitLocal, 0) psDebitLocal, isnull(ps.fCreditLocal, 0) psCreditLocal, \r\n");
                sql.append("isnull(ps.fDebitQty, 0) psDebitQty, isnull(ps.fCreditQty, 0) psCreditQty \r\n");
            }
        }
        sql.append("from ").append(this.getAsstBalanceTableName()).append(" GL \r\n");
        sql.append("inner join T_BD_AssistantHg HG ON GL.fassistgrpid = HG.FID \r\n");
        if (!this.getRptCondition().isAfterCurrPeriod()) {
            sql.append("left outer join ( \r\n");
            this.joinPLVoucherSql(sql, sp, rs);
            sql.append(") plV on plV.accountid = GL.faccountid and plV.currencyid = GL.fcurrencyid and GL.fassistgrpid = plv.hgid \r\n");
            if (this.fetchDataType != 0) {
                sql.append("left outer join ( \r\n");
                this.joinPsAmoutSql(sql, sp, rs);
                sql.append(") ps on ps.faccountid = GL.faccountid and ps.fcurrencyid = GL.fcurrencyid and GL.fassistgrpid = ps.hgid \r\n");
            }
        }
        sql.append(" inner join T_BD_AccountView C ON C.FID = GL.FAccountID  \r\n");
        sql.append(" inner join t_bd_accounttype avt on c.FAccountTypeID = avt.fid \r\n");
        String hgTmpTableName = this.insertHgIdToTmpTable();
        if (!"".equals(hgTmpTableName)) {
            sql.append(" inner join ").append(hgTmpTableName).append(" tmp on tmp.hgId = HG.").append(this.hgFieldName).append("  \r\n");
        }
        sql.append(this.getSystemstausOrgFilter());
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid \r\n");
        sql.append(" inner join t_bd_period sp on sp.fid = ssc.fstartperiodid \r\n");
        if (this.getRptCondition().isAfterCurrPeriod()) {
            sql.append(" inner join t_bd_period cp on cp.fid = ssc.fcurrentperiodid \r\n");
        }
        sql.append("where ss.fname = ").append(this.getSystemStatusName()).append(" and C.fisleaf = 1 and ").append(this.getVoucherOrgIdFilter1()).append(" \r\n");
        index = sp.size() + 1;
        index = this.getVoucherOrgIdFilterValue(sp, Integer.valueOf(index + "999"));
        if (this.getRptCondition().isAfterCurrPeriod()) {
            int startPeriod;
            int endPeriod = startPeriod = pYear * 100 + pNumber;
            sql.append(" and gl.fperiod <= ? and (gl.fperiod >= ? or gl.fperiod >= cp.fnumber) \r\n");
            sp.setInt(index++, endPeriod);
            sp.setInt(index++, startPeriod);
        } else {
            sql.append(" and gl.fperiod = ? \r\n");
            sp.setInt(index++, pYear * 100 + pNumber);
        }
        sql.append(" and c.flongnumber like '").append(this.accountView.getLongNumber()).append("%' \r\n");
        sql.append(" and c.FAccountTableID = '").append(this.accountTableID).append("' \r\n");
        sql.append("\n and GL.FCurrencyID in(");
        for (int i = 0; i < this.currencySize; ++i) {
            sql.append("?,");
            sp.setString(index++, this.currencys.get(i).getId().toString());
        }
        this.delLastChar(sql);
        sql.append(") \r\n");
        this.fiterHg(sql, sp, "C");
        if (this.getRptCondition().isAfterCurrPeriod()) {
            sql.append(" group by c.FID, avt.fproperty, C.FDC, ");
            sql.append("HG.").append(this.hgFieldName).append(",GL.FCurrencyId, GL.fassistgrpid ");
            sql.append(") ab left outer join ( \r\n");
            this.joinPLVoucherSql(sql, sp, rs);
            sql.append(") plV on plV.accountid = ab.fid and plV.currencyid = ab.fcurrencyid and ab.fassistgrpid = plv.hgid \r\n");
            if (this.fetchDataType != 0) {
                sql.append("left outer join ( \r\n");
                this.joinPsAmoutSql(sql, sp, rs);
                sql.append(") ps on ps.faccountid = ab.fid and ps.fcurrencyid = ab.fcurrencyid and ab.fassistgrpid = ps.hgid \r\n");
            }
        }
    }

    protected void joinPLVoucherSql(StringBuffer sql, SqlParams sp, IRowSet rs) throws SQLException, BOSException {
        String periodId = rs.getString("fperiodid");
        int pYear = rs.getInt("fperiodyear");
        int pNumber = rs.getInt("fperiodNumber");
        int index = sp.size() + 1;
        sql.append("select plav.fid accountid, ve.fcurrencyid currencyid, hg.fid hgid, \r\n");
        sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(1).append(" then va.FOriginalAmount else 0 end) debitfor, \r\n");
        sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(0).append(" then va.FOriginalAmount else 0 end) creditfor, \r\n");
        sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(1).append(" then va.FLocalAmount else 0 end) debitlocal, \r\n");
        sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(0).append(" then va.FLocalAmount else 0 end) creditlocal, \r\n");
        sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(1).append(" then va.FOriginalAmount else 0 end) ydebitfor, \r\n");
        sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(0).append(" then va.FOriginalAmount else 0 end) ycreditfor, \r\n");
        sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(1).append(" then va.FLocalAmount else 0 end) ydebitlocal, \r\n");
        sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(0).append(" then va.FLocalAmount else 0 end) ycreditlocal, \r\n");
        sql.append(" sum(case when ve.FEntryDC = ").append(1).append(" then va.FOriginalAmount else 0 end) sumdebitfor, \r\n");
        sql.append(" sum(case when ve.FEntryDC = ").append(0).append(" then va.FOriginalAmount else 0 end) sumcreditfor, \r\n");
        sql.append(" sum(case when ve.FEntryDC = ").append(1).append(" then va.FLocalAmount else 0 end) sumdebitlocal, \r\n");
        sql.append(" sum(case when ve.FEntryDC = ").append(0).append(" then va.FLocalAmount else 0 end) sumcreditlocal \r\n");
        sql.append(", sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(1).append(" then va.fstandardquantity else 0 end) debitQty, \r\n");
        sql.append(" sum(case when pd.fid = '").append(periodId).append("' and ve.FEntryDC = ").append(0).append(" then va.fstandardquantity else 0 end) creditQty, \r\n");
        sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(1).append(" then va.fstandardquantity else 0 end) ydebitQty, \r\n");
        sql.append(" sum(case when pd.fperiodyear = ypd.fperiodyear and ve.FEntryDC = ").append(0).append(" then va.fstandardquantity else 0 end) ycreditQty, \r\n");
        sql.append(" sum(case when ve.FEntryDC = ").append(1).append(" then va.fstandardquantity else 0 end) sumdebitQty, \r\n");
        sql.append(" sum(case when ve.FEntryDC = ").append(0).append(" then va.fstandardquantity else 0 end) sumcreditQty \r\n");
        sql.append("from ").append(this.getVoucherTableName()).append(" v \r\n");
        sql.append("inner join ").append(this.getVoucherEntryTableName()).append(" ve on ve.fbillid = v.fid \r\n");
        sql.append("inner join t_bd_accountview plav on plav.fid = ve.faccountid and plav.fisleaf = 1 \r\n");
        sql.append("INNER JOIN ").append(this.getVoucherAssRedTableName()).append(" VA ON v.FID = VA.FBillID and ve.FID = VA.FEntryID ").append("INNER JOIN  T_BD_AssistantHg HG ON VA.FAssGrpID = HG.FID ");
        sql.append("inner join t_bd_period pd on pd.fid = v.fperiodid \r\n");
        sql.append("inner join t_bd_period ypd on pd.fnumber <= ypd.fnumber \r\n");
        String hgTmpTableName = this.insertHgIdToTmpTable();
        if (!"".equals(hgTmpTableName)) {
            sql.append(" inner join ").append(hgTmpTableName).append(" tmp on tmp.hgId = HG.").append(this.hgFieldName).append("  \r\n");
        }
        sql.append("where v.fbizstatus in ").append(this.balTypes).append(" \r\n");
        sql.append(" and ypd.fid = ? \r\n");
        sql.append("and v.fsourcetype = 1 and ").append(this.getVoucherOrgIdFilter()).append(" and pd.ftypeid = ? \r\n");
        sp.setString(index++, periodId);
        index = this.getVoucherOrgIdFilterValue(sp, index);
        sp.setString(index++, this.periodType);
        sql.append(" and pd.fnumber >= ?").append(" and pd.fnumber <= ?");
        sp.setInt(index++, this.getRptCondition().getPeriodYearStart() * 100 + 1);
        sp.setInt(index++, pYear * 100 + pNumber);
        sql.append(" and plav.flongnumber like '").append(this.accountView.getLongNumber()).append("%' \r\n");
        sql.append(" and plav.FAccountTableID = '").append(this.accountTableID).append("' \r\n");
        sql.append("\n and ve.FCurrencyID in(");
        for (int i = 0; i < this.currencySize; ++i) {
            sql.append("?,");
            sp.setString(index++, this.currencys.get(i).getId().toString());
        }
        this.delLastChar(sql);
        sql.append(") \r\n");
        this.fiterHg(sql, sp, "plav");
        sql.append("group by plav.fid, ve.fcurrencyid, hg.fid \r\n");
    }

    protected void joinPsAmoutSql(StringBuffer sql, SqlParams sp, IRowSet rs) throws SQLException, BOSException {
        int pYear = rs.getInt("fperiodyear");
        int pNumber = rs.getInt("fperiodNumber");
        int index = sp.size() + 1;
        sql.append("select gl.faccountid,GL.FCurrencyId, hg.fid hgid, \r\n");
        sql.append("sum(GL.FCreditFor) FCreditFor,sum(GL.FDebitFor) FDebitFor, \r\n");
        sql.append("sum(GL.FCreditLocal) FCreditLocal,sum(GL.FDebitLocal) FDebitLocal, \r\n");
        sql.append("sum(GL.FCreditQty) FCreditQty,sum(GL.FDebitQty) FDebitQty \r\n");
        sql.append("from ").append(this.getAsstBalanceTableName()).append(" GL \r\n");
        sql.append("inner join t_bd_accountview av on av.fid = gl.faccountid  \r\n");
        sql.append("inner join T_BD_AssistantHg HG ON GL.fassistgrpid = HG.FID \r\n");
        String hgTmpTableName = this.insertHgIdToTmpTable();
        if (!"".equals(hgTmpTableName)) {
            sql.append(" inner join ").append(hgTmpTableName).append(" tmp on tmp.hgId = HG.").append(this.hgFieldName).append("  \r\n");
        }
        sql.append("where ").append(this.getVoucherOrgIdFilter1()).append(" \r\n");
        index = this.getVoucherOrgIdFilterValue(sp, Integer.valueOf(index + "999"));
        sql.append(" and gl.fperiod in " + SQLUtil.buildPeriodNumbersInSql(this.getRptCondition().getPeriodYearStart(), this.getRptCondition().getPeriodNumberStart(), pYear, pNumber));
        sql.append(" and av.flongnumber like '").append(this.accountView.getLongNumber()).append("%'");
        sql.append(" and av.FAccountTableID = '").append(this.accountTableID).append("' \r\n");
        sql.append("\n and gl.FCurrencyID in(");
        for (int i = 0; i < this.currencySize; ++i) {
            sql.append("?,");
            sp.setString(index++, this.currencys.get(i).getId().toString());
        }
        this.delLastChar(sql);
        sql.append(") \r\n");
        this.fiterHg(sql, sp, "av");
        sql.append("group by gl.faccountid, gl.fcurrencyid, hg.fid \r\n");
    }

    @Override
    protected boolean checkColItem(IRowSet rowSet, int mu) throws SQLException {
        ArrayList sonIds;
        boolean isChecked = false;
        String hAsstItemId = ((LabelValueBean)this.itemList.get(mu)).getValue();
        String lasstItemId = rowSet.getString("asstItemId");
        if (lasstItemId.equals(hAsstItemId)) {
            isChecked = true;
        } else if (this.actChild != null && this.actChild.get(hAsstItemId) != null && (sonIds = (ArrayList)this.actChild.get(hAsstItemId)).contains(lasstItemId)) {
            isChecked = true;
        }
        return isChecked;
    }

    @Override
    protected boolean checkColItem_absolute(IRowSet rowSet, int mu) throws SQLException {
        boolean isChecked = false;
        String hAsstItemId = ((LabelValueBean)this.itemList.get(mu)).getValue();
        String lasstItemId = rowSet.getString("asstItemId");
        if (lasstItemId.equals(hAsstItemId)) {
            isChecked = true;
        }
        return isChecked;
    }

    @Override
    protected void createInitColHideMapByVchSql(StringBuffer sql) {
        sql.append("select distinct asstItemId, FCurrencyID ");
        sql.append(" from ").append(this.entryTempTable).append(" where \r\n");
        sql.append(" fsourcetype <> 1 ");
        if (this.fetchDataType == 1) {
            sql.append(" and ActDC = ").append(1);
        } else if (this.fetchDataType != 0) {
            sql.append(" and ActDC = ").append(0);
        }
    }

    @Override
    protected String getQuerySql(GLRptID[] ids) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        if (this.fetchstartBalanceFlag) {
            if (this.fetchstartColumnAmtFlag) {
                sql.append("select t.FSourceType, t.ActDC, 0 fperiodid, vch.FCurrencyID,vch.asstitemid, 1 FCoefficient,N'' muname");
                sql.append(", sum(IsNull(vch.FOriginalAmount, 0)) FOriginalAmount ");
                sql.append(", sum(IsNull(case when t.fperiodYear = ? then vch.FOriginalAmount else 0 end, 0)) FYearOMT");
                sql.append(", sum(IsNull(case when t.fperiodYear = ? and t.fperiodNumber = ? then vch.FOriginalAmount else 0 end, 0)) FPeriodOMT");
                sql.append(", sum(IsNull(vch.FLocalAmount, 0)) FLocalAmount ");
                sql.append(", sum(IsNull(case when t.fperiodYear = ? then vch.FLocalAmount else 0 end, 0)) FYearLMT");
                sql.append(", sum(IsNull(case when t.fperiodYear = ? and t.fperiodNumber = ? then vch.FLocalAmount else 0 end, 0)) FPeriodLMT");
            } else {
                sql.append("select sum(IsNull(vch.FOriginalAmount, 0)) FOriginalAmount, sum(IsNull(vch.FLocalAmount, 0)) FLocalAmount ");
                sql.append(",sum(IsNull(case when t.fperiodYear = ? and t.actdc = 1 then vch.FOriginalAmount else 0 end, 0)) FYearDetOMT");
                sql.append(",sum(IsNull(case when t.fperiodYear = ? and t.fperiodNumber = ? and t.actdc = 1 then vch.FOriginalAmount else 0 end, 0)) FPeriodDetOMT");
                sql.append(",sum(IsNull(case when t.fperiodYear = ? and t.fperiodNumber = ? and t.actdc <> 1  then vch.FOriginalAmount else 0 end, 0)) FPeriodCetOMT");
                sql.append(",sum(IsNull(case when t.fperiodYear = ? and t.actdc <> 1  then vch.FOriginalAmount else 0 end, 0)) FYearCetOMT");
            }
        } else {
            sql.append(" select ").append(((GLRptQuery)query).getSelectSQL()).append(" ,t.FSourceType,t.no,t.ActDC,");
            sql.append("t.fperiodid, t.fperiodYear, t.fperiodNumber, vch.asstItemId, vch.FCurrencyID, vch.voucherId,");
            sql.append("IsNull(vch.FOriginalAmount, 0) FOriginalAmount,IsNull(vch.FLocalAmount, 0) FLocalAmount");
        }
        if (this.displayAmount) {
            if (this.fetchstartBalanceFlag) {
                if (this.fetchstartColumnAmtFlag) {
                    sql.append(", sum(IsNull(vch.fquantity, 0)) fquantity, sum(IsNull(vch.FStandardQuantity, 0)) FStandardQuantity");
                    sql.append(", sum(IsNull(case when t.fperiodYear = ? then vch.fquantity else 0 end, 0)) FYearQTY");
                    sql.append(", sum(IsNull(case when t.fperiodYear = ? and t.fperiodNumber = ? then vch.fquantity else 0 end, 0)) FPeriodQTY");
                    sql.append(", sum(IsNull(case when t.fperiodYear = ? then vch.FStandardQuantity else 0 end, 0)) FYearStQTY");
                    sql.append(", sum(IsNull(case when t.fperiodYear = ? and t.fperiodNumber = ? then vch.FStandardQuantity else 0 end, 0)) FPeriodStQTY");
                } else {
                    sql.append(", sum(IsNull(vch.fquantity, 0)) fquantity, sum(IsNull(vch.FStandardQuantity, 0)) FStandardQuantity \n");
                    sql.append(",sum(IsNull(case when t.fperiodYear = ?  and t.actdc = 1 then vch.fquantity else 0 end, 0)) FYearDetQTY");
                    sql.append(",sum(IsNull(case when t.fperiodYear = ? and t.fperiodNumber = ? and t.actdc = 1 then vch.fquantity else 0 end, 0)) FPeriodDetQTY");
                    sql.append(",sum(IsNull(case when t.fperiodYear = ?  and t.actdc <> 1 then vch.fquantity else 0 end, 0)) FYearCetQTY");
                    sql.append(",sum(IsNull(case when t.fperiodYear = ? and t.fperiodNumber = ? and t.actdc <> 1 then vch.fquantity else 0 end, 0)) FPeriodCetQTY");
                }
            } else {
                sql.append(", vch.muname");
                sql.append(", IsNull(vch.fquantity, 0) fquantity, IsNull(vch.FStandardQuantity, 0) FStandardQuantity, \n");
                sql.append("IsNull(vch.fprice, 0) fprice, IsNull(vch.FCoefficient, 0) FCoefficient \n");
            }
        }
        sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t \r\n");
        sql.append(" inner join ").append(this.dao.getIdListTempTable()).append(" p on t.KSQL_SEQ = p.SQL_SEQ and t.SQL_BATCH = p.SQL_BATCH \r\n");
        sql.append(" left outer join ").append(this.entryTempTable);
        sql.append(" vch on t.voucherid = vch.voucherId and t.actdc = vch.actdc ");
        if (!this.getIsDisplayOneLineBiz()) {
            sql.append(" and t.fseq = vch.fseq and t.fentryid = vch.fentryid ");
        }
        if (this.displayAmount) {
            sql.append(" and isnull(t.muname, 'mname') = isnull(vch.muname, 'mname') \r\n");
        }
        if (ids != null && ids.length > 0) {
            sql.append(" where ").append(this.glRptIDs2StrId(ids, "t"));
        }
        if (this.fetchstartBalanceFlag) {
            sql.append(" where p.KSQL_SEQ < ? ");
            if (this.fetchstartColumnAmtFlag) {
                sql.append(" group by t.FSourceType, t.ActDC,vch.FCurrencyID,vch.asstitemid ");
            }
        } else {
            sql.append("order by p.ksql_seq ");
        }
        return sql.toString();
    }

    @Override
    protected void dealRowToMap(IRowSet rs, Map<String, BigDecimal> mulColMap) throws SQLException {
        String prefix = rs.getString("asstItemId") + "_" + rs.getString("FCurrencyID") + "_" + rs.getString("actDC");
        mulColMap.put(prefix + "_for", rs.getBigDecimal("FOriginalAmount"));
        mulColMap.put(prefix + "_loc", rs.getBigDecimal("FLocalAmount"));
        if (this.displayAmount) {
            mulColMap.put(prefix + "_qty", this.isQtyAsst ? rs.getBigDecimal("FStandardQuantity") : rs.getBigDecimal("FQuantity"));
        }
        prefix = prefix + "_year";
        mulColMap.put(prefix + "_for", rs.getBigDecimal("FYearOMT"));
        mulColMap.put(prefix + "_loc", rs.getBigDecimal("FYearLMT"));
        if (this.displayAmount) {
            mulColMap.put(prefix + "_qty", this.isQtyAsst ? rs.getBigDecimal("FYearStQTY") : rs.getBigDecimal("FYearQTY"));
        }
        prefix = prefix + "_period";
        mulColMap.put(prefix + "_for", rs.getBigDecimal("FPeriodOMT"));
        mulColMap.put(prefix + "_loc", rs.getBigDecimal("FPeriodLMT"));
        if (this.displayAmount) {
            mulColMap.put(prefix + "_qty", this.isQtyAsst ? rs.getBigDecimal("FPeriodStQTY") : rs.getBigDecimal("FPeriodQTY"));
        }
    }

    @Override
    protected void dealMulColSumToMap(Map<String, BigDecimal> mulColMap) {
        HashMap<String, BigDecimal> accountViewDcSumMap = new HashMap<String, BigDecimal>();
        String cColName = "Credit";
        String dColName = "Debit";
        for (int i = 0; i < this.currencySize; ++i) {
            String currencyId = this.currencys.get(i).getId().toString();
            for (Map.Entry<String, BigDecimal> entry : mulColMap.entrySet()) {
                String[] keys = entry.getKey().split("_");
                String curId = keys[1];
                String dc = keys[2];
                if (!currencyId.equals(curId)) continue;
                StringBuilder key = new StringBuilder();
                if ("1".equals(dc)) {
                    key.append(dColName);
                } else {
                    if (!"0".equals(dc)) continue;
                    key.append(cColName);
                }
                key.append("_").append(currencyId);
                for (int j = 3; j < keys.length; ++j) {
                    key.append("_").append(keys[j]);
                }
                BigDecimal sum = (BigDecimal)accountViewDcSumMap.get(key.toString());
                if (sum == null) {
                    sum = GlUtils.zero;
                }
                accountViewDcSumMap.put(key.toString(), sum.add(entry.getValue()));
            }
        }
        HashMap<String, BigDecimal> tempMulColMap = new HashMap<String, BigDecimal>(mulColMap);
        for (Map.Entry entry : tempMulColMap.entrySet()) {
            String[] keys = ((String)entry.getKey()).split("_");
            String dc = keys[2];
            if (!"0".equals(dc)) continue;
            StringBuilder key = new StringBuilder(keys[0] + "_" + keys[1] + "_1");
            for (int i = 3; i < keys.length; ++i) {
                key.append("_").append(keys[i]);
            }
            if (mulColMap.containsKey(key.toString())) {
                BigDecimal debitAmt = mulColMap.get(key.toString());
                mulColMap.put(key.toString(), debitAmt.subtract((BigDecimal)entry.getValue()));
                mulColMap.remove(entry.getKey());
                continue;
            }
            BigDecimal creditAmt = mulColMap.get(entry.getKey());
            mulColMap.remove(entry.getKey());
            mulColMap.put(key.toString(), creditAmt.negate());
        }
        mulColMap.putAll(accountViewDcSumMap);
    }

    @Override
    protected String getQueryBalSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("select IsNull(sum((2 * t.actDc - 1) * IsNull(vch.FOriginalAmount, 0)), 0) FOriginalAmount");
        sql.append(",IsNull(sum((2 * t.actDc - 1) * IsNull(vch.FLocalAmount, 0)), 0) FLocalAmount");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.actDC = 1 then vch.FLocalAmount else 0 end, 0)), 0) FYearDetLMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? and t.actDC = 1 then vch.FLocalAmount else 0 end, 0)), 0) FPeriodDetLMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.actDC <> 1  then vch.FLocalAmount else 0 end, 0)), 0) FYearCetLMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? and t.actDC <> 1  then vch.FLocalAmount else 0 end, 0)), 0) FPeriodCetLMT");
        if (this.displayAmount) {
            sql.append(",IsNull(sum((2 * t.actDc - 1) * IsNull(vch.FQuantity, 0)), 0) FQuantity");
            sql.append(",IsNull(sum((2 * t.actDc - 1) * IsNull(vch.FStandardQuantity, 0)), 0) FStandardQuantity");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.actDC = 1 then vch.FQuantity else 0 end, 0)), 0) FYearDetQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? and t.actDC = 1 then vch.FQuantity else 0 end, 0)), 0) FPeriodDetQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.actDC <> 1 then vch.FQuantity else 0 end, 0)), 0) FYearCetQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? and t.actDC <> 1 then vch.FQuantity else 0 end, 0)), 0) FPeriodCetQTY");
        }
        sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t \n");
        sql.append(" inner join ").append(this.dao.getIdListTempTable()).append(" p on t.KSQL_SEQ = p.SQL_SEQ and t.SQL_BATCH = p.SQL_BATCH \r\n");
        sql.append(" left outer join ").append(this.entryTempTable);
        sql.append(" vch on t.voucherId = vch.voucherId and t.actDC = vch.actDC ");
        if (!this.getIsDisplayOneLineBiz()) {
            sql.append(" and t.FSeq = vch.FSeq and t.FEntryId = vch.FEntryId ");
        }
        if (this.displayAmount) {
            sql.append(" and isnull(t.muName, 'mname') = isnull(vch.muName, 'mname') \r\n");
        }
        sql.append(" where p.KSQL_SEQ < ? ");
        return sql.toString();
    }

    @Override
    protected String getQueryColSumSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("select t.actDC ActDC, 0 FPeriodId, vch.FCurrencyID, vch.asstItemId, 1 FCoefficient, N'' muName");
        sql.append(",IsNull(sum(IsNull(vch.FOriginalAmount, 0)), 0) FOriginalAmount ");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? then vch.FOriginalAmount else 0 end, 0)), 0) FYearOMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? then vch.FOriginalAmount else 0 end, 0)), 0) FPeriodOMT");
        sql.append(",IsNull(sum(IsNull(vch.FLocalAmount, 0)), 0) FLocalAmount ");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? then vch.FLocalAmount else 0 end, 0)), 0) FYearLMT");
        sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? then vch.FLocalAmount else 0 end, 0)), 0) FPeriodLMT");
        if (this.displayAmount) {
            sql.append(",IsNull(sum(IsNull(vch.FQuantity, 0)), 0) FQuantity");
            sql.append(",IsNull(sum(IsNull(vch.FStandardQuantity, 0)), 0) FStandardQuantity");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? then vch.FQuantity else 0 end, 0)), 0) FYearQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? then vch.FQuantity else 0 end, 0)), 0) FPeriodQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? then vch.FStandardQuantity else 0 end, 0)), 0) FYearStQTY");
            sql.append(",IsNull(sum(IsNull(case when t.FPeriodYear = ? and t.FPeriodNumber = ? then vch.FStandardQuantity else 0 end, 0)), 0) FPeriodStQTY");
        }
        sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t \r\n");
        sql.append(" inner join ").append(this.dao.getIdListTempTable()).append(" p on t.KSQL_SEQ = p.SQL_SEQ and t.SQL_BATCH = p.SQL_BATCH \r\n");
        sql.append(" left outer join ").append(this.entryTempTable);
        sql.append(" vch on t.voucherId = vch.voucherId and t.actDC = vch.actDC ");
        if (!this.getIsDisplayOneLineBiz()) {
            sql.append(" and t.FSeq = vch.FSeq and t.FEntryId = vch.FEntryId ");
        }
        if (this.displayAmount) {
            sql.append(" and isnull(t.muName, 'mname') = isnull(vch.muName, 'mname') \r\n");
        }
        sql.append(" where p.KSQL_SEQ < ? ");
        sql.append(" group by t.actDC, vch.FCurrencyID, vch.asstItemId");
        return sql.toString();
    }

    @Override
    protected String getQuerySql(GLRptID[] ids, String orderSql) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        sql.append(" select ").append(((GLRptQuery)query).getSelectSQL()).append(" ,t.FSourceType,t.no,t.ActDC,");
        sql.append("t.fperiodid, t.fperiodYear, t.fperiodNumber, vch.asstItemId, vch.FCurrencyID, vch.voucherId,");
        sql.append("IsNull(vch.FOriginalAmount, 0) FOriginalAmount,IsNull(vch.FLocalAmount, 0) FLocalAmount");
        if (this.displayAmount) {
            sql.append(", vch.muname");
            sql.append(", IsNull(vch.fquantity, 0) fquantity, IsNull(vch.FStandardQuantity, 0) FStandardQuantity, \n");
            sql.append("IsNull(vch.fprice, 0) fprice, IsNull(vch.FCoefficient, 0) FCoefficient \n");
        }
        sql.append(" from ").append(this.dao.getDataSourceTableName()).append(" t \r\n");
        sql.append(" inner join ").append(this.dao.getIdListTempTable()).append(" p on t.KSQL_SEQ = p.SQL_SEQ and t.SQL_BATCH = p.SQL_BATCH \r\n");
        sql.append(" left outer join ").append(this.entryTempTable);
        sql.append(" vch on t.voucherid = vch.voucherId and t.actdc = vch.actdc ");
        if (!this.getIsDisplayOneLineBiz()) {
            sql.append(" and t.fseq = vch.fseq and t.fentryid = vch.fentryid ");
        }
        if (this.displayAmount) {
            sql.append(" and isnull(t.muname, 'mname') = isnull(vch.muname, 'mname') \r\n");
        }
        if (ids != null && ids.length > 0) {
            sql.append(" where ").append(this.glRptIDs2StrId(ids, "t"));
        }
        sql.append(orderSql);
        return sql.toString();
    }

    @Override
    protected void dealVchBalance(int seq, int batch, String periodid, String vchId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        int index = 1;
        sql.append("select isnull(sum(case when vch.ActDC = ");
        sql.append(1).append(" then vch.FLocalAmount else 0 end), 0) debitLocal, \r\n");
        sql.append("isnull(sum(case when vch.ActDC = ");
        sql.append(0).append(" then vch.FLocalAmount else 0 end), 0) creditLocal \r\n");
        if (this.displayAmount) {
            sql.append(", isnull(sum(case when vch.ActDC = ");
            sql.append(1).append(" then vch.fquantity else 0 end), 0) debitQty, \r\n");
            sql.append("isnull(sum(case when vch.ActDC = ");
            sql.append(0).append(" then vch.fquantity else 0 end), 0) creditQty \r\n");
        }
        sql.append("from ").append(this.dao.getDataSourceTableName()).append(" ds \r\n");
        sql.append("inner join ").append(this.dao.getIdListTempTable()).append(" ids on ds.KSQL_SEQ = ids.SQL_SEQ and ds.SQL_BATCH = ids.SQL_BATCH \r\n");
        sql.append(" left outer join ").append(this.entryTempTable);
        sql.append(" vch on ds.voucherid = vch.voucherId and ds.actdc = vch.actdc ");
        if (!this.getIsDisplayOneLineBiz()) {
            sql.append(" and ds.fseq = vch.fseq and ds.fentryid = vch.fentryid ");
        }
        sql.append("where ds.fperiodid = ? \r\n");
        index = sp.size() + 1;
        sp.setString(index++, periodid);
        sql.append("and ids.ksql_seq < ( \r\n");
        sql.append("select ksql_seq from ").append(this.dao.getIdListTempTable()).append(" \r\n");
        sql.append("where SQL_SEQ = ? and SQL_BATCH = ?) \r\n");
        sp.setInt(index++, seq);
        sp.setInt(index++, batch);
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sp.getParams());
            while (rowSet.next()) {
                BigDecimal debit = rowSet.getBigDecimal("debitLocal");
                BigDecimal credit = rowSet.getBigDecimal("creditLocal");
                this.balances[1] = this.balances[1].add(debit).subtract(credit);
                if (!this.displayAmount) continue;
                BigDecimal debitQty = rowSet.getBigDecimal("debitQty");
                BigDecimal creditQty = rowSet.getBigDecimal("creditQty");
                this.balances[0] = this.balances[0].add(debitQty).subtract(creditQty);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
    }

    @Override
    protected void getDetailMeasure(AbstractGLRptMulColAbsDao.VoucherLineData lineData, IRowSet rs) {
        String muName = null;
        boolean isDspStd = false;
        muName = lineData.getMeasureUnitName();
        if (muName == null || "".equals(muName.trim())) {
            muName = this.baseMuName;
            isDspStd = true;
        }
        lineData.setDetailDspStandard(isDspStd);
        lineData.setDetailDspMu(muName);
    }

    @Override
    protected String getUniqueMeasureUnitName() {
        return this.baseMuName;
    }

    protected Object[][] initAndSortColData(List dclist) {
        Object[][] dcColumns = new Object[dclist.size()][1];
        int n = dcColumns.length;
        for (int i = 0; i < n; ++i) {
            dcColumns[n - i - 1][0] = ((LabelValueBean)dclist.get(i)).getLabel();
        }
        return dcColumns;
    }

    @Override
    protected String getUniqueMeasureUnitName4Item(int itemIndex) {
        return this.getUniqueMeasureUnitName();
    }
}

