/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGGCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPLVoucherAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GLRptNotPLBalanceQuery
extends GLRptQuery {
    private boolean isAmountFiler = true;
    protected static Map<GLRptField, GLRptField> fm = new HashMap<GLRptField, GLRptField>();
    private GLRptBalQuery balanceQuery;
    private GLRptQuery voucherQuery;

    public GLRptNotPLBalanceQuery(Context ctx, GLRptBaseCondition cond, GLRptBalQuery balanceQuery, GLRptQuery voucherQuery) {
        super(ctx, cond);
        this.isAmountFiler = balanceQuery.getAmountFilter() != null;
        balanceQuery.setAmountFilter(null);
        this.balanceQuery = balanceQuery;
        this.voucherQuery = voucherQuery;
    }

    @Override
    protected String getSelectSQL() throws EASBizException, BOSException {
        if (this.getSelector() == null || this.getSelector().isEmpty()) {
            throw new BOSException("The query selector is temp!");
        }
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getType() == "NUMERIC(29,10)" || "fdetailcount".equalsIgnoreCase(field.getName())) {
                sql.append(this.getAmountSelectSQL(field));
                continue;
            }
            this.appendSelectField(sql, field);
        }
        return sql.toString();
    }

    protected void appendSelectField(StringBuffer sql, GLRptField field) {
        sql.append("b.").append(field.getName()).append(" ").append(field.getName());
    }

    protected String getAmountSelectSQL(GLRptField field) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String vf = null;
        if (field.isDebit()) {
            vf = "isnull(pl.FSubDebit" + field.getSuffix() + ",0)";
        } else if (field.isYearDebit()) {
            if (this.getCond() instanceof GLRptAsstActTypeBalanceCondition) {
                vf = this.getCond().getPeriodNumberStart() != 1 || this.getCond().getPeriodYearStart() != this.getCond().getPeriodYearEnd() ? "isnull(plYear.FSubDebit" + field.getSuffix() + ",0)" : "isnull(pl.FSubDebit" + field.getSuffix() + ",0)";
            } else {
                vf = "isnull(pl.FSubDebit" + field.getSuffix() + ",0)";
                if (this.getCond() instanceof GLRptAsstactGGCondition && (this.getCond().getPeriodNumberStart() != 1 || this.getCond().getPeriodYearStart() != this.getCond().getPeriodYearEnd())) {
                    vf = vf + " - isnull(plYear.FSubDebit" + field.getSuffix() + ",0)";
                }
            }
        } else if (field.isCredit()) {
            vf = "isnull(pl.FSubCredit" + field.getSuffix() + ",0)";
        } else if (field.isYearCredit()) {
            if (this.getCond() instanceof GLRptAsstActTypeBalanceCondition) {
                vf = this.getCond().getPeriodNumberStart() != 1 || this.getCond().getPeriodYearStart() != this.getCond().getPeriodYearEnd() ? "isnull(plYear.FSubCredit" + field.getSuffix() + ",0)" : "isnull(pl.FSubCredit" + field.getSuffix() + ",0)";
            } else {
                vf = "isnull(pl.FSubCredit" + field.getSuffix() + ",0)";
                if (this.getCond() instanceof GLRptAsstactGGCondition && (this.getCond().getPeriodNumberStart() != 1 || this.getCond().getPeriodYearStart() != this.getCond().getPeriodYearEnd())) {
                    vf = vf + " - isnull(plYear.FSubCredit" + field.getSuffix() + ",0)";
                }
            }
        } else if (field.isEnd()) {
            vf = "(isnull(pl.FSubDebit" + field.getSuffix() + ",0) - isnull(pl.FSubCredit" + field.getSuffix() + ",0))";
        }
        if (vf == null) {
            sql.append("b.").append(field.getName()).append(" ").append(field.getName());
        } else {
            sql.append("b.").append(field.getName()).append(" - ").append(vf).append(" ").append(field.getName());
        }
        return sql.toString();
    }

    @Override
    protected String getFromSQL() throws BOSException, EASBizException {
        GLRptBalQuery query = this.getBalanceQuery();
        query.setIncluePLVoucher(true);
        return "(" + query.getSQL() + ") b";
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        GLRptQuery query = this.getJoinPLVoucherQuery();
        sql.append(" left outer join (").append(query.getSQL()).append(") pl ");
        sql.append(" on ");
        StringBuffer joinCond = new StringBuffer();
        Iterator<GLRptField> it = this.balanceQuery.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField f = it.next();
            GLRptField field = fm.get(f);
            if (field == null && (!f.isTempTableField() || !f.getSelect().startsWith("hg.F") && !f.getSelect().startsWith("hg.CF") && !f.getName().endsWith("GroupID")) || "NUMERIC(29,10)".equals(f.getType())) continue;
            if (joinCond.length() > 0) {
                joinCond.append(" and ");
            }
            joinCond.append(" b.").append(f.getName()).append(" = pl.").append(field == null ? f.getName() : field.getName());
        }
        sql.append(joinCond);
        return sql.toString();
    }

    @Override
    protected String getJoinPLYearSQL() throws BOSException, EASBizException {
        GLRptField field;
        StringBuffer sql = new StringBuffer();
        GLRptQuery query = this.getJoinPLVoucherQuery();
        GLRptSelector selector = query.getSelector();
        GLRptSelector newSelector = new GLRptSelector();
        Iterator<GLRptField> it = query.getSelector().iterator();
        while (it.hasNext()) {
            field = it.next();
            if (GLRptField.period.getName().equals(field.getName())) continue;
            newSelector.add(field);
        }
        query.setSelector(newSelector);
        if (query instanceof GLRptPLVoucherAsstactBalQuery) {
            ((GLRptPLVoucherAsstactBalQuery)query).setPLYear(true);
            sql.append(" left outer join (").append(query.getSQL()).append(") plYear");
            ((GLRptPLVoucherAsstactBalQuery)query).setPLYear(false);
        } else {
            sql.append(" left outer join (").append(query.getSQL()).append(") plYear");
        }
        query.setSelector(selector);
        sql.append(" on");
        StringBuffer joinCond = new StringBuffer();
        joinCond.append(" 1 = 1");
        it = this.balanceQuery.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField f = it.next();
            if (GLRptField.period.getName().equals(f.getName()) || (field = fm.get(f)) == null && (!f.isTempTableField() || !f.getSelect().startsWith("hg.F") && !f.getSelect().startsWith("hg.CF") && !f.getName().endsWith("GroupID")) || "NUMERIC(29,10)".equals(f.getType())) continue;
            if (joinCond.length() > 0) {
                joinCond.append(" and ");
            }
            joinCond.append(" b.").append(f.getName()).append(" = plYear.").append(field == null ? f.getName() : field.getName());
        }
        sql.append(joinCond);
        return sql.toString();
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        if (!this.isAmountFiler) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        if (this.getCond().isOptionAmountAndBalZero()) {
            sql.append(" (");
            this.setAmountAndBalZeroFilter(sql);
            sql.append(") ");
        } else if (this.getCond().isOptionBalanceZero()) {
            sql.append(" (");
            this.setBalanceZeroFilter(sql);
            sql.append(") ");
        } else if (this.getCond().isOptionAmountZero()) {
            if (this.getCond().isOptionBalanceZero()) {
                sql.append(" and (");
            } else {
                sql.append(" (");
            }
            this.setAmountZeroFilter(sql);
            sql.append(") ");
        }
        return sql.toString();
    }

    private void setBalanceZeroFilter(StringBuffer sql) throws EASBizException, BOSException {
        GLRptBaseCondition cond = this.getCond();
        if (cond.isShowFor()) {
            sql.append("b.").append(GLRptField.endBalanceFor).append(" + isnull(pl.").append(GLRptVoucherField.asstRecordCreditFor).append(",0) - isnull(pl.").append(GLRptVoucherField.asstRecordDebitFor).append(",0) <> 0 ");
        }
        if (cond.isShowLocal()) {
            if (cond.isShowFor()) {
                sql.append(" or ");
            }
            sql.append("b.").append(GLRptField.endBalanceLocal).append(" + isnull(pl.").append(GLRptVoucherField.asstRecordCreditLocal).append(",0) - isnull(pl.").append(GLRptVoucherField.asstRecordDebitLocal).append(",0) <> 0 ");
        }
        if (cond.isShowRpt()) {
            if (cond.isShowFor() || cond.isShowLocal()) {
                sql.append(" or ");
            }
            sql.append("b.").append(GLRptField.endBalanceRpt).append(" + isnull(pl.").append(GLRptVoucherField.asstRecordCreditRpt).append(",0) - isnull(pl.").append(GLRptVoucherField.asstRecordDebitRpt).append(",0) <> 0 ");
        }
    }

    private void setAmountZeroFilter(StringBuffer sql) throws EASBizException, BOSException {
        GLRptBaseCondition cond = this.getCond();
        if (cond.isShowFor()) {
            sql.append("b.").append(GLRptField.debitFor).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordDebitFor).append(",0) <> 0 or ").append("b.").append(GLRptField.creditFor).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordCreditFor).append(",0) <> 0 ");
        }
        if (cond.isShowLocal()) {
            if (cond.isShowFor()) {
                sql.append(" or ");
            }
            sql.append("b.").append(GLRptField.debitLocal).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordDebitLocal).append(",0) <> 0 or ").append("b.").append(GLRptField.creditLocal).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordCreditLocal).append(",0) <> 0 ");
        }
        if (cond.isShowRpt()) {
            if (cond.isShowFor() || cond.isShowLocal()) {
                sql.append(" or ");
            }
            sql.append("b.").append(GLRptField.debitRpt).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordDebitRpt).append(",0) <> 0 or ").append("b.").append(GLRptField.creditRpt).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordCreditRpt).append(",0) <> 0 ");
        }
    }

    private void setAmountAndBalZeroFilter(StringBuffer sql) throws EASBizException, BOSException {
        GLRptBaseCondition cond = this.getCond();
        if (cond.isShowFor()) {
            sql.append("b.").append(GLRptField.endBalanceFor).append(" + isnull(pl.").append(GLRptVoucherField.asstRecordCreditFor).append(",0) - isnull(pl.").append(GLRptVoucherField.asstRecordDebitFor).append(",0) <> 0 or b.").append(GLRptField.debitFor).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordDebitFor).append(",0) <> 0 or b.").append(GLRptField.creditFor).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordCreditFor).append(",0) <> 0 ");
        }
        if (cond.isShowLocal()) {
            if (cond.isShowFor()) {
                sql.append(" or ");
            }
            sql.append("b.").append(GLRptField.endBalanceLocal).append(" + isnull(pl.").append(GLRptVoucherField.asstRecordCreditLocal).append(",0) - isnull(pl.").append(GLRptVoucherField.asstRecordDebitLocal).append(",0) <> 0 or b.").append(GLRptField.debitLocal).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordDebitLocal).append(",0) <> 0 or b.").append(GLRptField.creditLocal).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordCreditLocal).append(",0) <> 0 ");
        }
        if (cond.isShowRpt()) {
            if (cond.isShowFor() || cond.isShowLocal()) {
                sql.append(" or ");
            }
            sql.append("b.").append(GLRptField.endBalanceRpt).append(" + isnull(pl.").append(GLRptVoucherField.asstRecordCreditRpt).append(",0) - isnull(pl.").append(GLRptVoucherField.asstRecordDebitRpt).append(",0) <> 0 or b.").append(GLRptField.debitRpt).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordDebitRpt).append(",0) <> 0 or b.").append(GLRptField.creditRpt).append(" - isnull(pl.").append(GLRptVoucherField.asstRecordCreditRpt).append(",0) <> 0 ");
        }
        if (cond.isAmountZeroByVoucher()) {
            sql.append(" or b.fdetailcount > 0");
        }
    }

    protected GLRptQuery getJoinPLVoucherQuery() throws EASBizException, BOSException {
        return this.voucherQuery;
    }

    public GLRptBalQuery getBalanceQuery() {
        return this.balanceQuery;
    }

    public GLRptQuery getVoucherQuery() {
        return this.voucherQuery;
    }

    static {
        fm.put(GLRptField.orgUnitID, GLRptVoucherField.companyID);
        fm.put(GLRptField.accountID, GLRptVoucherField.accountID);
        fm.put(GLRptField.accountNumberMerger, GLRptVoucherField.accountNumberMerger);
        fm.put(GLRptField.accountNameMerger, GLRptVoucherField.accountNameMerger);
        fm.put(GLRptField.accountDisplayNameMerger, GLRptVoucherField.accountDisplayNameMerger);
        fm.put(GLRptField.currencyID, GLRptVoucherField.currencyID);
        fm.put(GLRptField.period, GLRptVoucherField.period);
        fm.put(new GLRptField("FProfitCenterID", "b.FProfitCenterID", "profitCenter.id", "VARCHAR(44)"), new GLRptField("FProfitCenterID", "voucher.FProfitCenterID", "profitCenter.id", "VARCHAR(44)"));
        fm.put(GLRptField.debitFor, GLRptVoucherField.asstRecordDebitFor);
        fm.put(GLRptField.creditFor, GLRptVoucherField.asstRecordCreditFor);
        fm.put(GLRptField.debitLocal, GLRptVoucherField.asstRecordDebitLocal);
        fm.put(GLRptField.creditLocal, GLRptVoucherField.asstRecordCreditLocal);
        fm.put(GLRptField.debitRpt, GLRptVoucherField.asstRecordDebitRpt);
        fm.put(GLRptField.creditRpt, GLRptVoucherField.asstRecordCreditRpt);
    }
}

