/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItemInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItems;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GLRptPageQuery
extends GLRptQuery {
    private String dataSourceTableName;
    private boolean isSeqTable;
    protected GLRptSumItems sumItems;
    protected List sp = new ArrayList();
    protected int from = -1;
    protected int to = -1;
    protected GLRptID[] ids;
    protected GLRptSumItemInfo sumItem;

    public GLRptPageQuery(Context ctx, GLRptBaseCondition cond) {
        super(ctx, cond);
    }

    public void setDataSourceTable(GLRptTempTableInfo dataSourceTable) {
        this.dataSourceTableName = dataSourceTable.getTableName();
        this.isSeqTable = dataSourceTable.isSeqTable();
        this.setMainTable(new GLRptDataTable(this.dataSourceTableName, "t"));
    }

    public void setKSQL_SEQ(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public void setID(GLRptID[] ids) {
        this.ids = (GLRptID[])ids.clone();
    }

    public void setSumItems(GLRptSumItems sumItems) {
        this.sumItems = sumItems;
    }

    public void setSumItem(GLRptSumItemInfo sumItem) {
        this.sumItem = sumItem;
        this.sp.clear();
    }

    @Override
    protected String getSelectSQL() throws BOSException, EASBizException {
        return this.sumItem == null ? this.getSelect() : this.getSumSelect();
    }

    protected String getSelect() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        this.appendRecordID(sql);
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            String sel;
            GLRptField field = it.next();
            if (field.getSelect() == null && !field.isTempTableField() || (sel = this.getSelect(field)) == null || sel.trim().length() <= 0) continue;
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append(sel);
        }
        sql.append(this.getSumItemSelect());
        return sql.toString();
    }

    protected void appendRecordID(StringBuffer sql) {
        if (this.isSeqTable) {
            sql.append("t.").append("KSQL_SEQ");
        } else {
            sql.append("t.").append("SQL_BATCH").append(",t.").append("KSQL_SEQ");
        }
    }

    protected String getSumSelect() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (this.isSeqTable) {
            sql.append("t2.").append("KSQL_SEQ");
        } else {
            sql.append("t2.").append("SQL_BATCH").append(",t2.").append("KSQL_SEQ");
        }
        for (GLRptField field : this.sumItem.getFields()) {
            if (field.getQueryField() != null) {
                sql.append(",t.").append(field.getName());
                continue;
            }
            sql.append(",").append(field.getSelect());
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale().toString());
            }
            sql.append(" ").append(field.getName());
        }
        Iterator<Object> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field;
            field = (GLRptField)it.next();
            if (field.getType() != "NUMERIC(29,10)") continue;
            if (this.getCond().isAllCurrency() && "For".equals(field.getSuffix()) && !this.sumItem.containsField(GLRptField.currencyID.getName())) {
                sql.append(", 0.0 ").append(field.getName());
                continue;
            }
            sql.append(",").append(this.getAmountSumSelect(field));
        }
        sql.append(", 1 ").append(this.sumItem.getName());
        sql.append(this.getSumItemSelectAdd());
        return sql.toString();
    }

    protected String getSumItemSelect() {
        if (this.sumItems == null) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        for (GLRptSumItemInfo item : this.sumItems.getSumItems()) {
            sql.append(",t.").append(item.getName());
        }
        return sql.toString();
    }

    protected String getAmountSumSelect(GLRptField field) {
        StringBuffer sql = new StringBuffer();
        if (this.sumItem.containsField(GLRptField.period.getName())) {
            sql.append("sum(t.").append(field.getName()).append(") ").append(field.getName());
        } else if (field.isBegin()) {
            int periodBegin = this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart();
            sql.append("sum(case t.fperiod when ").append(periodBegin).append(" then t.").append(field.getName()).append(" else 0.0 end) ").append(field.getName());
        } else if (field.isEnd() || field.isYearDebit() || field.isYearCredit()) {
            int periodEnd = this.getCond().getPeriodYearEnd() * 100 + this.getCond().getPeriodNumberEnd();
            sql.append("sum(case t.fperiod when ").append(periodEnd).append(" then t.").append(field.getName()).append(" else 0.0 end) ").append(field.getName());
        } else {
            sql.append("sum(t.").append(field.getName()).append(") ").append(field.getName());
        }
        return sql.toString();
    }

    protected String getSelect(GLRptField field) throws EASBizException, BOSException {
        return this.getSelectField(field);
    }

    protected String getSelectField(GLRptField field) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (field.isTempTableField()) {
            sql.append("t.").append(field.getName());
        } else {
            String name = field.getSelect();
            if (this.getCond().isAccountShowLongName() && "av.fname".equalsIgnoreCase(name)) {
                name = "av.fdisplayName";
            }
            if (field.isMultiLang()) {
                name = name + "_" + this.getCtx().getLocale().toString();
            }
            sql.append(name).append(" ").append(field.getName());
        }
        return sql.toString();
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        if (this.sumItem != null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        String pageFilter = this.getPageFilter("t", this.sp);
        if (pageFilter != null && pageFilter.length() > 0) {
            if (sql.length() > 0) {
                sql.append(" and ");
            }
            sql.append(pageFilter);
        }
        return sql.toString();
    }

    protected String getPageFilter(String tbAlias, List sp) {
        StringBuffer sql = new StringBuffer();
        if (this.isSeqTable && (this.from >= 0 || this.to >= 0)) {
            if (this.from >= 0) {
                sql.append(tbAlias).append(".").append("KSQL_SEQ").append(" >= ?");
                sp.add(new Integer(this.from));
            }
            if (this.to >= 0) {
                sql.append(this.from >= 0 ? " and " : " where ");
                sql.append(" ").append(tbAlias).append(".").append("KSQL_SEQ").append(" <= ?");
                sp.add(new Integer(this.to));
            }
        } else if (this.ids != null && this.ids.length > 0) {
            sql.append(this.GLRptIDs2StrId(this.ids, tbAlias));
        } else if (this.ids != null && this.ids.length == 0) {
            sql.append("1=0");
        }
        return sql.toString();
    }

    protected String GLRptIDs2StrId(GLRptID[] ids, String tbAlias) {
        StringBuffer strIds = new StringBuffer();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    strIds.append(" or ");
                }
                strIds.append(" (").append(tbAlias).append(".").append("KSQL_SEQ").append(" = ").append(ids[i].getSeq()).append(" and ").append(tbAlias).append(".").append("SQL_BATCH").append(" = ").append(ids[i].getBatch()).append(")");
            }
        }
        return strIds.length() > 0 ? "(" + strIds.toString() + ")" : null;
    }

    protected String getJoinDataBaseSQL() throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String joinDBSql = this.getJoinDataBaseSQL();
        if (joinDBSql != null) {
            sql.append(joinDBSql);
        }
        if (this.sumItem != null) {
            sql.append(" inner join (").append(!this.isSeqTable ? this.getSumItemSQLFromDSTable() : this.getSumItemSqlFromSeqTable()).append(") t2 on ");
            if (this.sumItem.getFields() != null && !this.sumItem.getFields().isEmpty()) {
                Iterator it = this.sumItem.getFields().iterator();
                boolean first = true;
                while (it.hasNext()) {
                    GLRptField field = (GLRptField)it.next();
                    if (field.getQueryField() == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        sql.append(" and ");
                    }
                    sql.append(" t.").append(field.getName()).append(" = t2.").append(field.getName());
                }
            } else {
                sql.append(" 1 = 1 ");
            }
        }
        return sql.toString();
    }

    protected String getSumItemSQLFromDSTable() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.KSQL_SEQ, t.SQL_BATCH");
        if (this.sumItem.getFields() != null && !this.sumItem.getFields().isEmpty()) {
            for (GLRptField field : this.sumItem.getFields()) {
                if (field.getQueryField() == null) continue;
                sql.append(",t.").append(field.getName());
            }
        }
        sql.append(" from ").append(this.dataSourceTableName).append(" t ");
        String pageFilter = this.getPageFilter("t", this.sp);
        sql.append(" where t.").append(this.sumItem.getName()).append(" = 1");
        if (pageFilter != null && pageFilter.length() > 0) {
            sql.append(" and ").append(pageFilter);
        }
        return sql.toString();
    }

    protected String getSumItemSqlFromSeqTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.KSQL_SEQ");
        if (this.sumItem.getFields() != null && !this.sumItem.getFields().isEmpty()) {
            for (GLRptField field : this.sumItem.getFields()) {
                if (field.getQueryField() == null) continue;
                sql.append(",t.").append(field.getName());
            }
        }
        sql.append(" from ").append(this.dataSourceTableName).append(" t ");
        sql.append(" where t.").append(this.sumItem.getName()).append(" = 1");
        String pageFilter = this.getPageFilter("t", this.sp);
        if (pageFilter != null && pageFilter.length() > 0) {
            sql.append(" and ").append(pageFilter);
        }
        return sql.toString();
    }

    @Override
    protected String getGroupSQL() throws BOSException, EASBizException {
        if (this.sumItem == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.isSeqTable ? "t2.KSQL_SEQ" : "t2.KSQL_SEQ, t2.SQL_BATCH");
        for (GLRptField field : this.sumItem.getFields()) {
            if (field.getQueryField() != null) {
                sql.append(",t.").append(field.getName());
                continue;
            }
            sql.append(",").append(field.getSelect());
            if (!field.isMultiLang()) continue;
            sql.append("_").append(this.getCtx().getLocale().toString());
        }
        return sql.toString();
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        String orderSQL;
        String groupSQL;
        this.sp.clear();
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append(this.getSelectSQL());
        sql.append(" from ").append(this.getFromSQL());
        sql.append(this.getJoinSQL());
        String whereSQL = this.getWhereSQL();
        if (whereSQL != null && whereSQL.trim().length() > 0) {
            sql.append(" where ").append(whereSQL);
        }
        if ((groupSQL = this.getGroupSQL()) != null && groupSQL.trim().length() > 0) {
            sql.append(" group by ").append(groupSQL);
        }
        if ((orderSQL = this.getOrderSql()) != null) {
            sql.append(orderSQL);
        }
        try {
            return KSqlUtil.optimize((String)sql.toString());
        }
        catch (SqlTranslateException e) {
            throw new BOSException("Sql optimize error!", (Throwable)e);
        }
    }

    protected String getOrderSql() throws EASBizException, BOSException {
        String orderSQL;
        GLRptSQLOrder orders;
        if (this.sumItem != null) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        if (this.isSeqTable) {
            sql.append(" order by t.").append("KSQL_SEQ");
        } else if (this.ids == null && (orders = this.getOrder()) != null && !orders.isEmpty() && (orderSQL = orders.getOrderSQL()) != null) {
            sql.append(orderSQL);
        }
        return sql.toString();
    }

    public List getSQLParams() {
        return this.sp;
    }

    protected String getSumItemSelectAdd() {
        if (this.sumItems == null) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        for (GLRptSumItemInfo item : this.sumItems.getSumItems()) {
            if (this.sumItem.getName().compareTo(item.getName()) == 0) continue;
            sql.append(",0 ").append(item.getName());
        }
        return sql.toString();
    }

    protected String getSumItemsDataFilter(String tab) {
        StringBuffer sql = new StringBuffer();
        if (this.sumItems != null) {
            sql.append("(");
            Iterator sIt = this.sumItems.getSumItems().iterator();
            boolean isFirst = true;
            while (sIt.hasNext()) {
                GLRptSumItemInfo item = (GLRptSumItemInfo)sIt.next();
                if (isFirst) {
                    isFirst = false;
                } else {
                    sql.append(" or ");
                }
                sql.append(tab).append(".");
                sql.append(item.getName()).append("=1");
            }
            sql.append(")");
        }
        return sql.toString();
    }

    protected String getDataSourceTableName() {
        return this.dataSourceTableName;
    }

    protected boolean isSeqTable() {
        return this.isSeqTable;
    }

    protected String getAsstGroupAlias() {
        return "Group";
    }
}

