/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;

public class GLRptPeriodFilter
implements GLRptFilter {
    private int startPeriodYear = -1;
    private int startPeriodNumber = -1;
    private int endPeriodYear = -1;
    private int endPeriodNumber = -1;
    private String periodTypeId;

    public GLRptPeriodFilter(GLRptBaseCondition cond) throws EASBizException, BOSException {
        this(cond, true);
    }

    public GLRptPeriodFilter(GLRptBaseCondition cond, boolean isFromBeginPeriod) throws EASBizException, BOSException {
        PeriodInfo currPeriod;
        this.startPeriodYear = cond.getPeriodYearStart();
        this.startPeriodNumber = cond.getPeriodNumberStart();
        if (isFromBeginPeriod && (currPeriod = cond.getCurrPeriod()) != null && currPeriod.getNumber() < this.startPeriodYear * 100 + this.startPeriodNumber) {
            this.startPeriodYear = currPeriod.getPeriodYear();
            this.startPeriodNumber = currPeriod.getPeriodNumber();
        }
        this.endPeriodYear = cond.getPeriodYearEnd();
        this.endPeriodNumber = cond.getPeriodNumberEnd();
        this.periodTypeId = cond.getPeriodTypeId();
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.periodTypeId != null) {
            sql.append(" pd.ftypeid = '").append(this.periodTypeId).append("'");
        }
        if (this.startPeriodYear == this.endPeriodYear && this.startPeriodNumber == this.endPeriodNumber) {
            sql.append(" and pd.fnumber = ").append(this.startPeriodYear * 100 + this.startPeriodNumber);
        } else {
            sql.append(" and pd.fnumber >= ").append(this.startPeriodYear * 100 + this.startPeriodNumber);
            sql.append(" and pd.fnumber <=  ").append(this.endPeriodYear * 100 + this.endPeriodNumber);
        }
        return sql.toString();
    }
}

