/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherAssistQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class GLRptSubLedgerAccountTreeDao
implements IGLRptDao {
    private static final String ASST_BALANCE = "\"ASSISTBALANCE\"";
    private static final String ACCOUNT_BALANCE = "\"ACCOUNTBALANCE\"";
    private static final String VOUCHER_ENTRIES = "\"ENTRIES\"";
    private static final String ACCOUNT = "\"ACCOUNT\"";
    private static final String VOUCHER = "\"VOUCHER\"";
    protected Context ctx;
    protected GLRptSubLedgerCondition cond;
    private boolean isTreeAssBalFilter = true;

    public GLRptSubLedgerAccountTreeDao(Context ctx) {
        this.ctx = ctx;
    }

    public void init(EntityViewInfo ev) throws EASBizException, BOSException {
        this.cond = (GLRptSubLedgerCondition)ev.get("GLFixCondition");
        this.cond.setCtx(this.ctx);
        this.isTreeAssBalFilter = GLRptDaoUtil.getBoolean(this.cond.getExtendParam("Tree_AssBal_Filter"));
        if (this.isBizUnit()) {
            this.initAccountTable();
        }
        if (GLRptDaoUtil.getBoolean(this.cond.getExtendParam("Update_Balance"))) {
            this.updateVoucherBalance();
        }
    }

    protected void initAccountTable() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = this.cond.getCompany();
        AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)this.ctx).getLastAcctInfo(company.getId().toString(), company.getAccountTable().getId().toString(), this.cond.getPeriodYearEnd(), this.cond.getPeriodNumberEnd());
        if (ar != null && ar.getEnabledAcctTable() != null) {
            company.setAccountTable(ar.getEnabledAcctTable());
            this.cond.setAccountTableId(ar.getEnabledAcctTable().getId().toString());
        }
    }

    private Map getAccountMap() throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<String, ArrayList<AccountViewInfo>> typeAccMap = new HashMap<String, ArrayList<AccountViewInfo>>();
        try {
            String sql = this.getAccountMapSQL();
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            String accountNumber = null;
            String lastAccountNumber = null;
            while (rs.next()) {
                accountNumber = rs.getString("accountNumber");
                if (accountNumber.equals(lastAccountNumber)) continue;
                lastAccountNumber = accountNumber;
                String accTypeId = rs.getString("faccounttypeid");
                ArrayList<AccountViewInfo> accList = (ArrayList<AccountViewInfo>)typeAccMap.get(accTypeId);
                if (accList == null) {
                    accList = new ArrayList<AccountViewInfo>();
                    typeAccMap.put(accTypeId, accList);
                }
                accList.add(this.createAccountViewInfo(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("sql error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return typeAccMap;
    }

    private AccountViewInfo createAccountViewInfo(ResultSet rs) throws SQLException {
        AccountViewInfo account = new AccountViewInfo();
        account.setId(BOSUuid.read((String)rs.getString("accountId")));
        account.setNumber(rs.getString("accountNumber"));
        account.setName(rs.getString("accountName"));
        try {
            if (rs.findColumn("accountLongNumber") > 0) {
                account.setLongNumber(rs.getString("accountLongNumber"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String caa = rs.getString("fcaa");
        if (!StringUtils.isEmpty((String)caa)) {
            AsstAccountInfo asstAccount = new AsstAccountInfo();
            asstAccount.setId(BOSUuid.read((String)caa));
            account.setCAA(asstAccount);
        }
        account.setIsLeaf(rs.getInt("fisleaf") == 1);
        account.setLevel(rs.getInt("flevel"));
        account.setIsQty(rs.getInt("fisqty") == 1);
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)rs.getString("fcompanyid")));
        account.setCompanyID(company);
        account.setHasUserProperty(rs.getInt("fhasuserproperty") == 1);
        return account;
    }

    private IRowSet getAccountTypeRS(String accountTableId, Set accTypes) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T.fparentid, T.avtid, T.avtName  FROM ( ");
        sql.append(" SELECT * FROM  ( select avt.fparentid, avt.fid avtid, avt.fname_").append(this.ctx.getLocale().toString()).append(" avtName ,avt.flongnumber ");
        sql.append(" from t_bd_accounttype avt ");
        sql.append(" where exists (select 1 from t_bd_accounttype lavt");
        sql.append(" where lavt.faccounttableid = avt.faccounttableid");
        sql.append(" and charindex(avt.flongnumber || '!', lavt.FLONGNUMBER) = 1");
        sql.append(" and lavt.fid in (");
        Iterator it = accTypes.iterator();
        sql.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            sql.append(",'").append(it.next()).append("'");
        }
        sql.append("))");
        sql.append(" and avt.faccounttableid = '").append(accountTableId).append("'");
        sql.append("  ) T1  ");
        sql.append(" union all ");
        sql.append(" SELECT * FROM  ( select avt.fparentid, avt.fid avtid, avt.fname_").append(this.ctx.getLocale().toString()).append(" avtName ,avt.flongnumber ");
        sql.append(" from t_bd_accounttype avt ");
        sql.append(" where exists (select 1 from t_bd_accounttype lavt");
        sql.append(" where lavt.faccounttableid = avt.faccounttableid");
        sql.append(" and lavt.flongnumber = avt.flongnumber ");
        sql.append(" and lavt.fid in (");
        it = accTypes.iterator();
        sql.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            sql.append(",'").append(it.next()).append("'");
        }
        sql.append("))");
        sql.append(" and avt.faccounttableid = '").append(accountTableId).append("'");
        sql.append("   ) T2 ");
        sql.append("  ) T  order by T.flongnumber ");
        return DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
    }

    private DefaultMutableTreeNode buildAccTypeTree(Map accountMap) throws BOSException {
        String rootName = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLXResource.account", (Locale)this.ctx.getLocale());
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)rootName);
        if (accountMap.isEmpty()) {
            return root;
        }
        IRowSet rs = this.getAccountTypeRS(this.cond.getAccountTableId(), accountMap.keySet());
        try {
            HashMap<String, DefaultKingdeeTreeNode> accTypeMap = new HashMap<String, DefaultKingdeeTreeNode>();
            while (rs.next()) {
                String avtId = rs.getString("avtid");
                AccountTypeInfo act = new AccountTypeInfo();
                act.setId(BOSUuid.read((String)avtId));
                act.setName(rs.getString("avtName"));
                DefaultKingdeeTreeNode newChild = new DefaultKingdeeTreeNode();
                newChild.setUserObject(act);
                accTypeMap.put(avtId, newChild);
                List accountList = this.setAccountNode(accountMap, avtId, (DefaultMutableTreeNode)newChild);
                String parentId = rs.getString("fparentid");
                if (parentId == null) {
                    root.add((MutableTreeNode)newChild);
                    continue;
                }
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)accTypeMap.get(parentId);
                parent.add((MutableTreeNode)newChild);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        return root;
    }

    private List setAccountNode(Map accountMap, String avtId, DefaultMutableTreeNode newChild) {
        List accountList = (List)accountMap.get(avtId);
        if (accountList != null) {
            Iterator it = accountList.iterator();
            while (it.hasNext()) {
                DefaultKingdeeTreeNode accChild = new DefaultKingdeeTreeNode();
                accChild.setUserObject(it.next());
                newChild.add((MutableTreeNode)accChild);
            }
        }
        return accountList;
    }

    protected String getAccountMapSQL() throws EASBizException, BOSException {
        boolean showExist;
        boolean isSupportCharIndexToLike = SQLUtil.isSupportCharIndexToLike(this.ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" select pacc.faccounttypeid, pacc.fid accountId, pacc.fnumber accountNumber, pacc.flongnumber accountLongNumber ");
        sql.append(", pacc.fcaa, pacc.flevel, pacc.fisleaf, pacc.fisqty, pacc.fcompanyid, pacc.fhasuserproperty");
        sql.append(", pacc.").append(this.cond.isAccountShowLongName() ? "fdisplayname_" : "fname_");
        sql.append(this.ctx.getLocale().toString()).append(" accountName");
        sql.append(" from t_bd_accountview pacc ");
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details || !this.cond.isShowLeafAccount()) {
            if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
                if (this.cond.isOptionAmountZero() || this.includeAssFilter() || this.cond.isOptionAmountAndBalZero()) {
                    sql.append(" inner join t_bd_accountview lacc on ");
                    if (isSupportCharIndexToLike) {
                        sql.append(" (lacc.flongnumber like concat(pacc.flongnumber, '!%') or pacc.fnumber = lacc.fnumber) ");
                    } else {
                        sql.append(" (charindex(pacc.flongnumber||'!', lacc.flongnumber) = 1 or pacc.fnumber = lacc.fnumber) ");
                    }
                    sql.append(" and lacc.faccounttableid = pacc.faccounttableid ");
                } else {
                    sql.append(" inner join t_bd_accountview lacc on pacc.flongnumber = lacc.flongnumber and lacc.faccounttableid = pacc.faccounttableid");
                }
                sql.append(" and lacc.fcompanyid in ").append(this.cond.getCompanyIdsStr());
            } else if (this.cond.isOptionAmountZero() || this.includeAssFilter() || this.cond.isOptionAmountAndBalZero()) {
                sql.append(" inner join t_bd_accountview lacc on ");
                if (isSupportCharIndexToLike) {
                    sql.append(" (lacc.flongnumber like concat(pacc.flongnumber, '!%') or pacc.fnumber = lacc.fnumber) ");
                } else {
                    sql.append(" (charindex(pacc.flongnumber||'!', lacc.flongnumber) = 1 or pacc.fnumber = lacc.fnumber) ");
                }
                sql.append("  and lacc.faccounttableid = pacc.faccounttableid");
                sql.append(" and lacc.fcompanyid = pacc.fcompanyid ");
            }
        }
        sql.append(" where ");
        boolean bl = showExist = this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero();
        if (!this.cond.isGroupByMU() && this.cond.isOptionAmountZero()) {
            sql.append(this.getVoucherFilterSQL());
        } else if (this.includeAssFilter()) {
            sql.append(this.getAsstBalFilterSQL());
        } else {
            sql.delete(sql.lastIndexOf("where"), sql.length() - 1);
            if (showExist) {
                sql.append(" inner join \t");
            } else {
                sql.append(" left outer join ");
            }
            sql.append(this.getAccBalFilterSQL());
            if (this.cond.isShowLeafAccount()) {
                sql.append(" where pacc.fisleaf = 1");
            } else if (this.cond.isCompanysSelect()) {
                sql.append(" where 1=1 ");
            } else {
                sql.append(" where pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
            }
        }
        String accFilter = new GLRptAccountFilter(this.ctx, this.cond, "pacc", "pacc.fid", "pacc.fcompanyid", false).getSQL();
        if (accFilter != null) {
            sql.append(" and ").append(accFilter);
        }
        sql.append(" and pacc.fisProfitCenter <> 1 ");
        sql.append(" and pacc.fcompanyid = '").append(this.cond.getCompany().getId().toString()).append("'");
        sql.append(" and pacc.faccounttableid = '").append(this.cond.getAccountTableId()).append("'");
        sql.append(" order by pacc.faccounttypeid, pacc.fnumber ");
        return sql.toString();
    }

    protected String getVoucherFilterSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append(this.getVoucherFilter("lacc"));
            if (this.cond.isShowLeafAccount()) {
                sql.append(" and pacc.fisleaf = 1 ");
            } else {
                sql.append(" and pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
            }
        } else if (this.cond.isShowLeafAccount()) {
            sql.append(this.getVoucherFilter("pacc"));
        } else {
            sql.append(this.getVoucherFilter("lacc"));
            sql.append(" and pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
        }
        return sql.toString();
    }

    protected String getAsstBalFilterSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append(this.getAsstBalFilter("lacc"));
            if (this.cond.isShowLeafAccount()) {
                sql.append(" and pacc.fisleaf = 1 ");
            } else {
                sql.append(" and pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
            }
            return sql.toString();
        }
        if (this.cond.isShowLeafAccount()) {
            return this.getAsstBalFilter("pacc");
        }
        sql.append(this.getAsstBalFilter("lacc"));
        sql.append(" and pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
        return sql.toString();
    }

    protected String getAccBalFilterSQL() throws EASBizException, BOSException {
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            return this.getAccountBalFilterNew("lacc");
        }
        return this.getAccountBalFilterNew("pacc");
    }

    protected boolean includeAssFilter() {
        if (!this.cond.isShowDisplayAsstDetail()) {
            return false;
        }
        boolean isIncludeAssFilter = false;
        List list = this.cond.getAsstActList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            if (!at.isSelected()) continue;
            isIncludeAssFilter = true;
            break;
        }
        return isIncludeAssFilter && this.isTreeAssBalFilter;
    }

    protected String getVoucherFilter(String tag) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        GLRptVoucherAssistQuery query = this.getRptVoucherAssistQuery(this.ctx, this.cond.getCompany(), this.cond, false);
        query.setSelector(this.getAccountSelector());
        query.setAccountFilter(false);
        String voucherSql = query.getSQL();
        voucherSql = " select 1 " + voucherSql.substring(voucherSql.toUpperCase().indexOf(" FROM "));
        sql.append(" exists (").append(voucherSql).append(" and ").append(this.getVoucherEntryTableAlias()).append(".FAccountID = ").append(tag).append(".fid) ");
        return sql.toString();
    }

    private String getAccountBalFilterNew(String tag) throws EASBizException, BOSException {
        GLRptAccountBalQuery query = this.getRptAccountBalanceQuery(this.ctx, this.cond.getCompany(), this.cond);
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        query.setSelector(selector);
        query.setNotGroup(true);
        if (this.cond.isOptionAmountAndBalZero()) {
            query.addGLRptFilter(this.getAmountGLRptFilter());
        }
        String accBalSql = query.getSQL();
        StringBuffer sql = new StringBuffer();
        accBalSql = this.cond.isNotIncluePLVoucher() ? " select  b.FAccountID ,b.FOrgUnitID  FROM (SELECT b.FAccountID FAccountID ,b.FOrgUnitID FOrgUnitID " + accBalSql.substring(accBalSql.toUpperCase().indexOf(" FROM T_GL")) : " select  b.FAccountID ,b.FOrgUnitID " + accBalSql.substring(accBalSql.toUpperCase().indexOf(" FROM "));
        sql.append(" (").append(accBalSql).append(" group by ").append("b.FAccountID ,b.FOrgUnitID ").append(") acctBal on acctBal.FAccountID = " + tag + ".fid ");
        sql.append(" and acctBal.FOrgUnitID = " + tag + ".fcompanyid ");
        return sql.toString();
    }

    protected String getAccountBalFilter(String tag) throws EASBizException, BOSException {
        GLRptAccountBalQuery query = this.getRptAccountBalanceQuery(this.ctx, this.cond.getCompany(), this.cond);
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        query.setSelector(selector);
        query.setNotGroup(true);
        if (this.cond.isOptionAmountAndBalZero()) {
            query.addGLRptFilter(this.getAmountGLRptFilter());
        }
        String accBalSql = query.getSQL();
        StringBuffer sql = new StringBuffer();
        accBalSql = " select 1 " + accBalSql.substring(accBalSql.toUpperCase().indexOf(" FROM "));
        sql.append(" exists (").append(accBalSql);
        sql.append(this.cond.isNotIncluePLVoucher() ? " where " : " and ").append(query.getMainTable().getAlias()).append(".FAccountID = ").append(tag).append(".fid) ");
        return sql.toString();
    }

    private GLRptFilter getAmountGLRptFilter() {
        return new GLRptFilter(){

            @Override
            public String getSQL() throws EASBizException, BOSException {
                StringBuffer s = new StringBuffer();
                String currencyId = GLRptSubLedgerAccountTreeDao.this.cond.getCurrencyID();
                boolean isForCurrency = false;
                boolean isLocalCurrency = false;
                boolean isRptCurrency = false;
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
                    isLocalCurrency = true;
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
                    isRptCurrency = true;
                } else {
                    isForCurrency = true;
                }
                s.append(" (b.fdetailcount<> 0 ");
                if (isForCurrency) {
                    s.append(" or b.fendbalancefor <> 0");
                    s.append(" or b.fdebitfor <>0 or b.fcreditfor <> 0");
                }
                if (isLocalCurrency || isForCurrency) {
                    s.append(" or b.fdebitlocal<>0 or b.fcreditlocal<>0");
                    s.append(" or b.fendbalancelocal <> 0");
                }
                if ((isRptCurrency || isForCurrency) && GLRptSubLedgerAccountTreeDao.this.cond.getRptParams().isUseReportCurrency()) {
                    s.append(" or b.fendbalancerpt <>0");
                    s.append(" or b.fdebitrpt<>0 or b.fcreditrpt<>0");
                }
                s.append(")");
                return s.toString();
            }
        };
    }

    protected String getAsstBalFilter(String tag) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        GLRptAsstactBalQuery query = this.ctx.get((Object)"isPca") != null ? this.getRptAsstactBalanceQuery(this.ctx, this.cond.getCompany(), this.cond) : this.getRptAsstactBalanceQuery(this.ctx, this.cond.getCompany(), this.cond, this.isQueryMeasureUnitBalance());
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        query.setSelector(selector);
        query.setNotGroup(true);
        if (this.cond.isOptionAmountAndBalZero()) {
            query.addGLRptFilter(this.getAmountGLRptFilter());
        }
        String assBalSql = query.getSQL();
        assBalSql = " select 1 " + assBalSql.substring(assBalSql.toUpperCase().indexOf(" FROM "));
        String fj = this.cond.isNotIncluePLVoucher() && query.getAmountFilter() == null ? " where " : " and ";
        sql.append(" exists (").append(assBalSql).append(fj).append(query.getMainTable().getAlias()).append(".FAccountID = ").append(tag).append(".fid) ");
        return sql.toString();
    }

    protected GLRptSelector getAccountSelector() {
        GLRptSelector sic = new GLRptSelector();
        sic.add(GLRptVoucherField.accountID);
        return sic;
    }

    @Override
    public String createDataSourceTable(EntityViewInfo ev) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void releaseTempTable() {
    }

    @Override
    public GLRptTableHeadInfo getTableHeadInfo() throws BOSException, EASBizException {
        return null;
    }

    @Override
    public int getViewRowCount() throws BOSException, EASBizException {
        return 1;
    }

    @Override
    public GLRptRowSet getData(int start, int length) throws BOSException, EASBizException {
        Map accountMap = this.getAccountMap();
        DefaultMutableTreeNode root = this.buildAccTypeTree(accountMap);
        GLRptRowSet rowSet = new GLRptRowSet(new String[]{"accountTree"}, 1);
        rowSet.insertRow();
        rowSet.updateObject("accountTree", root);
        return rowSet;
    }

    @Override
    public GLRptRowSet getAsynSumData() throws BOSException, EASBizException {
        return null;
    }

    protected boolean isBizUnit() {
        CompanyOrgUnitInfo company = this.cond.getCompany();
        return company.isIsBizUnit() && this.cond.getAccountTableId() == null;
    }

    protected void updateVoucherBalance() throws BOSException {
        String[] companyIds = GLRptDaoUtil.set2StringArray(this.cond.getCompanyIds());
        GLBalanceFacadeFactory.getLocalInstance(this.ctx).updateVoucherBalance(companyIds);
    }

    protected GLRptAccountBalQuery getRptAccountBalanceQuery(Context ctx, CompanyOrgUnitInfo company, GLRptBaseCondition cond) throws EASBizException, BOSException {
        return new GLRptAccountBalQuery(ctx, (OrgUnitInfo)company, cond, false, false);
    }

    protected GLRptAsstactBalQuery getRptAsstactBalanceQuery(Context ctx, CompanyOrgUnitInfo company, GLRptSubLedgerCondition cond) throws EASBizException, BOSException {
        return new GLRptAsstactBalQuery(ctx, (OrgUnitInfo)company, cond, false, false);
    }

    protected GLRptAsstactBalQuery getRptAsstactBalanceQuery(Context ctx, CompanyOrgUnitInfo company, GLRptSubLedgerCondition cond, boolean isMeasureUnit) throws EASBizException, BOSException {
        return new GLRptAsstactBalQuery(ctx, (OrgUnitInfo)company, cond, isMeasureUnit, false);
    }

    protected GLRptVoucherAssistQuery getRptVoucherAssistQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isOnlyQty) {
        return new GLRptVoucherAssistQuery(ctx, cond, false);
    }

    protected String getAssistBalanceTableAlias() {
        return ASST_BALANCE;
    }

    protected String getAccountBalanceTableAlias() {
        return ACCOUNT_BALANCE;
    }

    protected String getVoucherEntryTableAlias() {
        return VOUCHER_ENTRIES;
    }

    protected boolean isQueryMeasureUnitBalance() {
        return this.cond.isGroupByMU();
    }
}

