/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerSplitEntryInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerVoucherQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableStruct;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherEntryInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptSubLedgerVoucherQuery;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLRptSubLedgerSpliter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerSpliter");
    protected static final int MAX_RECORDS = 1000;
    protected Context ctx;
    protected GLRptSubLedgerDao dao;
    protected CompanyOrgUnitInfo company;
    protected GLRptSubLedgerCondition cond;

    public GLRptSubLedgerSpliter(Context ctx, GLRptSubLedgerDao dao, OrgUnitInfo company, GLRptSubLedgerCondition cond) {
        this.ctx = ctx;
        this.dao = dao;
        this.cond = cond;
        this.initParams(ctx, dao, company, cond);
    }

    protected void initParams(Context ctx, GLRptSubLedgerDao dao, OrgUnitInfo company, GLRptSubLedgerCondition cond) {
        this.company = (CompanyOrgUnitInfo)company;
    }

    public void split(String dataSourceTableName) throws BOSException, EASBizException {
        String splitTable = null;
        try {
            splitTable = this.createSplitDataSource();
            this.insertDataSourceSQL(dataSourceTableName, splitTable);
        }
        catch (Exception e) {
            throw new BOSException(" split sql error!", (Throwable)e);
        }
        finally {
            if (splitTable != null) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(splitTable);
            }
        }
    }

    private String createAccountTmpTable(GLRptSubLedgerCondition cond) throws BOSException, EASBizException {
        String tmpTable = GLTempTableUtil.createDBSysTempTable(this.ctx, "FID varchar(44),FParentID varchar(44)" + (cond.isGroupVoucher() ? ",FSParentID varchar(44)" : ""));
        boolean isSupportCharIndexToLike = SQLUtil.isSupportCharIndexToLike(this.ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tmpTable).append("(FID,FParentID").append(cond.isGroupVoucher() ? ",FSParentID" : "").append(")");
        sql.append(" select account.fid, pav.fid").append(cond.isGroupVoucher() ? ",sav.fid" : "");
        sql.append(" from t_bd_accountview account ");
        sql.append(" inner join t_bd_accountview pav on account.faccounttableid = pav.faccounttableid ");
        if (isSupportCharIndexToLike) {
            sql.append(" and (account.flongnumber like concat(pav.flongnumber, '!%') ");
        } else {
            sql.append(" and (charindex(pav.flongnumber||'!', account.flongnumber) = 1 ");
        }
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append(" or pav.fnumber = account.fnumber) ");
            sql.append(" and account.fcompanyid in ").append(cond.getCompanyIdsStr());
        } else {
            sql.append(" or pav.fid = account.fid) ");
            sql.append(" and account.fcompanyid = pav.fcompanyid ");
        }
        if (cond.isGroupVoucher()) {
            sql.append(" inner join t_bd_accountview sav on ( ");
            if (isSupportCharIndexToLike) {
                sql.append(" account.flongnumber like concat(sav.flongnumber, '!%')");
            } else {
                sql.append(" charindex(sav.flongnumber||'!', account.flongnumber) = 1");
            }
            sql.append(" or sav.fid = account.fid) ");
            sql.append(" and sav.faccounttableid = account.faccounttableid and sav.fcompanyid = account.fcompanyid ");
            sql.append(" and (sav.flevel = ").append(cond.getGroupVoucherAccLevel()).append(" or (sav.fisleaf = 1 and sav.flevel < ").append(cond.getGroupVoucherAccLevel()).append("))");
        }
        sql.append(" where pav.fid in (").append(cond.getAccountIdFilter()).append(") and account.fisleaf = 1");
        this.setAccountTableFilter(sql, cond);
        this.setAccountCompanyFilter(sql, cond);
        this.setAccountNumberFilter(sql, cond);
        this.setAccountDataPermFilter(sql, "account.fid", cond);
        Set asstAccountIdSet = cond.getAsstAccountIdSet();
        if (!asstAccountIdSet.isEmpty()) {
            String asstAccIdStr = GLRptDaoUtil.set2String(asstAccountIdSet);
            this.addFilterItem(sql, "account.FCAA in " + asstAccIdStr);
        }
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        return tmpTable;
    }

    private void setAccountTableFilter(StringBuffer filter, GLRptSubLedgerCondition cond) throws BOSException {
        this.addFilterItem(filter, "account.FAccountTableID = '" + cond.getAccountTableId() + "'");
    }

    private void setAccountCompanyFilter(StringBuffer filter, GLRptSubLedgerCondition cond) throws BOSException {
        this.addFilterItem(filter, "account.FCompanyID in " + cond.getCompanyIdsStr());
    }

    private void setAccountNumberFilter(StringBuffer filter, GLRptSubLedgerCondition cond) {
        if (cond.isInputCodeStart()) {
            String[] starAcc = cond.getAccountCodeStart().split(",");
            if (starAcc.length > 1) {
                this.addFilterItem(filter, "(account.FNumber in " + GLRptDaoUtil.StringArray2String(starAcc) + " or account.FNumber > '" + starAcc[starAcc.length - 1] + "')");
            } else {
                this.addFilterItem(filter, "account.FNumber >= '" + starAcc[0] + "'");
            }
        }
        if (cond.isInputCodeEnd()) {
            String[] endAcc = cond.getAccountCodeEnd().split(",");
            if (endAcc.length > 1) {
                this.addFilterItem(filter, "(account.FNumber in " + GLRptDaoUtil.StringArray2String(endAcc) + " or account.FNumber < '" + endAcc[endAcc.length - 1] + "ZZ')");
            } else {
                this.addFilterItem(filter, "account.FNumber <= '" + endAcc[0] + "ZZ'");
            }
        }
    }

    private void setAccountDataPermFilter(StringBuffer filter, String field, GLRptSubLedgerCondition cond) throws EASBizException, BOSException {
        if (cond.getRptParams().useAccountPermission()) {
            CompanyDisplayModeEnum companyDisplayMode = cond.getCompanyDisplayMode();
            String fieldCompany = GLRptVoucherField.companyID.getSelect();
            String item = GLRptDaoUtil.getDataPermFilter(this.ctx, companyDisplayMode, cond.getCompany(), cond.getCompanyIdsStr(), "bd_account_accountView_view", false, field, fieldCompany);
            this.addFilterItem(filter, item);
        }
    }

    private void addFilterItem(StringBuffer filters, String filterItem) {
        if (StringUtils.isEmpty((String)filterItem)) {
            return;
        }
        if (filters.length() > 0) {
            filters.append(" AND ");
        }
        filters.append(filterItem);
    }

    private String createSplitDataSource() throws BOSException, EASBizException {
        String splitTable = this.createSplitTempTable();
        CurrencyCollection cyColl = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection("select id, precision");
        GLRptSubLedgerVoucherQuery query = this.getRptSubLedgerVoucherQuery(this.ctx, this.company, null, false);
        if (this.company.getReportConvertMode() == null) {
            this.company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.company.getId().toString()));
        }
        boolean isBaseLocalExRate = ReportCurrencyConvertMode.Base == this.company.getReportConvertMode();
        query.setSelector(this.getSelector());
        String voucherIdTable = this.createVoucherIDTempTable();
        query.setOrder(this.getOrder());
        String[] sqls = query.getSQL().split("ORDER BY ");
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select /*+ leading(tmp)*/").append(sqls[0].trim().substring(6)).append(" inner join ").append(" (select distinct voucherid from ").append(voucherIdTable).append(") ");
        sqlBuff.append(" tmp on tmp.voucherid = voucher.fid ");
        if (query instanceof PcaRptSubLedgerVoucherQuery) {
            sqlBuff.append(" where voucher." + this.getOrgUnitId() + " in ").append(this.cond.getProfitCenterIdsStr());
        } else {
            sqlBuff.append(" where voucher." + this.getOrgUnitId() + " in ").append(this.cond.getCompanyIdsStr());
        }
        sqlBuff.append(" and voucher.fperiodid in ").append(this.cond.getPeriodIdStr(false));
        sqlBuff.append(" and voucher.fbizstatus in (").append(this.cond.getOptionPosting() ? "1,3,5" : "5").append(")");
        sqlBuff.append(" ORDER BY ").append(sqls[1]);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.createStatement();
            String sql = sqlBuff.toString().replaceFirst("CASE  WHEN \\(\"ASSISTRECORDS\".fdescription IS NULL\\) THEN \"ENTRIES\".fdescription ELSE \"ASSISTRECORDS\".fdescription END", "\"ASSISTRECORDS\".FDescription");
            rs = stmt.executeQuery(sql);
            ArrayList<GLRptVoucherEntryInfo> debitEntrys = new ArrayList<GLRptVoucherEntryInfo>();
            ArrayList<GLRptVoucherEntryInfo> creditEntrys = new ArrayList<GLRptVoucherEntryInfo>();
            ArrayList<GLRptSubLedgerSplitEntryInfo> splitEntryList = new ArrayList<GLRptSubLedgerSplitEntryInfo>();
            GLRptVoucherEntryInfo lastEntry = null;
            while (rs.next()) {
                GLRptVoucherEntryInfo entry = this.createVoucherEntry(rs, isBaseLocalExRate);
                if (this.company.getReportCurrency() != null) {
                    CurrencyInfo rptCurrency = cyColl.get((Object)this.company.getReportCurrency().getId());
                    entry.setRptCurrencyScale(rptCurrency.getPrecision());
                }
                CurrencyInfo currency = cyColl.get((Object)BOSUuid.read((String)entry.getCurrencyId()));
                entry.setCurrencyScale(currency.getPrecision());
                if (lastEntry != null && !entry.getVoucherId().equals(lastEntry.getVoucherId())) {
                    splitEntryList.addAll(this.split(debitEntrys, creditEntrys));
                    if (splitEntryList.size() >= 1000) {
                        this.insertData(conn, splitTable, splitEntryList);
                        splitEntryList.clear();
                    }
                    debitEntrys.clear();
                    creditEntrys.clear();
                }
                if (entry.isCreditSubLedgerSpliter()) {
                    creditEntrys.add(entry);
                } else {
                    debitEntrys.add(entry);
                }
                lastEntry = entry;
            }
            if (!debitEntrys.isEmpty() && !creditEntrys.isEmpty()) {
                splitEntryList.addAll(this.split(debitEntrys, creditEntrys));
            }
            if (!splitEntryList.isEmpty()) {
                this.insertData(conn, splitTable, splitEntryList);
            }
            String avTemTableName = this.createAccountTmpTable(this.cond);
            String deleteSql = " delete " + splitTable + " where accountid not in (select fid from " + avTemTableName + ") ";
            SQLUtils.execute((Connection)conn, (String)deleteSql);
            if (this.cond.queryVoucherAssistRecordField()) {
                deleteSql = "delete from " + splitTable + " t where t.voucherassrecid is not null and not exists (select 1 from " + voucherIdTable + " v where v.VOUCHERID = t.VOUCHERID and v.ASSISTRECORDID = t.voucherassrecid)";
                SQLUtils.execute((Connection)conn, (String)deleteSql);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("sql error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return splitTable;
    }

    private List<GLRptSubLedgerSplitEntryInfo> split(List<GLRptVoucherEntryInfo> debitEntrys, List<GLRptVoucherEntryInfo> creditEntrys) {
        ArrayList<GLRptSubLedgerSplitEntryInfo> splitEntryList;
        block19: {
            int j;
            int i;
            GLRptSubLedgerSplitEntryInfo splitEntry;
            block18: {
                GLRptVoucherEntryInfo creditEntry;
                splitEntryList = new ArrayList<GLRptSubLedgerSplitEntryInfo>();
                if (debitEntrys.size() == 1 && creditEntrys.size() == 1) {
                    for (GLRptVoucherEntryInfo debitEntry : debitEntrys) {
                        for (GLRptVoucherEntryInfo creditEntry2 : creditEntrys) {
                            GLRptSubLedgerSplitEntryInfo splitEntry2 = new GLRptSubLedgerSplitEntryInfo();
                            splitEntry2.setEntryInfo(debitEntry);
                            splitEntry2.setOppEntryInfo(creditEntry2);
                            splitEntryList.add(splitEntry2);
                        }
                    }
                    return splitEntryList;
                }
                HashSet<GLRptVoucherEntryInfo> offsets = new HashSet<GLRptVoucherEntryInfo>();
                block2: for (GLRptVoucherEntryInfo debitEntry : debitEntrys) {
                    for (GLRptVoucherEntryInfo creditEntry3 : creditEntrys) {
                        if (offsets.contains(creditEntry3) || debitEntry.getEntryDC() == creditEntry3.getEntryDC() || debitEntry.getLocalAmount().compareTo(creditEntry3.getLocalAmount()) != 0 || debitEntry.getAccountId().equals(creditEntry3.getAccountId())) continue;
                        offsets.add(debitEntry);
                        offsets.add(creditEntry3);
                        splitEntry = new GLRptSubLedgerSplitEntryInfo();
                        splitEntry.setEntryInfo(debitEntry);
                        splitEntry.setOppEntryInfo(creditEntry3);
                        splitEntryList.add(splitEntry);
                        continue block2;
                    }
                }
                block4: for (GLRptVoucherEntryInfo debitEntry : debitEntrys) {
                    if (offsets.contains(debitEntry)) continue;
                    for (GLRptVoucherEntryInfo creditEntry3 : creditEntrys) {
                        if (offsets.contains(creditEntry3) || debitEntry.getEntryDC() != creditEntry3.getEntryDC() || debitEntry.getLocalAmount().compareTo(GlUtils.zero.subtract(creditEntry3.getLocalAmount())) != 0 || debitEntry.getAccountId().equals(creditEntry3.getAccountId())) continue;
                        offsets.add(debitEntry);
                        offsets.add(creditEntry3);
                        splitEntry = new GLRptSubLedgerSplitEntryInfo();
                        splitEntry.setEntryInfo(debitEntry);
                        splitEntry.setOppEntryInfo(creditEntry3);
                        splitEntryList.add(splitEntry);
                        continue block4;
                    }
                }
                List<GLRptVoucherEntryInfo> dEntrys = debitEntrys;
                List<GLRptVoucherEntryInfo> cEntrys = creditEntrys;
                if (offsets.size() > 0) {
                    dEntrys = new ArrayList<GLRptVoucherEntryInfo>();
                    for (GLRptVoucherEntryInfo debitEntry : debitEntrys) {
                        if (offsets.contains(debitEntry)) continue;
                        dEntrys.add(debitEntry);
                    }
                    cEntrys = new ArrayList<GLRptVoucherEntryInfo>();
                    for (GLRptVoucherEntryInfo creditEntry3 : creditEntrys) {
                        if (offsets.contains(creditEntry3)) continue;
                        cEntrys.add(creditEntry3);
                    }
                }
                debitEntrys = dEntrys;
                creditEntrys = cEntrys;
                i = 0;
                j = 0;
                while (i < debitEntrys.size() && j < creditEntrys.size()) {
                    GLRptVoucherEntryInfo debitEntry = debitEntrys.get(i);
                    creditEntry = creditEntrys.get(j);
                    GLRptSubLedgerSplitEntryInfo splitEntry3 = null;
                    if (debitEntry.compareTo(creditEntry) < 0) {
                        splitEntry3 = creditEntry.merge(debitEntry);
                        ++i;
                    } else if (debitEntry.compareTo(creditEntry) > 0) {
                        splitEntry3 = debitEntry.merge(creditEntry);
                        ++j;
                    } else if (debitEntry.compareTo(creditEntry) == 0) {
                        splitEntry3 = new GLRptSubLedgerSplitEntryInfo();
                        splitEntry3.setEntryInfo(debitEntry);
                        splitEntry3.setOppEntryInfo(creditEntry);
                        ++i;
                        ++j;
                    }
                    if (splitEntry3 == null) continue;
                    splitEntryList.add(splitEntry3);
                }
                splitEntry = null;
                if (i == debitEntrys.size() || creditEntrys.size() <= 0) break block18;
                creditEntry = creditEntrys.get(j - 1).clone();
                creditEntry.setOriginalAmount(BigDecimal.ZERO);
                creditEntry.setLocalAmount(BigDecimal.ZERO);
                creditEntry.setReportingAmount(BigDecimal.ZERO);
                creditEntry.setQuantity(BigDecimal.ZERO);
                creditEntry.setStandardQuantity(BigDecimal.ZERO);
                GLRptVoucherEntryInfo debitEntry = null;
                for (int k = i; k < debitEntrys.size(); ++k) {
                    debitEntry = debitEntrys.get(k);
                    if (!this.cond.getAccountIdSet().contains(debitEntry.getAccountId())) continue;
                    splitEntry = new GLRptSubLedgerSplitEntryInfo();
                    splitEntry.setEntryInfo(debitEntry);
                    splitEntry.setOppEntryInfo(creditEntry);
                    splitEntryList.add(splitEntry);
                }
                break block19;
            }
            if (j == creditEntrys.size() || debitEntrys.size() <= 0) break block19;
            GLRptVoucherEntryInfo debitEntry = debitEntrys.get(i - 1).clone();
            debitEntry.setOriginalAmount(BigDecimal.ZERO);
            debitEntry.setLocalAmount(BigDecimal.ZERO);
            debitEntry.setReportingAmount(BigDecimal.ZERO);
            debitEntry.setQuantity(BigDecimal.ZERO);
            debitEntry.setStandardQuantity(BigDecimal.ZERO);
            GLRptVoucherEntryInfo creditEntry = null;
            for (int k = j; k < creditEntrys.size(); ++k) {
                creditEntry = creditEntrys.get(k);
                if (!this.cond.getAccountIdSet().contains(creditEntry.getAccountId())) continue;
                splitEntry = new GLRptSubLedgerSplitEntryInfo();
                splitEntry.setEntryInfo(creditEntry);
                splitEntry.setOppEntryInfo(debitEntry);
                splitEntryList.add(splitEntry);
            }
        }
        return splitEntryList;
    }

    private void insertData(Connection conn, String splitTable, Collection<GLRptSubLedgerSplitEntryInfo> splitEntryList) throws EASBizException, BOSException {
        splitEntryList = this.doSplitEntry(splitEntryList);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(this.getInsertSQL(splitTable));
            for (GLRptSubLedgerSplitEntryInfo splitEntry : splitEntryList) {
                this.setParams(stmt, splitEntry.getEntryInfo(), splitEntry.getOppEntryInfo());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("sql error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt);
    }

    private Collection<GLRptSubLedgerSplitEntryInfo> doSplitEntry(Collection<GLRptSubLedgerSplitEntryInfo> splitEntryList) {
        boolean showAsst = (this.cond.isShowDisplayAsstDetail() || this.cond.isShowAccountAttribute()) && !this.cond.isShowOppAsstact();
        boolean showOppAsst = !this.cond.isShowDisplayAsstDetail() && !this.cond.isShowAccountAttribute() && this.cond.isShowOppAsstact();
        HashMap<String, GLRptSubLedgerSplitEntryInfo> entryMap = new HashMap<String, GLRptSubLedgerSplitEntryInfo>();
        ArrayList splitEntrys = new ArrayList();
        for (GLRptSubLedgerSplitEntryInfo entry : splitEntryList) {
            GLRptSubLedgerSplitEntryInfo entry1 = new GLRptSubLedgerSplitEntryInfo();
            entry1.setEntryInfo(entry.getEntryInfo().clone());
            entry1.setOppEntryInfo(entry.getOppEntryInfo().clone());
            if (showAsst || showOppAsst) {
                this.mergeSplitEntry(showAsst, entryMap, entry1);
            } else if (!this.cond.isLeafAccount() || this.cond.getAccountIdSet().contains(entry1.getEntryInfo().getAccountId())) {
                splitEntrys.add(entry1);
            }
            GLRptSubLedgerSplitEntryInfo entry2 = new GLRptSubLedgerSplitEntryInfo();
            entry2.setEntryInfo(entry.getOppEntryInfo().clone());
            entry2.setOppEntryInfo(entry.getEntryInfo().clone());
            if (showAsst || showOppAsst) {
                this.mergeSplitEntry(showAsst, entryMap, entry2);
                continue;
            }
            if (this.cond.isLeafAccount() && !this.cond.getAccountIdSet().contains(entry2.getEntryInfo().getAccountId())) continue;
            splitEntrys.add(entry2);
        }
        Collection es = showAsst || showOppAsst ? entryMap.values() : splitEntrys;
        ArrayList<GLRptSubLedgerSplitEntryInfo> result = new ArrayList<GLRptSubLedgerSplitEntryInfo>(es.size());
        result.addAll(es);
        Collections.sort(result, new Comparator<GLRptSubLedgerSplitEntryInfo>(){

            @Override
            public int compare(GLRptSubLedgerSplitEntryInfo o1, GLRptSubLedgerSplitEntryInfo o2) {
                int r = o1.getEntryInfo().getEntriesSeq() - o2.getEntryInfo().getEntriesSeq();
                if (r != 0) {
                    return r;
                }
                if (GLRptSubLedgerSpliter.this.cond.isShowDisplayAsstDetail() && (r = o1.getEntryInfo().getAsstRecSeq() - o2.getEntryInfo().getAsstRecSeq()) != 0) {
                    return r;
                }
                r = o1.getOppEntryInfo().getEntriesSeq() - o2.getOppEntryInfo().getEntriesSeq();
                if (r != 0) {
                    return r;
                }
                if (GLRptSubLedgerSpliter.this.cond.isShowOppAsstact()) {
                    r = o1.getOppEntryInfo().getAsstRecSeq() - o2.getOppEntryInfo().getAsstRecSeq();
                }
                return r;
            }
        });
        int seq = 0;
        for (GLRptSubLedgerSplitEntryInfo entry : result) {
            entry.getEntryInfo().setEntriesSeq(seq);
            entry.getEntryInfo().setAsstRecSeq(seq);
            entry.getOppEntryInfo().setEntriesSeq(seq);
            entry.getOppEntryInfo().setAsstRecSeq(seq);
            ++seq;
        }
        return result;
    }

    private void mergeSplitEntry(boolean showAsst, Map<String, GLRptSubLedgerSplitEntryInfo> entryMap, GLRptSubLedgerSplitEntryInfo entry) {
        String key = null;
        key = showAsst ? entry.getEntryInfo().getEntryId() + entry.getEntryInfo().getAssitRecordId() + entry.getOppEntryInfo().getEntryId() : entry.getEntryInfo().getEntryId() + entry.getOppEntryInfo().getEntryId() + entry.getOppEntryInfo().getAssitRecordId();
        GLRptSubLedgerSplitEntryInfo splitEntry = entryMap.get(key);
        if (splitEntry == null) {
            entryMap.put(key, entry);
        } else {
            splitEntry.add(entry);
        }
    }

    private String createVoucherIDTempTable() throws EASBizException, BOSException {
        GLRptSubLedgerVoucherQuery query = this.getRptSubLedgerVoucherQuery(this.ctx, this.company, this.cond, false);
        GLRptSelector selector = new GLRptSelector();
        GLRptTempTableStruct struct = new GLRptTempTableStruct();
        selector.add(GLRptVoucherField.voucherID);
        struct.addField(GLRptVoucherField.voucherID);
        if (this.cond.queryVoucherAssistRecordField()) {
            selector.add(GLRptVoucherField.asstRecordID);
            struct.addField(GLRptVoucherField.asstRecordID);
        }
        query.setSelector(selector);
        query.setDistinct(true);
        String table = GLTempTableUtil.createDBSysTempTable(this.ctx, struct.getDataTableDesc());
        DbUtil.execute((Context)this.ctx, (String)("insert into " + table + " " + query.getSQL()));
        return table;
    }

    private GLRptVoucherEntryInfo createVoucherEntry(ResultSet rs, boolean isBaseLocalExRate) throws SQLException, EASBizException, BOSException {
        boolean isJoinVchAsst;
        GLRptVoucherEntryInfo entry = new GLRptVoucherEntryInfo(isBaseLocalExRate);
        entry.setVoucherId(rs.getString(GLRptVoucherField.voucherID.getName()));
        entry.setEntryId(rs.getString(GLRptVoucherField.entryID.getName()));
        entry.setAccountId(rs.getString(GLRptVoucherField.accountID.getName()));
        entry.setCurrencyId(rs.getString(GLRptVoucherField.currencyID.getName()));
        entry.setPeriod(rs.getInt(GLRptVoucherField.period.getName()));
        entry.setEntryDC(rs.getInt(GLRptVoucherField.entryDC.getName()) == 0 ? -1 : 1);
        entry.setEntriesSeq(rs.getInt(GLRptVoucherField.entrySeq.getName()));
        entry.setEntriesSeqReal(rs.getInt(GLRptVoucherField.entrySeq.getName()));
        boolean bl = isJoinVchAsst = this.cond.isShowDisplayAsstDetail() || this.cond.isShowOppAsstact() || this.cond.isShowAccountAttribute();
        if (isJoinVchAsst) {
            entry.setAssitRecordId(rs.getString(GLRptVoucherField.asstRecordID.getName()));
            entry.setAsstRecSeq(rs.getInt(GLRptVoucherField.asstRecordSeq.getName()));
        }
        if (this.cond.isShowDisplayAsstDetail() || this.cond.isShowOppAsstact()) {
            entry.setHgId(rs.getString(GLRptVoucherField.HGID.getName()));
        }
        entry.setOriginalAmount(rs.getBigDecimal("FOriginalAmount"));
        entry.setLocalAmount(rs.getBigDecimal("FLocalAmount"));
        entry.setReportingAmount(rs.getBigDecimal("FReportingAmount"));
        entry.setQuantity(rs.getBigDecimal("FQuantity"));
        entry.setStandardQuantity(rs.getBigDecimal("FStandardQuantity"));
        entry.setLocalExRate(rs.getBigDecimal(GLRptVoucherField.localExRate.getName()));
        entry.setRptExRate(rs.getBigDecimal(GLRptVoucherField.rptExRate.getName()));
        entry.setQtyScale(this.cond.getRptParams().getQtyScale());
        entry.setEntryDesc(rs.getString(GLRptVoucherField.entryDesc.getName()));
        if (this.cond.isShowOppAsstact()) {
            entry.setAssistDesc(rs.getString(GLRptVoucherField.entryAsstRecordDesc.getName()));
        }
        return entry;
    }

    private GLRptSelector getSelector() throws BOSException, EASBizException {
        boolean joinVchAsst;
        GLRptSelector sic = new GLRptSelector();
        sic.add(GLRptVoucherField.voucherID);
        sic.add(GLRptVoucherField.entryID);
        sic.add(GLRptVoucherField.entryDC);
        sic.add(GLRptVoucherField.accountID);
        sic.add(GLRptVoucherField.currencyID);
        sic.add(GLRptVoucherField.period);
        sic.add(GLRptVoucherField.entrySeq);
        sic.add(GLRptVoucherField.localExRate);
        sic.add(GLRptVoucherField.rptExRate);
        if (this.cond.isShowOppAsstact()) {
            sic.add(GLRptVoucherField.entryAsstRecordDesc);
        } else {
            sic.add(GLRptVoucherField.entryDesc);
        }
        if (this.cond.getRptParams().isQtyAsst() && (this.cond.isShowDisplayAsstDetail() || this.cond.isShowOppAsstact())) {
            sic.add(GLRptVoucherField.entryAsstMeasureUnitID);
        } else {
            sic.add(GLRptVoucherField.entryMeasureUnitID);
        }
        boolean bl = joinVchAsst = this.cond.queryVoucherAssistRecordField() || this.cond.isShowOppAsstact();
        if (joinVchAsst) {
            sic.add(GLRptVoucherField.asstRecordID);
            sic.add(GLRptVoucherField.asstRecordSeq);
            sic.add(GLRptVoucherField.entryAsstRecordFor);
            sic.add(GLRptVoucherField.entryAsstRecordLocal);
            sic.add(GLRptVoucherField.entryAsstRecordRpt);
            sic.add(GLRptVoucherField.entryAsstQuantity);
            sic.add(GLRptVoucherField.entryAsstStandQuantity);
            sic.add(GLRptVoucherField.entryAsstPrice);
        } else {
            sic.add(GLRptVoucherField.entryRecordFor);
            sic.add(GLRptVoucherField.entryRecordLocal);
            sic.add(GLRptVoucherField.entryRecordRpt);
            sic.add(GLRptVoucherField.entryQuantity);
            sic.add(GLRptVoucherField.entryStandQuantity);
            sic.add(GLRptVoucherField.entryPrice);
        }
        if (this.cond.isShowDisplayAsstDetail() || this.cond.isShowOppAsstact()) {
            sic.add(GLRptVoucherField.HGID);
        }
        return sic;
    }

    private void insertDataSourceSQL(String dataSourceTableName, String splitTable) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSelectSQL());
        sql.append(" from ").append(splitTable).append(" t ");
        sql.append(this.getJoinSQL());
        sql.append(this.getWhereSQL());
        GLRptSQLOrder newOrder = new GLRptSQLOrder();
        GLRptSQLOrder order = this.dao.getVoucherSorter();
        for (int i = 0; i < order.size(); ++i) {
            String field = order.get(i).getField();
            if (field.endsWith("FSeq")) continue;
            newOrder.add(field, order.get(i).getOrderType());
        }
        newOrder.add("t.FSeq");
        sql.append(newOrder.getOrderSQL());
        this.dao.insertData(this.getInsertField(), sql.toString());
    }

    protected String[] getInsertField() throws EASBizException, BOSException {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("KSQL_SEQ");
        fields.add("FAccountID");
        if (this.cond.isShowDisplayAsstDetail()) {
            fields.add("FAssGrpId");
        }
        if (this.cond.isShowQty() && (this.cond.getMeasureUnitId() != null || this.cond.isGroupByMU())) {
            fields.add(GLRptVoucherField.asstMeasureUnitID.getName());
        }
        fields.add("FOppAccountID");
        if (this.cond.isShowOppAsstact()) {
            fields.add("FOppAssGrpId");
        }
        fields.add("FBookedDate");
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            fields.add(this.getOrgUnitId());
        }
        fields.add("FPeriod");
        fields.add(GLRptVoucherField.voucherTypeNumber.getName());
        fields.add("voucherId");
        fields.add(GLRptVoucherField.voucherNumber.getName());
        fields.add(GLRptVoucherField.createTime.getName());
        fields.add("entryID");
        if (this.cond.queryVoucherAssistRecordField()) {
            fields.add("assistRecordID");
        }
        fields.add("voucherDescription");
        fields.add("FDescription");
        fields.add("FSelfDescription");
        fields.add("FCreatorName");
        if (this.cond.isAllCurrency()) {
            fields.add("FCurrencyID");
        }
        this.addAmountFieldName(fields);
        fields.add("FBalSeq ");
        fields.add("entryseq");
        fields.add("oppEntryseq");
        if (this.cond.isShowOppAsstact()) {
            fields.add("recordseq");
        }
        return fields.toArray(new String[fields.size()]);
    }

    private String getSelectSQL() throws EASBizException, BOSException {
        String accTab;
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        if (!this.cond.isLeafAccount() || this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append("pav.fid").append(" faccountid ");
        } else {
            sql.append("t.accountid ");
        }
        if (this.cond.isShowDisplayAsstDetail()) {
            sql.append(", t.assGrpid");
        }
        if (this.cond.isShowQty() && (this.cond.getMeasureUnitId() != null || this.cond.isGroupByMU())) {
            sql.append(",").append(GLRptVoucherField.asstMeasureUnitID.getSelect()).append(" ").append(GLRptVoucherField.asstMeasureUnitID.getName());
        }
        sql.append(",t.oppAccountid");
        if (this.cond.isShowOppAsstact()) {
            sql.append(",t.oppAssGrpid");
        }
        sql.append(",voucher.FBookedDate");
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append(",voucher.").append(this.getOrgUnitId());
        }
        sql.append(",t.period");
        sql.append(",").append(GLRptVoucherField.voucherTypeNumber.getSelect()).append(" ").append(GLRptVoucherField.voucherTypeNumber.getName());
        sql.append(",").append(GLRptVoucherField.voucherID.getSelect()).append(" ").append(GLRptVoucherField.voucherID.getName());
        sql.append(",").append(GLRptVoucherField.voucherNumber.getSelect()).append(" ").append(GLRptVoucherField.voucherNumber.getName());
        sql.append(",").append(GLRptVoucherField.createTime.getSelect()).append(" ").append(GLRptVoucherField.createTime.getName());
        sql.append(",").append(GLRptVoucherField.entryID.getSelect()).append(" ").append(GLRptVoucherField.entryID.getName());
        if (this.cond.queryVoucherAssistRecordField()) {
            sql.append(",").append(GLRptVoucherField.asstRecordID.getSelect()).append(" ").append(GLRptVoucherField.asstRecordID.getName());
        }
        String string = accTab = !this.cond.isLeafAccount() || this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details ? "pav" : "account";
        if (this.cond.queryVoucherAssistRecordField() && !this.cond.isShowOppAccount()) {
            sql.append(",case when ").append(accTab).append(".fcaa is null and ").append(accTab).append(".fhasUserProperty <> 1 ");
            sql.append(" then entries.FDescription else assistRecords.FDescription end FDescription");
        } else {
            sql.append(",voucher.FDescription voucherDescription");
            sql.append(",t.Description");
            sql.append(",t.selfDescription");
        }
        sql.append(",creator.FName_").append(this.ctx.getLocale().toString());
        if (this.cond.isAllCurrency()) {
            sql.append(",t.currencyid");
        }
        this.addAmountSelect(sql);
        sql.append(",").append(2).append(" ").append("FBalSeq");
        sql.append(",t.fseq\t");
        sql.append(",t.foppentryseq\t");
        if (this.cond.isShowOppAsstact()) {
            sql.append(",t.foppassrecseq");
        }
        return sql.toString();
    }

    protected String getJoinSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(" INNER JOIN ").append(this.getVoucherTable()).append(" voucher on voucher.fid = t.voucherid ");
        sql.append(" left outer join t_pm_user creator on voucher.fcreatorid = creator.fid ");
        sql.append(" INNER JOIN T_BD_VoucherTypes voucherType on voucher.FVoucherTypeID = voucherType.FID ");
        sql.append(" INNER JOIN ").append(this.getVoucherEntryTable()).append(" entries on entries.fid = t.entryid ");
        sql.append(" INNER JOIN t_bd_accountview account on account.fid = t.accountid ");
        if (!this.cond.isLeafAccount() || this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append(" INNER JOIN t_bd_accountview pav on (");
            if (SQLUtil.isSupportCharIndexToLike(this.ctx)) {
                sql.append(" account.flongnumber like concat(pav.flongnumber, '!%') or ");
            } else {
                sql.append(" charindex(pav.flongnumber||'!', account.flongnumber) = 1 or ");
            }
            if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
                sql.append(" pav.fnumber = account.fnumber) ");
                sql.append(" and pav.fcompanyid = '").append(this.cond.getCompany().getId().toString()).append("'");
            } else {
                sql.append(" pav.fid = account.fid) ");
                sql.append(" and pav.fcompanyid = account.fcompanyid ");
            }
            sql.append(" and pav.faccounttableid = account.faccounttableid ");
        }
        if (this.cond.queryVoucherAssistRecordField()) {
            sql.append(" LEFT OUTER JOIN ").append(this.getVoucherAssistRecordTable()).append(" assistRecords on assistRecords.fid = t.voucherassrecid ");
            if (this.cond.isShowDisplayAsstDetail()) {
                sql.append(" LEFT OUTER JOIN t_bd_assistanthg assGrp on assGrp.fid = t.assGrpid ");
                for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                    sql.append(" LEFT OUTER JOIN ").append(at.getTableName()).append(" ").append(at.getHgAttribute()).append(" on ").append(at.getHgAttribute()).append(".fid ").append(" = ").append("assGrp").append(".").append(at.getHgField());
                    if (!this.cond.isFilterByCat() || at.isBasicCat()) continue;
                    sql.append(" LEFT OUTER JOIN ").append(GLRptDaoUtil.getGroupDetailTable(at)).append(" ").append(at.getHgAttribute()).append("GDet on ").append(at.getHgAttribute()).append("GDet.").append(GLRptDaoUtil.getField(at)).append(" = ").append("assGrp").append(".").append(at.getHgField());
                }
            }
        }
        if (this.cond.isShowOppAsstact()) {
            sql.append(" LEFT OUTER JOIN t_bd_assistanthg ohg on ohg.fid = t.oppAssGrpid ");
        }
        if (this.cond.getMeasureUnitId() != null) {
            sql.append(" and assistRecords.FMeasureUnitID = '").append(this.cond.getMeasureUnitId()).append("'");
        }
        return sql.toString();
    }

    private String getWhereSQL() throws BOSException, EASBizException {
        String asstAccFilter;
        StringBuffer sql = new StringBuffer();
        sql.append(" where ").append(this.cond.isLeafAccount() ? "account" : "pav").append(".fid in (").append(this.cond.getAccountIdFilter()).append(")");
        if (!(this.cond.isAllCurrency() || CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()))) {
            sql.append(" and t.currencyid = '").append(this.cond.getCurrencyID()).append("'");
        }
        if (!this.cond.getAsstActList().isEmpty() && this.cond.isShowDisplayAsstDetail() && (asstAccFilter = new GLRptAsstAccountFilter(this.ctx, this.cond, null, "t.assgrpid", "t." + GLRptField.orgUnitID.getName(), "assGrp", this.cond.getCtx().get((Object)"isPca") != null ? "account.FCAA" : "entries.FCAA", false).getSQL()).trim().length() > 0) {
            sql.append(" and ").append(asstAccFilter);
        }
        if (this.cond.getMeasureUnitId() != null) {
            sql.append(" and assistRecords.FMeasureUnitID = '").append(this.cond.getMeasureUnitId()).append("'");
        }
        return sql.toString();
    }

    protected void addAmountFieldName(List fields) throws EASBizException, BOSException {
        if (this.cond.isShowQty()) {
            fields.add("FSubStandardDebitQty");
            fields.add("FSubStandardCreditQty");
            fields.add("FSubDebitQty");
            fields.add("FSubCreditQty");
        }
        if (this.cond.isShowFor()) {
            fields.add("FSubDebitFor");
            fields.add("FSubCreditFor");
        }
        if (this.cond.isShowLocal()) {
            fields.add("FSubDebitLocal");
            fields.add("FSubCreditLocal");
        }
        if (this.cond.isShowRpt()) {
            fields.add("FSubDebitRpt");
            fields.add("FSubCreditRpt");
        }
    }

    private void addAmountSelect(StringBuffer sql) throws EASBizException, BOSException {
        if (this.cond.isShowQty()) {
            sql.append(", case entries.FEntryDC when 1 then t.standardQty else 0 end FSubStandardDebitQty");
            sql.append(", case entries.FEntryDC when 1 then 0 else t.standardQty end FSubStandardCreditQty");
            sql.append(", case entries.FEntryDC when 1 then t.quantity else 0 end FSubDebitQty");
            sql.append(", case entries.FEntryDC when 1 then 0 else t.quantity end FSubCreditQty");
        }
        if (this.cond.isShowFor()) {
            sql.append(",case entries.FEntryDC when 1 then t.originalAmount else 0 end FSubDebitFor");
            sql.append(",case entries.FEntryDC when 1 then 0 else t.originalAmount end FSubCreditFor");
        }
        if (this.cond.isShowLocal()) {
            sql.append(",case entries.FEntryDC when 1 then t.localAmount else 0 end FSubDebitLocal");
            sql.append(",case entries.FEntryDC when 1 then 0 else t.localAmount end FSubCreditLocal");
        }
        if (this.cond.isShowRpt()) {
            sql.append(",case entries.FEntryDC when 1 then t.reportingAmount else 0 end FSubDebitRpt");
            sql.append(",case entries.FEntryDC when 1 then 0 else t.reportingAmount end FSubCreditRpt");
        }
    }

    protected void addAsstCustomizedPropName(AssistCustomizedPropertyCollection coll, List fields) {
        if (coll != null) {
            if (this.contains(coll, "bizNumber")) {
                fields.add("FBizNumber");
            }
            if (this.contains(coll, "invoiceNumber")) {
                fields.add("FInvoiceNumber");
            }
            if (this.contains(coll, "settlementCode")) {
                fields.add("FSettlementCode");
            }
            if (this.contains(coll, "settleTypeName")) {
                fields.add("FSettlementTypeID");
            }
            if (this.contains(coll, "ticketNumber")) {
                fields.add("FTicketNumber");
            }
            if (this.contains(coll, "feeType")) {
                fields.add("feeType");
            }
            if (this.contains(coll, "handler")) {
                fields.add("receiverID");
            }
        }
    }

    protected AssistCustomizedPropertyCollection getAsstCustomizedProp() throws BOSException {
        AssistCustomizedPropertyCollection coll = null;
        if (this.cond.isShowAccountAttribute()) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("customizedtype.number"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(this.getAccountIDFilterItemInfo());
            view.setFilter(filter);
            coll = AssistCustomizedPropertyFactory.getLocalInstance(this.ctx).getAssistCustomizedPropertyCollection(view);
        }
        return coll;
    }

    private FilterItemInfo getAccountIDFilterItemInfo() throws BOSException {
        Set<String> accountIdSet = this.cond.getAccountIdSet();
        if (accountIdSet.size() > 500) {
            return new FilterItemInfo("account.id", (Object)this.cond.getAccountIdFilter(), CompareType.INNER);
        }
        return new FilterItemInfo("account.id", accountIdSet, CompareType.INCLUDE);
    }

    protected boolean contains(AssistCustomizedPropertyCollection coll, String prop) {
        if (prop == null) {
            return false;
        }
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            if (!prop.equals(((AssistCustomizedPropertyInfo)it.next()).getCustomizedType().getNumber())) continue;
            return true;
        }
        return false;
    }

    private GLRptSQLOrder getOrder() {
        GLRptSQLOrder sorter = new GLRptSQLOrder();
        sorter.add(GLRptVoucherField.voucherID.getSelect());
        sorter.add(GLRptVoucherField.entrySeq.getSelect());
        if (this.cond.isShowDisplayAsstDetail() || this.cond.isShowOppAsstact() || this.cond.isShowAccountAttribute()) {
            sorter.add(GLRptVoucherField.asstRecordSeq.getSelect());
        }
        return sorter;
    }

    private String createSplitTempTable() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("voucherid varchar(44), entryid varchar(44), accountid varchar(44)");
        sql.append(", oppAccountid varchar(44), period int, currencyid varchar(44)");
        sql.append(", description nvarchar(2000)");
        if (this.cond.isShowOppAccount() || this.cond.isShowOppAsstact()) {
            sql.append(",selfDescription nvarchar(2000)");
        }
        if (this.cond.queryVoucherAssistRecordField()) {
            sql.append(",voucherassrecid varchar(44)");
        }
        if (this.cond.isShowDisplayAsstDetail()) {
            sql.append(",assGrpid varchar(44)");
        }
        if (this.cond.isShowOppAsstact()) {
            sql.append(",oppAssGrpid varchar(44)");
        }
        if (this.cond.isShowFor()) {
            sql.append(",originalAmount NUMERIC(29,10)");
        }
        if (this.cond.isShowLocal()) {
            sql.append(",localAmount NUMERIC(29,10)");
        }
        if (this.cond.isShowRpt()) {
            sql.append(",reportingAmount NUMERIC(29,10)");
        }
        if (this.cond.isShowQty()) {
            sql.append(",quantity NUMERIC(29,10),standardQty NUMERIC(29,10)");
        }
        sql.append(",fseq int");
        sql.append(",foppEntrySeq int");
        if (this.cond.isShowOppAsstact()) {
            sql.append(",foppassrecSeq int");
        }
        return GLTempTableUtil.createDBSysTempTable(this.ctx, sql.toString());
    }

    private String getInsertSQL(String splitTable) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(splitTable).append("(");
        sql.append("voucherid, entryid, accountid, oppAccountid, period, currencyid,description");
        if (this.cond.isShowOppAccount() || this.cond.isShowOppAsstact()) {
            sql.append(",selfDescription");
        }
        if (this.cond.queryVoucherAssistRecordField()) {
            sql.append(",voucherassrecid");
        }
        if (this.cond.isShowDisplayAsstDetail()) {
            sql.append(",assGrpid");
        }
        if (this.cond.isShowOppAsstact()) {
            sql.append(",oppAssGrpid");
        }
        if (this.cond.isShowFor()) {
            sql.append(",originalAmount");
        }
        if (this.cond.isShowLocal()) {
            sql.append(",localAmount");
        }
        if (this.cond.isShowRpt()) {
            sql.append(",reportingAmount");
        }
        if (this.cond.isShowQty()) {
            sql.append(",quantity,standardQty");
        }
        sql.append(",fseq,Foppentryseq");
        if (this.cond.isShowOppAsstact()) {
            sql.append(",foppassrecSeq ");
        }
        sql.append(" ) values (?, ?, ?, ?, ? ,?,?");
        if (this.cond.isShowOppAccount() || this.cond.isShowOppAsstact()) {
            sql.append(",?");
        }
        if (this.cond.queryVoucherAssistRecordField()) {
            sql.append(",?");
        }
        if (this.cond.isShowDisplayAsstDetail()) {
            sql.append(",?");
        }
        if (this.cond.isShowOppAsstact()) {
            sql.append(",?");
        }
        if (this.cond.isShowFor()) {
            sql.append(",?");
        }
        if (this.cond.isShowLocal()) {
            sql.append(",?");
        }
        if (this.cond.isShowRpt()) {
            sql.append(",?");
        }
        if (this.cond.isShowQty()) {
            sql.append(",?, ?");
        }
        sql.append(",?,?");
        if (this.cond.isShowOppAsstact()) {
            sql.append(",?");
        }
        sql.append(")");
        return sql.toString();
    }

    private void setParams(PreparedStatement stmt, GLRptVoucherEntryInfo entry, GLRptVoucherEntryInfo oppEntry) throws EASBizException, BOSException, SQLException {
        int index = 1;
        stmt.setString(index++, entry.getVoucherId());
        stmt.setString(index++, entry.getEntryId());
        stmt.setString(index++, entry.getAccountId());
        stmt.setString(index++, oppEntry.getAccountId());
        stmt.setInt(index++, entry.getPeriod());
        stmt.setString(index++, entry.getCurrencyId());
        if (this.cond.isShowOppAsstact()) {
            stmt.setString(index++, oppEntry.getAssistDesc());
            stmt.setString(index++, entry.getAssistDesc());
        } else {
            stmt.setString(index++, oppEntry.getEntryDesc());
            stmt.setString(index++, entry.getEntryDesc());
        }
        if (this.cond.queryVoucherAssistRecordField()) {
            stmt.setString(index++, entry.getAssitRecordId());
        }
        if (this.cond.isShowDisplayAsstDetail()) {
            stmt.setString(index++, entry.getHgId());
        }
        if (this.cond.isShowOppAsstact()) {
            stmt.setString(index++, oppEntry.getHgId());
        }
        if (this.cond.isShowFor()) {
            stmt.setBigDecimal(index++, entry.getOriginalAmount());
        }
        if (this.cond.isShowLocal()) {
            stmt.setBigDecimal(index++, entry.getLocalAmount());
        }
        if (this.cond.isShowRpt()) {
            stmt.setBigDecimal(index++, entry.getReportingAmount());
        }
        if (this.cond.isShowQty()) {
            stmt.setBigDecimal(index++, entry.getQuantity());
            stmt.setBigDecimal(index++, entry.getStandardQuantity());
        }
        stmt.setInt(index++, entry.getEntriesSeq());
        stmt.setInt(index++, oppEntry.getEntriesSeqReal());
        if (this.cond.isShowOppAsstact()) {
            stmt.setInt(index, oppEntry.getAsstRecSeq());
        }
    }

    protected GLRptSubLedgerVoucherQuery getRptSubLedgerVoucherQuery(Context ctx, CompanyOrgUnitInfo company, GLRptSubLedgerCondition cond, boolean isOnlyQty) {
        return new GLRptSubLedgerVoucherQuery(ctx, company, cond, false);
    }

    protected String getOrgUnitId() {
        return "FCompanyID";
    }

    protected String getVoucherTable() {
        return "T_GL_Voucher";
    }

    protected String getVoucherEntryTable() {
        return "T_GL_VoucherEntry";
    }

    protected String getVoucherAssistRecordTable() {
        return "T_GL_VoucherAssistRecord";
    }
}

