/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLRptVoucherAssistQuery
extends GLRptQuery {
    private static final Logger logger = CoreUIObject.getLogger(GLRptVoucherAssistQuery.class);
    private static final String ACCOUNT_VIEW_PERM = "bd_account_accountView_view";
    private static final int ACCOUNT_COUNT_MAX = 500;
    private String extraFilter;
    private boolean isAccountFilter = true;
    private boolean isDistinct = false;
    protected boolean isOnlyQty = false;
    private boolean useHint = false;
    private GLRptSQLOrder order;

    public GLRptVoucherAssistQuery(Context ctx, GLRptAsstactBaseCondition cond, boolean isOnlyQty) {
        super(ctx, cond);
        this.isOnlyQty = isOnlyQty;
    }

    public void setFilter(String extraFilter) {
        this.extraFilter = extraFilter;
    }

    public void setAccountFilter(boolean isAccountFilter) {
        this.isAccountFilter = isAccountFilter;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public boolean isUseHint() {
        String hint = null;
        GLRptBaseCondition threadCondition = GLTempTableUtil.getCondition();
        if (threadCondition != null) {
            hint = threadCondition.getExtendParam("VoucherQuery_Hint");
        }
        if (hint != null && hint.trim().length() > 0) {
            return true;
        }
        return this.useHint;
    }

    public void setUseHint(boolean useHint) {
        this.useHint = useHint;
    }

    protected void setOrder(GLRptSQLOrder order) {
        this.order = order;
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        return this.order;
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        String querySql = super.getSQL();
        if (this.getCond() == null) {
            return querySql;
        }
        int fromIndex = querySql.indexOf("FROM ");
        int whereIndex = querySql.indexOf("WHERE ");
        int groupByIndex = querySql.indexOf("GROUP BY ");
        int orderIndex = querySql.indexOf("ORDER BY ");
        String selectSql = querySql.substring(0, fromIndex);
        String fromSql = querySql.substring(fromIndex, whereIndex);
        String whereSql = querySql.substring(whereIndex);
        if (groupByIndex != -1) {
            whereSql = querySql.substring(whereIndex, groupByIndex);
        } else if (orderIndex != -1) {
            whereSql = querySql.substring(whereIndex, orderIndex);
        }
        String gropyBySql = null;
        if (groupByIndex != -1) {
            gropyBySql = orderIndex == -1 ? querySql.substring(groupByIndex) : querySql.substring(groupByIndex, orderIndex);
        }
        String orderSql = null;
        if (orderIndex != -1) {
            orderSql = querySql.substring(orderIndex);
        }
        return this.composeSQL(selectSql, fromSql, whereSql, gropyBySql, orderSql);
    }

    protected void setPeriodFilter(StringBuffer filter, boolean isFromBeginPeriod) throws BOSException, EASBizException {
        this.addFilterItem(filter, GLRptVoucherField.periodID.getSelect() + " in " + this.getCond().getPeriodIdStr(isFromBeginPeriod));
        if (this.getCtx().get((Object)"isPca") == null) {
            this.addFilterItem(filter, "entries." + GLRptVoucherField.periodID + " in " + this.getCond().getPeriodIdStr(isFromBeginPeriod));
        }
    }

    protected void setCompanyFilter(StringBuffer filter) throws BOSException {
        this.addFilterItem(filter, "voucher." + this.getOrgUnitField() + " in " + this.getCond().getCompanyIdsStr());
        if (this.getCtx().get((Object)"isPca") == null) {
            this.addFilterItem(filter, "entries." + this.getOrgUnitField() + " in " + this.getCond().getCompanyIdsStr());
        }
    }

    protected void setSourceTypeFilter(StringBuffer filter) {
        if (this.getCond().isNotIncluePLVoucher()) {
            this.addFilterItem(filter, "voucher.FSourceType != 1");
        }
    }

    protected void setCurrencyFilter(StringBuffer filter) {
        GLRptAsstactBaseCondition cond = this.getCond();
        if (!(cond.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(cond.getCurrencyID()) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(cond.getCurrencyID()))) {
            this.addFilterItem(filter, GLRptVoucherField.currencyID.getSelect() + " = '" + this.getCond().getCurrencyID() + "'");
        }
    }

    protected void setStatusFilter(StringBuffer filter) {
        String statusValue = null;
        statusValue = this.getCond().getOptionPosting() ? "1,3,5" : "5";
        this.addFilterItem(filter, GLRptVoucherField.bizStatus.getSelect() + " in (" + statusValue + ")");
    }

    protected void addFilterItem(StringBuffer filters, String filterItem) {
        if (StringUtils.isEmpty((String)filterItem)) {
            return;
        }
        if (filters.length() > 0) {
            filters.append(" AND ");
        }
        filters.append(filterItem);
    }

    @Override
    protected String getSelectSQL() throws EASBizException, BOSException {
        if (this.getSelector() == null || this.getSelector().isEmpty()) {
            throw new BOSException("The query selector is temp!");
        }
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getSelect() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            sql.append(this.getSelectField(field));
        }
        return sql.toString();
    }

    protected String getSelectField(GLRptField field) {
        String select = field.getSelect();
        if (field.isMultiLang()) {
            select = select + "_" + this.getCtx().getLocale().toString();
        }
        if (select.startsWith("hg.")) {
            select = select.replaceFirst("hg", "assGrp");
        }
        return select + " " + field.getName();
    }

    @Override
    protected String getFromSQL() throws BOSException, EASBizException {
        return this.getVoucherTable() + " voucher ";
    }

    protected String getJoinVoucherEntrySql() throws BOSException, EASBizException {
        String joinSql = " entries ON voucher.FID = entries.FBillID ";
        if (this.getCtx().get((Object)"isPca") == null) {
            boolean join = false;
            GLRptBaseCondition threadCondition = GLTempTableUtil.getCondition();
            String v = null;
            if (threadCondition != null) {
                v = threadCondition.getExtendParam("VoucherQuery_EntryJoinOn_CompanyAndPeriod");
            }
            if ("true".equalsIgnoreCase(v)) {
                join = true;
            }
            if (join) {
                joinSql = joinSql + " and voucher.FCompanyID = entries.FCompanyID and voucher.FPeriodID = entries.FPeriodID ";
            }
        }
        return joinSql;
    }

    protected String getJoinVoucherAssistRecordSql() throws BOSException, EASBizException {
        String joinSql = " LEFT OUTER JOIN " + this.getVoucherAssistRecordTable() + " assistRecords ON entries.FID = assistRecords.FEntryID ";
        boolean onAccount = false;
        if (this.getCtx().get((Object)"isPca") == null) {
            boolean onCompany = false;
            GLRptBaseCondition threadCondition = GLTempTableUtil.getCondition();
            String v = null;
            if (threadCondition != null) {
                v = threadCondition.getExtendParam("VoucherQuery_AssistJoinOn_CompanyAndPeriod");
            }
            if ("true".equalsIgnoreCase(v)) {
                onCompany = true;
            }
            if (onCompany) {
                joinSql = joinSql + " and entries.FCompanyID = assistRecords.FCompanyID and entries.FPeriodID = assistRecords.FPeriodID ";
            }
            if (onCompany && this.getCond() != null && this.getCond().getProfitCenter() == null && "true".equalsIgnoreCase(v = threadCondition.getExtendParam("VoucherQuery_AssistJoinOn_Account"))) {
                onAccount = true;
            }
        }
        if (onAccount) {
            return joinSql + "     and entries.FAccountID = assistRecords.FAccountID ";
        }
        return joinSql;
    }

    protected String getJoinAsstAccountSql() {
        if (this.getCtx().get((Object)"isPca") != null) {
            return " LEFT OUTER JOIN T_BD_AsstAccount CAA ON entries.account = CAA.FID ";
        }
        return " LEFT OUTER JOIN T_BD_AsstAccount CAA ON entries.FCAA = CAA.FID ";
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" LEFT OUTER JOIN ").append(this.getOrgUnitTable()).append(" company ON voucher.").append(this.getOrgUnitField()).append(" = company.FID ");
        sql.append(" INNER JOIN ").append(this.getVoucherEntryTable()).append(this.getJoinVoucherEntrySql());
        sql.append(" LEFT OUTER JOIN T_BD_VoucherTypes voucherType ON voucher.FVoucherTypeID = voucherType.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Period period ON voucher.FPeriodID = period.FID ");
        sql.append(" LEFT OUTER JOIN T_PM_User auditor ON voucher.FAuditorID = auditor.FID ");
        sql.append(" LEFT OUTER JOIN T_PM_User handler ON voucher.FHandlerID = handler.FID ");
        sql.append(" LEFT OUTER JOIN T_PM_User creator ON voucher.FCreatorID = creator.FID ");
        sql.append(" LEFT OUTER JOIN T_PM_User poster ON voucher.FPosterID = poster.FID ");
        sql.append(" LEFT OUTER JOIN T_PM_User canceller ON voucher.FCancellerID = canceller.FID ");
        sql.append(" LEFT OUTER JOIN T_PM_User cashier ON voucher.FCashierID = cashier.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView account ON entries.FAccountID = account.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency currency ON entries.FCurrencyID = currency.FID ");
        sql.append(this.getJoinVoucherAssistRecordSql());
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit entryMeasureUnit ON entries.FMeasureUnitID = entryMeasureUnit.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountTable accountTable ON account.FAccountTableID = accountTable.FID ");
        sql.append(this.getJoinAsstAccountSql());
        sql.append(" LEFT OUTER JOIN T_BD_AssistantHG assGrp ON assistRecords.FAssGrpID = assGrp.FID ");
        if (this.getCond() != null) {
            for (AsstactTypeEntity at : this.getCond().getAsstActList()) {
                sql.append(" LEFT OUTER JOIN ").append(at.getTableName()).append(" ").append(at.getHgAttribute()).append(" on ").append(at.getHgAttribute()).append(".fid ").append(" = ").append("assGrp").append(".").append(at.getHgField());
                if (!this.getCond().isFilterByCat() || at.isBasicCat()) continue;
                sql.append(" LEFT OUTER JOIN ").append(GLRptDaoUtil.getGroupDetailTable(at)).append(" ").append(at.getHgAttribute()).append("GDet on ").append(at.getHgAttribute()).append("GDet.").append(GLRptDaoUtil.getField(at)).append(" = ").append("assGrp").append(".").append(at.getHgField());
            }
        }
        sql.append(" LEFT OUTER JOIN T_BD_SettlementType settlementType ON assistRecords.FSettlementTypeID = settlementType.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit asstMeasureUnit ON assistRecords.FMeasureUnitID = asstMeasureUnit.FID ");
        sql.append(" LEFT OUTER JOIN T_PM_User receiver ON assistRecords.FHandlerID = receiver.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AsstAccount asstAccount ON assGrp.FAsstAccountID = asstAccount.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_CUSTOMER accountAttributeCustomer on accountAttributeCustomer.fid = assistRecords.FCustomerID");
        sql.append(" LEFT OUTER JOIN T_BD_SUPPLIER accountAttributeSupplier on accountAttributeSupplier.fid = assistRecords.FSupplierID");
        sql.append(" LEFT OUTER JOIN T_BD_MATERIAL accountAttributeMaterial on accountAttributeMaterial.fid = assistRecords.FMaterialID");
        return sql.toString();
    }

    protected String composeSQL(String select, String fromSql, String whereSql, String gropyBySql, String orderSql) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT ");
        if (this.isDistinct()) {
            sql.append(" distinct ");
        }
        sql.append(select.trim().substring(6));
        sql.append(" ").append(fromSql);
        sql.append(" ").append(whereSql);
        if (gropyBySql != null) {
            sql.append(" ").append(gropyBySql);
        }
        if (orderSql != null) {
            sql.append(" ").append(orderSql);
        }
        try {
            if (this.isOptimize()) {
                String rsSql = KSqlUtil.optimize((String)sql.toString());
                if (this.isUseHint()) {
                    return "SELECT " + this.getHint() + " " + rsSql.substring(6);
                }
                return rsSql;
            }
            return sql.toString();
        }
        catch (SqlTranslateException e) {
            throw new BOSException("Sql optimize error!", (Throwable)e);
        }
    }

    @Override
    protected String getHint() {
        GLRptBaseCondition threadCondition = GLTempTableUtil.getCondition();
        String hint = null;
        if (threadCondition != null) {
            hint = threadCondition.getExtendParam("VoucherQuery_Hint");
        }
        if (hint != null && hint.trim().length() > 0) {
            return SQLUtil.buildHint(hint);
        }
        return super.getHint();
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String filter = null;
        if (this.getCond() != null) {
            filter = this.getQueryFilter();
            EntityViewInfo selfCond = this.getCond().getSelfCond();
            if (selfCond != null && selfCond.getFilter() != null && !selfCond.getFilter().getFilterItems().isEmpty()) {
                for (FilterItemInfo info : selfCond.getFilter().getFilterItems()) {
                    if ((info.getPropertyName().equalsIgnoreCase("bizDate") || info.getPropertyName().equalsIgnoreCase("bookedDate")) && info.getCompareValue() instanceof String) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            info.setCompareValue((Object)format.parse((String)info.getCompareValue()));
                        }
                        catch (ParseException e) {
                            logger.error((Object)"parse date error when building where sql, ", (Throwable)e);
                        }
                    }
                    if (info.getPropertyName().contains(".")) continue;
                    info.setPropertyName("voucher.F" + info.getPropertyName());
                }
                String selfFilter = selfCond.getFilter().toSql();
                selfFilter = selfFilter.replaceAll("entries.", " entries.F");
                selfFilter = selfFilter.replaceAll("assistRecords.", " assistRecords.F");
                selfFilter = selfFilter.replaceAll("settlementType.", " settlementType.F");
                selfFilter = selfFilter.replaceAll(".name", ".FName_" + this.getCtx().getLocale().toString());
                filter = filter + " AND (" + selfFilter + ")";
            }
        }
        if (this.extraFilter != null) {
            filter = filter == null ? this.extraFilter : filter + " and " + this.extraFilter;
        }
        return filter;
    }

    protected String getQueryFilter() throws EASBizException, BOSException {
        StringBuffer filter = new StringBuffer();
        this.setCompanyFilter(filter);
        this.setStatusFilter(filter);
        this.setPeriodFilter(filter, this.isFromBeginPeriod());
        this.setCurrencyFilter(filter);
        if (this.isAccountFilter) {
            this.setAccountFilter(filter);
        }
        this.setAsstactFilter(filter);
        this.setMeasureUnitFilter(filter);
        this.setSourceTypeFilter(filter);
        return filter.toString();
    }

    protected void setAccountFilter(StringBuffer filter) throws EASBizException, BOSException {
        StringBuffer accountFilter = new StringBuffer();
        if (this.isOnlyQty) {
            this.addFilterItem(accountFilter, "account.FIsQty = 1");
        }
        if (!this.getCond().getAccountIdSet().isEmpty()) {
            this.setAccountIDFilter(accountFilter);
        } else {
            this.setAccountTableFilter(accountFilter);
            this.setAccountNumberFilter(accountFilter);
            Set asstAccountIdSet = this.getCond().getAsstAccountIdSet();
            if (asstAccountIdSet.isEmpty()) {
                this.setAccountDataPermFilter(accountFilter, GLRptVoucherField.accountID.getSelect());
            } else {
                this.setAccountDataPermFilter(accountFilter, "account.fid");
                if (this.getCond().getProfitCenter() != null) {
                    String proIds = this.getCond().getProfitCenterIdsStr().replaceAll("'", "").substring(1, this.getCond().getProfitCenterIdsStr().replaceAll("'", "").length() - 1);
                    CompanyOrgUnitInfo[] coms = new CompanyOrgUnitInfo[]{};
                    try {
                        coms = PcaUtils.getRelatedAndAccountingCompany((Context)this.getCtx(), (String)proIds);
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e);
                    }
                    String comIds = "";
                    for (int i = 0; i < coms.length; ++i) {
                        comIds = comIds.length() == 0 ? "'" + coms[i].getId().toString() + "'" : comIds + ",'" + coms[i].getId().toString() + "'";
                    }
                    String sql = "select fid from t_bd_accountview where  fcompanyid in (" + comIds + ")";
                    String accFilter = " and account.FID in (" + sql + ")";
                    accountFilter.append(accFilter);
                } else {
                    String transformFilter = this.transformAccountFilter(accountFilter.toString());
                    accountFilter.setLength(0);
                    accountFilter.append(transformFilter);
                }
            }
        }
        this.addFilterItem(filter, accountFilter.toString());
    }

    protected String transformAccountFilter(String oldFilter) throws EASBizException, BOSException {
        String filter = (String)GLTempTableUtil.getContextObject("ACCOUNT_FILTER");
        if (filter != null) {
            return filter;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select account.FID ");
        sql.append("from T_BD_AccountView account ");
        sql.append("LEFT OUTER JOIN T_BD_AsstAccount CAA ON account.FCAA = CAA.FID ");
        sql.append("where " + oldFilter);
        sql.append(" and account.FCompanyID in " + this.getCond().getCompanyIdsStr());
        String opsql = sql.toString();
        if (this.isOptimize()) {
            try {
                opsql = KSqlUtil.optimize((String)opsql);
            }
            catch (SqlTranslateException e) {
                throw new BOSException("Sql optimize error!", (Throwable)e);
            }
        }
        opsql = "select top 501" + opsql.substring(6);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)opsql);
            if (rs.size() <= 500) {
                HashSet<String> ids = new HashSet<String>();
                while (rs.next()) {
                    ids.add(rs.getString("FID"));
                }
                filter = "account.FID in " + GLRptDaoUtil.set2String(ids);
            } else {
                filter = oldFilter;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        GLTempTableUtil.setContextObject("ACCOUNT_FILTER", filter);
        return filter;
    }

    protected void setAccountDataPermFilter(StringBuffer filter, String field) throws EASBizException, BOSException {
        if (this.getCond().getRptParams().useAccountPermission()) {
            GLRptAsstactBaseCondition cond = this.getCond();
            CompanyDisplayModeEnum companyDisplayMode = cond.getCompanyDisplayMode();
            String fieldCompany = GLRptVoucherField.companyID.getSelect();
            String item = GLRptDaoUtil.getDataPermFilter(this.getCtx(), companyDisplayMode, cond.getCompany(), cond.getCompanyIdsStr(), ACCOUNT_VIEW_PERM, false, field, fieldCompany);
            this.addFilterItem(filter, item);
        }
    }

    protected void setAccountCompanyFilter(StringBuffer filter) throws BOSException {
        this.addFilterItem(filter, "account.FCompanyID in " + this.getCond().getCompanyIdsStr());
    }

    protected void setAccountNumberFilter(StringBuffer filter) {
        if (this.getCond().isInputCodeStart()) {
            String[] starAcc = this.getCond().getAccountCodeStart().split(",");
            if (starAcc.length > 1) {
                this.addFilterItem(filter, "(account.FNumber in " + GLRptDaoUtil.StringArray2String(starAcc) + " or account.FNumber > '" + starAcc[starAcc.length - 1] + "')");
            } else {
                this.addFilterItem(filter, "account.FNumber >= '" + starAcc[0] + "'");
            }
        }
        if (this.getCond().isInputCodeEnd()) {
            String[] endAcc = this.getCond().getAccountCodeEnd().split(",");
            if (endAcc.length > 1) {
                this.addFilterItem(filter, "(account.FNumber in " + GLRptDaoUtil.StringArray2String(endAcc) + " or account.FNumber < '" + endAcc[endAcc.length - 1] + "ZZ')");
            } else {
                this.addFilterItem(filter, "account.FNumber <= '" + endAcc[0] + "ZZ'");
            }
        }
    }

    protected void setAccountTableFilter(StringBuffer filter) throws BOSException {
        this.addFilterItem(filter, "account.FAccountTableID = '" + this.getCond().getAccountTableId() + "'");
    }

    protected boolean isFromBeginPeriod() {
        return false;
    }

    private void setMeasureUnitFilter(StringBuffer filter) throws EASBizException, BOSException {
        if (this.getCond().getMeasureUnitId() != null) {
            if (this.getCond().getRptParams().isQtyAsst()) {
                this.addFilterItem(filter, GLRptVoucherField.asstMeasureUnitID.getSelect() + " = '" + this.getCond().getMeasureUnitId() + "'");
            } else {
                this.addFilterItem(filter, GLRptVoucherField.entryMeasureUnitID.getSelect() + " = '" + this.getCond().getMeasureUnitId() + "'");
            }
        }
    }

    protected void setAccountIDFilter(StringBuffer filter) throws BOSException {
        if (this.getCond().getProfitCenter() != null) {
            String proIds = this.getCond().getProfitCenterIdsStr().replaceAll("'", "").substring(1, this.getCond().getProfitCenterIdsStr().replaceAll("'", "").length() - 1);
            CompanyOrgUnitInfo[] coms = new CompanyOrgUnitInfo[]{};
            try {
                coms = PcaUtils.getRelatedAndAccountingCompany((Context)this.getCtx(), (String)proIds);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            String comIds = "";
            for (int i = 0; i < coms.length; ++i) {
                comIds = comIds.length() == 0 ? "'" + coms[i].getId().toString() + "'" : comIds + ",'" + coms[i].getId().toString() + "'";
            }
            String sql = "select fid from t_bd_accountview where fnumber in (select fnumber from t_bd_accountview av where av.fid IN (" + this.getCond().getAccountIdFilter() + ") ) and fcompanyid in (" + comIds + ")";
            this.addFilterItem(filter, GLRptVoucherField.accountID.getSelect() + " in (" + sql + ")");
        } else {
            this.addFilterItem(filter, GLRptVoucherField.accountID.getSelect() + " in (" + this.getCond().getAccountIdFilter() + ")");
        }
    }

    protected void setAsstactFilter(StringBuffer filter) throws BOSException, EASBizException {
        boolean isFilterAsstDataPermission;
        GLRptAsstactBaseCondition cond = this.getCond();
        boolean bl = isFilterAsstDataPermission = !cond.getAsstActList().isEmpty() || cond instanceof GLRptSubLedgerCondition && ((GLRptSubLedgerCondition)cond).isShowDisplayAsstDetail();
        if (isFilterAsstDataPermission) {
            this.setAsstDataPermissionFilter(filter);
        }
        if (cond.getAsstActList().isEmpty()) {
            return;
        }
        GLRptAsstAccountFilter asstFilter = this.getAsstAccountFilter();
        String sql = asstFilter.getSQL();
        if (!StringUtils.isEmpty((String)sql)) {
            this.addFilterItem(filter, sql);
        }
    }

    protected GLRptAsstAccountFilter getAsstAccountFilter() throws EASBizException, BOSException {
        GLRptAsstactBaseCondition cond = this.getCond();
        GLRptAsstAccountFilter asstFilter = new GLRptAsstAccountFilter(this.getCtx(), cond, this.getSelector(), GLRptVoucherField.HGID.getSelect(), GLRptVoucherField.companyID.getSelect(), GLRptDataTable.HG.getAlias(), this.getCtx().get((Object)"isPca") != null ? "account.FCAA" : "entries.FCAA", this.isOnlyQty);
        return asstFilter;
    }

    protected boolean setAsstDataPermissionFilter(StringBuffer filter) throws EASBizException, BOSException {
        boolean existAsstDataPerm = false;
        GLRptAsstactBaseCondition cond = this.getCond();
        if (!cond.getRptParams().useAccountPermission()) {
            return existAsstDataPerm;
        }
        String strPermItem = null;
        CompanyDisplayModeEnum companyDisplayMode = cond.getCompanyDisplayMode();
        String fieldCompany = GLRptVoucherField.companyID.getSelect();
        for (AsstactTypeEntity at : cond.getAsstActList()) {
            if (at.getPermissionItem() == null) continue;
            try {
                strPermItem = at.getPermissionItem();
                String field = "assGrp." + at.getHgField();
                boolean isPermissionByCU = GLRptDaoUtil.checkIfPermissionByCU(this.getCtx(), strPermItem);
                String item = GLRptDaoUtil.getDataPermFilter(this.getCtx(), companyDisplayMode, cond.getCompany(), cond.getCompanyIdsStr(), strPermItem, isPermissionByCU, field, fieldCompany);
                if (StringUtils.isEmpty((String)item)) continue;
                this.addFilterItem(filter, item);
                existAsstDataPerm = true;
            }
            catch (Exception e) {
                logger.error((Object)"Get permission sql error!", (Throwable)e);
            }
        }
        return existAsstDataPerm;
    }

    protected String getActLongNumber(AsstactTypeEntity at, Object value) throws BOSException, EASBizException {
        if (value instanceof DataBaseInfo) {
            DataBaseInfo obj = (DataBaseInfo)value;
            if (at.isUseLongNumber()) {
                return obj.get("longnumber").toString();
            }
            return obj.get("number").toString();
        }
        return value.toString();
    }

    @Override
    public GLRptAsstactBaseCondition getCond() {
        return (GLRptAsstactBaseCondition)super.getCond();
    }

    protected String getVoucherTable() {
        return "T_GL_Voucher";
    }

    protected String getVoucherEntryTable() {
        return "T_GL_VoucherEntry";
    }

    protected String getVoucherAssistRecordTable() {
        return "T_GL_VoucherAssistRecord";
    }

    protected String getOrgUnitTable() {
        return "T_ORG_Company";
    }

    protected String getOrgUnitField() {
        return "FCompanyID";
    }
}

