/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptCompanyFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPeriodFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import java.util.Iterator;

public class GLRptVoucherAsstactQuery
extends GLRptQuery {
    private boolean isAccountFilter = true;
    protected CompanyOrgUnitInfo company;

    public GLRptVoucherAsstactQuery(Context ctx, OrgUnitInfo org, GLRptAsstactBaseCondition cond) throws EASBizException, BOSException {
        super(ctx, cond);
        this.initSetMainTable();
        this.initOrgUnit(ctx, org, cond);
    }

    protected void initSetMainTable() {
        this.setMainTable(GLRptDataTable.VOUCHERASSISTRECORD);
    }

    protected void initOrgUnit(Context ctx, OrgUnitInfo org, GLRptAsstactBaseCondition cond) {
        this.company = (CompanyOrgUnitInfo)org;
    }

    public GLRptAsstAccountFilter getGLRptAsstAccountFilter() throws EASBizException, BOSException {
        return new GLRptAsstAccountFilter(this.getCtx(), this.getCond(), this.getSelector(), GLRptVoucherField.HGID.getSelect(), GLRptVoucherField.companyID.getSelect());
    }

    @Override
    protected String getSelectSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getType() == "NUMERIC(29,10)") {
                sql.append(this.getAmountSelectSQL(field));
                continue;
            }
            sql.append(field.getSelect());
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale());
            }
            sql.append(" ").append(field.getName());
        }
        return sql.toString();
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" inner join t_gl_voucher v on r.fbillid = v.fid \r\n");
        sql.append(" inner join t_gl_voucherentry ve on r.fentryid = ve.fid \r\n");
        GLRptAsstactBaseCondition cond = this.getCond();
        if (!cond.getCompany().isIsBizUnit() && (this.getSelector().contains(GLRptVoucherField.accountID) || this.getSelector().contains(GLRptField.accountID))) {
            sql.append(" inner join t_bd_accountview lav on lav.fid = ve.faccountid and lav.fcompanyid = v.fcompanyid \r\n");
            sql.append(" inner join t_bd_accountview av on ");
            if (SQLUtil.isSupportCharIndexToLike(this.getCtx())) {
                sql.append(" (lav.flongnumber like concat(av.flongnumber, '!%') or av.fnumber = lav.fnumber) ");
            } else {
                sql.append(" (charindex(av.flongnumber||'!', lav.flongnumber) = 1 or av.fnumber = lav.fnumber) ");
            }
            sql.append(" and lav.faccounttableid = av.faccounttableid and av.fcompanyid ='").append(cond.getCompany().getId().toString()).append("'");
            if (cond.isLeafAccount()) {
                sql.append(" and av.fisleaf = 1");
            } else {
                sql.append(" and av.flevel <= ").append(cond.getAccountLevelEnd());
            }
        } else {
            sql.append(" left outer join t_bd_accountview av on av.fid = ve.faccountid and av.fcompanyid = v.fcompanyid \r\n");
        }
        sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid \r\n");
        sql.append(" left outer join t_bd_assistanthg hg on hg.fid = r.fassgrpid \r\n");
        sql.append(" left outer join T_BD_Customer customer ON customer.FID = hg.FCustomerID \r\n");
        sql.append(" left outer join T_BD_Material material ON material.FID = hg.FMaterialID \r\n");
        sql.append(" left outer join t_bd_supplier provider ON provider.FID = hg.FProviderID \r\n");
        for (AsstactTypeEntity at : cond.getAsstActList()) {
            if (!cond.isFilterByCat() || at.isBasicCat()) continue;
            String groupDetTable = GLRptDaoUtil.getGroupDetailTable(at);
            String field = GLRptDaoUtil.getField(at);
            sql.append(" inner join ").append(groupDetTable).append(" ").append(at.getHgAttribute()).append("GDet on ").append(at.getHgAttribute()).append("GDet.").append(field).append(" = hg.").append(at.getHgField());
        }
        return sql.toString();
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String asstfilter;
        GLRptAsstactBaseCondition cond = this.getCond();
        StringBuffer sql = new StringBuffer();
        GLRptFilter cpFilter = this.getRptCompanyFilter(cond);
        sql.append(cpFilter.getSQL());
        sql.append(" and v.fbizstatus");
        if (cond.getOptionPosting()) {
            sql.append(" in (").append(1).append(", ").append(3).append(", ").append(5).append(") \r\n");
        } else {
            sql.append(" = ").append(5);
        }
        this.setPLVoucherFilter(sql);
        GLRptPeriodFilter pdFilter = new GLRptPeriodFilter(cond, false);
        sql.append(" and ").append(pdFilter.getSQL());
        if (!(cond.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(cond.getCurrencyID()) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(cond.getCurrencyID()))) {
            sql.append(" and ").append(GLRptVoucherField.currencyID.getSelect()).append(" = '").append(cond.getCurrencyID()).append("'");
        }
        this.setAcccountTableFilter(sql);
        GLRptAccountFilter accFilter = new GLRptAccountFilter(this.getCtx(), cond, "av", GLRptVoucherField.accountID.getSelect(), GLRptVoucherField.companyID.getSelect(), true);
        String accountFilter = accFilter.getSQL();
        if (accountFilter != null && accountFilter.length() > 0) {
            sql.append(" and ").append(accountFilter);
        }
        if ((asstfilter = this.getGLRptAsstAccountFilter().getSQL()) != null && asstfilter.length() > 0) {
            sql.append(" and ").append(asstfilter);
        }
        return sql.toString();
    }

    protected GLRptFilter getRptCompanyFilter(GLRptAsstactBaseCondition cond) {
        return new GLRptCompanyFilter(cond, GLRptVoucherField.companyID.getSelect());
    }

    protected void setPLVoucherFilter(StringBuffer sql) {
        if (this.getCond().isNotIncluePLVoucher()) {
            sql.append(" and ").append(this.getVoucherDataTable().getAlias()).append(".fsourcetype <> ").append(1);
        }
    }

    protected GLRptDataTable getVoucherDataTable() {
        return GLRptDataTable.VOUCHER;
    }

    protected String getAmountSelectSQL(GLRptField field) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("sum(").append(field.getSelect()).append(") ").append(field);
        return sql.toString();
    }

    protected void setAcccountTableFilter(StringBuffer sql) throws BOSException {
        if (GLRptDaoUtil.isIncludeAdjustPeriod(this.getCtx(), this.getCond(), this.company)) {
            sql.append(" and av.faccounttableid = '").append(this.getCond().getAccountTableId()).append("'");
        }
    }

    @Override
    public GLRptAsstactBaseCondition getCond() {
        return (GLRptAsstactBaseCondition)super.getCond();
    }

    public void setAccountFilter(boolean isAccountFilter) {
        this.isAccountFilter = isAccountFilter;
    }
}

