/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import java.sql.Date;

public class GLRptVoucherDetailPageQuery
extends GLRptPageQuery {
    protected int currRowSeq = -1;
    private int period;
    private String accountID;
    private String hgId;
    private String currencyID;
    private Date bookedDate;

    public GLRptVoucherDetailPageQuery(Context ctx, GLRptBaseCondition cond) {
        super(ctx, cond);
    }

    public void setCurrRow(GLRptRowSet currRowSet) throws BOSException {
        this.currRowSeq = currRowSet.getRowIndex();
        Object periodObj = currRowSet.getObject(GLRptVoucherField.period.getName());
        this.period = Integer.parseInt(this.getPeriodStr(periodObj.toString()));
        if (currRowSet.indexOf(GLRptVoucherField.accountID.getName()) != -1) {
            this.accountID = currRowSet.getString(GLRptVoucherField.accountID.getName());
        }
        this.hgId = this.getCurrRowHGID(currRowSet);
        if (currRowSet.indexOf(GLRptVoucherField.currencyID.getName()) != -1) {
            this.currencyID = currRowSet.getString(GLRptVoucherField.currencyID.getName());
        }
        if (currRowSet.indexOf(GLRptVoucherField.bookDate.getName()) != -1) {
            this.bookedDate = currRowSet.getDate(GLRptVoucherField.bookDate.getName());
        }
    }

    protected String getCurrRowHGID(GLRptRowSet rs) throws BOSException {
        return rs.getString(GLRptVoucherField.HGID.getName());
    }

    private String getPeriodStr(String peroid) {
        String year = peroid.substring(0, 4);
        String month = peroid.substring(5);
        if (month != null && month.length() == 1) {
            month = "0" + month;
        }
        return year + month;
    }

    @Override
    protected void appendRecordID(StringBuffer sql) {
        if (this.isSeqTable()) {
            sql.append(this.currRowSeq > -1 ? "" + this.currRowSeq + " " + "KSQL_SEQ" : "t.KSQL_SEQ");
        } else if (this.currRowSeq == -1) {
            sql.append("t.").append("SQL_BATCH").append(",t.").append("KSQL_SEQ");
        }
    }

    @Override
    protected String getSelect(GLRptField field) throws EASBizException, BOSException {
        if (this.currRowSeq > -1) {
            int year = this.period / 100;
            StringBuffer sql = new StringBuffer();
            GLRptDataTable mainTable = this.getMainTable();
            if (field.getName().startsWith("FSub")) {
                sql.append(" sum(case when ").append(mainTable.getAlias()).append(".FBalSeq = 2 and ").append(mainTable.getAlias()).append(".fperiod = ").append(this.period).append(" then isnull(").append(this.getSelectField(field, this.getSubSelect(field))).append(",0.0) else 0.0 end) F").append(field.getName().substring(4));
            } else if (field.isEnd()) {
                sql.append(" sum(case ").append(mainTable.getAlias()).append(".FBalSeq when 1 then isnull(").append(this.getSelectField(field, field)).append(",0.0) when 2 then ");
                sql.append(" (isnull(").append(this.getSelectField(field, this.getDebitSelect(field))).append(",0.0) - isnull(").append(this.getSelectField(field, this.getCreditSelect(field))).append(",0.0)) else 0.0 end) ").append(field.getName());
            } else if (field.isYearDebit()) {
                sql.append(" sum(case when ").append(mainTable.getAlias()).append(".FBalSeq = 1 and to_int(t.fperiod/100) = ").append(year).append(" then isnull(").append(this.getSelectField(field, field)).append(",0.0) ");
                sql.append(" when ").append(mainTable.getAlias()).append(".FBalSeq = 2 and to_int(t.fperiod/100) = ").append(year).append(" then ").append(" isnull(").append(this.getSelectField(field, this.getDebitSelect(field))).append(",0.0) ");
                sql.append(" else 0.0 end) ").append(field.getName());
            } else if (field.isYearCredit()) {
                sql.append(" sum(case when ").append(mainTable.getAlias()).append(".FBalSeq = 1 and to_int(t.fperiod/100) = ").append(year).append(" then isnull(").append(this.getSelectField(field, field)).append(",0.0) ");
                sql.append(" when ").append(mainTable.getAlias()).append(".FBalSeq = 2 and to_int(t.fperiod/100) = ").append(year).append(" then ").append(" isnull(").append(this.getSelectField(field, this.getCreditSelect(field))).append(",0.0) ");
                sql.append(" else 0.0 end) ").append(field.getName());
            } else if (field.isDayDebit()) {
                sql.append(" sum(case when ").append(mainTable.getAlias()).append(".FBalSeq = 2 and t.fbookeddate = ? then isnull(").append(this.getSelectField(field, this.getDebitSelect(field))).append(",0.0) else 0.0 end) ").append(field.getName());
                this.sp.add(this.bookedDate);
            } else if (field.isDayCredit()) {
                sql.append(" sum(case when ").append(mainTable.getAlias()).append(".FBalSeq = 2 and t.fbookeddate = ? then isnull(").append(this.getSelectField(field, this.getCreditSelect(field))).append(",0.0) else 0.0 end) ").append(field.getName());
                this.sp.add(this.bookedDate);
            }
            return sql.toString();
        }
        return super.getSelect(field);
    }

    protected GLRptField getSubSelect(GLRptField field) {
        GLRptField select = field;
        if (field.isQty()) {
            if (GLRptVoucherField.entryDebitQty == field) {
                select = GLRptVoucherField.entryStandDebitQty;
            } else if (GLRptVoucherField.entryCreditQty == field) {
                select = GLRptVoucherField.entryStandCreditQty;
            }
        }
        return select;
    }

    protected GLRptField getDebitSelect(GLRptField field) {
        GLRptField select = null;
        select = field.isQty() ? (field.isStandardQty() ? GLRptVoucherField.entryStandDebitQty : GLRptVoucherField.entryDebitQty) : ("For".equals(field.getSuffix()) ? GLRptVoucherField.entryDebitFor : ("Local".equals(field.getSuffix()) ? GLRptVoucherField.entryDebitLocal : GLRptVoucherField.entryDebitRpt));
        return select;
    }

    protected GLRptField getCreditSelect(GLRptField field) {
        GLRptField select = null;
        select = field.isQty() ? (field.isStandardQty() ? GLRptVoucherField.entryStandCreditQty : GLRptVoucherField.entryCreditQty) : ("For".equals(field.getSuffix()) ? GLRptVoucherField.entryCreditFor : ("Local".equals(field.getSuffix()) ? GLRptVoucherField.entryCreditLocal : GLRptVoucherField.entryCreditRpt));
        return select;
    }

    protected String getSelectField(GLRptField field, GLRptField select) {
        return select.getSelect() == null ? this.getMainTable().getAlias() + "." + select.getName() : select.getSelect();
    }

    @Override
    protected String getAmountSumSelect(GLRptField field) {
        if (field.getName().startsWith("FSub")) {
            return this.getDebitCreditSumSelect(field);
        }
        if (field.isEnd()) {
            return this.getEndSumSelect(field);
        }
        return " 0.0 " + field.getName();
    }

    protected String getEndSumSelect(GLRptField field) {
        StringBuffer sql = new StringBuffer();
        GLRptDataTable mainTable = this.getMainTable();
        sql.append(" sum(case ").append(mainTable.getAlias()).append(".FBalSeq when 1 then isnull(").append(mainTable.getAlias()).append(".").append(field.getName()).append(",0.0) when 2 then ");
        sql.append("(isnull(").append(this.getDebitSelect(field).getSelect()).append(",0.0) - isnull(").append(this.getCreditSelect(field).getSelect()).append(",0.0)) else 0.0 end) ").append(field.getName());
        return sql.toString();
    }

    protected String getDebitCreditSumSelect(GLRptField field) {
        return new StringBuffer().append(" sum(case ").append(this.getMainTable().getAlias()).append(".FBalSeq when 2 then isnull(").append(field.getSelect()).append(",0.0) else 0.0 end) ").append(field.getName()).toString();
    }

    @Override
    protected String getJoinDataBaseSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" left outer join ").append(this.getVoucherTable()).append(" voucher on voucher.fid = t.voucherid ");
        sql.append(" left outer join t_bd_vouchertypes voucherType on voucherType.fid = voucher.fvouchertypeid");
        sql.append(" left outer join ").append(this.getVoucherEntryTable()).append(" entries on entries.fid = t.entryid ");
        if (this.getCond().isAllCurrency()) {
            sql.append(" left outer join t_bd_currency currency on currency.fid = t.fcurrencyid");
        }
        sql.append(" LEFT OUTER JOIN T_PM_User creator ON voucher.FCreatorID = creator.FID ");
        sql.append(this.getJoinAccountSQL());
        sql.append(this.getJoinDataOrgSQL());
        return sql.toString();
    }

    protected String getJoinAccountSQL() {
        return " left outer join t_bd_accountview account on account.fid = t.faccountid ";
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String whereSql = super.getWhereSQL();
        if (this.currRowSeq > -1) {
            StringBuffer sql = new StringBuffer();
            this.addWhere(sql, whereSql);
            this.setInterruptQueryFilter(sql);
            return sql.toString();
        }
        return whereSql;
    }

    protected void setInterruptQueryFilter(StringBuffer sql) {
        if (this.isSeqTable()) {
            this.addWhere(sql, " t.KSQL_SEQ <= ? ");
            this.sp.add(this.currRowSeq);
        }
        if (this.accountID != null) {
            this.addWhere(sql, " t.FAccountID = ? ");
            this.sp.add(this.accountID);
        }
        if (this.hgId != null) {
            this.addWhere(sql, " t.FAssGrpId = ? ");
            this.sp.add(this.hgId);
        }
        if (this.getCond().isAllCurrency() && this.currencyID != null) {
            this.addWhere(sql, " t.FCurrencyID = ? ");
            this.sp.add(this.currencyID);
        }
    }

    protected void addWhere(StringBuffer sql, String where) {
        if (where != null && where.trim().length() > 0) {
            if (sql.length() > 0) {
                sql.append(" and ");
            }
            sql.append(where);
        }
    }

    @Override
    protected String getOrderSql() throws EASBizException, BOSException {
        if (this.currRowSeq > -1) {
            return null;
        }
        return super.getOrderSql();
    }

    protected String getJoinDataOrgSQL() {
        return " left outer join t_org_company company on company.fid = t.fcompanyid ";
    }

    protected String getOrgUnitId() {
        return "FCompanyID";
    }

    protected String getVoucherTable() {
        return "T_GL_Voucher";
    }

    protected String getVoucherEntryTable() {
        return "T_GL_VoucherEntry";
    }

    protected String getVoucherAssistRecordTable() {
        return "T_GL_VoucherAssistRecord";
    }
}

