/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.app.GLRptIDManager;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.IRptDataManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IDRptDataManager
implements IRptDataManager {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.IDRptDataManager");
    private Context ctx;
    private AbstractGLRptDao dao;
    private GLRptIDManager idManager;

    public IDRptDataManager(AbstractGLRptDao dao) throws EASBizException, BOSException {
        this.dao = dao;
        this.ctx = dao.getContex();
    }

    @Override
    public void init() throws EASBizException, BOSException {
        this.idManager = this.dao.createIDManager();
        this.idManager.initGLRptID(this.getIDList(), this.dao.getExpandLevel());
    }

    @Override
    public GLRptRowSet getData(int start, int length) throws BOSException, EASBizException {
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        query.setDataSourceTable(this.dao.getDataSourceTable());
        query.setSelector(this.dao.getGLRptSelector());
        query.setSumItems(this.dao.getSumItem());
        GLRptID[] ids = this.idManager.getIdList(start, length);
        query.setID(ids);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)query.getSQL(), (Object[])query.getSQLParams().toArray());
        GLRptRowSet rowSet = new GLRptRowSet(this.dao.getTableHeadInfo().getColNames(), rs.size());
        try {
            while (rs.next()) {
                int rowIndex = this.indexof(ids, rs);
                rowSet.insertRow(rowIndex);
                rowSet.setRowIndex(rowIndex + start);
                this.dao.toGLRptRowData(rs, rowSet);
                if (this.dao.getTreeColmun() != null) {
                    this.dao.setTreeNode(rowSet, rs, (GLRptTreeNode)ids[rowIndex]);
                }
                this.dao.doGLRptRowData(rowSet);
                this.dao.doDetailRowSet(rowSet);
            }
            this.dao.setSumData(start, query, ids, rowSet);
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return rowSet;
    }

    @Override
    public int getTotalRowCount() throws BOSException, EASBizException {
        return this.idManager.getViewRowCount();
    }

    @Override
    public String getQueryId() {
        return this.dao.getDataSourceTableName();
    }

    public int expandRow(int index) {
        return this.idManager.expandRow(index);
    }

    public int expandAllRow(int index) {
        return this.idManager.expandAllRow(index);
    }

    public int shrinkRow(int index) {
        return this.idManager.shrinkRow(index);
    }

    protected int indexof(GLRptID[] ids, IRowSet rs) throws SQLException {
        if (ids == null) {
            return -1;
        }
        int batch = rs.getInt("SQL_BATCH");
        int seq = rs.getInt("KSQL_SEQ");
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].getBatch() != batch || ids[i].getSeq() != seq) continue;
            return i;
        }
        return -1;
    }

    public List getIDList() throws BOSException, EASBizException {
        GLRptSQLOrder orders;
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        query.setDataSourceTable(this.dao.getDataSourceTable());
        query.setSumItems(this.dao.getSumItem());
        IGLRptIDCreator idCreator = this.dao.getGLRptIDCreator(query.getMainTable().getAlias(), null);
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(idCreator.getIDSelect());
        sql.append(" from ").append(query.getFromSQL());
        sql.append(query.getJoinSQL());
        String where = query.getWhereSQL();
        if (where != null && where.trim().length() > 0) {
            sql.append(" where ").append(where);
        }
        if ((orders = query.getOrder()) != null) {
            sql.append(orders.getOrderSQL());
        }
        try {
            return this.queryIdList(KSqlUtil.optimize((String)sql.toString()), idCreator);
        }
        catch (SqlTranslateException e) {
            throw new BOSException("Sql optimize error!", (Throwable)e);
        }
    }

    protected List queryIdList(String sql, IGLRptIDCreator idCreator) throws BOSException {
        ArrayList<GLRptID> arrayList;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("GLRptQuery sql error!", (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            ArrayList<GLRptID> idList = new ArrayList<GLRptID>();
            while (rs.next()) {
                GLRptID id = idCreator.create(rs);
                if (id == null) continue;
                idList.add(id);
            }
            arrayList = idList;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("sql is:" + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return arrayList;
    }

    public GLRptIDManager getIdManager() {
        return this.idManager;
    }

    public AbstractGLRptDao getDao() {
        return this.dao;
    }

    public Context getCtx() {
        return this.ctx;
    }
}

