/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class SelectedAsstItemFilter
implements GLRptFilter {
    private static final int ID_MAX_COUNT = 5;
    private static final String ASSTITEMID_TABLE = "asstItemIdTempTable";
    private Context ctx;
    private GLRptAsstactBaseCondition cond;
    private String hgAlias;
    private GLRptSelector selector;
    private String sql;
    private boolean isSupportCharIndexToLike = false;

    public SelectedAsstItemFilter(Context ctx, GLRptAsstactBaseCondition cond, String hgAlias, GLRptSelector selector) {
        this.ctx = ctx;
        this.cond = cond;
        this.hgAlias = hgAlias;
        this.selector = selector;
        this.isSupportCharIndexToLike = SQLUtil.isSupportCharIndexToLike(ctx);
    }

    @Override
    public String getSQL() throws BOSException {
        if (this.cond.getDataSourceTable() == null) {
            return null;
        }
        if (this.sql == null) {
            this.sql = this.getJoinDataSourceFilter();
        }
        return this.sql;
    }

    private String getJoinDataSourceFilter() throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.isShowAsstActSingle()) {
            Iterator it = this.cond.getAsstActList().iterator();
            sql.append(" exists (select 1 from ").append(this.cond.getDataSourceTable()).append(" t ");
            AsstactTypeEntity at = (AsstactTypeEntity)it.next();
            String strFieldAsstItem = GLRptField.asstItemIDSingle.getName();
            sql.append(" where t.").append(strFieldAsstItem).append(" = ").append(this.hgAlias).append(".").append(at.getHgField());
        } else {
            String tempTable = this.cond.getDataSourceTable();
            if (this.cond.getSelectedItem() != null) {
                tempTable = this.getAsstItemIdTempTable();
            }
            sql.append(" exists (select 1 from ").append(tempTable).append(" t ");
            boolean hasFilter = false;
            for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                if (!hasFilter) {
                    sql.append(" where ");
                    hasFilter = true;
                } else {
                    sql.append(" and ");
                }
                sql.append(" t.").append(at.getHgField()).append(" = ").append(this.hgAlias).append(".").append(at.getHgField());
            }
        }
        sql.append(") ");
        return sql.toString();
    }

    private String getAsstItemIdTempTable() throws BOSException {
        String tempTable = (String)GLTempTableUtil.getContextObject(ASSTITEMID_TABLE);
        if (tempTable == null) {
            StringBuffer select = new StringBuffer();
            StringBuffer where = new StringBuffer();
            for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                select.append(select.length() == 0 ? "SELECT " : ",").append("t.").append(at.getHgField());
            }
            String asstItemIdTable = null;
            String asstItemFilter = null;
            if (this.cond.getSelectedItem().size() > 5) {
                asstItemIdTable = this.createAsstItemIdTempTable(true);
                if (!this.checkTableName(asstItemIdTable)) {
                    throw new BOSException("illegal temptable name:" + asstItemIdTable);
                }
                this.insertAsstItemId2TempTable(asstItemIdTable);
                asstItemFilter = this.getAsstItemTmpTableFilterSQL(asstItemIdTable);
            } else {
                asstItemFilter = this.getSelectedAsstFilterSQL();
            }
            if (asstItemFilter != null && asstItemFilter.trim().length() > 0) {
                where.append(" WHERE ").append(asstItemFilter);
            }
            if (!this.checkTableName(tempTable = this.createAsstItemIdTempTable(false))) {
                throw new BOSException("illegal temptable name:" + tempTable);
            }
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into ").append(tempTable).append(" ").append(select).append(" FROM ").append(this.cond.getDataSourceTable()).append(" t ").append(where);
            DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
            GLTempTableUtil.setContextObject(ASSTITEMID_TABLE, tempTable);
        }
        return tempTable;
    }

    private String getAsstItemTmpTableFilterSQL(String asstItemIdTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" (exists (select 1 from ").append(asstItemIdTable).append(" idTable where ");
        List asstActList = this.cond.getAsstActList();
        for (int i = 0; i < asstActList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)asstActList.get(i);
            if (i > 0) {
                sql.append(" and ");
            }
            if (at.isShowAsstGroup()) {
                sql.append("((idTable.").append(at.getHgField()).append(" is not null ");
                sql.append(" and t.").append(at.getHgField()).append(" = idTable.").append(at.getHgField());
                sql.append(") or (idTable.").append(at.getHgField()).append(" is null ").append(" and ");
                sql.append("t.").append(at.getHgAttribute()).append("GroupID");
                sql.append(" in (").append(this.getLevelAsstItemGroupSQL(at)).append(" where pgp.fid = idTable.").append(at.getHgAttribute()).append("GroupID)");
                sql.append("))");
                continue;
            }
            if (at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP) {
                sql.append(" exists (select 1 from ").append(at.getTableName()).append(" l ");
                sql.append(" inner join ").append(at.getTableName()).append(" p on ");
                if (this.isSupportCharIndexToLike) {
                    sql.append(" (l.flongnumber like concat(p.flongnumber, '!%')  or p.fid = l.fid) ");
                } else {
                    sql.append(" (charindex(p.flongnumber||'!', l.flongnumber) = 1 or p.fid = l.fid) ");
                }
                sql.append(" where p.fid = idTable.").append(at.getHgField()).append(" and t.").append(at.getHgField()).append(" = l.fid)");
                continue;
            }
            sql.append("t.").append(at.getHgField()).append(" = idTable.").append(at.getHgField());
        }
        sql.append("))");
        return sql.toString();
    }

    private String getSelectedAsstFilterSQL() throws BOSException {
        StringBuffer sql = new StringBuffer();
        GLRptRowSet selectedItem = this.cond.getSelectedItem();
        while (selectedItem.next()) {
            String asstFilter = this.getAsstFilterSQL(selectedItem, this.hgAlias);
            if (asstFilter == null || asstFilter.trim().length() <= 0) continue;
            if (sql.length() > 0) {
                sql.append(" or ");
            }
            sql.append("(").append(asstFilter).append(")");
        }
        if (sql.length() > 0) {
            return "(" + sql.toString() + ")";
        }
        return null;
    }

    private String getAsstFilterSQL(GLRptRowSet selectedItem, String hgAlias) throws BOSException {
        StringBuffer sql = new StringBuffer();
        List actList = this.cond.getAsstActList();
        for (int i = 0; i < this.cond.getAsstActList().size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
            String itemFilter = this.getAsstItemFilterSQL(selectedItem, at);
            if (itemFilter == null || itemFilter.trim().length() <= 0) continue;
            if (sql.length() > 0) {
                sql.append(" and ");
            }
            sql.append(itemFilter);
        }
        return sql.toString();
    }

    private String getAsstItemFilterSQL(GLRptRowSet selectedItem, AsstactTypeEntity at) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String strFieldAsstItem = "";
        strFieldAsstItem = this.cond.isShowAsstActSingle() ? GLRptField.asstItemIDSingle.getName() : at.getHgField();
        String value = selectedItem.getString(at.getHgField());
        if (value != null) {
            sql.append("t.").append(strFieldAsstItem);
            if (!(at.isUseGroup() || at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP)) {
                sql.append(" in (");
                sql.append(" select l.fid from ").append(at.getTableName()).append(" l ");
                sql.append(" inner join ").append(at.getTableName()).append(" p on ");
                if (this.isSupportCharIndexToLike) {
                    sql.append(" (l.flongnumber like concat(p.flongnumber, '!%') or p.fid = l.fid) ");
                } else {
                    sql.append(" (charindex(p.flongnumber||'!', l.flongnumber) = 1 or p.fid = l.fid) ");
                }
                sql.append(" where p.fid = '").append(value).append("')");
            } else {
                sql.append(" = '").append(value).append("'");
            }
        } else {
            String field = at.getHgAttribute() + "GroupID";
            if (at.isShowAsstGroup() && selectedItem.getString(field) != null) {
                sql.append(" t.").append(at.getHgAttribute()).append("GroupID in (");
                sql.append(" select gp.fid from ").append(at.getGroupTable()).append(" gp ");
                sql.append(" inner join ").append(at.getGroupTable()).append(" pgp on ");
                if (this.isSupportCharIndexToLike) {
                    sql.append(" (gp.flongnumber like concat(pgp.flongnumber, '!%') or gp.fid = pgp.fid) ");
                } else {
                    sql.append(" (charindex(pgp.flongnumber||'!', gp.flongnumber) = 1 or gp.fid = pgp.fid) ");
                }
                sql.append(" where pgp.fid = '").append(selectedItem.getString(field)).append("'");
                sql.append(" )");
                sql.append(" and t.").append(strFieldAsstItem).append(" is not null");
            }
        }
        return sql.toString();
    }

    private StringBuffer getLevelAsstItemGroupSQL(AsstactTypeEntity at) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select gp.fid from ").append(at.getGroupTable()).append(" gp ");
        sql.append(" inner join ").append(at.getGroupTable()).append(" pgp on ");
        if (this.isSupportCharIndexToLike) {
            sql.append(" (gp.flongnumber like concat(pgp.flongnumber, '!%') or pgp.fid = gp.fid) ");
        } else {
            sql.append(" (charindex(pgp.flongnumber||'!', gp.flongnumber) = 1 or pgp.fid = gp.fid) ");
        }
        return sql;
    }

    private String createAsstItemIdTempTable(boolean includeGroup) throws BOSException {
        List asstActList = this.cond.getAsstActList();
        StringBuffer tableStruct = new StringBuffer();
        int size = asstActList.size();
        for (int i = 0; i < size; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)asstActList.get(i);
            if (i > 0) {
                tableStruct.append(",");
            }
            tableStruct.append(at.getHgField()).append(" ").append("VARCHAR(44)");
            if (!includeGroup || !at.isShowAsstGroup()) continue;
            tableStruct.append(",").append(at.getHgAttribute()).append("GroupID ").append("VARCHAR(44)");
        }
        return GLTempTableUtil.createDBSysTempTable(this.ctx, tableStruct.toString());
    }

    private void insertAsstItemId2TempTable(String asstItemIdTable) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(asstItemIdTable).append(" values(");
        List asstActList = this.cond.getAsstActList();
        int size = asstActList.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                insertSql.append(",");
            }
            AsstactTypeEntity at = (AsstactTypeEntity)asstActList.get(i);
            insertSql.append("?");
            if (!at.isShowAsstGroup()) continue;
            insertSql.append(",?");
        }
        insertSql.append(")");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.prepareStatement(insertSql.toString());
            GLRptRowSet selectedItem = this.cond.getSelectedItem();
            while (selectedItem.next()) {
                int index = 1;
                for (int i = 0; i < size; ++i) {
                    AsstactTypeEntity at = (AsstactTypeEntity)asstActList.get(i);
                    stmt.setString(index++, selectedItem.getString(at.getHgField()));
                    if (!at.isShowAsstGroup()) continue;
                    stmt.setString(index++, selectedItem.getString(at.getHgAttribute() + "GroupID"));
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("DB error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private boolean checkTableName(String tableName) {
        return UUTN.isTempTable((String)tableName);
    }
}

