/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItemInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.IRptDataManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SeqTableRptDataManager
implements IRptDataManager {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.SeqTableRptDataManager");
    private Context ctx;
    private AbstractGLRptDao dao;
    private GLRptTempTableInfo tableInfo;

    public SeqTableRptDataManager(AbstractGLRptDao dao) {
        this.dao = dao;
        this.ctx = dao.getContex();
    }

    @Override
    public void init() throws EASBizException, BOSException {
        this.createSeqTempTable();
    }

    @Override
    public GLRptRowSet getData(int start, int length) throws BOSException, EASBizException {
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        boolean isQtyAsst = GlUtils.getQtyAsstParam(this.ctx);
        query.setDataSourceTable(this.tableInfo);
        query.setSelector(this.dao.getGLRptSelector());
        query.setSumItems(this.dao.getSumItem());
        query.setKSQL_SEQ(start + 1, start + length);
        String querySql = query.getSQL();
        if (!isQtyAsst) {
            querySql = querySql.replace("assistRecords.FPrice", "entries.FPrice");
        }
        if (this.dao.getQueryCondition() instanceof GLRptSubLedgerCondition) {
            GLRptSubLedgerCondition condition = (GLRptSubLedgerCondition)this.dao.getQueryCondition();
            if (!StringUtils.isEmpty((String)condition.getMeasureUnitId())) {
                querySql = querySql.replace("account.FMeasureUnitID", "'" + condition.getMeasureUnitId() + "' ");
            } else if (condition.isGroupByMU()) {
                querySql = querySql.replace("account.FMeasureUnitID", "t.FMeasureUnitID ");
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)querySql, (Object[])query.getSQLParams().toArray());
        GLRptRowSet rowSet = new GLRptRowSet(this.dao.getTableHeadInfo().getColNames(), rs.size());
        try {
            while (rs.next()) {
                int rowIndex = rs.getInt("KSQL_SEQ") - start - 1;
                rowSet.insertRow(rowIndex);
                rowSet.setRowIndex(rowIndex + start);
                this.dao.toGLRptRowData(rs, rowSet);
                this.dao.doGLRptRowData(rowSet);
                this.dao.doDetailRowSet(rowSet);
            }
            this.dao.setSumData(start, query, null, rowSet);
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return rowSet;
    }

    public GLRptRowSet getAsynSumData() throws BOSException, EASBizException {
        GLRptRowSet totalRs = new GLRptRowSet(this.dao.getTableHeadInfo().getColNames(), 0);
        Iterator it = this.dao.getSumItem().getSumItems().iterator();
        try {
            while (it.hasNext()) {
                GLRptSumItemInfo item = (GLRptSumItemInfo)it.next();
                if (!item.isAsyn()) continue;
                IRowSet rs = this.getAsynSumRowSet(item);
                GLRptRowSet rowSet = new GLRptRowSet(this.dao.getTableHeadInfo().getColNames(), rs.size());
                while (rs.next()) {
                    rowSet.insertRow();
                    rowSet.setRowIndex(rs.getInt("KSQL_SEQ") - 1);
                    this.dao.toGLRptRowData(rs, rowSet);
                    this.dao.doGLRptRowData(rowSet);
                }
                if (totalRs == null) {
                    totalRs = rowSet;
                    continue;
                }
                totalRs.addRowSets(rowSet);
            }
        }
        catch (Exception e) {
            logger.error((Object)"GetAsynSumData error!", (Throwable)e);
        }
        return totalRs;
    }

    private IRowSet getAsynSumRowSet(GLRptSumItemInfo item) throws EASBizException, BOSException {
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        query.setSelector(this.dao.getGLRptSelector());
        query.setDataSourceTable(this.tableInfo);
        query.setSumItems(this.dao.getSumItem());
        query.setSumItem(item);
        return DbUtil.executeQuery((Context)this.ctx, (String)query.getSQL(), (Object[])query.getSQLParams().toArray());
    }

    @Override
    public int getTotalRowCount() throws BOSException, EASBizException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select count(1) ct from ").append(this.tableInfo.getTableName());
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs.next()) {
                return rs.getInt("ct");
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        return -1;
    }

    @Override
    public String getQueryId() {
        return this.tableInfo.getTableName();
    }

    protected void createSeqTempTable() throws BOSException, EASBizException {
        GLRptSQLOrder orders;
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        query.setDataSourceTable(this.dao.getDataSourceTable());
        query.setSelector(this.dao.getGLRptSelector());
        query.setSumItems(this.dao.getSumItem());
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        String[] fields = this.dao.getTempTableStruct().getFieldNames();
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(query.getMainTable().getAlias()).append(".").append(fields[i]);
        }
        sql.append(" from ").append(query.getFromSQL());
        sql.append(query.getJoinSQL());
        String whereSQL = query.getWhereSQL();
        if (whereSQL != null && whereSQL.trim().length() > 0) {
            sql.append(" where ").append(whereSQL);
        }
        if ((orders = query.getOrder()) != null && !orders.isEmpty()) {
            sql.append(orders.getOrderSQL());
        }
        String tableName = null;
        try {
            String sqlStr = KSqlUtil.optimize((String)sql.toString());
            String hint = query.getHint();
            if (hint != null && hint.trim().length() > 0) {
                sqlStr = "select " + hint.trim() + " " + sqlStr.substring(6);
            }
            long currTime = System.currentTimeMillis();
            tableName = this.createTempTable("seq", "KSQL_SEQ INT IDENTITY (1, 1)," + this.dao.getTempTableStruct().getDataTableDesc());
            StringBuffer insertSql = new StringBuffer();
            insertSql.append(" insert /*+ append */ into ").append(tableName).append("(KSQL_SEQ");
            for (int i = 0; i < fields.length; ++i) {
                insertSql.append(",").append(fields[i]);
            }
            insertSql.append(") ").append(sqlStr);
            DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
            logger.info((Object)("--------create seq table take " + (System.currentTimeMillis() - currTime) + " ms.-----------"));
            this.tableInfo = new GLRptTempTableInfo(tableName, true);
            this.dao.setDataSourceTable(this.tableInfo);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }

    protected String createTempTable(String name, String struct) throws BOSException {
        String csName = this.getClass().getName();
        name = csName.substring(csName.lastIndexOf(".") + 1) + name;
        String createTableSql = "create table " + name + " (" + struct + ")";
        try {
            return TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSql);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }
}

