/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.fi.gl.validator.ReverseVoucherValidatorUtils;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.Locale;

public class ReverseVoucherBaseAntiCancelValidator
implements IVoucherBaseValidator {
    private VoucherInfo sourceVoucher = null;
    private VoucherInfo reverseVoucher = null;
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.checkReverseSrcVchBeforeAntiCancel(ctx, voucherInfo);
        this.checkCouldReverse(ctx, voucherInfo);
    }

    private void checkReverseSrcVchBeforeAntiCancel(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherInfo srcVch = this.getSourceVoucherInfo(ctx, voucherInfo);
        boolean hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(srcVch.getId().toString());
        if (hasVerified) {
            throw new VoucherException(VoucherException.SRC_HAS_VERIFIED);
        }
        if (!VoucherStatusEnum.POSTED.equals((Object)srcVch.getBizStatus())) {
            throw new VoucherException(VoucherException.SRC_UNPOSTED);
        }
        VoucherEntryCollection entries = srcVch.getEntries();
        VoucherEntryInfo entry = null;
        String currentAcctTable = srcVch.getCompany().getAccountTable().getId().toString();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            if (currentAcctTable.equals(entry.getAccount().getAccountTableID().getId().toString())) continue;
            throw new VoucherException(VoucherException.REV_ANTICANCEL_FAIL_FOR_ACCOUNT_CHANGED);
        }
    }

    private void checkCouldReverse(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherInfo srcVch = this.getSourceVoucherInfo(ctx, voucherInfo);
        VoucherInfo reverseVch = this.getReverseVoucherInfo(ctx, voucherInfo);
        StringBuffer msgCollector = new StringBuffer();
        msgCollector.append(this.getResource(ctx, resource, "BEYOND_SRC_AMOUNT_ANTICANCEL", new Object[]{srcVch.getVoucherType().getName(ctx.getLocale()), srcVch.getNumber(), srcVch.getPeriod().getPeriodYear() + "." + srcVch.getPeriod().getPeriodNumber()}));
        msgCollector.append("\r\n");
        int result = ReverseVoucherValidatorUtils.checkReverse(ctx, reverseVch, srcVch, msgCollector);
        if (result == -1) {
            throw new VoucherException(VoucherException.NO_MSG, new String[]{msgCollector.toString()});
        }
        if (result == 0) {
            voucherInfo.put("ReverseComplete", (Object)true);
        }
    }

    private VoucherInfo getSourceVoucherInfo(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        VoucherInfo srcVch;
        if (this.sourceVoucher != null) {
            return this.sourceVoucher;
        }
        ObjectUuidPK srcVchPK = new ObjectUuidPK(BOSUuid.read((String)voucherInfo.getSourceBillId()));
        this.sourceVoucher = srcVch = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)srcVchPK, VoucherInfo.getReverseSelector());
        return srcVch;
    }

    private VoucherInfo getReverseVoucherInfo(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        VoucherInfo reverseVch;
        if (this.reverseVoucher != null) {
            return this.reverseVoucher;
        }
        ObjectUuidPK vchPK = new ObjectUuidPK(BOSUuid.read((String)voucherInfo.getId().toString()));
        this.reverseVoucher = reverseVch = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)vchPK, VoucherInfo.getDefaultSelector());
        return reverseVch;
    }

    protected String getResource(Context ctx, String resName, String key, Object[] params) {
        String message = ResourceBase.getString((String)resName, (String)key, (Locale)ctx.getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }
}

