/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.IAccountRefContrastEntry;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.validator.AbstractVoucherBaseValidator;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherBaseSubmitProfitCenterBalanceValidator
extends AbstractVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(VoucherBaseSubmitProfitCenterBalanceValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected VoucherInfo voucherInfo;
    protected Map<String, Set<String>> orgProfitAcctMapping = new HashMap<String, Set<String>>();
    protected Set<String> profitAcctIds = new HashSet<String>();

    public VoucherBaseSubmitProfitCenterBalanceValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.ctx = ctx;
        this.voucherInfo = voucherInfo;
        boolean commonVoucherProcess = this.sysParam.getBoolean("GL_111");
        boolean profitCenterBalanceNeed = this.sysParam.getBoolean("GL_108");
        if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            return;
        }
        if (profitCenterBalanceNeed && commonVoucherProcess && baseVoucherInfo.getSourceType() != SourceType.PROFIT_AND_LOSS && baseVoucherInfo.getSourceType() != SourceType.AUTO_TRANS && baseVoucherInfo.getSourceType() != SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT) {
            this.profitCenterBalanceCheckNeed();
        }
        boolean profitCenterBalanceChecked = this.sysParam.getBoolean("GL_112");
        if (commonVoucherProcess && profitCenterBalanceChecked) {
            this.profitCenterBalanceDebitCreditAmount();
        }
    }

    protected void profitCenterBalanceDebitCreditAmount() throws BOSException, EASBizException {
        BigDecimal amount;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> repotyResult = new HashMap<String, BigDecimal>();
        boolean useReportingCurrency = this.sysParam.getBoolean("G001");
        for (VoucherEntryInfo entryInfo : this.voucherInfo.getEntries()) {
            BigDecimal tempReportingAmount;
            BigDecimal tempLocalAmount;
            ProfitCenterOrgUnitInfo profitCenterInfo = entryInfo.getProfitCenter();
            if (profitCenterInfo == null) continue;
            EntryDC entryDC = entryInfo.getEntryDC();
            BigDecimal localAmount = entryInfo.getLocalAmount();
            BigDecimal bigDecimal = tempLocalAmount = EntryDC.DEBIT == entryDC ? localAmount : localAmount.multiply(new BigDecimal("-1"));
            if (result.containsKey(profitCenterInfo.getId().toString())) {
                BigDecimal amount2 = (BigDecimal)result.get(profitCenterInfo.getId().toString());
                result.put(profitCenterInfo.getId().toString(), amount2.add(tempLocalAmount));
            } else {
                result.put(profitCenterInfo.getId().toString(), tempLocalAmount);
            }
            if (!useReportingCurrency) continue;
            BigDecimal reportingAmount = entryInfo.getReportingAmount();
            BigDecimal bigDecimal2 = tempReportingAmount = EntryDC.DEBIT == entryDC ? reportingAmount : reportingAmount.multiply(new BigDecimal("-1"));
            if (repotyResult.containsKey(profitCenterInfo.getId().toString())) {
                BigDecimal amount3 = (BigDecimal)repotyResult.get(profitCenterInfo.getId().toString());
                repotyResult.put(profitCenterInfo.getId().toString(), amount3.add(tempReportingAmount));
                continue;
            }
            repotyResult.put(profitCenterInfo.getId().toString(), tempReportingAmount);
        }
        if (result.size() > 0) {
            for (String key : result.keySet()) {
                amount = (BigDecimal)result.get(key);
                if (amount.compareTo(new BigDecimal("0.00")) == 0) continue;
                throw new VoucherException(VoucherException.LOCALAMOUNT_DC_NOT_EQUAL);
            }
        }
        if (repotyResult.size() > 0) {
            for (String key : repotyResult.keySet()) {
                amount = (BigDecimal)repotyResult.get(key);
                if (amount.compareTo(new BigDecimal("0.00")) == 0) continue;
                throw new VoucherException(VoucherException.REPORTAMOUNT_DC_NOT_EQUAL);
            }
        }
    }

    private Set<String> getRelatedCompanyIds(Context ctx, String profitCenterId) throws BOSException {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, "getRelatedCompanyIds");
        if (datas.containsKey(profitCenterId)) {
            return (Set)datas.get(profitCenterId);
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(profitCenterId);
        Set<String> relatedCompanyIdSet = GlUtils.getRelatedCompanyIds(ctx, idSet);
        datas.put(profitCenterId, relatedCompanyIdSet);
        return relatedCompanyIdSet;
    }

    private void checkProfitCenterAccountMapping(Context ctx) throws BOSException, EASBizException {
        boolean commonVoucherProcess = this.sysParam.getBoolean("GL_111");
        boolean useProfitCenterAccount = this.sysParam.getBoolean("GL_115");
        if (commonVoucherProcess && useProfitCenterAccount) {
            this.getOrgProfitAcctMapping(ctx);
            StringBuffer msg = new StringBuffer();
            for (VoucherEntryInfo entry : this.voucherInfo.getEntries()) {
                if (entry.getProfitCenter() == null || entry.getProfitCenter().getId() == null) continue;
                ProfitCenterOrgUnitInfo profitCenterInfo = entry.getProfitCenter();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(profitCenterInfo.getId().toString());
                Set<String> relatedCompanyIdSet = this.getRelatedCompanyIds(ctx, profitCenterInfo.getId().toString());
                String relatedCompanyId = (String)relatedCompanyIdSet.toArray()[0];
                if (this.orgProfitAcctMapping.get(relatedCompanyId) == null) {
                    CompanyOrgUnitInfo relatedCompany = GlUtils.getCompanyById(ctx, relatedCompanyId);
                    String acctRefContrastNotExist = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1300_AcctRefContrastNotExist"), relatedCompany.getName(), this.voucherInfo.getCompany().getName());
                    msg.append(acctRefContrastNotExist).append("\r\n ");
                    continue;
                }
                Set<Object> acctIds = this.orgProfitAcctMapping.get(relatedCompanyId) != null ? this.orgProfitAcctMapping.get(relatedCompanyId) : new HashSet();
                if (acctIds.contains(entry.getAccount().getId().toString())) continue;
                String upProfitAcctount = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"908_unProfitAccount"), entry.getAccount().getNumber() + " " + entry.getAccount().getName());
                msg.append(upProfitAcctount).append("\r\n ");
            }
            if (msg.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("1", msg.toString()));
            }
        }
    }

    private void getOrgProfitAcctMapping(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = this.voucherInfo.getCompany();
        if (company.getAccountTable() == null || company.getAccountTable().getId() == null) {
            company = GlUtils.getCompanyById(ctx, company.getId().toString());
        }
        String oql = " select id, newAcct.id, acctRefContrast.company.id where id in (select e.FID from T_BD_AcctRefContrast a inner join  T_BD_AcctRefContrastEntry e on e.FAcctRefContrastID = a.fid where a.FRefType = 3 and a.FIsEnabled = 1 and a.fstcompanyid ='" + this.voucherInfo.getCompany().getId() + "' and a.FEnabledAcctTableID = '" + company.getAccountTable().getId() + "') order by acctRefContrast.company.id ";
        try {
            IAccountRefContrastEntry ir = AccountRefContrastEntryFactory.getLocalInstance((Context)ctx);
            AccountRefContrastEntryCollection arc = ir.getAccountRefContrastEntryCollection(oql);
            for (int i = 0; i < arc.size(); ++i) {
                Set<Object> AcctIds;
                AccountRefContrastEntryInfo arcEntryInfo = arc.get(i);
                if (arcEntryInfo.getNewAcct() == null || arcEntryInfo.getNewAcct().getId() == null) continue;
                CompanyOrgUnitInfo companyInfo = arcEntryInfo.getAcctRefContrast().getCompany();
                if (this.orgProfitAcctMapping.get(companyInfo.getId().toString()) != null) {
                    AcctIds = this.orgProfitAcctMapping.get(companyInfo.getId().toString());
                    AcctIds.add(arcEntryInfo.getNewAcct().getId().toString());
                    this.orgProfitAcctMapping.put(companyInfo.getId().toString(), AcctIds);
                } else {
                    AcctIds = new HashSet<String>();
                    AcctIds.add(arcEntryInfo.getNewAcct().getId().toString());
                    this.orgProfitAcctMapping.put(companyInfo.getId().toString(), AcctIds);
                }
                this.profitAcctIds.add(arcEntryInfo.getNewAcct().getId().toString());
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void profitCenterBalanceCheckNeed() throws BOSException, EASBizException {
        for (VoucherEntryInfo entry : this.voucherInfo.getEntries()) {
            if (entry.getProfitCenter() != null) continue;
            throw new VoucherException(VoucherException.PROFIT_CENTER_NEED);
        }
    }
}

