/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator;
import org.apache.log4j.Logger;

public class VoucherEntrySaveValidator
implements IVoucherEntryValidator {
    protected static final Logger logger = Logger.getLogger(VoucherEntrySaveValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected VoucherInfo voucherInfo;
    protected VoucherEntryInfo entryInfo;

    public VoucherEntrySaveValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo, BaseVoucherEntryInfo baseEntryInfo) throws BOSException, EASBizException {
        VoucherEntryInfo entryInfo;
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.entryInfo = entryInfo = (VoucherEntryInfo)baseEntryInfo;
        this.checkEntryDC(ctx, voucherInfo, entryInfo);
        this.checkEntryAccount(ctx, voucherInfo, entryInfo);
        if (entryInfo.getReportingAmount() != null && entryInfo.getReportingAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
    }

    private void checkEntryAccount(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = entryInfo.getAccount();
        if (accountViewInfo == null) {
            return;
        }
        String number = accountViewInfo.getNumber();
        if (accountViewInfo.isIsGFreeze() || accountViewInfo.isIsCFreeze() || accountViewInfo.isIsSelfFreeze()) {
            throw new VoucherException(VoucherException.ACCOUNT_FREEZE, new Object[]{this.getSeq()[0], accountViewInfo.getNumber()});
        }
        boolean isleaf = accountViewInfo.isIsLeaf();
        if (!isleaf) {
            throw new VoucherException(VoucherException.NOTACCOUNTOFCU, new String[]{String.valueOf(entryInfo.getSeq()), number});
        }
    }

    private void checkEntryDC(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws VoucherException {
        if (entryInfo.get("entryDC") == null) {
            throw new VoucherException(VoucherException.ENTRYDC_CANNOT_NULL, this.getSeq());
        }
    }

    private Integer[] getSeq() {
        Integer[] lineSeq = new Integer[]{new Integer(this.entryInfo.getSeq())};
        return lineSeq;
    }
}

