/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountViewDcCtrlUtil;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator;
import com.kingdee.eas.fm.common.util.AccountCurrencyVerifyUtil;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherEntrySubmitValidator
implements IVoucherEntryValidator {
    protected static final Logger logger = Logger.getLogger(VoucherEntrySubmitValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected VoucherInfo voucherInfo;
    protected VoucherEntryInfo entryInfo;
    private Map<String, AccountViewInfo> accCurs = new HashMap<String, AccountViewInfo>();

    public VoucherEntrySubmitValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo, BaseVoucherEntryInfo baseEntryInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        VoucherEntryInfo entryInfo = (VoucherEntryInfo)baseEntryInfo;
        this.ctx = ctx;
        this.voucherInfo = voucherInfo;
        this.entryInfo = entryInfo;
        AccountViewInfo accountViewInfo = entryInfo.getAccount();
        if (!(accountViewInfo == null || accountViewInfo.getAccountTableID() == null || voucherInfo.getCompany().getId().toString().equals(accountViewInfo.getCompanyID().getId().toString()) && voucherInfo.getCompany().getAccountTable().getId().toString().equals(accountViewInfo.getAccountTableID().getId().toString()))) {
            VoucherUtil.replaceAccount(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo.getCompany().getAccountTable().getId().toString(), entryInfo);
        }
        this.checkEntryRemark(ctx, voucherInfo, entryInfo);
        this.checkEntryAccount(ctx, voucherInfo, entryInfo);
        this.checkEntryProfitCenter(ctx, voucherInfo, entryInfo);
        this.checkEntryCurrency(ctx, voucherInfo, entryInfo);
        this.checkEntryDC(ctx, voucherInfo, entryInfo);
        this.checkEntryMeasureUnit(ctx, voucherInfo, entryInfo);
        this.checkEntryVerify(ctx, voucherInfo, entryInfo);
        this.checkEntryAmount(ctx, voucherInfo, entryInfo);
        this.checkRecordsIsNull(ctx, voucherInfo, entryInfo);
        this.checkProfitCenter(ctx, voucherInfo, entryInfo);
    }

    private void checkEntryRemark(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        String remark;
        boolean entryNeedRemark = this.sysParam.getBoolean("GL_030");
        if (entryNeedRemark && ((remark = entryInfo.getDescription()) == null || remark.trim().length() == 0)) {
            throw new VoucherException(VoucherException.ENTRY_NOT_REMARK, this.getSeq());
        }
    }

    private void checkEntryAccount(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = entryInfo.getAccount();
        if (accountViewInfo == null) {
            throw new VoucherException(VoucherException.ACCOUNT_CANNOT_NULL, this.getSeq());
        }
        boolean isFzz = this.sysParam.getBoolean("GL_008");
        boolean loadCurrency = false;
        if (isFzz) {
            this.loadAccountCurrency(ctx, accountViewInfo);
            loadCurrency = true;
            try {
                AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)ctx, (AccountViewInfo)entryInfo.getAccount(), (String)voucherInfo.getCurrency().getId().toString(), (String)voucherInfo.getCompany().getBaseCurrency().getId().toString());
            }
            catch (Exception ex) {
                throw new VoucherException(VoucherException.ACCOUNT_CURRENCY_ERROR, ex, this.getSeq());
            }
        }
        if (!voucherInfo.getSourceSys().equals((Object)SystemEnum.GENERALLEDGER)) {
            CurrencyInfo curreny;
            CurrencyInfo currencyInfo = curreny = isFzz ? voucherInfo.getCurrency() : entryInfo.getCurrency();
            if (!loadCurrency) {
                this.loadAccountCurrency(ctx, accountViewInfo);
            }
            try {
                AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)ctx, (AccountViewInfo)entryInfo.getAccount(), (String)curreny.getId().toString(), (String)voucherInfo.getCompany().getBaseCurrency().getId().toString());
            }
            catch (Exception ex) {
                throw new VoucherException(VoucherException.CURRENCY_NOT_ACCORD_ACCT, ex, new Object[]{this.getSeq()[0], accountViewInfo.getNumber() + "  " + accountViewInfo.getLongName(), curreny});
            }
        }
        if (!accountViewInfo.isIsLeaf()) {
            throw new VoucherException(VoucherException.ACCOUNT_ISNOT_LEAF, new Object[]{this.getSeq()[0], accountViewInfo.getNumber()});
        }
        if (accountViewInfo.isIsGFreeze() || accountViewInfo.isIsCFreeze() || accountViewInfo.isIsSelfFreeze()) {
            throw new VoucherException(VoucherException.ACCOUNT_FREEZE, new Object[]{this.getSeq()[0], accountViewInfo.getNumber()});
        }
    }

    private void checkEntryProfitCenter(Context ctx2, VoucherInfo voucherInfo2, VoucherEntryInfo entryInfo2) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenter = entryInfo2.getProfitCenter();
        if (profitCenter != null) {
            if (profitCenter.isIsSealUp()) {
                throw new GLException(GLException.PROFITCENTER_ISSEALUP, new Object[]{profitCenter.getName()});
            }
            String pNumber = profitCenter.getNumber();
            if (profitCenter.get("isBizUnit") == null) {
                IProfitCenterOrgUnit ProfitCenterOrgUnit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx2);
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("number", (Object)pNumber, CompareType.INCLUDE));
                fic.add(new FilterItemInfo("name", (Object)pNumber, CompareType.INCLUDE));
                filter.setMaskString("#0 OR #1");
                ProfitCenterOrgUnitInfo profitCenterinfo = null;
                ProfitCenterOrgUnitCollection profitCenterOrgUnitCollection = ProfitCenterOrgUnit.getProfitCenterOrgUnitCollection(view);
                if (profitCenterOrgUnitCollection != null && profitCenterOrgUnitCollection.size() != 0) {
                    profitCenterinfo = profitCenterOrgUnitCollection.get(0);
                }
                if (profitCenterinfo != null) {
                    profitCenter.setIsBizUnit(profitCenterinfo.isIsBizUnit());
                }
            }
            if (profitCenter.get("isBizUnit") != null && !profitCenter.isIsBizUnit()) {
                throw new GLException(GLException.PROFITCENTER_IS_NOT_BIZUNIT);
            }
        }
    }

    private void checkEntryVerify(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        boolean allowCussent;
        boolean isAdj;
        boolean bl = isAdj = voucherInfo.getSourceType() != null && voucherInfo.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT);
        if (!isAdj && (allowCussent = this.sysParam.getBoolean("GL_028"))) {
            boolean isVer;
            boolean bl2 = isVer = allowCussent && this.isVerify(entryInfo.getAccount(), entryInfo.getEntryDC());
            if (isVer != entryInfo.isIsVerify()) {
                if (isVer) {
                    entryInfo.setIsVerify(true);
                } else {
                    entryInfo.setIsVerify(false);
                }
                if (entryInfo.getOprStatus() == 0) {
                    entryInfo.setOprStatus(2);
                }
            }
        }
    }

    private void checkEntryMeasureUnit(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws VoucherException, GLException, BOSException {
        boolean useQtyAsst = this.sysParam.getBoolean("G010");
        if (!useQtyAsst && entryInfo.getAccount().isIsQty() && entryInfo.getQuantity() != null && GlUtils.zero.compareTo(entryInfo.getQuantity()) != 0 && entryInfo.getMeasureUnit() == null) {
            throw new VoucherException(VoucherException.ENTRY_NEED_MU, this.getSeq());
        }
    }

    private void checkEntryAmount(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        boolean checkAmount;
        if (entryInfo.getReportingAmount() != null && entryInfo.getReportingAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        boolean isFzz = this.sysParam.getBoolean("GL_008");
        if (!isFzz) {
            String locCurrencyID;
            String oriCurrencyID = entryInfo.getCurrency().getId().toString();
            if (oriCurrencyID.equals(locCurrencyID = voucherInfo.getCompany().getBaseCurrency().getId().toString()) && entryInfo.getOriginalAmount().compareTo(entryInfo.getLocalAmount()) != 0) {
                throw new VoucherException(VoucherException.ORI_NOT_EQUAL_LOCAL);
            }
            boolean useReportingCurrency = this.sysParam.getBoolean("G001");
            if (useReportingCurrency && voucherInfo.getCompany().getReportConvertMode() != null) {
                boolean isSettleByLocal = 3 == voucherInfo.getCompany().getReportConvertMode().getValue();
                String rptCurrencyID = voucherInfo.getCompany().getReportCurrency().getId().toString();
                if (!(voucherInfo.getSourceType() == SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT || this.sysParam.getBoolean("GL_072") && voucherInfo.getSourceType().getValue() == 1)) {
                    if (isSettleByLocal && locCurrencyID.equals(rptCurrencyID) && entryInfo.getLocalAmount().compareTo(entryInfo.getReportingAmount()) != 0) {
                        throw new VoucherException(VoucherException.LOC_NOT_EQUAL_RPT);
                    }
                    if (!isSettleByLocal && oriCurrencyID.equals(rptCurrencyID) && entryInfo.getOriginalAmount().compareTo(entryInfo.getReportingAmount()) != 0) {
                        throw new VoucherException(VoucherException.ORI_NOT_EQUAL_RPT);
                    }
                }
            }
        }
        boolean bl = checkAmount = voucherInfo.isPostedByUI() || "WebService".equals(voucherInfo.getString("entrance"));
        if (SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT == voucherInfo.getSourceType() || SourceType.PROFIT_AND_LOSS == voucherInfo.getSourceType()) {
            checkAmount = false;
        }
        boolean canSaveZero = this.sysParam.getBoolean("GL_0301");
        if (voucherInfo.isWebVoucher() ? !canSaveZero && checkAmount && entryInfo.getAssistRecords().isEmpty() && GlUtils.isAllZeroOrNull(new BigDecimal[]{entryInfo.getLocalAmount(), entryInfo.getOriginalAmount(), entryInfo.getReportingAmount(), entryInfo.getQuantity()}) : !canSaveZero && checkAmount && entryInfo.getAssistRecords().isEmpty() && GlUtils.isAllZeroOrNull(new BigDecimal[]{entryInfo.getLocalAmount(), entryInfo.getOriginalAmount(), entryInfo.getReportingAmount(), entryInfo.getQuantity()})) {
            throw new VoucherException(VoucherException.ENTRY_ZERO_AMOUNT, this.getSeq());
        }
    }

    private void checkEntryDC(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws VoucherException {
        if (entryInfo.get("entryDC") == null) {
            throw new VoucherException(VoucherException.ENTRYDC_CANNOT_NULL, this.getSeq());
        }
        EntryDC dc = entryInfo.getEntryDC();
        AccountViewInfo account = entryInfo.getAccount();
        if (AccountViewDcCtrlUtil.ctrlEntryDC((BaseVoucherInfo)voucherInfo) && !AccountViewDcCtrlUtil.verifyEntryDC((Context)ctx, (EntryDC)dc, (AccountViewInfo)account)) {
            throw new VoucherException(VoucherException.ENTRYDC_INVALID_FOR_ACCTDC_CHECKED, this.getSeq());
        }
    }

    private void checkEntryCurrency(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws VoucherException, GLException, BOSException {
        CurrencyInfo entryCur = entryInfo.getCurrency();
        if (entryCur == null) {
            throw new VoucherException(VoucherException.CURRENCY_CANNOT_NULL, this.getSeq());
        }
        AccountViewInfo acct = entryInfo.getAccount();
        CurrencyInfo localCur = voucherInfo.getCompany().getBaseCurrency();
        if (voucherInfo.getSourceType() == SourceType.NONE && acct.getAccountingcurrency() == AccountingCurrencyEnum.NOCURRENCY && !entryCur.getId().toString().equals(localCur.getId().toString())) {
            throw new VoucherException(VoucherException.NOCURRENCY_ONLY_LOCAL, new Object[]{acct.getNumber() + " " + acct.getName()});
        }
        boolean isFzz = this.sysParam.getBoolean("GL_008");
        CurrencyInfo acctCur = entryInfo.getAccount().getCurrencyID();
        if (!isFzz && acctCur != null && !acctCur.getId().equals((Object)entryCur.getId())) {
            throw new VoucherException(VoucherException.CURRENCY_NOT_ACCORD_ACCT, new Object[]{this.getSeq()[0], entryInfo.getAccount().getNumber(), entryCur.getName()});
        }
    }

    private void checkRecordsIsNull(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        if ((entryInfo.getAccount().isHasUserProperty() || entryInfo.getCAA() != null) && entryInfo.getAssistRecords().size() == 0) {
            throw new VoucherException(VoucherException.MUST_HAVE_ASSIST, this.getSeq());
        }
    }

    protected boolean isVerify(AccountViewInfo acc, EntryDC entryDC) {
        BalanceDirectionEnum accDC;
        return acc.isAC() && (BalanceDirectionEnum.DEBIT.equals((Object)(accDC = acc.getDC())) && EntryDC.CREDIT.equals((Object)entryDC) || BalanceDirectionEnum.CREDIT.equals((Object)accDC) && EntryDC.DEBIT.equals((Object)entryDC));
    }

    private Integer[] getSeq() {
        Integer[] lineSeq = new Integer[]{new Integer(this.entryInfo.getSeq())};
        return lineSeq;
    }

    private void loadAccountCurrency(Context ctx, AccountViewInfo account) throws EASBizException, BOSException {
        String accountId = account.getId().toString();
        if (this.accCurs.containsKey(accountId)) {
            AccountViewInfo info = this.accCurs.get(accountId);
            account.setAccountingcurrency(info.getAccountingcurrency());
            account.put("accountCurrency", (Object)info.getAccountCurrency());
            return;
        }
        if (this.isCurrencyEmpty(account)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("accountingcurrency"));
            sic.add(new SelectorItemInfo("accountCurrency.id"));
            sic.add(new SelectorItemInfo("accountCurrency.currency"));
            sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
            AccountViewInfo info = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(account.getId()), sic);
            this.accCurs.put(accountId, info);
            account.setAccountingcurrency(info.getAccountingcurrency());
            account.put("accountCurrency", (Object)info.getAccountCurrency());
        }
    }

    private boolean isCurrencyEmpty(AccountViewInfo account) {
        if (!account.containsKey("accountingcurrency")) {
            return true;
        }
        if (AccountingCurrencyEnum.ONECURRENCY.equals((Object)account.getAccountingcurrency())) {
            if (account.getAccountCurrency().size() == 0) {
                return true;
            }
            for (int i = 0; i < account.getAccountCurrency().size(); ++i) {
                CurrencyInfo currency = account.getAccountCurrency().get(i).getCurrency();
                if (currency != null && currency.getId() != null) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getRelatedCompanyIdsAndAccountRange(Context ctx, String profitCenterId) throws BOSException {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, "getRelatedCompanyIdsAndAccountRange");
        if (datas.containsKey(profitCenterId)) {
            return (Set)datas.get(profitCenterId);
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(profitCenterId);
        Set<String> companyIds = GlWebServiceUtil.getRelatedCompanyIdsAndAccountRange(ctx, profitCenterId);
        datas.put(profitCenterId, companyIds);
        return companyIds;
    }

    private void checkProfitCenter(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo voucherEntryInfo) throws BOSException, VoucherException {
        ProfitCenterOrgUnitInfo protifCentrOrg = voucherEntryInfo.getProfitCenter();
        if (protifCentrOrg != null) {
            boolean flag = false;
            String currentComOrgId = voucherInfo.getCompany().getId().toString();
            Set<String> companyIds = this.getRelatedCompanyIdsAndAccountRange(ctx, protifCentrOrg.getId().toString());
            Iterator<String> it = companyIds.iterator();
            while (it.hasNext()) {
                if (!currentComOrgId.equals(it.next())) continue;
                flag = true;
            }
            if (!flag) {
                throw new VoucherException(VoucherException.PROFITCENTERORGNOTMATCHCOMPANY, new Object[]{voucherEntryInfo.getSeq(), protifCentrOrg.getNumber(), voucherInfo.getCompany().getNumber()});
            }
        }
    }
}

