/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.validator.IVoucherAssistRecordValidator;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherValidator {
    protected static final Logger logger = Logger.getLogger(VoucherValidator.class);
    private List baseValidator = new ArrayList();
    private List entryValidator = new ArrayList();
    private List recordValidator = new ArrayList();

    public void validate(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        for (IVoucherBaseValidator baseValidator : this.baseValidator) {
            if (baseValidator == null) continue;
            baseValidator.validate(ctx, (BaseVoucherInfo)voucherInfo);
        }
        if (voucherInfo.getEntries() != null) {
            Iterator entryIt = voucherInfo.getEntries().iterator();
            HashMap<BOSUuid, BOSUuid> actPro = new HashMap<BOSUuid, BOSUuid>();
            HashSet<String> profitIds = new HashSet<String>();
            while (entryIt.hasNext()) {
                VoucherEntryInfo entryInfo = (VoucherEntryInfo)entryIt.next();
                if (entryInfo == null) continue;
                for (IVoucherEntryValidator entryValidator : this.entryValidator) {
                    if (entryValidator == null) continue;
                    entryValidator.validate(ctx, (BaseVoucherInfo)voucherInfo, (BaseVoucherEntryInfo)entryInfo);
                }
                if (entryInfo.getAssistRecords() != null) {
                    for (VoucherAssistRecordInfo recoredInfo : entryInfo.getAssistRecords()) {
                        if (recoredInfo == null) continue;
                        for (IVoucherAssistRecordValidator recordValidator : this.recordValidator) {
                            if (recordValidator == null) continue;
                            recordValidator.validate(ctx, (BaseVoucherInfo)voucherInfo, (BaseVoucherEntryInfo)entryInfo, (BaseVoucherAssistRecordInfo)recoredInfo);
                        }
                    }
                }
                if (voucherInfo.get("actPro") != null || entryInfo.getProfitCenter() == null || entryInfo.getAccount() == null) continue;
                actPro.put(entryInfo.getProfitCenter().getId(), entryInfo.getAccount().getId());
                profitIds.add(entryInfo.getProfitCenter().getId().toString());
            }
            if (voucherInfo.get("actPro") == null && !profitIds.isEmpty()) {
                voucherInfo.put("actPro", this.getAccountRelColl(ctx, profitIds, voucherInfo.getCompany().getId().toString(), actPro));
            }
        }
    }

    private Set<String> getAccountRelColl(Context ctx, Set profitIds, String companyId, Map actPro) {
        HashSet<String> orgRel = new HashSet<String>();
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)profitIds));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
            OrgUnitRelationCollection orl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
            OrgUnitRelationInfo ori = null;
            for (int i = 0; i < orl.size(); ++i) {
                ori = orl.get(i);
                if (companyId.equals(ori.getToUnit().getId().toString())) continue;
                orgRel.add(ori.getToUnit().getId().toString() + "@" + actPro.get(ori.getFromUnit().getId()));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return orgRel;
    }

    public void addVoucherBaseValidator(IVoucherBaseValidator validator) {
        this.baseValidator.add(validator);
    }

    public void addVoucherEntryValidator(IVoucherEntryValidator validator) {
        this.entryValidator.add(validator);
    }

    public void addVoucherAssistRecordValidator(IVoucherAssistRecordValidator validator) {
        this.recordValidator.add(validator);
    }

    public void addVoucherBaseValidatorList(List validatorList) {
        for (IVoucherBaseValidator validator : validatorList) {
            this.addVoucherBaseValidator(validator);
        }
    }

    public void addVoucherEntryValidatorList(List validatorList) {
        for (IVoucherEntryValidator validator : validatorList) {
            this.addVoucherEntryValidator(validator);
        }
    }

    public void addVoucherAssistRecordValidatorList(List validatorList) {
        for (IVoucherAssistRecordValidator validator : validatorList) {
            this.addVoucherAssistRecordValidator(validator);
        }
    }

    public List getVoucherBaseValidatorList() {
        return this.baseValidator;
    }

    public List getVoucherEntryValidatorList() {
        return this.entryValidator;
    }

    public List getVoucherAssistRecordValidatorList() {
        return this.recordValidator;
    }
}

