/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.dbclean.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CheckCanClean
extends CodeJZTask {
    public boolean doTask(JZContext context) throws JZTaskException {
        this.checkPeriod(context);
        this.checkUnVerifiedVoucher(context);
        this.checkCFRequisition(context);
        return true;
    }

    private void checkPeriod(JZContext ctx) throws JZTaskException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from T_BD_SystemStatusCtrol ssc ");
        sql.append(" inner join T_BD_SystemStatus ss on ss.fid = FSystemStatusID ");
        sql.append(" inner join T_BD_Period pe on pe.fid = ssc.FCurrentPeriodID ");
        sql.append(" where ss.fname = 6 and ssc.FCompanyID = ?");
        sql.append(" and pe.fnumber < ?");
        try {
            KDConnection con = ctx.getDbConn();
            pst = con.prepareStatement(sql.toString());
            pst.setString(1, ctx.getOrgFId());
            pst.setInt(2, ctx.getPeriodNumber());
            rs = pst.executeQuery();
            if (rs != null && rs.next()) {
                throw new JZTaskException("\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u7ed3\u8f6c\u671f\u95f4\u603b\u8d26\u6ca1\u6709\u7ed3\u8d26\uff0c\u4e0d\u80fd\u7ed3\u8f6c\uff01", 5);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException(e.getMessage(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pst);
                JZContext.closeResultSet(rs);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pst);
        JZContext.closeResultSet((ResultSet)rs);
    }

    private void checkUnVerifiedVoucher(JZContext ctx) throws JZTaskException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from t_gl_voucher v \r\n");
        sql.append("inner join t_gl_voucherentry ve on ve.fbillid = v.fid \r\n");
        sql.append("inner join t_gl_voucherassistrecord vchasst on vchasst.fentryid = ve.fid \r\n");
        sql.append("inner join t_bd_period pe on pe.fid = v.fperiodid \r\n");
        sql.append("where v.fcompanyid = ? \r\n");
        sql.append("and pe.fnumber < ? \r\n");
        sql.append("and ve.FIsVerify = 1 \r\n");
        sql.append("and vchasst.fisvierified = 0 \r\n");
        sql.append("and v.fbizstatus = 5");
        try {
            KDConnection con = ctx.getDbConn();
            pst = con.prepareStatement(sql.toString());
            pst.setString(1, ctx.getOrgFId());
            pst.setInt(2, ctx.getPeriodNumber());
            rs = pst.executeQuery();
            if (rs != null && rs.next()) {
                throw new JZTaskException("\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7 " + ctx.getOrgNumber() + " \u7684\u603b\u8d26\u7cfb\u7edf\u5728\u7ed3\u8f6c\u671f\u95f4" + Integer.toString(ctx.getYear()) + "\u5e74" + Integer.toString(ctx.getPeriod()) + "\u671f\u4e4b\u524d\u7684\u671f\u95f4\u5b58\u5728\u5c1a\u672a\u6838\u9500\u5b8c\u6bd5\u7684\u6838\u9500\u51ed\u8bc1\uff0c\u8bf7\u5148\u6838\u9500\u5b8c\u6bd5\uff01", 5);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException(e.getMessage(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pst);
                JZContext.closeResultSet(rs);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pst);
        JZContext.closeResultSet((ResultSet)rs);
    }

    private void checkCFRequisition(JZContext ctx) throws JZTaskException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 from t_gl_cfrequisition req \r\n");
        sql.append(" inner join t_gl_cashflowrecord cf on req.fcfrecordid=cf.fid \r\n");
        sql.append(" inner join t_gl_voucher v on v.fid = cf.fvoucherid \r\n");
        sql.append(" inner join t_bd_period pe on pe.fid = v.fperiodid \r\n");
        sql.append(" where \r\n");
        sql.append(" req.fsenderid = ? \r\n");
        sql.append(" and pe.fnumber < ? \r\n");
        sql.append(" and req.fstatus = '1' \r\n");
        try {
            KDConnection con = ctx.getDbConn();
            pst = con.prepareStatement(sql.toString());
            int index = 1;
            pst.setString(index++, ctx.getOrgFId());
            pst.setInt(index++, ctx.getPeriodNumber());
            rs = pst.executeQuery();
            if (rs != null && rs.next()) {
                throw new JZTaskException("\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7 " + ctx.getOrgNumber() + " \u7684\u603b\u8d26\u7cfb\u7edf\u5728\u7ed3\u8f6c\u671f\u95f4" + Integer.toString(ctx.getYear()) + "\u5e74" + Integer.toString(ctx.getPeriod()) + "\u671f\u4e4b\u524d\u7684\u671f\u95f4\u5b58\u5728\u5c1a\u672a\u52fe\u7a3d\u7684\u73b0\u91d1\u6d41\u91cf\u901a\u77e5\u5355\uff0c\u8bf7\u5148\u52fe\u7a3d\u5b8c\u6bd5\uff01", 5);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException(e.getMessage(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pst);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pst);
    }
}

