/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.bi.app.AbstractRptCellAnalysisFacadeControllerBean;
import com.kingdee.eas.fi.gr.bi.util.PeriodIterator;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.bi.util.SimplePeriod;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.CsRefBatchCalculater;
import com.kingdee.eas.fi.rpt.batch.RefMBatchCalculater;
import com.kingdee.eas.fi.rpt.excelformula.util.CellReferenceHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RptCellAnalysisFacadeControllerBean
extends AbstractRptCellAnalysisFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.bi.app.RptCellAnalysisFacadeControllerBean");
    private int fact_id;

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        boolean singleOrg;
        logger.info((Object)"Start RptCellAnalysis readySchemaSource");
        SchemaSource schema = new SchemaSource();
        schema.setCaller(RptCellAnalysisFacadeControllerBean.class);
        schema.setFilename("RptCellAnalysisSchema_" + ctx.getLocale() + ".xml");
        Integer start_year = (Integer)params.getObject("START_YEAR");
        Integer start_period = (Integer)params.getObject("START_PERIOD");
        Integer end_year = (Integer)params.getObject("END_YEAR");
        Integer end_period = (Integer)params.getObject("END_PERIOD");
        List row_titles = (List)params.getObject("ROW_TITLES");
        List col_titles = (List)params.getObject("COL_TITLES");
        String range = (String)params.getObject("RANGES");
        String template_id = (String)params.getObject("TEMPLATE_ID");
        String sheet_name = (String)params.getObject("SHEET_NAME");
        String tree_id = (String)params.getObject("ORG_TREE_ID");
        List orgs = (List)params.getObject("ORGS");
        if (tree_id == null) {
            String orgTreeID = this.getTreeIdByOrgs(ctx, orgs);
            params.setObject("ORG_TREE_ID", (Object)orgTreeID);
            tree_id = orgTreeID;
        }
        TemplateInfo templateInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection("select number, PeriodType, TemplateType where id='" + template_id + "'").get(0);
        String report_id = this.CheckReportId(ctx, (String)params.getObject("REPORT_ID"));
        if (report_id == null && (report_id = this.getReportId(ctx, tree_id, template_id, start_year.toString(), end_year.toString())) == null) {
            report_id = (String)params.getObject("REPORT_ID");
        }
        int period_type = templateInfo.getPeriodType().getValue();
        boolean show_org_sum = params.getBoolean("SHOW_ORG_SUM");
        boolean show_period_sum = params.getBoolean("SHOW_PERIOD_SUM");
        schema.setMacroValue("DynamicMeasure", this.buildMearsures(col_titles));
        schema.setMacroValue("PeriodLevel", this.getOlapTime(period_type));
        schema.setDataItem("Orgs", this.buildOrgs(ctx, orgs, tree_id), null);
        String customerTable = this.buildCustomerTable(row_titles);
        if (StringUtils.isEmpty((String)customerTable)) {
            throw new CSLReportAnlysisException(CSLReportAnlysisException.CELLANLYSISNULL);
        }
        schema.setDataItem("CustomerTable", customerTable, null);
        String periodSql = null;
        if (period_type == 3 && CslRptUtil.isSupport13Period(ctx)) {
            int sy = start_year;
            int sp = start_period;
            int ey = end_year;
            int ep = end_period;
            periodSql = RptBiUtil.buildPeriodSqlFor13q(period_type, sy, sp, ey, ep, ctx);
        } else {
            PeriodCollection periodCollection = (PeriodCollection)params.getObject("periodCollection");
            boolean isMergeByFiscalPeriod = false;
            if (params.getObject("isMergeByFiscalPeriod") == null) {
                isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
                params.setObject("isMergeByFiscalPeriod", (Object)isMergeByFiscalPeriod);
            } else {
                isMergeByFiscalPeriod = (Boolean)params.getObject("isMergeByFiscalPeriod");
            }
            periodSql = this.buildPeriod(start_year, start_period, end_year, end_period, period_type, periodCollection, isMergeByFiscalPeriod);
        }
        schema.setDataItem("Period", periodSql, null);
        boolean singlePeriod = start_year.intValue() == end_year.intValue() && start_period.intValue() == end_period.intValue();
        boolean bl = singleOrg = orgs.size() == 1;
        if (singlePeriod) {
            schema.setMacroValue("PeriodUseage", "");
        } else {
            schema.setMacroValue("PeriodUseage", "<DimensionUsage name=\"Period\" foreignKey=\"FPeriodID\"/>");
        }
        if (singleOrg) {
            schema.setMacroValue("OrgsUseage", "");
        } else {
            schema.setMacroValue("OrgsUseage", "<DimensionUsage name=\"Orgs\" foreignKey=\"FOrgID\"/>");
        }
        schema.setDataItem("Fact", this.buildFactTable(ctx, schema, templateInfo, report_id, orgs, start_year, start_period, end_year, end_period, sheet_name, range, period_type, params, false, row_titles, col_titles), null);
        schema.setMdx(this.makeMdx(singlePeriod, singleOrg, show_org_sum, show_period_sum, ctx));
        return schema;
    }

    private String getReportId(Context ctx, String tree_id, String template_id, String start_year, String end_year) throws BOSException {
        IRowSet rs;
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        if (tree_id != null) {
            sql.append("select fid from t_csl_cslreport where forgtreeid in\t\n");
            sql.append("(select fid from t_org_tree where fnumber = \t\t\n");
            sql.append("(select fNumber from t_org_tree where fid = ?))\t\t\n");
            sql.append(" and ftemplateid = ? and (fyear between ? and ?\t)\t\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{tree_id, template_id, start_year, end_year});
        } else {
            sql.append("select fid from t_csl_cslreport where ");
            sql.append(" ftemplateid = ? and (fyear between ? and ?\t)\t\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{template_id, start_year, end_year});
        }
        try {
            while (rs.next()) {
                list.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String report_id = null;
        for (int i = 0; i < list.size(); ++i) {
            if (this.CheckReportId(ctx, list.get(i).toString()) == null) continue;
            report_id = list.get(i).toString();
            return report_id;
        }
        return report_id;
    }

    private String CheckReportId(Context ctx, String report_id) throws BOSException {
        String sql = "select * from T_CSL_SUMRPTRELA where Freportid <> 'empty_company' and FSumReportID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{report_id});
        try {
            if (rs.next()) {
                return report_id;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private String getTreeIdByOrgs(Context ctx, List orgs) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        for (CoreBaseInfo object : orgs) {
            ids.add(object.getId().toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select t.fid id from T_ORG_Structure o  \t\t\n");
        sql.append("inner join T_ORG_Tree t on o.FTreeid = t.fid \t\n");
        sql.append("where funitid in    \t\t\t\t\t\t\t\n");
        sql.append(RptUtilForServer.createInStringSql(ids.iterator(), (Context)ctx)).append("\n");
        sql.append("and t.ftype = 8 \t\t\t\t\t\t\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                return rowSet.getString("id");
            }
            return null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String makeMdx(boolean singlePeriod, boolean singleOrg, boolean show_org_sum, boolean show_period_sum, Context ctx) {
        StringBuffer sb = new StringBuffer();
        if (!singlePeriod && show_period_sum) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"7_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        }
        if (!singleOrg && show_org_sum) {
            if (sb.length() < 1) {
                sb.append("With ");
            }
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"8_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        }
        sb.append("SELECT ").append(singleOrg ? "" : "{Orgs.Members" + (show_org_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"9_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*").append(singlePeriod ? "" : "{Period.Members" + (show_period_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"10_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*").append("Measures.Members ON rows, CustomerDim.Members ON columns FROM Fact");
        return sb.toString();
    }

    private String buildPeriod(int start_year, int start_period, int end_year, int end_period, int period_type, PeriodCollection periodCollection, boolean isMergeByFiscalPeriod) {
        return RptBiUtil.buildPeriodSQL(start_year, start_period, end_year, end_period, period_type, periodCollection, isMergeByFiscalPeriod);
    }

    private String getOlapTime(int period_type) {
        return RptBiUtil.getBIPeriodSegment(period_type);
    }

    /*
     * Unable to fully structure code
     */
    private String buildFactTable(Context ctx, SchemaSource schema, TemplateInfo templateInfo, String report_id, List orgs, Integer start_year, Integer start_period, Integer end_year, Integer end_period, String sheet_name, String range, int period_type, RptParams params, boolean isAdjusted, List rowTitles, List colTitles) throws BOSException, EASBizException {
        ranges = new SumcalcRange();
        ranges.addRange(range);
        Company_template_Number = null;
        Sum_template_Number = null;
        if (params.getInt("REPORT_TYPE") == 1) {
            Sum_template_Number = Company_template_Number = templateInfo.getNumber();
        } else if (templateInfo.getTemplateType() == RptTmpTypeEnum.SUMREPORT) {
            Sum_template_Number = templateInfo.getNumber();
            sql = "select t.FNumber from t_rpt_template t inner join t_csl_cslreport r on t.fid=r.ftemplateid inner join T_CSL_SUMRPTRELA s on s.FReportID=R.FID where s.FSumReportID=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{report_id});
            try {
                if (!rs.next()) ** GOTO lbl27
                Company_template_Number = rs.getString("FNumber");
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            Company_template_Number = templateInfo.getNumber();
            sql = "select t.FNumber as FNumber from T_CSL_SUMRPTRELA s inner join t_csl_cslreport cr on cr.FID=s.FSumReportID inner join t_rpt_report r on r.FCslReportID=s.FReportID inner join t_rpt_template t on t.FID = cr.fTemplateid where r.FID= ? union select t.FNumber from T_CSL_SUMRPTRELA s inner join t_csl_cslreport r on r.FID=s.FReportID inner join t_csl_cslreport cr on cr.FID=s.FSumReportID inner join t_rpt_template t on t.FID = cr.fTemplateid where r.FID=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{report_id, report_id});
            try {
                if (rs.next()) {
                    Sum_template_Number = rs.getString("FNumber");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
lbl27:
        // 4 sources

        tempTableName = RptCellAnalysisFacadeControllerBean.getTempTableName((String)"RptCellAnalysisTable", (Context)ctx);
        insert = new StringBuffer("select 1000000000 AS FID, 'NnLRpgESEADgAAkVfwAAAcznrtQ=NnLRpgESEADgAAkVfwAAAcznrtQ=' AS FOrgID , 2007000008 as FPeriodID , 99999999 as FCustomerDimID ");
        for (i = 0; i < colTitles.size(); ++i) {
            insert.append(" ");
            insert.append(", 99999999999999999.9999999 as fm").append(i);
        }
        RptCellAnalysisFacadeControllerBean.executeSelectInto((String)("select * into " + tempTableName + " from (" + insert.toString() + ") as A"), null, (Context)ctx);
        DbUtil.execute((Context)ctx, (String)("delete from " + tempTableName));
        schema.setProperty("TEMP_TABLE", (Object)tempTableName);
        periodCollection = (PeriodCollection)params.getObject("periodCollection");
        isMergeByFiscalPeriod = false;
        isSupport13Period = CslRptUtil.isSupport13Period(ctx);
        if (!isSupport13Period) {
            isMergeByFiscalPeriod = params.getObject("isMergeByFiscalPeriod") == null ? CslRptUtil.isMergeByFiscalPeriod(ctx) : (Boolean)params.getObject("isMergeByFiscalPeriod");
        }
        for (i = 0; i < orgs.size(); ++i) {
            orginfo = (OrgUnitInfo)orgs.get(i);
            if (period_type == 3 && isSupport13Period) {
                sy = start_year;
                sp = start_period;
                ey = end_year;
                ep = end_period;
                periodListFor13q = RptBiUtil.getPeriodListFor13q(sy, sp, ey, ep, period_type);
                for (SimplePeriod simplePeriod : periodListFor13q) {
                    this.buildSingleRptData(ctx, orginfo, params.getInt("REPORT_TYPE") == 2 ? Sum_template_Number : Company_template_Number, simplePeriod, sheet_name, ranges, params, isAdjusted, period_type, tempTableName, rowTitles, colTitles, templateInfo, report_id);
                }
                continue;
            }
            it = new PeriodIterator(start_year, end_year, start_period, end_period, period_type, periodCollection, isMergeByFiscalPeriod);
            while (it.hasNext()) {
                next = it.next();
                this.buildSingleRptData(ctx, orginfo, params.getInt("REPORT_TYPE") == 2 ? Sum_template_Number : Company_template_Number, next, sheet_name, ranges, params, isAdjusted, period_type, tempTableName, rowTitles, colTitles, templateInfo, report_id);
            }
        }
        return "select * from " + tempTableName;
    }

    private boolean isLeafCompany(OrgUnitInfo orginfo) {
        if (orginfo instanceof CompanyOrgUnitInfo) {
            return true;
        }
        if (orginfo instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)orginfo;
            return !fullOrgUnitInfo.isIsGrouping();
        }
        return false;
    }

    public static void main(String[] args) {
        BitSet set = new BitSet();
        set.set(0);
        set.set(5);
        set.set(15);
        set.set(15);
        set.set(32);
    }

    private void buildSingleRptData(Context ctx, OrgUnitInfo org, String tempCode, SimplePeriod period, String sheetName, SumcalcRange ranges, RptParams params, boolean isAdjusted, int period_type, String tempTableName, List rowTitles, List colTitles, TemplateInfo templateInfo, String report_id) throws BOSException, EASBizException {
        Parameter[][] matrix = null;
        ArrayList customerdim = (ArrayList)params.getObject("ROW_TITLES");
        matrix = params.getInt("REPORT_TYPE") == 1 && !params.getBoolean("IS_CSL_REPORT") || params.getBoolean("IS_NORMAL_REPORT") ? this.buildRefmMatrix(ctx, org, tempCode, period, sheetName, ranges, params, isAdjusted, period_type, rowTitles, colTitles, templateInfo) : this.buildCsRefMatrix(ctx, org, tempCode, period, sheetName, ranges, params, isAdjusted, period_type, rowTitles, colTitles, report_id);
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTableName).append(" values (?, ? , ? ,? ");
        for (int col = 0; col < colTitles.size(); ++col) {
            sql.append(" ,? ");
        }
        sql.append(")");
        Object[][] batchParams = new Object[matrix.length][];
        HashMap<String, Integer> idtocustomerdim = new HashMap<String, Integer>();
        for (int row = 0; row < matrix.length; ++row) {
            ++this.fact_id;
            ArrayList<Object> pps = new ArrayList<Object>();
            pps.add(new Integer(this.fact_id));
            pps.add(org.getNumber());
            pps.add(period_type == 6 ? new Integer(period.year) : new Integer(period.generateID()));
            boolean content = false;
            for (int i = 0; i < customerdim.size() && i != row; ++i) {
                if (i == row || !customerdim.get(i).equals(customerdim.get(row))) continue;
                content = true;
                Integer num = (Integer)idtocustomerdim.get(new Integer(i).toString());
                pps.add(num);
                break;
            }
            if (!content) {
                Integer num = new Integer(row);
                pps.add(new Integer(row));
                idtocustomerdim.put(new Integer(row).toString(), num);
            }
            boolean allnull = true;
            for (int col = 0; col < matrix[row].length; ++col) {
                BigDecimal value;
                Parameter pa = matrix[row][col];
                if (pa != null) {
                    allnull = false;
                }
                BigDecimal bigDecimal = value = pa == null || pa.getValue() == null || StringUtils.isEmpty((String)pa.getValue().toString()) ? CslConstant.BGZERO : pa.getValue();
                if (((Object)value).toString().startsWith("BAD FUNCTION")) {
                    value = CslConstant.BGZERO;
                } else {
                    try {
                        BigDecimal bigDecimal2;
                        value = bigDecimal2 = new Variant((Object)value).toBigDecimal();
                    }
                    catch (SyntaxErrorException e) {
                        value = CslConstant.BGZERO;
                    }
                }
                pps.add(value);
            }
            if (allnull) continue;
            if (matrix[row].length < colTitles.size()) {
                for (int i = matrix[row].length; i < colTitles.size(); ++i) {
                    pps.add(CslConstant.BGZERO);
                }
            }
            batchParams[row] = pps.toArray();
        }
        try {
            CslRptUtil.batchExecute(ctx, sql.toString(), batchParams);
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("007", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"11_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale())));
        }
    }

    private Parameter[][] buildRefmMatrix(Context ctx, OrgUnitInfo org, String tempCode, SimplePeriod period, String sheetName, SumcalcRange ranges, RptParams param, boolean isAdjusted, int period_type, List rowTitles, List colTitles, TemplateInfo templateInfo) throws BOSException, EASBizException {
        SortedParameterArray params = new SortedParameterArray();
        BitSet colbit = new BitSet();
        BitSet rowbit = new BitSet();
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getCellBlock(i);
            for (int row = block.getRow(); row <= block.getRow2(); ++row) {
                for (int col = block.getCol(); col <= block.getCol2(); ++col) {
                    colbit.set(col);
                    rowbit.set(row);
                }
            }
        }
        String currency = param.getString("CURRENCY_NUMBER");
        String dataCollectNumber = param.getString("KEY_DATACOLLECT_NUMBER");
        Parameter[][] matrix = new Parameter[rowTitles.size()][colTitles.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getCellBlock(i);
            for (int row = block.getRow(); row <= block.getRow2(); ++row) {
                for (int col = block.getCol(); col <= block.getCol2(); ++col) {
                    Variant[] v10 = new Variant[9];
                    v10[0] = new Variant((Object)org.getNumber());
                    RptTmpTypeEnum templateType = templateInfo.getTemplateType();
                    if (templateType == RptTmpTypeEnum.COMMONPUBLICTEMPLATE) {
                        v10[1] = new Variant((Object)templateType.getName());
                    } else if (templateType.getValue() == 2) {
                        TemplateCollection coll = TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection("select templateType where number = '" + templateInfo.getNumber() + "' and versionStatus = " + 1 + " and isFreezed = 0 and isK3Tpl = 0 and templateType in (6,10) ");
                        if (coll.size() == 1) {
                            TemplateInfo info = coll.get(0);
                            v10[1] = info.getTemplateType().getValue() == 10 ? new Variant((Object)RptTmpTypeEnum.RPTDYNAMICREPORT.getName()) : new Variant((Object)info.getTemplateType().getName());
                        } else if (coll.size() > 1) {
                            String groupTemplateid = templateInfo.getGroupTemplate().getId().toString();
                            TemplateInfo info = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(groupTemplateid));
                            v10[1] = new Variant((Object)info.getTemplateType().getName());
                        }
                    } else {
                        v10[1] = new Variant((Object)(templateType.getValue() == 1 ? RptTmpTypeEnum.COMMONREPORT.getName() : (templateType.getValue() == 6 ? RptTmpTypeEnum.GROUPCOMMREPORT.getName() : (templateType.getValue() == 15 ? RptTmpTypeEnum.MULTIDYNAMICCSLREPORT.getName() : RptTmpTypeEnum.DYNAMICNORMALREPORT.getName()))));
                    }
                    v10[2] = new Variant((Object)tempCode);
                    v10[3] = new Variant(period.year);
                    v10[4] = new Variant(period.period);
                    v10[5] = new Variant((Object)sheetName);
                    v10[6] = new Variant((Object)CellReferenceHelper.xy2Area((int)row, (int)col));
                    v10[7] = new Variant((Object)currency);
                    v10[8] = new Variant((Object)dataCollectNumber);
                    Parameter p = new Parameter(new Object[]{v10}, sheetName);
                    params.insert((Object)p);
                    matrix[RptCellAnalysisFacadeControllerBean.getSite((BitSet)rowbit, (int)row) - 1][RptCellAnalysisFacadeControllerBean.getSite((BitSet)colbit, (int)col) - 1] = p;
                }
            }
        }
        String report_id = (String)param.getObject("REPORT_ID");
        if (!StringUtils.isEmpty((String)report_id)) {
            ctx.put((Object)"report_id", (Object)report_id);
        }
        RefMBatchCalculater Benz = new RefMBatchCalculater((ICalculateContextProvider)new MyCalculateContext(period_type, period.period, period.year, ctx), ctx);
        Benz.execute(params, "refm");
        return matrix;
    }

    private Parameter[][] buildCsRefMatrix(Context ctx, OrgUnitInfo org, String tempCode, SimplePeriod period, String sheetName, SumcalcRange ranges, RptParams param, boolean isAdjusted, int period_type, List rowTitles, List colTitles, String report_id) throws EASBizException, BOSException {
        String currency = param.getString("CURRENCY_NUMBER");
        String sourceCurrency = param.getString("SRC_CURRENCY_NUMBER");
        OrgTreeInfo treeInfo = null;
        if (org instanceof FullOrgUnitInfo) {
            String tree_id = (String)param.getObject("ORG_TREE_ID");
            treeInfo = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(tree_id));
        }
        SortedParameterArray params = new SortedParameterArray();
        BitSet colbit = new BitSet();
        BitSet rowbit = new BitSet();
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getCellBlock(i);
            for (int row = block.getRow(); row <= block.getRow2(); ++row) {
                for (int col = block.getCol(); col <= block.getCol2(); ++col) {
                    colbit.set(col);
                    rowbit.set(row);
                }
            }
        }
        boolean isCompany = org.isIsCompanyOrgUnit() && param.getInt("REPORT_TYPE") == 2;
        String companyTemplateNumber = null;
        if (isCompany) {
            companyTemplateNumber = this.getCompanyTemplateNumber(ctx, org.getId().toString(), report_id);
            isCompany = isCompany && companyTemplateNumber != null;
        }
        Parameter[][] matrix = new Parameter[rowTitles.size()][colTitles.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getCellBlock(i);
            for (int row = block.getRow(); row <= block.getRow2(); ++row) {
                for (int col = block.getCol(); col <= block.getCol2(); ++col) {
                    Variant[] v10 = new Variant[10];
                    String orgnumber = org.getNumber();
                    if (treeInfo != null) {
                        orgnumber = treeInfo.getNumber() + "!" + orgnumber;
                    }
                    v10[0] = new Variant((Object)orgnumber);
                    v10[1] = isCompany ? new Variant((Object)companyTemplateNumber) : new Variant((Object)tempCode);
                    v10[2] = new Variant((Object)(this.isLeafCompany(org) ? RptTmpTypeEnum.GROUPCOMMREPORT.getName() : RptTmpTypeEnum.SUMREPORT.getName()));
                    v10[3] = new Variant(period.year);
                    v10[4] = new Variant(period.period);
                    v10[5] = new Variant((Object)sheetName);
                    v10[6] = new Variant((Object)CellReferenceHelper.xy2Area((int)row, (int)col));
                    v10[7] = new Variant((Object)currency);
                    v10[8] = new Variant((Object)(sourceCurrency == null ? currency : sourceCurrency));
                    v10[9] = new Variant(isAdjusted);
                    Parameter p = new Parameter(new Object[]{v10}, sheetName);
                    params.insert((Object)p);
                    matrix[RptCellAnalysisFacadeControllerBean.getSite((BitSet)rowbit, (int)row) - 1][RptCellAnalysisFacadeControllerBean.getSite((BitSet)colbit, (int)col) - 1] = p;
                }
            }
        }
        MyCalculateContext myCtx = new MyCalculateContext(period_type, period.period, period.year, ctx);
        CsRefBatchCalculater BMW = new CsRefBatchCalculater((ICalculateContextProvider)myCtx, ctx);
        BMW.execute(params);
        return matrix;
    }

    private String getCompanyTemplateNumber(Context ctx, String orgID, String report_id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("  select distinct template.FNumber templateNumber from T_RPT_template template  \n");
        sql.append("  inner join  T_CSL_CslReport cslReport on cslReport.FTemplateID = template.FID \n");
        sql.append("  where cslReport. FCompanyID = ? and \t\n");
        sql.append("  exists (      \n");
        sql.append(" \tselect * from T_CSL_SumRptRela sumRptRela where cslReport.FID = sumRptRela.FReportID and  \n");
        sql.append("    sumRptRela.FSumReportID = ?    \n");
        sql.append("  )    \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgID, report_id});
        try {
            if (rowSet.next()) {
                return rowSet.getString("templateNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    private static int getSite(BitSet bitset, int idx) {
        int count = 0;
        int i = 0;
        while (i <= idx) {
            int next = bitset.nextSetBit(i);
            if (next == -1) {
                return -1;
            }
            i = next + 1;
            ++count;
        }
        return count;
    }

    private String buildCustomerTable(List row_titles) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < row_titles.size(); ++i) {
            if (StringUtils.isEmpty((String)((String)row_titles.get(i)))) continue;
            if (sb.length() == 0) {
                sb.append("SELECT ").append(i).append(" AS FID, '").append(row_titles.get(i)).append("' AS FName \n");
            }
            if (sb.indexOf((String)row_titles.get(i)) != -1 || i >= row_titles.size() || i == 0) continue;
            sb.append(" UNION ALL \n");
            sb.append("SELECT ").append(i).append(" AS FID, '").append(row_titles.get(i)).append("' AS FName \n");
        }
        return sb.toString();
    }

    private String buildOrgs(Context ctx, List orgs, String tree_id) throws BOSException {
        return RptBiUtil.buildOrgs(ctx, orgs, tree_id);
    }

    private String buildMearsures(List col_titles) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < col_titles.size(); ++i) {
            sb.append("<Measure name=\"m").append(i).append("\" caption=\"").append(RptBiUtil.toXmlString(col_titles.get(i) == null ? "" : col_titles.get(i).toString())).append("\" column=\"fm").append(i).append("\" aggregator=\"sum\" formatString=\"#,##0.00\"/>\n");
        }
        return sb.toString();
    }

    protected List _getOrgNode(Context ctx, List orgs) throws BOSException {
        return null;
    }

    private final class MyCalculateContext
    implements ICalculateContextProvider {
        private final int period_type;
        private final int rptperiod;
        private final int rptyear;
        private CSLPropertyAdapter propertyAdapter;
        private Context ctx;

        private MyCalculateContext(int period_type, int rptperiod, int rptyear, Context ctx) {
            this.period_type = period_type;
            this.rptperiod = rptperiod;
            this.rptyear = rptyear;
            this.ctx = ctx;
        }

        public IErrorProvider getErrorProvider() {
            return null;
        }

        public IErrorResultProvider getErrorResultProvider() {
            return null;
        }

        public IReportPropertyAdapter getReportAdapter() {
            if (this.propertyAdapter == null) {
                this.propertyAdapter = new CSLPropertyAdapter();
                this.propertyAdapter.setReportProperty("Report.Year", this.rptyear);
                this.propertyAdapter.setReportProperty("Report.Period", this.rptperiod);
                this.propertyAdapter.setReportProperty("PeriodType", this.period_type);
            }
            return this.propertyAdapter;
        }

        public ReportVariables getReportVariables() {
            return null;
        }

        public Context getServerContext() {
            return this.ctx;
        }
    }
}

