/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.bi.util.PeriodIterator;
import com.kingdee.eas.fi.gr.bi.util.SimplePeriod;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.RptItemQuery;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class RptBiUtil {
    public static final String ITEM_TEMP_TABLE = "ITEM_TEMP_TABLE";
    public static final String BI_RESOURCE_PATH = "com.kingdee.eas.fi.gr.bi.CslBIResource";
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";

    public static final String buildPeriodSQL(int start_year, int start_period, int end_year, int end_period, int period_type, PeriodCollection periods, boolean isMergeByFiscalPeriod) {
        PeriodIterator it = new PeriodIterator(start_year, end_year, start_period, end_period, period_type, periods, isMergeByFiscalPeriod);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (it.hasNext()) {
            if (i != 0) {
                sb.append("\n UNION ALL ");
            } else {
                ++i;
            }
            SimplePeriod next = it.next();
            sb.append("select ").append(next.generateID()).append(" As FID , '").append(next.toString()).append("' as FNumber ");
        }
        return sb.toString();
    }

    public static final String getBIPeriodSegment(int period_type) {
        StringBuffer sb = new StringBuffer();
        sb.append("<Level name=\"Period\" column=\"FNumber\" orderBy=\"FID\"> ");
        sb.append("<Property  name=\"Period\" column=\"FNumber\" />");
        sb.append("</Level>");
        sb.append('\n');
        return sb.toString();
    }

    public static final String buildOrgs(Context ctx, List orgs, String tree_id) throws BOSException {
        return RptBiUtil.buildOrgs(ctx, orgs, tree_id, false);
    }

    public static final String buildOrgs(Context ctx, List orgs, String tree_id, boolean displayElimData) throws BOSException {
        StringBuffer sba = new StringBuffer();
        ParamTempTblService tblService = null;
        String tblName = null;
        ArrayList<String> units = new ArrayList<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            OrgUnitInfo info = (OrgUnitInfo)orgs.get(i);
            if (i != 0) {
                sba.append(',');
            }
            if (tree_id != null) {
                sba.append('\'').append(info.getNumber()).append('\'');
                units.add(info.getNumber());
                continue;
            }
            sba.append('\'').append(info.getId().toString()).append('\'');
            units.add(info.getId().toString());
        }
        if (orgs.size() > 100) {
            tblService = RptBiUtil.getTemplateUnitService(ctx, units);
            tblName = tblService.getTmpTableName();
        }
        String sql = null;
        if (tree_id != null) {
            sql = "select distinct st.FUnitID, u.FNumber as FID, up.FNUmber as FParentID from t_org_structure st                                                  inner join t_org_baseunit u on u.FID=st.FUnitID                          left join t_org_structure stp on stp.FID=st.FParentID                    left join t_org_baseunit up on up.FID=stp.FUnitID                        ";
            sql = tblName != null ? sql + "where st.FTreeID = '" + tree_id + "'  and u.FNumber in ( select Funitid from " + tblName + " )" : sql + "where st.FTreeID = '" + tree_id + "'  and u.FNumber in (" + sba.toString() + ")";
        } else {
            sql = tblName != null ? "select distinct FID As FUnitID, FID, FParentID from t_org_baseunit where FID in ( select Funitid from " + tblName + " )" : "select distinct FID As FUnitID, FID, FParentID from t_org_baseunit where FID in (" + sba.toString() + ")";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<OrgUnitInfo> elimNodes = new ArrayList<OrgUnitInfo>();
        int unitCount = 0;
        try {
            block6: while (rs.next()) {
                String unitid = tree_id != null ? rs.getString("FID") : rs.getString("FUnitID");
                for (int i = 0; i < orgs.size(); ++i) {
                    String right;
                    OrgUnitInfo info = (OrgUnitInfo)orgs.get(i);
                    String string = right = tree_id != null ? info.getNumber() : info.getId().toString();
                    if (!unitid.equals(right)) continue;
                    info.setString("BI_ID", rs.getString("FID"));
                    info.setString("BI_ParentID", rs.getString("FParentID"));
                    info.setInt("BI_Index", i + unitCount);
                    if (!info.isIsUnion() || !displayElimData) continue block6;
                    ++unitCount;
                    info = (OrgUnitInfo)info.clone();
                    info.setString("BI_ParentID", info.getNumber());
                    info.setName(info.getName() + "-" + ResourceBase.getString((String)BI_RESOURCE_PATH, (String)"ElimData", (Locale)ctx.getLocale()));
                    info.setString("BI_ID", "0000" + info.getString("BI_ID") + "Elim");
                    info.setNumber(info.getString("BI_ID"));
                    info.setInt("BI_Index", i + unitCount);
                    elimNodes.add(info);
                    continue block6;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tblService != null) {
                tblService.release();
            }
        }
        ArrayList combieOrgs = new ArrayList();
        combieOrgs.addAll(orgs);
        combieOrgs.addAll(elimNodes);
        orgs = combieOrgs;
        StringBuffer sb = new StringBuffer();
        if (orgs.size() > 5 && "true".equals(ctx.get((Object)"useTempTbl"))) {
            String tempTblName = RptBiUtil.createOrgBuildtTmpTbl(ctx, orgs);
            ctx.put((Object)"tempTbl", (Object)tempTblName);
            sb.append(" select * from ").append(tempTblName);
        } else {
            for (int i = 0; i < orgs.size(); ++i) {
                OrgUnitInfo info = (OrgUnitInfo)orgs.get(i);
                sb.append("SELECT '").append(info.getNumber()).append("' AS FID, '").append(info.getNumber()).append("' AS FNumber, '").append(info.getName()).append("' AS FName, '").append(info.getString("BI_ID") == null ? info.getNumber() : info.getString("BI_ID")).append("' AS BI_ID, '").append(info.getString("BI_ParentID")).append("' AS BI_ParentID").append(", " + info.getInt("BI_Index") + " AS BI_Index");
                if (i >= orgs.size() - 1) continue;
                sb.append(" UNION ALL \n");
            }
        }
        return sb.toString();
    }

    private static ParamTempTblService getTemplateUnitService(Context ctx, List orgs) throws BOSException {
        TableInfo table = new TableInfo("t_tmp_orgunit");
        table.addColumn(new ColumnInfo("Funitid", "nvarchar(80)"));
        ParamTempTblService service = ParamTempTblService.getInstance(ctx, table, orgs, null);
        return service;
    }

    private static String createOrgBuildtTmpTbl(Context ctx, List orgs) throws BOSException {
        String tableName;
        StringBuffer createSql = new StringBuffer(400);
        createSql.append(" create table T_ORGBUILD_TMPTBL(").append(" FID NVARCHAR(80),FNumber NVARCHAR(80),FName NVARCHAR(255),").append(" BI_ID NVARCHAR(80),BI_ParentID VARCHAR(80),BI_Index INT)");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            prepareStatement = connection.prepareStatement("insert into " + tableName + " (FID,FNumber,FName,BI_ID,BI_ParentID,BI_Index) values (?,?,?,?,?,?)");
            for (int i = 0; i < orgs.size(); ++i) {
                OrgUnitInfo info = (OrgUnitInfo)orgs.get(i);
                prepareStatement.setString(1, info.getNumber());
                prepareStatement.setString(2, info.getNumber());
                prepareStatement.setString(3, info.getName());
                prepareStatement.setString(4, info.getString("BI_ID") == null ? info.getNumber() : info.getString("BI_ID"));
                prepareStatement.setString(5, info.getString("BI_ParentID"));
                prepareStatement.setInt(6, info.getInt("BI_Index"));
                prepareStatement.addBatch();
            }
            prepareStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, prepareStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)prepareStatement, (Connection)connection);
        return tableName;
    }

    public static ArrayList getRptItemCollection(List itemNumbers) throws BOSException {
        return RptBiUtil.getRptItemCollection(itemNumbers, true);
    }

    public static ArrayList getRptItemCollection(List itemNumbers, boolean includeFreezed) throws BOSException {
        RptItemQuery itemQuery = new RptItemQuery();
        itemQuery.setQueryReportClass(true);
        itemQuery.setNumberList(itemNumbers);
        itemQuery.setIncludeFreezed(includeFreezed);
        return RptBiUtil.getRptItemCollection(itemNumbers, itemQuery);
    }

    public static ArrayList getRptItemCollection(List itemNumbers, boolean includeFreezed, RPTItemGroupEnum itemGroup) throws BOSException {
        RptItemQuery itemQuery = new RptItemQuery();
        itemQuery.setQueryReportClass(true);
        itemQuery.setNumberList(itemNumbers);
        itemQuery.setIncludeFreezed(includeFreezed);
        itemQuery.setItemGroup(itemGroup);
        return RptBiUtil.getRptItemCollection(itemNumbers, itemQuery);
    }

    public static ArrayList getRptItemCollection(List itemNumbers, String rptCompanyId, boolean includeFreezed) throws BOSException {
        RptItemQuery itemQuery = new RptItemQuery();
        itemQuery.setQueryReportClass(true);
        itemQuery.setNumberList(itemNumbers);
        itemQuery.setIncludeFreezed(includeFreezed);
        itemQuery.setCompanyId(rptCompanyId);
        return RptBiUtil.getRptItemCollection(itemNumbers, itemQuery);
    }

    private static ArrayList getRptItemCollection(List itemNumbers, RptItemQuery itemQuery) throws BOSException {
        RPTItemCollection rptItemCL = RPTItemFactory.getRemoteInstance().getCollectionNoChild(itemQuery);
        ArrayList<Object> contents = new ArrayList<Object>(rptItemCL.size());
        if (itemNumbers == null) {
            CslRptUtil.addCollectionToArrayList(contents, (IObjectCollection)rptItemCL);
        } else {
            for (int i = 0; i < itemNumbers.size(); ++i) {
                Object findInfoBy = RptBiUtil.findInfoBy("number", itemNumbers.get(i), (IObjectCollection)rptItemCL);
                if (findInfoBy == null) continue;
                contents.add(findInfoBy);
            }
        }
        return contents.size() < 1 ? null : contents;
    }

    public static Object findInfoBy(String field, Object value, IObjectCollection coll) {
        if (value == null) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            IObjectValue object = coll.getObject(i);
            if (!value.equals(object.get(field).toString())) continue;
            return object;
        }
        return null;
    }

    public static ArrayList findFetchTypes(List numbers, String companyId) throws BOSException {
        DataElementCollection dataElements;
        try {
            EntityViewInfo viewInfo;
            if (numbers != null) {
                viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", new HashSet(numbers), CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                CslGradeManageUtil.filterDataElementGradeManage((EntityViewInfo)viewInfo, (String)companyId);
                dataElements = DataElementFactory.getRemoteInstance().getDataElementCollection(viewInfo);
            } else {
                viewInfo = CslGradeManageUtil.filterDataElementGradeManage(null, (String)companyId);
                dataElements = DataElementFactory.getRemoteInstance().getDataElementCollection(viewInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList<Object> contents = new ArrayList<Object>(dataElements.size());
        if (numbers == null) {
            CslRptUtil.addCollectionToArrayList(contents, (IObjectCollection)dataElements);
        } else {
            for (int i = 0; i < numbers.size(); ++i) {
                Object findInfoBy = RptBiUtil.findInfoBy("number", numbers.get(i), (IObjectCollection)dataElements);
                if (findInfoBy == null) continue;
                contents.add(findInfoBy);
            }
        }
        return contents;
    }

    public static ArrayList findFetchTypes(List numbers) throws BOSException {
        return RptBiUtil.findFetchTypes(numbers, null);
    }

    public static String buildItemSQL(List items) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.size(); ++i) {
            if (i != 0) {
                sb.append("\n UNION ALL ");
            }
            RPTItemInfo info = (RPTItemInfo)items.get(i);
            sb.append(" SELECT '").append(info.getNumber()).append("' AS FNumber, '").append(info.getName()).append("' AS FName, ").append(i).append(" AS FSEQ ");
        }
        return sb.toString();
    }

    public static String buildItemSQLByTempTable(Context ctx, SchemaSource schema, List items) throws BOSException {
        String tableName = null;
        try {
            tableName = TempTablePool.getInstance((Context)ctx).createTempTable("Create Table ITEM_TEMP_TABLE ( FNumber NVARCHAR(80), FName NVARCHAR(80),FSEQ INT )");
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        schema.setProperty(ITEM_TEMP_TABLE, (Object)tableName);
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            prepareStatement = connection.prepareStatement("insert into " + tableName + " (FNumber,FName,FSEQ) values (?,?,?)");
            for (int i = 0; i < items.size(); ++i) {
                RPTItemInfo info = (RPTItemInfo)items.get(i);
                prepareStatement.setString(1, info.getNumber());
                prepareStatement.setString(2, info.getName());
                prepareStatement.setInt(3, i);
                prepareStatement.addBatch();
            }
            prepareStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, prepareStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)prepareStatement, (Connection)connection);
        return "Select FNumber , FName , FSEQ from " + tableName;
    }

    public static String buildFetchType(RptParams params) {
        List fetchType = (List)params.getObject("FETCH_TYPE");
        String dataFormatString = "#,##0.00";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fetchType.size(); ++i) {
            DataElementInfo info = (DataElementInfo)fetchType.get(i);
            String number = (String)info.get("extNumber") == null ? info.getNumber() : (String)info.get("extNumber");
            sb.append("<Measure name=\"m").append(i).append("\" caption=\"").append(info.getName()).append("\" column=\"F").append(RptBiUtil.reviseColName(number)).append("\" aggregator=\"sum\" formatString=\"").append(dataFormatString).append("\"/>\n");
        }
        return sb.toString();
    }

    public static String generatePeriodID(int year, int period) {
        String p = String.valueOf(period);
        if (p.length() < 4) {
            int max = 4 - p.length();
            for (int i = 0; i < max; ++i) {
                p = '0' + p;
            }
        }
        return year + p;
    }

    public static String toXmlString(String str) {
        String ret = str.replaceAll("&", "&amp;");
        ret = ret.replaceAll("\"", "&quot;");
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        return ret;
    }

    public static String toBookString(String str) {
        String ret = str.replaceAll("&quot;", "\"");
        ret = ret.replaceAll("&lt;", "<");
        ret = ret.replaceAll("&gt;", ">");
        ret = ret.replaceAll("&amp;", "&");
        return ret;
    }

    public static List getPeriodListFor13q(int startYear, int startPeriod, int endYear, int endPeriod, int periodType) {
        ArrayList<SimplePeriod> periodList = new ArrayList<SimplePeriod>();
        for (int k = startYear; k <= endYear; ++k) {
            int start = 0;
            int end = 0;
            start = k == startYear ? startPeriod : 1;
            end = k == endYear ? endPeriod : 13;
            for (int j = start; j <= end; ++j) {
                SimplePeriod simplePeriod = new SimplePeriod(k, j, periodType, null, false);
                periodList.add(simplePeriod);
            }
        }
        return periodList;
    }

    public static String reviseColName(String colName) {
        colName = colName.replaceAll("\\!", "11");
        colName = colName.replaceAll("\\.", "22");
        colName = colName.replaceAll("-", "_");
        colName = colName.replaceAll(" ", "_");
        return colName;
    }

    public static String getString(String resName) {
        return EASResource.getString((String)BI_RESOURCE_PATH, (String)resName);
    }

    public static String getStringWithFormat(String resName, Object[] param) {
        String s = EASResource.getString((String)BI_RESOURCE_PATH, (String)resName);
        return MessageFormat.format(s, param);
    }

    public static String buildPeriodSqlFor13q(int period_type, int sy, int sp, int ey, int ep, Context ctx) {
        List periodListFor13q = RptBiUtil.getPeriodListFor13q(sy, sp, ey, ep, period_type);
        StringBuffer sb = new StringBuffer();
        for (SimplePeriod simplePeriod : periodListFor13q) {
            if (sb.length() > 0) {
                sb.append("\n UNION ALL \n");
            }
            String id = simplePeriod.generateID();
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"3_RptBiUtil", (Locale)ctx.getOriginLocale());
            String number = MessageFormat.format(msg, "" + simplePeriod.year, simplePeriod.period);
            sb.append("select ").append(id).append(" As FID , '").append(number).append("' as FNumber ");
        }
        String periodSql = sb.toString();
        return periodSql;
    }

    public static String buildPeriodSqlFor13q(int period_type, int sy, int sp, int ey, int ep) {
        List periodListFor13q = RptBiUtil.getPeriodListFor13q(sy, sp, ey, ep, period_type);
        StringBuffer sb = new StringBuffer();
        for (SimplePeriod simplePeriod : periodListFor13q) {
            if (sb.length() > 0) {
                sb.append("\n UNION ALL \n");
            }
            String id = simplePeriod.generateID();
            String number = simplePeriod.year + EASResource.getString((String)RESOURCE_PATH, (String)"785_ExtractItemDataUI") + simplePeriod.period + EASResource.getString((String)RESOURCE_PATH, (String)"786_ExtractItemDataUI");
            sb.append("select ").append(id).append(" As FID , '").append(number).append("' as FNumber ");
        }
        String periodSql = sb.toString();
        return periodSql;
    }
}

