/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.IFastMergeSolu;
import com.kingdee.eas.fi.rpt.AbstractReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class CSLPropertyAdapter
extends AbstractReportPropertyAdapter {
    private static final Logger logger = Logger.getLogger(CSLPropertyAdapter.class);
    private static final long serialVersionUID = 3933978563818108716L;
    public static final String IS_ADJUST_REPORT = "isAdjustReport";
    private int isQueryBudget = 0;
    private boolean isFromGroupRptProceeUI = false;
    private boolean isMergeByFiscalPeriod = false;

    public CSLPropertyAdapter() {
    }

    public CSLPropertyAdapter(CslReportInfo report, Context ctx) {
        this.isMergeByFiscalPeriod = CSLParamUtil.getSysParamBoolValFromContext(ctx, "GR_CSL_MergeByFiscalPeriod", true);
        this.setProperties(report, ctx);
    }

    public CSLPropertyAdapter(HisCslReportInfo report, Context ctx) {
        this.setHisProperties(report, ctx);
    }

    public CSLPropertyAdapter(CslReportInfo report, Context ctx, boolean isMergeByFiscalPeriod) {
        this.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
        this.setProperties(report, ctx);
    }

    private void setProperties(CslReportInfo report, Context ctx) {
        Date periodfirstDate = null;
        Date periodLastDate = null;
        if (this.isMergeByFiscalPeriod) {
            try {
                PeriodCollection periods = null;
                if (CslRptUtil.isCslRpt(report.getSourceType().getValue())) {
                    periods = FiscalPeriodHelper.getPeriodCollection(ctx, report.getOrgTree());
                } else if (report.getCompany() != null) {
                    periods = FiscalPeriodHelper.getPeriodCollection(ctx, report.getCompany().getId().toString());
                }
                periodfirstDate = FiscalPeriodHelper.getPeriodFirstDate(report.getYear(), report.getPeriod(), report.getPeriodType(), periods, this.isMergeByFiscalPeriod);
                periodLastDate = FiscalPeriodHelper.getPeriodLastDate(periods, report.getYear(), report.getPeriod(), report.getPeriodType(), this.isMergeByFiscalPeriod);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        } else {
            periodfirstDate = RPTDateUtil.getPeriodFirstDate(report.getYear(), report.getPeriod(), report.getPeriodType());
            periodLastDate = RPTDate13Util.getPeriodLastDate(report.getYear(), report.getPeriod(), report.getPeriodType());
        }
        if (!this.isFromGroupRptProceeUI) {
            report.setStartDate(periodfirstDate);
            report.setEndDate(periodLastDate);
        }
        if (this.propertyContainer == null) {
            this.propertyContainer = new PropertyContainer();
        }
        if (report.getCompany() != null) {
            this.propertyContainer.setString("Company.Name", report.getCompany().getName());
            this.propertyContainer.setString("Company.Number", report.getCompany().getNumber());
            this.propertyContainer.setString("Company.ID", report.getCompany().getId().toString());
        }
        if (report.getPeriodType() != null) {
            this.propertyContainer.setInt("PeriodType", report.getPeriodType().getValue());
        }
        this.propertyContainer.setInt("Report.Year", report.getYear());
        this.propertyContainer.setInt("Report.Period", (int)report.getPeriod());
        if (report.getCurrency() != null) {
            this.propertyContainer.setString("Currency.Number", report.getCurrency().getNumber());
        }
        if (report.getLastUpdateUser() != null) {
            this.propertyContainer.setString("LastUpdater.Name", report.getLastUpdateUser().getName());
        }
        this.propertyContainer.setString("Report.Name", report.getName());
        if (report.getId() != null) {
            this.propertyContainer.setString("Report.ID", report.getId().toString());
        }
        this.propertyContainer.setString("Report.Number", report.getNumber());
        if (report.getSourceType() != null) {
            this.propertyContainer.setInt("Report.SourceType", report.getSourceType().getValue());
        }
        if (report.getCU() != null) {
            this.propertyContainer.setString("CU.Name", report.getCU().getId().toString());
        }
        if (report.getCreator() != null) {
            this.propertyContainer.setString("Creater.Name", report.getCreator().getName());
        }
        this.propertyContainer.setDate("Report_StartDate", report.getStartDate());
        this.propertyContainer.setDate("Report_EndDate", report.getEndDate());
        if (report.getSourceCurrency() != null) {
            this.propertyContainer.setString("SourceCurrency.Number", report.getSourceCurrency().getNumber());
        }
        if (report.getOrgUnit() != null) {
            this.propertyContainer.setString("OrgUnit.Number", report.getOrgUnit().getNumber());
            this.propertyContainer.setString("OrgUnit.Name", report.getOrgUnit().getName());
            this.propertyContainer.setString("OrgUnit.Id", report.getOrgUnit().getId() != null ? report.getOrgUnit().getId().toString() : null);
        }
        if (report.getOrgTree() != null) {
            this.propertyContainer.setString("CSLReport_OrgTree_Name", report.getOrgTree().getName());
            this.propertyContainer.setString("CSLReport_OrgTree_Number", report.getOrgTree().getNumber());
        }
        if (report.getAdjustStatus() != null) {
            this.propertyContainer.setString("CSLReport_AdjustedStatus", String.valueOf(report.getAdjustStatus().getValue()));
        }
        this.propertyContainer.setString("CSLReport_DataCollect_Number", report.getDataCollectNumber());
        this.propertyContainer.put("orgType", (Object)report.getOrgType());
        this.handleFastMergeId(report, ctx);
        this.handleReportSupportAdjustPeriodDataParam(report, ctx);
        super.setCommonProperty((ReportBaseInfo)report, ctx);
    }

    private void handleReportSupportAdjustPeriodDataParam(CslReportInfo report, Context ctx) {
        if (!(report.getId() == null || report.getSourceType() == null || report.getSourceType().getValue() != 1 && report.getSourceType().getValue() != 7 && report.getSourceType().getValue() != 10 && report.getSourceType().getValue() != 13 || this.propertyContainer.containsKey("SupportAdjustPeriodData"))) {
            try {
                String cslrptid = report.getId().toString();
                IReport iReport = null;
                iReport = ctx == null ? ReportFactory.getRemoteInstance() : ReportFactory.getLocalInstance((Context)ctx);
                if (iReport.exists("where cslReport = '" + cslrptid + "'")) {
                    ReportInfo info = iReport.getReportInfo("select isSupportAdjust where cslReport = '" + cslrptid + "'");
                    this.propertyContainer.setInt("SupportAdjustPeriodData", info.isIsSupportAdjust() ? 1 : 0);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private void handleFastMergeId(CslReportInfo report, Context ctx) {
        if (StringUtils.isEmpty((String)report.getFastMergeSoluId())) {
            return;
        }
        if (ElimReportUtils.isFastMergeReport(report)) {
            try {
                IFastMergeSolu iFastMerge = ctx == null ? FastMergeSoluFactory.getRemoteInstance() : FastMergeSoluFactory.getLocalInstance(ctx);
                FastMergeSoluInfo soluInfo = iFastMerge.getFastMergeSoluInfo("select number where id='" + report.getFastMergeSoluId() + "'");
                if (soluInfo != null) {
                    this.propertyContainer.setString("MergeSchmNum", soluInfo.getNumber());
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private void setHisProperties(HisCslReportInfo report, Context ctx) {
        this.isMergeByFiscalPeriod = CSLParamUtil.getSysParamBoolValFromContext(ctx, "GR_CSL_MergeByFiscalPeriod", true);
        Date periodfirstDate = null;
        Date periodLastDate = null;
        if (this.isMergeByFiscalPeriod) {
            try {
                PeriodCollection periods = FiscalPeriodHelper.getPeriodCollection(ctx, report);
                periodfirstDate = FiscalPeriodHelper.getPeriodFirstDate(report.getYear(), report.getPeriod(), report.getPeriodType(), periods, this.isMergeByFiscalPeriod);
                periodLastDate = FiscalPeriodHelper.getPeriodLastDate(periods, report.getYear(), report.getPeriod(), report.getPeriodType(), this.isMergeByFiscalPeriod);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        } else {
            periodfirstDate = RPTDateUtil.getPeriodFirstDate(report.getYear(), report.getPeriod(), report.getPeriodType());
            periodLastDate = RPTDateUtil.getPeriodLastDate(report.getYear(), report.getPeriod(), report.getPeriodType());
        }
        report.setStartDate(periodfirstDate);
        report.setEndDate(periodLastDate);
        if (this.propertyContainer == null) {
            this.propertyContainer = new PropertyContainer();
        }
        if (report.getCompany() != null) {
            this.propertyContainer.setString("Company.Name", report.getCompany().getName());
            this.propertyContainer.setString("Company.Number", report.getCompany().getNumber());
            this.propertyContainer.setString("Company.ID", report.getCompany().getId().toString());
        }
        if (report.getPeriodType() != null) {
            this.propertyContainer.setInt("PeriodType", report.getPeriodType().getValue());
        }
        this.propertyContainer.setInt("Report.Year", report.getYear());
        this.propertyContainer.setInt("Report.Period", (int)report.getPeriod());
        if (report.getCurrency() != null) {
            this.propertyContainer.setString("Currency.Number", report.getCurrency().getNumber());
        }
        if (report.getLastUpdateUser() != null) {
            this.propertyContainer.setString("LastUpdater.Name", report.getLastUpdateUser().getName());
        }
        this.propertyContainer.setString("Report.Name", report.getName());
        this.propertyContainer.setString("Report.ID", report.getId().toString());
        this.propertyContainer.setString("Report.Number", report.getNumber());
        if (report.getSourceType() != null) {
            this.propertyContainer.setInt("Report.SourceType", report.getSourceType().getValue());
        }
        if (report.getCU() != null) {
            this.propertyContainer.setString("CU.Name", report.getCU().getId().toString());
        }
        if (report.getCreator() != null) {
            this.propertyContainer.setString("Creater.Name", report.getCreator().getName());
        }
        this.propertyContainer.setDate("Report_StartDate", report.getStartDate());
        this.propertyContainer.setDate("Report_EndDate", report.getEndDate());
        if (report.getSourceCurrency() != null) {
            this.propertyContainer.setString("SourceCurrency.Number", report.getSourceCurrency().getNumber());
        }
        if (report.getOrgUnit() != null) {
            this.propertyContainer.setString("OrgUnit.Number", report.getOrgUnit().getNumber());
            this.propertyContainer.setString("OrgUnit.Name", report.getOrgUnit().getName());
        }
        if (report.getOrgTree() != null) {
            this.propertyContainer.setString("CSLReport_OrgTree_Name", report.getOrgTree().getName());
            this.propertyContainer.setString("CSLReport_OrgTree_Number", report.getOrgTree().getNumber());
        }
        if (report.getAdjustStatus() != null) {
            this.propertyContainer.setString("CSLReport_AdjustedStatus", String.valueOf(report.getAdjustStatus().getValue()));
        }
        this.propertyContainer.setString("CSLReport_DataCollect_Number", report.getDataCollectNumber());
    }

    public Object getReportProperty(String name) {
        return this.propertyContainer.get(name);
    }

    public void initReportProperties(IObjectValue vo, Context ctx) {
        if (vo instanceof HisCslReportInfo) {
            this.setHisProperties((HisCslReportInfo)vo, ctx);
        } else {
            this.setProperties((CslReportInfo)vo, ctx);
        }
    }

    public void setReportProperty(String name, int value) {
        if (this.propertyContainer == null) {
            this.propertyContainer = new PropertyContainer();
        }
        this.propertyContainer.setInt(name, value);
    }

    public void setExtraProperty(String name, Object value) {
        if (this.propertyContainer == null) {
            this.propertyContainer = new PropertyContainer();
        }
        this.propertyContainer.put(name, value);
    }

    public void setOrgGroupNumber(String orgGroupNumber) {
        this.propertyContainer.setString("CSLReport_OrgUnit_Group", orgGroupNumber);
    }

    public int getIsQueryBudget() {
        return this.isQueryBudget;
    }

    public void setIsQueryBudget(int isQueryBudget) {
        this.isQueryBudget = isQueryBudget;
    }

    public void setRptDate(Date startDate, Date endDate) {
        this.propertyContainer.setDate("Report_StartDate", startDate);
        this.propertyContainer.setDate("Report_EndDate", endDate);
        this.isFromGroupRptProceeUI = true;
    }
}

