/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.eas.fi.gr.cslrpt.Checkage;
import com.kingdee.eas.fi.gr.cslrpt.DiffHandleUtil;
import com.kingdee.eas.fi.gr.cslrpt.IDiffHandle;

public class DiffHandleStrategy {
    private int _diffMode = 0;
    private Checkage _checkage = null;
    private IDiffHandle _handler = null;

    public DiffHandleStrategy(int diffMode, Checkage checkage) {
        this._diffMode = diffMode;
        this._checkage = checkage;
    }

    public IDiffHandle getHandler() {
        if (this._diffMode == 6) {
            this._handler = new DiffHandleZero();
        } else if (this._diffMode == 1) {
            this._handler = new DiffHandleBig();
        } else if (this._diffMode == 2) {
            this._handler = new DiffHandleSmall();
        } else if (this._diffMode == 3) {
            this._handler = new DiffHandleDebit();
        } else if (this._diffMode == 4) {
            this._handler = new DiffHandleCredit();
        } else if (this._diffMode == 5) {
            this._handler = new DiffHandleAverage();
        } else if (this._diffMode == 10) {
            this._handler = new DiffHandleHand();
        }
        return this._handler;
    }

    public void execute() {
        if (this._checkage.getSingleDC() == 1 && this._diffMode != 6) {
            this._diffMode = 10;
        }
        this.getHandler().execute(this._checkage);
    }

    static class DiffHandleHand
    implements IDiffHandle {
        DiffHandleHand() {
        }

        @Override
        public void execute(Checkage checkage) {
            DiffHandleUtil.handleHand(checkage);
        }
    }

    static class DiffHandleAverage
    implements IDiffHandle {
        DiffHandleAverage() {
        }

        @Override
        public void execute(Checkage checkage) {
            DiffHandleUtil.handleAverage(checkage);
        }
    }

    static class DiffHandleCredit
    implements IDiffHandle {
        DiffHandleCredit() {
        }

        @Override
        public void execute(Checkage checkage) {
            DiffHandleUtil.handleBigSmall(checkage);
        }
    }

    static class DiffHandleDebit
    implements IDiffHandle {
        DiffHandleDebit() {
        }

        @Override
        public void execute(Checkage checkage) {
            DiffHandleUtil.handleBigSmall(checkage);
        }
    }

    static class DiffHandleSmall
    implements IDiffHandle {
        DiffHandleSmall() {
        }

        @Override
        public void execute(Checkage checkage) {
            DiffHandleUtil.handleBigSmall(checkage);
        }
    }

    static class DiffHandleBig
    implements IDiffHandle {
        DiffHandleBig() {
        }

        @Override
        public void execute(Checkage checkage) {
            DiffHandleUtil.handleBigSmall(checkage);
        }
    }

    static class DiffHandleZero
    implements IDiffHandle {
        DiffHandleZero() {
        }

        @Override
        public void execute(Checkage checkage) {
            DiffHandleUtil.handleZero(checkage);
        }
    }
}

