/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItemDataService;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.DynaRptItemDataFacadeFactory;
import com.kingdee.eas.fi.gr.dynamic.IDynaRptItemDataFacade;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Map;

public final class FormulaAdapter {
    public static final String PARAMS_CONTEXT = "CONTEXT";
    public static final String PARAMS_ORGBOUND = "ORGBOUND";
    public static final String PARAMS_ORGUNIT = "ORGUNIT";
    public static final String PARAMS_SOURCECURRENCY = "SOURCECURRENCY";
    public static final String PARAMS_CURRENCY = "CURRENCY";
    public static final String PARAMS_RPTPERIODTYPE = "RPTPERIODTYPE";
    public static final String PARAMS_YEAR = "YEAR";
    public static final String PARAMS_PERIOD = "PERIOD";
    public static final String PARAMS_DATASOURCE = "DATASOURCE";
    public static final String PARAMS_ITEMDATATYPE = "VALUETYPE";
    public static final String PARAMS_ISADJUSTED = "ISADJUSTED";
    public static final String STR_SEPRATOR = "|";
    public static final String OUT_ITEMDATA = "ITEMDATA";
    public static final String COMMITTEDSTATUS = "COMMITTEDSTATUS";
    private String itemPostil = null;
    private IRPTItemDataService dataService;
    private Map paramList;
    private IItemDataProvider iReportInstance = null;
    private IDynaRptItemDataFacade iDynaRptItemInstance = null;

    public FormulaAdapter(Map pList) throws BOSException {
        this.paramList = pList;
        if (this.paramList.get(PARAMS_CONTEXT) == null) {
            this.dataService = RPTItemDataServiceFactory.getRemoteInstance();
            this.iReportInstance = ItemDataProviderFactory.getRemoteInstance();
            this.iDynaRptItemInstance = DynaRptItemDataFacadeFactory.getRemoteInstance();
        } else {
            this.dataService = RPTItemDataServiceFactory.getLocalInstance((Context)this.paramList.get(PARAMS_CONTEXT));
            this.iReportInstance = ItemDataProviderFactory.getLocalInstance((Context)this.paramList.get(PARAMS_CONTEXT));
            this.iDynaRptItemInstance = DynaRptItemDataFacadeFactory.getLocalInstance((Context)((Context)this.paramList.get(PARAMS_CONTEXT)));
        }
    }

    public BigDecimal AdjustData(String orgBoundNumber, String orgUnitNumber, String sourceCurrencyNumber, String currencyNumber, String startItemNumber, String endItemNumber, String rptPeriodType, int yearOffset, int startPeriodOffset, int endPeriodOffset, String dataSource, String dataElement, String valueType, String dc, boolean isIncldUnAudit, String dataCollectNumber) throws BOSException, EASBizException {
        int endPeriod;
        int endYear;
        int startPeriod;
        int startYear;
        if (orgBoundNumber == null || orgBoundNumber.trim().equals("")) {
            orgBoundNumber = (String)this.paramList.get(PARAMS_ORGBOUND);
        }
        if (orgUnitNumber == null || orgUnitNumber.trim().equals("")) {
            orgUnitNumber = (String)this.paramList.get(PARAMS_ORGUNIT);
        }
        int int_periodType = rptPeriodType == null || rptPeriodType.trim().equals("") ? (Integer)this.paramList.get(PARAMS_RPTPERIODTYPE) : FormulaAdapter.getRptPeriodType(rptPeriodType);
        int rptYear = (Integer)this.paramList.get(PARAMS_YEAR);
        int rptPeriod = (Integer)this.paramList.get(PARAMS_PERIOD);
        String itemRange = startItemNumber + STR_SEPRATOR + endItemNumber;
        int int_dataSource = FormulaAdapter.getDataSource(dataSource);
        int int_dataElement = this.getDataElement(dataElement);
        int int_valueType = FormulaAdapter.getValueType(valueType);
        int int_dc = FormulaAdapter.getDebitOrCredit(dc);
        int[] start = RPTDateUtil.getRptYearAndPeriod(rptYear, rptPeriod, int_periodType, yearOffset, startPeriodOffset);
        int[] end = RPTDateUtil.getRptYearAndPeriod(rptYear, rptPeriod, int_periodType, yearOffset, endPeriodOffset);
        if (start == null) {
            startYear = rptYear;
            startPeriod = rptPeriod;
        } else {
            startYear = start[0];
            startPeriod = start[1];
        }
        if (end == null) {
            endYear = rptYear;
            endPeriod = rptPeriod;
        } else {
            endYear = end[0];
            endPeriod = end[1];
        }
        BigDecimal result = this.dataService.adjustData(orgBoundNumber, orgUnitNumber, itemRange, sourceCurrencyNumber, currencyNumber, int_periodType, int_dataSource, int_dataElement, startYear, endYear, startPeriod, endPeriod, isIncldUnAudit, int_dc, int_valueType, dataCollectNumber);
        return result;
    }

    public BigDecimal ElimData(String orgBoundNumber, String orgUnitNumber, String sourceCurrencyNumber, String currencyNumber, String startItemNumber, String endItemNumber, String rptPeriodType, int yearOffset, int startPeriodOffset, int endPeriodOffset, String dataElement, String valueType, String dc, boolean isIncldUnAudit) throws BOSException, EASBizException {
        int endPeriod;
        int endYear;
        int startPeriod;
        int startYear;
        int rptYear = (Integer)this.paramList.get(PARAMS_YEAR);
        int rptPeriod = (Integer)this.paramList.get(PARAMS_PERIOD);
        if (endPeriodOffset + rptPeriod == 0 && dataElement.equals("YTDAMOUNT")) {
            return new BigDecimal("0");
        }
        if (orgBoundNumber == null || orgBoundNumber.trim().equals("")) {
            orgBoundNumber = (String)this.paramList.get(PARAMS_ORGBOUND);
        }
        if (orgUnitNumber == null || orgUnitNumber.trim().equals("")) {
            orgUnitNumber = (String)this.paramList.get(PARAMS_ORGUNIT);
        }
        int int_periodType = rptPeriodType == null || rptPeriodType.trim().equals("") ? (Integer)this.paramList.get(PARAMS_RPTPERIODTYPE) : FormulaAdapter.getRptPeriodType(rptPeriodType);
        if (currencyNumber == null || currencyNumber.trim().equals("")) {
            currencyNumber = (String)this.paramList.get(PARAMS_SOURCECURRENCY);
        }
        String itemRange = startItemNumber + STR_SEPRATOR + endItemNumber;
        int int_dataElement = this.getDataElement(dataElement);
        int int_valueType = FormulaAdapter.getValueType(valueType);
        int int_dc = FormulaAdapter.getDebitOrCredit(dc);
        int[] start = RPTDateUtil.getRptYearAndPeriod(rptYear, rptPeriod, int_periodType, yearOffset, startPeriodOffset);
        int[] end = RPTDateUtil.getRptYearAndPeriod(rptYear, rptPeriod, int_periodType, yearOffset, endPeriodOffset);
        if (start == null) {
            startYear = rptYear;
            startPeriod = rptPeriod;
        } else {
            startYear = start[0];
            startPeriod = start[1];
        }
        if (end == null) {
            endYear = rptYear;
            endPeriod = rptPeriod;
        } else {
            endYear = end[0];
            endPeriod = end[1];
        }
        BigDecimal result = this.dataService.elimData(orgBoundNumber, orgUnitNumber, itemRange, sourceCurrencyNumber, currencyNumber, int_periodType, int_dataElement, startYear, endYear, startPeriod, endPeriod, isIncldUnAudit, int_dc, int_valueType);
        return result;
    }

    public BigDecimal acctAC(String fiOrgUnit, String destOrgUnit, String acctItem, String balanceType, int startYear, int startPeriod, int endYear, int endPeriod, String currency) throws BOSException, EASBizException {
        int periodType;
        int rptPeriod;
        int rptYear = (Integer)this.paramList.get(PARAMS_YEAR);
        int[] start = RPTDateUtil.getRptYearAndPeriod(rptYear, rptPeriod = ((Integer)this.paramList.get(PARAMS_PERIOD)).intValue(), periodType = ((Integer)this.paramList.get(PARAMS_RPTPERIODTYPE)).intValue(), startYear, startPeriod);
        if (start == null) {
            startYear = rptYear;
            startPeriod = rptPeriod;
        } else {
            startYear = start[0];
            startPeriod = start[1];
        }
        int[] end = RPTDateUtil.getRptYearAndPeriod(rptYear, rptPeriod, periodType, endYear, endPeriod);
        if (end == null) {
            endYear = rptYear;
            endPeriod = rptPeriod;
        } else {
            endYear = end[0];
            endPeriod = end[1];
        }
        return this.dataService.acctAC(fiOrgUnit, destOrgUnit, acctItem, balanceType, startYear, startPeriod, endYear, endPeriod, currency, false);
    }

    public String getItemPostil() {
        return this.itemPostil;
    }

    public static int getRptPeriodType(String name) {
        if (RptPeriodTypeEnum.getEnum((String)name) != null) {
            return RptPeriodTypeEnum.getEnum((String)name).getValue();
        }
        return -1;
    }

    public static int getDataSource(String name) {
        if (RptSrcTypeEnum.getEnum((String)name) != null) {
            return RptSrcTypeEnum.getEnum((String)name).getValue();
        }
        return -1;
    }

    public static int getTmpType(String name) {
        if (RptTmpTypeEnum.getEnum((String)name) != null) {
            return RptTmpTypeEnum.getEnum((String)name).getValue();
        }
        return -1;
    }

    public static int getValueType(String name) {
        if (ValueTypeEnum.getEnum(name) != null) {
            return ValueTypeEnum.getEnum(name).getValue();
        }
        return -1;
    }

    public static int getDebitOrCredit(String name) {
        if (DebitOrCreditEnum.getEnum(name) != null) {
            return DebitOrCreditEnum.getEnum(name).getValue();
        }
        return -1;
    }

    public static int getSourceType(String name) {
        if (RptSrcTypeEnum.getEnum((String)name) != null) {
            return RptSrcTypeEnum.getEnum((String)name).getValue();
        }
        return -1;
    }

    private int getDataElement(String dataElement) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)dataElement)) {
            return -1;
        }
        if (this.paramList.get(PARAMS_CONTEXT) == null) {
            return DataElementProvider.getDataElementInnerValue(dataElement);
        }
        return DataElementProvider.getDataElementInnerValue((Context)this.paramList.get(PARAMS_CONTEXT), dataElement);
    }
}

