/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.AbstractFormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineCollection;
import com.kingdee.eas.fi.gr.cslrpt.ValueFormulaExtendCollection;
import com.kingdee.eas.fi.gr.cslrpt.ValueFormulaExtendInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.GeneralUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringFormulaParser;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;

public class FormulaSchemeInfo
extends AbstractFormulaSchemeInfo
implements Serializable {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", FormulaSchemeInfo.class);
    private static final int MAX_VALUE_FORMULA_LENGTH = 3600;
    protected IFormula itemFormula;
    protected IFormula valueFormula;

    public FormulaSchemeInfo() {
    }

    protected FormulaSchemeInfo(String pkField) {
        super(pkField);
    }

    public FormulaSchemeInfo(OrgUnitInfo company, TemplateInfo template, String itemFormula, String valueFormula) {
        this();
        if (company != null) {
            this.setCompany(company.castToFullOrgUnitInfo());
        }
        if (template != null) {
            this.setTemplate(template);
        }
        this.setItemFormula(itemFormula);
        this.setValueFormula(valueFormula);
    }

    @Override
    public void setValueFormula(String valueFormulaStr) {
        super.setValueFormula(valueFormulaStr);
        StringFormulaParser formulaParser = ActionFactory.get(StringFormulaParser.class);
        this.valueFormula = formulaParser.parse(valueFormulaStr);
        boolean isExtend = this.putExtendValueFormula(valueFormulaStr);
        if (isExtend) {
            super.setValueFormula(null);
            this.put("LONG_VALUE_FORMULA", valueFormulaStr);
        }
    }

    public IFormula getValueFormulaInfo() {
        if (this.valueFormula == null) {
            StringFormulaParser formulaParser = ActionFactory.get(StringFormulaParser.class);
            String valueFormulaForStr = this.getValueFormula();
            this.valueFormula = formulaParser.parse(valueFormulaForStr);
            if (valueFormulaForStr == null || this.valueFormula == null) {
                // empty if block
            }
        }
        return this.valueFormula;
    }

    @Override
    public String getValueFormula() {
        String valueFormula = super.getValueFormula();
        if (StringUtil.isEmpty((String)valueFormula) && this.isIsExtendValueFormula()) {
            if (this.get("LONG_VALUE_FORMULA") instanceof String) {
                return (String)this.get("LONG_VALUE_FORMULA");
            }
            return this.assembleExtendValueFormula();
        }
        return valueFormula;
    }

    protected String assembleExtendValueFormula() {
        ValueFormulaExtendCollection formulaParts = this.getExtendValueFormula();
        String[] parts = new String[formulaParts.size()];
        int partIndex = 0;
        for (int i = 0; i < formulaParts.size(); ++i) {
            partIndex = formulaParts.get(i).getPartIndex();
            parts[partIndex] = formulaParts.get(i).getValueFormulaPart();
        }
        StringBuffer sb = new StringBuffer();
        for (String part : parts) {
            sb.append(part);
        }
        return sb.toString();
    }

    protected boolean putExtendValueFormula(String longValueFormula) {
        if (longValueFormula == null) {
            return false;
        }
        ValueFormulaExtendCollection formulaParts = this.getExtendValueFormula();
        if (longValueFormula.length() <= 3600) {
            return false;
        }
        formulaParts.clear();
        this.setIsExtendValueFormula(true);
        int start = 0;
        int end = start + 3600;
        int partIndex = 0;
        ValueFormulaExtendInfo part = null;
        while (start < longValueFormula.length()) {
            part = new ValueFormulaExtendInfo();
            part.setValueFormulaPart(longValueFormula.substring(start, end));
            part.setPartIndex(partIndex);
            part.setFormulaScheme(this);
            formulaParts.add(part);
            ++partIndex;
            start = end;
            if ((end = start + 3600) <= longValueFormula.length()) continue;
            end = longValueFormula.length();
        }
        return start != 0;
    }

    public void setItemFormula(String itemFormulaStr) {
        AutoItemItemFormula item = new AutoItemItemFormula(itemFormulaStr, null);
        this.setItemFormula(item);
    }

    public void setItemFormula(IFormula itemFormulaStr) {
        AutoItemItemFormula item = new AutoItemItemFormula(itemFormulaStr, null);
        this.setItemFormula(item);
    }

    protected void setItemFormula(AutoItemItemFormula item) {
        this.itemFormula = item.getFormulaInfo();
        this.setItemKey(item.getType());
        this.setItemNumber(item.getNumber());
        this.setItemDynaItem(item.getDynaItem());
        this.setItemOffYear(item.getYear());
        this.setItemOffPeriod(item.getPeriod());
        this.setItemDataType(item.getDataElementStr());
        this.setItemValueType(item.getValueType());
    }

    public String toString() {
        return MessageFormat.format("FormulaSchemeInfo|company:{0}|tpl:{1}|item:{2}|formula:{3}|dynDefine:{4}.", new Object[]{this.getCompany() != null ? this.getCompany().getNumber() : null, this.getTemplate() != null ? this.getTemplate().getNumber() : null, this.getItemFormula(), this.getValueFormulaInfo(), this.getDynFormulaDefine()});
    }

    public IFormula getItemFormula() {
        if (this.itemFormula == null) {
            AutoItemItemFormula item = new AutoItemItemFormula(this.getItemKey(), this.getItemNumber(), this.getItemDynaItem(), this.getItemOffYear(), this.getItemOffPeriod(), this.getItemDataType(), this.getItemValueType().getName(), null);
            this.itemFormula = item.getFormulaInfo();
        }
        return this.itemFormula;
    }

    public void setFormulaSheetID(String sheetId) {
        this.put("formulaSheetId", sheetId);
    }

    public String getFormulaSheetID() {
        return (String)this.get("formulaSheetId");
    }

    public static Collection<RptTmpTypeEnum> supportTemplateTypeForCalc() {
        return GeneralUtil.toSet(new RptTmpTypeEnum[]{RptTmpTypeEnum.GROUPCOMMREPORT, RptTmpTypeEnum.DYNAMICNORMALREPORT});
    }

    public static Collection<RptTmpTypeEnum> supportTemplateTypeForExtr() {
        return GeneralUtil.toSet(new RptTmpTypeEnum[]{RptTmpTypeEnum.GROUPCOMMREPORT, RptTmpTypeEnum.DYNAMICNORMALREPORT, RptTmpTypeEnum.GROUPREPORT, RptTmpTypeEnum.RPTDYNAMICREPORT});
    }

    public IFormula getCompleteValueFormulaInfo() {
        DynFormulaDefineCollection dynFormulaDefine;
        String valueFormula = super.getValueFormula();
        if (StringUtil.isEmpty((String)valueFormula) && this.isIsExtendValueFormula()) {
            valueFormula = this.get("LONG_VALUE_FORMULA") instanceof String ? (String)this.get("LONG_VALUE_FORMULA") : this.assembleExtendValueFormula();
        }
        if (!(dynFormulaDefine = this.getDynFormulaDefine()).isEmpty()) {
            boolean updateFormulaInfo = false;
            for (int i = 0; i < dynFormulaDefine.size(); ++i) {
                if (StringUtil.isEmpty((String)dynFormulaDefine.get(i).getSumFormula())) continue;
                valueFormula = valueFormula + "+" + dynFormulaDefine.get(i).getSumFormula();
                updateFormulaInfo = true;
            }
        }
        StringFormulaParser formulaParser = ActionFactory.get(StringFormulaParser.class);
        return formulaParser.parse(valueFormula);
    }
}

