/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.eas.common.client.ClientVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaEvent;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import com.kingdee.util.StringUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class ItemFormula
implements Externalizable,
Cloneable {
    public static final String EAS_VERSION;
    public static final String KEY_ITEM = "Item";
    public static final String KEY_DITEM = "DItem";
    private static final String FORMULA_KEY = "Formula_Key";
    private static final String FLAG_KEY_VALUE = "\u0018";
    private static final String FLAG_CELL = "\u0012";
    public static final String ITEMDATA_INFO_ITEMNUMBER = "0";
    public static final String ITEMDATA_INFO_OFFSET_YEAR = "1";
    public static final String ITEMDATA_INFO_OFFSET_PERIOD = "2";
    public static final String ITEMDATA_INFO_DATAELEMENT = "3";
    public static final String ITEMDATA_INFO_VALUETYPE = "4";
    public static final String ITEMDATA_INFO_DITEMNUMBER = "26";
    public static final String ITEMDATA_INFO_SHEETID = "5";
    public static final String ITEMDATA_INFO_SHEETNAME = "6";
    public static final String ITEMDATA_INFO_SHEETTYPE = "SHEETTYPE";
    public static final String ITEMDATA_INFO_CELLNAME = "7";
    public static final String ITEMDATA_INFO_POSX = "8";
    public static final String ITEMDATA_INFO_POSY = "9";
    public static final String ITEMDATA_INFO_YEAR = "10";
    public static final String ITEMDATA_INFO_PERIOD = "11";
    public static final String ITEMDATA_INFO_DAY = "12";
    public static final String ITEMDATA_INFO_FORMULA = "13";
    public static final String ITEMDATA_INFO_VALUE = "14";
    public static final String ITEMDATA_INFO_CELL = "15";
    public static final String ITEMDATA_INFO_CACOMPANY = "16";
    public static final String ITEMDATA_INFO_FORMULAVALIDITY = "17";
    public static final String ITEMDATA_INFO_REPORTCLASS = "18";
    public static final String ITEMDATA_INFO_ASSTACTTYPE = "27";
    public static final String ITEM_FORMULA_INVALID_KEY = "20";
    public static final String ITEM_FORMULA_NULL = "21";
    public static final String ITEM_FORMULA_INVALID = "22";
    public static final String ITEM_FORMULA_ITEM_NOT_EXIST = "23";
    public static final String ITEM_FORMULA_DUPLICATE = "24";
    public static final String ITEM_FORMULA_DUPLICATE_CELL = "2244";
    public static final String ITEM_FORMULA_OK = "25";
    public static final String ITEMDATA_INFO_FORMULASPLIT = ",";
    public static final String ITEMDATA_INFO_FORMULAHEAD = "=";
    public static final String DYNAMIC_GRADE_NUMBER = "GRADE_NUMBER";
    public static final String ITEMDATA_INFO_CACOMPANY_NUM = "26";
    private static final long serialVersionUID = 200407023163917L;
    transient ItemFormulaEvent invokeObject = null;
    transient RptCell cell = null;
    private Map props = new HashMap();
    private static final Logger logger;

    public ItemFormula() {
    }

    public ItemFormula(String formulaString) {
        this.FormulaToObject(formulaString);
    }

    public String getItemNumber() {
        String itemNumber = null;
        if (this.props.containsKey(ITEMDATA_INFO_ITEMNUMBER)) {
            itemNumber = this.props.get(ITEMDATA_INFO_ITEMNUMBER).toString();
        }
        return itemNumber;
    }

    public void setItemNumber(String itemNumber) {
        this.props.put(ITEMDATA_INFO_ITEMNUMBER, itemNumber);
    }

    public String getDItemNumber() {
        String ditemNumber = null;
        if (this.props.get("26") != null) {
            ditemNumber = this.props.get("26").toString();
        }
        return ditemNumber;
    }

    public void setDItemNumber(String ditemNumber) {
        this.props.put("26", ditemNumber);
    }

    public int getYearOffSet() {
        if (this.props.containsKey(ITEMDATA_INFO_OFFSET_YEAR)) {
            return Integer.parseInt(this.props.get(ITEMDATA_INFO_OFFSET_YEAR).toString());
        }
        return -1;
    }

    public int getPeriodOffSet() {
        if (this.props.containsKey(ITEMDATA_INFO_OFFSET_PERIOD)) {
            return Integer.parseInt(this.props.get(ITEMDATA_INFO_OFFSET_PERIOD).toString());
        }
        return -1;
    }

    public String getDataElementNumber() {
        String v = "";
        if (this.props.containsKey(ITEMDATA_INFO_DATAELEMENT)) {
            v = this.props.get(ITEMDATA_INFO_DATAELEMENT).toString();
        }
        return v;
    }

    public int getValueType() {
        int v = -1;
        if (this.props.containsKey(ITEMDATA_INFO_VALUETYPE)) {
            v = Integer.parseInt(this.props.get(ITEMDATA_INFO_VALUETYPE).toString());
        }
        return v;
    }

    public ItemFormula FormulaToObject(String formulaString) {
        Expression exp;
        boolean isDitem = false;
        if (!StringUtils.isEmpty((String)formulaString) && formulaString.startsWith("=DItem")) {
            isDitem = true;
            this.props.put(FORMULA_KEY, KEY_DITEM);
        } else {
            this.props.put(FORMULA_KEY, KEY_ITEM);
        }
        this.props.put(ITEMDATA_INFO_FORMULA, formulaString);
        boolean isFormulaValidity = formulaString != null && formulaString.trim().length() != 0;
        this.props.put(ITEMDATA_INFO_FORMULAVALIDITY, Boolean.toString(isFormulaValidity));
        if (!isFormulaValidity || formulaString.indexOf("(") == -1 || formulaString.indexOf(")") == -1) {
            return null;
        }
        try {
            exp = ExcelFormulaPaserHelper.parse((String)formulaString.substring(1));
        }
        catch (Exception e) {
            return null;
        }
        String[] valueString = null;
        if (exp instanceof FunctionExpr) {
            FunctionExpr foo = (FunctionExpr)exp;
            List params = foo.parameters;
            valueString = new String[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                valueString[i] = params.get(i).toString();
            }
        } else {
            return null;
        }
        if (isDitem) {
            if (valueString.length != 6) {
                return null;
            }
            this.props.put(ITEMDATA_INFO_ITEMNUMBER, this.analyseFormulaParam(ITEMDATA_INFO_ITEMNUMBER, valueString[0]));
            this.props.put("26", this.analyseFormulaParam("26", valueString[1]));
            this.props.put(ITEMDATA_INFO_OFFSET_YEAR, this.analyseFormulaParam(ITEMDATA_INFO_OFFSET_YEAR, valueString[2]));
            this.props.put(ITEMDATA_INFO_OFFSET_PERIOD, this.analyseFormulaParam(ITEMDATA_INFO_OFFSET_PERIOD, valueString[3]));
            this.props.put(ITEMDATA_INFO_DATAELEMENT, this.analyseFormulaParam(ITEMDATA_INFO_DATAELEMENT, valueString[4]));
            this.props.put(ITEMDATA_INFO_VALUETYPE, this.analyseFormulaParam(ITEMDATA_INFO_VALUETYPE, valueString[5]));
        } else {
            if (valueString.length != 5) {
                return null;
            }
            this.props.put(ITEMDATA_INFO_ITEMNUMBER, this.analyseFormulaParam(ITEMDATA_INFO_ITEMNUMBER, valueString[0]));
            this.props.put(ITEMDATA_INFO_OFFSET_YEAR, this.analyseFormulaParam(ITEMDATA_INFO_OFFSET_YEAR, valueString[1]));
            this.props.put(ITEMDATA_INFO_OFFSET_PERIOD, this.analyseFormulaParam(ITEMDATA_INFO_OFFSET_PERIOD, valueString[2]));
            this.props.put(ITEMDATA_INFO_DATAELEMENT, this.analyseFormulaParam(ITEMDATA_INFO_DATAELEMENT, valueString[3]));
            this.props.put(ITEMDATA_INFO_VALUETYPE, this.analyseFormulaParam(ITEMDATA_INFO_VALUETYPE, valueString[4]));
        }
        return this;
    }

    public void clearFormula() {
        String key = null;
        for (int i = Integer.parseInt(ITEMDATA_INFO_ITEMNUMBER); i <= Integer.parseInt(ITEMDATA_INFO_VALUETYPE); ++i) {
            key = Integer.toString(i);
            if (!this.props.containsKey(key)) continue;
            this.props.remove(key);
        }
        if (this.props.containsKey("26")) {
            this.props.remove("26");
        }
        if (this.props.containsKey(ITEMDATA_INFO_FORMULA)) {
            this.props.remove(ITEMDATA_INFO_FORMULA);
            this.props.put("ITEMDATA_INFO_FORMULAVALIDITY", Boolean.toString(false));
        }
    }

    public boolean isValidity() {
        if (this.props.containsKey(ITEMDATA_INFO_FORMULAVALIDITY)) {
            return Boolean.valueOf(this.props.get(ITEMDATA_INFO_FORMULAVALIDITY).toString());
        }
        return false;
    }

    public boolean isDItem() {
        String type = (String)this.props.get(FORMULA_KEY);
        return StringUtils.equals((String)type, (String)KEY_DITEM);
    }

    public Object clone() {
        try {
            ItemFormula o = (ItemFormula)super.clone();
            o.props = (HashMap)((HashMap)this.props).clone();
            return o;
        }
        catch (Exception e) {
            logger.debug((Object)("clone err:" + e.getLocalizedMessage()));
            return null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        StringBuffer buf = new StringBuffer();
        if (this.props != null && !this.props.isEmpty()) {
            Set s = this.props.keySet();
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                String temp = iter.next().toString();
                buf.append(FLAG_CELL + temp + FLAG_KEY_VALUE + this.props.get(temp));
            }
            out.writeObject(buf.toString());
        } else {
            out.writeObject(null);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object o = null;
        o = in.readObject();
        if (o == null) {
            this.props = new HashMap(1);
        } else if (o instanceof String) {
            String[] temp = o.toString().split(FLAG_CELL);
            if (temp != null) {
                for (int i = 1; i < temp.length; ++i) {
                    int index = temp[i].indexOf(FLAG_KEY_VALUE);
                    String key = temp[i].substring(0, index);
                    String value = temp[i].substring(index + 1, temp[i].length());
                    try {
                        if (EAS_VERSION.length() > 4 && EAS_VERSION.startsWith("5.1.") && key.equals(ITEMDATA_INFO_DATAELEMENT) && value.matches("[1-5]")) {
                            if (value.equals(ITEMDATA_INFO_OFFSET_YEAR)) {
                                value = "BEGINBALANCE";
                            } else if (value.equals(ITEMDATA_INFO_OFFSET_PERIOD)) {
                                value = "AMOUNT";
                            } else if (value.equals(ITEMDATA_INFO_DATAELEMENT)) {
                                value = "YTDAMOUNT";
                            } else if (value.equals(ITEMDATA_INFO_VALUETYPE)) {
                                value = "ENDBALANCE";
                            } else if (value.equals(ITEMDATA_INFO_SHEETID)) {
                                value = "YTBEGIN";
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.props.put(key, value);
                }
            }
        } else if (o instanceof HashMap) {
            int index;
            String f;
            HashMap m = (HashMap)o;
            Set s = m.keySet();
            Iterator iter = s.iterator();
            Object obj = null;
            while (iter.hasNext()) {
                obj = iter.next();
                this.props.put(obj.toString(), m.get(obj).toString());
            }
            if (this.props.containsKey(ITEMDATA_INFO_FORMULA) && (f = this.props.get(ITEMDATA_INFO_FORMULA).toString()) != null && f.length() != 0 && (index = f.indexOf(ITEMDATA_INFO_FORMULAHEAD)) == -1) {
                this.props.put(ITEMDATA_INFO_FORMULA, ITEMDATA_INFO_FORMULAHEAD + f);
            }
        } else {
            throw new ClassNotFoundException();
        }
    }

    public String toString() {
        return this.getFormula();
    }

    public String getFormulaKey() {
        if (this.props.containsKey(FORMULA_KEY)) {
            return this.props.get(FORMULA_KEY).toString();
        }
        return null;
    }

    public void setFormulaKey(String v) {
        if (this.props.containsKey(FORMULA_KEY)) {
            this.props.remove(FORMULA_KEY);
        }
        this.props.put(FORMULA_KEY, v);
    }

    public String getFormula() {
        if (this.props.containsKey(ITEMDATA_INFO_FORMULA)) {
            return this.props.get(ITEMDATA_INFO_FORMULA).toString();
        }
        return null;
    }

    public void setInvokeObject(ItemFormulaEvent event) {
        this.invokeObject = event;
    }

    public LinkedList getContext() {
        return this.invokeObject == null ? null : this.invokeObject.getContext();
    }

    public Object getContextItem(String key) {
        return this.invokeObject == null ? null : this.invokeObject.getContextItem(key);
    }

    public RptCell getCell() {
        return this.cell;
    }

    public void setCell(RptCell v) {
        this.cell = v;
    }

    public int getYear() {
        if (this.props.containsKey(ITEMDATA_INFO_YEAR)) {
            return new Integer(this.props.get(ITEMDATA_INFO_YEAR).toString());
        }
        return -1;
    }

    public int getPeriod() {
        if (this.props.containsKey(ITEMDATA_INFO_PERIOD)) {
            return new Integer(this.props.get(ITEMDATA_INFO_PERIOD).toString());
        }
        return -1;
    }

    public Date getDay() {
        if (this.props.containsKey(ITEMDATA_INFO_DAY)) {
            return Date.valueOf(this.props.get(ITEMDATA_INFO_DAY).toString());
        }
        return null;
    }

    public String getReportClass() {
        if (this.props.containsKey(ITEMDATA_INFO_REPORTCLASS)) {
            return this.props.get(ITEMDATA_INFO_REPORTCLASS).toString();
        }
        return null;
    }

    public void setReportClass(String v) {
        if (this.props.containsKey(ITEMDATA_INFO_REPORTCLASS)) {
            this.props.remove(ITEMDATA_INFO_REPORTCLASS);
        }
        this.props.put(ITEMDATA_INFO_REPORTCLASS, v);
    }

    public BigDecimal getValue() {
        if (this.props.containsKey(ITEMDATA_INFO_VALUE)) {
            return new BigDecimal(this.props.get(ITEMDATA_INFO_VALUE).toString());
        }
        return null;
    }

    public void setValue(BigDecimal v) {
        if (this.props.containsKey(ITEMDATA_INFO_VALUE)) {
            this.props.remove(ITEMDATA_INFO_VALUE);
        }
        this.props.put(ITEMDATA_INFO_VALUE, v.toString());
    }

    public String getExt(String key) {
        Object o = this.props.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public void putExt(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        this.props.put(key, value);
    }

    public void removeExt(String key) {
        if (this.props.containsKey(key)) {
            this.props.remove(key);
        }
    }

    private String analyseFormulaParam(String key, String o) {
        String valueString = o.toString();
        String enumName = null;
        String value = null;
        if (valueString.indexOf("\"") != -1 && valueString.lastIndexOf("\"") != -1 && valueString.indexOf("\"") < valueString.lastIndexOf("\"")) {
            enumName = valueString.substring(valueString.indexOf("\"") + 1, valueString.lastIndexOf("\""));
            if (key.equals(ITEMDATA_INFO_ITEMNUMBER)) {
                value = enumName;
            } else if (key.equals("26")) {
                value = enumName;
            } else if (key.equals(ITEMDATA_INFO_DATAELEMENT)) {
                value = enumName;
            } else if (key.equals(ITEMDATA_INFO_VALUETYPE) && ValueTypeEnum.getEnum(enumName) != null) {
                value = String.valueOf(ValueTypeEnum.getEnum(enumName).getValue());
            }
        } else if (key.equals(ITEMDATA_INFO_OFFSET_YEAR)) {
            value = o.toString();
        }
        if (key.equals(ITEMDATA_INFO_OFFSET_PERIOD)) {
            value = o.toString();
        }
        return value;
    }

    public boolean isBasePoint() {
        String flag1 = this.getExt("CSL_TEMPLATE_BASEPOSITION");
        String flag2 = this.getExt("DynaParameters");
        return flag1 != null || flag2 != null;
    }

    public void fromSerialString(String s) throws Exception {
        IObjectIterator it = UserObjectTrans.createObjectIterator((String)s);
        if (it.hasNext()) {
            this.props = (HashMap)it.nextObject();
        }
        if (this.props == null) {
            this.props = new HashMap();
        }
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        UserObjectTrans.toString((HashMap)((HashMap)this.props), (StringBuffer)sb);
        return sb.toString();
    }

    public Map getExt() {
        HashMap map = new HashMap();
        for (Object key : this.props.keySet()) {
            map.put(key, this.props.get(key));
        }
        return map;
    }

    static {
        String version = null;
        try {
            version = ClientVersionUtil.getCommonLibVersion();
        }
        catch (Exception e) {
            version = "";
        }
        EAS_VERSION = version;
        logger = Logger.getLogger(ItemFormula.class);
    }
}

