/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RPTDateUtil
implements Serializable {
    public static final int DATEUTIL_FORMAT_YEAR = 0;
    public static final int DATEUTIL_FORMAT_PERIOD = 1;
    public static final int DATEUTIL_FORMAT_DAY = 2;
    private static int[] monthLength = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static int[] leapYearMonthLength = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String DATE_STYLE_SHORT_YMD = "yyyyMMdd";
    public static final String DATE_STYLE_SHORT_YMDHM = "yyyyMMddHHmm";
    public static final String DATE_STYLE_YMD = "yyyy-MM-dd";
    public static final String DATE_STYLE_YMDHM = "yyyy-MM-dd HH:mm";
    public static final Date NON_PERIOD_BE_FOUND = new Date();

    public static String getSimpleDateFormat(Date rptDate) {
        if (rptDate == null) {
            return null;
        }
        SimpleDateFormat dateFm = null;
        String curDate = null;
        try {
            dateFm = new SimpleDateFormat(DATE_STYLE_YMD);
            curDate = dateFm.format(rptDate);
        }
        catch (Exception exc) {
            curDate = null;
        }
        return curDate;
    }

    public static int getDayCountBefore(int year, int month, int date) {
        int sum = 0;
        sum += date;
        for (int i = month; i > 1; --i) {
            sum += RPTDateUtil.prevMonthLength(i, year);
        }
        return sum;
    }

    public static Date getNextDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(6, cal.get(6) + 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int getPeriod(int year, int month, int date, RptPeriodTypeEnum periodType) {
        int result = 0;
        if (periodType.equals((Object)RptPeriodTypeEnum.DAILY)) {
            result = RPTDateUtil.getDayCountBefore(year, month, date);
        } else if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
            result = month;
        } else if (periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
            result = RPTDateUtil.getQuarterByMonth(month);
        } else if (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
            result = RPTDateUtil.getSemiYearByMonth(month);
        } else if (periodType.equals((Object)RptPeriodTypeEnum.WEEKLY)) {
            result = RPTDateUtil.getWeekByDate(year, month, date);
        } else if (periodType.equals((Object)RptPeriodTypeEnum.YEARLY)) {
            result = 1;
        }
        return result;
    }

    public static final int getPeriodYear(int year, int period) {
        return year * 10000 + period * 100;
    }

    public static final int getQuarterByMonth(int month) {
        return month / 3 + (month % 3 == 0 ? 0 : 1);
    }

    public static final int getSemiYearByMonth(int month) {
        return month / 6 + (month % 6 == 0 ? 0 : 1);
    }

    public static final int monthLength(int month, int year) {
        return RPTDateUtil.isLeapYear(year) ? leapYearMonthLength[month - 1] : monthLength[month - 1];
    }

    public static final int prevMonthLength(int month, int year) {
        return RPTDateUtil.monthLength(--month, year);
    }

    public static Date getPeriodFirstDate(int year, int period, RptPeriodTypeEnum periodType) {
        int month = 0;
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        switch (periodType.getValue()) {
            case 1: {
                calendar.set(1, year);
                calendar.set(6, period);
                return calendar.getTime();
            }
            case 3: {
                if (period == 13) {
                    return RPTDateUtil.getPeriodLastDate(year, period, periodType);
                }
                calendar.set(year, period - 1, 1);
                return calendar.getTime();
            }
            case 4: {
                month = period * 3 - 3;
                calendar.set(year, month, 1);
                return calendar.getTime();
            }
            case 5: {
                month = period * 6 - 6;
                calendar.set(year, month, 1);
                return calendar.getTime();
            }
            case 2: {
                calendar.set(1, year);
                calendar.set(3, period);
                calendar.set(7, 1);
                return calendar.getTime();
            }
            case 6: {
                calendar.set(year, 0, 1);
                return calendar.getTime();
            }
        }
        return null;
    }

    public static int getDays(Date beginDate, RptPeriodTypeEnum rptPeriodType) {
        int period = rptPeriodType.getValue();
        int days = 0;
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.clear();
        switch (period) {
            case 2: {
                days = 7;
                break;
            }
            case 3: {
                cal.setTime(beginDate);
                days = cal.getActualMaximum(5);
                break;
            }
            case 4: {
                days = RPTDateUtil.getPeriodDays(beginDate, 3);
                break;
            }
            case 5: {
                days = RPTDateUtil.getPeriodDays(beginDate, 6);
                break;
            }
            case 6: {
                cal.setTime(beginDate);
                int year = cal.get(1);
                if (RPTDateUtil.isLeapYear(year)) {
                    days = 366;
                    break;
                }
                days = 365;
                break;
            }
        }
        return days;
    }

    private static int getPeriodDays(Date beginDate, int count) {
        int days = 0;
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.clear();
        cal.setTime(beginDate);
        for (int i = 0; i < count; ++i) {
            days += cal.getActualMaximum(5);
            cal.add(2, 1);
        }
        return days;
    }

    public static Date getFirstDayByendDate(Date date) {
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(6, 1);
        return cal.getTime();
    }

    public static long getQuotOfDates(Date startDate, Date endDate) {
        long Quot = 0L;
        Quot = endDate.getTime() - startDate.getTime();
        Quot = Quot / 86400000L + 1L;
        return Quot;
    }

    public static Date getPeriodLastDate(int year, int period, RptPeriodTypeEnum periodType) {
        int month = 0;
        int date = 0;
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.clear();
        boolean isLeapYear = RPTDateUtil.isLeapYear(year);
        switch (periodType.getValue()) {
            case 1: {
                calendar.set(1, year);
                calendar.set(6, period);
                return calendar.getTime();
            }
            case 3: {
                if (period > 13) {
                    return null;
                }
                if (period == 13) {
                    period = 12;
                }
                date = isLeapYear ? leapYearMonthLength[period - 1] : monthLength[period - 1];
                calendar.set(year, period - 1, date);
                return calendar.getTime();
            }
            case 4: {
                month = period * 3 - 1;
                if (month > 12) {
                    return null;
                }
                date = isLeapYear ? leapYearMonthLength[month] : monthLength[month];
                calendar.set(year, month, date);
                return calendar.getTime();
            }
            case 5: {
                month = period * 6 - 1;
                if (month > 12) {
                    return null;
                }
                date = isLeapYear ? leapYearMonthLength[month] : monthLength[month];
                calendar.set(year, month, date);
                return calendar.getTime();
            }
            case 2: {
                calendar.set(1, year);
                calendar.set(3, period);
                calendar.set(7, 7);
                return calendar.getTime();
            }
            case 6: {
                calendar.set(year, 11, 31);
                return calendar.getTime();
            }
        }
        return null;
    }

    public static int[] getPeriod(Date date, RptPeriodTypeEnum periodType) {
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int period = RPTDateUtil.getPeriod(year, ++month, day, periodType);
        if (!periodType.equals((Object)RptPeriodTypeEnum.WEEKLY) || month != 12 || period == 1) {
            // empty if block
        }
        return new int[]{++year, period};
    }

    public static List getRptPeriod(Date date, RptPeriodTypeEnum periodType) {
        int[] ls = RPTDateUtil.getPeriod(date, periodType);
        return RPTDateUtil.getRptYearAndPeriodAndDate(ls[0], ls[1], periodType);
    }

    public static List getRptYearAndPeriodAndDate(int rptYear, int rptPeriod, RptPeriodTypeEnum periodType) {
        return RPTDateUtil.getRptYearAndPeriodAndDate(rptYear, rptPeriod, periodType.getValue(), 0, 0);
    }

    public static void getRptYearAndPeriod(ItemFormula srcFormula, int RptYear, int RptPeriod, RptPeriodTypeEnum RptPeriodType) {
        if (srcFormula == null) {
            return;
        }
        List ls = RPTDateUtil.getRptYearAndPeriodAndDate(RptYear, RptPeriod, RptPeriodType.getValue(), srcFormula.getYearOffSet(), srcFormula.getPeriodOffSet());
        Date t = (Date)ls.get(2);
        SimpleDateFormat format = new SimpleDateFormat(DATE_STYLE_YMD);
        srcFormula.putExt("10", ls.get(0).toString());
        srcFormula.putExt("11", ls.get(1).toString());
        srcFormula.putExt("12", format.format(t).toString());
    }

    public static int[] getRptYearAndPeriod(int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod) {
        return RPTDateUtil.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod, false);
    }

    public static int[] getRptYearAndPeriod(int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod, boolean isPeriodPositiveOffSet) {
        if (offsetYear > 1000 && offsetPeriod > 0) {
            int[] result = new int[]{offsetYear, offsetPeriod};
            return result;
        }
        if (offsetYear > 1000) {
            offsetYear -= RptYear;
        }
        if (!isPeriodPositiveOffSet && offsetPeriod > 0) {
            offsetPeriod -= RptPeriod;
        }
        Calendar rptCalendar = RPTDateUtil.getCalendarTimeIsZero();
        int resultYear = 0;
        int resultPeriod = 0;
        rptCalendar.set(1, RptYear);
        switch (RptPeriodType) {
            case 1: {
                rptCalendar.set(6, RptPeriod);
                rptCalendar.add(1, offsetYear);
                rptCalendar.add(5, offsetPeriod);
                resultYear = rptCalendar.get(1);
                resultPeriod = rptCalendar.get(6);
                break;
            }
            case 2: {
                rptCalendar.set(3, RptPeriod);
                rptCalendar.set(7, 7);
                rptCalendar.add(1, offsetYear);
                rptCalendar.add(3, offsetPeriod);
                resultYear = rptCalendar.get(1);
                resultPeriod = rptCalendar.get(3);
                break;
            }
            case 3: {
                rptCalendar.add(1, offsetYear);
                rptCalendar.set(2, 0);
                rptCalendar.add(2, RptPeriod + offsetPeriod - 1);
                resultYear = rptCalendar.get(1);
                resultPeriod = rptCalendar.get(2) + 1;
                break;
            }
            case 4: {
                resultYear = RptYear + offsetYear;
                resultPeriod = RptPeriod + offsetPeriod;
                resultYear += resultPeriod / 4;
                if ((resultPeriod %= 4) == 0) {
                    resultPeriod = 4;
                    break;
                }
                if (resultPeriod >= 0) break;
                resultPeriod += 4;
                --resultYear;
                break;
            }
            case 5: {
                resultYear = RptYear + offsetYear;
                resultPeriod = RptPeriod + offsetPeriod;
                resultYear += resultPeriod / 2;
                if ((resultPeriod %= 2) == 0) {
                    --resultYear;
                    resultPeriod = 2;
                    break;
                }
                if (resultPeriod >= 0) break;
                resultPeriod += 2;
                --resultYear;
                break;
            }
            case 6: {
                resultYear = RptYear + offsetYear;
                resultPeriod = 1;
                break;
            }
        }
        int[] result = new int[]{--resultYear, resultPeriod};
        return result;
    }

    public static int[] getYearAndPeriod(boolean isStartYear, Context serverCtx, int startYear, int startPeriod, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter, String Company_ID, PeriodCollection fiscalPeriods, boolean isMergeByFiscalPeriod) throws EASBizException, BOSException {
        Integer b;
        Integer Period_Type = (Integer)adapter.getReportProperty("PeriodType");
        if (startYear <= 0) {
            if (reportVariables != null) {
                startYear = isStartYear ? reportVariables.getIntValue("StartYear", sheetName, 0) + startYear : reportVariables.getIntValue("EndYear", sheetName, 0) + startYear;
            }
            if (startYear <= 0) {
                startYear = (Integer)adapter.getReportProperty("Report.Year") + startYear;
            }
        }
        if (startPeriod <= 0) {
            if (reportVariables != null) {
                startPeriod = isStartYear ? reportVariables.getIntValue("StartPeriod", sheetName, 0) + startPeriod : reportVariables.getIntValue("EndPeriod", sheetName, 0) + startPeriod;
            }
            if (startPeriod <= 0) {
                startPeriod = (Integer)adapter.getReportProperty("Report.Period") + startPeriod;
            }
            if (startPeriod <= 0) {
                int maxPeriod = 0;
                maxPeriod = fiscalPeriods != null && fiscalPeriods.size() > 0 ? FiscalPeriodHelper.getMaxPeriodNumber(fiscalPeriods, startYear) : PeriodUtils.getMaxPeriodNumber((Context)serverCtx, (int)(--startYear), (String)Company_ID);
                startPeriod += maxPeriod;
            } else if (Period_Type != null && Period_Type != 3) {
                int[] yearAndPeriod = null;
                yearAndPeriod = isStartYear ? FiscalPeriodHelper.getYearAndFirstPeriodNumber(fiscalPeriods, startYear, startPeriod, RptPeriodTypeEnum.getEnum((int)Period_Type), isMergeByFiscalPeriod) : FiscalPeriodHelper.getYearAndLastPeriodNumber(fiscalPeriods, startYear, startPeriod, RptPeriodTypeEnum.getEnum((int)Period_Type), isMergeByFiscalPeriod);
                startYear = yearAndPeriod[0];
                startPeriod = yearAndPeriod[1];
            }
        }
        if ((b = (Integer)adapter.getReportProperty("SupportAdjustPeriodData")) != null && b == 1 && !isStartYear && startPeriod == 12) {
            int maxPeriod = 0;
            maxPeriod = fiscalPeriods != null && fiscalPeriods.size() > 0 ? FiscalPeriodHelper.getMaxPeriodNumber(fiscalPeriods, startYear) : PeriodUtils.getMaxPeriodNumber((Context)serverCtx, (int)startYear, (String)Company_ID);
            startPeriod = maxPeriod;
        }
        return new int[]{startYear, startPeriod};
    }

    public static int[] getYearAndPeriod(boolean isStartYear, Map maxPeriodMap, int startYear, int startPeriod, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter, String periodTypeID, PeriodCollection fiscalPeriods, boolean isMergeByFiscalPeriod) {
        Integer b;
        Integer Period_Type = (Integer)adapter.getReportProperty("PeriodType");
        if (startYear <= 0) {
            if (reportVariables != null) {
                startYear = isStartYear ? reportVariables.getIntValue("StartYear", sheetName, 0) + startYear : reportVariables.getIntValue("EndYear", sheetName, 0) + startYear;
            }
            if (startYear <= 0) {
                startYear = (Integer)adapter.getReportProperty("Report.Year") + startYear;
            }
        }
        if (startPeriod <= 0) {
            if (reportVariables != null) {
                startPeriod = isStartYear ? reportVariables.getIntValue("StartPeriod", sheetName, 0) + startPeriod : reportVariables.getIntValue("EndPeriod", sheetName, 0) + startPeriod;
            }
            if (startPeriod <= 0) {
                startPeriod = (Integer)adapter.getReportProperty("Report.Period") + startPeriod;
            }
            if (startPeriod <= 0) {
                Integer periodInt;
                if ((periodInt = (Integer)maxPeriodMap.get(--startYear + periodTypeID)) == null) {
                    return null;
                }
                int maxPeriodOfYear = periodInt;
                startPeriod += maxPeriodOfYear;
            } else if (Period_Type != null && Period_Type != 3) {
                int[] yearAndPeriod = null;
                yearAndPeriod = isStartYear ? FiscalPeriodHelper.getYearAndFirstPeriodNumber(fiscalPeriods, startYear, startPeriod, RptPeriodTypeEnum.getEnum((int)Period_Type), isMergeByFiscalPeriod) : FiscalPeriodHelper.getYearAndLastPeriodNumber(fiscalPeriods, startYear, startPeriod, RptPeriodTypeEnum.getEnum((int)Period_Type), isMergeByFiscalPeriod);
                startYear = yearAndPeriod[0];
                startPeriod = yearAndPeriod[1];
            }
        }
        if ((b = (Integer)adapter.getReportProperty("SupportAdjustPeriodData")) != null && b == 1 && !isStartYear && startPeriod == 12) {
            int maxPeriodOfYear;
            Integer periodInt = (Integer)maxPeriodMap.get(startYear + periodTypeID);
            if (periodInt == null) {
                return null;
            }
            startPeriod = maxPeriodOfYear = periodInt.intValue();
        }
        return new int[]{startYear, startPeriod};
    }

    public static List getRptYearAndPeriodAndDate(int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod) {
        ArrayList<Comparable<Integer>> result = new ArrayList<Comparable<Integer>>();
        int[] yearAndPeriod = RPTDateUtil.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod);
        Integer year = new Integer(yearAndPeriod[0]);
        Integer period = new Integer(yearAndPeriod[1]);
        Date date = RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)RptPeriodType));
        result.add(0, year);
        result.add(1, period);
        result.add(2, date);
        return result;
    }

    private static int getWeekByDate(int year, int month, int date) {
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.set(year, month - 1, date);
        return calendar.get(3);
    }

    public static Date getLastDayByDate(Date anyDate) {
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.setTime(anyDate);
        int iYear = calendar.get(1);
        int iMonth = calendar.get(2);
        calendar.set(iYear, iMonth, monthLength[iMonth]);
        return calendar.getTime();
    }

    public static Date getNextMonthLastDayByDate(Date anyDate) {
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.setTime(anyDate);
        int iYear = calendar.get(1);
        int iMonth = calendar.get(2);
        if (++iMonth == 12) {
            iMonth = 0;
            ++iYear;
        }
        calendar.set(iYear, iMonth, monthLength[iMonth]);
        return calendar.getTime();
    }

    public static Date getPrevMonthLastDayByDate(Date anyDate) {
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.setTime(anyDate);
        int iYear = calendar.get(1);
        int iMonth = calendar.get(2);
        if (--iMonth == -1) {
            iMonth = 11;
            --iYear;
        }
        calendar.set(iYear, iMonth, monthLength[iMonth]);
        return calendar.getTime();
    }

    public static Date getYearFirstDayByDate(Date anyDate) {
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.setTime(anyDate);
        int iYear = calendar.get(1);
        calendar.set(iYear, 0, 1);
        return calendar.getTime();
    }

    public static boolean isYearLastPeriod(Date curDate, RptPeriodTypeEnum periodType) {
        if (curDate == null || periodType == null) {
            return false;
        }
        int[] yearAndPeriod = RPTDateUtil.getPeriod(curDate, periodType);
        Calendar ca = RPTDateUtil.getCalendarTimeIsZero();
        ca.setTime(curDate);
        int month = ca.get(2);
        int date = ca.get(5);
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        if (periodType.getValue() == 2 && month == 11 && date == 30) {
            calendar.set(yearAndPeriod[0], 11, 30);
        } else {
            calendar.set(yearAndPeriod[0], 11, 31);
        }
        if (curDate == null) {
            return false;
        }
        return curDate.compareTo(calendar.getTime()) == 0;
    }

    private static Calendar getCalendarTimeIsZero() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        return calendar;
    }

    public static Date getBeginOfDay(Date d) {
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.setTime(d);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndOfDay(Date d) {
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.setTime(d);
        int day = cal.get(6);
        cal.set(6, day + 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, -1);
        return cal.getTime();
    }

    public static Date getBeginOfYear(int year) {
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.set(year, 0, 1, 0, 0, 0);
        return cal.getTime();
    }

    public static Date getEndOfYear(int year) {
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.set(year + 1, 0, 1, 0, 0, 0);
        cal.set(14, -1);
        return cal.getTime();
    }

    public static Date getBeginOfMonth(int year, int month) {
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.set(year, month - 1, 1, 0, 0, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndOfMonth(int year, int month) {
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.set(year, month, 1, 0, 0, 0);
        cal.set(13, -1);
        return cal.getTime();
    }

    public static Date getFirstDayByDate(Date date) {
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getPreDay(Date date) {
        Calendar cal = RPTDateUtil.getCalendarTimeIsZero();
        cal.setTime(date);
        cal.set(6, cal.get(6) - 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getPrePeriodLastDayByDate(Date date, RptPeriodTypeEnum periodType) {
        int[] ls = RPTDateUtil.getPeriod(date, periodType);
        int[] pre = RPTDateUtil.getPrevYearAndPeriod(ls[0], ls[1], periodType);
        return RPTDateUtil.getPeriodLastDate(pre[0], pre[1], periodType);
    }

    public static int[] getPrevYearAndPeriod(int iYear, int iPeriod, RptPeriodTypeEnum periodType) {
        int iPeriodNew;
        int iYearNew;
        if (iPeriod == 1) {
            iYearNew = iYear - 1;
            iPeriodNew = RPTDateUtil.getPeriod(iYearNew, 12, 31, periodType);
        } else {
            iYearNew = iYear;
            iPeriodNew = iPeriod - 1;
        }
        int[] arrlstResult = new int[]{iYearNew, iPeriodNew};
        return arrlstResult;
    }

    public static int[] getStartAndEndPeriod(int iYear, int iStartPeriod, int iEndPeriod, int iPeriodType, int iOffsetYear, int iOffsetPeriod) {
        int endPeriod;
        int endYear;
        int startPeriod;
        int startYear;
        int[] start = RPTDateUtil.getRptYearAndPeriod(iYear, iStartPeriod, iPeriodType, iOffsetYear, iOffsetPeriod);
        int[] end = RPTDateUtil.getRptYearAndPeriod(iYear, iEndPeriod, iPeriodType, iOffsetYear, iOffsetPeriod);
        if (start == null) {
            startYear = iYear;
            startPeriod = iStartPeriod;
        } else {
            startYear = start[0];
            startPeriod = start[1];
        }
        if (end == null) {
            endYear = iYear;
            endPeriod = iEndPeriod;
        } else {
            endYear = end[0];
            endPeriod = end[1];
        }
        int[] result = new int[]{startYear, startPeriod, endYear, endPeriod};
        return result;
    }

    public static String formateDate(Date date, String style) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat dateFormate = null;
        try {
            dateFormate = new SimpleDateFormat(style);
        }
        catch (Exception e) {
            dateFormate = new SimpleDateFormat(DATE_STYLE_YMD);
        }
        return dateFormate.format(date);
    }

    public static Date stringToDate(String date) {
        DateFormat df = DateFormat.getDateInstance();
        try {
            return df.parse(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date stringToDate(String date, String style) {
        SimpleDateFormat df = new SimpleDateFormat(style);
        try {
            return df.parse(date);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date stringToDateTime(String time, String style) {
        DateFormat dateTimeInstance = DateFormat.getDateTimeInstance();
        try {
            return dateTimeInstance.parse(time);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static int[] getRptYearAndPeriod(int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriodBegin, int offsetPeriodEnd) {
        if (offsetYear > 1000 && (offsetPeriodBegin > 0 || offsetPeriodEnd > 0)) {
            int[] result = new int[]{offsetYear, offsetPeriodBegin, offsetPeriodEnd};
            return result;
        }
        if (offsetYear > 1000) {
            offsetYear -= RptYear;
        }
        if (offsetPeriodBegin > 0) {
            offsetPeriodBegin -= RptPeriod;
        }
        if (offsetPeriodEnd > 0) {
            offsetPeriodEnd -= RptPeriod;
        }
        Calendar rptCalendar = RPTDateUtil.getCalendarTimeIsZero();
        int resultYear = 0;
        int resultPeriodBegin = 0;
        int resultPeriodEnd = 0;
        rptCalendar.set(1, RptYear);
        switch (RptPeriodType) {
            case 1: {
                rptCalendar.set(6, RptPeriod);
                rptCalendar.add(1, offsetYear);
                rptCalendar.add(5, offsetPeriodBegin);
                resultYear = rptCalendar.get(1);
                resultPeriodBegin = rptCalendar.get(6);
                rptCalendar.set(6, RptPeriod);
                rptCalendar.add(1, offsetYear);
                rptCalendar.add(5, offsetPeriodBegin);
                resultYear = rptCalendar.get(1);
                resultPeriodEnd = rptCalendar.get(6);
                break;
            }
            case 2: {
                rptCalendar.set(3, RptPeriod);
                rptCalendar.add(1, offsetYear);
                rptCalendar.add(3, offsetPeriodBegin);
                resultYear = rptCalendar.get(1);
                if (resultYear == RptYear - 1) {
                    ++resultYear;
                }
                resultPeriodBegin = rptCalendar.get(3);
                rptCalendar.set(3, RptPeriod);
                rptCalendar.add(1, offsetYear);
                rptCalendar.add(3, offsetPeriodEnd);
                resultYear = rptCalendar.get(1);
                if (resultYear == RptYear - 1) {
                    // empty if block
                }
                resultPeriodEnd = rptCalendar.get(3);
                break;
            }
            case 3: {
                rptCalendar.add(1, offsetYear);
                rptCalendar.set(2, 0);
                rptCalendar.add(2, RptPeriod + offsetPeriodBegin - 1);
                resultYear = rptCalendar.get(1);
                resultPeriodBegin = rptCalendar.get(2) + 1;
                rptCalendar.add(1, offsetYear);
                rptCalendar.set(2, 0);
                rptCalendar.add(2, RptPeriod + offsetPeriodEnd - 1);
                resultYear = rptCalendar.get(1);
                resultPeriodEnd = rptCalendar.get(2) + 1;
                break;
            }
            case 4: {
                resultYear = RptYear + offsetYear;
                resultPeriodBegin = RptPeriod + offsetPeriodBegin;
                resultYear += resultPeriodBegin / 4;
                if ((resultPeriodBegin %= 4) == 0) {
                    --resultYear;
                    resultPeriodBegin = 4;
                } else if (resultPeriodBegin < 0) {
                    resultPeriodBegin += 4;
                    --resultYear;
                }
                resultYear = RptYear + offsetYear;
                resultPeriodEnd = RptPeriod + offsetPeriodEnd;
                resultYear += resultPeriodEnd / 4;
                if ((resultPeriodEnd %= 4) == 0) {
                    --resultYear;
                    resultPeriodEnd = 4;
                    break;
                }
                if (resultPeriodEnd >= 0) break;
                resultPeriodEnd += 4;
                --resultYear;
                break;
            }
            case 5: {
                resultYear = RptYear + offsetYear;
                resultPeriodBegin = RptPeriod + offsetPeriodBegin;
                resultYear += resultPeriodBegin / 2;
                if ((resultPeriodBegin %= 2) == 0) {
                    --resultYear;
                    resultPeriodBegin = 2;
                } else if (resultPeriodBegin < 0) {
                    resultPeriodBegin += 2;
                    --resultYear;
                }
                resultYear = RptYear + offsetYear;
                resultPeriodEnd = RptPeriod + offsetPeriodEnd;
                resultYear += resultPeriodEnd / 2;
                if ((resultPeriodEnd %= 2) == 0) {
                    --resultYear;
                    resultPeriodEnd = 2;
                    break;
                }
                if (resultPeriodEnd >= 0) break;
                resultPeriodEnd += 2;
                --resultYear;
                break;
            }
            case 6: {
                resultYear = RptYear + offsetYear;
                resultPeriodBegin = 1;
                resultYear = RptYear + offsetYear;
                resultPeriodEnd = 1;
                break;
            }
        }
        int[] result = new int[]{++resultYear, resultPeriodBegin, resultPeriodEnd};
        return result;
    }

    public static int[] getLastPeriod(RptPeriodTypeEnum t, int last) {
        Calendar c = RPTDateUtil.getCalendarTimeIsZero();
        if (t.getValue() == 3) {
            c.set(2, c.get(2) - (last - 1));
        } else if (t.getValue() == 4) {
            c.set(2, c.get(2) - (last * 3 - 1));
        } else if (t.getValue() == 6) {
            c.set(2, c.get(2) - (last * 12 - 1));
        }
        int thismonth = c.get(2);
        do {
            c.add(5, -1);
        } while (c.get(2) == thismonth);
        int[] period = RPTDateUtil.getPeriod(new Date(c.getTimeInMillis()), t);
        return period;
    }

    public static Date getDateByYearOrPreYear(Context ctx, String companyId, String companyNum, int year, int period, boolean isBeginDate) throws BOSException, EASBizException {
        if (year <= 0) {
            return NON_PERIOD_BE_FOUND;
        }
        if (period == 0) {
            return NON_PERIOD_BE_FOUND;
        }
        if (StringUtils.isEmpty((String)companyId) && StringUtils.isEmpty((String)companyNum)) {
            return NON_PERIOD_BE_FOUND;
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = null;
        if (!StringUtils.isEmpty((String)companyId)) {
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        } else if (!StringUtils.isEmpty((String)companyNum)) {
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo("WHERE number = '" + companyNum + "'");
        } else {
            return NON_PERIOD_BE_FOUND;
        }
        if (companyInfo != null && companyInfo.getAccountPeriodType() != null && companyInfo.getAccountPeriodType() != null) {
            PeriodInfo periodInfo;
            int i;
            IPeriod periodInteface = ctx != null ? PeriodFactory.getLocalInstance((Context)ctx) : PeriodFactory.getRemoteInstance();
            String addPeriodCondition = "";
            String preYearCondition = "";
            if (period <= 0) {
                preYearCondition = " OR periodYear = " + (year - 1) + " ";
            } else {
                addPeriodCondition = " AND periodNumber = " + period + " ";
            }
            PeriodCollection col = periodInteface.getPeriodCollection("select \tperiodYear,periodNumber,beginDate,endDate where \t\tperiodType.id='" + companyInfo.getAccountPeriodType().getId().toString() + "'  AND (  periodYear =" + year + " " + preYearCondition + " ) " + addPeriodCondition + "order by periodYear,periodNumber asc");
            if (period > 0) {
                if (col.size() == 1) {
                    return isBeginDate ? col.get(0).getBeginDate() : col.get(0).getEndDate();
                }
                return NON_PERIOD_BE_FOUND;
            }
            for (i = 0; i < col.size() && (periodInfo = col.get(i)).getPeriodYear() != year; ++i) {
            }
            if (i + period < 0 || i == 0 && period <= 0) {
                return NON_PERIOD_BE_FOUND;
            }
            return isBeginDate ? col.get(i + period).getBeginDate() : col.get(i + period).getEndDate();
        }
        return NON_PERIOD_BE_FOUND;
    }
}

