/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.RptItemQuery;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RptItemVerifier {
    private static Pattern initItemPattern(boolean isDItem) throws EASBizException, BOSException {
        Pattern itemPattern = null;
        HashMap dataElementMap = DataElementProvider.getDataElementMap();
        StringBuffer sbDateElement = new StringBuffer();
        for (Object obj : dataElementMap.values()) {
            if (!(obj instanceof DataElementInfo)) continue;
            if (sbDateElement.length() > 0) {
                sbDateElement.append('|');
            }
            sbDateElement.append(((DataElementInfo)obj).getNumber());
        }
        Object[] vtArray = ValueTypeEnum.getEnumList().toArray();
        StringBuffer sbValueType = new StringBuffer();
        for (int i = 0; i < vtArray.length; ++i) {
            if (i > 0) {
                sbValueType.append('|');
            }
            sbValueType.append(((ValueTypeEnum)((Object)vtArray[i])).getName());
        }
        String pattern = null;
        pattern = isDItem ? "\\s*\\=\\s*DItem\\s*\\(\\s*\\\"(.+?)\\\"\\s*\\,\\s*\\\"(.*?)\\\"\\s*\\,\\s*\\-?\\d+\\s*\\,\\s*\\-?\\d+\\s*\\,\\s*\\\"(" + sbDateElement.toString() + ")\\\"\\s*\\,\\s*\\\"(" + sbValueType.toString() + ")\\\"\\s*\\)\\s*" : "\\s*\\=\\s*Item\\s*\\(\\s*\\\"(.+?)\\\"\\s*\\,\\s*\\-?\\d+\\s*\\,\\s*\\-?\\d+\\s*\\,\\s*\\\"(" + sbDateElement.toString() + ")\\\"\\s*\\,\\s*\\\"(" + sbValueType.toString() + ")\\\"\\s*\\)\\s*";
        itemPattern = Pattern.compile(pattern);
        return itemPattern;
    }

    public static CheckReport verify(Book book, boolean isDItem) throws EASBizException, BOSException {
        return RptItemVerifier.verify(true, book, isDItem);
    }

    public static CheckReport verify(boolean isGradeManage, Book book, boolean isDItem) throws EASBizException, BOSException {
        StringBuffer result = new StringBuffer();
        DataElementProvider.refresh();
        Pattern itemPattern = RptItemVerifier.initItemPattern(isDItem);
        ArrayList itemListInfo = new ArrayList();
        HashMap formulaCache = new HashMap();
        Sheet table = null;
        int tableCount = book.getSheetCount();
        ReportVariables v = ReportVariables.loadFromBook((Book)book);
        if (v == null) {
            v = new ReportVariables();
        }
        boolean isPassed = true;
        String res = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";
        String cslRptUtil_721 = null;
        String cslRptUtil_722 = null;
        String cslRptUtil_723 = null;
        String cslRptUtil_724 = null;
        String cslRptUtil_725 = null;
        String cslRptUtil_726 = null;
        HashMap basePoints = new HashMap();
        boolean checkIsExists = book.getUserObject("isFromXMLImport") != null && Boolean.TRUE.equals(book.getUserObject("isFromXMLImport").getValue());
        for (int n = 0; n < tableCount; ++n) {
            table = book.getSheet(n);
            int reportClass = v.getIntValue("SheetClass", table.getSheetName(), 1);
            int mcol = table.getCols().getMaxIntMark();
            int mrow = table.getRows().getMaxIntMark();
            if (mcol < 0) {
                mcol = 0;
            }
            if (mrow < 0) {
                mrow = 0;
            }
            Sheet.ICellsIterator it = table.getCellsIterator(0, 0, mrow, mcol, false, true);
            while (it.hasNext()) {
                Cell cell = it.next();
                ItemFormula item = NewRptUtil.getItemFormula((Cell)cell, basePoints);
                if (cell == null || item == null || RptItemVerifier.checkItemFormula(item, reportClass, table, cell, isDItem, itemPattern, formulaCache, itemListInfo, checkIsExists)) continue;
                isPassed = false;
                if (cslRptUtil_721 == null) {
                    cslRptUtil_721 = EASResource.getString((String)res, (String)"721_CslRptUtil");
                }
                if (cslRptUtil_722 == null) {
                    cslRptUtil_722 = EASResource.getString((String)res, (String)"722_CslRptUtil");
                }
                result.append(cslRptUtil_721).append("[").append(table.getSheetName()).append("]").append(TableToolkit.xy2range((int)cell.getCol(), (int)cell.getRow())).append(cslRptUtil_722);
                if (item.getExt("20").equals("22")) {
                    if (cslRptUtil_723 == null) {
                        cslRptUtil_723 = EASResource.getString((String)res, (String)"723_CslRptUtil");
                    }
                    result.append(item.toString()).append(cslRptUtil_723).append("\n").append("<br>");
                    continue;
                }
                if (!item.getExt("20").equals("24")) continue;
                if (cslRptUtil_725 == null) {
                    cslRptUtil_725 = EASResource.getString((String)res, (String)"725_CslRptUtil");
                }
                if (cslRptUtil_726 == null) {
                    cslRptUtil_726 = EASResource.getString((String)res, (String)"726_CslRptUtil");
                }
                String duplicate = item.getExt("2244");
                result.append(item.toString()).append(cslRptUtil_725).append(duplicate).append(cslRptUtil_726).append("\n").append("<br>");
            }
        }
        if (!itemListInfo.isEmpty() && checkIsExists) {
            ArrayList<String> numberList = new ArrayList<String>(itemListInfo.size());
            HashMap map = new HashMap();
            for (int i = 0; i < itemListInfo.size(); ++i) {
                String strItemNumber = ((ValidateInfo)itemListInfo.get(i)).itemNumber;
                if (map.containsKey(strItemNumber)) continue;
                map.put(strItemNumber, null);
                numberList.add(strItemNumber);
            }
            RptItemQuery rptItemQuery = new RptItemQuery();
            rptItemQuery.setNumberList(numberList);
            rptItemQuery.setSelectType(1);
            rptItemQuery.setGradeManage(isGradeManage);
            RPTItemCollection col = RPTItemFactory.getRemoteInstance().getCollectionNoChild(rptItemQuery);
            HashSet<String> itemCache = new HashSet<String>();
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                RPTItemInfo info = (RPTItemInfo)iter.next();
                itemCache.add(info.getNumber());
            }
            for (int i = 0; i < itemListInfo.size(); ++i) {
                ValidateInfo validateInfo = (ValidateInfo)itemListInfo.get(i);
                if (itemCache.contains(validateInfo.itemNumber)) continue;
                isPassed = false;
                if (cslRptUtil_721 == null) {
                    cslRptUtil_721 = EASResource.getString((String)res, (String)"721_CslRptUtil");
                }
                if (cslRptUtil_722 == null) {
                    cslRptUtil_722 = EASResource.getString((String)res, (String)"722_CslRptUtil");
                }
                if (cslRptUtil_724 == null) {
                    cslRptUtil_724 = EASResource.getString((String)res, (String)"724_CslRptUtil");
                }
                result.append(cslRptUtil_721).append("[").append(validateInfo.SheetName).append("]").append(TableToolkit.xy2range((int)validateInfo.cell.getCol(), (int)validateInfo.cell.getRow())).append(cslRptUtil_722);
                result.append(validateInfo.itemFormula.toString()).append(cslRptUtil_724).append("\n").append("<br>");
            }
            itemCache.clear();
        }
        itemPattern = null;
        itemListInfo = null;
        formulaCache = null;
        CheckReport checkReport = new CheckReport();
        checkReport.setCheckMsg(result.toString());
        checkReport.setPass(isPassed);
        return checkReport;
    }

    private static boolean checkItemFormula(ItemFormula itemFormula, int reportClass, Sheet sheet, Cell cell, boolean isDItem, Pattern itemPattern, Map formulaCache, List itemListInfo, boolean checkIsExists) throws EASBizException, BOSException {
        String formula = itemFormula.getFormula();
        String typeFormula = reportClass + "@" + formula;
        if (formula == null || formula.length() == 0) {
            return true;
        }
        itemFormula.removeExt("20");
        if (formulaCache.containsKey(typeFormula)) {
            itemFormula.putExt("20", "24");
            itemFormula.putExt("2244", (String)formulaCache.get(typeFormula));
            return false;
        }
        formulaCache.put(typeFormula, "[" + sheet.getSheetName() + "]" + TableToolkit.xy2range((int)cell.getCol(), (int)cell.getRow()));
        Matcher m = itemPattern.matcher(formula);
        if (m.matches() && DataElementProvider.existsDataElement(m.group(isDItem ? 3 : 2))) {
            if (checkIsExists) {
                ValidateInfo info = new ValidateInfo();
                info.itemFormula = itemFormula;
                info.SheetName = sheet.getSheetName();
                info.cell = cell;
                info.itemNumber = m.group(1);
                itemListInfo.add(info);
            }
            return true;
        }
        itemFormula.putExt("20", "22");
        return false;
    }

    private static class ValidateInfo {
        private Cell cell;
        private ItemFormula itemFormula;
        private String SheetName;
        private String itemNumber;

        private ValidateInfo() {
        }
    }

    static class CheckReport {
        private boolean isPass;
        private String checkMsg;

        CheckReport() {
        }

        public boolean isPass() {
            return this.isPass;
        }

        public void setPass(boolean isPass) {
            this.isPass = isPass;
        }

        public String getCheckMsg() {
            return this.checkMsg;
        }

        public void setCheckMsg(String checkMsg) {
            this.checkMsg = checkMsg;
        }
    }
}

