/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ArchivedStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustDynamicItem;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustEntry;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdjustImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.AdjustImport");
    private static final String ADJ_NUMBER = "FNUMBER";
    private static final String ADJ_BIZDATE = "FBIZDATE";
    private static final String ADJ_COMPANY = "FCOMPANY";
    private static final String ADJ_MODE = "FADJUSTMODE";
    private static final String ADJ_DATASOURCE = "FDATASOURCE";
    private static final String ADJ_VALUETYPE = "FVALUETYPE";
    private static final String ADJ_CURRENCY = "FCURRENCY";
    private static final String ADJ_SOURCECURRENCY = "FSOURCECURRENCY";
    private static final String ADJ_ISCITEDBYLATER = "FISCITEDBYLATER";
    private static final String ADJ_REMARK = "FREMARK";
    private static final String ADJ_CUSTOMNUMBER = "FCUSTOMNUMBER";
    private static final String ADJ_ENTRY_SUMMARY = "FSUMMARY";
    private static final String ADJ_ENTRY_ITEM = "FITEM";
    private static final String ADJ_ENTRY_DATAELEMENT = "FDATAELEMENT";
    private static final String ADJ_ENTRY_DEBIT = "FDEBIT";
    private static final String ADJ_ENTRY_CREDIT = "FCREDIT";
    private static final String ADJ_DYN_KEYNUMBER = "FKEYNUMBER";
    private static final String ADJ_DYN_KEYLONGNUMBER = "FKEYLONGNUMBER";
    private static final String ADJ_DYN_KEYNAME = "FKEYNAME";
    private static final String ADJ_DYN_VALUE = "FVALUE";
    private static final String ADJ_DYN_REMARK = "FDYNAREMARK";
    private static final String ADJ_DYN_ASSTACTTYPENUMBER = "FASSTACTTYPENUMBER";
    private static final String KEY_FLAG = "kingdee_eas_rpt";
    private OrgTreeInfo orgtree;
    private RptPeriodTypeEnum periodType;
    private int year;
    private int period;
    private Date rptdate;
    private Map cachedCurrencyNumber = new HashMap();
    private Map cachedSourceCurrencyNumber = new HashMap();
    private Map cachedElement = new HashMap();
    private Map cachedCompanyNumber = new HashMap();
    private Map cachedItemNumber = new HashMap();
    private Map cachedAdjustedMode = new HashMap();
    private Map cachedCompanyPermission = new HashMap();
    private boolean isByCompany = false;
    private Timestamp ts = new Timestamp(System.currentTimeMillis());
    private boolean hasCodeRule = false;
    private IAdjust iAdj = null;
    private IAdjustEntry iAdjEntry = null;
    private IAdjustDynamicItem iAdjustDynamic = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    private void initParams(Context ctx) throws TaskExternalException {
        if (this.orgtree != null) {
            return;
        }
        String orgtree_id = (String)this.getContextParameter().get("ORGTREE_ID");
        this.orgtree = new OrgTreeInfo();
        this.orgtree.setId(BOSUuid.read((String)orgtree_id));
        this.periodType = (RptPeriodTypeEnum)this.getContextParameter().get("PERIOD_TYPE");
        this.year = (Integer)this.getContextParameter().get("YEAR");
        this.period = (Integer)this.getContextParameter().get("PERIOD");
        this.rptdate = (Date)this.getContextParameter().get("DATE");
        Object obj = this.getContextParameter().get("isByCompany");
        if (obj != null) {
            this.isByCompany = (Boolean)obj;
        }
    }

    private void initCodeRule(Context ctx) throws EASBizException, BOSException {
        this.hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)new AdjustInfo(), CSLServerHelper.getRootOrgIDForRootCU(ctx));
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String adjValueTypeName;
        ValueTypeEnum valueType;
        String adjCompanyNumber;
        FullOrgUnitInfo orgUnitInfo;
        try {
            this.initCodeRule(ctx);
        }
        catch (EASBizException e1) {
            throw new TaskExternalException(e1.getMessage());
        }
        catch (BOSException e1) {
            throw new TaskExternalException(e1.getMessage());
        }
        this.initParams(ctx);
        String adjNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_NUMBER)).data;
        if (StringUtils.isEmpty((String)adjNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"99_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        String adjBizdate = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_BIZDATE)).data;
        Date bizDate = null;
        if (!StringUtils.isEmpty((String)adjBizdate)) {
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern("yyyy-MM-dd");
            try {
                bizDate = sdf.parse(adjBizdate);
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"100_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
        }
        if ((orgUnitInfo = this.getCompanyNumber(ctx, adjCompanyNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_COMPANY)).data)) == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"101_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        this.checkCompanyPermission(ctx, (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()));
        String adjModeNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_MODE)).data;
        AdjustModeInfo adjModeInfo = this.getAdjustMode(ctx, adjModeNumber);
        if (adjModeInfo == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"102_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        String adjDataSourceName = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_DATASOURCE)).data;
        RptSrcTypeEnum dataSource = this.getRptEnumByAlias(adjDataSourceName, ctx.getOriginLocale());
        if (dataSource == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"103_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            if (dataSource.getValue() != 1) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"104_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
        } else if (dataSource.getValue() != 2 && dataSource.getValue() != 3) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"105_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        if ((valueType = this.getValueEnumByAlias(adjValueTypeName = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_VALUETYPE)).data, ctx.getOriginLocale())) == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"106_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        String adjCurrencyNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_CURRENCY)).data;
        CurrencyInfo currencyInfo = this.getCurrencyInfo(ctx, adjCurrencyNumber);
        if (currencyInfo == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"107_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        String adjSourceCurrencyNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_SOURCECURRENCY)).data;
        CurrencyInfo sourceCurrencyInfo = this.getSourceCurrencyInfo(ctx, adjSourceCurrencyNumber);
        if (sourceCurrencyInfo == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"108_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        String isCitedByLater = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_ISCITEDBYLATER)).data;
        boolean isCitedLater = RptUtil.isTrue((Object)isCitedByLater, (boolean)false);
        String headRemark = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_REMARK)).data;
        if (!StringUtils.isEmpty((String)headRemark) && headRemark.startsWith("=")) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimiEntryCheckResource", (String)"remarkUnallowStartWithEqual-sign", (Locale)ctx.getLocale()));
        }
        String customNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ADJ_CUSTOMNUMBER)).data;
        AdjustInfo adjInfo = new AdjustInfo();
        adjInfo.setNumber(adjNumber);
        adjInfo.setYear(this.year);
        adjInfo.setPeriod(this.period);
        adjInfo.setDate(this.rptdate);
        adjInfo.setCurrency(currencyInfo);
        adjInfo.setSourceCurrency(sourceCurrencyInfo);
        adjInfo.setOrgBound(this.orgtree);
        adjInfo.setPeriodType(this.periodType);
        adjInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        adjInfo.setDataSource(dataSource);
        adjInfo.setAdjustMode(adjModeInfo);
        adjInfo.setArchivedStatus(ArchivedStatusEnum.UNARCHIVED);
        adjInfo.setValueType(valueType);
        adjInfo.setOrgUnit(orgUnitInfo);
        adjInfo.setIsCitedByLater(isCitedLater ? IsCitedByLaterEnum.ISTRUE : IsCitedByLaterEnum.ISFALSE);
        adjInfo.setBizDate(bizDate == null ? new Date(this.ts.getTime()) : bizDate);
        adjInfo.setCreateTime(this.ts);
        adjInfo.setRemark(headRemark);
        UserInfo uInfo = new UserInfo();
        uInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        adjInfo.setCreator(uInfo);
        adjInfo.setLastUpdateTime(this.ts);
        adjInfo.setLastUpdateUser(uInfo);
        adjInfo.setCustomNumber(customNumber);
        String summary = null;
        String itemNumber = null;
        String dataElementNumber = null;
        String debitStr = null;
        String creditStr = null;
        String keynumber = null;
        String keyLongNumber = null;
        String keyName = null;
        String value = null;
        String remark = null;
        String asstActTypeNumber = null;
        HashMap<String, AdjustEntryInfo> entryMap = new HashMap<String, AdjustEntryInfo>();
        ArrayList<String> entryList = new ArrayList<String>();
        Hashtable entryData = null;
        int precision = this.getCurrencyPrecision(currencyInfo);
        for (int i = 0; i < hsData.size(); ++i) {
            String entryKey;
            entryData = (Hashtable)hsData.get(new Integer(i));
            summary = (String)((DataToken)entryData.get((Object)ADJ_ENTRY_SUMMARY)).data;
            if (!StringUtils.isEmpty((String)summary) && summary.startsWith("=")) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimiEntryCheckResource", (String)"summaryUnallowStartWithEqual-sign", (Locale)ctx.getLocale()));
            }
            itemNumber = (String)((DataToken)entryData.get((Object)ADJ_ENTRY_ITEM)).data;
            RPTItemInfo iteminfo = this.getItemByNumber(ctx, itemNumber);
            if (iteminfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"109_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            dataElementNumber = (String)((DataToken)entryData.get((Object)ADJ_ENTRY_DATAELEMENT)).data;
            DataElementInfo dataElementInfo = this.getDataElementInfo(ctx, dataElementNumber);
            if (dataElementInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"110_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            debitStr = (String)((DataToken)entryData.get((Object)ADJ_ENTRY_DEBIT)).data;
            BigDecimal debitValue = null;
            try {
                if (!StringUtils.isEmpty((String)debitStr)) {
                    debitValue = new BigDecimal(debitStr).setScale(precision, 4);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"111_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            creditStr = (String)((DataToken)entryData.get((Object)ADJ_ENTRY_CREDIT)).data;
            BigDecimal creditValue = null;
            try {
                if (!StringUtils.isEmpty((String)creditStr)) {
                    creditValue = new BigDecimal(creditStr).setScale(precision, 4);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"112_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            if (debitValue == null && creditValue == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"113_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            if (debitValue != null && creditValue != null) {
                if (debitValue.compareTo(new BigDecimal(0)) == 0 && creditValue.compareTo(new BigDecimal(0)) == 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"114_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
                if (debitValue.compareTo(new BigDecimal(0)) != 0 && creditValue.compareTo(new BigDecimal(0)) != 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"115_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
            }
            AdjustEntryInfo adjEntryInfo = new AdjustEntryInfo();
            adjEntryInfo.setAdjust(adjInfo);
            adjEntryInfo.setItem(iteminfo);
            adjEntryInfo.setCredit(creditValue);
            adjEntryInfo.setDebit(debitValue);
            String adjustRelevanceSummary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"Adjust_Relevance_Summary", (Locale)ctx.getOriginLocale());
            if (summary.indexOf(adjustRelevanceSummary) != -1) {
                adjEntryInfo.setSummary(adjustRelevanceSummary.substring(0, adjustRelevanceSummary.length() - 1));
                adjEntryInfo.setSummaryExtend(summary.substring(9, summary.length()));
            } else {
                adjEntryInfo.setSummary(summary);
            }
            adjEntryInfo.setDataElement(dataElementInfo.getInterSeq());
            adjEntryInfo.setIsVisible(true);
            keyLongNumber = (String)((DataToken)entryData.get((Object)ADJ_DYN_KEYLONGNUMBER)).data;
            keynumber = (String)((DataToken)entryData.get((Object)ADJ_DYN_KEYNUMBER)).data;
            keyName = (String)((DataToken)entryData.get((Object)ADJ_DYN_KEYNAME)).data;
            value = (String)((DataToken)entryData.get((Object)ADJ_DYN_VALUE)).data;
            if (entryData.get(ADJ_DYN_REMARK) != null) {
                remark = (String)((DataToken)entryData.get((Object)ADJ_DYN_REMARK)).data;
            }
            asstActTypeNumber = (String)((DataToken)entryData.get((Object)ADJ_DYN_ASSTACTTYPENUMBER)).data;
            BigDecimal bigValue = null;
            boolean isAllEmpty = false;
            if (StringUtils.isEmpty((String)keyLongNumber) && StringUtils.isEmpty((String)keynumber) && StringUtils.isEmpty((String)keyName) && StringUtils.isEmpty((String)value) && StringUtils.isEmpty((String)asstActTypeNumber)) {
                isAllEmpty = true;
            } else {
                if (StringUtils.isEmpty((String)keyLongNumber)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"116_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
                if (StringUtils.isEmpty((String)keynumber)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"117_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
                if (StringUtils.isEmpty((String)keyName)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"118_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
                try {
                    if (!StringUtils.isEmpty((String)value)) {
                        bigValue = new BigDecimal(value).setScale(precision, 4);
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"119_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
            }
            AdjustDynamicItemInfo adjDynItemInfo = new AdjustDynamicItemInfo();
            adjDynItemInfo.setAdjustEntry(adjEntryInfo);
            adjDynItemInfo.setRptItem(iteminfo);
            adjDynItemInfo.setKeyLongNumber(keyLongNumber);
            adjDynItemInfo.setKeyNumber(keynumber);
            adjDynItemInfo.setKeyName(keyName);
            adjDynItemInfo.setValue(bigValue);
            adjDynItemInfo.setAsstActTypeNumber(asstActTypeNumber);
            adjDynItemInfo.setRemark(remark);
            String dynKey = KEY_FLAG + new Integer(i).toString();
            if (!isAllEmpty) {
                adjEntryInfo.put(dynKey, adjDynItemInfo);
            }
            if (entryMap.containsKey(entryKey = adjEntryInfo.getItem().getNumber() + new Integer(adjEntryInfo.getDataElement()).toString())) {
                if (isAllEmpty) continue;
                AdjustEntryInfo entryInfo = (AdjustEntryInfo)entryMap.get(entryKey);
                entryInfo.put(dynKey, adjDynItemInfo);
                entryMap.remove(entryKey);
                entryMap.put(entryKey, entryInfo);
                entryList.add(entryKey);
                continue;
            }
            entryMap.put(entryKey + i, adjEntryInfo);
            entryList.add(entryKey + i);
        }
        Iterator iter = entryList.iterator();
        while (iter.hasNext()) {
            adjInfo.getEntries().add((AdjustEntryInfo)entryMap.get(iter.next()));
        }
        return adjInfo;
    }

    private int getCurrencyPrecision(CurrencyInfo currency) {
        return currency.getPrecision();
    }

    private FullOrgUnitInfo getCompanyNumber(Context ctx, String companyNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)companyNumber)) {
            return null;
        }
        if (this.cachedCompanyNumber.containsKey(companyNumber)) {
            return (FullOrgUnitInfo)this.cachedCompanyNumber.get(companyNumber);
        }
        try {
            String sql = "select orgUnit.fid as orgUnitId, orgUnit.fnumber as orgUnitNumber, orgUnit.fIsCompanyOrgUnit as isCompanyOrgUnit \r\nfrom t_org_structure orgStruct left outer join T_ORG_BaseUnit orgUnit \r\non orgStruct.Funitid = orgUnit.Fid where orgStruct.Ftreeid = ? and orgUnit.Fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{this.orgtree.getId().toString(), companyNumber});
            FullOrgUnitInfo orgUnitInfo = null;
            if (rs != null && rs.next()) {
                orgUnitInfo = new FullOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("orgUnitId")));
                orgUnitInfo.setNumber(rs.getString("orgUnitNumber"));
                orgUnitInfo.setIsCompanyOrgUnit(RptUtil.isTrue((Object)new Integer(rs.getInt("isCompanyOrgUnit")), (boolean)false));
                this.cachedCompanyNumber.put(companyNumber, orgUnitInfo);
            }
            return orgUnitInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private AdjustModeInfo getAdjustMode(Context ctx, String adjModeNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)adjModeNumber)) {
            return null;
        }
        if (this.cachedAdjustedMode.containsKey(adjModeNumber)) {
            return (AdjustModeInfo)this.cachedAdjustedMode.get(adjModeNumber);
        }
        try {
            String sql = "select fid, fnumber from T_CSL_AdjustMode where fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{adjModeNumber});
            AdjustModeInfo adjModeInfo = null;
            if (rs != null && rs.next()) {
                adjModeInfo = new AdjustModeInfo();
                adjModeInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                adjModeInfo.setNumber(rs.getString("fnumber"));
                this.cachedAdjustedMode.put(adjModeNumber, adjModeInfo);
            }
            return adjModeInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)currencyNumber)) {
            return null;
        }
        if (this.cachedCurrencyNumber.containsKey(currencyNumber)) {
            return (CurrencyInfo)this.cachedCurrencyNumber.get(currencyNumber);
        }
        try {
            String sql = "select fid, fnumber, fprecision from T_BD_Currency where fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{currencyNumber});
            CurrencyInfo currencyInfo = null;
            if (rs != null && rs.next()) {
                currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                currencyInfo.setNumber(rs.getString("fnumber"));
                currencyInfo.setPrecision(rs.getInt("fprecision"));
                this.cachedCurrencyNumber.put(currencyNumber, currencyInfo);
            }
            return currencyInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private CurrencyInfo getSourceCurrencyInfo(Context ctx, String currencyNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)currencyNumber)) {
            return null;
        }
        if (this.cachedSourceCurrencyNumber.containsKey(currencyNumber)) {
            return (CurrencyInfo)this.cachedSourceCurrencyNumber.get(currencyNumber);
        }
        try {
            String sql = "select fid, fnumber from T_BD_Currency where fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{currencyNumber});
            CurrencyInfo currencyInfo = null;
            if (rs != null && rs.next()) {
                currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                currencyInfo.setNumber(rs.getString("fnumber"));
                this.cachedSourceCurrencyNumber.put(currencyNumber, currencyInfo);
            }
            return currencyInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private DataElementInfo getDataElementInfo(Context ctx, String dataElementNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)dataElementNumber)) {
            return null;
        }
        if (this.cachedElement.containsKey(dataElementNumber)) {
            return (DataElementInfo)this.cachedElement.get(dataElementNumber);
        }
        try {
            String sql = "select fid, fnumber, FInterSeq from T_CSL_DataElement where fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{dataElementNumber});
            DataElementInfo dataElementInfo = null;
            if (rs != null && rs.next()) {
                dataElementInfo = new DataElementInfo();
                dataElementInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                dataElementInfo.setNumber(rs.getString("fnumber"));
                dataElementInfo.setInterSeq(rs.getInt("FInterSeq"));
                this.cachedElement.put(dataElementNumber, dataElementInfo);
            }
            return dataElementInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private RPTItemInfo getItemByNumber(Context ctx, String itemNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)itemNumber)) {
            return null;
        }
        if (this.cachedItemNumber.containsKey(itemNumber)) {
            return (RPTItemInfo)this.cachedItemNumber.get(itemNumber);
        }
        try {
            IRPTItem iItem = RPTItemFactory.getLocalInstance(ctx);
            CoreBaseCollection collection = iItem.getCollection(" where number = '" + itemNumber + "'");
            if (collection.isEmpty()) {
                throw new ServerException(ServerException.ITEMNUMBER_NOTFIND, new Object[]{itemNumber});
            }
            this.cachedItemNumber.put(itemNumber, collection.get(0));
            return (RPTItemInfo)collection.get(0);
        }
        catch (Exception e1) {
            throw new TaskExternalException(e1.getMessage());
        }
    }

    private RptSrcTypeEnum getRptEnumByAlias(String alias, Locale l) {
        List ls = RptSrcTypeEnum.getEnumList();
        return (RptSrcTypeEnum)this.getEnumByAlias(alias, ls, l);
    }

    private ValueTypeEnum getValueEnumByAlias(String alias, Locale l) {
        List ls = ValueTypeEnum.getEnumList();
        return (ValueTypeEnum)this.getEnumByAlias(alias, ls, l);
    }

    private IntEnum getEnumByAlias(String alias, List ls, Locale l) {
        if (StringUtils.isEmpty((String)alias)) {
            return null;
        }
        for (int i = 0; i < ls.size(); ++i) {
            IntEnum t = (IntEnum)ls.get(i);
            if (alias.equals(t.getAlias(l))) {
                return t;
            }
            if (alias.equals(t.getAlias(new Locale("L2")))) {
                return t;
            }
            if (!alias.equals(t.getAlias(new Locale("L3")))) continue;
            return t;
        }
        return null;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        AdjustInfo adjInfo = (AdjustInfo)coreBaseInfo;
        if (adjInfo.getDataCollect() == null) {
            adjInfo.setDataCollect(DataCollectConstant.getActualDC());
            adjInfo.setDataCollectNumber("ACTUALDATA");
        }
        AdjustEntryCollection adjEntryCol = adjInfo.getEntries();
        try {
            AdjustInfo hasExistAdjInfo = this.getHasExistAdjInfo(ctx, adjInfo);
            if (this.isSltImportUpdate()) {
                if (hasExistAdjInfo != null) {
                    if (hasExistAdjInfo.getCheckedStatus().getValue() == 2) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"120_AdjustImport", (Locale)ctx.getOriginLocale()));
                    }
                    if (hasExistAdjInfo.getArchivedStatus().getValue() == 2) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"121_AdjustImport", (Locale)ctx.getOriginLocale()));
                    }
                    AdjustEntryCollection hasExistEntryCol = hasExistAdjInfo.getEntries();
                    ObjectUuidPK[] pks = new ObjectUuidPK[hasExistEntryCol.size()];
                    for (int i = 0; i < hasExistEntryCol.size(); ++i) {
                        this.getAdjustDynamicController(ctx).delete(" where adjustEntry.id = '" + hasExistEntryCol.get(i).getId().toString() + "'");
                        pks[i] = new ObjectUuidPK(hasExistEntryCol.get(i).getId());
                    }
                    this.getAdjustEntryController(ctx).delete((IObjectPK[])pks);
                    this.getAdjustController(ctx).delete(" where id = '" + hasExistAdjInfo.getId().toString() + "'");
                } else if (this.hasCodeRule) {
                    adjInfo.setNumber(null);
                }
            }
            IObjectPK pk = null;
            if (hasExistAdjInfo != null && !this.hasCodeRule) {
                pk = this.getAdjustController(ctx).addnew((CoreBaseInfo)adjInfo);
            } else if (this.hasCodeRule && !this.isSltImportUpdate()) {
                AdjustFactory.getLocalInstance(ctx).checkNumberDup(null, (CoreBillBaseInfo)adjInfo);
                adjInfo.setNumber(null);
                pk = this.getAdjustController(ctx).submit((CoreBaseInfo)adjInfo);
            } else {
                pk = this.hasCodeRule && this.isSltImportUpdate() ? (adjInfo.getNumber() == null ? this.getAdjustController(ctx).submit((CoreBaseInfo)adjInfo) : this.getAdjustController(ctx).addnew((CoreBaseInfo)adjInfo)) : this.getAdjustController(ctx).addnew((CoreBaseInfo)adjInfo);
            }
            AdjustEntryCollection pkAdjEntryCol = this.getHasExistAdjEntryCollection(ctx, pk);
            AdjustEntryInfo adjEntryInfo = null;
            AdjustEntryInfo pkAdjEntryInfo = null;
            for (int i = 0; i < pkAdjEntryCol.size(); ++i) {
                pkAdjEntryInfo = pkAdjEntryCol.get(i);
                for (int j = 0; j < adjEntryCol.size(); ++j) {
                    adjEntryInfo = adjEntryCol.get(j);
                    AdjustDynamicItemInfo adjDynItemInfo = null;
                    String key = null;
                    Enumeration enumn = adjEntryInfo.keys();
                    while (enumn.hasMoreElements()) {
                        key = enumn.nextElement().toString();
                        if (!key.startsWith(KEY_FLAG) || !((adjDynItemInfo = (AdjustDynamicItemInfo)adjEntryInfo.get(key)).getAdjustEntry().getItem().getNumber() + new Integer(adjDynItemInfo.getAdjustEntry().getDataElement()).toString()).equals(pkAdjEntryInfo.getItem().getNumber() + new Integer(pkAdjEntryInfo.getDataElement()).toString())) continue;
                        adjDynItemInfo.getAdjustEntry().setId(pkAdjEntryInfo.getId());
                        this.getAdjustDynamicController(ctx).addnew((CoreBaseInfo)adjDynItemInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected AdjustInfo getHasExistAdjInfo(Context ctx, AdjustInfo info) throws EASBizException, BOSException {
        AdjustInfo adjInfo = new AdjustInfo();
        try {
            String sql = "select adj.fid as adjId, adj.FCheckedStatus as adjCheckedStatus, adj.FArchivedStatus as adjArchivedStatus, \r\n adjEntry.fid as adjEntryId from T_CSL_Adjust adj inner join T_CSL_AdjustEntry adjEntry \r\n on adj.fid = adjEntry.Fadjustid where adj.fnumber = ? and adj.FOrgBoundID = ? \r\nand adj.FPeriodType = ? and adj.FYear = ? and adj.FPeriod = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getNumber(), info.getOrgBound().getId().toString(), new Integer(info.getPeriodType().getValue()), new Integer(info.getYear()), new Integer(info.getPeriod())});
            AdjustEntryInfo adjEntryInfo = null;
            while (rs != null && rs.next()) {
                adjInfo.setId(BOSUuid.read((String)rs.getString("adjId")));
                adjInfo.setCheckedStatus(CheckedStatusEnum.getEnum((int)rs.getInt("adjCheckedStatus")));
                adjInfo.setArchivedStatus(ArchivedStatusEnum.getEnum(rs.getInt("adjArchivedStatus")));
                adjEntryInfo = new AdjustEntryInfo();
                adjEntryInfo.setId(BOSUuid.read((String)rs.getString("adjEntryId")));
                adjInfo.getEntries().add(adjEntryInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getHasExistAdjInfo_SQLException", (Throwable)e);
        }
        return adjInfo.getId() == null ? null : adjInfo;
    }

    protected AdjustEntryCollection getHasExistAdjEntryCollection(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        AdjustEntryCollection adjEntryCol = new AdjustEntryCollection();
        try {
            String sql = "select adjEntry.fid as adjEntryId, adjEntry.FDataElement as adjEntryElement, \r\nrptItem.fid as itemId, rptItem.fnumber as itemNumber from \r\nT_CSL_AdjustEntry adjEntry left outer join T_CSL_RptItem rptItem \r\non adjEntry.FItemID = rptItem.fid where adjEntry.FAdjustID = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            AdjustEntryInfo adjEntryInfo = null;
            RPTItemInfo itemInfo = null;
            while (rs.next()) {
                adjEntryInfo = new AdjustEntryInfo();
                adjEntryInfo.setId(BOSUuid.read((String)rs.getString("adjEntryId")));
                adjEntryInfo.setDataElement(rs.getInt("adjEntryElement"));
                itemInfo = new RPTItemInfo();
                itemInfo.setId(BOSUuid.read((String)rs.getString("itemId")));
                itemInfo.setNumber(rs.getString("itemNumber"));
                adjEntryInfo.setItem(itemInfo);
                adjEntryCol.add(adjEntryInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getHasExistAdjEntryCollection_SQLException", (Throwable)e);
        }
        return adjEntryCol;
    }

    private IAdjust getAdjustController(Context ctx) throws BOSException {
        if (this.iAdj == null) {
            this.iAdj = AdjustFactory.getLocalInstance(ctx);
        }
        return this.iAdj;
    }

    private IAdjustEntry getAdjustEntryController(Context ctx) throws BOSException {
        if (this.iAdjEntry == null) {
            this.iAdjEntry = AdjustEntryFactory.getLocalInstance(ctx);
        }
        return this.iAdjEntry;
    }

    private IAdjustDynamicItem getAdjustDynamicController(Context ctx) throws BOSException {
        if (this.iAdjustDynamic == null) {
            this.iAdjustDynamic = AdjustDynamicItemFactory.getLocalInstance(ctx);
        }
        return this.iAdjustDynamic;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            Hashtable result = new Hashtable();
            this.setData(result, ADJ_NUMBER, rs.getObject("number"));
            this.setData(result, ADJ_BIZDATE, sf.format(rs.getObject("date")));
            this.setData(result, ADJ_COMPANY, rs.getObject("orgUnit.number"));
            this.setData(result, ADJ_MODE, rs.getObject("adjustMode.number"));
            this.setData(result, ADJ_DATASOURCE, RptSrcTypeEnum.getEnum((int)rs.getInt("dataSource")) == null ? null : RptSrcTypeEnum.getEnum((int)rs.getInt("dataSource")).getAlias(ctx.getOriginLocale()));
            this.setData(result, ADJ_VALUETYPE, ValueTypeEnum.getEnum(rs.getInt("valueType")) == null ? null : ValueTypeEnum.getEnum(rs.getInt("valueType")).getAlias(ctx.getOriginLocale()));
            this.setData(result, ADJ_CURRENCY, rs.getObject("currency.number"));
            this.setData(result, ADJ_SOURCECURRENCY, rs.getObject("sourceCurrency.number"));
            this.setData(result, ADJ_ISCITEDBYLATER, Boolean.valueOf(rs.getBoolean("isCitedByLater")) == true ? IsCitedByLaterEnum.ISTRUE.getAlias() : IsCitedByLaterEnum.ISFALSE.getAlias());
            this.setData(result, ADJ_REMARK, rs.getObject("remark"));
            this.setData(result, ADJ_ENTRY_SUMMARY, rs.getObject("summaryAndRemark"));
            this.setData(result, ADJ_ENTRY_ITEM, rs.getObject("item.number"));
            this.setData(result, ADJ_ENTRY_DATAELEMENT, rs.getObject("dataElement.number"));
            this.setData(result, ADJ_ENTRY_DEBIT, rs.getObject("entries.debit"));
            this.setData(result, ADJ_ENTRY_CREDIT, rs.getObject("entries.credit"));
            this.setData(result, ADJ_CUSTOMNUMBER, rs.getObject("customNumber"));
            this.setData(result, ADJ_DYN_KEYLONGNUMBER, rs.getObject("dynamicItem.keyLongNumber"));
            this.setData(result, ADJ_DYN_KEYNUMBER, rs.getObject("DYNAMICITEM.KEYNUMBER"));
            this.setData(result, ADJ_DYN_KEYNAME, rs.getObject("DYNAMICITEM.KEYNAME"));
            this.setData(result, ADJ_DYN_VALUE, rs.getObject("DYNAMICITEM.VALUE"));
            this.setData(result, ADJ_DYN_REMARK, rs.getObject("DYNAMICITEM.REMARK"));
            this.setData(result, ADJ_DYN_ASSTACTTYPENUMBER, rs.getObject("DYNAMICITEM.ASSTACTTYPENUMBER"));
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                result.put(key, CslRptUtil.ReduceBigDecimalZeros((BigDecimal)value));
            } else {
                result.put(key, value.toString());
            }
        }
    }

    public Hashtable getContextParameter() {
        Hashtable p = super.getContextParameter();
        return p;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gr.cslrpt.AdjustQueryForExport";
    }

    public String getMainField() {
        return ADJ_NUMBER;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currenctData) {
        if (firstData != null && currenctData != null) {
            String[] fields = new String[]{ADJ_NUMBER, ADJ_BIZDATE, ADJ_COMPANY, ADJ_MODE, ADJ_DATASOURCE, ADJ_VALUETYPE, ADJ_CURRENCY, ADJ_SOURCECURRENCY, ADJ_ISCITEDBYLATER, ADJ_REMARK, ADJ_CUSTOMNUMBER};
            String firstField = null;
            String currenctField = null;
            for (int i = 0; i < fields.length; ++i) {
                firstField = StringUtils.cnulls(firstData.get(fields[i]));
                if (StringUtils.equals((String)firstField, (String)(currenctField = StringUtils.cnulls(currenctData.get(fields[i]))))) continue;
                return false;
            }
        }
        return true;
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gr.cslrpt.AdjustQueryForExport"));
        super.setContextParameter((Map)param);
    }

    public void checkCompanyPermission(Context ctx, IObjectPK orgUnitId) throws TaskExternalException {
        if (this.isByCompany) {
            String permItem = "cslrpt_adjvoucher_addnew";
            if (this.cachedCompanyPermission.containsKey(orgUnitId)) {
                Object obj = this.cachedCompanyPermission.get(orgUnitId);
                if (obj instanceof TaskExternalException) {
                    throw (TaskExternalException)obj;
                }
            } else {
                try {
                    IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                    iPermission.checkFunctionPermission(ctx.getCaller(), orgUnitId, null, null, permItem, true);
                    this.cachedCompanyPermission.put(orgUnitId.toString(), true);
                }
                catch (Exception e) {
                    TaskExternalException exception = new TaskExternalException(e.getMessage(), (Throwable)e);
                    this.cachedCompanyPermission.put(orgUnitId.toString(), exception);
                    throw exception;
                }
            }
        }
    }
}

