/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCheckResultTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItemCheckFormula;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaInfo;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ArticulationImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.ArticulationImport");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            RPTItemCheckFormulaFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public IRPTItemCheckFormula getBizInterface(Context ctx) {
        IRPTItemCheckFormula iRPTItemCheckFormula = null;
        try {
            iRPTItemCheckFormula = RPTItemCheckFormulaFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)"IRPTItemCheckFormula_getBizInterface_BOSException", (Throwable)e);
        }
        return iRPTItemCheckFormula;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            RPTItemCheckFormulaInfo info = (RPTItemCheckFormulaInfo)coreBaseInfo;
            this.importDataFromXsl(ctx, this.isSltImportUpdate(), (IObjectValue)info);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void importDataFromXsl(Context ctx, boolean isOverride, IObjectValue model) throws BOSException, EASBizException {
        IRPTItemCheckFormula iRPTItemCheckFormula = RPTItemCheckFormulaFactory.getLocalInstance(ctx);
        RPTItemCheckFormulaInfo info = (RPTItemCheckFormulaInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.fid,f.FTrackRecordCreatorID,c.fname_" + ctx.getLocale() + " from T_CSL_CheckFormula f inner join T_ORG_Company c on f.FTrackRecordCreatorID = c.fid where f.fnumber = ?");
        Object[] params = new Object[]{info.getNumber()};
        if (isOverride) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            try {
                if (rs.next()) {
                    this.doDataRepeatInCreateOrg(ctx, info.getNumber(), rs);
                    info.setId(BOSUuid.read((String)rs.getString("fid")));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        iRPTItemCheckFormula.submit((CoreBaseInfo)info);
    }

    private void doDataRepeatInCreateOrg(Context ctx, String num, IRowSet rs) throws SQLException, SundryException {
        if (!rs.getString(2).equals(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString())) {
            throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{num, rs.getString(3)});
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        RPTItemCheckFormulaInfo info = new RPTItemCheckFormulaInfo();
        String number = this.fecthData(hsData, "FNumber");
        if (StringUtil.isEmptyString((String)number)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NumberNull", (Locale)ctx.getOriginLocale()));
        }
        number = number.replaceAll(" ", "");
        info.setNumber(number);
        info.setName(this.fecthData(hsData, "FName"));
        info.setIfClause(this.fecthData(hsData, "FIfClause"));
        info.setLFormula(this.fecthData(hsData, "FLFormula"));
        String operateSymbol = this.fecthData(hsData, "FOperateSymbol");
        OperateSymbolEnum operateSymbolEnum = this.getOperateSymbolEnum(ctx, operateSymbol);
        info.setOperateSymbol(operateSymbolEnum);
        info.setRFormula(this.fecthData(hsData, "FRFormula"));
        String range = this.fecthData(hsData, "FRange");
        if (StringUtils.isEmpty((String)range)) {
            info.setRange(new BigDecimal(0));
        } else {
            BigDecimal rangeBdv = new BigDecimal(range);
            rangeBdv = rangeBdv.setScale(4, RoundingMode.HALF_UP);
            info.setRange(rangeBdv);
        }
        info.setIsFreezed(this.getBooleanFromAlias(this.fecthData(hsData, "FIsFreezed"), ctx));
        String checkResult = this.fecthData(hsData, "FCheckResult");
        FormulaCheckResultTypeEnum formulaCheckResultTypeEnum = this.getFormulaCheckResultTypeEnum(ctx, checkResult);
        info.setCheckResult(formulaCheckResultTypeEnum);
        info.setPrompt(this.fecthData(hsData, "FPrompt"));
        if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            try {
                ObjectStringPK companyPK = new ObjectStringPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
                info.setTrackRecordCreator(company);
            }
            catch (EASBizException e) {
                logger.error((Object)"transmit_EASBizException", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"transmit_BOSException", (Throwable)e);
            }
        }
        return info;
    }

    private String fecthData(Hashtable htData, String key) {
        DataToken dataToken = (DataToken)htData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    private boolean getBooleanFromAlias(String bool, Context ctx) {
        if (StringUtils.isEmpty((String)bool)) {
            return false;
        }
        String upperCase = bool.toUpperCase(ctx.getOriginLocale());
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_Yes", (Locale)ctx.getOriginLocale()).equals(upperCase) || ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_True", (Locale)ctx.getOriginLocale()).equals(upperCase) || "Y".equals(upperCase) || "TRUE".equals(upperCase);
    }

    private OperateSymbolEnum getOperateSymbolEnum(Context ctx, String name) {
        Iterator iterator = OperateSymbolEnum.iterator();
        while (iterator.hasNext()) {
            OperateSymbolEnum operateSymbolEnum = (OperateSymbolEnum)((Object)iterator.next());
            if (!operateSymbolEnum.getAlias(ctx.getOriginLocale()).equals(name)) continue;
            return operateSymbolEnum;
        }
        return null;
    }

    private FormulaCheckResultTypeEnum getFormulaCheckResultTypeEnum(Context ctx, String name) {
        Iterator iterator = FormulaCheckResultTypeEnum.iterator();
        while (iterator.hasNext()) {
            FormulaCheckResultTypeEnum formulaCheckResultTypeEnum = (FormulaCheckResultTypeEnum)((Object)iterator.next());
            if (!formulaCheckResultTypeEnum.getAlias(ctx.getOriginLocale()).equals(name)) continue;
            return formulaCheckResultTypeEnum;
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            if (rs.getString("number") != null) {
                result.put("FNumber", rs.getString("number"));
            }
            if (rs.getString("name") != null) {
                result.put("FName", rs.getString("name"));
            }
            if (rs.getString("ifClause") != null) {
                result.put("FIfClause", rs.getString("ifClause"));
            }
            if (rs.getString("lFormula") != null) {
                result.put("FLFormula", rs.getString("lFormula"));
            }
            result.put("FOperateSymbol", OperateSymbolEnum.getEnum(rs.getInt("operateSymbol")).getAlias(ctx.getOriginLocale()));
            if (rs.getString("rFormula") != null) {
                result.put("FRFormula", rs.getString("rFormula"));
            }
            if (rs.getBigDecimal("range") != null) {
                result.put("FRange", rs.getBigDecimal("range"));
            }
            if (rs.getString("isFreezed").equalsIgnoreCase("true")) {
                result.put("FIsFreezed", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            } else {
                result.put("FIsFreezed", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"794_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            }
            result.put("FCheckResult", FormulaCheckResultTypeEnum.getEnum(rs.getInt("CheckResult")).getAlias(ctx.getOriginLocale()));
            if (rs.getString("prompt") != null) {
                result.put("FPrompt", rs.getString("prompt"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"exportTransmit_SQLException", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaBtwQuery";
    }
}

