/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartUnionGroupFactory;
import com.kingdee.eas.basedata.org.OUPartUnionGroupInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDetailsEnum;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustTemple;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchImportAdjust {
    private Book book = null;
    private static Logger logger = Logger.getLogger(BatchImportAdjust.class);

    public List<IObjectPK> doTemplateBatchImportAdjustRecords(Context ctx, List listId, Map valueMap) throws Exception {
        ArrayList<IObjectPK> ids = new ArrayList<IObjectPK>();
        String orgTreeID = null;
        FullOrgUnitInfo fullOrgUnit = null;
        FullOrgUnitInfo companyOrgUnit = null;
        CurrencyInfo sourceCurrency = null;
        CurrencyInfo currency = null;
        RptSrcTypeEnum dataSource = null;
        Date date = null;
        Timestamp createTime = null;
        int periodType = -1;
        int year = -1;
        int period = -1;
        OrgTreeInfo OrgBound = null;
        if (valueMap != null) {
            if (valueMap.get("orgTreeID") != null) {
                orgTreeID = (String)valueMap.get("orgTreeID");
            }
            if (valueMap.get("fullOrgUnit") != null) {
                fullOrgUnit = (FullOrgUnitInfo)valueMap.get("fullOrgUnit");
            }
            if (valueMap.get("companyOrgUnit") != null) {
                companyOrgUnit = (FullOrgUnitInfo)valueMap.get("companyOrgUnit");
            }
            if (valueMap.get("sourceCurrency") != null) {
                sourceCurrency = (CurrencyInfo)valueMap.get("sourceCurrency");
            }
            if (valueMap.get("currency") != null) {
                currency = (CurrencyInfo)valueMap.get("currency");
            }
            if (valueMap.get("dpkAdjustDate") != null) {
                date = (Date)valueMap.get("dpkAdjustDate");
            }
            if (valueMap.get("dpkCreateTime") != null) {
                createTime = new Timestamp(((Date)valueMap.get("dpkCreateTime")).getTime());
            }
            if (valueMap.get("comboDataSource") != null) {
                dataSource = (RptSrcTypeEnum)valueMap.get("comboDataSource");
            }
            if (valueMap.get("periodType") != null) {
                periodType = (Integer)valueMap.get("periodType");
            }
            if (valueMap.get("year") != null) {
                year = (Integer)valueMap.get("year");
            }
            if (valueMap.get("period") != null) {
                period = (Integer)valueMap.get("period");
            }
            if (valueMap.get("OrgBound") != null) {
                OrgBound = (OrgTreeInfo)valueMap.get("OrgBound");
            }
        }
        boolean hasCodeRule = false;
        String orgID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        AdjustInfo caller = new AdjustInfo();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        hasCodeRule = iCodingRuleManager.isExist((IObjectValue)caller, orgID);
        OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
        orgTreeInfo.setId(BOSUuid.read((String)orgTreeID));
        IAdjustTemple iAdjustTemple = AdjustTempleFactory.getLocalInstance(ctx);
        AdjustTempleInfo templateInfo = null;
        AdjustTempleEntryCollection templeEntryCollection = null;
        String templateId = null;
        AdjustCollection adjustCollection = null;
        AdjustInfo adjustInfo = null;
        int rowIndex = 0;
        if (listId != null && listId.size() > 0) {
            Sheet sheet = null;
            try {
                sheet = this.initBook(ctx, fullOrgUnit, companyOrgUnit, sourceCurrency, currency, year, periodType, period, OrgBound);
            }
            catch (Exception e) {
                logger.error((Object)"initBook error.", (Throwable)e);
            }
            if (sheet == null) {
                throw new Exception("sheet can't null.");
            }
            adjustCollection = new AdjustCollection();
            for (int i = 0; i < listId.size(); ++i) {
                templateId = (String)listId.get(i);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("entries.*"));
                selector.add(new SelectorItemInfo("entries.item.id"));
                selector.add(new SelectorItemInfo("entries.item.number"));
                selector.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
                selector.add(new SelectorItemInfo("entries.company.number"));
                templateInfo = iAdjustTemple.getAdjustTempleInfo((IObjectPK)new ObjectUuidPK(templateId), selector);
                adjustInfo = new AdjustInfo();
                adjustInfo.setId(null);
                adjustInfo.setNumber(null);
                adjustInfo.setOrgBound(orgTreeInfo);
                if (fullOrgUnit != null) {
                    adjustInfo.setOrgUnit(fullOrgUnit);
                } else if (companyOrgUnit != null) {
                    adjustInfo.setOrgUnit(companyOrgUnit);
                }
                adjustInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                adjustInfo.setCreateTime(createTime);
                adjustInfo.setDate(date);
                adjustInfo.setSourceCurrency(sourceCurrency);
                adjustInfo.setCurrency(currency);
                adjustInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                adjustInfo.setAdjustMode(templateInfo.getAdjustMode());
                adjustInfo.setValueType(templateInfo.getValueType());
                adjustInfo.setIsCitedByLater(templateInfo.getIsCitedByLater());
                adjustInfo.setDataSource(dataSource);
                adjustInfo.setTemplet(templateInfo);
                adjustInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                adjustInfo.setYear(year);
                adjustInfo.setPeriod(period);
                templeEntryCollection = templateInfo.getEntries();
                if (templeEntryCollection != null && templeEntryCollection.size() > 0) {
                    OUPartUnionGroupInfo unitGroupInfo;
                    AdjustEntryInfo adjustEntryInfo = null;
                    FullOrgUnitInfo adjustOrgUnit = adjustInfo.getOrgUnit();
                    CompanyOrgUnitInfo stockControlCompany = null;
                    if (adjustOrgUnit != null && adjustOrgUnit.isIsUnion() && (unitGroupInfo = OUPartUnionGroupFactory.getLocalInstance((Context)ctx).getOUPartUnionGroupInfo("select id , stockControlCompany.* where unit.id = '" + adjustOrgUnit.getId().toString() + "'")) != null) {
                        stockControlCompany = unitGroupInfo.getStockControlCompany();
                    }
                    for (int j = 0; j < templeEntryCollection.size(); ++j) {
                        String curCompanyId;
                        Expression stmt;
                        adjustEntryInfo = new AdjustEntryInfo();
                        adjustEntryInfo.setId(null);
                        adjustEntryInfo.setAdjust(null);
                        adjustEntryInfo.setItem(templeEntryCollection.get(j).getItem());
                        adjustEntryInfo.setSummary(templeEntryCollection.get(j).getSummary());
                        adjustEntryInfo.setDataElement(templeEntryCollection.get(j).getDataElement());
                        adjustEntryInfo.setIsVisible(true);
                        adjustEntryInfo.setHasAdjustDetails(AdjustDetailsEnum.NO);
                        adjustInfo.getEntries().add(adjustEntryInfo);
                        Cell cell = null;
                        if (templeEntryCollection.get(j).getDebitFormula() != null) {
                            cell = sheet.getCell(rowIndex, 0, true);
                            stmt = ExcelFormulaPaserHelper.parse((String)templeEntryCollection.get(j).getDebitFormula());
                            if (stmt instanceof FunctionExpr && "ACCT".equals(((FunctionExpr)stmt).funcionName)) {
                                curCompanyId = ((FunctionExpr)stmt).parameters.get(0).toString();
                                if (curCompanyId != null && curCompanyId.indexOf("\"") != -1) {
                                    curCompanyId = curCompanyId.replaceAll("\"", "");
                                }
                                if (StringUtils.isEmpty((String)curCompanyId) && adjustOrgUnit != null && adjustOrgUnit.isIsUnion() && stockControlCompany != null) {
                                    ((FunctionExpr)stmt).parameters.set(0, new StringExpr(stockControlCompany.getId().toString()));
                                    cell.setFormula("=" + stmt.toString());
                                    continue;
                                }
                            }
                            cell.setFormula("=" + templeEntryCollection.get(j).getDebitFormula());
                        } else {
                            cell = sheet.getCell(rowIndex, 0, true);
                            cell.setFormula(null);
                            cell.setValue(Variant.emptyVariant);
                        }
                        if (templeEntryCollection.get(j).getCreditFormula() != null) {
                            cell = sheet.getCell(rowIndex, 1, true);
                            stmt = ExcelFormulaPaserHelper.parse((String)templeEntryCollection.get(j).getCreditFormula());
                            if (stmt instanceof FunctionExpr && "ACCT".equals(((FunctionExpr)stmt).funcionName)) {
                                curCompanyId = ((FunctionExpr)stmt).parameters.get(0).toString();
                                if (curCompanyId != null && curCompanyId.indexOf("\"") != -1) {
                                    curCompanyId = curCompanyId.replaceAll("\"", "");
                                }
                                if (StringUtils.isEmpty((String)curCompanyId) && adjustOrgUnit != null && adjustOrgUnit.isIsUnion() && stockControlCompany != null) {
                                    ((FunctionExpr)stmt).parameters.set(0, new StringExpr(stockControlCompany.getId().toString()));
                                    cell.setFormula("=" + stmt.toString());
                                    continue;
                                }
                            }
                            cell.setFormula("=" + templeEntryCollection.get(j).getCreditFormula());
                        } else {
                            cell = sheet.getCell(rowIndex, 1, true);
                            cell.setFormula(null);
                            cell.setValue(Variant.emptyVariant);
                        }
                        ++rowIndex;
                    }
                }
                adjustCollection.add(adjustInfo);
            }
        }
        Object[][] values = this.getCalcValues(rowIndex);
        if (adjustCollection != null) {
            IAdjust iAdjust = AdjustFactory.getLocalInstance(ctx);
            rowIndex = 0;
            BigDecimal zero = new BigDecimal(0);
            for (int i = 0; i < adjustCollection.size(); ++i) {
                AdjustEntryCollection adjustEntryCollection = adjustCollection.get(i).getEntries();
                int entrySize = adjustEntryCollection.size();
                ArrayList<Integer> allEmptyEntryList = new ArrayList<Integer>();
                for (int k = 0; k < entrySize; ++k) {
                    if (values[rowIndex][0] instanceof Number) {
                        adjustCollection.get(i).getEntries().get(k).setDebit((BigDecimal)values[rowIndex][0]);
                    }
                    if (values[rowIndex][1] instanceof Number) {
                        adjustCollection.get(i).getEntries().get(k).setCredit((BigDecimal)values[rowIndex][1]);
                    }
                    if (adjustEntryCollection.get(k).getDebit() == null && adjustEntryCollection.get(k).getCredit() == null || adjustEntryCollection.get(k).getCredit() != null && adjustEntryCollection.get(k).getDebit() == null && adjustEntryCollection.get(k).getCredit().compareTo(zero) == 0 || adjustEntryCollection.get(k).getDebit() != null && adjustEntryCollection.get(k).getDebit().compareTo(zero) == 0 && adjustEntryCollection.get(k).getCredit() == null || adjustEntryCollection.get(k).getDebit() != null && adjustEntryCollection.get(k).getCredit() != null && adjustEntryCollection.get(k).getDebit().compareTo(zero) == 0 && adjustEntryCollection.get(k).getCredit().compareTo(zero) == 0) {
                        allEmptyEntryList.add(new Integer(k));
                    }
                    ++rowIndex;
                }
                if (allEmptyEntryList.size() == entrySize) continue;
                int delIndex = 0;
                for (int k = 0; k < allEmptyEntryList.size(); ++k) {
                    adjustEntryCollection.removeObject((Integer)allEmptyEntryList.get(k) - delIndex);
                    ++delIndex;
                }
                if (hasCodeRule) {
                    adjustCollection.get(i).setNumber(null);
                    adjustCollection.get(i).setNumber(iCodingRuleManager.getNumber((IObjectValue)adjustCollection.get(i), orgID));
                } else {
                    String tableName = "t_csl_adjust";
                    BigDecimal number = new BigDecimal("1");
                    StringBuffer ret = new StringBuffer("AUTO_");
                    StringBuffer sbSQL = new StringBuffer(" SELECT Replace(fnumber,'AUTO_','') As Fnumber From \r\n");
                    sbSQL.append(tableName).append(" a  \r\n");
                    sbSQL.append("\tWHERE a.fOrgBoundId = '").append(orgTreeID).append("' \r\n");
                    sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
                    sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
                    sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
                    sbSQL.append("  and a.fNumber like 'AUTO\\_%' ESCAPE '\\' \r\n");
                    try {
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
                        String tempNumber = "";
                        BigDecimal curNumber = new BigDecimal("1");
                        while (rowSet.next()) {
                            tempNumber = rowSet.getString("Fnumber");
                            if (StringUtils.isEmpty((String)tempNumber) || !tempNumber.matches("[0-9]{" + tempNumber.length() + "}") || number.compareTo(curNumber = new BigDecimal(tempNumber)) >= 0) continue;
                            number = curNumber;
                        }
                        if (number != null) {
                            number = number.add(new BigDecimal("1"));
                        }
                    }
                    catch (SQLException exc) {
                        throw new SQLDataException(exc);
                    }
                    int n = 8 - number.toString().length();
                    for (int k = 0; k < n; ++k) {
                        ret.append("0");
                    }
                    ret.append(number);
                    adjustCollection.get(i).setNumber(ret.toString());
                }
                IObjectPK pk = iAdjust.submit((CoreBaseInfo)adjustCollection.get(i));
                ids.add(pk);
            }
        }
        return ids;
    }

    private Sheet initBook(final Context ctx, final FullOrgUnitInfo fullOrgUnit, final FullOrgUnitInfo companyOrgUnit, final CurrencyInfo sourceCurrency, final CurrencyInfo currency, final int year, final int periodType, final int period, final OrgTreeInfo OrgBound) throws Exception {
        if (this.book == null) {
            this.book = Book.Manager.getNewBook((String)"Sheet1", (int)1);
            this.book.setCalculate(false);
        }
        Sheet sheet = this.book.getSheet(0);
        FormulaDefinition.registerFormulaToBook((Book)this.book, (ICalculateContextProvider)new ICalculateContextProvider(){
            private static final long serialVersionUID = 4558806141205673468L;

            public IErrorProvider getErrorProvider() {
                return null;
            }

            public IErrorResultProvider getErrorResultProvider() {
                return null;
            }

            public IReportPropertyAdapter getReportAdapter() {
                CslReportInfo cslReport = new CslReportInfo();
                cslReport.setOrgTree(OrgBound);
                cslReport.setOrgUnit(fullOrgUnit);
                cslReport.setCompany(companyOrgUnit);
                cslReport.setYear(year);
                cslReport.setPeriod((short)period);
                cslReport.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                cslReport.setSourceCurrency(sourceCurrency);
                cslReport.setCurrency(currency);
                CSLPropertyAdapter adapter = new CSLPropertyAdapter(cslReport, ctx);
                return adapter;
            }

            public ReportVariables getReportVariables() {
                return new ReportVariables();
            }

            public Context getServerContext() {
                return ctx;
            }
        });
        return sheet;
    }

    private Object[][] getCalcValues(int entrySize) {
        this.book.calc();
        Sheet sheet = this.book.getSheet(0);
        Cell cell = null;
        Object[][] values = new Object[entrySize][2];
        for (int i = 0; i < entrySize; ++i) {
            cell = sheet.getCell(i, 0, false);
            if (cell != null && cell.getValue() != null) {
                values[i][0] = cell.getValue().getValue();
            }
            if ((cell = sheet.getCell(i, 1, false)) == null || cell.getValue() == null) continue;
            values[i][1] = cell.getValue().getValue();
        }
        return values;
    }
}

