/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLAnlysisTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnalysisFilterParam;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisObjectCollection;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisObjectFactory;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisObjectInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.TrendAnlysisObjectEnum;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCSLReportAnlysisObjectControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateHelper;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CSLReportAnlysisObjectControllerBean
extends AbstractCSLReportAnlysisObjectControllerBean {
    private static final long serialVersionUID = -321441379110225135L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.CSLReportAnlysisObjectControllerBean");

    @Override
    protected Map _getYearAndPeriodMap(Context ctx, String reportId) throws BOSException, EASBizException {
        HashMap<Object, Object[]> result = new HashMap<Object, Object[]>();
        String templateGroupId = null;
        StringBuffer sb = new StringBuffer();
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        sb.append(" select a.fid, a.fgrouptemplateid  ");
        sb.append(" from t_rpt_template a , T_CSL_CslReport b ");
        sb.append(" where a.fid = b.ftemplateid and b.fid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{reportId});
        try {
            if (rs.next()) {
                templateGroupId = rs.getString(2);
                if (templateGroupId == null || templateGroupId.trim().length() == 0) {
                    sb1.append(" select distinct d.fitemformula,g.fyear,g.fperiod ");
                    sb1.append(" from T_CSL_CslReport b,T_RPT_Template c,T_CSL_TempletItemList d,t_csl_itemdata f, t_csl_itemdataentry g ");
                    sb1.append(" where b.ftemplateid = c.fid and c.fid = d.ftemplateid and b.fid = f.freportid and f.fid = g.fitemdataid and b.fid = ? ");
                    sb1.append(" order by d.fitemformula ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sb1.toString(), (Object[])new String[]{reportId});
                } else {
                    sb2.append(" select distinct d.fitemformula,g.fyear,g.fperiod ");
                    sb2.append(" from T_CSL_CslReport b,T_RPT_Template c,t_rpt_template h,T_CSL_TempletItemList d,t_csl_itemdata f,t_csl_itemdataentry g ");
                    sb2.append(" where b.ftemplateid = c.fid and c.fgrouptemplateid = h.fid and h.fid = d.ftemplateid and b.fid = f.freportid and f.fid = g.fitemdataid and c.fgrouptemplateid = ? and b.fid = ? ");
                    sb2.append(" order by d.fitemformula");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sb2.toString(), (Object[])new String[]{templateGroupId, reportId});
                }
            } else {
                return result;
            }
            while (rs.next()) {
                Object[] value = new Object[]{rs.getObject(2), rs.getObject(3)};
                result.put(rs.getObject(1), value);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte[] _getAnlysisBookData(Context ctx, String reportId, CSLReportAnalysisFilterParam param, boolean isGetReportData) throws BOSException, EASBizException {
        CSLAnlysisTypeEnum anlysisType = param.getAnalysisType();
        if (anlysisType == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"133_CSLReportAnlysisObjectControllerBean", (Locale)ctx.getOriginLocale()));
        }
        CSLReportAnlysisObjectInfo anlysisObjectInfo = null;
        byte[] data = null;
        Book book = null;
        if (anlysisType.getValue() == 1 || anlysisType.getValue() == 3) {
            if (isGetReportData) {
                data = this.getCSLReport(ctx, reportId).getData();
            } else {
                anlysisObjectInfo = this.getAnlysisObjectInfo(ctx, reportId, anlysisType);
                if (anlysisObjectInfo != null) return anlysisObjectInfo.getData();
                CslReportInfo reportInfo = this.getCSLReport(ctx, reportId);
                data = reportInfo.getData();
            }
        } else if (anlysisType.getValue() == 2) {
            String templateId = param.getTemplateId();
            TemplateInfo template = this.getCSLTemplate(ctx, templateId);
            data = template.getData();
        }
        try {
            book = IOHelper.unpackBook((byte[])data);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (book != null) {
            book.setCalculate(false);
        }
        if (anlysisType.getValue() == 1) {
            this.dealPerformBook(ctx, param, book);
        } else if (anlysisType.getValue() == 2) {
            this.dealTendencyBook(ctx, param, book);
        } else if (anlysisType.getValue() == 3) {
            this.dealLastPeriodBook(ctx, param, book);
        }
        try {
            return IOHelper.packBook((Book)book);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void dealLastPeriodBook(Context ctx, CSLReportAnalysisFilterParam param, Book book) throws EASBizException, BOSException {
        String RESORCE_LOCATION = "com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource";
        StyleAttributes cellSa = Styles.getEmptySA();
        cellSa.setNumberFormat("[>=0]#.00%;\"-\"#.00%");
        String budget = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"Budget", (Locale)ctx.getOriginLocale());
        String budgetLastPeriod = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"BudgetLastPeriod", (Locale)ctx.getOriginLocale());
        String budgetLastPeriodIncreate = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"BudgetLastPeriodIncreate", (Locale)ctx.getOriginLocale());
        String budgetLastPeriodIncreateRate = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"BudgetLastPeriodIncreateRate", (Locale)ctx.getOriginLocale());
        String actual = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"Actual", (Locale)ctx.getOriginLocale());
        String actualLastPeriod = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"ActualLastPeriod", (Locale)ctx.getOriginLocale());
        String actualLastPeriodIncreate = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"ActualLastPeriodIncreate", (Locale)ctx.getOriginLocale());
        String actualLastPeriodIncreateRate = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"ActualLastPeriodIncreateRate", (Locale)ctx.getOriginLocale());
        boolean isActual = param.getDataCollectNumber().equals("ACTUALDATA");
        String reportId = param.getReportId();
        Map analysisMap = this._getYearAndPeriodMap(ctx, reportId);
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = 0;
        int colCount = 0;
        this.clearFormula(book);
        String itemFormula = null;
        ReportVariables rptVariables = ReportVariables.loadFromBook((Book)book);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Cell cell;
            Sheet sheet = book.getSheet(i);
            int sheetType = rptVariables.getIntValue("SheetClass", sheet.getSheetName(), 1);
            if (sheetType == 30 || sheetType == 40 || sheetType == 10 || sheetType == 20) {
                book.removeSheet(sheet);
                --i;
                continue;
            }
            rowCount = sheet.getMaxRowIndex() + 1;
            colCount = sheet.getMaxColIndex() + 1;
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    Column column;
                    String[] formulaPara;
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    itemFormula = TemplateHelper.getItemFormula((Cell)cell);
                    if (itemFormula == null || (formulaPara = BgNFSHelper.parseFormulaPara(null, (String)itemFormula))[4].equalsIgnoreCase(ValueTypeEnum.TXT.getName()) || (column = sheet.getColumn(colIndex, false)) == null || column.getUserObjectValue("dataElement") != null && (column.getUserObjectValue("dataElement") == null || column.getUserObjectValue("dataElement").toString().equals(formulaPara[3]))) continue;
                    column.setUserObject("dataElement", (Object)formulaPara[3]);
                    this.addColumn(sheet, colIndex + 1);
                    this.addColumn(sheet, colIndex + 1);
                    this.addColumn(sheet, colIndex + 1);
                    Row row = null;
                    boolean isFind = false;
                    for (int j = rowIndex; j >= 0; --j) {
                        row = sheet.getRow(j, false);
                        if (row == null || row.getUserObjectValue("elementRow") == null) continue;
                        isFind = true;
                        break;
                    }
                    if (!isFind) {
                        row = this.addRow(sheet, rowIndex);
                        row.setUserObject("elementRow", (Object)"true");
                        ++rowIndex;
                    }
                    if (row != null) {
                        if (isActual) {
                            row.getCell(colIndex, true).setValue(new Variant((Object)actual));
                            row.getCell(colIndex + 1, true).setValue(new Variant((Object)actualLastPeriod));
                            row.getCell(colIndex + 2, true).setValue(new Variant((Object)actualLastPeriodIncreate));
                            row.getCell(colIndex + 3, true).setValue(new Variant((Object)actualLastPeriodIncreateRate));
                        } else {
                            row.getCell(colIndex, true).setValue(new Variant((Object)budget));
                            row.getCell(colIndex + 1, true).setValue(new Variant((Object)budgetLastPeriod));
                            row.getCell(colIndex + 2, true).setValue(new Variant((Object)budgetLastPeriodIncreate));
                            row.getCell(colIndex + 3, true).setValue(new Variant((Object)budgetLastPeriodIncreateRate));
                        }
                    }
                    colCount = sheet.getMaxColIndex() + 1;
                    rowCount = sheet.getMaxRowIndex() + 1;
                    colIndex += 3;
                }
            }
            rowCount = sheet.getMaxRowIndex() + 1;
            colCount = sheet.getMaxColIndex() + 1;
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    String[] formula;
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    itemFormula = TemplateHelper.getItemFormula((Cell)cell);
                    if (itemFormula == null || (formula = this.convertToLastPeriodFormula(itemFormula, param, analysisMap)) == null) continue;
                    String a1 = formula[0].substring(1);
                    String a2 = formula[1].substring(1);
                    sheet.getCell(rowIndex, colIndex, true).setUserObject("formula", (Object)formula[0]);
                    sheet.getCell(rowIndex, colIndex + 1, true).setUserObject("formula", (Object)formula[1]);
                    sheet.getCell(rowIndex, colIndex + 2, true).setUserObject("formula", (Object)("=" + a1 + "-" + a2));
                    sheet.getCell(rowIndex, colIndex + 3, true).setUserObject("formula", (Object)("= (" + a1 + "-" + a2 + ")/" + a2));
                    sheet.getRange(sheet.getCell(rowIndex, colIndex + 3, true)).setStyle(cellSa, Styles.getEmptySA());
                }
            }
        }
        this.caclAndFillData(ctx, book);
        this.lockBook(book, true);
    }

    private void dealTendencyBook(Context ctx, CSLReportAnalysisFilterParam param, Book book) throws EASBizException, BOSException {
        String RESORCE_LOCATION = "com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource";
        StyleAttributes cellSa = Styles.getEmptySA();
        cellSa.setNumberFormat("[>=0]#.00%;\"-\"#.00%");
        StyleAttributes cellSa1 = Styles.getEmptySA();
        cellSa1.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        List orgNumberList = param.getOrgNumberList();
        TrendAnlysisObjectEnum[] trendAnlysisObject = param.getTrendAnlysisObject();
        int trendAnlysisObjectSize = trendAnlysisObject.length;
        int beginYear = param.getBeginYear();
        int beginPeriod = param.getBeginPeriod();
        int endYear = param.getEndYear();
        int endPeiod = param.getEndPeriod();
        String yearStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"Year", (Locale)ctx.getOriginLocale());
        String seasonStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"Season", (Locale)ctx.getOriginLocale());
        String periodStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"Month", (Locale)ctx.getOriginLocale());
        String firstTitle = beginYear + yearStr;
        if (param.getPeriodType().getValue() == 3) {
            firstTitle = beginYear + yearStr + beginPeriod + periodStr;
        } else if (param.getPeriodType().getValue() == 4) {
            firstTitle = beginYear + yearStr + beginPeriod + seasonStr;
        }
        String firstYearAndPeriod = beginYear + ":" + beginPeriod;
        ArrayList<String> leaveTitleList = new ArrayList<String>();
        ArrayList<String> leaveYearAndPeriodist = new ArrayList<String>();
        int totalCount = 0;
        for (int i = beginYear; i <= endYear; ++i) {
            int count = 0;
            if (param.getPeriodType().getValue() == 3 || param.getPeriodType().getValue() == 4) {
                int j;
                String sharePeriodStr;
                int sharePeriods = param.getPeriodType().getValue() == 3 ? 12 : 4;
                String string = sharePeriodStr = param.getPeriodType().getValue() == 3 ? periodStr : seasonStr;
                if (i == beginYear && i < endYear) {
                    if ((count += sharePeriods - beginPeriod) == 0) continue;
                    for (j = beginPeriod + 1; j <= sharePeriods; ++j) {
                        leaveTitleList.add(i + yearStr + j + sharePeriodStr);
                        leaveYearAndPeriodist.add(i + ":" + j);
                        ++totalCount;
                    }
                    continue;
                }
                if (i == beginYear && i == endYear) {
                    if ((count = count + endPeiod - beginPeriod) == 0) continue;
                    for (j = beginPeriod + 1; j <= endPeiod; ++j) {
                        leaveTitleList.add(i + yearStr + j + sharePeriodStr);
                        leaveYearAndPeriodist.add(i + ":" + j);
                        ++totalCount;
                    }
                    continue;
                }
                if (i > beginYear && i < endYear) {
                    count += sharePeriods;
                    for (j = 1; j <= sharePeriods; ++j) {
                        leaveTitleList.add(i + yearStr + j + sharePeriodStr);
                        leaveYearAndPeriodist.add(i + ":" + j);
                        ++totalCount;
                    }
                    continue;
                }
                if (i <= beginYear || i != endYear) continue;
                count += endPeiod;
                for (j = 1; j <= endPeiod; ++j) {
                    leaveTitleList.add(i + yearStr + j + sharePeriodStr);
                    leaveYearAndPeriodist.add(i + ":" + j);
                    ++totalCount;
                }
                continue;
            }
            if (param.getPeriodType().getValue() != 6 || (count = endYear - beginYear) == 0) continue;
            for (int j = beginYear + 1; j <= endYear; ++j) {
                leaveTitleList.add(j + yearStr);
                leaveYearAndPeriodist.add(j + ":1");
                ++totalCount;
            }
        }
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = 0;
        int colCount = 0;
        String dataCollectName = DataCollectConstant.getActualDC().getName();
        if (param.getDataCollectNumber().equals("BUDGETDATA")) {
            dataCollectName = DataCollectConstant.getBudgetDC().getName();
        }
        this.clearFormula(book);
        String anlysisCol = param.getAnlysisCol();
        Map sheetAnlysisColmap = this.getColPosKeyMap(anlysisCol);
        String titleCol = param.getTitleCol();
        Map sheetTitleColmap = new HashMap();
        if (titleCol != null && titleCol.trim().length() > 0) {
            sheetTitleColmap = this.getColPosKeyMap(titleCol);
        }
        this.clearValue(book, sheetAnlysisColmap, sheetTitleColmap);
        String itemFormula = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String sheetName = sheet.getSheetName();
            if (!sheetAnlysisColmap.containsKey(sheetName)) continue;
            HashMap colPosMap = new HashMap();
            String[] strs = (String[])sheetAnlysisColmap.get(sheetName);
            for (int j = 0; j < strs.length; ++j) {
                colPosMap.put(strs[j], null);
            }
            rowCount = sheet.getMaxRowIndex() + 1;
            colCount = sheet.getMaxColIndex() + 1;
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                if (!colPosMap.containsKey(TableToolkit.int2pos((int)colIndex)) || sheet.getColumn(colIndex, false) == null) continue;
                sheet.getColumn(colIndex, false).setUserObject("main", (Object)"true");
            }
            Column orgCol = this.addColumn(sheet, 0);
            Row titleRow = null;
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                if (sheet.getColumn(colIndex, false) != null && sheet.getColumn(colIndex, false).getUserObjectValue("main") != null && sheet.getColumn(colIndex, false).getUserObjectValue("main").equals("true")) {
                    for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        Cell cell = sheet.getCell(rowIndex, colIndex, false);
                        itemFormula = TemplateHelper.getItemFormula((Cell)cell);
                        if (itemFormula == null) continue;
                        if (titleRow == null) {
                            int curRow = rowIndex == 0 ? rowIndex : rowIndex - 1;
                            titleRow = this.addRow(sheet, curRow);
                        }
                        titleRow.getCell(colIndex, true).setValue(new Variant((Object)firstTitle));
                        rowCount = sheet.getMaxRowIndex() + 1;
                        int tmp1 = colIndex + 1;
                        for (int a1 = 0; a1 < totalCount; ++a1) {
                            this.addColumn(sheet, tmp1);
                            titleRow.getCell(tmp1, true).setValue(new Variant(leaveTitleList.get(a1)));
                            for (int b1 = 0; b1 < trendAnlysisObjectSize; ++b1) {
                                this.addColumn(sheet, ++tmp1);
                                titleRow.getCell(tmp1, true).setValue(new Variant((Object)((Object)((Object)trendAnlysisObject[b1]) + "(" + dataCollectName + ")")));
                            }
                            ++tmp1;
                        }
                        break;
                    }
                }
                colCount = sheet.getMaxColIndex() + 1;
            }
            rowCount = sheet.getMaxRowIndex() + 1;
            colCount = sheet.getMaxColIndex() + 1;
            boolean isAddRow = false;
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                if (sheet.getColumn(colIndex, false) == null || sheet.getColumn(colIndex, false).getUserObjectValue("main") == null || !sheet.getColumn(colIndex, false).getUserObjectValue("main").equals("true")) continue;
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    itemFormula = TemplateHelper.getItemFormula((Cell)cell);
                    if (itemFormula != null) {
                        int tmpRowIndex = rowIndex;
                        for (int c1 = 0; c1 < orgNumberList.size(); ++c1) {
                            String[] tmps = firstYearAndPeriod.split(":");
                            String formula = this.convertToFormula(itemFormula, param, (String)orgNumberList.get(c1), tmps[0], tmps[1]);
                            if (c1 != 0) {
                                ++tmpRowIndex;
                                if (!isAddRow) {
                                    this.addRow(sheet, tmpRowIndex);
                                }
                            }
                            sheet.getCell(tmpRowIndex, orgCol.getCol(), true).setUserObject("orgNumber", orgNumberList.get(c1));
                            sheet.getRange(sheet.getCell(tmpRowIndex, orgCol.getCol(), true)).setStyle(cellSa1, Styles.getEmptySA());
                            sheet.getCell(tmpRowIndex, colIndex, true).setUserObject("formula", (Object)formula);
                            String x1 = formula.substring(1);
                            int tmp1 = colIndex + 1;
                            for (int a1 = 0; a1 < totalCount; ++a1) {
                                tmps = ((String)leaveYearAndPeriodist.get(a1)).split(":");
                                formula = this.convertToFormula(itemFormula, param, (String)orgNumberList.get(c1), tmps[0], tmps[1]);
                                sheet.getCell(tmpRowIndex, tmp1, true).setUserObject("formula", (Object)formula);
                                String x2 = formula.substring(1);
                                for (int b1 = 0; b1 < trendAnlysisObjectSize; ++b1) {
                                    ++tmp1;
                                    if (trendAnlysisObject[b1].getValue() == 1) {
                                        sheet.getCell(tmpRowIndex, tmp1, true).setUserObject("formula", (Object)("=" + x2 + "-" + x1));
                                        continue;
                                    }
                                    if (trendAnlysisObject[b1].getValue() == 2) {
                                        sheet.getCell(tmpRowIndex, tmp1, true).setUserObject("formula", (Object)("=(" + x2 + "-" + x1 + ")/" + x1));
                                        sheet.getRange(sheet.getCell(tmpRowIndex, tmp1, true)).setStyle(cellSa, Styles.getEmptySA());
                                        continue;
                                    }
                                    if (trendAnlysisObject[b1].getValue() == 3) {
                                        sheet.getCell(tmpRowIndex, tmp1, true).setUserObject("formula", (Object)("=" + x2 + "-" + x1));
                                        continue;
                                    }
                                    if (trendAnlysisObject[b1].getValue() != 4) continue;
                                    sheet.getCell(tmpRowIndex, tmp1, true).setUserObject("formula", (Object)("=(" + x2 + "-" + x1 + ")/" + x1));
                                    sheet.getRange(sheet.getCell(tmpRowIndex, tmp1, true)).setStyle(cellSa, Styles.getEmptySA());
                                }
                                if (trendAnlysisObject[0].getValue() == 3 || trendAnlysisObject[0].getValue() == 4) {
                                    x1 = x2;
                                }
                                ++tmp1;
                            }
                        }
                    }
                    rowCount = sheet.getMaxRowIndex() + 1;
                }
                isAddRow = true;
            }
        }
        this.caclAndFillData(ctx, book);
        this.lockBook(book, true);
    }

    private Map getColPosKeyMap(String anlysisCol) {
        HashMap<String, String[]> sheetColmap = new HashMap<String, String[]>();
        String[] tmp4 = anlysisCol.split(";");
        for (int j = 0; j < tmp4.length; ++j) {
            String[] tmp = tmp4[j].split("\\(");
            String sheetName = tmp[0];
            String[] tmp1 = tmp[1].split("\\)");
            String[] tmp3 = tmp1[0].split(",");
            sheetColmap.put(sheetName, tmp3);
        }
        return sheetColmap;
    }

    private void dealPerformBook(Context ctx, CSLReportAnalysisFilterParam param, Book book) throws BOSException, EASBizException {
        String RESORCE_LOCATION = "com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource";
        StyleAttributes cellSa = Styles.getEmptySA();
        cellSa.setNumberFormat("[>=0]#.00%;\"-\"#.00%");
        String budget = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"Budget", (Locale)ctx.getOriginLocale());
        String actual = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"Actual", (Locale)ctx.getOriginLocale());
        String performDiff = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"PerformDiff", (Locale)ctx.getOriginLocale());
        String performDiffPercent = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"PerformDiffPercent", (Locale)ctx.getOriginLocale());
        String allYearBudget = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"AllYearBudget", (Locale)ctx.getOriginLocale());
        String allYearBudgetPerformPercent = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"AllYearBudgetPerformPercent", (Locale)ctx.getOriginLocale());
        String reportId = param.getReportId();
        Map analysisMap = this._getYearAndPeriodMap(ctx, reportId);
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = 0;
        int colCount = 0;
        this.clearFormula(book);
        String itemFormula = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Cell cell;
            Sheet sheet = book.getSheet(i);
            rowCount = sheet.getMaxRowIndex() + 1;
            colCount = sheet.getMaxColIndex() + 1;
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    Column column;
                    String[] formulaPara;
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    itemFormula = TemplateHelper.getItemFormula((Cell)cell);
                    if (itemFormula == null || (formulaPara = BgNFSHelper.parseFormulaPara(null, (String)itemFormula))[4].equalsIgnoreCase(ValueTypeEnum.TXT.getName()) || (column = sheet.getColumn(colIndex, false)) == null || column.getUserObjectValue("dataElement") != null && (column.getUserObjectValue("dataElement") == null || column.getUserObjectValue("dataElement").toString().equals(formulaPara[3]))) continue;
                    column.setUserObject("dataElement", (Object)formulaPara[3]);
                    this.addColumn(sheet, colIndex + 1);
                    this.addColumn(sheet, colIndex + 1);
                    this.addColumn(sheet, colIndex + 1);
                    this.addColumn(sheet, colIndex + 1);
                    this.addColumn(sheet, colIndex + 1);
                    Row row = null;
                    boolean isFind = false;
                    for (int j = rowIndex; j >= 0; --j) {
                        row = sheet.getRow(j, false);
                        if (row == null || row.getUserObjectValue("elementRow") == null) continue;
                        isFind = true;
                        break;
                    }
                    if (!isFind) {
                        row = this.addRow(sheet, rowIndex);
                        row.setUserObject("elementRow", (Object)"true");
                        ++rowIndex;
                    }
                    if (row != null) {
                        row.getCell(colIndex, true).setValue(new Variant((Object)budget));
                        row.getCell(colIndex + 1, true).setValue(new Variant((Object)actual));
                        row.getCell(colIndex + 2, true).setValue(new Variant((Object)performDiff));
                        row.getCell(colIndex + 3, true).setValue(new Variant((Object)performDiffPercent));
                        row.getCell(colIndex + 4, true).setValue(new Variant((Object)allYearBudget));
                        row.getCell(colIndex + 5, true).setValue(new Variant((Object)allYearBudgetPerformPercent));
                    }
                    colCount = sheet.getMaxColIndex() + 1;
                    rowCount = sheet.getMaxRowIndex() + 1;
                    colIndex += 5;
                }
            }
            rowCount = sheet.getMaxRowIndex() + 1;
            colCount = sheet.getMaxColIndex() + 1;
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    String[] formula;
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    itemFormula = TemplateHelper.getItemFormula((Cell)cell);
                    if (itemFormula == null || (formula = this.convertToFormula(ctx, itemFormula, param, analysisMap)) == null) continue;
                    String a1 = formula[0].substring(1);
                    String a2 = formula[1].substring(1);
                    sheet.getCell(rowIndex, colIndex, true).setUserObject("formula", (Object)formula[0]);
                    sheet.getCell(rowIndex, colIndex + 1, true).setUserObject("formula", (Object)formula[1]);
                    sheet.getCell(rowIndex, colIndex + 2, true).setUserObject("formula", (Object)("=" + a1 + "-" + a2));
                    sheet.getCell(rowIndex, colIndex + 3, true).setUserObject("formula", (Object)("= (" + a1 + "-" + a2 + ")/" + a1));
                    sheet.getCell(rowIndex, colIndex + 4, true).setUserObject("formula", (Object)formula[2]);
                    sheet.getCell(rowIndex, colIndex + 5, true).setUserObject("formula", (Object)"=");
                    sheet.getRange(sheet.getCell(rowIndex, colIndex + 3, true)).setStyle(cellSa, Styles.getEmptySA());
                    sheet.getRange(sheet.getCell(rowIndex, colIndex + 5, true)).setStyle(cellSa, Styles.getEmptySA());
                }
            }
        }
        this.caclAndFillData(ctx, book);
        this.lockBook(book, true);
    }

    public Column addColumn(Sheet sheet, int colIndex) {
        if (sheet == null || colIndex < 0 || colIndex > sheet.getMaxColIndex() + 1) {
            return null;
        }
        Range range = sheet.getColRange(colIndex, colIndex);
        range.setIgnoreProtected(true);
        range.insert(false, InsertType.FLLOW_UP_STYLE);
        for (int i = 0; i <= sheet.getMaxRowIndex() && colIndex > 0; ++i) {
            sheet.getCell(i, colIndex, true).setSSA(sheet.getCell(i, colIndex - 1, true).getSSA());
        }
        return sheet.getColumn(colIndex, true);
    }

    public Row addRow(Sheet sheet, int rowIndex) {
        if (sheet == null || rowIndex < 0 || rowIndex > sheet.getMaxRowIndex() + 1) {
            return null;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex);
        range.setIgnoreProtected(true);
        range.insert(true, InsertType.FLLOW_UP_STYLE);
        for (int i = 0; i <= sheet.getMaxColIndex() && rowIndex > 0; ++i) {
            sheet.getCell(rowIndex, i, true).setSSA(sheet.getCell(rowIndex - 1, i, true).getSSA());
        }
        return sheet.getRow(rowIndex, true);
    }

    private void lockBook(Book book, boolean isLocked) {
        BgNFSHelper.setBookLANDP((Book)book, (boolean)isLocked, (List)BgNFSHelper.getBookOperation(), (List)BgNFSHelper.getMaxOperation());
        CSLReportAnlysisObjectControllerBean.setAllCellLocked(book, isLocked);
    }

    public static void setAllCellLocked(Book book, boolean isLocked) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(isLocked);
            Range range = null;
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null) continue;
                    if (isLocked) {
                        if (_cell.isLocked() || _cell == null) continue;
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (!_cell.isLocked() || _cell == null) continue;
                    if (range == null) {
                        range = _cell.getSheet().getRange(_cell);
                        continue;
                    }
                    range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                }
            }
            if (range == null) continue;
            range.setIgnoreProtected(true);
            range.setStyle(sa, Styles.getEmptySA());
        }
    }

    private void caclAndFillData(Context ctx, Book book) throws BOSException, EASBizException {
        int rowIndex;
        int colIndex;
        int rowCount;
        int colCount;
        ArrayList<String> formulaList = new ArrayList<String>();
        String itemFormula = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            colCount = sheet.getMaxColIndex() + 1;
            rowCount = sheet.getMaxRowIndex() + 1;
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell != null && cell.getUserObjectValue("formula") != null) {
                        formulaList.add(cell.getUserObjectValue("formula").toString());
                    }
                    if ((itemFormula = TemplateHelper.getItemFormula((Cell)cell)) == null) continue;
                    cell.removeUserObject("ITEM");
                }
            }
        }
        Variant[] caclResult = ReportFactory.getLocalInstance((Context)ctx).calcFormulas(formulaList);
        int index = 0;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            colCount = sheet.getMaxColIndex() + 1;
            rowCount = sheet.getMaxRowIndex() + 1;
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null || cell.getUserObjectValue("formula") == null) continue;
                    cell.setValue(caclResult[index++]);
                }
            }
        }
    }

    private void clearFormula(Book book) {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!TemplateHelper.checkHasExpression((Cell)cell)) continue;
                    cell.setFormula(null);
                    cell.setValue(new Variant((Object)""));
                }
            }
        }
    }

    private void clearValue(Book book, Map sheetAnlysisColmap, Map sheetTitleColmap) {
        Variant nullVariant = new Variant((Object)"");
        for (int i = 0; i < book.getSheetCount(); ++i) {
            int rowIndex;
            int colIndex;
            int colCount;
            int rowCount;
            Sheet sheet = book.getSheet(i);
            String sheetName = sheet.getSheetName();
            if (sheetAnlysisColmap.containsKey(sheetName) || sheetTitleColmap.containsKey(sheetName)) {
                HashMap anyColPosMap = new HashMap();
                String[] strs = (String[])sheetAnlysisColmap.get(sheetName);
                for (int j = 0; strs != null && j < strs.length; ++j) {
                    anyColPosMap.put(strs[j], null);
                }
                HashMap titleColPosMap = new HashMap();
                String[] strs1 = (String[])sheetTitleColmap.get(sheetName);
                for (int j = 0; strs1 != null && j < strs1.length; ++j) {
                    titleColPosMap.put(strs1[j], null);
                }
                rowCount = sheet.getMaxRowIndex() + 1;
                colCount = sheet.getMaxColIndex() + 1;
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    if (anyColPosMap.containsKey(TableToolkit.int2pos((int)colIndex)) || titleColPosMap.containsKey(TableToolkit.int2pos((int)colIndex))) continue;
                    for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        Cell cell = sheet.getCell(rowIndex, colIndex, false);
                        if (cell == null) continue;
                        cell.setValue(nullVariant);
                    }
                }
            } else {
                rowCount = sheet.getMaxRowIndex() + 1;
                colCount = sheet.getMaxColIndex() + 1;
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex < colCount; ++colIndex) {
                        Cell cell = sheet.getCell(rowIndex, colIndex, false);
                        if (cell == null) continue;
                        cell.setValue(nullVariant);
                    }
                }
            }
            rowCount = sheet.getMaxRowIndex() + 1;
            colCount = sheet.getMaxColIndex() + 1;
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                Range range;
                boolean isColumnAllValueNull = true;
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null || cell.getValue().equals(nullVariant)) continue;
                    isColumnAllValueNull = false;
                    break;
                }
                if (!isColumnAllValueNull || (range = sheet.getColRange(colIndex, colIndex)) == null) continue;
                range.setColumnHidden(true);
            }
        }
    }

    private String[] convertToFormula(Context ctx, String itemFormula, CSLReportAnalysisFilterParam filter1Params, Map analysisMap) throws EASBizException, BOSException {
        String[] formulaPara = BgNFSHelper.parseFormulaPara(null, (String)itemFormula);
        if (formulaPara[4].equalsIgnoreCase(ValueTypeEnum.TXT.getName())) {
            return null;
        }
        if (!analysisMap.containsKey(itemFormula)) {
            return null;
        }
        Object[] value = (Object[])analysisMap.get(itemFormula);
        String orgTreeNumber = filter1Params.getOrgTreeNumber();
        String companyNumber = filter1Params.getOrgUnitNumber();
        String sourceCurrencyNumber = filter1Params.getSourceCurrencyNumber();
        String convertCurrencyNumber = filter1Params.getConvertCurrencyNumber();
        String itemNumberFrom = formulaPara[0];
        String itemNumberTo = formulaPara[0];
        String periodType = filter1Params.getPeriodType().getName();
        String year = value[0].toString();
        String beginPeriod = value[1].toString();
        String endPeriod = value[1].toString();
        String sourceType = filter1Params.getSourceType();
        String dataElement = formulaPara[3];
        String valueType = formulaPara[4];
        String isGetAfetrAdjust = "true";
        if (sourceType.equals(RptSrcTypeEnum.COMMITREPORT.getName())) {
            isGetAfetrAdjust = "false";
        }
        String formula1 = "=AcctItem(\"" + orgTreeNumber + "\",\"" + companyNumber + "\",\"" + sourceCurrencyNumber + "\",\"" + convertCurrencyNumber + "\",\"" + itemNumberFrom + "\",\"" + itemNumberTo + "\",\"" + periodType + "\"," + year + "," + beginPeriod + "," + endPeriod + ",\"" + sourceType + "\",\"" + dataElement + "\",\"" + valueType + "\"," + isGetAfetrAdjust + ",false,\"" + "BUDGETDATA" + "\",true)";
        String formula2 = "=AcctItem(\"" + orgTreeNumber + "\",\"" + companyNumber + "\",\"" + sourceCurrencyNumber + "\",\"" + convertCurrencyNumber + "\",\"" + itemNumberFrom + "\",\"" + itemNumberTo + "\",\"" + periodType + "\"," + year + "," + beginPeriod + "," + endPeriod + ",\"" + sourceType + "\",\"" + dataElement + "\",\"" + valueType + "\"," + isGetAfetrAdjust + ",false,\"" + "ACTUALDATA" + "\",true)";
        String formula3 = "=AcctItem(\"" + orgTreeNumber + "\",\"" + companyNumber + "\",\"" + sourceCurrencyNumber + "\",\"" + convertCurrencyNumber + "\",\"" + itemNumberFrom + "\",\"" + itemNumberTo + "\",\"" + periodType + "\"," + year + "," + 12 + "," + 12 + ",\"" + sourceType + "\",\"" + this.getYTDAMOUNTDataElement(ctx) + "\",\"" + valueType + "\"," + isGetAfetrAdjust + ",false,\"" + "BUDGETDATA" + "\",true)";
        return new String[]{formula1, formula2, formula3};
    }

    private String[] convertToLastPeriodFormula(String itemFormula, CSLReportAnalysisFilterParam param, Map analysisMap) {
        String[] formulaPara = BgNFSHelper.parseFormulaPara(null, (String)itemFormula);
        if (formulaPara[4].equalsIgnoreCase(ValueTypeEnum.TXT.getName())) {
            return null;
        }
        if (!analysisMap.containsKey(itemFormula)) {
            return null;
        }
        String dataCollectNumber = param.getDataCollectNumber();
        Object[] value = (Object[])analysisMap.get(itemFormula);
        String orgTreeNumber = param.getOrgTreeNumber();
        String companyNumber = param.getOrgUnitNumber();
        String sourceCurrencyNumber = param.getSourceCurrencyNumber();
        String convertCurrencyNumber = param.getConvertCurrencyNumber();
        String itemNumberFrom = formulaPara[0];
        String itemNumberTo = formulaPara[0];
        String periodType = param.getPeriodType().getName();
        String year1 = value[0].toString();
        String year2 = String.valueOf(Integer.parseInt(value[0].toString()) - 1);
        String beginPeriod = value[1].toString();
        String endPeriod = value[1].toString();
        String sourceType = param.getSourceType();
        String dataElement = formulaPara[3];
        String valueType = formulaPara[4];
        String isGetAfetrAdjust = "true";
        if (sourceType.equals(RptSrcTypeEnum.COMMITREPORT.getName())) {
            isGetAfetrAdjust = "false";
        }
        String formula1 = "=AcctItem(\"" + orgTreeNumber + "\",\"" + companyNumber + "\",\"" + sourceCurrencyNumber + "\",\"" + convertCurrencyNumber + "\",\"" + itemNumberFrom + "\",\"" + itemNumberTo + "\",\"" + periodType + "\"," + year1 + "," + beginPeriod + "," + endPeriod + ",\"" + sourceType + "\",\"" + dataElement + "\",\"" + valueType + "\"," + isGetAfetrAdjust + ",false,\"" + dataCollectNumber + "\",false)";
        String formula2 = "=AcctItem(\"" + orgTreeNumber + "\",\"" + companyNumber + "\",\"" + sourceCurrencyNumber + "\",\"" + convertCurrencyNumber + "\",\"" + itemNumberFrom + "\",\"" + itemNumberTo + "\",\"" + periodType + "\"," + year2 + "," + beginPeriod + "," + endPeriod + ",\"" + sourceType + "\",\"" + dataElement + "\",\"" + valueType + "\"," + isGetAfetrAdjust + ",false,\"" + dataCollectNumber + "\",false)";
        return new String[]{formula1, formula2};
    }

    private String convertToFormula(String itemFormula, CSLReportAnalysisFilterParam param, String companyNumber, String year, String period) {
        String[] formulaPara = BgNFSHelper.parseFormulaPara(null, (String)itemFormula);
        if (formulaPara[4].equalsIgnoreCase(ValueTypeEnum.TXT.getName())) {
            return null;
        }
        String orgTreeNumber = param.getOrgTreeNumber();
        String sourceCurrencyNumber = param.getSourceCurrencyNumber();
        String convertCurrencyNumber = param.getConvertCurrencyNumber();
        String itemNumberFrom = formulaPara[0];
        String itemNumberTo = formulaPara[0];
        String periodType = param.getPeriodType().getName();
        String sourceType = (String)param.getSourceTypeMap().get(companyNumber);
        String dataElement = formulaPara[3];
        String valueType = formulaPara[4];
        String dataCollectNumber = param.getDataCollectNumber();
        String isGetAfetrAdjust = "true";
        String formula = "=AcctItem(\"" + orgTreeNumber + "\",\"" + companyNumber + "\",\"" + sourceCurrencyNumber + "\",\"" + convertCurrencyNumber + "\",\"" + itemNumberFrom + "\",\"" + itemNumberTo + "\",\"" + periodType + "\"," + year + "," + period + "," + period + ",\"" + sourceType + "\",\"" + dataElement + "\",\"" + valueType + "\"," + isGetAfetrAdjust + ",false,\"" + dataCollectNumber + "\",false)";
        return formula;
    }

    private CSLReportAnlysisObjectInfo getAnlysisObjectInfo(Context ctx, String reportId, CSLAnlysisTypeEnum anlysisType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cslReportID", (Object)reportId));
        filter.getFilterItems().add(new FilterItemInfo("analysisType", (Object)new Integer(anlysisType.getValue())));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("data"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        CSLReportAnlysisObjectInfo anlysisObjectInfo = null;
        CSLReportAnlysisObjectCollection coll = CSLReportAnlysisObjectFactory.getLocalInstance(ctx).getCSLReportAnlysisObjectCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            anlysisObjectInfo = coll.get(0);
        }
        return anlysisObjectInfo;
    }

    private CslReportInfo getCSLReport(Context ctx, String reportId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)reportId));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("data"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        CslReportInfo reportInfo = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(viewInfo).get(0);
        return reportInfo;
    }

    private TemplateInfo getCSLTemplate(Context ctx, String templateId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)templateId));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("data"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        TemplateInfo template = TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(viewInfo).get(0);
        return template;
    }

    @Override
    protected IObjectPK _saveAnlysisObject(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        CSLReportAnlysisObjectInfo anlysisInfo = (CSLReportAnlysisObjectInfo)info;
        if (anlysisInfo.getCslReportID() == null || anlysisInfo.getAnalysisType() == null) {
            throw new CSLReportAnlysisException(CSLReportAnlysisException.CAN_NOT_SAVE);
        }
        String sql = " delete from T_CSL_CSLReportAnlysisObject where fcslreportId = ? and FAnalysisType = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{anlysisInfo.getCslReportID().toString(), new Integer(anlysisInfo.getAnalysisType().getValue())});
        sql = " select fname from t_csl_cslreport where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{anlysisInfo.getCslReportID().toString()});
        try {
            if (!rs.next()) {
                throw new CSLReportAnlysisException(CSLReportAnlysisException.REPORT_NOT_EXIST);
            }
            anlysisInfo.setName(rs.getString(1));
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        IObjectPK pk = this._addnew(ctx, (IObjectValue)anlysisInfo);
        return pk;
    }

    @Override
    protected Set _getOrgsInTree(Context ctx, String treeID, String upOrgLongnumber, boolean isIncludeDown) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        IRowSet rs = null;
        String sql = "select a.FUnitId from t_org_structure a , t_org_tree b where a.ftreeId = b.fid ";
        if (isIncludeDown) {
            sql = sql + " and b.fid = ? and ( a.flongnumber = ? or a.flongnumber like ? )";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{treeID, upOrgLongnumber, upOrgLongnumber + "!%"});
        } else {
            sql = sql + " and b.fid = ? and a.flongnumber = ? ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{treeID, upOrgLongnumber});
        }
        try {
            while (rs != null && rs.next()) {
                idSet.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return idSet;
    }

    @Override
    protected String _getSameRootOrg(Context ctx, List idList, String treeID) throws BOSException, EASBizException {
        String ids = "(''";
        for (int i = 0; i < idList.size(); ++i) {
            ids = ids + " , '" + idList.get(i) + "'";
        }
        ids = ids + " ) ";
        String sql = " select a.flongnumber from t_org_structure a ,t_org_tree b  where a.ftreeid = b.fid and a.ftreeid = '" + treeID + "' and a.funitid in " + ids + " order by a.flevel ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String[]> tmp = new ArrayList<String[]>();
        try {
            int i;
            while (rs.next()) {
                tmp.add(rs.getString(1).split("!"));
            }
            int index = 0;
            String[] base = (String[])tmp.get(0);
            boolean second = true;
            while (second) {
                String target = null;
                for (i = 1; i < tmp.size(); ++i) {
                    String[] strs = (String[])tmp.get(i);
                    if (index < base.length) {
                        target = base[index];
                    } else {
                        second = false;
                    }
                    if (!second) continue;
                    if (index < strs.length) {
                        if (target == null || target.equals(strs[index]) || index <= 0) continue;
                        second = false;
                        continue;
                    }
                    second = false;
                }
                ++index;
            }
            String longNumber = "";
            for (i = 0; i <= index - 2; ++i) {
                longNumber = longNumber + base[i] + "!";
            }
            if (longNumber.trim().length() > 0) {
                longNumber = longNumber.substring(0, longNumber.length() - 1);
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select a.funitid from t_org_structure a ,t_org_tree b  where a.ftreeid = b.fid and a.flongnumber = ? and b.fid = ?"), (Object[])new Object[]{longNumber, treeID})).next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException e) {
            logger.equals(e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected IObjectCollection _getCSLTemplates(Context ctx, String treeId, List orgIDList) throws BOSException, EASBizException {
        TemplateCollection coll = new TemplateCollection();
        String sql = " SELECT  distinct  TEMPLATE.FID AS ID, TEMPLATE.FNumber AS NUMBER1,  TEMPLATE.FName AS NAME,  TEMPLATE.FTemplateType AS TEMPLATETYPE,  TEMPLATE.FPeriodType AS PERIODTYPE,  TEMPLATE.FDynaRptType AS DYNARPTTYPE,  TEMPLATE.FAuditedStatus AS AUDITEDSTATUS,  AUDITOR.FName_" + ctx.getLocale() + " AS AUDITORNAME,  AUDITOR.FID AS AUDITORID,  TEMPLATE.FAuditedTime AS AUDITEDTIME,  CREATOR.FName_" + ctx.getLocale() + " AS CREATORNAME,  CREATOR.FID AS CREATORID,  TEMPLATE.FCreateTime AS CREATETIME,  TEMPLATE.FLastUpdateTime AS LASTUPDATETIME,  TEMPLATE.FVersionStatus AS VERSIONSTATUS  FROM T_RPT_Template AS TEMPLATE  LEFT OUTER JOIN T_PM_User AS CREATOR  ON TEMPLATE.FCreatorID = CREATOR.FID  LEFT OUTER JOIN T_PM_User AS AUDITOR  ON TEMPLATE.FAuditorID = AUDITOR.FID  INNER JOIN T_CSL_TempletDispense AS DISPENSE  ON TEMPLATE.FID = DISPENSE.FDispenseSrcID  INNER JOIN T_ORG_Company AS COMPANY  ON DISPENSE.FCompanyID = COMPANY.FID  INNER JOIN T_ORG_Tree AS TREE  ON DISPENSE.FOrgBoundID = TREE.FID  WHERE TEMPLATE.FTemplateType IN (3, 5, 4, 6) and TEMPLATE.FPeriodType IN (3, 4, 6) AND TEMPLATE.FAuditedStatus = 2  AND TEMPLATE.FVersionStatus = 1  ORDER BY TEMPLATETYPE ASC,  NUMBER1 ASC, PERIODTYPE ASC";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                TemplateInfo info = new TemplateInfo();
                String id = rs.getString("ID");
                String number = rs.getString("NUMBER1");
                String name = rs.getString("NAME");
                int templateType = rs.getInt("TEMPLATETYPE");
                int periodType = rs.getInt("PERIODTYPE");
                int dynRptType = rs.getInt("DYNARPTTYPE");
                int auditedStatus = rs.getInt("AUDITEDSTATUS");
                String auditorName = rs.getString("AUDITORNAME");
                String auditorID = rs.getString("AUDITORID");
                Timestamp auditedTime = rs.getTimestamp("AUDITEDTIME");
                String creatorName = rs.getString("CREATORNAME");
                String creatorID = rs.getString("CREATORID");
                Timestamp createTime = rs.getTimestamp("CREATETIME");
                Timestamp lastUpdateTime = rs.getTimestamp("LASTUPDATETIME");
                int versionStatus = rs.getInt("VERSIONSTATUS");
                info.setId(BOSUuid.read((String)id));
                info.setNumber(number);
                info.setName(name);
                info.setTemplateType(RptTmpTypeEnum.getEnum((int)templateType));
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                info.setDynaRptType(DynaEnumRptTypeEnum.getEnum(dynRptType));
                info.setAuditedStatus(AuditedStatusEnum.getEnum((int)auditedStatus));
                if (auditorID != null) {
                    UserInfo auditor = new UserInfo();
                    auditor.setId(BOSUuid.read((String)auditorID));
                    auditor.setName(auditorName);
                    info.setAuditor(auditor);
                }
                info.setAuditedTime(auditedTime);
                if (creatorID != null) {
                    UserInfo creator = new UserInfo();
                    creator.setId(BOSUuid.read((String)creatorID));
                    creator.setName(creatorName);
                    info.setCreator(creator);
                }
                info.setCreateTime(createTime);
                info.setLastUpdateTime(lastUpdateTime);
                info.setVersionStatus(VersionStatusEnum.getEnum((int)versionStatus));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    private String getYTDAMOUNTDataElement(Context ctx) throws BOSException, EASBizException {
        IDataElement iData = DataElementFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK("233dd11b-0108-1000-e000-03a4c0a81287B9E6C0CE");
        DataElementInfo dataInfo = iData.getDataElementInfo((IObjectPK)pk);
        return dataInfo.getNumber();
    }
}

