/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class CslElimUtil {
    public static String[] getBatchNumber(Context ctx, Map mapParams, int size) throws BOSException, EASBizException {
        EliminationInfo elimInfo = new EliminationInfo();
        elimInfo.setOrgBound((OrgTreeInfo)mapParams.get("KEY_ORGTREE_INFO"));
        elimInfo.setOrgUnit((OrgUnitInfo)mapParams.get("KEY_ORGUNIT_INFO"));
        elimInfo.setYear((Integer)mapParams.get("Year"));
        elimInfo.setPeriod((Integer)mapParams.get("Period"));
        elimInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)mapParams.get("PeriodType"))));
        return CslElimUtil.getBatchBizNumber(ctx, (IObjectValue)elimInfo, size);
    }

    public static String[] getAdjustBatchNumber(Context ctx, Map mapParams, int size) throws BOSException, EASBizException {
        AdjustInfo adjustInfo = new AdjustInfo();
        adjustInfo.setOrgBound((OrgTreeInfo)mapParams.get("KEY_ORGTREE_INFO"));
        adjustInfo.setOrgUnit((OrgUnitInfo)mapParams.get("KEY_ORGUNIT_INFO"));
        adjustInfo.setYear((Integer)mapParams.get("Year"));
        adjustInfo.setPeriod((Integer)mapParams.get("Period"));
        adjustInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)mapParams.get("PeriodType"))));
        return CslElimUtil.getBatchBizNumber(ctx, (IObjectValue)adjustInfo, size);
    }

    public static String getAdjustNumber(Context ctx, AdjustInfo sourceAdjustInfo, RptProperties rptProperties, Timestamp timestamp) throws BOSException, EASBizException {
        AdjustInfo adjustInfo = new AdjustInfo();
        adjustInfo.setOrgBound((OrgTreeInfo)rptProperties.getObject("KEY_ORGTREE_INFO"));
        adjustInfo.setOrgUnit(sourceAdjustInfo.getOrgUnit());
        adjustInfo.setYear((Integer)rptProperties.getObject("year"));
        adjustInfo.setPeriod((Integer)rptProperties.getObject("period"));
        adjustInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)rptProperties.getObject("periodType"))));
        adjustInfo.setBizDate(timestamp);
        sourceAdjustInfo.setBizDate(timestamp);
        String[] batchBizNumber = CslElimUtil.getBatchBizNumber(ctx, (IObjectValue)adjustInfo, 1);
        return batchBizNumber != null && batchBizNumber.length > 0 ? batchBizNumber[0] : null;
    }

    public static String[] getBatchBizNumber(Context ctx, IObjectValue bizObject, int size) throws BOSException, EASBizException {
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        String[] ret = CslRptUtil.getBatchCodingRuleNumber(ctx, bizObject, strOrgID, size);
        if (ret == null) {
            ret = new String[size];
            int number = 1;
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT Max(to_int(Replace(fnumber,'AUTO_',''))) As Fmaxnumber From ");
            sql.append(CslElimUtil.getTblNameByBizObj(bizObject)).append(" a  \r\n");
            sql.append("  WHERE a.fOrgBoundId = ? \r\n");
            sql.append("  and a.fyear = ? \r\n");
            sql.append("  and a.fperiod = ? \r\n");
            sql.append("  and a.fperiodType = ? \r\n");
            sql.append("  and a.fNumber like N'AUTO\\_%' escape '\\' \r\n");
            Object[] param = new Object[]{CslElimUtil.getBizObjtPrtValue(bizObject, "OrgTreeID"), CslElimUtil.getBizObjtPrtValue(bizObject, "Year"), CslElimUtil.getBizObjtPrtValue(bizObject, "Period"), CslElimUtil.getBizObjtPrtValue(bizObject, "PeriodType")};
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (rs.next() && rs.getBigDecimal("Fmaxnumber") != null) {
                    number = rs.getInt("Fmaxnumber") + 1;
                }
            }
            catch (SQLException exc) {
                throw new SQLDataException(exc);
            }
            StringBuffer result = null;
            for (int j = 0; j < size; ++j) {
                result = new StringBuffer("AUTO_");
                int n = 8 - Integer.valueOf(number).toString().length();
                for (int i = 0; i < n; ++i) {
                    result.append("0");
                }
                result.append(number);
                ret[j] = result.toString();
                ++number;
            }
        }
        return ret;
    }

    private static Object getBizObjtPrtValue(IObjectValue bizObject, String key) {
        if (bizObject instanceof EliminationInfo) {
            if ("OrgTreeID".equals(key)) {
                return ((EliminationInfo)bizObject).getOrgBound().getId().toString();
            }
            if ("Year".equals(key)) {
                return ((EliminationInfo)bizObject).getYear();
            }
            if ("Period".equals(key)) {
                return ((EliminationInfo)bizObject).getPeriod();
            }
            if ("PeriodType".equals(key)) {
                return ((EliminationInfo)bizObject).getPeriodType().getValue();
            }
            throw new UnsupportedOperationException("not Supported EliminationInfo's properties " + key + "!");
        }
        if (bizObject instanceof AdjustInfo) {
            if ("OrgTreeID".equals(key)) {
                return ((AdjustInfo)bizObject).getOrgBound().getId().toString();
            }
            if ("Year".equals(key)) {
                return ((AdjustInfo)bizObject).getYear();
            }
            if ("Period".equals(key)) {
                return ((AdjustInfo)bizObject).getPeriod();
            }
            if ("PeriodType".equals(key)) {
                return ((AdjustInfo)bizObject).getPeriodType().getValue();
            }
            throw new UnsupportedOperationException("not Supported EliminationInfo's properties " + key + "!");
        }
        throw new UnsupportedOperationException("not Supported BizObject:" + bizObject.getClass().getName());
    }

    private static String getTblNameByBizObj(IObjectValue bizObject) {
        if (bizObject instanceof EliminationInfo) {
            return "T_CSL_ELIMINATION";
        }
        if (bizObject instanceof AdjustInfo) {
            return "T_CSL_ADJUST";
        }
        throw new UnsupportedOperationException("not Supported BizObject:" + bizObject.getClass().getName());
    }

    public static String[] getBatchNumber(Context ctx, String orgTreeId, int year, int period, int periodType, int size, OrgTreeInfo orgTreeInfo, OrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("OrgTreeID", orgTreeId);
        param.put("Year", new Integer(year));
        param.put("Period", new Integer(period));
        param.put("PeriodType", new Integer(periodType));
        param.put("KEY_ORGTREE_INFO", orgTreeInfo);
        param.put("KEY_ORGUNIT_INFO", orgUnitInfo);
        return CslElimUtil.getBatchNumber(ctx, param, size);
    }
}

