/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.IBookFieldFlags;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaKeyAndValue;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ICslReportRela;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.TempletItemListFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCslRptCalculatorControllerBean;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class CslRptCalculatorControllerBean
extends AbstractCslRptCalculatorControllerBean {
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("template.id"));
        return sic;
    }

    @Override
    protected HashMap _calculateSumRptBySheets(Context ctx, ArrayList cslRptIDs, Map sheets) throws BOSException, SumRptException {
        if (cslRptIDs == null || sheets == null) {
            return null;
        }
        String curSheetName2 = null;
        HashMap<String, String> rptSheets = new HashMap<String, String>();
        for (String curSheetName2 : sheets.keySet()) {
            if (curSheetName2 == null || curSheetName2.length() == 0) continue;
            rptSheets.put(curSheetName2, curSheetName2);
        }
        HashMap sumSheets = new HashMap();
        for (String sheetName : sheets.keySet()) {
            sumSheets.put(sheetName, new HashMap());
        }
        try {
            Book book = null;
            int nodeCount = 0;
            int n = cslRptIDs.size();
            for (int j = 0; j < n; ++j) {
                ReportBaseInfo cslRpt = null;
                cslRpt = this.getCslReport((String)cslRptIDs.get(j), ctx);
                book = cslRpt.getBook();
                book.setCalculate(false);
                if (book != null && (nodeCount = book.getSheetCount()) > 0) {
                    for (int i = 0; i < nodeCount; ++i) {
                        Sheet sheet = book.getSheet(i);
                        curSheetName2 = sheet.getSheetName();
                        if (!rptSheets.containsKey(curSheetName2)) continue;
                        HashMap curSumDataMap = (HashMap)sumSheets.get(curSheetName2);
                        SumcalcRange sumZone = (SumcalcRange)sheets.get(curSheetName2);
                        this.calculateSheets(curSumDataMap, sheet, sumZone, false);
                        sheet = null;
                    }
                }
                cslRpt = null;
                book = null;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap resultMap = new HashMap(2);
        resultMap.put("sumBySheet", sumSheets);
        return resultMap;
    }

    @Override
    protected HashMap _calculateSumRptByDynaSheets(Context ctx, ArrayList cslRptIDs, Map sheets, Map dynaSumRange, Map sumdynaSheets, Map dynaOrder) throws BOSException, SumRptException {
        if (cslRptIDs == null || sheets == null) {
            return null;
        }
        String curSheetName2 = null;
        HashMap<String, String> rptSheets = new HashMap<String, String>();
        for (String curSheetName2 : sheets.keySet()) {
            if (curSheetName2 == null || curSheetName2.length() == 0) continue;
            rptSheets.put(curSheetName2, curSheetName2);
        }
        HashMap mapSum = new HashMap();
        if (dynaOrder == null) {
            dynaOrder = new HashMap();
            for (String sheetName : sheets.keySet()) {
                dynaOrder.put(sheetName, new ArrayList());
            }
        }
        if (sumdynaSheets == null) {
            sumdynaSheets = new HashMap();
            for (String sheetName : sheets.keySet()) {
                sumdynaSheets.put(sheetName, new HashMap());
            }
        }
        HashMap sumSheets = new HashMap();
        for (String sheetName : sheets.keySet()) {
            sumSheets.put(sheetName, new HashMap());
        }
        try {
            Book book = null;
            int nodeCount = 0;
            int n = cslRptIDs.size();
            for (int j = 0; j < n; ++j) {
                ReportBaseInfo cslRpt = null;
                cslRpt = this.getCslReport((String)cslRptIDs.get(j), ctx);
                book = cslRpt.getBook();
                if (book != null && (nodeCount = book.getSheetCount()) > 0) {
                    for (int i = 0; i < nodeCount; ++i) {
                        Sheet sheet = book.getSheet(i);
                        curSheetName2 = sheet.getSheetName();
                        if (!rptSheets.containsKey(curSheetName2)) continue;
                        HashMap curSumDataMap = (HashMap)sumSheets.get(curSheetName2);
                        SumcalcRange sumZone = (SumcalcRange)sheets.get(curSheetName2);
                        Book tempBook = null;
                        Sheet curSheet = SpreadHelper.copySheet(tempBook, (Sheet)sheet);
                        curSheet.setUserObject("DYNAMICSUMKEYZONE", sheet.getUserObjectValue("DYNAMICSUMKEYZONE"));
                        curSheet.setUserObject("DYNAMICSUMVALUEZONE", sheet.getUserObjectValue("DYNAMICSUMVALUEZONE"));
                        curSheet.setUserObject("fomulaLocation", sheet.getUserObjectValue("fomulaLocation"));
                        this.sumDynaSheets(curSumDataMap, curSheet, sumZone, dynaSumRange);
                        this.calculateDynaSheets(sheet, sumdynaSheets, dynaOrder);
                        sheet = null;
                    }
                }
                cslRpt = null;
                book = null;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        mapSum.put("sumBySheet", sumSheets);
        mapSum.put("dynaSumRange", sumdynaSheets);
        mapSum.put("order", dynaOrder);
        return mapSum;
    }

    private void sumDynaSheets(HashMap curSumDataMap, Sheet curSheet, SumcalcRange sumZone, Map dynaSumRange) {
        Object cell2;
        if (curSheet == null) {
            return;
        }
        if (sumZone == null || sumZone.size() < 1) {
            return;
        }
        HashMap tmpSumDataMap = new HashMap();
        this.removeDynaRow(curSheet, sumZone, dynaSumRange);
        for (int index = 0; index < sumZone.size(); ++index) {
            CellBlock block = sumZone.getCellBlock(index);
            Range range = curSheet.getRange(block);
            Sheet.ICellsIterator it = curSheet.getBook().getRangeCellsIterator(range, false, true);
            while (it.hasNext()) {
                BigDecimal tmpCellValue;
                cell2 = it.next();
                Variant var = cell2.getValue();
                Object tmpCellObj = var.isEmpty() ? null : var.getValue();
                if (tmpCellObj == null) continue;
                try {
                    tmpCellValue = new BigDecimal(tmpCellObj.toString());
                }
                catch (Exception e) {
                    continue;
                }
                HashMap cell = (HashMap)tmpSumDataMap.get(new Point(cell2.getCol(), cell2.getRow()));
                if (cell != null) continue;
                HashMap<String, BigDecimal> cell1 = new HashMap<String, BigDecimal>(2);
                cell1.put("value", tmpCellValue);
                tmpSumDataMap.put(new Point(cell2.getCol(), cell2.getRow()), cell1);
            }
        }
        for (Object key : tmpSumDataMap.keySet()) {
            if (curSumDataMap.containsKey(key)) {
                Map cell1 = (Map)curSumDataMap.get(key);
                cell2 = (Map)tmpSumDataMap.get(key);
                BigDecimal value = (BigDecimal)cell1.get("value");
                BigDecimal tmpValue = (BigDecimal)cell2.get("value");
                if ((value = value != null && tmpValue != null ? value.add(tmpValue) : tmpValue) != null && value.scale() < 0) {
                    value = value.setScale(0 - value.scale());
                }
                cell1.put("value", value);
                continue;
            }
            curSumDataMap.put(key, tmpSumDataMap.get(key));
        }
    }

    private void removeDynaRow(Sheet curSheet, SumcalcRange sumZone, Map dynaSumRange) {
        SumcalcRange groupRptkeyRange = null;
        SumcalcRange sumcalcRange = groupRptkeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
        if (groupRptkeyRange == null) {
            return;
        }
        DynaKeyAndValue dynaObj = (DynaKeyAndValue)dynaSumRange.get(curSheet.getSheetName());
        SumcalcRange sumRptKeyRange = dynaObj.dynaKeyRange;
        Integer leftKeyVol = dynaObj.leftKeyCol;
        this.reSetsheetBlock(curSheet, groupRptkeyRange, leftKeyVol);
        SumcalcRange sumcalcRange2 = groupRptkeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
        if (sumRptKeyRange == null || leftKeyVol == null) {
            return;
        }
        for (int i = 0; i < sumRptKeyRange.size(); ++i) {
            int k;
            CellBlock block = sumRptKeyRange.getCellBlock(i);
            int beginRow = block.getRow();
            int endRow = block.getRow2();
            groupRptkeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            CellBlock groupBlock = null;
            if (groupRptkeyRange != null) {
                groupBlock = groupRptkeyRange.getCellBlock(i);
            }
            if (groupBlock == null || groupBlock.getRow() == beginRow && groupBlock.getRow2() == endRow) continue;
            if (groupBlock.getRow2() > endRow) {
                for (k = groupBlock.getRow2(); k >= endRow + 1; --k) {
                    SumcalcRange sumcalcRange3 = groupRptkeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    if (groupRptkeyRange != null) {
                        curSheet = CslRptUtil.doDeleteDynaRange(curSheet, groupRptkeyRange, k, k);
                    }
                    curSheet.getRowRange(k, k).delete();
                }
                continue;
            }
            if (groupBlock.getRow2() >= endRow) continue;
            for (k = groupBlock.getRow2() + 1; k <= endRow; ++k) {
                SumcalcRange sumcalcRange4 = groupRptkeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                if (groupRptkeyRange != null) {
                    curSheet = CslRptUtil.doInsertDynaKeyRange(curSheet, groupRptkeyRange, k);
                }
                curSheet.getRowRange(k, k).insert();
            }
        }
    }

    private void reSetsheetBlock(Sheet curSheet, SumcalcRange keyRange, Integer leftKeyVol) {
        ArrayList allKeyRow = CslRptUtil.getAllLeftRow(leftKeyVol, keyRange);
        if (allKeyRow.size() != 0 && leftKeyVol != null) {
            SumcalcRange newKeyZone = CslRptUtil.reSaveKeyZoneByRange(curSheet, allKeyRow, leftKeyVol);
            curSheet.setUserObject("DYNAMICSUMKEYZONE", (Object)newKeyZone);
        }
    }

    private void calculateDynaSheets(Sheet curSheet, Map sumdynaSheets, Map dynaOrder) {
        SumcalcRange dynaValueRange;
        HashMap sumdynaSheet = (HashMap)sumdynaSheets.get(curSheet.getSheetName());
        ArrayList order = (ArrayList)dynaOrder.get(curSheet.getSheetName());
        SumcalcRange dynaKeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
        SumcalcRange sumcalcRange = dynaValueRange = curSheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
        if (dynaKeyRange == null || dynaValueRange == null) {
            return;
        }
        for (int index = 0; index < dynaKeyRange.size(); ++index) {
            CellBlock block = dynaKeyRange.getCellBlock(index);
            Range range = curSheet.getRange(block);
            Sheet.ICellsIterator it = curSheet.getBook().getRangeCellsIterator(range, false, true);
            while (it.hasNext()) {
                Cell cell = it.next();
                Object obj = cell.getValue().getValue();
                if (obj == null) continue;
                obj = obj.toString().trim();
                for (int i = 0; i < dynaValueRange.size(); ++i) {
                    CellBlock bk = dynaValueRange.getCellBlock(i);
                    if (!bk.containsRow(cell.getRow())) continue;
                    Range r = curSheet.getRange(bk);
                    Sheet.ICellsIterator itc = curSheet.getBook().getRangeCellsIterator(r, false, true);
                    while (itc.hasNext()) {
                        Cell cellValue = itc.next();
                        if (cellValue.getRow() != cell.getRow()) continue;
                        String key = curSheet.getSheetName() + "&" + index + "&" + obj.toString() + "&" + cellValue.getCol();
                        Object value = cellValue.getValue().getValue();
                        if (!sumdynaSheet.containsKey(key)) {
                            if (!(value instanceof BigDecimal)) continue;
                            sumdynaSheet.put(key, value);
                            if (order.contains(key)) continue;
                            order.add(index + "&" + obj.toString() + "&" + cellValue.getCol());
                            continue;
                        }
                        Object val = sumdynaSheet.get(key);
                        if (!(value instanceof BigDecimal)) continue;
                        BigDecimal valnew = (BigDecimal)value;
                        valnew = valnew.add((BigDecimal)val);
                        sumdynaSheet.put(key, valnew);
                    }
                }
            }
        }
    }

    private ReportBaseInfo getCslReport(String id, Context ctx) throws EASBizException, BOSException {
        BOSObjectType common_report_type = new BOSObjectType("0758F09F");
        boolean isCSLReport = true;
        BOSUuid uid = BOSUuid.read((String)id);
        if (uid.getType().equals((Object)common_report_type)) {
            isCSLReport = false;
        }
        ReportBaseInfo rpt = null;
        rpt = isCSLReport ? CslReportFactory.getLocalInstance(ctx).getReportBaseInfo("select id,name,number,company.id,company.number,data,dataCollect.*,dataCollectNumber where id='" + id + "'") : ReportFactory.getLocalInstance((Context)ctx).getReportBaseInfo("select id,name,number,company.id,company.number,data,dataCollect.*,dataCollectNumber where id='" + id + "'");
        return rpt;
    }

    private AbstractObjectCollection getCslReports(ArrayList cslRptIDs, Context ctx) throws EASBizException, BOSException {
        String id;
        BOSUuid uid;
        BOSObjectType common_report_type = new BOSObjectType("0758F09F");
        boolean isCSLReport = true;
        if (cslRptIDs != null && cslRptIDs.size() > 0 && cslRptIDs.get(0) != null && (uid = BOSUuid.read((String)(id = cslRptIDs.get(0).toString()))).getType().equals((Object)common_report_type)) {
            isCSLReport = false;
        }
        HashSet hsIDs = CslRptUtil.AryListToHashSet(cslRptIDs);
        CslReportCollection collection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("company.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("company.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("data"));
        viewInfo.getSelector().add(new SelectorItemInfo("dataCollect.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("dataCollectNumber"));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)hsIDs, CompareType.INCLUDE));
        collection = isCSLReport ? CslReportFactory.getLocalInstance(ctx).getCslReportCollection(viewInfo) : ReportFactory.getLocalInstance((Context)ctx).getReportCollection(viewInfo);
        return collection;
    }

    private void calculateSheets(HashMap curSumDataMap, Sheet curSheet, SumcalcRange sumZone, boolean isRemove) {
        Object cell2;
        if (curSheet == null) {
            return;
        }
        if (sumZone == null || sumZone.size() < 1) {
            return;
        }
        HashMap tmpSumDataMap = new HashMap();
        for (int index = 0; index < sumZone.size(); ++index) {
            CellBlock block = sumZone.getCellBlock(index);
            Range range = curSheet.getRange(block);
            Sheet.ICellsIterator it = curSheet.getBook().getRangeCellsIterator(range, false, true);
            while (it.hasNext()) {
                HashMap cell;
                BigDecimal tmpCellValue;
                cell2 = it.next();
                Variant var = cell2.getValue();
                Object tmpCellObj = var.isEmpty() ? null : var.getValue();
                if (tmpCellObj == null) continue;
                try {
                    tmpCellValue = new BigDecimal(tmpCellObj.toString());
                }
                catch (Exception e) {
                    continue;
                }
                if (isRemove) {
                    tmpCellValue = tmpCellValue.negate();
                }
                if ((cell = (HashMap)tmpSumDataMap.get(new Point(cell2.getCol(), cell2.getRow()))) != null) continue;
                HashMap<String, BigDecimal> cell1 = new HashMap<String, BigDecimal>(2);
                cell1.put("value", tmpCellValue);
                tmpSumDataMap.put(new Point(cell2.getCol(), cell2.getRow()), cell1);
            }
        }
        for (Object key : tmpSumDataMap.keySet()) {
            if (curSumDataMap.containsKey(key)) {
                Map cell1 = (Map)curSumDataMap.get(key);
                cell2 = (Map)tmpSumDataMap.get(key);
                BigDecimal value = (BigDecimal)cell1.get("value");
                BigDecimal tmpValue = (BigDecimal)cell2.get("value");
                if ((value = value != null && tmpValue != null ? value.add(tmpValue) : tmpValue) != null && value.scale() < 0) {
                    value = value.setScale(0 - value.scale());
                }
                cell1.put("value", value);
                continue;
            }
            curSumDataMap.put(key, tmpSumDataMap.get(key));
        }
    }

    private String vecToString(Vector companys) {
        StringBuffer sbResult = new StringBuffer();
        for (int i = 0; i < companys.size(); ++i) {
            Object obj = companys.get(i);
            if (obj == null || !(obj instanceof String)) continue;
            String company = (String)obj;
            sbResult.append(company);
            sbResult.append(',');
        }
        String result = sbResult.toString();
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Override
    protected HashMap _calculateSumRptBySheets(Context ctx, ArrayList cslRptIDs, ArrayList sheets) throws BOSException, SumRptException {
        if (cslRptIDs == null || sheets == null) {
            return null;
        }
        String curSheetId = null;
        HashMap<String, String> rptSheets = new HashMap<String, String>();
        Iterator iterSheet = sheets.iterator();
        String companyNumber = "";
        while (iterSheet.hasNext()) {
            curSheetId = (String)iterSheet.next();
            if (curSheetId == null || curSheetId.length() == 0) continue;
            rptSheets.put(curSheetId, curSheetId);
        }
        HashMap sumSheets = new HashMap();
        for (int i = 0; i < sheets.size(); ++i) {
            String sheetID = (String)sheets.get(i);
            sumSheets.put(sheetID, new HashMap());
        }
        try {
            Book book = null;
            AbstractObjectCollection cslRpts = null;
            cslRpts = this.getCslReports(cslRptIDs, ctx);
            Iterator iterRpt = cslRpts.iterator();
            int nodeCount = 0;
            while (iterRpt.hasNext()) {
                ReportBaseInfo cslRpt = (ReportBaseInfo)iterRpt.next();
                book = IOHelper.unpackBook((byte[])cslRpt.getData(), (int)(IBookFieldFlags.FLAG_DATA | IBookFieldFlags.FLAG_FORMULA));
                book.setCalculate(false);
                if (book != null && (nodeCount = book.getSheetCount()) > 0) {
                    for (int i = 0; i < nodeCount; ++i) {
                        Sheet sheet = book.getSheet(i);
                        curSheetId = sheet.getID();
                        if (!rptSheets.containsKey(curSheetId)) continue;
                        HashMap curSumDataMap = (HashMap)sumSheets.get(curSheetId);
                        if (cslRpt.getCompany() != null && cslRpt.getCompany().getNumber() != null) {
                            companyNumber = cslRpt.getCompany().getNumber();
                        }
                        this.calculateSheets(curSumDataMap, sheet, companyNumber, cslRpt.getNumber());
                        sheet = null;
                    }
                }
                cslRpt = null;
                book = null;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sumSheets;
    }

    private void calculateSheets(HashMap curSumDataMap, Sheet curSheet, String companyNum, String reportName) {
        if (curSheet == null) {
            return;
        }
        Sheet.ICellsIterator cellIterator = curSheet.getCellsIterator(null, false, true);
        while (cellIterator.hasNext()) {
            String expression;
            BigDecimal tmpCellValue;
            Cell curCell = cellIterator.next();
            int rowIndex = curCell.getRow();
            int columnIndex = curCell.getCol();
            Variant var = curCell.getValue();
            Object tmpCellObj = var == null ? null : var.getValue();
            String expr = curCell.getFormula();
            if (tmpCellObj == null && StringUtils.isEmpty((String)expr)) continue;
            try {
                if (tmpCellObj != null && tmpCellObj.toString().equals("")) {
                    tmpCellObj = null;
                }
                tmpCellValue = tmpCellObj == null ? null : new BigDecimal(tmpCellObj.toString());
            }
            catch (Exception e) {
                continue;
            }
            HashMap cell = (HashMap)curSumDataMap.get(new Point(columnIndex, rowIndex));
            if (cell == null) {
                HashMap<String, Object> cell1 = new HashMap<String, Object>(2);
                cell1.put("value", tmpCellValue);
                expression = "ref(\"" + companyNum + "\",\"" + reportName + "\",\"" + curSheet.getSheetName() + "\",\"" + TableToolkit.xy2range((int)columnIndex, (int)rowIndex) + "\")";
                cell1.put("expression", expression);
                curSumDataMap.put(new Point(columnIndex, rowIndex), cell1);
                continue;
            }
            BigDecimal tmpMapValue = (BigDecimal)cell.get("value");
            if (tmpMapValue != null && tmpCellValue != null) {
                tmpMapValue = tmpMapValue.add(tmpCellValue);
            } else if (tmpMapValue == null && tmpCellValue != null) {
                tmpMapValue = tmpCellValue;
            }
            expression = (String)cell.get("expression");
            String newexpression = "ref(\"" + companyNum + "\",\"" + reportName + "\",\"" + curSheet.getSheetName() + "\",\"" + TableToolkit.xy2range((int)columnIndex, (int)rowIndex) + "\")";
            expression = expression + "+" + newexpression;
            cell.put("value", tmpMapValue);
            cell.put("expression", expression);
            curSumDataMap.put(new Point(columnIndex, rowIndex), cell);
        }
    }

    @Override
    protected HashMap _checkSumRptRule(Context ctx, HashMap param) throws BOSException, EASBizException {
        CslReportInfo rpt;
        int i;
        HashMap<String, Object> ret = new HashMap<String, Object>(8);
        HashMap<String, CommittedStatusEnum> committedCompanys = new HashMap<String, CommittedStatusEnum>();
        StringBuffer detail = new StringBuffer();
        StringBuffer strOql = new StringBuffer();
        CslReportInfo report = (CslReportInfo)param.get("report");
        Vector companys = (Vector)param.get("companys");
        Boolean bySumReport = param.get("bySumReport") == null ? Boolean.TRUE : (Boolean)param.get("bySumReport");
        StringBuffer sb = new StringBuffer("");
        if (companys != null && companys.size() > 0) {
            for (int i2 = 0; i2 < companys.size(); ++i2) {
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)companys.get(i2);
                if (i2 > 0) {
                    sb.append(",");
                }
                sb.append("'" + orgUnitInfo.getId().toString() + "'");
            }
        } else {
            return null;
        }
        if (sb.length() == 0) {
            return null;
        }
        ICslReport iCslReport = CslReportFactory.getLocalInstance(ctx);
        TemplateInfo template = report.getTemplate();
        if (report.getSourceType().equals((Object)RptSrcTypeEnum.SUM) && template.getSumType().getValue() == 1) {
            strOql.delete(0, strOql.length());
            strOql.append("SELECT sourceTemplet.id, sourceTemplet.group, targetTemplet.group WHERE targetTemplet.id = '");
            strOql.append(report.getTemplate().getId().toString()).append("'");
            ICslReportRela iCslReportRela = CslReportRelaFactory.getLocalInstance(ctx);
            CoreBaseCollection collection = iCslReportRela.getCollection(strOql.toString());
            if (collection.size() != 1) {
                return null;
            }
            CslReportRelaInfo reportRelaInfo = (CslReportRelaInfo)collection.get(0);
            strOql.delete(0, strOql.length());
            strOql.append("SELECT id,committedstatus,orgunit WHERE orgUnit.id in (");
            strOql.append(sb.toString());
            strOql.append(") AND template.group in ('");
            strOql.append(reportRelaInfo.getSourceTemplet().getGroup()).append("', '");
            strOql.append(reportRelaInfo.getTargetTemplet().getGroup()).append("'");
            strOql.append(") and year = ").append(report.getYear());
            strOql.append(" and period = ").append(report.getPeriod());
            strOql.append(" and currency.id = '").append(report.getCurrency().getId().toString());
            strOql.append("' and dataCollectNumber = '").append(report.getDataCollectNumber());
            strOql.append("' and adjustStatus = ").append(0);
            strOql.append(" and committedStatus = ").append(3);
            CslReportCollection col = iCslReport.getCslReportCollection(strOql.toString());
            if (col != null && col.size() > 0) {
                for (i = 0; i < col.size(); ++i) {
                    rpt = col.get(i);
                    if (rpt.getCommittedStatus().getValue() != 3) continue;
                    committedCompanys.put(rpt.getOrgUnit().getId().toString(), CommittedStatusEnum.GROUPCOMMITTED);
                }
                ret.put("", new Integer(companys.size() - committedCompanys.size()));
            } else {
                ret.put("noConfirmCount", new Integer(companys.size()));
            }
        } else {
            boolean isListCompany;
            if (report.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT) && !TempletItemListFactory.getLocalInstance(ctx).exists("select id where template.id='" + template.getId() + "'")) {
                ret.put("noConfirmCount", new Integer(0));
                return ret;
            }
            boolean bl = isListCompany = param.get("isListCompany") == null ? false : (Boolean)param.get("isListCompany");
            if (isListCompany) {
                String ids = sb.toString();
                sb.setLength(0);
                sb.append(CslRptUtil.expandCompanys(ctx, report.getOrgTree().getId().toString(), ids, true));
                companys.clear();
                companys.addAll(this.getCompanyidVector(ctx, report, sb.toString()));
                ret.put("companySize", companys.size());
            }
            List col = iCslReport.getLinkReports(report.getId().toString(), sb.toString(), bySumReport, isListCompany);
            StringBuffer companyids = new StringBuffer();
            if (col != null && col.size() > 0) {
                for (int i3 = 0; i3 < col.size(); ++i3) {
                    if (i3 > 0) {
                        companyids.append(",");
                    }
                    companyids.append("'").append(col.get(i3)).append("'");
                }
                strOql.delete(0, strOql.length());
                strOql.append(" SELECT id,committedstatus,orgunit ");
                strOql.append(" WHERE id in (").append(companyids.toString()).append(")");
                strOql.append(" AND dataCollectNumber ='").append(report.getDataCollectNumber()).append("'");
                CslReportCollection col2 = iCslReport.getCslReportCollection(strOql.toString());
                if (col2 != null && col2.size() > 0) {
                    for (i = 0; i < col2.size(); ++i) {
                        rpt = col2.get(i);
                        if (rpt.getCommittedStatus().getValue() != 3) continue;
                        committedCompanys.put(rpt.getOrgUnit().getId().toString(), CommittedStatusEnum.GROUPCOMMITTED);
                    }
                }
            } else {
                ret.put("noConfirmCount", new Integer(companys.size()));
            }
        }
        int noConfirmCount = 0;
        for (OrgUnitInfo org : companys) {
            if (committedCompanys.containsKey(org.getId().toString())) continue;
            ++noConfirmCount;
            if (!org.isIsGrouping()) {
                detail.append("\n").append(org.getName());
                continue;
            }
            detail.append("\n").append(org.getName()).append(bySumReport != false ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"169_CslRptCalculatorControllerBean", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"170_CslRptCalculatorControllerBean", (Locale)ctx.getOriginLocale()));
        }
        ret.put("noConfirmCount", noConfirmCount);
        ret.put("detail", detail.toString());
        return ret;
    }

    private Vector getCompanyidVector(Context ctx, CslReportInfo report, String companyIds) throws BOSException {
        Vector<FullOrgUnitInfo> companys = new Vector<FullOrgUnitInfo>();
        RptSrcTypeEnum sourceType = report.getSourceType();
        if (sourceType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) || sourceType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) {
            OrgStructureCollection orgStructures = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select Unit.id,Unit.name where Tree.id ='" + report.getOrgTree().getId() + "' and Unit.id in(" + companyIds + ")");
            for (int i = 0; i < orgStructures.size(); ++i) {
                companys.add(orgStructures.get(i).getUnit());
            }
        }
        return companys;
    }

    @Override
    protected HashMap _incrementCalSumRptBySheets(Context ctx, List cslRptIDs, String sumRptId, Map sheets) throws BOSException, SumRptException {
        if (cslRptIDs == null || sheets == null) {
            return null;
        }
        HashMap sumSheets = new HashMap();
        for (String sheetName : sheets.keySet()) {
            if (StringUtils.isEmpty((String)sheetName)) continue;
            sumSheets.put(sheetName, new HashMap());
        }
        Map calRptIds = this.getIncrementCalReport(ctx, cslRptIDs, sumRptId, sheets);
        Map removeBackReport = (Map)calRptIds.get("removeBackReport");
        for (String rptId : removeBackReport.keySet()) {
            List sheetNames = (List)removeBackReport.get(rptId);
            String sql = "select FData from t_csl_backedReport where FId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rptId});
            try {
                Blob data;
                Book book;
                if (!rowSet.next() || (book = IOHelper.unpackBook((byte[])this.toBytes(data = rowSet.getBlob("FData")), (int)IBookFieldFlags.FLAG_DATA)) == null) continue;
                for (int i = 0; i < sheetNames.size(); ++i) {
                    Sheet sheet;
                    String sheetName = (String)sheetNames.get(i);
                    int index = book.getSheetIndexByName(sheetName);
                    if (index < 0 || (sheet = book.getSheet(index)) == null) continue;
                    HashMap curSumDataMap = (HashMap)sumSheets.get(sheetName);
                    SumcalcRange sumZone = (SumcalcRange)sheets.get(sheetName);
                    this.calculateSheets(curSumDataMap, sheet, sumZone, true);
                    sheet = null;
                }
                book = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        Map removeReport = (Map)calRptIds.get("removeReport");
        for (String rptId : removeReport.keySet()) {
            List sheetNames = (List)removeReport.get(rptId);
            String sql = "select FData from t_csl_cslReport where FId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rptId});
            try {
                Blob data;
                Book book;
                if (!rowSet.next() || (book = IOHelper.unpackBook((byte[])this.toBytes(data = rowSet.getBlob("FData")), (int)IBookFieldFlags.FLAG_DATA)) == null) continue;
                for (int i = 0; i < sheetNames.size(); ++i) {
                    Sheet sheet;
                    String sheetName = (String)sheetNames.get(i);
                    int index = book.getSheetIndexByName(sheetName);
                    if (index < 0 || (sheet = book.getSheet(index)) == null) continue;
                    HashMap curSumDataMap = (HashMap)sumSheets.get(sheetName);
                    SumcalcRange sumZone = (SumcalcRange)sheets.get(sheetName);
                    this.calculateSheets(curSumDataMap, sheet, sumZone, true);
                    sheet = null;
                }
                book = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        Map addReport = (Map)calRptIds.get("addReport");
        for (String rptId : addReport.keySet()) {
            List sheetNames = (List)addReport.get(rptId);
            String sql = "select FData from t_csl_cslReport where FId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rptId});
            try {
                Blob data;
                Book book;
                if (!rowSet.next() || (book = IOHelper.unpackBook((byte[])this.toBytes(data = rowSet.getBlob("FData")), (int)IBookFieldFlags.FLAG_DATA)) == null) continue;
                for (int i = 0; i < sheetNames.size(); ++i) {
                    Sheet sheet;
                    String sheetName = (String)sheetNames.get(i);
                    int index = book.getSheetIndexByName(sheetName);
                    if (index < 0 || (sheet = book.getSheet(index)) == null) continue;
                    HashMap curSumDataMap = (HashMap)sumSheets.get(sheetName);
                    SumcalcRange sumZone = (SumcalcRange)sheets.get(sheetName);
                    this.calculateSheets(curSumDataMap, sheet, sumZone, false);
                    sheet = null;
                }
                book = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        String sql = "select FData from t_csl_cslReport where FId = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{sumRptId});
        try {
            Blob data;
            Book book;
            if (rowSet.next() && (book = IOHelper.unpackBook((byte[])this.toBytes(data = rowSet.getBlob("FData")), (int)IBookFieldFlags.FLAG_DATA)) != null) {
                for (String sheetName : sheets.keySet()) {
                    Sheet sheet;
                    int index = book.getSheetIndexByName(sheetName);
                    if (index < 0 || (sheet = book.getSheet(index)) == null) continue;
                    HashMap curSumDataMap = (HashMap)sumSheets.get(sheetName);
                    SumcalcRange sumZone = (SumcalcRange)sheets.get(sheetName);
                    this.calculateSheets(curSumDataMap, sheet, sumZone, false);
                    sheet = null;
                }
                book = null;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap mapSum = new HashMap(2);
        mapSum.put("sumBySheet", sumSheets);
        return mapSum;
    }

    private byte[] toBytes(Blob data) throws BOSException {
        InputStream in = null;
        try {
            in = data.getBinaryStream();
            if (in == null) {
                byte[] byArray = null;
                return byArray;
            }
            int blockSize = 1024;
            byte[] block = new byte[1024];
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            int len = -1;
            do {
                try {
                    len = in.read(block);
                }
                catch (IOException e1) {
                    throw new BOSException(e1.getMessage(), (Throwable)e1);
                }
                if (len <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            throw new BOSException("toBytes error.", (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new BOSException("in.close() error.", (Throwable)e);
                }
            }
        }
    }

    private Map getIncrementCalReport(Context ctx, List cslRptIds, String sumRptId, Map sheets) throws BOSException {
        HashMap result = new HashMap(4);
        HashMap<String, ArrayList<String>> removeBackReport = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> removeReport = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> addReport = new HashMap<String, ArrayList<String>>();
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        params.add(sumRptId);
        params.add("empty_sheet");
        sql.append("select distinct sumRela.FReportId SubReportID,sumRela.FSheetId SheetName, backedSheet.FReportId BackReportID  from t_csl_sumRptRela sumRela ");
        sql.append(" Left join t_csl_backedSheet backedSheet on  backedSheet.FReportId = sumRela.FReportID and backedSheet.FSheetName = sumRela.FSheetID ");
        sql.append(" where sumRela.FSumReportId = ? and ( sumRela.FSheetId = ? or sumRela.FSheetId in ");
        sql.append(RptUtilForServer.createInSql(sheets.keySet().iterator(), params));
        sql.append(" ) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        OneToManyMap sheetID2ReportIDMap = new OneToManyMap();
        OneToManyMap backSheetID2ReportIDMap = new OneToManyMap();
        try {
            while (rowSet.next()) {
                sheetID2ReportIDMap.put(rowSet.getString("SheetName"), rowSet.getString("SubReportID"));
                if (StringUtils.isEmpty((String)rowSet.getString("BackReportID"))) continue;
                backSheetID2ReportIDMap.put(rowSet.getString("SheetName"), rowSet.getString("BackReportID"));
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        for (String sheetName : sheets.keySet()) {
            ArrayList tmpIds = new ArrayList();
            tmpIds.addAll(cslRptIds);
            List sumReportID = (List)sheetID2ReportIDMap.get(sheetName);
            if (sumReportID == null) {
                sumReportID = (List)sheetID2ReportIDMap.get("empty_sheet");
            }
            if (sumReportID != null && sumReportID.size() > 0) {
                ArrayList backReportList = (ArrayList)backSheetID2ReportIDMap.get(sheetName);
                if (backReportList == null && (backReportList = (List)backSheetID2ReportIDMap.get("empty_sheet")) == null) {
                    backReportList = new ArrayList();
                }
                HashSet backReportSet = new HashSet(backReportList);
                for (String rptId : sumReportID) {
                    List<String> ls;
                    if (backReportSet.contains(rptId)) {
                        ls = (ArrayList<String>)removeBackReport.get(rptId);
                        if (ls == null) {
                            ls = new ArrayList<String>();
                            removeBackReport.put(rptId, (ArrayList<String>)ls);
                        }
                        ls.add(sheetName);
                        continue;
                    }
                    if (tmpIds.contains(rptId)) {
                        tmpIds.remove(rptId);
                        continue;
                    }
                    ls = (List)removeReport.get(rptId);
                    if (ls == null) {
                        ls = new ArrayList();
                        removeReport.put(rptId, (ArrayList<String>)ls);
                    }
                    ls.add(sheetName);
                }
            }
            for (int i = 0; i < tmpIds.size(); ++i) {
                String rptId = (String)tmpIds.get(i);
                ArrayList<String> ls = (ArrayList<String>)addReport.get(rptId);
                if (ls == null) {
                    ls = new ArrayList<String>();
                    addReport.put(rptId, ls);
                }
                ls.add(sheetName);
            }
        }
        result.put("removeBackReport", removeBackReport);
        result.put("removeReport", removeReport);
        result.put("addReport", addReport);
        return result;
    }
}

