/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CyConvtSchmCollection;
import com.kingdee.eas.fi.gr.cslrpt.CyConvtSchmInfo;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCyConvtSchmControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class CyConvtSchmControllerBean
extends AbstractCyConvtSchmControllerBean {
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkExists(ctx, model);
        CyConvtSchmInfo info = (CyConvtSchmInfo)model;
        if (info.isIsDefault()) {
            this.clearDefault(ctx);
        }
        super._addnew(ctx, pk, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkExists(ctx, model);
        CyConvtSchmInfo info = (CyConvtSchmInfo)model;
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        if (info.isIsDefault()) {
            this.clearDefault(ctx);
        }
        return super._addnew(ctx, model);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        CyConvtSchmInfo info = this.getCyConvtSchmInfo(ctx, pk);
        return info.getNumber() + "  " + info.getName();
    }

    private void checkExists(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (super.exists(ctx, "where number = '" + StringUtil.replaceAll(model.get("number").toString(), "'", "''") + "'")) {
            throw new ServerException(ServerException.NUMBER_DOUBLE);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CyConvtSchmInfo info;
        CyConvtSchmInfo oldModel = this.getCyConvtSchmInfo(ctx, pk);
        if (!((CyConvtSchmInfo)model).getNumber().equals(oldModel.getNumber())) {
            this.checkExists(ctx, model);
        }
        if ((info = (CyConvtSchmInfo)model).isIsDefault()) {
            this.clearDefault(ctx);
        }
        String sql = "DELETE FROM T_CSL_CYCONVTSCHMENTRY WHERE FSchemeID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        super._update(ctx, pk, model);
    }

    private void clearDefault(Context ctx) throws BOSException, EASBizException {
        String sql = "update T_CSL_CyConvtSchm set fisdefault=0 where fisdefault=1 ";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected IObjectCollection _getcollectionbySql(Context ctx, String sql) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        CyConvtSchmCollection retValue = new CyConvtSchmCollection();
        try {
            sqlStr.append(sql);
            String gradeManageFilterSql = CslGradeManageUtil.getGradeManageFilterSql((Context)ctx, (String)"FTrackRecordCreatorID", (String)"com.kingdee.eas.fi.gr.cslrpt.client.CyConvtSchmListUI", null);
            if (sql.toUpperCase().indexOf("WHERE") < 0) {
                sqlStr.append(" WHERE ");
            } else {
                sqlStr.append(" AND ");
            }
            if (gradeManageFilterSql == null) {
                sqlStr.append("1=1");
            } else {
                sqlStr.append(gradeManageFilterSql);
            }
            sqlStr.append(" ORDER BY FNumber");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("FId");
                String fnumber = rowSet.getString("fnumber");
                String fname = rowSet.getString("fname");
                CyConvtSchmInfo info = new CyConvtSchmInfo();
                info.setName(fname);
                info.setId(BOSUuid.read((String)id));
                info.setNumber(fnumber);
                retValue.add(info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return retValue;
    }
}

