/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.DynItemFillSqlParse;
import com.kingdee.eas.fi.gr.cslrpt.app.DynaItemDataInterface;
import com.kingdee.eas.fi.gr.dynamic.fill.FormulaFilterInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DynItemFillData
implements DynaItemDataInterface {
    private static Logger LOGGER = Logger.getLogger(DynItemFillData.class);
    private List fourmulaFilterList;
    private Set<String> fillItemSet;
    private Map<String, Set<String>> fillItemMap = null;
    private CompanyOrgUnitInfo currentUnit;
    private Context ctx;
    private String dynItemSql;
    private String fieldHg;
    private boolean isExecuteError = false;
    private List asstActTypeList = null;
    private Map useredAsstActTypes = null;
    private Map<String, List<String>> asstActType_values = new HashMap<String, List<String>>();
    private Map asstActTypeAttribeAndGroupMap = null;
    private boolean isSameYearPeriod = true;
    private String sameYear = null;
    private String samePeriod = null;
    private boolean isSameOrgUnit = true;
    private CompanyOrgUnitInfo sameOrgUnit = null;
    private boolean isIncludeNotBizUnit = false;
    private boolean isSameCurrency = true;
    private String sameCurrencyId = null;
    private String sameCurrencyNumber = null;
    private String tmpTableName = null;
    private String glAssistBalTable = null;
    private boolean isHasCurrency = true;
    private Set<String> periodSet = new HashSet<String>();
    boolean isProfitCenter = false;
    private String balType = null;
    PeriodInfo periodInfo = null;
    boolean isQueryByBalType = false;
    private Exception exception = null;
    private boolean isGroupByFormula = false;
    private boolean isQueryOwnerCompany = false;
    private String attribute = null;

    public DynItemFillData(Context ctx, List fourmulaFilterList, String dynItemSql, String fieldHg, CompanyOrgUnitInfo currentUnit, String glAssistBalTable, String balType) {
        this.ctx = ctx;
        this.fourmulaFilterList = fourmulaFilterList;
        this.dynItemSql = dynItemSql;
        this.fieldHg = fieldHg;
        this.currentUnit = currentUnit;
        this.glAssistBalTable = glAssistBalTable;
        this.fillItemSet = new HashSet<String>();
        if (glAssistBalTable.trim().toUpperCase().charAt(glAssistBalTable.length() - 1) != 'F') {
            this.isHasCurrency = false;
        }
        if (glAssistBalTable.trim().toUpperCase(Locale.ENGLISH).startsWith("T_PCA_PC")) {
            this.isProfitCenter = true;
        }
        this.balType = balType;
    }

    public DynItemFillData(Context ctx, List fourmulaFilterList, String dynItemSql, String fieldHg, CompanyOrgUnitInfo currentUnit, String glAssistBalTable, boolean isGroupByFormula) {
        this(ctx, fourmulaFilterList, dynItemSql, fieldHg, currentUnit, glAssistBalTable, null);
        this.isGroupByFormula = isGroupByFormula;
    }

    public DynItemFillData(Context ctx, List fourmulaFilterList, String dynItemSql, String fieldHg, CompanyOrgUnitInfo currentUnit, String glAssistBalTable, boolean isQueryOwnerCompany, String attribute) {
        this(ctx, fourmulaFilterList, dynItemSql, fieldHg, currentUnit, glAssistBalTable, null);
        this.isQueryOwnerCompany = isQueryOwnerCompany;
        this.attribute = attribute;
    }

    public DynItemFillData(Context ctx, List fourmulaFilterList, List asstActTypeList, Map useredAsstActTypes, CompanyOrgUnitInfo currentUnit, String tableName) {
        this(ctx, fourmulaFilterList, asstActTypeList, useredAsstActTypes, currentUnit, tableName, null);
    }

    public DynItemFillData(Context ctx, List fourmulaFilterList, List asstActTypeList, Map useredAsstActTypes, CompanyOrgUnitInfo currentUnit, String tableName, Map asstActTypeAttribeAndGroupMap) {
        this.ctx = ctx;
        this.fourmulaFilterList = fourmulaFilterList;
        this.currentUnit = currentUnit;
        this.asstActTypeList = asstActTypeList;
        this.useredAsstActTypes = useredAsstActTypes;
        this.glAssistBalTable = tableName;
        this.fillItemSet = new HashSet<String>();
        if (this.glAssistBalTable.trim().toUpperCase(Locale.ENGLISH).charAt(this.glAssistBalTable.length() - 1) != 'F') {
            this.isHasCurrency = false;
        }
        if (this.glAssistBalTable.trim().toUpperCase(Locale.ENGLISH).startsWith("T_PCA_PC")) {
            this.isProfitCenter = true;
        }
        this.asstActTypeAttribeAndGroupMap = asstActTypeAttribeAndGroupMap;
    }

    @Override
    public void createFillDate() throws EASBizException, BOSException {
        try {
            if (this.isGroupByFormula || this.isQueryOwnerCompany) {
                this.getFillDataByFormulaGroup();
            } else {
                this.preHandleParam(false);
                this.getFillItemData();
            }
        }
        finally {
            if (!StringUtils.isEmpty((String)this.tmpTableName) && !DebugLogger.isDebug) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tmpTableName);
                this.tmpTableName = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFillDataByFormulaGroup() throws EASBizException, BOSException {
        try {
            this.preHandleParam(false);
            StringBuffer sql = this.getExecutesql();
            if (DebugLogger.isDebug) {
                LOGGER.error((Object)sql);
            }
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                this.fillItemMap = new HashMap<String, Set<String>>();
                if (rs != null) {
                    while (rs.next()) {
                        String id = rs.getString("ID");
                        String formulaId = rs.getString("formulaId");
                        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)formulaId)) continue;
                        Set<String> ids = this.fillItemMap.get(formulaId);
                        if (ids == null) {
                            ids = new HashSet<String>();
                            this.fillItemMap.put(formulaId, ids);
                        }
                        ids.add(id);
                    }
                }
            }
            catch (SQLException e) {
                this.isExecuteError = true;
                LOGGER.error((Object)"getFillItemData", (Throwable)e);
            }
        }
        finally {
            if (!StringUtils.isEmpty((String)this.tmpTableName) && !DebugLogger.isDebug) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tmpTableName);
                this.tmpTableName = null;
            }
        }
    }

    private void preHandleParam(boolean isMult) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        this.periodInfo = this.getPeriodInfo();
        this.handleSame(this.periodInfo);
        String[] periodArray = null;
        if (this.isSameYearPeriod) {
            String periodStr = RptUtil.getYearPeriod((int)Integer.valueOf(this.sameYear), (int)Integer.valueOf(this.samePeriod), (int)Integer.valueOf(this.sameYear), (int)Integer.valueOf(this.samePeriod));
            periodArray = periodStr.split(",");
        }
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        try {
            sql.append("create table t_csl_FormulFilter(startAccount VARCHAR(100),endAccount VARCHAR(100)");
            if (isMult || !this.isSameOrgUnit || this.isHasCurrency && !this.isSameCurrency) {
                sql.append(",period int");
            }
            if (!this.isSameOrgUnit) {
                sql.append(",companyNumber VARCHAR(100)");
                if (this.isIncludeNotBizUnit) {
                    sql.append(",isBizUnit Int");
                }
            }
            if (this.isHasCurrency && !this.isSameCurrency) {
                sql.append(",currency VARCHAR(100)");
            }
            if (this.isGroupByFormula || this.isQueryOwnerCompany) {
                sql.append(",formulaId nVARCHAR(80)");
            }
            sql.append(")");
            this.tmpTableName = pool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        boolean hasParam = false;
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        try {
            sql.setLength(0);
            sql.append(" insert into ").append(this.tmpTableName).append("(startAccount,endAccount");
            if (isMult || !this.isSameOrgUnit || this.isHasCurrency && !this.isSameCurrency) {
                sql.append(",period");
            }
            if (!this.isSameOrgUnit) {
                sql.append(",companyNumber");
                if (this.isIncludeNotBizUnit) {
                    sql.append(",isBizUnit");
                }
            }
            if (this.isHasCurrency && !this.isSameCurrency) {
                sql.append(",currency");
            }
            if (this.isGroupByFormula || this.isQueryOwnerCompany) {
                sql.append(",formulaId");
            }
            sql.append(") values(?,? ");
            if (isMult || !this.isSameOrgUnit || this.isHasCurrency && !this.isSameCurrency) {
                sql.append(",?");
            }
            if (!this.isSameOrgUnit) {
                sql.append(",?");
                if (this.isIncludeNotBizUnit) {
                    sql.append(",?");
                }
            }
            if (this.isHasCurrency && !this.isSameCurrency) {
                sql.append(",?");
            }
            if (this.isGroupByFormula || this.isQueryOwnerCompany) {
                sql.append(",?");
            }
            sql.append(")");
            connection = EJBFactory.getConnection((Context)this.ctx);
            prepareStatement = connection.prepareStatement(sql.toString());
            for (int i = 0; i < this.fourmulaFilterList.size(); ++i) {
                FormulaFilterInfo formulaFilterInfo = (FormulaFilterInfo)this.fourmulaFilterList.get(i);
                if (!this.isSameYearPeriod) {
                    int endPeriod;
                    int endYear;
                    int startPeriod;
                    int startYear;
                    String periodStr;
                    if (formulaFilterInfo.getEndYear().equals(String.valueOf(this.periodInfo.getPeriodYear())) && Integer.valueOf(formulaFilterInfo.getEndPeriod()) > this.periodInfo.getPeriodNumber() || Integer.valueOf(formulaFilterInfo.getEndYear()) > this.periodInfo.getPeriodYear()) {
                        formulaFilterInfo.setStartYear(String.valueOf(this.periodInfo.getPeriodYear()));
                        formulaFilterInfo.setStartPeriod(String.valueOf(this.periodInfo.getPeriodNumber()));
                    }
                    if (StringUtils.isEmpty((String)(periodStr = RptUtil.getYearPeriod((int)(startYear = Integer.valueOf(formulaFilterInfo.getStartYear()).intValue()), (int)(startPeriod = Integer.valueOf(formulaFilterInfo.getStartPeriod()).intValue()), (int)(endYear = Integer.valueOf(formulaFilterInfo.getEndYear()).intValue()), (int)(endPeriod = Integer.valueOf(formulaFilterInfo.getEndPeriod()).intValue()))))) continue;
                    periodArray = periodStr.split(",");
                }
                int length = periodArray != null ? periodArray.length : 0;
                int index = 1;
                if (periodArray != null && length > 0) {
                    for (int j = 0; j < length; ++j) {
                        index = 1;
                        if (isMult || !this.isSameOrgUnit || this.isHasCurrency && !this.isSameCurrency) {
                            prepareStatement.setObject(index++, formulaFilterInfo.getStartAccount());
                            prepareStatement.setObject(index++, formulaFilterInfo.getEndAccount());
                            prepareStatement.setObject(index++, Integer.valueOf(periodArray[j]));
                            if (!this.isSameOrgUnit) {
                                prepareStatement.setObject(index++, this.isIncludeNotBizUnit ? formulaFilterInfo.getCompanyLongNumber() : formulaFilterInfo.getCompanyNumber());
                                if (this.isIncludeNotBizUnit) {
                                    prepareStatement.setObject(index++, formulaFilterInfo.isBizUnit() ? 1 : 0);
                                }
                            }
                            if (this.isHasCurrency && !this.isSameCurrency) {
                                prepareStatement.setObject(index++, formulaFilterInfo.getCurrency());
                            }
                            if (this.isGroupByFormula || this.isQueryOwnerCompany) {
                                prepareStatement.setObject(index++, formulaFilterInfo.getFormulaId());
                            }
                            prepareStatement.addBatch();
                            hasParam = true;
                            continue;
                        }
                        if (periodArray == null) continue;
                        this.periodSet.add(periodArray[j]);
                    }
                }
                if (isMult || !this.isSameOrgUnit || this.isHasCurrency && !this.isSameCurrency) continue;
                index = 1;
                prepareStatement.setObject(index++, formulaFilterInfo.getStartAccount());
                prepareStatement.setObject(index++, formulaFilterInfo.getEndAccount());
                if (!this.isSameOrgUnit) {
                    prepareStatement.setObject(index++, this.isIncludeNotBizUnit ? formulaFilterInfo.getCompanyLongNumber() : formulaFilterInfo.getCompanyNumber());
                    if (this.isIncludeNotBizUnit) {
                        prepareStatement.setObject(index++, formulaFilterInfo.isBizUnit() ? 1 : 0);
                    }
                }
                if (this.isHasCurrency && !this.isSameCurrency) {
                    prepareStatement.setObject(index++, formulaFilterInfo.getCurrency());
                }
                if (this.isGroupByFormula || this.isQueryOwnerCompany) {
                    prepareStatement.setObject(index++, formulaFilterInfo.getFormulaId());
                }
                prepareStatement.addBatch();
                hasParam = true;
            }
            if (hasParam) {
                prepareStatement.executeBatch();
                prepareStatement.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, prepareStatement, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)prepareStatement, (Connection)connection);
    }

    private void handleSame(PeriodInfo periodInfo) throws EASBizException, BOSException {
        CurrencyCollection coll;
        String tempCompanyNumber = null;
        String tempCurrency = null;
        HashSet<FormulaFilterInfo> filterInfo = new HashSet<FormulaFilterInfo>();
        HashSet<String> companyNumberSet = new HashSet<String>();
        for (int i = 0; i < this.fourmulaFilterList.size(); ++i) {
            FormulaFilterInfo formulaFilterInfo = (FormulaFilterInfo)this.fourmulaFilterList.get(i);
            if (formulaFilterInfo.getEndYear().equals(String.valueOf(periodInfo.getPeriodYear())) && Integer.valueOf(formulaFilterInfo.getEndPeriod()) > periodInfo.getPeriodNumber() || Integer.valueOf(formulaFilterInfo.getEndYear()) > periodInfo.getPeriodYear()) {
                formulaFilterInfo.setStartYear(String.valueOf(periodInfo.getPeriodYear()));
                formulaFilterInfo.setStartPeriod(String.valueOf(periodInfo.getPeriodNumber()));
            }
            if (i == 0) {
                tempCompanyNumber = formulaFilterInfo.getCompanyNumber();
                tempCurrency = formulaFilterInfo.getCurrency();
            }
            if (this.isSameYearPeriod && formulaFilterInfo.getStartPeriod().equals(formulaFilterInfo.getEndPeriod()) && formulaFilterInfo.getStartYear().equals(formulaFilterInfo.getEndYear())) {
                if (i == 0) {
                    this.samePeriod = formulaFilterInfo.getStartPeriod();
                    this.sameYear = formulaFilterInfo.getStartYear();
                } else if (!this.samePeriod.equals(formulaFilterInfo.getStartPeriod()) || !this.sameYear.equals(formulaFilterInfo.getStartYear())) {
                    this.isSameYearPeriod = false;
                }
            } else {
                this.isSameYearPeriod = false;
            }
            if (tempCompanyNumber != null && !tempCompanyNumber.equals(formulaFilterInfo.getCompanyNumber()) || tempCompanyNumber == null && formulaFilterInfo.getCompanyNumber() != null) {
                this.isSameOrgUnit = false;
            }
            if (tempCurrency != null && !tempCurrency.equals(formulaFilterInfo.getCurrency()) || tempCurrency == null && formulaFilterInfo.getCurrency() != null) {
                this.isSameCurrency = false;
            }
            filterInfo.add(formulaFilterInfo);
            if (StringUtils.isEmpty((String)formulaFilterInfo.getCompanyNumber())) continue;
            companyNumberSet.add(formulaFilterInfo.getCompanyNumber());
        }
        if (this.isProfitCenter) {
            if (this.isSameOrgUnit && !StringUtils.isEmpty(tempCompanyNumber)) {
                if (tempCompanyNumber.equals(this.currentUnit.getNumber())) {
                    this.sameOrgUnit = this.currentUnit;
                } else {
                    String id = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitCollection("select id where number='" + tempCompanyNumber + "'").get(0).getId().toString();
                    this.sameOrgUnit = new CompanyOrgUnitInfo();
                    this.sameOrgUnit.setId(BOSUuid.read((String)id));
                }
            }
        } else {
            CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection("select id,IsOnlyUnion,longNumber,number where number in(" + CslRptUtil.changeIdSet2String(companyNumberSet) + ")");
            if (this.isSameOrgUnit) {
                this.sameOrgUnit = companyColl.get(0);
                if (this.sameOrgUnit == null) {
                    this.sameOrgUnit = new CompanyOrgUnitInfo();
                    this.sameOrgUnit.setId(BOSUuid.create((String)"16FD9F90"));
                } else if (this.sameOrgUnit.isIsOnlyUnion()) {
                    this.isIncludeNotBizUnit = true;
                }
            } else {
                HashMap<String, CompanyOrgUnitInfo> number_company = new HashMap<String, CompanyOrgUnitInfo>();
                for (int i = 0; i < companyColl.size(); ++i) {
                    number_company.put(companyColl.get(i).getNumber(), companyColl.get(i));
                    if (!companyColl.get(i).isIsOnlyUnion()) continue;
                    this.isIncludeNotBizUnit = true;
                }
                String curCompanyNumber = null;
                for (FormulaFilterInfo info : filterInfo) {
                    curCompanyNumber = StringUtils.isEmpty((String)info.getCompanyNumber()) ? this.currentUnit.getNumber() : info.getCompanyNumber();
                    info.setCompanyNumber(curCompanyNumber);
                    if (number_company.get(curCompanyNumber) == null) continue;
                    info.setBizUnit(!((CompanyOrgUnitInfo)number_company.get(curCompanyNumber)).isIsOnlyUnion());
                    info.setCompanyLongNumber(((CompanyOrgUnitInfo)number_company.get(curCompanyNumber)).getLongNumber());
                }
                number_company.clear();
            }
        }
        if (this.isSameCurrency && !StringUtils.isEmpty(tempCurrency) && (coll = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection("select id where number='" + tempCurrency + "'")) != null) {
            this.sameCurrencyId = coll.get(0).getId().toString();
            this.sameCurrencyNumber = tempCurrency;
        }
        companyNumberSet.clear();
        this.fourmulaFilterList.clear();
        this.fourmulaFilterList.addAll(filterInfo);
        filterInfo.clear();
    }

    public Map getMultiFillDate() throws EASBizException, BOSException {
        try {
            this.preHandleParam(true);
            Map map = this.getMultiFillItemData();
            return map;
        }
        finally {
            if (!StringUtils.isEmpty((String)this.tmpTableName) && !DebugLogger.isDebug) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tmpTableName);
                this.tmpTableName = null;
            }
        }
    }

    private Map getMultiFillItemData() throws EASBizException, BOSException {
        this.initAsstActType();
        StringBuffer sql = new StringBuffer();
        sql.append(this.getMultiSql());
        if (DebugLogger.isDebug) {
            LOGGER.error((Object)sql);
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        return this.getMultiResult(rs);
    }

    private Map getMultiResult(IRowSet rs) throws EASBizException, BOSException {
        OneToManyMap result = new OneToManyMap();
        if (rs.size() <= 0) {
            return result;
        }
        AsstActTypeInfo asstActTypeInfo = null;
        IObjectCollection coll = null;
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<String, IObjectValue> tmpMap = new HashMap<String, IObjectValue>();
        String field = null;
        HashMap subTypeFilterMap = new HashMap();
        HashMap<String, Map> uiContext = new HashMap<String, Map>();
        uiContext.put("asstActTypeAttribeAndGroupMap", this.asstActTypeAttribeAndGroupMap);
        uiContext.put("subTypeFilterMap", subTypeFilterMap);
        for (Object obj : this.asstActTypeList) {
            asstActTypeInfo = (AsstActTypeInfo)obj;
            String defaultQueryName = asstActTypeInfo.getDefaultQueryName();
            if (asstActTypeInfo.getAsstHGAttribute().equals("person")) {
                defaultQueryName = "com.kingdee.eas.fi.gr.dynamic.app.AllPositionPersonQuery";
            }
            MetaDataPK queryPK = new MetaDataPK(defaultQueryName);
            QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)queryPK);
            SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
            SubEntityInfo mainEntityInfo = null;
            field = this.getField(asstActTypeInfo);
            if (!(mainObjectInfo instanceof SubEntityInfo) || (mainEntityInfo = (SubEntityInfo)mainObjectInfo) == null || mainEntityInfo.getEntityRef() == null) continue;
            try {
                while (rs.next()) {
                    ids.add(rs.getString(field));
                }
                rs.beforeFirst();
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            IDynamicObject idynaObj = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
            BOSObjectType type = mainEntityInfo.getEntityRef().getType();
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().addObjectCollection((IObjectCollection)this.getSelectorItem(asstActTypeInfo.getMappingFieldName()));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
            try {
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(new FilterInfo());
                DynamicTemplateUtility.setAsstActTypeGroupFilter((Context)this.ctx, (EntityViewInfo)view, (String)asstActTypeInfo.getAsstHGAttribute(), uiContext);
                if (!view.getFilter().getFilterItems().isEmpty()) {
                    IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
                    exec.setObjectView(view);
                    exec.option().isAutoIgnoreZero = true;
                    exec.option().isAutoTranslateBoolean = true;
                    exec.option().isAutoTranslateEnum = true;
                    exec.option().isIgnoreOrder = true;
                    filter.mergeFilter(new FilterInfo(" id in (select id from (" + exec.getSQL() + ") filter)"), "and");
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"setAsstActTypeGroupFilter error", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            ev.setFilter(filter);
            coll = idynaObj.getCollection(type, ev);
            for (int i = 0; i < coll.size(); ++i) {
                tmpMap.put(((DataBaseInfo)coll.getObject(i)).getId().toString(), coll.getObject(i));
            }
            for (String id : ids) {
                result.put(asstActTypeInfo.getAsstHGAttribute(), tmpMap.get(id));
            }
            tmpMap.clear();
            ids.clear();
        }
        return result;
    }

    private SelectorItemCollection getSelectorItem(String mappingFieldName) {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider")) {
            sic.add(new SelectorItemInfo("browseGroup"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
        } else if (mappingFieldName.equals("material")) {
            sic.add(new SelectorItemInfo("materialGroup"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
        } else {
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
        }
        return sic;
    }

    private void initAsstActType() throws EASBizException, BOSException {
        AsstActTypeInfo asstActTypeInfo = null;
        String field = null;
        for (Object asstActType : this.useredAsstActTypes.keySet()) {
            asstActTypeInfo = (AsstActTypeInfo)asstActType;
            field = this.getField(asstActTypeInfo);
            this.asstActType_values.put(field, (List)this.useredAsstActTypes.get(asstActType));
        }
    }

    private String getField(AsstActTypeInfo asstActTypeInfo) {
        String field = null;
        field = asstActTypeInfo.getMappingFieldName() == null ? "F" + asstActTypeInfo.getAsstHGAttribute() + "ID" : asstActTypeInfo.getMappingFieldName();
        return field;
    }

    private void preHandleStartPeriod() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        try {
            this.tmpTableName = pool.createTempTable("create table t_csl_FormulFilter(companyNumber VARCHAR(100),startAccount VARCHAR(100),endAccount VARCHAR(100),currency VARCHAR(100),period VARCHAR(8))");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        PeriodInfo periodInfo = this.getPeriodInfo();
        boolean hasParam = false;
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        try {
            sql.append(" insert into ").append(this.tmpTableName).append("(companyNumber,startAccount,endAccount,currency");
            sql.append(",period) values(?,?,?,?,?) ");
            connection = EJBFactory.getConnection((Context)this.ctx);
            prepareStatement = connection.prepareStatement(sql.toString());
            for (int i = 0; i < this.fourmulaFilterList.size(); ++i) {
                int endPeriod;
                int endYear;
                int startPeriod;
                int startYear;
                String periodStr;
                String[] periodArray;
                int length;
                FormulaFilterInfo formulaFilterInfo = (FormulaFilterInfo)this.fourmulaFilterList.get(i);
                if (formulaFilterInfo.getEndYear().equals(String.valueOf(periodInfo.getPeriodYear())) && Integer.valueOf(formulaFilterInfo.getEndPeriod()) > periodInfo.getPeriodNumber() || Integer.valueOf(formulaFilterInfo.getEndYear()) > periodInfo.getPeriodYear()) {
                    formulaFilterInfo.setStartYear(String.valueOf(periodInfo.getPeriodYear()));
                    formulaFilterInfo.setStartPeriod(String.valueOf(periodInfo.getPeriodNumber()));
                }
                if ((length = (periodArray = (periodStr = RptUtil.getYearPeriod((int)(startYear = Integer.valueOf(formulaFilterInfo.getStartYear()).intValue()), (int)(startPeriod = Integer.valueOf(formulaFilterInfo.getStartPeriod()).intValue()), (int)(endYear = Integer.valueOf(formulaFilterInfo.getEndYear()).intValue()), (int)(endPeriod = Integer.valueOf(formulaFilterInfo.getEndPeriod()).intValue()))).split(",")).length) <= 0) continue;
                for (int j = 0; j < length; ++j) {
                    prepareStatement.setObject(1, formulaFilterInfo.getCompanyNumber());
                    prepareStatement.setObject(2, formulaFilterInfo.getStartAccount());
                    prepareStatement.setObject(3, formulaFilterInfo.getEndAccount());
                    prepareStatement.setObject(4, formulaFilterInfo.getCurrency());
                    prepareStatement.setObject(5, periodArray[j]);
                    prepareStatement.addBatch();
                    hasParam = true;
                }
            }
            if (hasParam) {
                prepareStatement.executeBatch();
                prepareStatement.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, prepareStatement, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)prepareStatement, (Connection)connection);
    }

    private void getFillItemData() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getExecutesql());
        if (DebugLogger.isDebug) {
            LOGGER.error((Object)sql);
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs != null) {
                while (rs.next()) {
                    if (StringUtils.isEmpty((String)rs.getString("ID"))) continue;
                    this.fillItemSet.add(rs.getString("ID"));
                }
            }
        }
        catch (SQLException e) {
            this.isExecuteError = true;
            this.exception = e;
            LOGGER.error((Object)"getFillItemData", (Throwable)e);
        }
    }

    private StringBuffer getMultiSql() throws EASBizException, BOSException {
        StringBuffer sBuf = new StringBuffer("select distinct ");
        String curField = null;
        HashMap<String, AsstActTypeInfo> field_AsstAct = new HashMap<String, AsstActTypeInfo>();
        for (Object obj : this.asstActTypeList) {
            curField = this.getField((AsstActTypeInfo)obj);
            sBuf.append("A_Hg.").append(curField).append(" as ").append(curField).append(",");
            sBuf.append(((AsstActTypeInfo)obj).getAsstHGAttribute()).append(".fnumber,");
            field_AsstAct.put(curField, (AsstActTypeInfo)obj);
        }
        sBuf.deleteCharAt(sBuf.lastIndexOf(","));
        sBuf.append(" from T_BD_AssistantHG A_Hg  \n");
        String realtionTable = null;
        String tableAsName = null;
        String numberInStr = null;
        String field = null;
        for (Object obj : this.asstActTypeList) {
            field = this.getField((AsstActTypeInfo)obj);
            tableAsName = ((AsstActTypeInfo)field_AsstAct.get(field)).getAsstHGAttribute();
            realtionTable = ((AsstActTypeInfo)field_AsstAct.get(field)).getRealtionDataObject();
            sBuf.append(this.asstActType_values.containsKey(field) ? " inner join " : " left join ").append(realtionTable).append(" ").append(tableAsName).append(" on ").append(tableAsName).append(".fid=A_Hg.").append(field);
            if (this.asstActType_values.get(field) == null || this.asstActType_values.get(field).isEmpty() || StringUtils.isEmpty((String)(numberInStr = CslRptUtil.list2String(this.asstActType_values.get(field), ",", true))) || StringUtils.isEmpty((String)numberInStr.replaceAll("'", "").trim())) continue;
            sBuf.append(" and ").append(tableAsName).append(".fnumber in (").append(CslRptUtil.list2String(this.asstActType_values.get(field), ",", true)).append(")  \n");
        }
        sBuf.append(" inner join " + this.glAssistBalTable + " A_Bal on A_Bal.FAssistGrpID = A_Hg.fid  \n");
        sBuf.append("inner join (select account1.* from T_BD_AccountView isNotLeaf, ").append(this.tmpTableName).append(" accountA ");
        sBuf.append(", T_BD_AccountView  account1 ");
        if (!this.isProfitCenter && this.isSameOrgUnit && this.isIncludeNotBizUnit) {
            sBuf.append(", t_org_company  company1 ");
        }
        sBuf.append(" where isNotLeaf.fnumber>=accountA.startAccount and ");
        sBuf.append(" isNotLeaf.fnumber<=accountA.endAccount and isNotLeaf.fisleaf<>1 and account1.fnumber like concat(isNotLeaf.fnumber,'%') ");
        sBuf.append(" and isNotLeaf.FCompanyID = account1.FCompanyID and isNotLeaf.FAccountTableID = account1.FAccountTableID ");
        if (!this.isProfitCenter) {
            if (this.isSameOrgUnit && !this.isIncludeNotBizUnit) {
                sBuf.append(" and isNotLeaf.FCompanyID ='").append(this.sameOrgUnit.getId().toString()).append("'");
            } else if (this.isSameOrgUnit && this.isIncludeNotBizUnit) {
                sBuf.append(" and company1.fid=isNotLeaf.FCompanyID ");
                sBuf.append(" and company1.flongNumber like '" + this.sameOrgUnit.getLongNumber() + "!%' and company1.FIsBizUnit=1 ");
            }
        }
        sBuf.append(" union ");
        sBuf.append("select leaf.* from T_BD_AccountView leaf, ").append(this.tmpTableName).append(" accountB ");
        if (!this.isProfitCenter && this.isSameOrgUnit && this.isIncludeNotBizUnit) {
            sBuf.append(", t_org_company  company2 ");
        }
        sBuf.append(" where leaf.fnumber>=accountB.startAccount and leaf.fnumber<=accountB.endAccount ");
        if (!this.isProfitCenter) {
            if (this.isSameOrgUnit && !this.isIncludeNotBizUnit) {
                sBuf.append(" and leaf.FCompanyID ='").append(this.sameOrgUnit.getId().toString()).append("'");
            } else if (this.isSameOrgUnit && this.isIncludeNotBizUnit) {
                sBuf.append(" and company2.fid=leaf.FCompanyID ");
                sBuf.append(" and company2.flongNumber like '" + this.sameOrgUnit.getLongNumber() + "!%' and company2.FIsBizUnit=1 ");
            }
        }
        sBuf.append(" and leaf.fisleaf=1) accountV on accountV.FID = A_Bal.fAccountid \n");
        if (this.isHasCurrency && !this.isSameCurrency) {
            sBuf.append(" inner join T_BD_Currency currency on currency.FID = A_Bal.fcurrencyid   \n");
        }
        if (!this.isSameOrgUnit || this.isIncludeNotBizUnit) {
            sBuf.append(" inner join ").append(this.isProfitCenter ? "T_ORG_BaseUnit" : "t_org_company").append(" baseunit on baseunit.FID =").append(this.isProfitCenter ? "A_Bal.FProfitCenterID" : "A_Bal.forgunitid");
        }
        if (this.isHasCurrency && !this.isSameCurrency || !this.isSameOrgUnit || !this.isSameYearPeriod && this.periodSet.isEmpty()) {
            sBuf.append(" inner join ").append(this.tmpTableName).append(" as filter on ( 1=1 ");
            if (!this.isSameYearPeriod && this.periodSet.isEmpty()) {
                sBuf.append(" and filter.period = A_Bal.fperiod ");
            }
            if (this.isHasCurrency && !this.isSameCurrency) {
                sBuf.append(" and currency.fnumber = filter.currency ");
            }
            if (!this.isSameOrgUnit) {
                if (!this.isIncludeNotBizUnit) {
                    sBuf.append(" and filter.companyNumber = baseunit.fnumber ");
                } else {
                    sBuf.append(" and (baseunit.flongNumber like concat(filter.companyNumber,'!%') and filter.isBizUnit=0 ");
                    sBuf.append(" or baseunit.flongNumber=filter.companyNumber and filter.isBizUnit=1 )");
                }
            }
            sBuf.append("  ) \n");
        }
        sBuf.append(" where 1=1 ");
        if (this.isHasCurrency && this.isSameCurrency) {
            sBuf.append(" and A_Bal.fcurrencyid='").append(this.sameCurrencyId).append("'");
        }
        if (this.isSameOrgUnit) {
            if (this.isIncludeNotBizUnit) {
                sBuf.append(" and baseunit.flongNumber like '" + this.sameOrgUnit.getLongNumber() + "!%' and baseunit.FIsBizUnit=1 ");
            } else {
                sBuf.append(" and ").append(this.isProfitCenter ? "A_Bal.FProfitCenterID='" : "A_Bal.forgunitid='").append(this.sameOrgUnit.getId().toString()).append("'");
            }
        }
        if (this.isSameYearPeriod) {
            String periodStr = RptUtil.getYearPeriod((int)Integer.valueOf(this.sameYear), (int)Integer.valueOf(this.samePeriod), (int)Integer.valueOf(this.sameYear), (int)Integer.valueOf(this.samePeriod));
            String[] periodArray = periodStr.split(",");
            sBuf.append(" and A_Bal.fperiod=").append(periodArray[0]);
        }
        if (!this.periodSet.isEmpty()) {
            sBuf.append(" and A_Bal.fperiod in (").append(CslRptUtil.collection2String(this.periodSet, ",", false)).append(")");
        }
        sBuf.append(" order by ");
        int k = 0;
        for (Object obj : this.asstActTypeList) {
            curField = this.getField((AsstActTypeInfo)obj);
            if (k != 0) {
                sBuf.append(",");
            }
            tableAsName = ((AsstActTypeInfo)field_AsstAct.get(curField)).getAsstHGAttribute();
            sBuf.append(tableAsName).append(".fnumber");
            ++k;
        }
        sBuf.append(" asc ");
        return sBuf;
    }

    private StringBuffer getExecutesql() throws EASBizException, BOSException {
        boolean isDyAutoFillByFilter = true;
        if (!StringUtils.isEmpty((String)this.dynItemSql)) {
            try {
                isDyAutoFillByFilter = !CslRptUtil.getCslParam(this.ctx, "ISDYAUTOFILLBYNOTFILTER");
            }
            catch (Exception e) {
                LOGGER.error((Object)"getCslParam error", (Throwable)e);
                isDyAutoFillByFilter = true;
            }
        } else {
            isDyAutoFillByFilter = false;
        }
        StringBuffer sBuf = new StringBuffer();
        this.buildSelect(sBuf);
        if (isDyAutoFillByFilter) {
            DynItemFillSqlParse sqlParse = new DynItemFillSqlParse(this.dynItemSql);
            sqlParse.parseSql();
            String bodySql = sqlParse.getOtherExcludeorder();
            sBuf.append(" from ( ");
            sBuf.append(bodySql);
            sBuf.append(") fillItemTbl ");
            sBuf.append("inner join T_BD_AssistantHG A_Hg on A_Hg.").append(this.fieldHg).append(" = fillItemTbl.ID  \n");
        } else {
            sBuf.append("from T_BD_AssistantHG A_Hg  \n");
        }
        sBuf.append(" inner join " + this.glAssistBalTable + " A_Bal on A_Bal.FAssistGrpID = A_Hg.fid  \n");
        sBuf.append("inner join (select account1.fid ").append(this.isGroupByFormula || this.isQueryOwnerCompany ? ",accountA.formulaId" : "");
        sBuf.append("    from T_BD_AccountView isNotLeaf, ").append(this.tmpTableName).append(" accountA,T_ORG_BASEUNIT UNIT");
        sBuf.append(",   T_BD_AccountView  account1 ");
        if (!this.isProfitCenter && this.isSameOrgUnit && this.isIncludeNotBizUnit) {
            sBuf.append(", t_org_company  company1 ");
        }
        sBuf.append(" where isNotLeaf.fnumber>=accountA.startAccount and ");
        sBuf.append(" isNotLeaf.fnumber<=accountA.endAccount and isNotLeaf.fisleaf=0 and account1.fnumber like concat(isNotLeaf.fnumber,'%') ");
        sBuf.append(" and isNotLeaf.FCompanyID = account1.FCompanyID and isNotLeaf.FAccountTableID = account1.FAccountTableID ");
        sBuf.append(" and UNIT.FID=isNotLeaf.FCOMPANYID ");
        if (this.isSameOrgUnit) {
            if (!this.isIncludeNotBizUnit && !this.isQueryOwnerCompany) {
                sBuf.append(" and UNIT.fid='").append(this.sameOrgUnit.getId().toString()).append("' ");
            }
        } else {
            sBuf.append(" and accountA.COMPANYNUMBER=UNIT.FNUMBER");
        }
        if (!this.isProfitCenter) {
            if (this.isSameOrgUnit && !this.isIncludeNotBizUnit) {
                if (!this.isQueryOwnerCompany) {
                    sBuf.append(" and isNotLeaf.FCompanyID ='").append(this.sameOrgUnit.getId().toString()).append("'");
                }
            } else if (this.isSameOrgUnit && this.isIncludeNotBizUnit) {
                sBuf.append(" and company1.fid=isNotLeaf.FCompanyID ");
                sBuf.append(" and company1.flongNumber like '" + this.sameOrgUnit.getLongNumber() + "!%' and company1.FIsBizUnit=1 ");
            }
        }
        sBuf.append(" union ");
        sBuf.append("select leaf.fid ").append(this.isGroupByFormula || this.isQueryOwnerCompany ? ",accountB.formulaId" : "");
        sBuf.append("  from T_BD_AccountView leaf, ").append(this.tmpTableName).append(" accountB ");
        if (!this.isProfitCenter && this.isSameOrgUnit && this.isIncludeNotBizUnit) {
            sBuf.append(", t_org_company  company2 ");
        }
        sBuf.append(" where leaf.fnumber>=accountB.startAccount and leaf.fnumber<=accountB.endAccount ");
        if (!this.isProfitCenter) {
            if (this.isSameOrgUnit && !this.isIncludeNotBizUnit) {
                if (!this.isQueryOwnerCompany) {
                    sBuf.append(" and leaf.FCompanyID ='").append(this.sameOrgUnit.getId().toString()).append("'");
                }
            } else if (this.isSameOrgUnit && this.isIncludeNotBizUnit) {
                sBuf.append(" and company2.fid=leaf.FCompanyID ");
                sBuf.append(" and company2.flongNumber like '" + this.sameOrgUnit.getLongNumber() + "!%' and company2.FIsBizUnit=1 ");
            }
        }
        sBuf.append(" and leaf.fisleaf=1) accountV on accountV.FID = A_Bal.fAccountid \n");
        if (this.isHasCurrency && !this.isSameCurrency) {
            sBuf.append(" inner join T_BD_Currency currency on currency.FID = A_Bal.fcurrencyid   \n");
        }
        if (!this.isSameOrgUnit || this.isIncludeNotBizUnit) {
            sBuf.append(" inner join ").append(this.isProfitCenter ? "T_ORG_BaseUnit" : "t_org_company").append(" baseunit on baseunit.FID =").append(this.isProfitCenter ? "A_Bal.FProfitCenterID" : "A_Bal.forgunitid");
        }
        if (this.isHasCurrency && !this.isSameCurrency || !this.isSameOrgUnit || !this.isSameYearPeriod && this.periodSet.isEmpty()) {
            sBuf.append(" inner join ").append(this.tmpTableName).append(" as filter on ( 1=1 ");
            if (!this.isSameYearPeriod && this.periodSet.isEmpty()) {
                sBuf.append(" and filter.period = A_Bal.fperiod ");
            }
            if (this.isHasCurrency && !this.isSameCurrency) {
                sBuf.append(" and currency.fnumber = filter.currency ");
            }
            if (!this.isSameOrgUnit) {
                if (!this.isIncludeNotBizUnit) {
                    sBuf.append(" and filter.companyNumber = baseunit.fnumber ");
                } else {
                    sBuf.append(" and (baseunit.flongNumber like concat(filter.companyNumber,'!%') and filter.isBizUnit=0 ");
                    sBuf.append(" or baseunit.flongNumber=filter.companyNumber and filter.isBizUnit=1 )");
                }
            }
            sBuf.append("  ) \n");
        }
        sBuf.append(" where 1=1 ");
        if (this.isHasCurrency && this.isSameCurrency) {
            sBuf.append(" and A_Bal.fcurrencyid='").append(this.sameCurrencyId).append("'");
        }
        if (this.isSameOrgUnit) {
            if (this.isIncludeNotBizUnit) {
                sBuf.append(" and baseunit.flongNumber like '" + this.sameOrgUnit.getLongNumber() + "!%' and baseunit.FIsBizUnit=1 ");
            } else if (this.isQueryOwnerCompany) {
                if (this.attribute.equals("customer")) {
                    sBuf.append(" and ").append(" A_Hg.").append(this.fieldHg).append(" = (Select fid from T_BD_Customer Where FInternalCompanyID = '").append(this.sameOrgUnit.getId().toString()).append("') \n");
                } else if (this.attribute.equals("provider")) {
                    sBuf.append(" and ").append(" A_Hg.").append(this.fieldHg).append(" = (Select fid from T_BD_Supplier Where FInternalCompanyID = '").append(this.sameOrgUnit.getId().toString()).append("') \n");
                } else {
                    sBuf.append(" and ").append(" A_Hg.").append(this.fieldHg).append(" = '").append(this.sameOrgUnit.getId().toString()).append("' \n");
                }
            } else {
                sBuf.append(" and ").append(this.isProfitCenter ? "A_Bal.FProfitCenterID='" : "A_Bal.forgunitid='").append(this.sameOrgUnit.getId().toString()).append("'");
            }
        }
        if (this.isSameYearPeriod) {
            String periodStr = RptUtil.getYearPeriod((int)Integer.valueOf(this.sameYear), (int)Integer.valueOf(this.samePeriod), (int)Integer.valueOf(this.sameYear), (int)Integer.valueOf(this.samePeriod));
            String[] periodArray = periodStr.split(",");
            sBuf.append(" and A_Bal.fperiod=").append(periodArray[0]);
        }
        if (!this.periodSet.isEmpty()) {
            sBuf.append(" and A_Bal.fperiod in (").append(CslRptUtil.collection2String(this.periodSet, ",", false)).append(")");
        }
        this.buildGroup(sBuf);
        return sBuf;
    }

    private void buildSelect(StringBuffer sBuf) throws EASBizException, BOSException {
        if (this.isSameCurrency && this.isSameOrgUnit && this.isSameYearPeriod && !StringUtils.isEmpty((String)this.balType)) {
            int srcLen = sBuf.length();
            if ("GLC".equals(this.sameCurrencyNumber)) {
                if (this.isQueryOwnerCompany) {
                    String orgField;
                    String string = orgField = this.isProfitCenter ? "A_Bal.FProfitCenterID" : "A_Bal.forgunitid";
                    if (this.balType.equalsIgnoreCase("JY")) {
                        sBuf.append("select distinct fassistId as ID from (");
                        sBuf.append(" select ").append(orgField).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceLocal) JY ");
                    } else if (this.balType.equalsIgnoreCase("DY")) {
                        sBuf.append("select distinct fassistId as ID from (");
                        sBuf.append(" select ").append(orgField).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceLocal) DY ");
                    }
                } else if (this.balType.equalsIgnoreCase("JY")) {
                    sBuf.append("select distinct fassistId as ID from (");
                    sBuf.append(" select A_Hg.").append(this.fieldHg).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceLocal) JY ");
                } else if (this.balType.equalsIgnoreCase("DY")) {
                    sBuf.append("select distinct fassistId as ID from (");
                    sBuf.append(" select A_Hg.").append(this.fieldHg).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceLocal) DY ");
                }
                if (this.balType.equalsIgnoreCase("JY")) {
                    sBuf.append("select distinct fassistId as ID from (");
                    sBuf.append(" select A_Hg.").append(this.fieldHg).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceLocal) JY ");
                } else if (this.balType.equalsIgnoreCase("DY")) {
                    sBuf.append("select distinct fassistId as ID from (");
                    sBuf.append(" select A_Hg.").append(this.fieldHg).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceLocal) DY ");
                }
            } else if ("GRC".equals(this.sameCurrencyNumber)) {
                if (this.isQueryOwnerCompany) {
                    String orgField;
                    String string = orgField = this.isProfitCenter ? "A_Bal.FProfitCenterID" : "A_Bal.forgunitid";
                    if (this.balType.equalsIgnoreCase("JY")) {
                        sBuf.append("select distinct fassistId as ID from (");
                        sBuf.append(" select ").append(orgField).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceRpt) JY ");
                    } else if (this.balType.equalsIgnoreCase("DY")) {
                        sBuf.append("select distinct fassistId as ID from (");
                        sBuf.append(" select ").append(orgField).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceRpt) DY ");
                    }
                } else if (this.balType.equalsIgnoreCase("JY")) {
                    sBuf.append("select distinct fassistId as ID from (");
                    sBuf.append(" select A_Hg.").append(this.fieldHg).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceRpt) JY ");
                } else if (this.balType.equalsIgnoreCase("DY")) {
                    sBuf.append("select distinct fassistId as ID from (");
                    sBuf.append(" select A_Hg.").append(this.fieldHg).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceRpt) DY ");
                }
            } else {
                String orgField;
                String string = orgField = this.isProfitCenter ? "A_Bal.FProfitCenterID" : "A_Bal.forgunitid";
                if (this.isQueryOwnerCompany) {
                    if (this.balType.equalsIgnoreCase("JY")) {
                        sBuf.append("select distinct fassistId as ID from (");
                        sBuf.append(" select ").append(orgField).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceFor) JY ");
                    } else if (this.balType.equalsIgnoreCase("DY")) {
                        sBuf.append("select distinct fassistId as ID from (");
                        sBuf.append(" select ").append(orgField).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceFor) DY ");
                    }
                } else if (this.balType.equalsIgnoreCase("JY")) {
                    sBuf.append("select distinct fassistId as ID from (");
                    sBuf.append(" select A_Hg.").append(this.fieldHg).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceFor) JY ");
                } else if (this.balType.equalsIgnoreCase("DY")) {
                    sBuf.append("select distinct fassistId as ID from (");
                    sBuf.append(" select A_Hg.").append(this.fieldHg).append(" fassistId,A_Bal.FAccountID AccountID,SUM(A_Bal.FEndBalanceFor) DY ");
                }
            }
            boolean bl = this.isQueryByBalType = sBuf.length() > srcLen;
        }
        if (!this.isQueryByBalType) {
            String orgField;
            String string = orgField = this.isProfitCenter ? "A_Bal.FProfitCenterID" : "A_Bal.forgunitid";
            if (this.isQueryOwnerCompany) {
                sBuf.append("select distinct ");
                sBuf.append(orgField).append(" as ID ");
                sBuf.append(",accountV.formulaId ");
            } else {
                sBuf.append("select distinct A_Hg.");
                sBuf.append(this.fieldHg).append(" as ID ");
                if (this.isGroupByFormula) {
                    sBuf.append(",accountV.formulaId ");
                }
            }
        }
    }

    private void buildGroup(StringBuffer sBuf) throws EASBizException, BOSException {
        if (this.isQueryByBalType) {
            if (this.isQueryOwnerCompany) {
                String orgField = this.isProfitCenter ? "A_Bal.FProfitCenterID" : "A_Bal.forgunitid";
                sBuf.append(" group by A_Bal.FAccountID,").append(orgField);
                sBuf.append(") balTypeTable ");
            } else {
                sBuf.append(" group by A_Bal.FAccountID,A_Hg.").append(this.fieldHg);
                sBuf.append(") balTypeTable ");
            }
            if (this.balType.equalsIgnoreCase("JY")) {
                sBuf.append(" where JY>0 ");
            } else if (this.balType.equalsIgnoreCase("DY")) {
                sBuf.append(" where DY<0 ");
            }
        }
    }

    @Override
    public Set<String> getFillItemSet() {
        return this.fillItemSet;
    }

    @Override
    public Map<String, Set<String>> getFillItemMap() {
        return this.fillItemMap;
    }

    @Override
    public boolean isExecuteError() {
        return this.isExecuteError;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    private Set<String> getCompanyNumbers() throws EASBizException, BOSException {
        HashSet<String> companyNumberSet = new HashSet<String>();
        for (int i = 0; i < this.fourmulaFilterList.size(); ++i) {
            FormulaFilterInfo formulaFilterInfo = (FormulaFilterInfo)this.fourmulaFilterList.get(i);
            if (StringUtils.isEmpty((String)formulaFilterInfo.getCompanyNumber())) continue;
            companyNumberSet.add(formulaFilterInfo.getCompanyNumber());
        }
        return companyNumberSet;
    }

    private PeriodInfo getPeriodInfo() throws EASBizException, BOSException {
        Set<String> companyNumbers = this.getCompanyNumbers();
        if (companyNumbers == null || companyNumbers.isEmpty()) {
            return this.getPeriodInfo(this.currentUnit);
        }
        if (companyNumbers.size() == 1 && this.currentUnit.getNumber() != null && this.currentUnit.getNumber().equals(companyNumbers.iterator().next())) {
            return this.getPeriodInfo(this.currentUnit);
        }
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection("select id,number,name,longnumber,isBizUnit,isProfitOrgUnit,isCompanyOrgUnit  where number in(" + CslRptUtil.changeIdSet2String(companyNumbers) + ")");
        PeriodInfo periodInfo = null;
        Exception curException = null;
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo orgUnit = companyColl.get(i);
            if (this.isProfitCenter) {
                orgUnit.setString("srcOrgUnitId", orgUnit.getId().toString());
            }
            try {
                PeriodInfo curPeriod = this.getPeriodInfo(orgUnit);
                if (periodInfo != null && periodInfo.getNumber() <= curPeriod.getNumber()) continue;
                periodInfo = curPeriod;
                continue;
            }
            catch (Exception ex) {
                LOGGER.error((Object)(orgUnit.getName() + " error."), (Throwable)ex);
                curException = ex;
            }
        }
        if (periodInfo == null) {
            if (curException != null) {
                throw new BOSException(curException);
            }
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"23_AcctUtils", (Locale)this.ctx.getOriginLocale())});
        }
        return periodInfo;
    }

    private PeriodInfo getPeriodInfo(CompanyOrgUnitInfo orgUnit) throws EASBizException, BOSException {
        String companyID = orgUnit.getId().toString();
        PeriodInfo periodInfo = null;
        if (this.isProfitCenter && !StringUtils.isEmpty((String)orgUnit.getString("srcOrgUnitId")) && orgUnit.isIsBizUnit()) {
            periodInfo = PcaUtils.getCurrentPeriod((Context)this.ctx, (String)orgUnit.getString("srcOrgUnitId"));
            return periodInfo;
        }
        if (orgUnit.isIsBizUnit()) {
            periodInfo = GlUtils.getCurrentPeriod((Context)this.ctx, (String)companyID);
        } else {
            if (orgUnit.isIsProfitOrgUnit() && !this.isProfitCenter && orgUnit.isIsCompanyOrgUnit()) {
                orgUnit.setIsProfitOrgUnit(false);
            }
            periodInfo = AcctUtils.getSubCompanyMinCurrentPeriod((Context)this.ctx, (CompanyOrgUnitInfo)orgUnit);
        }
        return periodInfo;
    }

    public boolean isQueryOwnerCompany() {
        return this.isQueryOwnerCompany;
    }

    public void setQueryOwnerCompany(boolean isQueryOwnerCompany) {
        this.isQueryOwnerCompany = isQueryOwnerCompany;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }
}

