/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CompanyTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.InvestItemDCRuleEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractEliminateByMainCostControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CslElimUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.InvestDayUtilForMainCost;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EliminateByMainCostControllerBean
extends AbstractEliminateByMainCostControllerBean {
    private static final BigDecimal ZERO = new BigDecimal("0");
    private static final BigDecimal ONE = new BigDecimal("1");
    private static final String KEY_CURRENCY = "KeyCurrency";
    private static final String KEY_COMPANY = "KeyCompany";
    private static final String KEY_ITEM = "KeyItem";
    private static final String KEY_FROM_COMPANY_ZERO = "KeyFromCompanyZero";
    private static final String KEY_TARGET_COMPANY = "KeyTargetCompany";
    private static final String KEY_FROM_COMPANY = "KeyFromCompany";
    private static final String COST_MAIN_TEMPLATEID = "00000000-1111111-00000001111";

    private void mergeElimination(Context ctx, Map mapElimination, List investDayCl, String companyId, String targetCompanyId, InvestTempletEntryInfo templetEntry, String summary, Map mapParams) throws BOSException, EASBizException {
        if (investDayCl == null || investDayCl.isEmpty()) {
            return;
        }
        int dataElement = templetEntry.getDataElement();
        InvestItemDCRuleEnum dcRule = templetEntry.getDcType();
        String strCompanyID = templetEntry.getCompanyType().equals((Object)CompanyTypeEnum.FROM_INVEST) ? companyId : targetCompanyId;
        RPTItemInfo item = null;
        if (templetEntry.isIsUserDefinded()) {
            if (templetEntry.getItem() == null || templetEntry.getItem().length() == 0) {
                return;
            }
            item = this.getItemByID(ctx, templetEntry.getItem(), mapParams);
        } else {
            item = this.getRptItemByCtrlAttr(ctx, templetEntry.getControlAttr(), mapParams);
        }
        int size = investDayCl.size();
        for (int i = 0; i < size; ++i) {
            String strItemID;
            Map mapInvestDay = (Map)investDayCl.get(i);
            dataElement = templetEntry.getDataElement();
            BigDecimal bdValue = (BigDecimal)mapInvestDay.get("Value");
            if (bdValue == null || bdValue.compareTo(ZERO) == 0) continue;
            String currencyId = (String)mapInvestDay.get("KEY_CURRENCY_ID");
            RPTItemInfo tmpItem = item;
            if (mapInvestDay.containsKey("RPTITEM_ID") && (tmpItem = this.getItemByID(ctx, strItemID = (String)mapInvestDay.get("RPTITEM_ID"), mapParams)).getControl().equals((Object)RPTItemControlEnum.UNSHARED_PROFIT)) {
                tmpItem = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.UNALLOTGAIN_SYEAR, mapParams);
                dataElement = 3;
            }
            String templetId = templetEntry.getTemplet().getId().toString();
            this.mergeElimEntry(ctx, mapElimination, strCompanyID, currencyId, templetId, tmpItem, dataElement, dcRule, bdValue, summary, mapParams);
        }
    }

    private void mergeElimEntry(Context ctx, Map mapElimination, String companyId, String currencyId, String templetId, RPTItemInfo item, int dataElement, InvestItemDCRuleEnum dcRule, BigDecimal value, String summary, Map mapParams) throws EASBizException, BOSException {
        EliminationInfo elimination = null;
        FullOrgUnitInfo company = this.getCompanyByID(ctx, companyId, mapParams);
        if (!mapElimination.containsKey(currencyId)) {
            elimination = new EliminationInfo();
            elimination.setSourceCurrency(this.getCurrencyByID(ctx, currencyId, mapParams));
            elimination.setCurrency(this.getCurrencyByID(ctx, currencyId, mapParams));
            elimination.setOrgBound((OrgTreeInfo)mapParams.get("KeyOrgTree"));
            elimination.setOrgUnit((OrgUnitInfo)mapParams.get("KeyOrgUnit"));
            int iPeriodType = (Integer)mapParams.get("PeriodType");
            elimination.setPeriodType(RptPeriodTypeEnum.getEnum((int)iPeriodType));
            int iYear = (Integer)mapParams.get("Year");
            elimination.setYear(iYear);
            int iPeriod = (Integer)mapParams.get("Period");
            elimination.setPeriod(iPeriod);
            elimination.setElimType(ElimTypeEnum.MAIN_COST);
            java.util.Date rptDate = (java.util.Date)mapParams.get("Day");
            elimination.setDate(rptDate);
            elimination.setTempletID(templetId);
            elimination.getEntries().add(this.getElimEntryInfo(ctx, item, dataElement, company, value, dcRule, summary));
            mapElimination.put(currencyId, elimination);
        } else {
            boolean isFind = false;
            elimination = (EliminationInfo)mapElimination.get(currencyId);
            int n = elimination.getEntries().size();
            for (int j = 0; j < n; ++j) {
                EliminationEntryInfo elimEntryInfo = elimination.getEntries().get(j);
                if (!elimEntryInfo.getCompany().getId().toString().equals(companyId) || !elimEntryInfo.getItem().getId().equals((Object)item.getId()) || elimEntryInfo.getDataElement() != dataElement || !elimEntryInfo.isIsVisible()) continue;
                this.setDCValue(dcRule, value, elimEntryInfo.getItem(), elimEntryInfo);
                isFind = true;
                break;
            }
            if (!isFind) {
                elimination.getEntries().add(this.getElimEntryInfo(ctx, item, dataElement, company, value, dcRule, summary));
            }
        }
        if (mapParams.get("displayTypeId") != null) {
            TemplateTypeInfo type = new TemplateTypeInfo();
            type.setId(BOSUuid.read((String)mapParams.get("displayTypeId").toString()));
            elimination.setDisplayTemplateType(type);
        }
    }

    private EliminationEntryInfo getElimEntryInfo(Context ctx, RPTItemInfo item, int dataElement, FullOrgUnitInfo company, BigDecimal bdValue, InvestItemDCRuleEnum dcRule, String summary) throws BOSException, EASBizException {
        EliminationEntryInfo elimEntryInfo = new EliminationEntryInfo();
        elimEntryInfo.setCompany(company);
        this.setDCValue(dcRule, bdValue, item, elimEntryInfo);
        elimEntryInfo.setItem(item);
        elimEntryInfo.setDataElement(dataElement);
        elimEntryInfo.setSummary(summary);
        elimEntryInfo.setIsVisible(true);
        return elimEntryInfo;
    }

    private void setDCValue(InvestItemDCRuleEnum dcRule, BigDecimal value, RPTItemInfo item, EliminationEntryInfo elimEntryInfo) {
        switch (dcRule.getValue()) {
            case 1: {
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
            case 2: {
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 5: {
                if (value.compareTo(ZERO) > 0) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                value = value.negate();
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 6: {
                if (value.compareTo(ZERO) > 0) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                value = value.negate();
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
            case 3: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
            case 4: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 7: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    if (value.compareTo(ZERO) > 0) {
                        this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                        break;
                    }
                    value = value.negate();
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                if (value.compareTo(ZERO) > 0) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                value = value.negate();
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 8: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    if (value.compareTo(ZERO) > 0) {
                        this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                        break;
                    }
                    value = value.negate();
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                if (value.compareTo(ZERO) > 0) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                value = value.negate();
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
        }
    }

    private void addDCValue(EliminationEntryInfo elimEntryInfo, BigDecimal bdValue, DebitOrCreditEnum dc) {
        BigDecimal credit;
        BigDecimal debit = elimEntryInfo.getDebit() != null ? elimEntryInfo.getDebit() : ZERO;
        BigDecimal bigDecimal = credit = elimEntryInfo.getCredit() != null ? elimEntryInfo.getCredit() : ZERO;
        if (dc.equals((Object)DebitOrCreditEnum.DEBIT)) {
            debit = debit.add(bdValue);
        } else {
            credit = credit.add(bdValue);
        }
        BigDecimal diff = debit.subtract(credit);
        if (diff.compareTo(ZERO) > 0) {
            debit = diff;
            credit = null;
        } else {
            debit = null;
            credit = diff.negate();
        }
        elimEntryInfo.setDebit(debit);
        elimEntryInfo.setCredit(credit);
    }

    private RPTItemInfo getRptItemByCtrlAttr(Context ctx, RPTItemControlEnum ctrlAttr, Map mapParams) throws BOSException, EASBizException {
        RPTItemInfo item;
        HashMap<RPTItemControlEnum, RPTItemInfo> items = (HashMap<RPTItemControlEnum, RPTItemInfo>)mapParams.get(KEY_ITEM);
        if (items == null) {
            items = new HashMap<RPTItemControlEnum, RPTItemInfo>(32);
            mapParams.put(KEY_ITEM, items);
        }
        if ((item = (RPTItemInfo)items.get((Object)ctrlAttr)) == null) {
            String strOql;
            IRPTItem iitem = RPTItemFactory.getLocalInstance(ctx);
            if (iitem.exists(strOql = "select * where isFreezed = 0 and control = " + ctrlAttr.getValue())) {
                try {
                    item = iitem.getRPTItemInfo(strOql);
                }
                catch (BOSException e) {
                    throw new ServerException(ServerException.MANY_RECORD_RPTITEM, new Object[]{ctrlAttr.getAlias()});
                }
            } else {
                throw new ServerException(ServerException.NOT_FOUND_RPTITEM, new Object[]{ctrlAttr.getAlias()});
            }
            items.put(ctrlAttr, item);
        }
        return item;
    }

    private RPTItemInfo getItemByID(Context ctx, String itemId, Map mapParams) throws BOSException, EASBizException {
        RPTItemInfo item;
        HashMap<String, RPTItemInfo> items = (HashMap<String, RPTItemInfo>)mapParams.get(KEY_ITEM);
        if (items == null) {
            items = new HashMap<String, RPTItemInfo>(32);
            mapParams.put(KEY_ITEM, items);
        }
        if ((item = (RPTItemInfo)items.get(itemId)) == null) {
            IRPTItem iitem = RPTItemFactory.getLocalInstance(ctx);
            item = iitem.getRPTItemInfo(" where id = '" + itemId + "' and isFreezed = 0");
            items.put(itemId, item);
        }
        return item;
    }

    private FullOrgUnitInfo getCompanyByID(Context ctx, String companyId, Map mapParams) throws BOSException, EASBizException {
        FullOrgUnitInfo company;
        if (StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        HashMap<String, FullOrgUnitInfo> companys = (HashMap<String, FullOrgUnitInfo>)mapParams.get(KEY_COMPANY);
        if (companys == null) {
            companys = new HashMap<String, FullOrgUnitInfo>(32);
            mapParams.put(KEY_COMPANY, companys);
        }
        if ((company = (FullOrgUnitInfo)companys.get(companyId)) == null) {
            IFullOrgUnit fullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            company = fullOrgUnit.getFullOrgUnitInfo("select id where id = '" + companyId + "'");
            companys.put(companyId, company);
        }
        return company;
    }

    private CurrencyInfo getCurrencyByID(Context ctx, String currencyId, Map mapParams) throws BOSException, EASBizException {
        CurrencyInfo currency;
        if (StringUtils.isEmpty((String)currencyId)) {
            return null;
        }
        HashMap<String, CurrencyInfo> currencies = (HashMap<String, CurrencyInfo>)mapParams.get(KEY_CURRENCY);
        if (currencies == null) {
            currencies = new HashMap<String, CurrencyInfo>(32);
            mapParams.put(KEY_CURRENCY, currencies);
        }
        if ((currency = (CurrencyInfo)currencies.get(currencyId)) == null) {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            currency = (CurrencyInfo)icurrency.getValue("select id where id = '" + currencyId + "'");
            currencies.put(currencyId, currency);
        }
        return currency;
    }

    @Override
    protected boolean _checkExists(Context ctx, Map mapParams) throws BOSException, EASBizException {
        List lstTemplateID;
        IElimination elimination = EliminationFactory.getLocalInstance(ctx);
        int iElimType = 6;
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        int iPeriod = (Integer)mapParams.get("Period");
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        iElimType = (Integer)mapParams.get("ElimType");
        StringBuffer oql = new StringBuffer();
        oql.append("where orgBound.id = '").append(orgTreeId).append("'");
        oql.append(" and orgUnit.id = '").append(orgUnitId).append("'");
        oql.append(" and year = ").append(iYear);
        oql.append(" and period = ").append(iPeriod);
        oql.append(" and periodType = ").append(iPeriodType);
        oql.append(" and elimType = ").append(iElimType);
        if (elimination.exists(oql.toString() + " and templetID is null and checkedStatus = 2 and convertBefore is null")) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"Exists_Audited_EliminationDatas", (Locale)ctx.getOriginLocale())));
        }
        if (elimination.exists(oql.toString() + " and templetID is null")) {
            return true;
        }
        ArrayList<InvestTempletEnum> lstTemplate = new ArrayList<InvestTempletEnum>();
        if (mapParams.containsKey("KEY_MAINCOST_BEFOREYEAR")) {
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_BEFOREYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_IUD_BEFOREYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_BEFOREYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UIUD_BEFOREYEAR);
        }
        if (mapParams.containsKey("KEY_MAINCOST_THISYEAR")) {
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_THISYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_FEWSHARESHOLDER);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_PROFITDIST);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_OTHERRIGHT);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_IUD_THISYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_THISYEAR_FIRSTDAY);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_THISYEAR_OTHER);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_THISDAY);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_FEWSHARESHOLDER);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_PROFITDIST);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_OTHERRIGHT);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UIUD_THISYEAR);
        }
        if (mapParams.containsKey("KEY_MAINCOST_WITHDRAWAL")) {
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_WITHDRAWAL);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_WITHDRAWAL);
        }
        if ((lstTemplateID = this.getTemplateID(ctx, lstTemplate)) != null && lstTemplateID.size() > 0) {
            oql.append(" and templetID in (");
            for (int i = 0; i < lstTemplateID.size(); ++i) {
                if (i > 0) {
                    oql.append(",");
                }
                oql.append("'" + lstTemplateID.get(i) + "'");
            }
            if (mapParams.containsKey("KEY_MAINCOST_BEFOREYEAR")) {
                oql.append(",'").append(COST_MAIN_TEMPLATEID).append("'");
            }
            oql.append(")");
        } else if (mapParams.containsKey("KEY_MAINCOST_BEFOREYEAR")) {
            oql.append(" and templetId ='").append(COST_MAIN_TEMPLATEID).append("'");
        }
        if (elimination.exists(oql.toString() + " and checkedStatus = 2 and convertBefore is null")) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"Exists_Audited_EliminationDatas", (Locale)ctx.getOriginLocale())));
        }
        return elimination.exists(oql.toString());
    }

    private List getTemplateID(Context ctx, List lstParams) throws BOSException {
        if (lstParams != null && lstParams.size() > 0) {
            StringBuffer oql = new StringBuffer();
            oql.append("select fid from T_CSL_InvestTemplet where felimType = ");
            oql.append(6);
            oql.append(" and ftempletType in (");
            for (int i = 0; i < lstParams.size(); ++i) {
                if (i > 0) {
                    oql.append(",");
                }
                int templateType = ((InvestTempletEnum)((Object)lstParams.get(i))).getValue();
                oql.append(templateType);
            }
            oql.append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            ArrayList<String> result = new ArrayList<String>();
            try {
                while (rowSet.next()) {
                    result.add(rowSet.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            return result;
        }
        return null;
    }

    @Override
    protected void _delete(Context ctx, Map mapParams) throws BOSException, EASBizException {
        List lstTemplateID;
        IElimination elimination = EliminationFactory.getLocalInstance(ctx);
        int iElimType = 6;
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        int iPeriod = (Integer)mapParams.get("Period");
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        iElimType = (Integer)mapParams.get("ElimType");
        StringBuffer oql = new StringBuffer();
        oql.append("where orgBound.id = '").append(orgTreeId).append("'");
        oql.append(" and orgUnit.id = '").append(orgUnitId).append("'");
        oql.append(" and year = ").append(iYear);
        oql.append(" and period = ").append(iPeriod);
        oql.append(" and periodType = ").append(iPeriodType);
        oql.append(" and elimType = ").append(iElimType);
        ArrayList<InvestTempletEnum> lstTemplate = new ArrayList<InvestTempletEnum>();
        if (mapParams.containsKey("KEY_MAINCOST_BEFOREYEAR")) {
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_BEFOREYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_IUD_BEFOREYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_BEFOREYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UIUD_BEFOREYEAR);
        }
        if (mapParams.containsKey("KEY_MAINCOST_THISYEAR")) {
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_THISYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_FEWSHARESHOLDER);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_PROFITDIST);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_OTHERRIGHT);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_IUD_THISYEAR);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_THISYEAR_FIRSTDAY);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_THISYEAR_OTHER);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_THISDAY);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_FEWSHARESHOLDER);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_PROFITDIST);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_OTHERRIGHT);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UIUD_THISYEAR);
        }
        if (mapParams.containsKey("KEY_MAINCOST_WITHDRAWAL")) {
            lstTemplate.add(InvestTempletEnum.MAIN_COST_UID_WITHDRAWAL);
            lstTemplate.add(InvestTempletEnum.MAIN_COST_ID_WITHDRAWAL);
        }
        if ((lstTemplateID = this.getTemplateID(ctx, lstTemplate)) != null && lstTemplateID.size() > 0) {
            oql.append(" and (templetID in (");
            for (int i = 0; i < lstTemplateID.size(); ++i) {
                if (i > 0) {
                    oql.append(",");
                }
                oql.append("'" + lstTemplateID.get(i) + "'");
            }
            if (mapParams.containsKey("KEY_MAINCOST_BEFOREYEAR")) {
                oql.append(",'").append(COST_MAIN_TEMPLATEID).append("'");
            }
            oql.append(") or templetId is null)");
        } else if (mapParams.containsKey("KEY_MAINCOST_BEFOREYEAR")) {
            oql.append(" and (templetId = '").append(COST_MAIN_TEMPLATEID).append("'");
            oql.append(" or templetId is null )");
        }
        elimination.delete(oql.toString());
    }

    private InvestTempletInfo getTemplateByType(Context ctx, int templetType) throws EASBizException, BOSException {
        String oql = "select id, summary, entries.* where ElimType = 6 and templetType = " + templetType;
        InvestTempletInfo info = InvestTempletFactory.getLocalInstance(ctx).getInvestTempletInfo(oql);
        if (info == null) {
            throw new ServerException(ServerException.NOT_FOUND_SYS_INVESTTEMPLATE, new Object[]{InvestTempletEnum.getEnum(templetType).getAlias()});
        }
        return info;
    }

    private Map getTempletEntriesCach(InvestTempletInfo template) {
        String templetId = template.getId().toString();
        HashMap<String, InvestTempletEntryInfo> result = new HashMap<String, InvestTempletEntryInfo>();
        Iterator iter = template.getEntries().iterator();
        while (iter.hasNext()) {
            InvestTempletEntryInfo info = (InvestTempletEntryInfo)iter.next();
            int seq = info.getSeq();
            result.put(templetId + seq, info);
        }
        return result;
    }

    private InvestTempletEntryInfo getTempletEntryBySeq(Context ctx, String templetId, int seq, Map entries) throws EASBizException, BOSException {
        InvestTempletEntryInfo info = (InvestTempletEntryInfo)entries.get(templetId + seq);
        if (info == null) {
            throw new ServerException(ServerException.NOT_FOUND_SYS_INVESTTEMPLATE);
        }
        return info;
    }

    private BigDecimal getEquialentRate(Context ctx, String orgTreeId, String orgUnitId, String targetCompanyId, java.util.Date date, Map mapParams, Map equialentRate, String _currencyId) throws BOSException {
        Map rates;
        if (equialentRate.containsKey(date = RPTDateUtil.getBeginOfDay(date))) {
            rates = (Map)equialentRate.get(date);
        } else {
            Map map = InvestDayUtilForMainCost.getCompanysOfMainCost(ctx, orgTreeId, orgUnitId, _currencyId, date, false, (String)mapParams.get("longNumber"));
            rates = (Map)map.get("EquivalentRate");
            equialentRate.put(date, rates);
        }
        if (rates.containsKey(targetCompanyId)) {
            return (BigDecimal)rates.get(targetCompanyId);
        }
        return ZERO;
    }

    private void setLongNumber(Context ctx, Map mapParams) throws BOSException {
        String longnumber;
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        String numberSql = "select flongnumber from t_org_structure t where ftreeId = ? and funitId = ?";
        Object[] params = new Object[]{orgTreeId, orgUnitId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)numberSql, (Object[])params);
        try {
            rowSet.next();
            longnumber = rowSet.getString(1);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        mapParams.put("longNumber", longnumber);
    }

    @Override
    protected void _createElimRecords(Context ctx, Map mapParams) throws BOSException, EASBizException {
        String _currencyId;
        this.setLongNumber(ctx, mapParams);
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        java.util.Date rptDate = (java.util.Date)mapParams.get("Day");
        boolean allInOne = false;
        if (mapParams.containsKey("KEY_MAINCOST_ALLINONE")) {
            allInOne = (Boolean)mapParams.get("KEY_MAINCOST_ALLINONE");
        }
        CoreBaseCollection eliCol = null;
        ArrayList copyList = new ArrayList();
        if (mapParams.get("KEY_MAINCOST_BEFOREYEAR") != null) {
            eliCol = this.getPreYearEliminationColByPara(ctx, mapParams);
        }
        ArrayList<Object> eliminations = new ArrayList<Object>(0);
        HashMap eliminationNew = new HashMap();
        List currencies = this.getCurrencyIds(ctx);
        HashMap equialentRate = new HashMap();
        for (int i = 0; i < currencies.size(); ++i) {
            _currencyId = (String)currencies.get(i);
            Map map = InvestDayUtilForMainCost.getCompanysOfMainCost(ctx, orgTreeId, orgUnitId, _currencyId, rptDate, true, (String)mapParams.get("longNumber"));
            equialentRate.put(rptDate, map.get("EquivalentRate"));
            Map companys = (Map)map.get("ElimType");
            Map identityDirect = (Map)companys.get("identityDirect");
            Map identityUnDirect = (Map)companys.get("identityUnDirect");
            Map unidentityDirect = (Map)companys.get("unidentityDirect");
            Map unidentityUnDirect = (Map)companys.get("unidentityUnDirect");
            if (mapParams.containsKey("KEY_MAINCOST_THISYEAR")) {
                ArrayList lstElimination;
                if (!identityDirect.isEmpty()) {
                    lstElimination = new ArrayList();
                    this.createElimForIDInvestDayInvest(ctx, lstElimination, identityDirect, mapParams, _currencyId, allInOne);
                    eliminations.addAll(lstElimination);
                    lstElimination.clear();
                    this.createElimForIDFewSharesHolder(ctx, lstElimination, identityDirect, mapParams, equialentRate, _currencyId, allInOne);
                    eliminations.addAll(lstElimination);
                    lstElimination.clear();
                    this.createElimForIDProfitDist(ctx, lstElimination, identityDirect, identityUnDirect, mapParams, equialentRate, _currencyId, allInOne);
                    eliminations.addAll(lstElimination);
                    lstElimination.clear();
                    eliminationNew.clear();
                    this.createElimForIDOtherRight(ctx, eliminationNew, identityDirect, mapParams, equialentRate, _currencyId);
                    eliminations.addAll(eliminationNew.values());
                    eliminationNew.clear();
                }
                if (!identityUnDirect.isEmpty()) {
                    lstElimination = new ArrayList();
                    this.createElimForIUDThisYear(ctx, lstElimination, identityUnDirect, identityDirect, mapParams, equialentRate, _currencyId, allInOne);
                    eliminations.addAll(lstElimination);
                    eliminationNew.clear();
                }
                if (!unidentityDirect.isEmpty()) {
                    lstElimination = new ArrayList();
                    this.createElimForUIDThisYear(ctx, lstElimination, unidentityDirect, mapParams, _currencyId, allInOne);
                    eliminations.addAll(lstElimination);
                    lstElimination.clear();
                    eliminationNew.clear();
                    this.createElimForUIDThisDay(ctx, eliminationNew, unidentityDirect, mapParams, _currencyId);
                    eliminations.addAll(eliminationNew.values());
                    eliminationNew.clear();
                    this.createElimForUIDFewSharesHolder(ctx, lstElimination, unidentityDirect, mapParams, equialentRate, _currencyId, allInOne);
                    eliminations.addAll(lstElimination);
                    lstElimination.clear();
                    this.createElimForUIDProfitDist(ctx, lstElimination, unidentityDirect, unidentityUnDirect, mapParams, equialentRate, _currencyId, allInOne);
                    eliminations.addAll(lstElimination);
                    lstElimination.clear();
                    eliminationNew.clear();
                    this.createElimForUIDOtherRight(ctx, eliminationNew, unidentityDirect, mapParams, equialentRate, _currencyId);
                    eliminations.addAll(eliminationNew.values());
                    eliminationNew.clear();
                }
                if (!unidentityUnDirect.isEmpty()) {
                    lstElimination = new ArrayList();
                    this.createElimForUIUDThisYear(ctx, lstElimination, unidentityUnDirect, unidentityDirect, mapParams, equialentRate, _currencyId, allInOne);
                    eliminations.addAll(lstElimination);
                    eliminationNew.clear();
                }
            }
            if (mapParams.containsKey("KEY_MAINCOST_WITHDRAWAL")) {
                if (!identityDirect.isEmpty()) {
                    this.createElimForIDWithdrawal(ctx, eliminationNew, identityDirect, mapParams, _currencyId);
                    eliminations.addAll(eliminationNew.values());
                    eliminationNew.clear();
                }
                if (!unidentityDirect.isEmpty()) {
                    this.createElimForUIDWithdrawal(ctx, eliminationNew, unidentityDirect, mapParams, _currencyId);
                    eliminations.addAll(eliminationNew.values());
                    eliminationNew.clear();
                }
            }
            if (!mapParams.containsKey("KEY_MAINCOST_BEFOREYEAR") || eliCol == null || eliCol.size() <= 0) continue;
            this.copyElimFromHistory(eliCol, copyList, InvestDayUtilForMainCost.getCompanysOfMainCostRate(ctx, orgTreeId, orgUnitId, _currencyId, rptDate, true), _currencyId);
        }
        String[] numbers = this.getBatchElimNumber(ctx, mapParams, copyList, eliminations);
        Object var15_17 = null;
        int index = 0;
        if (!eliminations.isEmpty()) {
            IElimination elimination = EliminationFactory.getLocalInstance(ctx);
            String number = null;
            for (EliminationInfo eliminationInfo : eliminations) {
                number = numbers[index];
                ++index;
                eliminationInfo.setNumber(number);
                eliminationInfo.setIsCitedByLater(IsCitedByLaterEnum.ISTRUE);
                if (mapParams.get("displayTypeId") != null) {
                    String typeid = (String)mapParams.get("displayTypeId");
                    BOSUuid id = BOSUuid.read((String)typeid);
                    TemplateTypeInfo type = new TemplateTypeInfo();
                    type.setId(id);
                    eliminationInfo.setDisplayTemplateType(type);
                }
                eliminationInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
                eliminationInfo.setCreateTime(new Timestamp(new java.util.Date().getTime()));
                elimination.addnew((CoreBaseInfo)eliminationInfo);
            }
        }
        if (!copyList.isEmpty()) {
            this.copyHistoryAutoGenElimination(ctx, copyList, mapParams, numbers, index);
        }
        _currencyId = null;
    }

    private String[] getBatchElimNumber(Context ctx, Map mapParams, ArrayList copyList, Collection eliminations) throws BOSException, EASBizException, CodingRuleException {
        String[] numbers = null;
        int numberSize = 0;
        if (!eliminations.isEmpty()) {
            numberSize += eliminations.size();
        }
        if (!copyList.isEmpty()) {
            numberSize += copyList.size();
        }
        if (numberSize > 0) {
            numbers = CslElimUtil.getBatchNumber(ctx, mapParams, numberSize);
        }
        return numbers;
    }

    private List caclEntryDist(Map mapElimination, boolean isDebitToCredit) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        for (String currencyId : mapElimination.keySet()) {
            EliminationInfo elim = (EliminationInfo)mapElimination.get(currencyId);
            BigDecimal diff = ZERO;
            Iterator iterEntry = elim.getEntries().iterator();
            while (iterEntry.hasNext()) {
                EliminationEntryInfo entry = (EliminationEntryInfo)iterEntry.next();
                if (!entry.isIsVisible()) continue;
                if (entry.getDebit() != null) {
                    diff = diff.subtract(entry.getDebit());
                }
                if (entry.getCredit() == null) continue;
                diff = diff.add(entry.getCredit());
            }
            if (diff.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            if (isDebitToCredit) {
                data.put("Value", diff.negate());
            } else {
                data.put("Value", diff);
            }
            result.add(data);
        }
        return result;
    }

    protected void createElimForUIDThisYear(Context ctx, List eliminations, Map companys, Map mapParams, String _currencyId, boolean allInOne) throws EASBizException, BOSException {
        java.util.Date rptDate = (java.util.Date)mapParams.get("Day");
        InvestTempletInfo template = this.getTemplateByType(ctx, 33);
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        String summary = template.getSummary();
        HashMap mapElimination = new HashMap();
        for (String targetCompanyId : companys.keySet()) {
            List sourceCompanyIds = (List)companys.get(targetCompanyId);
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"178_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            List investDayCl = InvestDayUtilForMainCost.getThisYearOwnerSum(ctx, targetCompanyId, _currencyId, templetEntry.isIsSumItemExtend(), rptDate);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
            investDayCl = InvestDayUtilForMainCost.getThisYearOwnerSum(ctx, targetCompanyId, _currencyId, false, rptDate);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            if (!allInOne) {
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
                summary = template.getSummary();
            }
            for (int k = 0; k < sourceCompanyIds.size(); ++k) {
                String sourceCompanyId = (String)sourceCompanyIds.get(k);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
                investDayCl = InvestDayUtilForMainCost.getThisYearMinoritySum(ctx, sourceCompanyId, targetCompanyId, _currencyId, rptDate);
                this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                investDayCl = InvestDayUtilForMainCost.getThisYearHonorSum(ctx, sourceCompanyId, targetCompanyId, _currencyId, rptDate);
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                investDayCl = InvestDayUtilForMainCost.getThisYearSumInvestAmount(ctx, sourceCompanyId, targetCompanyId, _currencyId, rptDate);
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 5, entries);
                investDayCl = this.caclEntryDist(mapElimination, true);
                this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
                if (allInOne) continue;
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
            }
        }
        eliminations.addAll(mapElimination.values());
    }

    protected void createElimForUIDThisDay(Context ctx, Map mapElimination, Map companys, Map mapParams, String _currencyId) throws EASBizException, BOSException {
        int iYear = (Integer)mapParams.get("Year");
        InvestTempletInfo template = this.getTemplateByType(ctx, 35);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        for (String targetCompanyId : companys.keySet()) {
            List sourceCompanyIds = (List)companys.get(targetCompanyId);
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            List investDayCl = InvestDayUtilForMainCost.getThisYearProfit(ctx, sourceCompanyIds, targetCompanyId, _currencyId, iYear, templetEntry.isIsSumItemExtend());
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
            investDayCl = InvestDayUtilForMainCost.getThisYearProfit(ctx, sourceCompanyIds, targetCompanyId, _currencyId, iYear, templetEntry.isIsSumItemExtend());
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
        }
    }

    protected void createElimForUIDFewSharesHolder(Context ctx, List lstElimination, Map companys, Map mapParams, Map equialentRate, String _currencyId, boolean allInOne) throws EASBizException, BOSException {
        InvestTempletInfo template = this.getTemplateByType(ctx, 36);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        HashMap mapElimination = new HashMap();
        for (String targetCompanyId : companys.keySet()) {
            List fewHolderInterest = this.getThisYearFewHolderProfitAndLoss(ctx, targetCompanyId, mapParams, false, equialentRate, _currencyId);
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            this.mergeElimination(ctx, mapElimination, fewHolderInterest, null, targetCompanyId, templetEntry, summary, mapParams);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
            this.mergeElimination(ctx, mapElimination, fewHolderInterest, null, targetCompanyId, templetEntry, summary, mapParams);
            if (allInOne) continue;
            lstElimination.addAll(mapElimination.values());
            mapElimination.clear();
        }
        lstElimination.addAll(mapElimination.values());
    }

    private List getThisYearFewHolderProfitAndLoss(Context ctx, String targetCompanyId, Map mapParams, boolean isForUnDirect, Map equialentRate, String _currencyId) throws EASBizException, BOSException {
        java.util.Date rptDate;
        ArrayList result = new ArrayList();
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        if (!InvestDayUtilForMainCost.existsInvest(ctx, null, targetCompanyId, _currencyId, iYear, rptDate = (java.util.Date)mapParams.get("Day"))) {
            BigDecimal bdRateValue = this.getEquialentRate(ctx, orgTreeId, orgUnitId, targetCompanyId, rptDate, mapParams, equialentRate, _currencyId);
            BigDecimal bdProfitValue = this.getPeriodEndProfit(ctx, targetCompanyId, _currencyId, mapParams);
            if (bdProfitValue != null && bdRateValue != null) {
                if (!isForUnDirect) {
                    bdRateValue = ONE.subtract(bdRateValue);
                }
                BigDecimal bdResultValue = bdProfitValue.multiply(bdRateValue);
                HashMap<String, Object> mapTemp = new HashMap<String, Object>(4);
                mapTemp.put("KEY_CURRENCY_ID", _currencyId);
                mapTemp.put("Value", bdResultValue);
                result.add(mapTemp);
            }
        } else {
            List allProfits = InvestDayUtilForMainCost.getThisYearAllProfit(ctx, null, targetCompanyId, _currencyId, rptDate);
            int size = allProfits.size();
            if (size == 0) {
                return result;
            }
            BigDecimal beginOfYearSumInvestRate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, targetCompanyId, RPTDateUtil.getEndOfYear(iYear - 1), mapParams, equialentRate, _currencyId);
            if (beginOfYearSumInvestRate != null && beginOfYearSumInvestRate.compareTo(ZERO) != 0) {
                BigDecimal resultValue = ZERO;
                BigDecimal bdPrevProfit = ZERO;
                BigDecimal bdPrevSumInvestRate = ZERO;
                for (int iRow = 0; iRow < size; ++iRow) {
                    Map mapProfitDetail = (Map)allProfits.get(iRow);
                    BigDecimal bdCurProfit = (BigDecimal)mapProfitDetail.get("Value");
                    java.util.Date day = (java.util.Date)mapProfitDetail.get("ChangeDate");
                    BigDecimal bdCurSumInvestRate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, targetCompanyId, day, mapParams, equialentRate, _currencyId);
                    if (iRow == 0) {
                        if (!isForUnDirect) {
                            beginOfYearSumInvestRate = ONE.subtract(beginOfYearSumInvestRate);
                        }
                        resultValue = bdCurProfit.multiply(beginOfYearSumInvestRate);
                    } else {
                        if (!isForUnDirect) {
                            bdPrevSumInvestRate = ONE.subtract(bdPrevSumInvestRate);
                        }
                        resultValue = resultValue.add(bdCurProfit.subtract(bdPrevProfit).multiply(bdPrevSumInvestRate));
                    }
                    if (iRow == size - 1) {
                        BigDecimal bdEndProfit = this.getPeriodEndProfit(ctx, targetCompanyId, _currencyId, mapParams);
                        if (bdEndProfit == null) {
                            bdEndProfit = ZERO;
                        }
                        if (!isForUnDirect) {
                            bdCurSumInvestRate = ONE.subtract(bdCurSumInvestRate);
                        }
                        resultValue = resultValue.add(bdEndProfit.subtract(bdCurProfit).multiply(bdCurSumInvestRate));
                        continue;
                    }
                    bdPrevProfit = bdCurProfit;
                    bdPrevSumInvestRate = bdCurSumInvestRate;
                }
                HashMap<String, Object> mapTemp = new HashMap<String, Object>(4);
                mapTemp.put("KEY_CURRENCY_ID", _currencyId);
                mapTemp.put("Value", resultValue);
                result.add(mapTemp);
            } else {
                BigDecimal resultValue = ZERO;
                BigDecimal lastProfit = ZERO;
                for (int iRow = size - 1; iRow >= 0; --iRow) {
                    Map mapProfitDetail = (Map)allProfits.get(iRow);
                    BigDecimal curProfit = (BigDecimal)mapProfitDetail.get("Value");
                    java.util.Date day = (java.util.Date)mapProfitDetail.get("ChangeDate");
                    BigDecimal curSumInvestRate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, targetCompanyId, day, mapParams, equialentRate, _currencyId);
                    if (iRow == size - 1) {
                        BigDecimal endProfit = this.getPeriodEndProfit(ctx, targetCompanyId, _currencyId, mapParams);
                        if (endProfit == null) {
                            endProfit = ZERO;
                        }
                        BigDecimal endSumInvestRate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, targetCompanyId, rptDate, mapParams, equialentRate, _currencyId);
                        if (!isForUnDirect) {
                            endSumInvestRate = ONE.subtract(endSumInvestRate);
                        }
                        resultValue = endProfit.subtract(curProfit).multiply(endSumInvestRate);
                    } else {
                        if (!isForUnDirect) {
                            curSumInvestRate = ONE.subtract(curSumInvestRate);
                        }
                        resultValue = resultValue.add(lastProfit.subtract(curProfit).multiply(curSumInvestRate));
                    }
                    lastProfit = curProfit;
                }
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", _currencyId);
                data.put("Value", resultValue);
                result.add(data);
            }
        }
        return result;
    }

    private BigDecimal getPeriodEndProfit(Context ctx, String targetCompanyId, String currencyId, Map mapParams) throws BOSException, EASBizException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        StringBuffer sql = new StringBuffer();
        sql.append("select FUnitId, FStockControlCompanyID from T_ORG_OUPartUnionGroup");
        sql.append(" where FUnitId in (");
        sql.append("select a.FUnitId from t_org_structure a join t_org_structure b");
        sql.append(" on a.FId = b.FParentId");
        sql.append(" where b.FTreeId = ?)");
        sql.append(" and FStockControlCompanyID = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, targetCompanyId});
        try {
            if (rowSet.next()) {
                String unitId = rowSet.getString("FUnitId");
                return this.getPeriodEndNetProfit(ctx, unitId, currencyId, 3, mapParams);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return this.getPeriodEndNetProfit(ctx, targetCompanyId, currencyId, 1, mapParams);
    }

    private BigDecimal getPeriodEndNetProfit(Context ctx, String targetCompanyId, String currencyId, int sourceType, Map mapParams) throws BOSException, EASBizException {
        String orgTreeNumber = ((OrgTreeInfo)mapParams.get("KeyOrgTree")).getNumber();
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        int year = (Integer)mapParams.get("Year");
        int period = (Integer)mapParams.get("Period");
        String itemNumber = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.NET_PROFIT, mapParams).getNumber();
        return this.getAcctItem(ctx, targetCompanyId, currencyId, itemNumber, orgTreeNumber, year, period, iPeriodType, sourceType, 3);
    }

    protected void createElimForUIDProfitDist(Context ctx, List lstElimination, Map companys, Map companys2, Map mapParams, Map equialentRate, String _currencyId, boolean allInOne) throws EASBizException, BOSException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        java.util.Date begin = RPTDateUtil.getBeginOfYear(iYear);
        java.util.Date endOfYear = (java.util.Date)mapParams.get("Day");
        InvestTempletInfo template = this.getTemplateByType(ctx, 37);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        HashMap mapElimination = new HashMap();
        for (String targetCompanyId : companys.keySet()) {
            ArrayList<HashMap<String, Object>> list;
            ArrayList<HashMap<String, Object>> list2;
            BigDecimal dbValue;
            List sourceCompanyIds = (List)companys.get(targetCompanyId);
            java.util.Date beginOfYear = begin;
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 FChangeDate from t_csl_investDay");
            sql.append(" where FTargetCompanyId = ?");
            sql.append(" order by FChangeDate asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{targetCompanyId});
            try {
                Date date;
                if (rowSet.next() && (date = rowSet.getDate("FChangeDate")).after(beginOfYear)) {
                    beginOfYear = date;
                }
            }
            catch (SQLException e1) {
                throw new SQLDataException(e1);
            }
            sql = new StringBuffer();
            sql.append("Select FAmount, FDistDate From T_CSL_ProfitDistributeList");
            sql.append(" where FCompanyID = '");
            sql.append(targetCompanyId);
            sql.append("' and FDistDate >= ");
            sql.append(CslRptUtil.formatDateForSql(beginOfYear));
            sql.append(" and FDistDate <= ");
            sql.append(CslRptUtil.formatDateForSql(endOfYear));
            sql.append(" and FCurrencyID = '");
            sql.append(_currencyId);
            sql.append("' order by FDistDate asc");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            BigDecimal dbProfitDist = ZERO;
            BigDecimal dbFewHolder = ZERO;
            HashMap<String, BigDecimal> mapInvest = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> mapFewShare = new HashMap<String, BigDecimal>();
            try {
                while (rowSet.next()) {
                    Date date = rowSet.getDate("FDistDate");
                    BigDecimal dbValue2 = rowSet.getBigDecimal("FAmount");
                    dbProfitDist = dbProfitDist.add(dbValue2);
                    BigDecimal erate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, targetCompanyId, date, mapParams, equialentRate, _currencyId);
                    if (erate == null) {
                        erate = ZERO;
                    }
                    dbFewHolder = dbFewHolder.add(dbValue2.multiply(ONE.subtract(erate)));
                    HashMap investCompanys = new HashMap();
                    if (date.before(endOfYear)) {
                        Map companyAndRate = InvestDayUtilForMainCost.getCompanysOfMainCost(ctx, orgTreeId, orgUnitId, _currencyId, date, true, (String)mapParams.get("longNumber"));
                        Map tmpMap = (Map)companyAndRate.get("ElimType");
                        investCompanys.putAll((Map)tmpMap.get("unidentityDirect"));
                        investCompanys.putAll((Map)tmpMap.get("unidentityUnDirect"));
                    } else {
                        investCompanys.putAll(companys);
                        investCompanys.putAll(companys2);
                    }
                    for (int i = 0; i < sourceCompanyIds.size(); ++i) {
                        String sourceCompanyId = (String)sourceCompanyIds.get(i);
                        BigDecimal rate = InvestDayUtilForMainCost.getThisDaySumInvestRate(ctx, sourceCompanyId, targetCompanyId, _currencyId, date);
                        if (rate == null) {
                            rate = ZERO;
                        }
                        BigDecimal dbInvest = ZERO;
                        if (mapInvest.containsKey(sourceCompanyId)) {
                            dbInvest = (BigDecimal)mapInvest.get(sourceCompanyId);
                        }
                        BigDecimal dbTmp = dbValue2.multiply(rate);
                        dbInvest = dbInvest.add(dbTmp);
                        mapInvest.put(sourceCompanyId, dbInvest);
                        if (dbTmp.compareTo(ZERO) == 0) continue;
                        List lstCompany = new ArrayList(0);
                        if (investCompanys.containsKey(sourceCompanyId)) {
                            lstCompany = (List)investCompanys.get(sourceCompanyId);
                        }
                        BigDecimal dbFewShare = ZERO;
                        if (mapFewShare.containsKey(sourceCompanyId)) {
                            dbFewShare = (BigDecimal)mapFewShare.get(sourceCompanyId);
                        }
                        for (int k = 0; lstCompany != null && k < lstCompany.size(); ++k) {
                            String companyId = (String)lstCompany.get(k);
                            erate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, sourceCompanyId + companyId, date, mapParams, equialentRate, _currencyId);
                            if (erate == null || erate.compareTo(ZERO) <= 0) continue;
                            dbFewShare = dbFewShare.add(dbTmp.multiply(ONE.subtract(erate)));
                        }
                        mapFewShare.put(sourceCompanyId, dbFewShare);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            for (String sourceCompanyId : mapInvest.keySet()) {
                dbValue = (BigDecimal)mapInvest.get(sourceCompanyId);
                if (dbValue.compareTo(ZERO) == 0) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", _currencyId);
                data.put("Value", dbValue);
                list2 = new ArrayList<HashMap<String, Object>>();
                list2.add(data);
                this.mergeElimination(ctx, mapElimination, list2, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
            }
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
            for (String sourceCompanyId : mapFewShare.keySet()) {
                dbValue = (BigDecimal)mapFewShare.get(sourceCompanyId);
                if (dbValue.compareTo(ZERO) == 0) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", _currencyId);
                data.put("Value", dbValue);
                list2 = new ArrayList();
                list2.add(data);
                this.mergeElimination(ctx, mapElimination, list2, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
            }
            if (dbFewHolder.compareTo(ZERO) != 0) {
                HashMap<String, Object> mapFh = new HashMap<String, Object>(4);
                mapFh.put("KEY_CURRENCY_ID", _currencyId);
                mapFh.put("Value", dbFewHolder);
                list = new ArrayList<HashMap<String, Object>>();
                list.add(mapFh);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                this.mergeElimination(ctx, mapElimination, list, null, targetCompanyId, templetEntry, summary, mapParams);
            }
            if (dbProfitDist.compareTo(ZERO) != 0) {
                HashMap<String, Object> mapPt = new HashMap<String, Object>(4);
                mapPt.put("KEY_CURRENCY_ID", _currencyId);
                mapPt.put("Value", dbProfitDist);
                list = new ArrayList();
                list.add(mapPt);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                this.mergeElimination(ctx, mapElimination, list, null, targetCompanyId, templetEntry, summary, mapParams);
            }
            if (allInOne) continue;
            lstElimination.addAll(mapElimination.values());
            mapElimination.clear();
        }
        lstElimination.addAll(mapElimination.values());
    }

    protected void createElimForUIDOtherRight(Context ctx, Map mapElimination, Map companys, Map mapParams, Map equialentRate, String _currencyId) throws EASBizException, BOSException {
        InvestTempletInfo template = this.getTemplateByType(ctx, 38);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        for (String targetCompanyId : companys.keySet()) {
            List investDayCl = this.getOtherOwnerSum(ctx, targetCompanyId, mapParams, false, equialentRate, _currencyId);
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            investDayCl = this.getTotalOtherOnwerSum(investDayCl);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
        }
    }

    private List getOtherOwnerSum(Context ctx, String targetCompanyId, Map mapParams, boolean isForFewHolder, Map equialentRate, String _currencyId) throws BOSException, EASBizException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        java.util.Date end = (java.util.Date)mapParams.get("Day");
        java.util.Date begin = RPTDateUtil.getBeginOfYear(iYear);
        ArrayList result = new ArrayList();
        StringBuffer oql = new StringBuffer();
        oql.append("Select o.FCurrencyID, o.FChangeDate, e.FChangeMoney, e.FItemID ");
        oql.append(" From T_CSL_OtherOwnerRight o join T_CSL_OtherOwnerRightEntry e");
        oql.append(" on o.FId = e.FHeadID");
        oql.append(" where o.fcompanyid = '");
        oql.append(targetCompanyId);
        oql.append("'");
        oql.append(" and o.FChangeDate >= ?");
        oql.append(" and o.FChangeDate <= ");
        oql.append(CslRptUtil.formatDateForSql(end));
        oql.append(" and o.FCurrencyID = ?");
        oql.append(" order by o.FChangeDate");
        if (!(begin instanceof Date)) {
            begin = new Date(begin.getTime());
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])new Object[]{begin, _currencyId});
        HashMap<String, BigDecimal> tmpItem = new HashMap<String, BigDecimal>();
        try {
            while (rowSet.next()) {
                BigDecimal changeMoney;
                Date date = rowSet.getDate("FChangeDate");
                BigDecimal rate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, targetCompanyId, date, mapParams, equialentRate, _currencyId);
                if (rate == null) {
                    rate = ZERO;
                }
                if (!isForFewHolder) {
                    rate = ONE.subtract(rate);
                }
                if ((changeMoney = rowSet.getBigDecimal("FChangeMoney")) == null) {
                    changeMoney = ZERO;
                }
                String itemid = rowSet.getString("FItemId");
                BigDecimal total = ZERO;
                if (tmpItem.containsKey(itemid)) {
                    total = (BigDecimal)tmpItem.get(itemid);
                }
                total = total.add(changeMoney.multiply(rate));
                tmpItem.put(itemid, total);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        for (String itemid : tmpItem.keySet()) {
            BigDecimal value = (BigDecimal)tmpItem.get(itemid);
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", _currencyId);
            data.put("RPTITEM_ID", itemid);
            data.put("Value", value);
            result.add(data);
        }
        return result;
    }

    private List getTotalOtherOnwerSum(List investDayCl) {
        BigDecimal value;
        String currencyId;
        ArrayList result = new ArrayList();
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (HashMap<String, Object> data : investDayCl) {
            currencyId = (String)data.get("KEY_CURRENCY_ID");
            value = (BigDecimal)data.get("Value");
            if (map.containsKey(currencyId)) {
                BigDecimal tmpValue = (BigDecimal)map.get(currencyId);
                value = value.add(tmpValue);
            }
            map.put(currencyId, value);
        }
        Iterator<Object> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            HashMap<String, Object> data;
            data = new HashMap<String, Object>(4);
            currencyId = (String)iter.next();
            value = (BigDecimal)map.get(currencyId);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", value);
            result.add(data);
        }
        return result;
    }

    protected void createElimForUIDWithdrawal(Context ctx, Map mapElimination, Map companys, Map mapParams, String _currencyId) throws EASBizException, BOSException {
        InvestTempletInfo template = this.getTemplateByType(ctx, 49);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        for (String targetCompanyId : companys.keySet()) {
            List investDayCl = this.getWithdrawalValue(ctx, targetCompanyId, mapParams, 1, _currencyId);
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            investDayCl = this.getWithdrawalValue(ctx, targetCompanyId, mapParams, 2, _currencyId);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            investDayCl = this.getWithdrawalValue(ctx, targetCompanyId, mapParams, 3, _currencyId);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            investDayCl = this.caclEntryDist(mapElimination, false);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
        }
    }

    protected void createElimForUIUDThisYear(Context ctx, List eliminations, Map companys, Map companys2, Map mapParams, Map equialentRate, String _currencyId, boolean allInOne) throws EASBizException, BOSException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        java.util.Date beginOfYear = RPTDateUtil.getBeginOfYear(iYear);
        java.util.Date endOfYear = (java.util.Date)mapParams.get("Day");
        InvestTempletInfo template = this.getTemplateByType(ctx, 40);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        HashMap mapElimination = new HashMap();
        Map entries = this.getTempletEntriesCach(template);
        for (String targetCompanyId : companys.keySet()) {
            InvestTempletEntryInfo templetEntry;
            String sourceCompanyId;
            int i;
            List sourceCompanyIds = (List)companys.get(targetCompanyId);
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"179_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            java.util.Date begin = beginOfYear;
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 FChangeDate from t_csl_investDay");
            sql.append(" where FTargetCompanyId = ?");
            sql.append(" order by FChangeDate asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{targetCompanyId});
            try {
                Date date;
                if (rowSet.next() && (date = rowSet.getDate("FChangeDate")).after(begin)) {
                    begin = date;
                }
            }
            catch (SQLException e1) {
                throw new SQLDataException(e1);
            }
            StringBuffer oql = new StringBuffer();
            oql.append("Select FAmount, FDistDate From T_CSL_ProfitDistributeList");
            oql.append(" where fcurrencyid = '");
            oql.append(_currencyId);
            oql.append("' and fcompanyid = '");
            oql.append(targetCompanyId);
            oql.append("'");
            oql.append(" and fdistDate >= ");
            oql.append(CslRptUtil.formatDateForSql(begin));
            oql.append(" and fdistDate <= ");
            oql.append(CslRptUtil.formatDateForSql(endOfYear));
            oql.append(" order by fdistDate");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            HashMap<String, BigDecimal> mapInvest = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> mapFewShare = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> mapDist = new HashMap<String, BigDecimal>();
            try {
                while (rowSet.next()) {
                    Date date = rowSet.getDate("FDistDate");
                    BigDecimal dbValue = rowSet.getBigDecimal("FAmount");
                    HashMap investCompanys = new HashMap();
                    if (date.before(endOfYear)) {
                        Map companyAndRate = InvestDayUtilForMainCost.getCompanysOfMainCost(ctx, orgTreeId, orgUnitId, _currencyId, date, true, (String)mapParams.get("longNumber"));
                        Map tmpMap = (Map)companyAndRate.get("ElimType");
                        investCompanys.putAll((Map)tmpMap.get("unidentityDirect"));
                        investCompanys.putAll((Map)tmpMap.get("unidentityUnDirect"));
                    } else {
                        investCompanys.putAll(companys);
                        investCompanys.putAll(companys2);
                    }
                    for (int i2 = 0; i2 < sourceCompanyIds.size(); ++i2) {
                        String sourceCompanyId2 = (String)sourceCompanyIds.get(i2);
                        BigDecimal sumInvestRate = InvestDayUtilForMainCost.getThisDaySumInvestRate(ctx, sourceCompanyId2, targetCompanyId, _currencyId, date);
                        BigDecimal dbInvest = dbValue.multiply(sumInvestRate);
                        BigDecimal dbTmp = ZERO;
                        if (mapInvest.containsKey(sourceCompanyId2)) {
                            dbTmp = (BigDecimal)mapInvest.get(sourceCompanyId2);
                        }
                        dbTmp = dbTmp.add(dbInvest);
                        mapInvest.put(sourceCompanyId2, dbTmp);
                        if (dbInvest.compareTo(ZERO) == 0) continue;
                        List lstCompany = new ArrayList(0);
                        if (investCompanys.containsKey(sourceCompanyId2)) {
                            lstCompany = (List)investCompanys.get(sourceCompanyId2);
                        }
                        BigDecimal dbFewShare = ZERO;
                        dbTmp = ZERO;
                        if (mapFewShare.containsKey(sourceCompanyId2)) {
                            dbTmp = (BigDecimal)mapFewShare.get(sourceCompanyId2);
                        }
                        for (int k = 0; lstCompany != null && k < lstCompany.size(); ++k) {
                            String companyId = (String)lstCompany.get(k);
                            BigDecimal erate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, sourceCompanyId2 + companyId, date, mapParams, equialentRate, _currencyId);
                            if (erate == null || erate.compareTo(ZERO) <= 0) continue;
                            dbFewShare = dbFewShare.add(dbInvest.multiply(ONE.subtract(erate)));
                        }
                        mapFewShare.put(sourceCompanyId2, dbTmp.add(dbFewShare));
                        dbTmp = ZERO;
                        if (mapDist.containsKey(sourceCompanyId2)) {
                            dbTmp = (BigDecimal)mapDist.get(sourceCompanyId2);
                        }
                        dbTmp = dbTmp.add(dbFewShare.subtract(dbInvest));
                        mapDist.put(sourceCompanyId2, dbTmp);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            for (i = 0; i < sourceCompanyIds.size(); ++i) {
                ArrayList<HashMap<String, Object>> list;
                HashMap<String, Object> data;
                sourceCompanyId = (String)sourceCompanyIds.get(i);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                BigDecimal dbValue = (BigDecimal)mapInvest.get(sourceCompanyId);
                if (dbValue != null && dbValue.compareTo(ZERO) != 0) {
                    data = new HashMap<String, Object>(4);
                    data.put("KEY_CURRENCY_ID", _currencyId);
                    data.put("Value", dbValue);
                    list = new ArrayList<HashMap<String, Object>>(1);
                    list.add(data);
                    this.mergeElimination(ctx, mapElimination, list, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                }
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 5, entries);
                dbValue = (BigDecimal)mapFewShare.get(sourceCompanyId);
                if (dbValue != null && dbValue.compareTo(ZERO) != 0) {
                    data = new HashMap(4);
                    data.put("KEY_CURRENCY_ID", _currencyId);
                    data.put("Value", dbValue);
                    list = new ArrayList(1);
                    list.add(data);
                    this.mergeElimination(ctx, mapElimination, list, null, sourceCompanyId, templetEntry, summary, mapParams);
                }
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                dbValue = (BigDecimal)mapDist.get(sourceCompanyId);
                if (dbValue != null && dbValue.compareTo(ZERO) != 0) {
                    data = new HashMap(4);
                    data.put("KEY_CURRENCY_ID", _currencyId);
                    data.put("Value", dbValue);
                    list = new ArrayList(1);
                    list.add(data);
                    this.mergeElimination(ctx, mapElimination, list, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                }
                if (allInOne) continue;
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
            }
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"180_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            for (i = 0; i < sourceCompanyIds.size(); ++i) {
                sourceCompanyId = (String)sourceCompanyIds.get(i);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                List investDayValues = InvestDayUtilForMainCost.getThisYearHonorSum(ctx, sourceCompanyId, targetCompanyId, _currencyId, endOfYear);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
                investDayValues = InvestDayUtilForMainCost.getThisYearSumInvestAmount(ctx, sourceCompanyId, targetCompanyId, _currencyId, endOfYear);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                investDayValues = InvestDayUtilForMainCost.getThisYearMinoritySum(ctx, sourceCompanyId, targetCompanyId, _currencyId, endOfYear);
                templetEntry.setDcType(InvestItemDCRuleEnum.CREDIT);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry.setDcType(InvestItemDCRuleEnum.DEBIT);
                if (allInOne) continue;
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
            }
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"181_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            InvestTempletEntryInfo templetEntry2 = this.getTempletEntryBySeq(ctx, templetId, 5, entries);
            List investDayValues = this.getThisYearFewHolderProfitAndLoss(ctx, targetCompanyId, mapParams, true, equialentRate, _currencyId);
            this.mergeElimination(ctx, mapElimination, investDayValues, null, targetCompanyId, templetEntry2, summary, mapParams);
            templetEntry2 = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            this.mergeElimination(ctx, mapElimination, investDayValues, null, targetCompanyId, templetEntry2, summary, mapParams);
            if (!allInOne) {
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
            }
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"182_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            templetEntry2 = this.getTempletEntryBySeq(ctx, templetId, 6, entries);
            investDayValues = this.getOtherOwnerSum(ctx, targetCompanyId, mapParams, true, equialentRate, _currencyId);
            this.mergeElimination(ctx, mapElimination, investDayValues, null, targetCompanyId, templetEntry2, summary, mapParams);
            templetEntry2 = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            investDayValues = this.getTotalOtherOnwerSum(investDayValues);
            this.mergeElimination(ctx, mapElimination, investDayValues, null, targetCompanyId, templetEntry2, summary, mapParams);
            if (!allInOne) {
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
            }
            if (!allInOne) continue;
            templetEntry2 = this.getTempletEntryBySeq(ctx, templetId, 7, entries);
            investDayValues = this.caclEntryDist(mapElimination, true);
            this.mergeElimination(ctx, mapElimination, investDayValues, null, targetCompanyId, templetEntry2, summary, mapParams);
        }
        eliminations.addAll(mapElimination.values());
    }

    protected void createElimForIDInvestDayInvest(Context ctx, List eliminations, Map companys, Map mapParams, String _currencyId, boolean allInOne) throws EASBizException, BOSException {
        int iYear = (Integer)mapParams.get("Year");
        java.util.Date rptDate = (java.util.Date)mapParams.get("Day");
        InvestTempletInfo template = this.getTemplateByType(ctx, 42);
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        String summary = template.getSummary();
        HashMap mapElimination = new HashMap();
        for (String targetCompanyId : companys.keySet()) {
            List sourceCompanyIds = (List)companys.get(targetCompanyId);
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"183_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            List investDayCl = InvestDayUtilForMainCost.getThisYearOwnerSum(ctx, targetCompanyId, _currencyId, templetEntry.isIsSumItemExtend(), rptDate);
            BigDecimal dbProfit = InvestDayUtilForMainCost.getBeforeInvestProfit(ctx, targetCompanyId, _currencyId, iYear);
            if (dbProfit.compareTo(ZERO) != 0) {
                String itemId = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.UNSHARED_PROFIT, mapParams).getId().toString();
                boolean find = false;
                for (int i = 0; i < investDayCl.size(); ++i) {
                    String id;
                    Map data = (Map)investDayCl.get(i);
                    if (!data.containsKey("RPTITEM_ID") || !(id = (String)data.get("RPTITEM_ID")).equals(itemId)) continue;
                    find = true;
                    BigDecimal dbValue = (BigDecimal)data.get("Value");
                    dbValue = dbValue.subtract(dbProfit);
                    data.put("Value", dbValue);
                }
                if (!find) {
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("RPTITEM_ID", this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.UNSHARED_PROFIT, mapParams).getId().toString());
                    data.put("KEY_CURRENCY_ID", _currencyId);
                    data.put("Value", dbProfit.negate());
                    investDayCl.add(data);
                }
            }
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
            investDayCl = InvestDayUtilForMainCost.getThisYearOwnerSum(ctx, targetCompanyId, _currencyId, false, rptDate);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
            investDayCl = this.caclEntryDist(mapElimination, true);
            this.mergeElimination(ctx, mapElimination, investDayCl, targetCompanyId, targetCompanyId, templetEntry, summary, mapParams);
            if (!allInOne) {
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"184_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            for (int k = 0; k < sourceCompanyIds.size(); ++k) {
                String sourceCompanyId = (String)sourceCompanyIds.get(k);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                investDayCl = InvestDayUtilForMainCost.getThisYearMinoritySum(ctx, sourceCompanyId, targetCompanyId, _currencyId, rptDate);
                this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                investDayCl = InvestDayUtilForMainCost.getThisYearSumInvestAmount(ctx, sourceCompanyId, targetCompanyId, _currencyId, rptDate);
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
                investDayCl = this.caclEntryDist(mapElimination, true);
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                if (allInOne) continue;
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
            }
        }
        eliminations.addAll(mapElimination.values());
    }

    protected void createElimForIDFewSharesHolder(Context ctx, List lstElimination, Map companys, Map mapParams, Map equialentRate, String _currencyId, boolean allInOne) throws EASBizException, BOSException {
        InvestTempletInfo template = this.getTemplateByType(ctx, 43);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        HashMap mapElimination = new HashMap();
        for (String targetCompanyId : companys.keySet()) {
            List fewHolderInterest = this.getThisYearFewHolderProfitAndLoss(ctx, targetCompanyId, mapParams, false, equialentRate, _currencyId);
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            this.mergeElimination(ctx, mapElimination, fewHolderInterest, null, targetCompanyId, templetEntry, summary, mapParams);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
            this.mergeElimination(ctx, mapElimination, fewHolderInterest, null, targetCompanyId, templetEntry, summary, mapParams);
            if (allInOne) continue;
            lstElimination.addAll(mapElimination.values());
            mapElimination.clear();
        }
        lstElimination.addAll(mapElimination.values());
    }

    protected void createElimForIDProfitDist(Context ctx, List lstElimination, Map companys, Map companys2, Map mapParams, Map equialentRate, String _currencyId, boolean allInOne) throws EASBizException, BOSException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        java.util.Date begin = RPTDateUtil.getBeginOfYear(iYear);
        java.util.Date endOfYear = (java.util.Date)mapParams.get("Day");
        InvestTempletInfo template = this.getTemplateByType(ctx, 44);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        HashMap mapElimination = new HashMap();
        for (String targetCompanyId : companys.keySet()) {
            ArrayList<HashMap<String, Object>> list;
            ArrayList<HashMap<String, Object>> list2;
            BigDecimal dbValue;
            List sourceCompanyIds = (List)companys.get(targetCompanyId);
            java.util.Date beginOfYear = begin;
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 FChangeDate from t_csl_investDay");
            sql.append(" where FTargetCompanyId = ?");
            sql.append(" order by FChangeDate asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{targetCompanyId});
            try {
                Date date;
                if (rowSet.next() && (date = rowSet.getDate("FChangeDate")).after(beginOfYear)) {
                    beginOfYear = date;
                }
            }
            catch (SQLException e1) {
                throw new SQLDataException(e1);
            }
            sql = new StringBuffer();
            sql.append("Select FAmount, FDistDate From T_CSL_ProfitDistributeList");
            sql.append(" where FCompanyID = '");
            sql.append(targetCompanyId);
            sql.append("' and FDistDate >= ");
            sql.append(CslRptUtil.formatDateForSql(beginOfYear));
            sql.append(" and FDistDate <= ");
            sql.append(CslRptUtil.formatDateForSql(endOfYear));
            sql.append(" and FCurrencyID = '");
            sql.append(_currencyId);
            sql.append("' order by FDistDate asc");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            BigDecimal dbProfitDist = ZERO;
            BigDecimal dbFewHolder = ZERO;
            HashMap<String, BigDecimal> mapInvest = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> mapFewShare = new HashMap<String, BigDecimal>();
            try {
                while (rowSet.next()) {
                    Date date = rowSet.getDate("FDistDate");
                    BigDecimal dbValue2 = rowSet.getBigDecimal("FAmount");
                    dbProfitDist = dbProfitDist.add(dbValue2);
                    BigDecimal erate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, targetCompanyId, date, mapParams, equialentRate, _currencyId);
                    if (erate == null) {
                        erate = ZERO;
                    }
                    dbFewHolder = dbFewHolder.add(dbValue2.multiply(ONE.subtract(erate)));
                    HashMap investCompanys = new HashMap();
                    if (date.before(endOfYear)) {
                        Map companyAndRate = InvestDayUtilForMainCost.getCompanysOfMainCost(ctx, orgTreeId, orgUnitId, _currencyId, date, true, (String)mapParams.get("longNumber"));
                        Map tmpMap = (Map)companyAndRate.get("ElimType");
                        investCompanys.putAll((Map)tmpMap.get("identityDirect"));
                        investCompanys.putAll((Map)tmpMap.get("identityUnDirect"));
                    } else {
                        investCompanys.putAll(companys);
                        investCompanys.putAll(companys2);
                    }
                    for (int i = 0; i < sourceCompanyIds.size(); ++i) {
                        String sourceCompanyId = (String)sourceCompanyIds.get(i);
                        BigDecimal rate = InvestDayUtilForMainCost.getThisDaySumInvestRate(ctx, sourceCompanyId, targetCompanyId, _currencyId, date);
                        if (rate == null) {
                            rate = ZERO;
                        }
                        BigDecimal dbInvest = ZERO;
                        if (mapInvest.containsKey(sourceCompanyId)) {
                            dbInvest = (BigDecimal)mapInvest.get(sourceCompanyId);
                        }
                        BigDecimal dbTmp = dbValue2.multiply(rate);
                        dbInvest = dbInvest.add(dbTmp);
                        mapInvest.put(sourceCompanyId, dbInvest);
                        if (dbTmp.compareTo(ZERO) == 0) continue;
                        List lstCompany = new ArrayList(0);
                        if (investCompanys.containsKey(sourceCompanyId)) {
                            lstCompany = (List)investCompanys.get(sourceCompanyId);
                        }
                        BigDecimal dbFewShare = ZERO;
                        if (mapFewShare.containsKey(sourceCompanyId)) {
                            dbFewShare = (BigDecimal)mapFewShare.get(sourceCompanyId);
                        }
                        for (int k = 0; lstCompany != null && k < lstCompany.size(); ++k) {
                            String companyId = (String)lstCompany.get(k);
                            erate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, sourceCompanyId + companyId, date, mapParams, equialentRate, _currencyId);
                            if (erate == null || erate.compareTo(ZERO) <= 0) continue;
                            dbFewShare = dbFewShare.add(dbTmp.multiply(ONE.subtract(erate)));
                        }
                        mapFewShare.put(sourceCompanyId, dbFewShare);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            for (String sourceCompanyId : mapInvest.keySet()) {
                dbValue = (BigDecimal)mapInvest.get(sourceCompanyId);
                if (dbValue.compareTo(ZERO) == 0) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", _currencyId);
                data.put("Value", dbValue);
                list2 = new ArrayList<HashMap<String, Object>>(1);
                list2.add(data);
                this.mergeElimination(ctx, mapElimination, list2, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
            }
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
            for (String sourceCompanyId : mapFewShare.keySet()) {
                dbValue = (BigDecimal)mapFewShare.get(sourceCompanyId);
                if (dbValue.compareTo(ZERO) == 0) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", _currencyId);
                data.put("Value", dbValue);
                list2 = new ArrayList(1);
                list2.add(data);
                this.mergeElimination(ctx, mapElimination, list2, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
            }
            if (dbFewHolder.compareTo(ZERO) != 0) {
                HashMap<String, Object> mapFh = new HashMap<String, Object>(4);
                mapFh.put("KEY_CURRENCY_ID", _currencyId);
                mapFh.put("Value", dbFewHolder);
                list = new ArrayList<HashMap<String, Object>>(1);
                list.add(mapFh);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                this.mergeElimination(ctx, mapElimination, list, null, targetCompanyId, templetEntry, summary, mapParams);
            }
            if (dbProfitDist.compareTo(ZERO) != 0) {
                HashMap<String, Object> mapPt = new HashMap<String, Object>(4);
                mapPt.put("KEY_CURRENCY_ID", _currencyId);
                mapPt.put("Value", dbProfitDist);
                list = new ArrayList(1);
                list.add(mapPt);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                this.mergeElimination(ctx, mapElimination, list, null, targetCompanyId, templetEntry, summary, mapParams);
            }
            if (allInOne) continue;
            lstElimination.addAll(mapElimination.values());
            mapElimination.clear();
        }
        lstElimination.addAll(mapElimination.values());
    }

    protected void createElimForIDOtherRight(Context ctx, Map mapElimination, Map companys, Map mapParams, Map equialentRate, String _currencyId) throws EASBizException, BOSException {
        InvestTempletInfo template = this.getTemplateByType(ctx, 45);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        for (String targetCompanyId : companys.keySet()) {
            List investDayCl = this.getOtherOwnerSum(ctx, targetCompanyId, mapParams, false, equialentRate, _currencyId);
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            investDayCl = this.getTotalOtherOnwerSum(investDayCl);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
        }
    }

    protected void createElimForIDWithdrawal(Context ctx, Map mapElimination, Map companys, Map mapParams, String _currencyId) throws EASBizException, BOSException {
        InvestTempletInfo template = this.getTemplateByType(ctx, 50);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        Map entries = this.getTempletEntriesCach(template);
        for (String targetCompanyId : companys.keySet()) {
            List investDayCl = this.getWithdrawalValue(ctx, targetCompanyId, mapParams, 1, _currencyId);
            InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            investDayCl = this.getWithdrawalValue(ctx, targetCompanyId, mapParams, 2, _currencyId);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            investDayCl = this.getWithdrawalValue(ctx, targetCompanyId, mapParams, 3, _currencyId);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
            investDayCl = this.caclEntryDist(mapElimination, false);
            templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            this.mergeElimination(ctx, mapElimination, investDayCl, null, targetCompanyId, templetEntry, summary, mapParams);
        }
    }

    private List getWithdrawalValue(Context ctx, String companyId, Map mapParams, int type, String _currencyId) throws BOSException {
        int iYear = (Integer)mapParams.get("Year");
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(iYear, 0, 1);
        java.util.Date begin = calendar.getTime();
        java.util.Date end = (java.util.Date)mapParams.get("Day");
        ArrayList result = new ArrayList();
        if (begin.after(end)) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FChangeDate from t_csl_investDay");
        sql.append(" where FTargetCompanyId = ? and fcurrencyid = ?");
        sql.append(" order by FChangeDate asc");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, _currencyId});
        try {
            Date date;
            if (rowSet.next() && (date = rowSet.getDate("FChangeDate")).after(begin)) {
                begin = date;
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        StringBuffer oql = new StringBuffer();
        oql.append("select FAmount from T_CSL_WithdrawalSurplusList");
        oql.append(" where FCurrencyID = '");
        oql.append(_currencyId);
        oql.append("' and FCompanyID = '");
        oql.append(companyId);
        oql.append("' and FWithDrawalDate >= ");
        oql.append(CslRptUtil.formatDateForSql(begin));
        oql.append(" and FWithDrawalDate <= ");
        oql.append(CslRptUtil.formatDateForSql(end));
        oql.append(" and FWithDrawalType = ").append(type);
        rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        try {
            BigDecimal sumValue = ZERO;
            while (rowSet.next()) {
                BigDecimal dbValue = rowSet.getBigDecimal("FAmount");
                if (dbValue == null || dbValue.compareTo(ZERO) == 0) continue;
                sumValue = sumValue.add(dbValue);
            }
            if (sumValue != null && sumValue.compareTo(ZERO) != 0) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", _currencyId);
                data.put("Value", sumValue);
                result.add(data);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    protected void createElimForIUDThisYear(Context ctx, List eliminations, Map companys, Map companys2, Map mapParams, Map equialentRate, String _currencyId, boolean allInOne) throws EASBizException, BOSException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        java.util.Date beginOfYear = RPTDateUtil.getBeginOfYear(iYear);
        java.util.Date endOfYear = (java.util.Date)mapParams.get("Day");
        InvestTempletInfo template = this.getTemplateByType(ctx, 47);
        String summary = template.getSummary();
        String templetId = template.getId().toString();
        HashMap mapElimination = new HashMap();
        Map entries = this.getTempletEntriesCach(template);
        for (String targetCompanyId : companys.keySet()) {
            InvestTempletEntryInfo templetEntry;
            String sourceCompanyId;
            int i;
            List sourceCompanyIds = (List)companys.get(targetCompanyId);
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"179_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            java.util.Date begin = beginOfYear;
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 FChangeDate from t_csl_investDay");
            sql.append(" where FTargetCompanyId = ?");
            sql.append(" order by FChangeDate asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{targetCompanyId});
            try {
                Date date;
                if (rowSet.next() && (date = rowSet.getDate("FChangeDate")).after(begin)) {
                    begin = date;
                }
            }
            catch (SQLException e1) {
                throw new SQLDataException(e1);
            }
            StringBuffer oql = new StringBuffer();
            oql.append("Select FAmount, FDistDate From T_CSL_ProfitDistributeList");
            oql.append(" where fcurrencyid = '");
            oql.append(_currencyId);
            oql.append("' and fcompanyid = '");
            oql.append(targetCompanyId);
            oql.append("'");
            oql.append(" and fdistDate >= ");
            oql.append(CslRptUtil.formatDateForSql(begin));
            oql.append(" and fdistDate <= ");
            oql.append(CslRptUtil.formatDateForSql(endOfYear));
            oql.append(" order by fdistDate");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            HashMap<String, BigDecimal> mapInvest = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> mapFewShare = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> mapDist = new HashMap<String, BigDecimal>();
            try {
                while (rowSet.next()) {
                    Date date = rowSet.getDate("FDistDate");
                    BigDecimal dbValue = rowSet.getBigDecimal("FAmount");
                    HashMap investCompanys = new HashMap();
                    if (date.before(endOfYear)) {
                        Map companyAndRate = InvestDayUtilForMainCost.getCompanysOfMainCost(ctx, orgTreeId, orgUnitId, _currencyId, date, true, (String)mapParams.get("longNumber"));
                        Map tmpMap = (Map)companyAndRate.get("ElimType");
                        investCompanys.putAll((Map)tmpMap.get("identityDirect"));
                        investCompanys.putAll((Map)tmpMap.get("identityUnDirect"));
                    } else {
                        investCompanys.putAll(companys);
                        investCompanys.putAll(companys2);
                    }
                    for (int i2 = 0; i2 < sourceCompanyIds.size(); ++i2) {
                        String sourceCompanyId2 = (String)sourceCompanyIds.get(i2);
                        BigDecimal sumInvestRate = InvestDayUtilForMainCost.getThisDaySumInvestRate(ctx, sourceCompanyId2, targetCompanyId, _currencyId, date);
                        BigDecimal dbInvest = dbValue.multiply(sumInvestRate);
                        BigDecimal dbTmp = ZERO;
                        if (mapInvest.containsKey(sourceCompanyId2)) {
                            dbTmp = (BigDecimal)mapInvest.get(sourceCompanyId2);
                        }
                        dbTmp = dbTmp.add(dbInvest);
                        mapInvest.put(sourceCompanyId2, dbTmp);
                        if (dbInvest.compareTo(ZERO) == 0) continue;
                        List lstCompany = new ArrayList(0);
                        if (investCompanys.containsKey(sourceCompanyId2)) {
                            lstCompany = (List)investCompanys.get(sourceCompanyId2);
                        }
                        BigDecimal dbFewShare = ZERO;
                        dbTmp = ZERO;
                        if (mapFewShare.containsKey(sourceCompanyId2)) {
                            dbTmp = (BigDecimal)mapFewShare.get(sourceCompanyId2);
                        }
                        for (int k = 0; lstCompany != null && k < lstCompany.size(); ++k) {
                            String companyId = (String)lstCompany.get(k);
                            BigDecimal erate = this.getEquialentRate(ctx, orgTreeId, orgUnitId, sourceCompanyId2 + companyId, date, mapParams, equialentRate, _currencyId);
                            if (erate == null || erate.compareTo(ZERO) <= 0) continue;
                            dbFewShare = dbFewShare.add(dbInvest.multiply(ONE.subtract(erate)));
                        }
                        mapFewShare.put(sourceCompanyId2, dbTmp.add(dbFewShare));
                        dbTmp = ZERO;
                        if (mapDist.containsKey(sourceCompanyId2)) {
                            dbTmp = (BigDecimal)mapDist.get(sourceCompanyId2);
                        }
                        dbTmp = dbTmp.add(dbFewShare.subtract(dbInvest));
                        mapDist.put(sourceCompanyId2, dbTmp);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            for (i = 0; i < sourceCompanyIds.size(); ++i) {
                ArrayList<HashMap<String, Object>> list;
                HashMap<String, Object> data;
                sourceCompanyId = (String)sourceCompanyIds.get(i);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                BigDecimal dbValue = (BigDecimal)mapInvest.get(sourceCompanyId);
                if (dbValue != null && dbValue.compareTo(ZERO) != 0) {
                    data = new HashMap<String, Object>(4);
                    data.put("KEY_CURRENCY_ID", _currencyId);
                    data.put("Value", dbValue);
                    list = new ArrayList<HashMap<String, Object>>(1);
                    list.add(data);
                    this.mergeElimination(ctx, mapElimination, list, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                }
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
                dbValue = (BigDecimal)mapFewShare.get(sourceCompanyId);
                if (dbValue != null && dbValue.compareTo(ZERO) != 0) {
                    data = new HashMap(4);
                    data.put("KEY_CURRENCY_ID", _currencyId);
                    data.put("Value", dbValue);
                    list = new ArrayList(1);
                    list.add(data);
                    this.mergeElimination(ctx, mapElimination, list, null, sourceCompanyId, templetEntry, summary, mapParams);
                }
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                dbValue = (BigDecimal)mapDist.get(sourceCompanyId);
                if (dbValue != null && dbValue.compareTo(ZERO) != 0) {
                    data = new HashMap(4);
                    data.put("KEY_CURRENCY_ID", _currencyId);
                    data.put("Value", dbValue);
                    list = new ArrayList(1);
                    list.add(data);
                    this.mergeElimination(ctx, mapElimination, list, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                }
                if (allInOne) continue;
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
            }
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"185_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            for (i = 0; i < sourceCompanyIds.size(); ++i) {
                sourceCompanyId = (String)sourceCompanyIds.get(i);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                List investDayValues = InvestDayUtilForMainCost.getThisYearSumInvestAmount(ctx, sourceCompanyId, targetCompanyId, _currencyId, endOfYear);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                investDayValues = InvestDayUtilForMainCost.getThisYearMinoritySum(ctx, sourceCompanyId, targetCompanyId, _currencyId, endOfYear);
                templetEntry.setDcType(InvestItemDCRuleEnum.CREDIT);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry.setDcType(InvestItemDCRuleEnum.DEBIT);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 6, entries);
                investDayValues = this.caclEntryDist(mapElimination, true);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                if (allInOne) continue;
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
            }
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"181_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            InvestTempletEntryInfo templetEntry2 = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
            List investDayValues = this.getThisYearFewHolderProfitAndLoss(ctx, targetCompanyId, mapParams, true, equialentRate, _currencyId);
            this.mergeElimination(ctx, mapElimination, investDayValues, null, targetCompanyId, templetEntry2, summary, mapParams);
            templetEntry2 = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            this.mergeElimination(ctx, mapElimination, investDayValues, null, targetCompanyId, templetEntry2, summary, mapParams);
            if (!allInOne) {
                eliminations.addAll(mapElimination.values());
                mapElimination.clear();
            }
            if (!allInOne) {
                summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"182_EliminateByMainCostControllerBean", (Locale)ctx.getOriginLocale());
            }
            templetEntry2 = this.getTempletEntryBySeq(ctx, templetId, 5, entries);
            investDayValues = this.getOtherOwnerSum(ctx, targetCompanyId, mapParams, true, equialentRate, _currencyId);
            this.mergeElimination(ctx, mapElimination, investDayValues, null, targetCompanyId, templetEntry2, summary, mapParams);
            templetEntry2 = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
            investDayValues = this.getTotalOtherOnwerSum(investDayValues);
            this.mergeElimination(ctx, mapElimination, investDayValues, null, targetCompanyId, templetEntry2, summary, mapParams);
            if (allInOne) continue;
            eliminations.addAll(mapElimination.values());
            mapElimination.clear();
        }
        eliminations.addAll(mapElimination.values());
    }

    private List getCurrencyIds(Context ctx) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select distinct fcurrencyId from t_csl_investDay";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("fcurrencyId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private BigDecimal getAcctItem(Context ctx, String targetCompanyId, String currencyId, String itemNumber, String orgTreeNumber, int year, int period, int periodType, int dataSource, int dataElement) throws BOSException, EASBizException {
        ItemDataCondition condition = new ItemDataCondition();
        ArrayList<String> lstOrgUnit = new ArrayList<String>();
        lstOrgUnit.add(targetCompanyId);
        condition.setOrgUnit(lstOrgUnit);
        condition.setOrgTreeNumber(orgTreeNumber);
        condition.setTargetCurrency(currencyId);
        condition.setRptYearStart(year);
        condition.setRptYearEnd(year);
        condition.setRptPeriodStart(period);
        condition.setRptPeriodEnd(period);
        condition.setRptPeriodType(periodType);
        condition.setDataSource(dataSource);
        condition.setDataElement(dataElement);
        condition.setCommitStatus(3);
        IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        ArrayList<String> lstItem = new ArrayList<String>();
        lstItem.add(itemNumber);
        condition.setItemList(itemFieldMapped.getHiberMapInfoByItemNumbers(lstItem));
        Map mapValue = ItemDataProviderFactory.getLocalInstance(ctx).getAcctItems(condition);
        if (mapValue != null && mapValue.containsKey(itemNumber)) {
            return (BigDecimal)mapValue.get(itemNumber);
        }
        return null;
    }

    private CoreBaseCollection getPreYearEliminationColByPara(Context ctx, Map mapParams) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelector());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        Integer curYear = (Integer)mapParams.get("Year");
        Integer periodType = (Integer)mapParams.get("PeriodType");
        String unitnumber = ((OrgUnitInfo)mapParams.get("KeyOrgUnit")).getNumber();
        String treenumber = ((OrgTreeInfo)mapParams.get("KeyOrgTree")).getNumber();
        int preYear = curYear - 1;
        int prePeriod = 12;
        if (CslRptUtil.isSupport13Period(ctx)) {
            prePeriod = 13;
        }
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(preYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(prePeriod), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("PeriodType", (Object)periodType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("ElimType", (Object)new Integer(6), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgBound.number", (Object)treenumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)unitnumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CheckedStatus", (Object)new Integer(2), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6");
        view.setFilter(filter);
        IElimination elimination = EliminationFactory.getLocalInstance(ctx);
        return elimination.getCollection(view);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.item"));
        sic.add(new SelectorItemInfo("entries.item.number"));
        sic.add(new SelectorItemInfo("entries.item.name"));
        sic.add(new SelectorItemInfo("entries.company.name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("orgBound.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        return sic;
    }

    private void copyElimFromHistory(CoreBaseCollection eliCol, ArrayList copyList, Map companyAndRate, String currencyId) {
        EliminationInfo eliInfo = null;
        String _currencyId = null;
        boolean result = false;
        Map invstSet = this.FiltInvestCompanyRate(companyAndRate);
        for (int i = 0; i < eliCol.size(); ++i) {
            eliInfo = (EliminationInfo)eliCol.get(i);
            _currencyId = eliInfo.getCurrency().getId().toString();
            if (_currencyId == null || !_currencyId.equals(currencyId) || (result = this.iswillRemoveEliminationEntry(eliInfo, invstSet))) continue;
            copyList.add(eliInfo);
        }
    }

    private Map FiltInvestCompanyRate(Map params) {
        if (params == null) {
            return new HashMap();
        }
        Iterator it = params.keySet().iterator();
        String combineIdKey = null;
        String targetcompany = null;
        HashMap data = null;
        BigDecimal ZERO = CslConstant.BGZERO;
        BigDecimal Rate = null;
        HashMap<String, HashMap> RateEquZero = new HashMap<String, HashMap>();
        HashMap<String, HashMap> RateNotEquZero = new HashMap<String, HashMap>();
        HashMap<String, HashMap> RatefromComapny = new HashMap<String, HashMap>();
        HashMap<String, HashMap<String, HashMap>> investSet = new HashMap<String, HashMap<String, HashMap>>(3);
        while (it.hasNext()) {
            combineIdKey = (String)it.next();
            data = (HashMap)params.get(combineIdKey);
            Rate = (BigDecimal)data.get("rate");
            if (Rate == null) {
                Rate = ZERO;
            }
            if (ZERO.compareTo(Rate) == 0) {
                RateEquZero.put(combineIdKey, data);
                continue;
            }
            if (Rate.compareTo(ZERO) <= 0) continue;
            targetcompany = (String)data.get("targetCompanyId");
            if (targetcompany != null && !targetcompany.equals("")) {
                RateNotEquZero.put(targetcompany, data);
            }
            RatefromComapny.put(combineIdKey, data);
        }
        investSet.put(KEY_FROM_COMPANY_ZERO, RateEquZero);
        investSet.put(KEY_TARGET_COMPANY, RateNotEquZero);
        investSet.put(KEY_FROM_COMPANY, RatefromComapny);
        return investSet;
    }

    private boolean iswillRemoveEliminationEntry(EliminationInfo eliInfo, Map invstSet) {
        EliminationEntryCollection entryCol = eliInfo.getEntries();
        String companyId2 = null;
        ArrayList items = null;
        HashMap<String, ArrayList> companyItemsMap = new HashMap<String, ArrayList>();
        boolean isdelete = false;
        ArrayList<String> companyIds = new ArrayList<String>();
        if (entryCol != null && entryCol.size() > 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                EliminationEntryInfo item = entryCol.get(i);
                if (item.isIsVisible()) {
                    companyId2 = item.getCompany().getId().toString();
                    if (companyItemsMap.containsKey(companyId2)) {
                        items = (ArrayList)companyItemsMap.get(companyId2);
                        items.add(item);
                        companyItemsMap.put(companyId2, items);
                        continue;
                    }
                    items = new ArrayList();
                    items.add(item);
                    companyItemsMap.put(companyId2, items);
                    continue;
                }
                entryCol.remove(item);
            }
            for (String companyId2 : companyItemsMap.keySet()) {
                companyIds.add(companyId2);
            }
            isdelete = this.isRemoveed(companyItemsMap, companyIds, invstSet);
        }
        return isdelete;
    }

    private boolean isRemoveed(Map companyItemsMap, List companyArray, Map invstSet) {
        Map data = null;
        String targetcompany = null;
        String fromcompany = null;
        Map RateEquZero = (Map)invstSet.get(KEY_FROM_COMPANY_ZERO);
        Map RateNotEquZero = (Map)invstSet.get(KEY_TARGET_COMPANY);
        Map RatefromCompany = (Map)invstSet.get(KEY_FROM_COMPANY);
        if (companyArray.size() == 2) {
            String combineStr1 = (String)companyArray.get(0) + (String)companyArray.get(1);
            String combineStr2 = (String)companyArray.get(1) + (String)companyArray.get(0);
            if (RateEquZero.containsKey(combineStr1) || RateEquZero.containsKey(combineStr2) ? companyItemsMap.containsKey(targetcompany = (String)(data = (Map)RateEquZero.get(combineStr1) != null ? (Map)RateEquZero.get(combineStr1) : (Map)RateEquZero.get(combineStr2)).get("targetCompanyId")) : !RatefromCompany.containsKey(combineStr1) && !RatefromCompany.containsKey(combineStr2)) {
                return true;
            }
        } else if (companyArray.size() == 1 && !RateNotEquZero.containsKey(fromcompany = (String)companyArray.get(0))) {
            return true;
        }
        return false;
    }

    private void copyHistoryAutoGenElimination(Context ctx, ArrayList ElimList, Map params, String[] numbers, int index) throws BOSException, EASBizException {
        int periodType = (Integer)params.get("PeriodType");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        int iElimType = (Integer)params.get("ElimType");
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        OrgTreeInfo treeInfo = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo unitInfo = (OrgUnitInfo)params.get("KeyOrgUnit");
        String currentNumber = null;
        EliminationInfo newInfo = null;
        EliminationEntryInfo entryInfo = null;
        RPTItemInfo unAllotGainYearItem = null;
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"Summary", (Locale)ctx.getOriginLocale());
        IRPTItem iItem = RPTItemFactory.getLocalInstance(ctx);
        if (ElimList != null && ElimList.size() > 0) {
            int i;
            HashMap<String, RPTItemInfo> itemLst = new HashMap<String, RPTItemInfo>();
            StringBuffer itemsql = new StringBuffer("select * where id in (");
            boolean isQuery = false;
            for (int i2 = 0; i2 < ElimList.size(); ++i2) {
                newInfo = (EliminationInfo)ElimList.get(i2);
                if (i2 > 0) {
                    itemsql.append(",");
                }
                for (int k = 0; k < newInfo.getEntries().size(); ++k) {
                    entryInfo = newInfo.getEntries().get(k);
                    if (k > 0) {
                        itemsql.append(",");
                    }
                    itemsql.append("'").append(entryInfo.getItem().getId()).append("'");
                    isQuery = true;
                }
            }
            itemsql.append(")");
            if (isQuery) {
                RPTItemCollection items = iItem.getRPTItemCollection(itemsql.toString());
                int s = items.size();
                for (i = 0; i < s; ++i) {
                    RPTItemInfo item = items.get(i);
                    itemLst.put(item.getId().toString(), item);
                }
            }
            IElimination ielimination = EliminationFactory.getLocalInstance(ctx);
            for (i = 0; i < ElimList.size(); ++i) {
                newInfo = (EliminationInfo)ElimList.get(i);
                currentNumber = numbers[index + i];
                for (int k = 0; k < newInfo.getEntries().size(); ++k) {
                    RPTItemInfo itemInfo;
                    entryInfo = newInfo.getEntries().get(k);
                    entryInfo.setId(null);
                    if (entryInfo.isIsVisible()) {
                        entryInfo.setSummary(summary);
                    }
                    if ((itemInfo = (RPTItemInfo)itemLst.get(entryInfo.getItem().getId().toString())) == null || !itemInfo.isIsProfitAndLosses() || entryInfo.getDataElement() != 3) continue;
                    if (unAllotGainYearItem == null) {
                        unAllotGainYearItem = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.UNALLOTGAIN_SYEAR, params);
                    }
                    entryInfo.setItem(unAllotGainYearItem);
                }
                newInfo.setTempletID(COST_MAIN_TEMPLATEID);
                newInfo.setYear(year);
                newInfo.setPeriod(period);
                newInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                newInfo.setAuditDate(null);
                newInfo.setAuditor(null);
                newInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                newInfo.setIsCitedByLater(IsCitedByLaterEnum.ISTRUE);
                newInfo.setOrgBound(treeInfo);
                newInfo.setOrgUnit(unitInfo);
                newInfo.setCreator(user);
                newInfo.setCreateTime(time);
                newInfo.setNumber(currentNumber);
                newInfo.setId(null);
                newInfo.setElimType(ElimTypeEnum.getEnum(iElimType));
                newInfo.setDate(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
                ielimination.addnew((CoreBaseInfo)newInfo);
            }
        }
    }
}

