/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.InvestNewAdjustElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractEliminateByMainInvestFacadeControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.EliminateUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.FormulaUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.ClearCompanyItemInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EliminateByMainInvestFacadeControllerBean
extends AbstractEliminateByMainInvestFacadeControllerBean {
    private static final long serialVersionUID = -4050242876052670160L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.EliminateByMainInvestFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _createElimRecords(Context ctx, Map mapParams) throws BOSException, EASBizException {
        this.autoCopyElimInvestRatePrePeriod(ctx, mapParams);
        Map<String, ClearCompanyItemInfo> clearCompanysMap = this.getClearCompanys(ctx, mapParams);
        mapParams.put("clearCompanysMap", clearCompanysMap);
        List formulas = null;
        try {
            CslRptUtil.initNationMapCatch(ctx);
            formulas = this.getFormulas(ctx, mapParams);
        }
        finally {
            CslRptUtil.clearNationmapCatch(ctx);
        }
        long time = System.currentTimeMillis();
        Map elimInvestRates = this.getElimInvestRates(ctx, mapParams);
        logger.info((Object)("getElimInvestRates:" + (System.currentTimeMillis() - time) + "ms"));
        Map values = this.getValues(ctx, mapParams, formulas);
        mapParams.put("values", values);
        mapParams.put("elimInvestRates", elimInvestRates);
        time = System.currentTimeMillis();
        mapParams.put("InvestNewType", InvestNewAdjustElimTypeEnum.INVEST_ADJUST);
        mapParams.put("existsRecordKey", this.getCreatedInvestElimRecordKeys(ctx, mapParams));
        CoreBaseCollection adjustCol = EliminateUtil.getEliminations(ctx, mapParams);
        logger.info((Object)("getEliminations1:" + (System.currentTimeMillis() - time) + "ms"));
        time = System.currentTimeMillis();
        Result result = EliminationFactory.getLocalInstance(ctx).addnew(adjustCol);
        if (mapParams.get("createIds") != null) {
            HashSet<String> createIds = new HashSet<String>();
            for (int i = 0; i < result.size(); ++i) {
                createIds.add(result.getLineResult(i).getPk().toString());
            }
            mapParams.put("createIds", createIds);
        }
        if (result != null && result.size() > 0) {
            if (result.getLineResult(0).getException() instanceof AdjustException && ((AdjustException)((Object)result.getLineResult(0).getException())).getSubCode().equals(AdjustException.UN_EXIST_UNSHARED_RPTITEM.getCode())) {
                throw new EASBizException(new NumericExceptionSubItem("1", result.getLineResult(0).getException().getMessage()));
            }
            if (result.getLineResult(0).getException() != null) {
                throw new BOSException((Throwable)result.getLineResult(0).getException());
            }
        }
    }

    private boolean isSelectAdjustTemplet(Context ctx, Map mapParams) throws EASBizException, BOSException {
        mapParams.put("KEY_MAININVEST_ADJUST", Boolean.TRUE);
        mapParams.put("KEY_MAININVEST_ELIMI", null);
        Map elimInvestRates = this.getElimInvestRates(ctx, mapParams);
        return elimInvestRates.size() > 0;
    }

    private List getFormulas(Context ctx, Map<Object, Object> mapParams) throws BOSException, EASBizException {
        OrgTreeInfo orgTree = (OrgTreeInfo)mapParams.get("KeyOrgTree");
        CurrencyInfo sourceCurrency = (CurrencyInfo)mapParams.get("KEY_SOURCECURRENCY");
        CurrencyInfo currency = (CurrencyInfo)mapParams.get("KEY_CURRENCY");
        long time = System.currentTimeMillis();
        IRowSet templatesRS = this.getTemplates(ctx, mapParams);
        logger.info((Object)("getTemplates:" + (System.currentTimeMillis() - time) + "ms"));
        ArrayList<Object> formulas = new ArrayList<Object>();
        HashMap<Object, Object> tempInvestFormulas = new HashMap<Object, Object>();
        Map clearCompanysMap = (Map)mapParams.get("clearCompanysMap");
        try {
            while (templatesRS.next()) {
                Expression stmt;
                String clearCompanyId;
                HashMap<String, Object> params = new HashMap<String, Object>(32);
                params.put("KeyOrgTree", orgTree.getNumber());
                int type = templatesRS.getInt("FCompanyType");
                String investtempletentryid = templatesRS.getString("finvesttempletentryid");
                String srcCompany = templatesRS.getString("fcompany");
                String tarCompany = templatesRS.getString("ftargetcompany");
                String srcCompanyID = templatesRS.getString("fcompanyid");
                String tarCompanyID = templatesRS.getString("ftargetcompanyid");
                String finvestNewType = templatesRS.getString("finvestNewType");
                String company = type == 1 ? srcCompany : tarCompany;
                params.put("SRCCOMPANY", srcCompany);
                params.put("TARCOMPANY", tarCompany);
                params.put("KEY_COMPANY_ID", srcCompanyID);
                params.put("KEY_TARGETCOMPANY_ID", tarCompanyID);
                params.put("KEY_COMPANY", company);
                params.put("KEY_SOURCECURRENCY", sourceCurrency.getNumber());
                params.put("KEY_CURRENCY", currency.getNumber());
                params.put("Day", RPTDateUtil.formateDate((java.util.Date)mapParams.get("Day"), null).toString());
                params.put("CUR_Period", mapParams.get("Period"));
                params.put("AdjustElimType", finvestNewType);
                params.put("isNew", true);
                params.put("KEY_CONTEXT", ctx);
                params.put("KEY_INVEST_COMPANYTYPE", new Integer(type));
                params.put("KeyOrgUnit", ((OrgUnitInfo)mapParams.get("KeyOrgUnit")).getNumber());
                int dc = templatesRS.getInt("fdctype");
                String formula = dc == 1 ? templatesRS.getString("fdebitformula") : templatesRS.getString("fcreditformula");
                String string = clearCompanyId = type == 1 ? srcCompanyID : tarCompanyID;
                if (clearCompanysMap.containsKey(clearCompanyId)) {
                    ClearCompanyItemInfo clearCompanyItemInfo = (ClearCompanyItemInfo)clearCompanysMap.get(clearCompanyId);
                    params.put("Year", clearCompanyItemInfo.getYear());
                    params.put("Period", clearCompanyItemInfo.getPeriod());
                    params.put("KEY_ORGTREE_INFO", clearCompanyItemInfo.getTreeInfo());
                    params.put("KEY_IS_CLEARCOMPANY", true);
                    OrgTreeInfo orgBound = clearCompanyItemInfo.getTreeInfo();
                    PeriodCollection periods = null;
                    boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(ctx);
                    if (isMergeByFiscalPeriod) {
                        periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgBound);
                    }
                    java.util.Date periodLastDate = this.getPeriodLastDate(ctx, orgBound, periods, clearCompanyItemInfo.getYear(), clearCompanyItemInfo.getPeriod(), RptPeriodTypeEnum.MONTHLY, isMergeByFiscalPeriod);
                    params.put("Day", RPTDateUtil.formateDate(periodLastDate, "yyyy-MM-dd"));
                } else {
                    params.put("Year", mapParams.get("Year"));
                    params.put("Period", mapParams.get("Period"));
                    params.put("KEY_ORGTREE_INFO", orgTree);
                }
                try {
                    stmt = ExcelFormulaPaserHelper.parse((String)formula);
                }
                catch (Exception e) {
                    throw new EASBizException(new NumericExceptionSubItem("genElimFormulaError", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"125_CheckFormulaControllerBean", (Locale)ctx.getOriginLocale()) + "\n" + formula + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"126_CheckFormulaControllerBean", (Locale)ctx.getOriginLocale())));
                }
                stmt = FormulaUtil.fillFormulas(stmt, params);
                if (stmt.toString().indexOf("ESP") >= 0 && stmt.toString().indexOf("ACCTITEM") >= 0 && (templatesRS.getInt("fdataelement") == 3 || templatesRS.getInt("fdataelement") == 4) && this.isSubsection(stmt)) {
                    params.put("DataElement", templatesRS.getInt("fdataelement") == 3 ? "YTDAMOUNT" : "ENDBALANCE");
                    Object[] stmtTemp = new Object[]{stmt, params};
                    tempInvestFormulas.put(srcCompanyID + tarCompanyID + investtempletentryid, stmtTemp);
                }
                formula = stmt.toString();
                String[] arrformula = new String[]{srcCompanyID + tarCompanyID + investtempletentryid, formula};
                formulas.add(arrformula);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.constructsSubsectionFormula(ctx, formulas, tempInvestFormulas, mapParams);
        return formulas;
    }

    private Map<String, ClearCompanyItemInfo> getClearCompanys(Context ctx, Map mapParams) throws EASBizException, BOSException {
        HashMap params = new HashMap();
        params.put("year", mapParams.get("Year"));
        params.put("period", mapParams.get("Period"));
        params.put("periodType", 3);
        params.put("orgTreeInfo", mapParams.get("KeyOrgTree"));
        params.put("orgUnitInfo", mapParams.get("KeyOrgUnit"));
        Map clearCompMap = ElimInvestRateFactory.getLocalInstance(ctx).getClearingCompanyInfors(params);
        List clearCompanys = clearCompMap.get("clearCompList") == null ? new ArrayList(0) : (List)clearCompMap.get("clearCompList");
        HashMap<String, ClearCompanyItemInfo> clearCompanysMap = new HashMap<String, ClearCompanyItemInfo>(clearCompanys.size());
        for (ClearCompanyItemInfo companyItemInfo : clearCompanys) {
            clearCompanysMap.put(companyItemInfo.getClearCompany().getId().toString(), companyItemInfo);
        }
        return clearCompanysMap;
    }

    private boolean isSubsection(Expression stmt) {
        if (stmt instanceof BinaryOperationExpr) {
            Expression formulaLeftExpr = ((BinaryOperationExpr)stmt).left;
            Expression formulaRightExpr = ((BinaryOperationExpr)stmt).right;
            String inst = "1-ESP";
            if (formulaLeftExpr instanceof BinaryOperationExpr) {
                return formulaLeftExpr.toString().startsWith(inst);
            }
            if (formulaRightExpr instanceof BinaryOperationExpr) {
                return formulaRightExpr.toString().startsWith(inst);
            }
        } else {
            return false;
        }
        return true;
    }

    private void constructsSubsectionFormula(Context ctx, List<Object> formulas, Map<Object, Object> tempInvestFormulas, Map<Object, Object> mapParams) throws EASBizException, BOSException {
        if (tempInvestFormulas == null || tempInvestFormulas.isEmpty()) {
            return;
        }
        int year = (Integer)mapParams.get("Year");
        RptPeriodTypeEnum periodType = RptPeriodTypeEnum.MONTHLY;
        OrgTreeInfo orgBound = (OrgTreeInfo)mapParams.get("KeyOrgTree");
        PeriodCollection periods = null;
        boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(ctx);
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgBound);
        }
        Iterator<Map.Entry<Object, Object>> it = tempInvestFormulas.entrySet().iterator();
        while (it.hasNext()) {
            String[] arrformula;
            java.util.Date periodLastDate;
            Map params;
            int period = (Integer)mapParams.get("Period");
            Map.Entry<Object, Object> entry = it.next();
            String key = (String)entry.getKey();
            Object[] stmtTemp = (Object[])entry.getValue();
            Expression stmt = (Expression)stmtTemp[0];
            int branchType = FormulaUtil.getBranchCalculateType(stmt, params = (Map)stmtTemp[1]);
            if (0 == branchType) continue;
            boolean isAddFirstPeriod = true;
            boolean isClearCompany = params.containsKey("KEY_IS_CLEARCOMPANY") ? (Boolean)params.get("KEY_IS_CLEARCOMPANY") : false;
            for (int k = period = isClearCompany ? (Integer)params.get("Period") : period; k > 1; --k) {
                periodLastDate = this.getPeriodLastDate(ctx, orgBound, periods, year, k, periodType, isMergeByFiscalPeriod);
                params.put("Day", RPTDateUtil.formateDate(periodLastDate, "yyyy-MM-dd"));
                params.put("isNew", false);
                if (k != period) {
                    params.put("Period", new Integer(k));
                    Expression curPeriodFormula = FormulaUtil.fillFormulas(stmt, params);
                    arrformula = new String[]{key, curPeriodFormula.toString()};
                    String formulaEsp = FormulaUtil.getformulaEspStr(curPeriodFormula);
                    if (!"".equals(formulaEsp)) {
                        BigDecimal bvalue;
                        String[] arrformulaEsp = new String[]{key, formulaEsp};
                        ArrayList<String[]> esp = new ArrayList<String[]>();
                        esp.add(arrformulaEsp);
                        Map espMapValue = this.getValues(ctx, mapParams, esp, true);
                        if (espMapValue.get(arrformula[0]) != null && espMapValue.get(arrformula[0]) instanceof BigDecimal && (bvalue = (BigDecimal)espMapValue.get(arrformula[0])) != null && bvalue.compareTo(new BigDecimal("0")) == 0) {
                            isAddFirstPeriod = false;
                            break;
                        }
                    }
                    formulas.add(arrformula);
                }
                params.put("Period", new Integer(k - 1));
                Expression prePeriodFormula = FormulaUtil.fillFormulas(stmt, params);
                String[] arrformula2 = new String[]{key, "-(" + prePeriodFormula.toString() + ")"};
                formulas.add(arrformula2);
            }
            if (period != 1 && 1 == branchType && isAddFirstPeriod) {
                periodLastDate = this.getPeriodLastDate(ctx, orgBound, periods, year, 1, periodType, isMergeByFiscalPeriod);
                params.put("Day", RPTDateUtil.formateDate(periodLastDate, "yyyy-MM-dd"));
                params.put("Period", new Integer(1));
                params.put("isNew", false);
                Expression temp = FormulaUtil.fillFormulas(stmt, params);
                arrformula = new String[]{key, temp.toString()};
                formulas.add(arrformula);
            }
            if (2 != branchType) continue;
            java.util.Date rptDate = this.getPeriodLastDate(ctx, orgBound, periods, year, 1, RptPeriodTypeEnum.MONTHLY, isMergeByFiscalPeriod);
            Map keyDateMap = this.getMinDateFromElimInvestRate(ctx, mapParams, rptDate);
            FormulaUtil.constructFirstPeriodFormula(formulas, keyDateMap, stmt, params, key, year, period, periodType, rptDate);
        }
        tempInvestFormulas.clear();
    }

    private java.util.Date getPeriodLastDate(Context ctx, OrgTreeInfo orgBound, PeriodCollection periods, int year, int period, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod) {
        if (!isMergeByFiscalPeriod || periods == null || periods.isEmpty()) {
            return RPTDateUtil.getPeriodLastDate(year, period, periodType);
        }
        try {
            return FiscalPeriodHelper.getPeriodLastDate(periods, year, period, periodType, isMergeByFiscalPeriod);
        }
        catch (Exception e) {
            logger.error((Object)"getPeriodLastDate_Exception", (Throwable)e);
            return null;
        }
    }

    private Map getValues(Context ctx, Map mapParams, List formulas) throws BOSException, EASBizException {
        return this.getValues(ctx, mapParams, formulas, true);
    }

    private Map getValues(Context ctx, Map mapParams, List formulas, boolean isCheckESP) throws BOSException, EASBizException {
        CslReportInfo info = new CslReportInfo();
        info.setYear((Integer)mapParams.get("Year"));
        info.setPeriod((short)((Integer)mapParams.get("Period")).intValue());
        info.setPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)mapParams.get("PeriodType"))));
        info.setOrgTree((OrgTreeInfo)mapParams.get("KeyOrgTree"));
        info.setSourceCurrency((CurrencyInfo)mapParams.get("KEY_SOURCECURRENCY"));
        info.setCurrency((CurrencyInfo)mapParams.get("KEY_CURRENCY"));
        long time = System.currentTimeMillis();
        Book book = FormulaUtil.initBook(ctx, info);
        FormulaUtil.putFormulaToTable(formulas, book, ctx);
        Map values = FormulaUtil.getResult(book, ctx, (CurrencyInfo)mapParams.get("KEY_CURRENCY"), isCheckESP);
        logger.info((Object)("calculater:" + (System.currentTimeMillis() - time) + "ms"));
        return values;
    }

    @Override
    protected void _delete(Context ctx, Map mapParams) throws BOSException, EASBizException {
        EliminateUtil.delInvestElim(ctx, mapParams);
    }

    @Override
    protected boolean _checkExists(Context ctx, Map mapParams) throws BOSException, EASBizException {
        return EliminateUtil.isHaveInvestElim(ctx, mapParams, false);
    }

    private IRowSet getTemplates(Context ctx, Map mapParams) throws BOSException {
        StringBuffer sql = new StringBuffer(1500);
        sql.append(" select distinct a.finvesttemplate ,d.fid finvesttempletentryid,d.fdctype, \t\n").append(" d.fdebitformula,d.fcreditformula, d.fitemid,d.FCompanyType, \t\t\t\t\n").append(" e.fnumber fcompany, com.fnumber ftargetcompany,e.fid fcompanyid, \t\t\t\n").append(" com.fid ftargetcompanyid,max(b.fdate)fdate,d.fdataelement,c.finvestNewType \n").append(" from T_CSL_ElimInvestRateEntry a \t\t\t\t\t\t\t\t\t\t\t\n").append(" join T_CSL_eliminvestrate b on a.feliminvestrate=b.fid \t\t\t\t\t\n").append(" join t_Csl_Investtemplet c on c.fid=a.finvesttemplate \t\t\t\t\t\t\n").append(" join t_csl_investtempletentry d on d.ftempletid=c.fid \t\t\t\t\t\t\n").append(" join t_org_baseunit e on b.fcompany=e.fid \t\t\t\t\t\t\t\t\t\n").append(" join t_org_baseunit com on b.ftargetcompany=com.fid \t\t\t\t\t\t\n");
        ArrayList<Object> param = new ArrayList<Object>();
        SQLBuilder excludeSQLpart = this.getExcludeAuditRecordSQLBuilder(mapParams);
        sql.append(excludeSQLpart.getSQL());
        param.addAll(Arrays.asList(excludeSQLpart.getParams()));
        sql.append(" where b.forgboundid=? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        param.add(mapParams.get("OrgTreeID"));
        Boolean adjust = (Boolean)mapParams.get("KEY_MAININVEST_ADJUST");
        Boolean elimi = (Boolean)mapParams.get("KEY_MAININVEST_ELIMI");
        if (adjust == null) {
            sql.append(" and c.finvestNewType=? \t\t\t\t\t\t\t\t\t\t\t    \n");
            param.add(new Integer(2));
        }
        if (elimi == null) {
            sql.append(" and c.finvestNewType=? \t\t\t\t\t\t\t\t\t\t\t\t\n");
            param.add(new Integer(1));
        }
        sql.append(" and d.fcompanytype<=2 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" and( d.fdebitformula is not null \t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" or d.fcreditformula is not null )\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" and b.fdate<=?");
        java.util.Date rptDate = (java.util.Date)mapParams.get("Day");
        Date date1 = new Date(rptDate.getTime());
        param.add(date1);
        sql.append(" and b.fyear=?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        param.add(mapParams.get("Year"));
        sql.append(" and b.fperiod=? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        param.add(mapParams.get("Period"));
        sql.append(" and forgunit=? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        param.add(mapParams.get("OrgUnitID"));
        sql.append(" and b.fislatest=1    \t\t\t\t\t\t\t\t\t                    \n");
        sql.append(" and  exiTemp.flagstr is null \n");
        sql.append(" group by a.finvesttemplate,d.fid ,d.fdctype,d.fdebitformula,d.fcreditformula, \t\n");
        sql.append(" d.fitemid,d.FCompanyType,e.fnumber,com.fnumber, e.fid,com.fid,d.fdataelement,c.finvestNewType\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        return rowSet;
    }

    private SQLBuilder getExcludeAuditRecordSQLBuilder(Map mapParams) {
        SQLBuilder builder = new SQLBuilder(500);
        builder.append(" left join ( \n").append(" select 'X' flagstr,tmpl.fid tempId,etr.FItemId itemId,etr.FDataElement DataElement,etr.FInvCompanyId InvCompanyId,etr.FTargetCompanyId TargetCompanyId \n").append(" from t_csl_elimination et \n").append(" join t_csl_eliminationentry etr on et.fid = etr.feliminationid \n").append(" join t_csl_investtemplet tmpl on et.ftempletid = tmpl.fid \n").append(" join t_csl_investtempletentry itr on itr.ftempletId = tmpl.FId \n").append(" where etr.fisvisible = 1 and et.felimtype = 7 and et.FCheckedStatus = 2 \n").append(" and itr.fItemId = etr.FItemId and itr.FDataElement = etr.FDataElement \n").append(" and et.FOrgBoundId = ? ", mapParams.get("OrgTreeID")).append(" and et.FOrgUnit = ? ", mapParams.get("OrgUnitID")).append(" and et.Fyear = ? ", mapParams.get("Year")).append(" and et.Fperiod = ? ", mapParams.get("Period")).append(" and et.FPeriodType = ? ", mapParams.get("PeriodType")).append(" and et.FCurrencyId = ? ", (Object)((CurrencyInfo)mapParams.get("KEY_CURRENCY")).getId().toString()).append(" and et.fsourcecurrencyid = ? ", (Object)((CurrencyInfo)mapParams.get("KEY_SOURCECURRENCY")).getId().toString());
        Boolean adjust = (Boolean)mapParams.get("KEY_MAININVEST_ADJUST");
        Boolean elimi = (Boolean)mapParams.get("KEY_MAININVEST_ELIMI");
        if (adjust == null) {
            builder.append(" and tmpl.finvestNewType=? \n", (Object)new Integer(2));
        }
        if (elimi == null) {
            builder.append(" and tmpl.finvestNewType=? \n", (Object)new Integer(1));
        }
        builder.append(" ) exiTemp ");
        builder.append(" on exiTemp.tempId=c.fid and d.FItemId=exiTemp.itemId and  d.FDataElement=exiTemp.DataElement \n");
        builder.append(" and  exiTemp.InvCompanyId= b.FCompany and exiTemp.TargetCompanyId=b.FTargetCompany");
        return builder;
    }

    private Set<String> getCreatedInvestElimRecordKeys(Context ctx, Map mapParams) throws EASBizException, BOSException {
        HashSet<String> existsRecordKey = new HashSet<String>();
        SQLBuilder builder = new SQLBuilder(500);
        builder.append(" select etr.FInvCompanyId,etr.FTargetCompanyId,itr.fid tentryId from t_csl_elimination et \n").append(" join t_csl_eliminationentry etr on et.fid = etr.feliminationid \n").append(" join t_csl_investtemplet tmpl on et.ftempletid = tmpl.fid \n").append(" join t_csl_investtempletentry itr on itr.ftempletId = tmpl.FId \n").append(" where etr.fisvisible = 1 and et.felimtype = 7 and et.FCheckedStatus = 2 \n").append(" and itr.fItemId = etr.FItemId and itr.FDataElement = etr.FDataElement \n").append(" and et.FOrgBoundId = ? ", mapParams.get("OrgTreeID")).append(" and et.FOrgUnit = ? ", mapParams.get("OrgUnitID")).append(" and et.Fyear = ? ", mapParams.get("Year")).append(" and et.Fperiod = ? ", mapParams.get("Period")).append(" and et.FPeriodType = ? ", mapParams.get("PeriodType")).append(" and et.FCurrencyId = ? ", (Object)((CurrencyInfo)mapParams.get("KEY_CURRENCY")).getId().toString()).append(" and et.fsourcecurrencyid = ? ", (Object)((CurrencyInfo)mapParams.get("KEY_SOURCECURRENCY")).getId().toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        try {
            while (rs.next()) {
                String companyId = rs.getString("FInvCompanyId");
                String targetCompanyId = rs.getString("FTargetCompanyId");
                String tmplEntryId = rs.getString("tentryId");
                existsRecordKey.add(companyId + targetCompanyId + tmplEntryId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return existsRecordKey;
    }

    public Map getElimInvestRates(Context ctx, Map mapParams) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("elimInvestRate.company"));
        sic.add(new SelectorItemInfo("elimInvestRate.targetCompany"));
        sic.add(new SelectorItemInfo("elimInvestRate.date"));
        sic.add(new SelectorItemInfo("investTemplate.fid"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem2 = new SorterItemInfo("elimInvestRate.targetCompany.number");
        sorterItem2.setSortType(SortType.ASCEND);
        SorterItemInfo sorterItem = new SorterItemInfo("investTemplate.number");
        sorterItem.setSortType(SortType.ASCEND);
        SorterItemInfo sorterItem3 = new SorterItemInfo("investTemplate.investNewType");
        sorterItem3.setSortType(SortType.ASCEND);
        sorter.add(sorterItem3);
        sorter.add(sorterItem2);
        sorter.add(sorterItem);
        view.setSorter(sorter);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("elimInvestRate.orgBound.id", mapParams.get("OrgTreeID")));
        java.util.Date date = (java.util.Date)mapParams.get("Day");
        filter.getFilterItems().add(new FilterItemInfo("elimInvestRate.date", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("elimInvestRate.year", mapParams.get("Year")));
        filter.getFilterItems().add(new FilterItemInfo("elimInvestRate.period", mapParams.get("Period")));
        filter.getFilterItems().add(new FilterItemInfo("elimInvestRate.orgUnit", mapParams.get("OrgUnitID")));
        filter.getFilterItems().add(new FilterItemInfo("elimInvestRate.islatest", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("investTemplate.isFreezed", (Object)new Integer(0)));
        view.setFilter(filter);
        Boolean adjust = (Boolean)mapParams.get("KEY_MAININVEST_ADJUST");
        Boolean elimi = (Boolean)mapParams.get("KEY_MAININVEST_ELIMI");
        if (adjust == null) {
            filter.getFilterItems().add(new FilterItemInfo("investTemplate.investNewType", (Object)new Integer(2)));
        }
        if (elimi == null) {
            filter.getFilterItems().add(new FilterItemInfo("investTemplate.investNewType", (Object)new Integer(1)));
        }
        ElimInvestRateEntryCollection col = ElimInvestRateEntryFactory.getLocalInstance(ctx).getElimInvestRateEntryCollection(view);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("investNewType"));
        sic.add(new SelectorItemInfo("summary"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.item"));
        sic.add(new SelectorItemInfo("entries.companyType"));
        sic.add(new SelectorItemInfo("entries.dcType"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.debitFormula"));
        sic.add(new SelectorItemInfo("entries.creditFormula"));
        sic.add(new SelectorItemInfo("entries.dataElement"));
        sic.add(new SelectorItemInfo("entries.summary"));
        sic.add(new SelectorItemInfo("eliminationMode.id"));
        LinkedHashMap templateMap = new LinkedHashMap();
        HashMap<String, java.util.Date> tempMap = new HashMap<String, java.util.Date>();
        for (int i = 0; i < col.size(); ++i) {
            ElimInvestRateEntryInfo info = col.get(i);
            ElimInvestRateInfo rate = info.getElimInvestRate();
            InvestTempletInfo templet = info.getInvestTemplate();
            if (templet == null || templet.getId() == null) continue;
            templet = InvestTempletFactory.getLocalInstance(ctx).getInvestTempletInfo((IObjectPK)new ObjectUuidPK(templet.getId()), sic);
            String key = rate.getCompany().getId().toString() + rate.getTargetCompany().getId().toString();
            if (tempMap.containsKey(key)) {
                if (!rate.getDate().equals(tempMap.get(key))) continue;
                ((List)templateMap.get(rate)).add(templet);
                continue;
            }
            ArrayList<InvestTempletInfo> templateList = new ArrayList<InvestTempletInfo>();
            templateList.add(templet);
            tempMap.put(key, rate.getDate());
            templateMap.put(rate, templateList);
        }
        return templateMap;
    }

    private String getRptItemNumByRptControlVal(Context ctx, RPTItemControlEnum controlEnum) throws BOSException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("select item.Fnumber from t_csl_RptItem item \t\t\t\t\t\n").append(" join t_csl_RptControl c on item.Fcontrol = c.Fcontrol \t\t\t\n").append(" where c.Fcontrol = ? and c.FIsSingle = 1 \t\t\t\t\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(controlEnum.getValue())});
        try {
            if (rowSet.next()) {
                return rowSet.getString("Fnumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return "";
    }

    private Map getMinDateFromElimInvestRate(Context ctx, Map mapParams, java.util.Date rptDate) throws BOSException {
        ArrayList<Object> params = new ArrayList<Object>(5);
        HashMap<String, Date> keyDateMap = new HashMap<String, Date>();
        StringBuffer sql = new StringBuffer(500);
        sql.append(" select rate.FCompany,rate.FTargetCompany,min(rate.FDate) Fdate\t\t\n").append(" from t_csl_ElimInvestRate rate \t\t\t\t\t\t\t\t\t\n").append(" join t_org_BaseUnit com on com.FId = rate.FCompany \t\t\t\t\n").append(" join t_org_BaseUnit targCom on targCom.FId = rate.FTargetCompany \t\n").append(" where \trate.FOrgBoundId = ? and rate.FOrgUnit = ? \t\t\t\t\t\n").append(" and rate.FYear = ? and rate.FPeriod = ? and rate.FDate <= ? \t\t\n").append(" group by rate.FCompany,rate.FTargetCompany \t\t\t\t\t\t\n");
        params.add(mapParams.get("OrgTreeID"));
        params.add(mapParams.get("OrgUnitID"));
        params.add(mapParams.get("Year"));
        params.add(mapParams.get("Period"));
        Date date = new Date(rptDate.getTime());
        params.add(date);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                String companyId = rowSet.getString("FCompany");
                String targetCompanyId = rowSet.getString("FTargetCompany");
                String key = companyId + targetCompanyId;
                keyDateMap.put(key, rowSet.getDate("Fdate"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return keyDateMap;
    }

    private void autoCopyElimInvestRatePrePeriod(Context ctx, Map mapParams) throws BOSException, EASBizException {
        HashMap params = new HashMap(7);
        params.put("reportDate", mapParams.get("Day"));
        params.put("rptYear", mapParams.get("Year"));
        params.put("rptPeriod", mapParams.get("Period"));
        params.put("orgUnit", mapParams.get("KeyOrgUnit"));
        params.put("orgBound", mapParams.get("KeyOrgTree"));
        params.put("rptPeriodType", mapParams.get("PeriodType"));
        int mergeType = 0;
        if (mapParams.containsKey("mergeType")) {
            mergeType = (Integer)mapParams.get("mergeType");
        }
        params.put("MERGETYPE", mergeType);
        try {
            ElimInvestRateFactory.getLocalInstance(ctx).autoCopyElimInvestRatePrePeriod(params);
        }
        catch (BOSException e) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"187_EliminateByMainInvestFacadeControllerBean", (Locale)ctx.getOriginLocale()) + e.getStackTrace()));
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"187_EliminateByMainInvestFacadeControllerBean", (Locale)ctx.getOriginLocale()) + e.getStackTrace()));
            throw e;
        }
    }

    @Override
    protected boolean _existsAdjust(Context ctx, Map mapParams) throws BOSException, EASBizException {
        SQLBuilder sql = this.getAdjustSql(mapParams);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    private SQLBuilder getAdjustSql(Map mapParams) {
        HashSet<String> sourCurrencyIdSet = new HashSet<String>();
        Object sourCurrencyObj = mapParams.get("KEY_SOURCECURRENCY");
        if (sourCurrencyObj instanceof List) {
            List sourCurrencyIdList = (List)sourCurrencyObj;
            for (int i = 0; i < sourCurrencyIdList.size(); ++i) {
                sourCurrencyIdSet.add(((CurrencyInfo)sourCurrencyIdList.get(i)).getId().toString());
            }
        } else {
            sourCurrencyIdSet.add(((CurrencyInfo)sourCurrencyObj).getId().toString());
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append("select top 1 fid, elim.FInvestNewType InvestNewType from t_csl_elimination elim ");
        sql.append(" where elim.forgboundid=? \n", mapParams.get("OrgTreeID"));
        sql.append(" and elim.fyear=? \n", mapParams.get("Year"));
        sql.append(" and elim.fperiod=? \n", mapParams.get("Period"));
        sql.append(" and elim.fperiodtype =? \n", mapParams.get("PeriodType"));
        sql.append(" and  elim.felimtype=");
        sql.append((Object)7);
        sql.append(" and  elim.FInvestNewType=");
        sql.append((Object)1);
        sql.append(" and elim.fsourcecurrencyid in \n", sourCurrencyIdSet);
        sql.append(" and elim.fcurrencyid=? \n", (Object)((CurrencyInfo)mapParams.get("KEY_CURRENCY")).getId().toString());
        sql.append(" and forgUnit = ? \n", mapParams.get("OrgUnitID"));
        return sql;
    }

    @Override
    protected boolean _existsUnAuditedAdjust(Context ctx, Map mapParams) throws BOSException, EASBizException {
        SQLBuilder sql = this.getAdjustSql(mapParams);
        sql.append(" and fcheckedStatus = ?", (Object)new Integer(1));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }
}

