/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CompanyTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.InvestItemDCRuleEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestNewAdjustElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.CslElimUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.InvestDataUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.InvestTempletComp;
import com.kingdee.eas.fi.gr.cslrpt.app.InvestTempletEntrySeq;
import com.kingdee.eas.fi.gr.cslrpt.util.ClearCompanyItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EliminateUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.EliminateUtil");

    private static BigDecimal getDiffValue(BigDecimal diffValue, BigDecimal bdValue, int precision, InvestItemDCRuleEnum dcType) {
        if (bdValue != null) {
            bdValue = bdValue.setScale(precision, 4);
            diffValue = dcType.equals((Object)InvestItemDCRuleEnum.CREDIT) ? diffValue.add(bdValue) : diffValue.subtract(bdValue);
        }
        return diffValue;
    }

    public static CoreBaseCollection getEliminations(Context ctx, Map mapParams) throws BOSException, EASBizException {
        int num = 0;
        Map elimInvestRates = (Map)mapParams.get("elimInvestRates");
        Map values = (Map)mapParams.get("values");
        CoreBaseCollection col = new CoreBaseCollection();
        BigDecimal bdValue = null;
        EliminationInfo elimination = null;
        boolean allInOne = false;
        if (mapParams.get("KEY_MAINCOST_ALLINONE") != null) {
            allInOne = true;
        }
        Map investElim = null;
        mapParams.put("investNewType", 1);
        investElim = EliminateUtil.getInvestElim(ctx, mapParams);
        Set existsRecordKey = (Set)mapParams.get("existsRecordKey");
        existsRecordKey = existsRecordKey == null ? new HashSet(0) : existsRecordKey;
        for (ElimInvestRateInfo rate : elimInvestRates.keySet()) {
            List templateList = (List)elimInvestRates.get(rate);
            FullOrgUnitInfo company = rate.getCompany();
            FullOrgUnitInfo srcCompany = rate.getCompany();
            FullOrgUnitInfo targetCompany = rate.getTargetCompany();
            CurrencyInfo currencyInfo = (CurrencyInfo)mapParams.get("KEY_CURRENCY");
            int precision = currencyInfo.getPrecision();
            mapParams.put("srcCompany", srcCompany.getId().toString());
            mapParams.put("targetCompany", targetCompany.getId().toString());
            if (allInOne) {
                elimination = new EliminationInfo();
            }
            for (int j = 0; j < templateList.size(); ++j) {
                InvestTempletInfo template = (InvestTempletInfo)templateList.get(j);
                InvestTempletEntryCollection entryCol = template.getEntries();
                Object[] arrayEntry = entryCol.toArray();
                Arrays.sort(arrayEntry, new InvestTempletComp());
                mapParams.put("templetId", template.getId().toString());
                mapParams.put("eliminationMode", template.getEliminationMode());
                BigDecimal diffValue = CslConstant.BGZERO;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("autoGen_templateID:" + template.getId() + "\n"));
                    logger.debug((Object)("autoGen_template_InvestNewType:" + (Object)((Object)template.getInvestNewType()) + "\n"));
                }
                mapParams.put("InvestNewType", template.getInvestNewType());
                if (!allInOne) {
                    elimination = new EliminationInfo();
                }
                int size = arrayEntry.length;
                block12: for (int i = 0; i < size; ++i) {
                    RPTItemInfo itemInfo;
                    InvestTempletEntryInfo entryInfo = (InvestTempletEntryInfo)arrayEntry[i];
                    String key = srcCompany.getId().toString() + targetCompany.getId().toString() + entryInfo.getId().toString();
                    if (existsRecordKey.contains(key)) continue;
                    SelectorItemCollection src = new SelectorItemCollection();
                    src.add(new SelectorItemInfo("id"));
                    src.add(new SelectorItemInfo("number"));
                    src.add(new SelectorItemInfo("control"));
                    src.add(new SelectorItemInfo("dc"));
                    if (entryInfo.getItem() == null) continue;
                    try {
                        itemInfo = RPTItemFactory.getLocalInstance(ctx).getRPTItemInfo((IObjectPK)new ObjectUuidPK(entryInfo.getItem()), src);
                    }
                    catch (BOSException e) {
                        continue;
                    }
                    int iFseq = entryInfo.getSeq();
                    mapParams.put("templetEntry", entryInfo);
                    CompanyTypeEnum companyType = entryInfo.getCompanyType();
                    bdValue = null;
                    switch (companyType.getValue()) {
                        case 1: {
                            company = rate.getCompany();
                            bdValue = (BigDecimal)values.get(srcCompany.getId().toString() + targetCompany.getId() + entryInfo.getId().toString());
                            if (bdValue == null && template.getInvestNewType().equals((Object)InvestNewAdjustElimTypeEnum.INVEST_ELIM)) {
                                bdValue = EliminateUtil.getSpecialItemValue(ctx, mapParams, itemInfo, entryInfo, investElim, company, targetCompany);
                            }
                            diffValue = EliminateUtil.getDiffValue(diffValue, bdValue, precision, entryInfo.getDcType());
                            break;
                        }
                        case 2: {
                            company = rate.getTargetCompany();
                            bdValue = (BigDecimal)values.get(srcCompany.getId().toString() + targetCompany.getId() + entryInfo.getId().toString());
                            if (bdValue == null && template.getInvestNewType().equals((Object)InvestNewAdjustElimTypeEnum.INVEST_ELIM)) {
                                bdValue = EliminateUtil.getSpecialItemValue(ctx, mapParams, itemInfo, entryInfo, investElim, company, targetCompany);
                            }
                            diffValue = EliminateUtil.getDiffValue(diffValue, bdValue, precision, entryInfo.getDcType());
                            break;
                        }
                        case 4: {
                            company = rate.getCompany();
                            if (i == size - 2 && (diffValue.signum() <= 0 ? entryInfo.getDcType().equals((Object)InvestItemDCRuleEnum.DEBIT) : entryInfo.getDcType().equals((Object)InvestItemDCRuleEnum.CREDIT))) continue block12;
                            bdValue = entryInfo.getDcType().equals((Object)InvestItemDCRuleEnum.CREDIT) ? diffValue.negate() : diffValue;
                            ++i;
                            break;
                        }
                        case 3: {
                            company = rate.getTargetCompany();
                            try {
                                if (entryInfo.getDcType().equals((Object)InvestItemDCRuleEnum.DEBIT) && entryInfo.getDebitFormula() != null) {
                                    bdValue = new BigDecimal(entryInfo.getDebitFormula());
                                } else if (entryInfo.getCreditFormula() != null) {
                                    bdValue = new BigDecimal(entryInfo.getCreditFormula());
                                }
                            }
                            catch (NumberFormatException e) {
                                bdValue = CslConstant.BGZERO;
                                logger.error((Object)"getCreditFormula_NumberFormatException", (Throwable)e);
                            }
                            diffValue = EliminateUtil.getDiffValue(diffValue, bdValue, precision, entryInfo.getDcType());
                            break;
                        }
                        default: {
                            continue block12;
                        }
                    }
                    if ((bdValue == null || bdValue.compareTo(CslConstant.BGZERO) == 0) && companyType.getValue() != 3) continue;
                    if (template.getInvestNewType().equals((Object)InvestNewAdjustElimTypeEnum.INVEST_ADJUST)) {
                        company = rate.getCompany();
                    }
                    boolean isFind = false;
                    if (allInOne) {
                        int n = elimination.getEntries().size();
                        for (int k = 0; k < n; ++k) {
                            EliminationEntryInfo elimEntryInfo = elimination.getEntries().get(k);
                            if (!elimEntryInfo.getCompany().getId().equals((Object)company.getId()) || !elimEntryInfo.getItem().getId().toString().equals(entryInfo.getItem()) || elimEntryInfo.getDataElement() != entryInfo.getDataElement() || !elimEntryInfo.isIsVisible()) continue;
                            EliminateUtil.setDCValue(entryInfo.getDcType(), bdValue, itemInfo, elimEntryInfo);
                            isFind = true;
                            break;
                        }
                    }
                    if (isFind) continue;
                    elimination.getEntries().add(EliminateUtil.createElimEntryInfo(ctx, entryInfo, itemInfo, company, srcCompany, targetCompany, bdValue, entryInfo.getSummary() == null ? template.getName() : entryInfo.getSummary(), iFseq));
                }
                if (!allInOne && elimination.getEntries().size() > 0) {
                    EliminateUtil.createElimination(ctx, elimination, mapParams, num);
                    ++num;
                    EliminateUtil.sortElimEntry(elimination);
                    col.add((CoreBaseInfo)elimination);
                }
                EliminateUtil.catchAdjustElimData(investElim, elimination);
            }
            if (!allInOne || elimination.getEntries().size() <= 0) continue;
            EliminateUtil.createElimination(ctx, elimination, mapParams, num);
            ++num;
            EliminateUtil.sortElimEntry(elimination);
            col.add((CoreBaseInfo)elimination);
        }
        if (col.size() > 0) {
            EliminationInfo elimInfo = new EliminationInfo();
            elimInfo.setOrgBound((OrgTreeInfo)mapParams.get("KeyOrgTree"));
            elimInfo.setOrgUnit((OrgUnitInfo)mapParams.get("KeyOrgUnit"));
            elimInfo.setYear((Integer)mapParams.get("Year"));
            elimInfo.setPeriod((Integer)mapParams.get("Period"));
            elimInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)mapParams.get("PeriodType"))));
            String[] batchNumbers = CslElimUtil.getBatchBizNumber(ctx, (IObjectValue)elimInfo, col.size());
            if (batchNumbers.length == col.size()) {
                EliminationInfo info = null;
                for (int i = 0; i < col.size(); ++i) {
                    info = (EliminationInfo)col.get(i);
                    info.setNumber(batchNumbers[Integer.valueOf(info.getNumber())]);
                }
            }
        }
        return col;
    }

    private static void catchAdjustElimData(Map investElim, EliminationInfo elimination) {
        if (ElimTypeEnum.Main_Invest_New.equals((Object)elimination.getElimType()) && InvestNewAdjustElimTypeEnum.INVEST_ADJUST.equals((Object)elimination.getInvestNewType())) {
            EliminationEntryCollection enlimiEntries = elimination.getEntries();
            EliminationEntryInfo eliminEntry = null;
            RPTItemControlEnum itemControl = null;
            BigDecimal dvalue = null;
            DebitOrCreditEnum dc = null;
            String key = null;
            for (int i = 0; i < enlimiEntries.size(); ++i) {
                eliminEntry = enlimiEntries.get(i);
                itemControl = eliminEntry.getItem().getControl();
                if ((!RPTItemControlEnum.FUNDED_INVEST.equals((Object)itemControl) || 4 != eliminEntry.getDataElement()) && (!RPTItemControlEnum.INVEST_INCOME.equals((Object)itemControl) || 2 != eliminEntry.getDataElement() && 3 != eliminEntry.getDataElement())) continue;
                dc = eliminEntry.getItem().getDc();
                dvalue = DebitOrCreditEnum.DEBIT.equals((Object)dc) ? (eliminEntry.getDebit() == null ? CslConstant.BGZERO : eliminEntry.getDebit()).subtract(eliminEntry.getCredit() == null ? CslConstant.BGZERO : eliminEntry.getCredit()) : (eliminEntry.getCredit() == null ? CslConstant.BGZERO : eliminEntry.getCredit()).subtract(eliminEntry.getDebit() == null ? CslConstant.BGZERO : eliminEntry.getDebit());
                key = itemControl.getValue() + "*" + eliminEntry.getDataElement() + "*" + eliminEntry.getCompany().getId() + eliminEntry.getTargetCompany().getId();
                if (investElim.containsKey(key)) {
                    dvalue = dvalue.add((BigDecimal)investElim.get(key));
                }
                investElim.put(key, dvalue);
            }
        }
    }

    private static void sortElimEntry(EliminationInfo elimination) {
        if (null == elimination || null == elimination.getEntries()) {
            return;
        }
        Object[] arrayEntry = elimination.getEntries().toArray();
        Arrays.sort(arrayEntry, new InvestTempletEntrySeq());
        elimination.getEntries().clear();
        int iSize = arrayEntry.length;
        for (int i = 0; i < iSize; ++i) {
            elimination.getEntries().add((EliminationEntryInfo)arrayEntry[i]);
        }
    }

    private static BigDecimal getSpecialItemValue(Context ctx, Map mapParams, RPTItemInfo itemInfo, InvestTempletEntryInfo entryInfo, Map investElim, FullOrgUnitInfo company, FullOrgUnitInfo targetCompany) throws EASBizException, BOSException {
        BigDecimal bdValue = null;
        ClearCompanyItemInfo clearCompanyItemInfo = EliminateUtil.getClearCompanyItemInfo(mapParams, targetCompany);
        HashMap<String, Object> origParams = new HashMap<String, Object>();
        EliminateUtil.initParams4QueryUsed(clearCompanyItemInfo, mapParams, origParams, false);
        if (itemInfo.getControl().equals((Object)RPTItemControlEnum.FUNDED_INVEST) && entryInfo.getDataElement() == 4) {
            bdValue = InvestDataUtil.getInvestItemData(ctx, mapParams, entryInfo.getDataElement(), itemInfo.getNumber());
        }
        if (itemInfo.getControl().equals((Object)RPTItemControlEnum.INVEST_INCOME) && (entryInfo.getDataElement() == 2 || entryInfo.getDataElement() == 3)) {
            bdValue = InvestDataUtil.getInvestItemData(ctx, mapParams, entryInfo.getDataElement(), itemInfo.getNumber());
        }
        EliminateUtil.initParams4QueryUsed(clearCompanyItemInfo, mapParams, origParams, true);
        BigDecimal value = (BigDecimal)investElim.get(itemInfo.getControl().getValue() + "*" + entryInfo.getDataElement() + "*" + company.getId() + targetCompany.getId());
        if (bdValue != null && value != null) {
            bdValue = bdValue.add(value);
        }
        return bdValue;
    }

    private static void initParams4QueryUsed(ClearCompanyItemInfo clearCompanyItemInfo, Map mapParams, Map<String, Object> origParams, boolean isRollBack) {
        if (clearCompanyItemInfo == null) {
            return;
        }
        if (!isRollBack) {
            String treeId = (String)mapParams.get("OrgTreeID");
            int year = (Integer)mapParams.get("Year");
            int period = (Integer)mapParams.get("Period");
            int periodType = (Integer)mapParams.get("PeriodType");
            origParams.put("OrgTreeID", treeId);
            origParams.put("Year", year);
            origParams.put("Period", period);
            origParams.put("PeriodType", periodType);
            mapParams.put("OrgTreeID", clearCompanyItemInfo.getTreeInfo().getId().toString());
            mapParams.put("Year", clearCompanyItemInfo.getYear());
            mapParams.put("Period", clearCompanyItemInfo.getPeriod());
            mapParams.put("PeriodType", clearCompanyItemInfo.getPeriodType());
        } else {
            String treeId = (String)origParams.get("OrgTreeID");
            int year = (Integer)origParams.get("Year");
            int period = (Integer)origParams.get("Period");
            int periodType = (Integer)origParams.get("PeriodType");
            mapParams.put("OrgTreeID", treeId);
            mapParams.put("Year", year);
            mapParams.put("Period", period);
            mapParams.put("PeriodType", periodType);
        }
    }

    private static ClearCompanyItemInfo getClearCompanyItemInfo(Map mapParams, FullOrgUnitInfo targetCompany) {
        Map clearCompanysMap = (Map)mapParams.get("clearCompanysMap");
        if (clearCompanysMap != null) {
            return (ClearCompanyItemInfo)clearCompanysMap.get(targetCompany.getId().toString());
        }
        return null;
    }

    private static void createElimination(Context ctx, EliminationInfo elimination, Map mapParams, int num) throws EASBizException, BOSException {
        elimination.setIsCitedByLater(IsCitedByLaterEnum.ISTRUE);
        if (mapParams.get("displayTypeId") != null) {
            String typeid = (String)mapParams.get("displayTypeId");
            BOSUuid id = BOSUuid.read((String)typeid);
            TemplateTypeInfo type = new TemplateTypeInfo();
            type.setId(id);
            elimination.setDisplayTemplateType(type);
        }
        elimination.setNumber(String.valueOf(num));
        elimination.setSourceCurrency((CurrencyInfo)mapParams.get("KEY_SOURCECURRENCY"));
        elimination.setCurrency((CurrencyInfo)mapParams.get("KEY_CURRENCY"));
        elimination.setOrgBound((OrgTreeInfo)mapParams.get("KeyOrgTree"));
        elimination.setOrgUnit((OrgUnitInfo)mapParams.get("KeyOrgUnit"));
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        elimination.setPeriodType(RptPeriodTypeEnum.getEnum((int)iPeriodType));
        int iYear = (Integer)mapParams.get("Year");
        elimination.setYear(iYear);
        int iPeriod = (Integer)mapParams.get("Period");
        elimination.setPeriod(iPeriod);
        elimination.setElimType(ElimTypeEnum.Main_Invest_New);
        InvestNewAdjustElimTypeEnum investNewType = (InvestNewAdjustElimTypeEnum)((Object)mapParams.get("InvestNewType"));
        elimination.setInvestNewType(investNewType);
        Date rptDate = (Date)mapParams.get("Day");
        elimination.setDate(rptDate);
        String templetId = (String)mapParams.get("templetId");
        elimination.setTempletID(templetId);
        EliminationModeInfo eliminationModeInfo = (EliminationModeInfo)mapParams.get("eliminationMode");
        elimination.setEliminationMode(eliminationModeInfo);
    }

    public static boolean isHaveInvestElim(Context ctx, Map mapParams, boolean isCheckAdjust) throws BOSException, EASBizException {
        Set sourCurrencyIdSet = EliminateUtil.getSourCurrencyIdSet(mapParams);
        Boolean adjust = (Boolean)mapParams.get("KEY_MAININVEST_ADJUST");
        SQLBuilder sql = new SQLBuilder();
        sql.append("select fid , elim.FInvestNewType InvestNewType from t_csl_elimination elim ");
        sql.append(" where elim.forgboundid=? \n", mapParams.get("OrgTreeID"));
        sql.append(" and elim.fyear=? \n", mapParams.get("Year"));
        sql.append(" and elim.fperiod=? \n", mapParams.get("Period"));
        sql.append(" and elim.fperiodtype =? \n", mapParams.get("PeriodType"));
        sql.append(" and  elim.felimtype=");
        sql.append((Object)7);
        if (isCheckAdjust) {
            sql.append(" and  elim.FInvestNewType=");
            sql.append((Object)1);
        } else if (adjust == null) {
            sql.append(" and  elim.FInvestNewType=");
            sql.append((Object)2);
        }
        sql.append(" and elim.fsourcecurrencyid in \n", (Collection)sourCurrencyIdSet);
        sql.append(" and elim.fcurrencyid=? \n", (Object)((CurrencyInfo)mapParams.get("KEY_CURRENCY")).getId().toString());
        sql.append(" and forgUnit = ? ", mapParams.get("OrgUnitID"));
        sql.append(" and fcheckedStatus = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    public static boolean delInvestElim(Context ctx, Map mapParams) throws BOSException, EASBizException {
        Set sourCurrencyIdSet = EliminateUtil.getSourCurrencyIdSet(mapParams);
        Boolean adjust = (Boolean)mapParams.get("KEY_MAININVEST_ADJUST");
        IElimination elimination = EliminationFactory.getLocalInstance(ctx);
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        String currencyId = ((CurrencyInfo)mapParams.get("KEY_CURRENCY")).getId().toString();
        int year = (Integer)mapParams.get("Year");
        int period = (Integer)mapParams.get("Period");
        int periodType = (Integer)mapParams.get("PeriodType");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)orgTreeId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)year));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType));
        filter.getFilterItems().add(new FilterItemInfo("elimType", (Object)7));
        if (adjust == null) {
            filter.getFilterItems().add(new FilterItemInfo("investNewType", (Object)2));
        }
        filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)sourCurrencyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)1));
        elimination.delete(filter);
        return true;
    }

    public static Map getInvestElim(Context ctx, Map mapParams) throws BOSException {
        HashMap<String, BigDecimal> investElim = new HashMap<String, BigDecimal>();
        StringBuffer sql = new StringBuffer();
        sql.append("select item.fcontrol,item.fdc,en.fdataelement,en.FCompanyID CompanyID ,en.FTargetCompanyID TargetCompany,sum(FDEBIT) FDEBIT,sum(fcredit) fcredit from t_csl_elimination elim \r\n");
        sql.append(" join t_csl_eliminationentry en on en.feliminationid=elim.fid \r\n");
        sql.append(" join t_csl_rptitem item on en.fitemid=item.fid \r\n");
        sql.append(" where elim.forgboundid=? and elim.fyear=? and elim.fperiod=?  and elim.fperiodtype =? \r\n");
        sql.append(" and  elim.felimtype=");
        sql.append(7);
        if (mapParams.get("investNewType") != null) {
            sql.append(" and  elim.FInvestNewType=");
            sql.append(mapParams.get("investNewType"));
        }
        sql.append("\r\n and elim.fsourcecurrencyid=? and elim.fcurrencyid=? \r\n");
        sql.append(" and forgUnit = ? ");
        sql.append(" and (item.fcontrol= ");
        sql.append(1);
        sql.append(" and en.fdataelement= ");
        sql.append(4);
        sql.append(" or item.fcontrol=  ");
        sql.append(9);
        sql.append(" and (en.fdataelement= ");
        sql.append(2);
        sql.append(" or en.fdataelement= ");
        sql.append(3);
        sql.append("))");
        sql.append(" group by item.fcontrol,item.fdc,en.fdataelement ,en.FCompanyID,en.FTargetCompanyID \r\n");
        Object[] param = new Object[]{mapParams.get("OrgTreeID"), mapParams.get("Year"), mapParams.get("Period"), mapParams.get("PeriodType"), ((CurrencyInfo)mapParams.get("KEY_SOURCECURRENCY")).getId().toString(), ((CurrencyInfo)mapParams.get("KEY_CURRENCY")).getId().toString(), mapParams.get("OrgUnitID")};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rs.next()) {
                int dc;
                BigDecimal cvalue;
                BigDecimal dvalue = rs.getBigDecimal("FDEBIT");
                if (dvalue == null) {
                    dvalue = CslConstant.BGZERO;
                }
                if ((cvalue = rs.getBigDecimal("fcredit")) == null) {
                    cvalue = CslConstant.BGZERO;
                }
                BigDecimal value = (dc = rs.getInt("fdc")) == 1 ? dvalue.subtract(cvalue) : cvalue.subtract(dvalue);
                investElim.put(rs.getString("fcontrol") + "*" + rs.getString("fdataelement") + "*" + rs.getString("CompanyID") + rs.getString("TargetCompany"), value);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return investElim;
    }

    private static void createCodeRule(Context ctx, Map mapParams, EliminationInfo newInfo, int num) throws BOSException, EASBizException {
        EliminationInfo elimInfo = new EliminationInfo();
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)mapParams.get("KeyOrgTree");
        elimInfo.setOrgBound(orgTreeInfo);
        elimInfo.setOrgUnit((OrgUnitInfo)mapParams.get("KeyOrgUnit"));
        elimInfo.setYear((Integer)mapParams.get("Year"));
        elimInfo.setPeriod((Integer)mapParams.get("Period"));
        ICodingRuleManager icodeManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)elimInfo, strOrgID);
        String number = strOrgID != null && hasCodeRule ? icodeManager.getNumber((IObjectValue)elimInfo, strOrgID) : EliminateUtil.getMaxNumber(ctx, mapParams, "T_CSL_Elimination", num);
        newInfo.setNumber(number);
    }

    private static String getMaxNumber(Context ctx, Map mapParams, String tableName, int num) throws BOSException {
        BigDecimal number = new BigDecimal("1");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT Round(Max(to_int(Replace(fnumber,'AUTO_',''))),0) As Fmaxnumber From ");
        sql.append(tableName).append(" a  \r\n");
        sql.append(" WHERE a.fOrgBoundId = ? \r\n");
        sql.append(" and a.fyear = ? \r\n");
        sql.append(" and a.fperiod = ? \r\n");
        sql.append(" and a.fperiodType = ? \r\n");
        sql.append(" and forgUnit = ? ");
        sql.append(" and a.fNumber like N'AUTO\\_%' escape '\\'  \r\n");
        Object[] param = new Object[]{mapParams.get("OrgTreeID"), mapParams.get("Year"), mapParams.get("Period"), mapParams.get("PeriodType"), mapParams.get("OrgUnitID")};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rs.next() && rs.getBigDecimal("Fmaxnumber") != null) {
                number = rs.getBigDecimal("Fmaxnumber").add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        number = number.add(new BigDecimal(num));
        StringBuffer result = new StringBuffer("AUTO_");
        int n = 8 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            result.append("0");
        }
        result.append(number);
        return result.toString();
    }

    public static EliminationEntryInfo createElimEntryInfo(Context ctx, InvestTempletEntryInfo entry, RPTItemInfo itemInfo, FullOrgUnitInfo company, FullOrgUnitInfo InvCompany, FullOrgUnitInfo targetCompany, BigDecimal bdValue, String summary, int iFseq) throws BOSException, EASBizException {
        EliminationEntryInfo elimEntryInfo = new EliminationEntryInfo();
        elimEntryInfo.setCompany(company);
        elimEntryInfo.setTargetCompany(targetCompany);
        elimEntryInfo.setInvCompany(InvCompany);
        EliminateUtil.setDCValue(entry.getDcType(), bdValue, itemInfo, elimEntryInfo);
        elimEntryInfo.setItem(itemInfo);
        elimEntryInfo.setDataElement(entry.getDataElement());
        elimEntryInfo.setSummary(summary);
        elimEntryInfo.setIsVisible(true);
        elimEntryInfo.setSeq(iFseq);
        return elimEntryInfo;
    }

    public Map getItems(Context ctx, List ids) {
        HashMap itemMap = new HashMap();
        return itemMap;
    }

    private static void setDCValue(InvestItemDCRuleEnum dcRule, BigDecimal value, RPTItemInfo item, EliminationEntryInfo elimEntryInfo) {
        value = value != null ? value : CslConstant.BGZERO;
        switch (dcRule.getValue()) {
            case 1: {
                EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
            case 2: {
                EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 5: {
                if (value.compareTo(CslConstant.BGZERO) > 0) {
                    EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                value = value.negate();
                EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 6: {
                if (value.compareTo(CslConstant.BGZERO) > 0) {
                    EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                value = value.negate();
                EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
            case 3: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
            case 4: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 7: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    if (value.compareTo(CslConstant.BGZERO) > 0) {
                        EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                        break;
                    }
                    value = value.negate();
                    EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                if (value.compareTo(CslConstant.BGZERO) > 0) {
                    EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                value = value.negate();
                EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 8: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    if (value.compareTo(CslConstant.BGZERO) > 0) {
                        EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                        break;
                    }
                    value = value.negate();
                    EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                if (value.compareTo(CslConstant.BGZERO) > 0) {
                    EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                value = value.negate();
                EliminateUtil.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
        }
    }

    private static void addDCValue(EliminationEntryInfo elimEntryInfo, BigDecimal bdValue, DebitOrCreditEnum dc) {
        BigDecimal credit;
        if (bdValue == null) {
            return;
        }
        BigDecimal debit = elimEntryInfo.getDebit() != null ? elimEntryInfo.getDebit() : CslConstant.BGZERO;
        BigDecimal bigDecimal = credit = elimEntryInfo.getCredit() != null ? elimEntryInfo.getCredit() : CslConstant.BGZERO;
        if (dc.equals((Object)DebitOrCreditEnum.DEBIT)) {
            debit = debit.add(bdValue);
            credit = null;
        } else {
            credit = credit.add(bdValue);
            debit = null;
        }
        elimEntryInfo.setDebit(debit);
        elimEntryInfo.setCredit(credit);
    }

    private static void addDCValueforDiff(EliminationEntryInfo elimEntryInfo, BigDecimal bdValue, DebitOrCreditEnum dc) {
        BigDecimal credit;
        BigDecimal debit = elimEntryInfo.getDebit() != null ? elimEntryInfo.getDebit() : CslConstant.BGZERO;
        BigDecimal bigDecimal = credit = elimEntryInfo.getCredit() != null ? elimEntryInfo.getCredit() : CslConstant.BGZERO;
        if (dc.equals((Object)DebitOrCreditEnum.DEBIT)) {
            debit = debit.add(bdValue);
        } else {
            credit = credit.add(bdValue);
        }
        BigDecimal diff = debit.subtract(credit);
        if (diff.compareTo(CslConstant.BGZERO) > 0) {
            debit = diff;
            credit = null;
        } else {
            debit = null;
            credit = diff.negate();
        }
        elimEntryInfo.setDebit(debit);
        elimEntryInfo.setCredit(credit);
    }

    public static boolean isNeedRecyleNumber(Context ctx) throws BOSException, EASBizException {
        EliminationInfo info = new EliminationInfo();
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)info, strOrgID);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isUseIntermitNumber = codingRuleManager.isUseIntermitNumber((IObjectValue)info, strOrgID);
        return hasCodeRule && strOrgID != null && isUseIntermitNumber;
    }

    public static void batchRecyleNumber(Context ctx, EliminationInfo info, String[] numbers) throws BOSException, EASBizException {
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        codingRuleManager.recycleBatchNumber((IObjectValue)info, strOrgID, numbers);
    }

    public static Set getSourCurrencyIdSet(Map mapParams) {
        HashSet<String> sourCurrencyIdSet = new HashSet<String>();
        Object sourCurrencyObj = mapParams.get("KEY_SOURCECURRENCY");
        if (sourCurrencyObj instanceof List) {
            List sourCurrencyIdList = (List)sourCurrencyObj;
            for (int i = 0; i < sourCurrencyIdList.size(); ++i) {
                sourCurrencyIdSet.add(((CurrencyInfo)sourCurrencyIdList.get(i)).getId().toString());
            }
        } else {
            sourCurrencyIdSet.add(((CurrencyInfo)sourCurrencyObj).getId().toString());
        }
        return sourCurrencyIdSet;
    }
}

